<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoEventos;
use App\Modules\Natureza51\Repositories\RepoFuncionario;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\NivelHierarquico;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMailUser;
use App\Jobs\SendEmail;

class RepoEnviarEmail extends RepositoryNat51
{
    
    use \App\Core\Traits\ParamTrait;
    
    protected $model_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $repo_func;
            
    function __construct() {
        
        // if(!$this->getModelNameSpace()){
        //     $this->setModelNameSpace($this->getOrcNameSpace());
        // }
        // if($this->isChildren()){
        //     $this->repoOrcNewInstance();
        // }       
        $this->repo_func = new RepoFuncionario();
        parent::__construct();
    }

    public function getRepoFunc(){
        return $this->repo_func;
    }


     /**
     * @author Daniel José Rodrigues da Silva 01/04/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function notifyManagersRelease($lot_id=null, $hierarquia, $ano, $descricao){
       
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Liberação de Orçamento.',
            'view'=>'emails.releaseOrc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
        ];
        foreach ($funcs as $func) {            
            $data_email['nome'] = $func['nome_funcionario'];

            $myJob = new SendEmail($func['email'], $data_email);
            dispatch($myJob);
        }
        return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
    }

    public function notifyManagersReleaseComData($lot_id=null, $hierarquia, $ano, $descricao, $datas_desc){
        
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        
        $data_email = [
            'subject'=>'Liberação de Orçamento.',
            'view'=>'emails.liberarOrcamentoData',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'datas'=>$datas_desc
        ];
        foreach ($funcs as $func) {            
            $data_email['nome'] = $func['nome_funcionario'];
            
            $myJob = new SendEmail($func['email'], $data_email);
            dispatch($myJob);
        }
        return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
    }

    /**
    * @author Daniel José Rodrigues da Silva 02/04/2020
    * @param int $id Pass an área identifier.
    * @param string $model_name_space Pass a string with your model name space. 
    * @param string $field_name Optional Param. Default field name is status.
    * @return array An array with status and mensage about function
    */
   public function notifyManagersSendSystem($lot_id, $hierarquia, $ano, $descricao){
    
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $data_email = [
            'subject'=>'Envio sistêmico do headcount.',
            'view'=>'emails.sendSystem',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
        ];
        foreach ($funcs as $func) {            
            $data_email['nome'] = $func['nome_funcionario'];
            
            $myJob = new SendEmail($func['email'], $data_email);
            dispatch($myJob);
        }
        return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
   }


   /**
   * @author Daniel José Rodrigues da Silva 02/04/2020
   * @param int $id Pass an área identifier.
   * @param string $model_name_space Pass a string with your model name space. 
   * @param string $field_name Optional Param. Default field name is status.
   * @return array An array with status and mensage about function
   */
    public function notifyManagersSendSystemPrevious($lot_id, $hierarquia, $ano, $descricao, $daysToFill){       
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $data_email = [
            'subject'=>'Período para preenchimento e envio de headcount.',
            'view'=>'emails.sendSystemPrevious',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'dias'=>$daysToFill
        ];
        foreach ($funcs as $func) {            
            $data_email['nome'] = $func['nome_funcionario'];
            
            $myJob = new SendEmail($func['email'], $data_email);
            dispatch($myJob);
        }
        return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
    }


    /**
    * @author Daniel José Rodrigues da Silva 08/04/2020
    * @param int $id Pass an área identifier.
    * @param string $model_name_space Pass a string with your model name space. 
    * @param string $field_name Optional Param. Default field name is status.
    * @return array An array with status and mensage about function
    */
   public function notifyManagersReopened($lot_id, $hierarquia, $ano, $descricao){
       
       $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

       $data_email = [
           'subject'=>'Liberação de Orçamento.',
           'view'=>'emails.reopenOrc',
           'ano'=>$ano,
           'nome_orcamento'=>$descricao,
       ];
       foreach ($funcs as $func) {            
           $data_email['nome'] = $func['nome_funcionario'];
            
           $myJob = new SendEmail($func['email'], $data_email);
           dispatch($myJob);
       }
       return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
   }
   


     /**
     * @author Daniel José Rodrigues da Silva 01/04/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function notifyManagersReleaseBudget($hierarquia, $ano, $descricao){
       
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia);

        $data_email = [
            'subject'=>'Liberação de Orçamento.',
            'view'=>'emails.releaseOrc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
        ];
        foreach ($funcs as $func) {            
            $data_email['nome'] = $func['nome_funcionario'];  

            $myJob = new SendEmail($func['email'], $data_email);
            dispatch($myJob);

        }
        return array('status'=>'success','msg'=>'Usuários notificados com sucesso!');
    }

    public function definirSenha($link, $nome, $email){
       
        $data_email = [
            'subject'=>'Definição de senha.',
            'view'=>'emails.linkDefinirSenha',
            'nome'=>$nome,
            'link'=>$link,
        ];
        // dd($email);
        return Mail::to([$email])->send(new SendMailUser($data_email));
    }



    public function enviaEmailToUserId($user_id, $data){
        $repoUser = new RepoUsuario();
        $user = $repoUser->getModelEntity()->find($user_id);

        if(!$user){
            $this->setError('Usuário não encontrado.');
            return false;
        }

        if(is_null($user->email)){
            $this->setError('Usuário informado não possui email.');
            return false;
        }

        $email = $user->email;

        if(!$this->getParamValue($this->getCodEnviaEmail())){
            $email = 'douglas@insti.com';
        }
        return true;// Mail::to([$email])->send(new SendMailUser($data));
    }

    public function enviaEmail($email, $data, $teste = false){
        if(!$this->getParamValue($this->getCodEnviaEmail()) && !$teste){
            $email = 'matheus@insti.com.br';
            // return true;
        }
        return Mail::to([$email])->send(new SendMailUser($data));
    }
}
