<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoEventos extends RepositoryNat51
{
     protected $model_name_space='App\Modules\Natureza51\Entities\Eventos';
     protected $form_rules=[
          'cdn_event'=>'required|unique:tbl_eventos,cdn_event'
     ];
     protected $rules_msg=[
          'cdn_event.required'=>'O campo Cód. Evento é obrigatório',
          'cdn_event.unique'=>'Cód. Evento já cadastrado'
     ]; 
     public function listarEventos(){
          $data=$this->getModelEntity()->select()->orderBy('des_event')->get()->toArray();
          for($i=0;$i<count($data);$i++){
               $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_event'].' - '.$data[$i]['des_event']));
               $dados[$i]['des_impr_envel'] = $dados[$i]['impr_envel'] == 1 ? 'Sim' : 'Não';
               $dados[$i]['des_tipo_evento'] = $this->getDesTipoEvento($dados[$i]['tipo_evento_id']);
               $dados[$i]['des_ativo'] = $dados[$i]['ativo'] == 1 ? 'Sim' : 'Não';

               $dados[$i]['des_data_ini'] = $this->formataData($dados[$i]['dt_base_admissao_ini']);
               $dados[$i]['des_data_fim'] = $this->formataData($dados[$i]['dt_base_admissao_fim']);
               
               if($dados[$i]['origem_evento'] == 1){
                    $dados[$i]['des_origem_evento'] = 'Contábil';
               }
               else if($dados[$i]['origem_evento'] == ''){
                    $dados[$i]['des_origem_evento'] = '-';
               }
               else{
                    $dados[$i]['des_origem_evento'] = 'Evento';
               }
               $dados[$i]['multiplica_'] = number_format($dados[$i]['multiplica'],6,',','.');
               $dados[$i]['multiplica_'] = formataMonetarioQuatro($dados[$i]['multiplica_']);
          }

          
          
          return $dados;
     }
     public function update(array $data,$id,$attribute="id"){

          $this->form_rules['cdn_event'].=','.$id;
          
          monetarioVirgula($data['multiplica']);
          return parent::update($data,$id,$attribute);
      
     }
     public function getDesTipoEvento($value){
          if($value==null){
               return "-";
          }
          else if($value==1){
               return "Folha";
          }
          else if($value==2){
               return "Encargos";
          }
          else if($value==3){
               return "Hora Extra";
          }
          else if($value==4){
               return "Bônus";
          }
          else if($value==5){
               return "Benefícios";
          }
          else if($value==6){
               return "Periculosidade";
          }
          else{
               return "Hora de transporte";
          }
     } 
     public function formataData($data){
          if($data == null){
               return '';
          }else{
               $ano = substr($data, 0, 4);
               $meses = substr($data, 5, 2);
               $dia = substr($data, 8, 2);
               $data = $dia.'/'.$meses.'/'.$ano;
               return $data;
          }
      }
}

