<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Entities\Fgts;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Usuario;

class RepoFgts extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\Fgts';
    protected $form_rules=[
        'func_id'=>'required',
        'cdn_func'=>'required',
        'dta_base_valor'=>'required',
        'valor'=>'required',
    ]; 
    protected $rules_msg=[
        'func_id.required'=>'Funcionário é um campo obrigatório',
        'cdn_func.required'=>'Matrícula do funcionário é um campo obrigatório',
        'dta_base_valor.required'=>'Data base do valor é um campo obrigatório',
        'valor.required'=>'Valor é um campo obrigatório',
    ]; 


    public function listar(){
        
        $func = $this->getModelEntity()->with('getFunc')->get();
 
        foreach ($func as $funcionario) {
            $funcionario['nome_funcionario']=$funcionario['getFunc']['nome_funcionario'];
            $funcionario['cdn_funcionario']=$funcionario['getFunc']['cdn_funcionario'];
            $funcionario['funcionario']=$funcionario['cdn_funcionario']. ' - '.$funcionario['nome_funcionario'];
            $funcionario['valor_format']=number_format($funcionario['valor'],2, ',','.');
            $funcionario['data_base_formatada']=$this->formataData($funcionario['dta_base_valor']);
            unset($funcionario['getFunc']);
            // $funcionario['description_created_at'] = $funcionario['created_at'] != null ? $this->formataData($funcionario, 'created_at') : '-';
            // $funcionario['description_updated_at'] = $funcionario['updated_at'] != null ? $this->formataData($funcionario, 'updated_at') : '-';
        }
        return $func;



         //$func = $this->getModelEntity()->with('getFunc')->get();
        //  $tbl_func = new Funcionario();
        //  $tbl_usuario = new Usuario();
         
        //  $func = $this->getModelEntity()
        //      ->leftJoin($tbl_func->getTable(), $this->getModelEntity()->getColunaAlias('func_id'), $tbl_func->getColunaAlias('id'))
 
        //      ->leftJoin(
        //          DB::raw("{$tbl_usuario->getTable()} as usuario1"),
        //          DB::raw("usuario1.id"),
        //          DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        //       )
        //       ->leftJoin(
        //          DB::raw("{$tbl_usuario->getTable()} as usuario2"),
        //          $this->getModelEntity()->getColunaAlias('updated_by'),
        //          DB::raw("usuario2.id")
        //       )
        //      ->select(
        //          $tbl_func->getColunaAlias('nome_funcionario'),
        //          $tbl_func->getColunaAlias('cdn_funcionario'),
        //          $this->getModelEntity()->getColunaAlias('id'),
        //          $this->getModelEntity()->getColunaAlias('cdn_func'),
        //          $this->getModelEntity()->getColunaAlias('dta_base_valor'),
        //          $this->getModelEntity()->getColunaAlias('valor'),
        //          $this->getModelEntity()->getColunaAlias('corrigido'),
 
        //          DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
        //          DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
                 
        //          DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
        //          DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        //      )
        //  ->get()->toArray();
         
        //  $dados = [];
        //  for($i = 0; $i < count($func); $i++) {
        //      $func[$i]['nome_funcionario'] = $func[$i]['nome_funcionario'];
        //      $func[$i]['cdn_funcionario'] = $func[$i]['cdn_funcionario'];
        //      $func[$i]['funcionario'] = $func[$i]['cdn_funcionario']. ' - '.$func[$i]['nome_funcionario'];
        //      $func[$i]['valor_format'] = number_format($func[$i]['valor'],2, ',','.');
        //      $func[$i]['data_base_formatada'] = $this->formataData($func[$i]['dta_base_valor']);

    }

    public function create($data){
        //$data['valor'] = convertDec($data['valor']); 
        return parent::create($data);
    }
    public function update(array $data,$id,$attribute="id"){
        monetarioVirgula($data['valor']);
        return parent::updateParent($data,$id,$attribute);
    }
    public function formataData($data){
		if($data == null){
			 return '';
		}else{
			 $ano = substr($data, 0, 4);
			 $meses = substr($data, 5, 2);
			 $dia = substr($data, 8, 2);
			 $data = $dia.'/'.$meses.'/'.$ano;
			 return $data;
		}
	}




}
      
