<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class RepoForecast extends RepoOrcamento
{
    use \App\Core\Traits\ParamTrait;
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
    protected $form_rules = [];
    protected $rules_msg = [];
    
    private $msg;
    public $repo_notify;

    const STATUS_LOT_PENDENTE_DIGITACAO_FCST=9;
    const STATUS_LOT_REABERTO_FCST=10;
    const STATUS_LOT_ENVIADO_FCST=11;
    const STATUS_LOT_CONFERIDO_FCST=12; 
    const STATUS_LOT_CALCULADO_FCST=13;
    const STATUS_LOT_CALCULADO_LIBERADO_FCST=14;
    const STATUS_LOT_APROVADO_FCST=15; 
    const STATUS_LOT_APROVADO_DIRETOR_AREA_FCST=16;

    public $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;

    public function __construct(){
        parent::__construct();
        $this->repo_notify = new RepoNotify();
    }

    public function listarOrc(){
        $data_user = $this->getUserFromCurrentGuard();

        $orc = new Orcamento();
        $select = $orc->select()->where([
            [$orc->getColunaAlias('status_orc'), '!=', 12],
            //[$orc->getColunaAlias('status_orc'), '>=', 8],
            [$orc->getColunaAlias('status_orc'), '<=', 10],
            [$orc->getColunaAlias('is_suspended'), '!=', 1]
        ])->orderBy('id','DESC');// 12

        if ($data_user->tipo != 3) {
            $select->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }       
        
        return $select->get()->toArray();
    }
    public function loadLotacoesByPeriodo($orc_id){
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, null, 'F');
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $select = DB::select("
            SELECT
            oc.start_date, oc.end_date,
            olot.*,
            lot.quadro_atual,
            lot.ativo,
            lot.unid_lotac,
            lot.des_unid_lotac,
            cc.cod_ccusto,
            cc.des_ccusto, 
            concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as description,
            
            case olot.status
            when '1' then 'Pendente'
            when '2' then 'Em Andamento'
            when '3' then 'Enviado'
            when '4' then 'Reaberto'
            when '5' then 'Conferido'
            when '6' then 'Liberado'
            when '7' then 'Finalizado'
            when '8' then 'Aprovado'
            when '9' then 'Em Execução'
            when '10' then 'Enviado Sistema'
            else cast(olot.status as varchar) end as status_label
            
            FROM [tbl_orc_cronograma] as oc
            
            inner join tbl_activities as ac on ac.id = oc.activity_id
            inner join tbl_orc_lotacao as olot on olot.id = oc.orc_lotacao_id
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            
            where oc.orcamento_id = $orc_id and lot.id in ($lotacoes_string) and
            oc.start_date <= GETDATE() and
            oc.end_date >= GETDATE() and
            orc_lotacao_id is not null and
            ac.[description] like('%orecast%')"
        );
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            $dados[$i]['start_date_'] = formataData($dados[$i]['start_date']);
            $dados[$i]['end_date_'] = formataData($dados[$i]['end_date']);
            $dados[$i]['description'] = $dados[$i]['description'].' - '.$dados[$i]['start_date_'].' - '.$dados[$i]['end_date_'];
        }
        return $dados;
    }

    public function createForecast($data){ 
        $repo_orc = $this->getOrcInstanceNew();
        $repo_lot = new RepoOrcLotacao();
        
        if($this->canCRUDForecast($data['lotacao_id'], $data['orc_id'], $data['periodo'], 'F') === false){
            $retorno = array('status'=>'error', 'msg'=>'Impossível fazer operação. A lotação foi enviada. Erro: 031220201109');
            goto saida;
        }
        $orc = $repo_orc->find($this->extractOrcamentoIdFromData($data, 'orc_id'));
        
        if(!$orc){
            $retorno = array('status'=>'error','msg'=>'Orçamento não encontrado. Erro 040920201413.');
            goto saida;
        }

        if($orc->status_orc != $this->getStatusEmExecucao() && $orc->status_orc != $this->getStatusLiberado() && $orc->status_orc != $this->getStatusAprovado()){
            $retorno = array('status'=>'error','msg'=>'Operação indisponível. Libere o orçamento para continuar. Erro 040920201413.');
            goto saida;
        }

        $lot_movto = $this->getStatusMovtoByLotacao($data['lotacao_id'], $data['periodo']);//$repo_lot->find($data['lotacao_id']);
        $lotacao = $repo_lot->find($data['lotacao_id']);

        if( ($lotacao->status == self::STATUS_LOT_PENDENTE_DIGITACAO_FCST || $lotacao->status == self::STATUS_LOT_REABERTO_FCST) || ($lot_movto->status_atual == self::STATUS_LOT_PENDENTE_DIGITACAO_FCST || $lot_movto->status_atual == self::STATUS_LOT_REABERTO_FCST) ){
            
            $data['orc_cargo_id'] = $this->getOrcCargoByCargo($data['orc_cargo_id'], $data['orc_id'], $data['periodo'], $data['tipo_table']);
            
            $clausule = array(
                'orc_id'=>$data['orc_id'], 
                'lotacao_id'=>$data['lotacao_id'],
                'ccusto_id'=>$data['ccusto_id'],
                'orc_cargo_id'=>$data['orc_cargo_id'],
                'orc_turma_id'=>$data['orc_turma_id'],
                'tipo_table'=>$data['tipo_table'],
                'periodo'=>$data['periodo']
            );
            
            if($this->hasDataOnDB($clausule)){               
                $retorno['status'] = 'warning';
                $retorno['msg'] = 'Falha ao inserir o Registro! Dados já cadastrados.';
                goto saida;
            }
            
            $repo_calc_orcamento = new RepoCalcOrcamento();   

            $meses = ($data['fromMeses']) ? $data['meses_orcado'] : $this->setMesesSameValue($data['quadroAtual']);
            $meses['tbl_origem'] = $this->getModelEntity()->getTable();
            DB::beginTransaction();

            try {

                // OBS: comentei essa parte pois de acordo com a nova modelagem de status das lotações, não existe mais o status Em andamento(inProgress)
                // if($lot->status == $this->getStatusPendente()){
                //     $this->inProgressStatus($lot->id,$repo_lot->getModelNameSpace());
                // }

                if(!($data['fromMeses'])){
                    $data['qtd_func_lot'] = $data['quadroAtual'];
                }
                
                $data = $this->setTotaisHeadcount($data);
                $head = $this->create($data);
                if(!$head){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 0409202014221');
                    goto saida;
                }
                

                $inserted = $this->getModelEntity()->where([
                    ['orc_id', $data['orc_id']],
                    ['lotacao_id', $data['lotacao_id']],
                    ['orc_cargo_id', $data['orc_cargo_id']],
                    ['ccusto_id', $data['ccusto_id']],
                    ['orc_turma_id', $data['orc_turma_id']],
                    ['tipo_table', $data['tipo_table']],
                    ['periodo', $data['periodo']]
                ])->first();

                if(!$inserted){
                    $retorno = array('status'=>'error','msg'=>"registro inserido não encontrado",'submsg'=>'Erro ao inserir o registro. Erro: 190120201719');
                    goto saida;
                }
                
                $meses['origem_id'] = $inserted->id;
                
                if(!$repo_calc_orcamento->create($meses)){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 0409202014222');
                    goto saida;
                }
                //dd($meses, $result);
                /* VER SE ESSA PARTE SERÁ USADA */
                // if(! $this->scriptUpdateForecastOrcadoAnt($data['orc_id'], $data['lotacao_id'], $data['orc_cargo_id'], $data['tipo_table'], $data['periodo']) ){
                //     $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 0409202014223');
                //     goto saida;
                // }
                if( array_key_exists('insere_realizado', $data) && $data['insere_realizado'] == true ){
                    if($this->insereRealizado($data, $meses) === false){
                        $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir realizado. Erro: 170920201653');
                        goto saida;
                    } 
                }               
                /* ============ */
                $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
                goto saida;

            } catch (\Exception $e) {
                DB::rollBack();
                
                abort(500, 'Erro! Falha ao Inserir o Registro. Erro 220920200819b'.$e);
            }

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            goto saida;

    
        
            saida:
            ($retorno['status']=='success')?DB::commit():DB::rollBack();
            return $retorno;
        }else{
            return array('status'=>'error','msg'=>'Operação indisponível. Tente novamente mais tarde. Erro: 220920200819.');
        }
    }
    public function insereRealizado($dados, $meses){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $dados['tipo_table'] = 'R';
        unset($dados['periodo']);
        $select = $this->getModelEntity()->select()
        ->where([
            ['orc_id', $dados['orc_id']], 
            ['lotacao_id', $dados['lotacao_id']],
            ['ccusto_id', $dados['ccusto_id']],
            ['orc_cargo_id', $dados['orc_cargo_id']],
            ['orc_turma_id', $dados['orc_turma_id']],
            ['tipo_table',  $dados['tipo_table']]
        ])->get()->toArray();
        if(count($select) == 0){
            try{

                $realizado = $this->create($dados);
                
                if(!$realizado){
                    return false;
                }
                $meses['origem_id'] = $realizado->id;
                $calc = $repo_calc_orcamento->create($meses);
                if(!$calc){
                    return false;
                }
               
                DB::commit();
                return true;
            }catch(\Exception $e){
                DB::rollBack();
                return false;
            }
        }
        return 0;// não inseriu, mas também não deu erro. Como é algo automatico, não vale a pena parar o processo
    }
    public function putCargoOrc(&$data){
        $cargo = $data['orc_cargo_id'];
        $orc = $data['orc_id'];
        $select = DB::select("select id from tbl_orc_cargo where cargo_id = $cargo and orcamento_id = $orc");
        $data['orc_cargo_id'] = count($select) > 0 ? $select[0]->id : false;
    }
    public function setMesesSameValue($value){
        $array = [
            'jan_orcado'=>$value,
            'fev_orcado'=>$value,
            'mar_orcado'=>$value,
            'abr_orcado'=>$value,
            'mai_orcado'=>$value,
            'jun_orcado'=>$value,
            'jul_orcado'=>$value,
            'ago_orcado'=>$value,
            'set_orcado'=>$value,
            'out_orcado'=>$value,
            'nov_orcado'=>$value,
            'dez_orcado'=>$value,
        ];

        return $array;
    }
    public function setTotaisHeadcount($data){
        $sameCargo = $this->getModelEntity()->where([
            ['orc_id',$data['orc_id']], 
            ['lotacao_id',$data['lotacao_id']],
            ['ccusto_id',$data['ccusto_id']],
            ['orc_cargo_id',$data['orc_cargo_id']],
            ['tipo_table',$data['tipo_table']],
            ['periodo',$data['periodo']]
        ])->first();

        if($sameCargo){
            $data['atual_total'] = $sameCargo['atual_total'];
            $data['forecast_total'] = $sameCargo['forecast_total'];
            return $data;
        }

        $data['forecast_total'] = $this->getForecastAnterior($data['orc_id'], $data['lotacao_id']);
        $data['atual_total'] = $this->getAtualTotal($data['lotacao_id'], $data['orc_cargo_id']);

        return $data;
    }
    public function getForecastAnterior($orc_id, $lotacao_id){
        $tbl_orcamento = new Orcamento();
        $tbl_orc_lot_carg_headcount = $this->getModelEntity();        
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_calc_orcamento = new CalcOrcamento();
        $repo_orcamento = new RepoOrcamento();
        
        $orc_atual = $repo_orcamento->getModelEntity()->find($orc_id);

        if(!$orc_atual){
            return false;
        }

        $ano = $orc_atual->ano;
        
        $forecast_anterior = $tbl_orcamento
        ->leftJoin($tbl_orc_lot_carg_headcount->getTable(),
                    $tbl_orcamento->getColunaAlias('id'), $tbl_orc_lot_carg_headcount->getColunaAlias('orc_id')) 
        ->leftJoin($tbl_orc_lotacao->getTable(),
                    $tbl_orc_lot_carg_headcount->getColunaAlias('lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_calc_orcamento->getTable(), $tbl_orc_lot_carg_headcount->getColunaAlias('id'), '=', 
                    DB::raw("{$tbl_calc_orcamento->getColunaAlias('origem_id')} and 
                    {$tbl_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tbl_orc_lot_carg_headcount->getTable()}'"))

        ->select($tbl_calc_orcamento->getColunaAlias('dez_orcado'))
        ->where([
            [$tbl_orcamento->getColunaAlias('ano'),$ano-1],//Ano anterior
            [$tbl_orcamento->getColunaAlias('status_aprovacao'),$repo_orcamento->getStatusAprovado()],//Aprovado
            [$tbl_orcamento->getColunaAlias('status_orc'),$repo_orcamento->getStatusLiberado()],//Liberado
            [$tbl_orc_lot_carg_headcount->getColunaAlias('tipo_table'),'F'], //Forecast
            [$tbl_orc_lotacao->getColunaAlias('lotacao_id'),$lotacao_id], 
        ])
        ->first();

        if(!$forecast_anterior){
            return 0;
        }

        return $forecast_anterior->toArray()['dez_orcado'];
    }
    public function getAtualTotal($orc_lotacao_id, $orc_cargo_id){
        
        $lot_id = OrcLotacao::find($orc_lotacao_id)->lotacao_id;
        //$cargo_id = OrcCargo::all();//($orc_cargo_id)->cargo_id;
        
        $repo_func = new RepoFuncionario();

        return $repo_func->getQtdeFuncsByLotCarg($lot_id, $orc_cargo_id);
    }
    public function scriptUpdateForecastOrcadoAnt($orc_id, $lotacao_id, $cargo_id, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela ? Erro: 040920201417';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC update_forecast_orcado_anterior :orc_id, :lotacao_id, :cargo_id, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':lotacao_id', $lotacao_id, \PDO::PARAM_INT );
            $stmt->bindParam(':cargo_id', $cargo_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 300720201943 | update_forecast_orcado_anterior';

            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            return false;
        }
        DB::commit();
        return true;    
    }

    public function validaDistribuicao($mes, $periodo, $dados){
        
        $meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];
        $par_id = DB::select("SELECT id from tblg_parametros where cod_parametro = 'TPFORECAST'")[0]->id;
        $dado1 = [];
        $orc_id = array_key_exists('orc_id', $dados) ? $dados['orc_id'] : $dados['orcamento_id'];

        if($mes == 1){
            $dado1 = $this->getValoresJan($orc_id, $dados['lotacao_id'], $periodo, $par_id, $dados['id_princ']);
        }
        // else{
        //     $dado1 = $this->getValoresMes($orc_id, $dados['lotacao_id'], $periodo, $par_id, $meses[$mes]);
        // }
        $dado2 = [];
        if($mes > 1){
            $dado2 = $this->getValoresMeses($mes, $orc_id, $dados['lotacao_id'], $periodo, $dados['id_princ']);
        }
        

        if(count($dado1) > 0){
            foreach($dado1 as $value){
                if($value->valor < 0){
                    return false;
                }
            }
            
        }
        if(count($dado2) > 0){
            for($i = 0; $i < count($dado2); $i++){
                if($dado2[$i]->valor < 0){
                    return true;
                }
            }
        }
        return true;
    }

    public function updateValues($values, $field_update, $mes = null, $periodo = null){
        
        $table = $this->getModelEntity()->getTable();
        $cases = [];
        $ids = [];
        $params = [];
        $cont = count($values);
        //$cont_err = 0;
        
        foreach ($values as $item) {
            // if($item['origem_sistema'] == 0){
                
            $id = (int) $item['id_princ'];
            $cases[] = "WHEN {$id} then ?";
            $params[] = $item[$field_update];
            $ids[] = $id;
            // }
            // else{
                // $this->msg = 'É possível distribuir apenas para os cargos que foram inseridos manualmente.';
                // $cont_err++;
            // }
        }

        // if($cont == $cont_err){
        //     $this->setError($this->msg);
        //     return false;
        // }
        $ids_string = implode(',', $ids);
        $cases = implode(' ', $cases);
        
        // $params[] = Carbon::now()->format('Y-d-m');
        $params[] = $this->fillModificadoEm();
        $params[] = $this->fillModificadoPor();

        if(count($ids) > 1){
            $update = true;
            foreach($ids as $value){
                $update = DB::update("UPDATE tbl_calc_orcamento set updated_at = ?, updated_by = ? where id = ? and tbl_origem = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $value, 'tbl_orc_lot_carg_headcount']);
                $update = DB::update("UPDATE {$table} SET {$field_update} = CASE id {$cases} END, updated_at = ?, updated_by = ? WHERE id = $value", $params);        
            }
            return $update;
        }
        DB::update("UPDATE tbl_calc_orcamento set updated_at = ?, updated_by = ? where id in (?) and tbl_origem = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $ids_string, 'tbl_orc_lot_carg_headcount']);
        return DB::update("UPDATE {$table} SET {$field_update} = CASE id {$cases} END, updated_at = ?, updated_by = ? WHERE id in ({$ids_string})", $params);

        // $result = null;
        // foreach($values as $value){
        //     for ($i = $mes; $i <= 12 ; $i++) { 
        //         $result = $this->validaDistribuicao($i, $periodo, $value);
                
        //         if( $result === false){
        //             $this->setError("Forecast Inicial incorreto. A distribuição dos valores iria assumir um valor negativo. Por favor, verifique as Transferências/Promoções e Demissões");
        //             //DB::rollBack();
        //             return false;
        //         }
        //     }
        // }
    }
    public function getMsg(){
        return $this->msg;
    }
    public function calcHeadcount($orc_id, $lotacao_id, $mes_ini = 1, $periodo){
        $cont = 0;
        $mes_ini = (int) Carbon::parse($periodo)->format('m');
        
        for ($i=$mes_ini; $i<=12 ; $i++) { 
            if(!$this->updateHeadcountMes($i, $orc_id, $lotacao_id, $periodo, $cont)){
                return false;
            }
            $cont++;
        }

        return true;
    }

    public function updateHeadcountMes($mes, $orc_id, $lotacao_id, $periodo, $cont = 0){     
        //$mes = 1;
        $meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];
        
        $par_id = DB::select("SELECT id from tblg_parametros where cod_parametro = 'TPFORECAST'")[0]->id;// 21-54
        
        if(!array_key_exists($mes, $meses)){
            $this->setError("Mês inválido para o cálculo. Erro 040920201525");
            return false;
        }


        $mesAtual = $meses[$mes];

        $calcOrcamento = new CalcOrcamento();
        $tbl_calc_orcamento = $calcOrcamento->getTable();
        $orcLotCargHC = new OrcamLotCargoHeadcount();
        $tbl_orc_carg_hc = $orcLotCargHC->getTable();
        
        
        $values = [];
        if($mes == 1){
            $values = $this->getValoresJan($orc_id, $lotacao_id, $periodo, $par_id);
        }
        else if($cont == 0){
            $values = $this->getValoresMes($orc_id, $lotacao_id, $periodo, $par_id, $meses[$mes], $mes);
        }
        else if($mes > 1){
            $values = $this->getValoresMeses($mes, $orc_id, $lotacao_id, $periodo);
        }
        // dd($values, $mes);

        
        
        if(!$values){
            $this->setError("Não foi possível encontrar o valor dos meses. Erro 040920201525");
            return false;
        }

        $cases = [];
        $ids = [];
        $params = [];

        foreach ($values as $value) {
            $id = (int) $value->lot_id;
            $cases[] = "WHEN {$id} then ?";
            $params[] = $value->valor;
            $ids[] = $id;
        }

        $ids = implode(',', $ids);
        $cases = implode(' ', $cases);
        // $params[] = Carbon::now()->format('Y-m-d H:i:s');
        $params[] = $this->fillModificadoEm();
        $params[] = $this->fillModificadoPor();
        

        return DB::update("UPDATE {$tbl_calc_orcamento} SET {$mesAtual} = CASE origem_id {$cases} END, updated_at = ?, updated_by = ? WHERE origem_id in ({$ids}) and tbl_origem = '{$tbl_orc_carg_hc}'", $params);
        

    }
    public function getValoresJan($orc_id, $lotacao_id, $periodo, $par_id, $id_hd = null){

        $condicao = $id_hd == null ? "" : " and olch.id = $id_hd";
        $tipoTableOrcamento = 'F'; 


        $values = DB::select("SELECT 
                olch.id	as lot_id,
                case op.valor_parametro
                    when 0 then COALESCE(olch.qtd_func_lot, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)
                    when 1 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Forecast dezembro anterior' 
                    when 2 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Importação' 
                end as valor
            FROM [tbl_orcamento]  orc
            left join tbl_orc_parametros op on op.orcamento_id = orc.id and op.parametro_id = {$par_id}
            left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento' and olch.periodo = '{$periodo}'
            left join tbl_orc_headcount_contratacoes ohc on ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id and ohc.periodo = '{$periodo}'
            left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes'
            left join tbl_orc_headcount_demissoes ohdt1 on ohdt1.tipo_table = '$tipoTableOrcamento' and  ohdt1.tipo = 1 and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id and ohdt1.periodo = '{$periodo}'
            left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes'
            left join tbl_orc_headcount_demissoes ohdt2 on ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes=1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id and ohdt2.periodo = '{$periodo}'
            left join tbl_orc_headcount_demissoes ohdt3 on ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes=1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id and ohdt3.periodo = '{$periodo}'
            left join tbl_orc_promocao ope on ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id and ope.periodo = '{$periodo}'
            left join tbl_orc_promocao ops on ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id and ops.periodo = '{$periodo}'
            where olch.lotacao_id = $lotacao_id
                and orc.id = $orc_id".$condicao."
                and olch.tipo_table = '$tipoTableOrcamento' and olch.periodo = '{$periodo}'
            group by olch.id, olch.qtd_func_lot, coc.jan_orcado, cod.jan_orcado, ohdt3.qtde_pessoas, op.valor_parametro, olch.forecast_anterior
        ");

        return $values;
    }

    public function getValoresMeses($mes, $orc_id, $lotacao_id, $periodo, $id_hd = null){
        // $repoOrc = new RepoOrcamento();
        // $tbl_orc_lot_carg_headcount = new OrcamLotCargoHeadcount(); 
        // $calcOrcamento = new CalcOrcamento();
        // $tbl_calc_orcamento = $calcOrcamento->getTable();
        // $orcLotCargHC = new OrcamLotCargoHeadcount();
        // $tbl_orc_carg_hc = $orcLotCargHC->getTable();
        // $tbl_orc_lot_carg_headcount = new OrcamLotCargoHeadcount(); 
        // $tb_orcam_headcount_contratacoes = new OrcHeadcountContratacoes();        
        // $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();     
        // $tbl_orc_promocao = new OrcPromocao(); 
        $condicao = $id_hd == null ? "" : " and olch.id = $id_hd";
        
        $meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];
        // AQUI DEVE HAVER UMA VALIDAÇÃO, POIS PODE SER QUE O MES SEJA 1, QUE SERÁ 0 MAS NÃO EXISTE

        $mesAnt = $meses[$mes-1];
        $mesAtual = $meses[$mes];

        $tipoTableOrcamento = 'F';

        $values = DB::select("SELECT 
                 olch.id as lot_id,             
                (COALESCE(co.$mesAnt, 0)
                - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = '$tipoTableOrcamento' and ohdt3.periodo = '{$periodo}' and  ohdt3.tipo = 3 and ohdt3.mes = $mes and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0)
                - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = '$tipoTableOrcamento' and ohdt2.periodo = '{$periodo}' and  ohdt2.tipo = 2 and ohdt2.mes = $mes and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) 
                + COALESCE((select SUM(coc.$mesAtual) from tbl_orc_headcount_contratacoes ohc left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = '$tipoTableOrcamento' and ohc.periodo = '{$periodo}' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) 
                - COALESCE((select SUM(cod.$mesAtual) from tbl_orc_headcount_demissoes ohdt1 left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = '$tipoTableOrcamento' and ohdt1.periodo = '{$periodo}' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) 
                + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = '$tipoTableOrcamento' and ope.periodo = '{$periodo}' and ope.mes_promocao=$mes and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0) 
                - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = '$tipoTableOrcamento' and ops.periodo = '{$periodo}' and ops.mes_promocao=$mes and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)) as valor
            FROM [tbl_orcamento]  orc
            left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
            left join tbl_calc_orcamento co on co.origem_id = olch.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
            where (olch.lotacao_id = $lotacao_id)
            and orc.id = $orc_id
            and olch.tipo_table = '$tipoTableOrcamento'
            and olch.periodo = '{$periodo}'
        ");

        // $values = DB::select("SELECT 
        //         olch.id	as lot_id,
        //         COALESCE(co.$mesAnt, 0) + COALESCE(coc.$mesAtual, 0) - COALESCE(cod.$mesAtual, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id) as valor
        //     FROM [tbl_orcamento]  orc
        //     left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento' and olch.periodo = '{$periodo}'
        //     left join tbl_calc_orcamento co on co.origem_id = olch.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
        //     left join tbl_orc_headcount_contratacoes ohc on ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id and ohc.periodo = '{$periodo}'
        //     left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes'
        //     left join tbl_orc_headcount_demissoes ohdt1 on ohdt1.tipo_table = '$tipoTableOrcamento' and  ohdt1.tipo = 1 and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id and ohdt1.periodo = '{$periodo}'
        //     left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' 
        //     left join tbl_orc_headcount_demissoes ohdt2 on ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes = $mes and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id and ohdt2.periodo = '{$periodo}'
        //     left join tbl_orc_headcount_demissoes ohdt3 on ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes = $mes and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id and ohdt3.periodo = '{$periodo}'
        //     left join tbl_orc_promocao ope on ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=$mes and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id and ope.periodo = '{$periodo}'
        //     left join tbl_orc_promocao ops on ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=$mes and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id and ops.periodo = '{$periodo}'
        //     where (olch.lotacao_id = $lotacao_id)
        //     and orc.id = $orc_id".$condicao."
        //     and olch.tipo_table = '$tipoTableOrcamento'
        //     group by olch.id, olch.qtd_func_lot, ohdt3.qtde_pessoas, coc.$mesAtual, cod.$mesAtual, co.$mesAnt
        // ");

        return $values;
    }

    public function getValoresMes($orc_id, $lotacao_id, $periodo, $par_id, $mes, $mes_int, $id_hd = null){

        $condicao = $id_hd == null ? "" : " and olch.id = $id_hd";
        $tipoTableOrcamento = 'F'; 

        
        $values = DB::select("SELECT 
               olch.id	as lot_id,
               case op.valor_parametro
                   when 0 then COALESCE(olch.qtd_func_lot, 0)      + COALESCE((select coc.$mes from tbl_orc_headcount_contratacoes ohc left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = '$tipoTableOrcamento' and ohc.periodo = '$periodo'  and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.$mes from tbl_orc_headcount_demissoes ohdt1 left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = '$tipoTableOrcamento' and ohdt1.periodo = '$periodo' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.tipo = 1 and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = '$tipoTableOrcamento' and ohdt2.periodo = '$periodo' and  ohdt2.tipo = 2 and ohdt2.mes = $mes_int and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = '$tipoTableOrcamento' and ohdt3.periodo = '$periodo' and  ohdt3.tipo = 3 and ohdt3.mes = $mes_int and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = '$tipoTableOrcamento' and ope.periodo = '$periodo' and ope.mes_promocao= $mes_int and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = '$tipoTableOrcamento' and ops.periodo = '$periodo' and ops.mes_promocao=$mes_int and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)
                   when 1 then COALESCE(olch.forecast_anterior, 0) + COALESCE((select coc.$mes from tbl_orc_headcount_contratacoes ohc left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = '$tipoTableOrcamento' and ohc.periodo = '$periodo'  and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.$mes from tbl_orc_headcount_demissoes ohdt1 left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = '$tipoTableOrcamento' and ohdt1.periodo = '$periodo' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.tipo = 1 and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = '$tipoTableOrcamento' and ohdt2.periodo = '$periodo' and  ohdt2.tipo = 2 and ohdt2.mes = $mes_int and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = '$tipoTableOrcamento' and ohdt3.periodo = '$periodo' and  ohdt3.tipo = 3 and ohdt3.mes = $mes_int and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = '$tipoTableOrcamento' and ope.periodo = '$periodo' and ope.mes_promocao= $mes_int and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = '$tipoTableOrcamento' and ops.periodo = '$periodo' and ops.mes_promocao=$mes_int and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)--'Forecast dezembro anterior' 
                   when 2 then COALESCE(olch.forecast_anterior, 0) + COALESCE((select coc.$mes from tbl_orc_headcount_contratacoes ohc left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = '$tipoTableOrcamento' and ohc.periodo = '$periodo'  and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.$mes from tbl_orc_headcount_demissoes ohdt1 left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = '$tipoTableOrcamento' and ohdt1.periodo = '$periodo' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.tipo = 1 and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = '$tipoTableOrcamento' and ohdt2.periodo = '$periodo' and  ohdt2.tipo = 2 and ohdt2.mes = $mes_int and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = '$tipoTableOrcamento' and ohdt3.periodo = '$periodo' and  ohdt3.tipo = 3 and ohdt3.mes = $mes_int and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = '$tipoTableOrcamento' and ope.periodo = '$periodo' and ope.mes_promocao= $mes_int and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = '$tipoTableOrcamento' and ops.periodo = '$periodo' and ops.mes_promocao=$mes_int and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)--'Importação' 
               end as valor
            FROM [tbl_orcamento]  orc
            left join tbl_orc_parametros op on op.orcamento_id = orc.id and op.parametro_id = $par_id
            left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
            where olch.lotacao_id = $lotacao_id
                and orc.id = $orc_id
                and olch.tipo_table = '$tipoTableOrcamento'          
                and olch.periodo = '$periodo' 
        ");

        // $values = DB::select("SELECT 
        //         olch.id	as lot_id,
        //         case op.valor_parametro
        //             when 0 then COALESCE(olch.qtd_func_lot, 0) + COALESCE(coc.{$mes}, 0) - COALESCE(cod.{$mes}, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)
        //             when 1 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.{$mes}, 0) - COALESCE(cod.{$mes}, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Forecast dezembro anterior' 
        //             when 2 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.{$mes}, 0) - COALESCE(cod.{$mes}, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Importação' 
        //         end as valor
        //     FROM [tbl_orcamento]  orc
        //     left join tbl_orc_parametros op on op.orcamento_id = orc.id and op.parametro_id = {$par_id}
        //     left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento' and olch.periodo = '{$periodo}'
        //     left join tbl_orc_headcount_contratacoes ohc on ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id and ohc.periodo = '{$periodo}'
        //     left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes'
        //     left join tbl_orc_headcount_demissoes ohdt1 on ohdt1.tipo_table = '$tipoTableOrcamento' and  ohdt1.tipo = 1 and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id and ohdt1.periodo = '{$periodo}'
        //     left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes'
        //     left join tbl_orc_headcount_demissoes ohdt2 on ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes=1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id and ohdt2.periodo = '{$periodo}'
        //     left join tbl_orc_headcount_demissoes ohdt3 on ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes=1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id and ohdt3.periodo = '{$periodo}'
        //     left join tbl_orc_promocao ope on ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id and ope.periodo = '{$periodo}'
        //     left join tbl_orc_promocao ops on ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id and ops.periodo = '{$periodo}'
        //     where olch.lotacao_id = $lotacao_id
        //         and orc.id = $orc_id".$condicao."
        //         and olch.tipo_table = '$tipoTableOrcamento' and olch.periodo = '{$periodo}'
        //     group by olch.id, olch.qtd_func_lot, coc.{$mes}, cod.{$mes}, ohdt3.qtde_pessoas, op.valor_parametro, olch.forecast_anterior
        // ");

        return $values;
    }

    public function updateForecastTotal($data){
        $registro = $this->getModelEntity()->find($data['id']);
        if(!$registro){
            $this->setError("Registro não encontrado. Erro: 040520201534");
            return false;
        }
        
        try { 
            // DB::enableQueryLog();
            $this->getModelEntity()->where([
                ['orc_id', $registro->orc_id],
                ['lotacao_id', $registro->lotacao_id],
                ['orc_cargo_id', $registro->orc_cargo_id],
                ['ccusto_id', $registro->ccusto_id],
                ['tipo_table', $registro->tipo_table],
                ['periodo', $registro->periodo]
            ])->update(['forecast_total' => $data['forecast_total'], 'updated_by' => $this->fillModificadoPor()]);

            $select = DB::select("SELECT id FROM tbl_orc_lot_carg_headcount where orc_id = ? and lotacao_id = ? and orc_cargo_id = ? and
            ccusto_id = ? and tipo_table = ? and periodo = ?",
            [$registro->orc_id,
            $registro->lotacao_id,
            $registro->orc_cargo_id,
            $registro->ccusto_id,
            $registro->tipo_table,
            $registro->periodo]);
            
            if($select != null && count($select) > 0){
                foreach($select as $value){
                    DB::update("UPDATE tbl_calc_orcamento set updated_at = ?, updated_by = ? where origem_id = ? and tbl_origem = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $value->id, 'tbl_orc_lot_carg_headcount']);
                }
            }
            // dd(DB::getQueryLog());
        } catch(\Illuminate\Database\QueryException $ex){ 
            $this->setError($ex);
            return false;
        }
        return true;
    }
    public function liberarForecast($dados, $orc_id){
        // inserir em forecast
        // inserir em status_lot_ccusto
        $tbl_status = new RepoStatusLotacaCentroCusto();
        $select_status = $tbl_status->getModelEntity()->select()->where([
            [$tbl_status->getModelEntity()->getColunaAlias('ccusto_id'), '=', $dados['ccusto_id']],
            [$tbl_status->getModelEntity()->getColunaAlias('lotacao_id'), '=', $dados['lotacao_id']],
            [$tbl_status->getModelEntity()->getColunaAlias('orcamento_id'), '=', $orc_id]
        ])->get()->toArray();
        
        if(count($select_status) > 0){
            $this->setError('Registro já existente!');
            return false;
        }
        try{
            $dados['orcamento_id'] = $orc_id;
            $dados['status'] = 1;
            $inserir = $tbl_status->create($dados);
            
            if(!$inserir){
                $this->setError('Falha ao inserir registro!');
                return false;
            }
            return true;
        }catch(\Exception $e){
            $this->setError('Falha ao inserir registro! Erro: 080920201530');
            return false;
        }
    }
    public function listarLiberar($orc_id){
        $tbl_status = new RepoStatusLotacaCentroCusto();
        $tbl_orc_lotacao = new RepoOrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_cc = new CentroCusto();

        $select = $tbl_status->getModelEntity()
        ->leftJoin($tbl_orc_lotacao->getModelEntity()->getTable(), $tbl_status->getModelEntity()->getColunaAlias('lotacao_id'), $tbl_orc_lotacao->getModelEntity()->getColunaAlias('id'))
        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getModelEntity()->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_cc->getTable(), $tbl_status->getModelEntity()->getColunaAlias('ccusto_id'), $tbl_cc->getColunaAlias('id'))
        ->select(
            $tbl_status->getModelEntity()->getColunaAlias('id'),
            $tbl_status->getModelEntity()->getColunaAlias('lotacao_id'),
            $tbl_status->getModelEntity()->getColunaAlias('ccusto_id'),
            $tbl_status->getModelEntity()->getColunaAlias('orcamento_id'),
            $tbl_status->getModelEntity()->getColunaAlias('periodo_inicial'),
            $tbl_status->getModelEntity()->getColunaAlias('periodo_final'),
            $tbl_status->getModelEntity()->getColunaAlias('status'),
            DB::raw("CONCAT( {$tbl_cc->getColunaAlias('cod_ccusto')}, ' - ', {$tbl_lotacao->getColunaAlias('unid_lotac')}, ' - ', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as description")
        )
        ->where($tbl_status->getModelEntity()->getColunaAlias('orcamento_id'), '=', $orc_id)
        
        ->get()->toArray();

        return $select;
    }
    public function deletarLiberacao($dados){
        $tbl_status = new RepoStatusLotacaCentroCusto();
        try{
            $resp = $tbl_status->delete($dados['id']);
            if(!$resp){
                $this->setError("Falha ao deletar Liberação!");
                return false;
            }
            return true;
        }catch(\Exception $e){
            $this->setError("Falha ao deletar Liberação! Erro: 080920201625");
            return false;
        }
    }
    public function listarPeriodos(){
 
    }
    public function liberarInsert($dados, $orc_id, $periodo){
        // $periodo = '2020-12-01';
        set_time_limit(700);
        $retorno = [];
        $retorno['submsg'] = 'Erro';
        $retorno['status'] = 'error';

        $cargo = DB::select("SELECT * FROM tbl_orc_cargo where orcamento_id = $orc_id and periodo = '{$periodo}' and tipo_table = 'F' ");
        if(count($cargo) == 0){
            $retorno['msg'] = 'Para preencher o período selecionado, libere antes a Parametrização do Forecast<br>Erro: 040220210940';
            return $retorno;
        }

        $ja_existe = DB::select("SELECT id from tbl_orc_lot_carg_headcount where orc_id = $orc_id and periodo = '{$periodo}' and tipo_table = 'F' ");
        if(count($ja_existe) > 0){
            $retorno['submsg'] = 'Atenção';
            $retorno['status'] = 'warning';
            $retorno['msg'] = 'O período selecionado já foi liberado.<br>Erro: 310320211046';
            return $retorno;
        }

        $preenchimento_liberado = DB::select("SELECT cron.*, ac.id from tbl_activities as ac
            inner join tbl_orc_cronograma as cron on cron.activity_id = ac.id
            where title like ('%orecast%') and title like ('%reenchimento%') and (cron.end_date >= GETDATE()) and cron.orcamento_id = $orc_id
            order by cron.start_date asc
        ");// cron.start_date <= GETDATE()

        if(count($preenchimento_liberado) == 0){
            $retorno['msg'] = "Não existe uma atividade cadastrada para o preenchimento do Forecast com data válida. Erro: 231120201054";
            return $retorno;
        }
        //$this->notificacaoEmail($orc_id, $periodo);
        // Verificar se tem algum periodo em aberto. Se tiver, cai fora
        /*
            PENDENTE DIGITACAO = 9;
            REABERTO = 10;
            ENVIADO = 11;
            CONFERIDO = 12;
            CALCULADO = 13;
            CALCULADO_LIBERADO = 14;
            APROVADO_GESTOR = 15;
            APROVADO_DIRETOR_AREA = 16;
        */
        $status_erro_msg = $this->status;
        //$insert_tudo = new RepoForecastFuncoes($this->fillCodEmpresa(), $this->fillCriadoPor(), $this->fillCriadoEm());
        $select_periodo = DB::select("SELECT concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'desc' from tbl_orc_lotacao as olot
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            where orcamento_id = $orc_id and tipo_table = 'F' and status <= $status_erro_msg and periodo = dateadd(month, -1, cast('{$periodo}' as date)) and olot.ativo = 1
            /*select * from c as st
            inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = $orc_id
            where st.status_atual <= $status_erro_msg and st.periodo is not null*/"
        );

        if( count($select_periodo) > 0){
            $desc = "";
            for($i = 0; $i < count($select_periodo); $i++){
                $desc = ($i == count($select_periodo)-1) ? $desc = $desc.$select_periodo[$i]->desc : $desc.$select_periodo[$i]->desc."; ";
            }
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            $retorno['msg'] = "Finalize a(s) Lotação(ões) existente(s) para liberar um novo período. <br>Lotação(ões): {$desc}.<br>Erro: 090920201117";
            return $retorno;
        }
        
        
        $status_orcamento = DB::select("SELECT id from tbl_orcamento where id = $orc_id and status_aprovacao <> 2");
        
        if(count($status_orcamento) > 0){
            $retorno['msg'] = "O orçamento deve ser aprovado antes do Forecast ser liberado. Erro: 061220201235";
            return $retorno;
        }

        // $cargo_sal = DB::select("SELECT * from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' ");
        // if(count($cargo_sal) == 0){
        //     $retorno['msg'] = 'Preencha os parâmetros do orçamento, Salário por Cargo inexistentes. Erro: 020220211621.';
        //     return $retorno;
        // }
        $bonus = DB::select("SELECT * from tbl_orc_bonus where orc_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' ");
        if(count($bonus) == 0){
            $retorno['msg'] = 'Preencha os parâmetros do orçamento. Bônus inexistentes. Erro: 020220211623.';
            return $retorno;
        }
        $he = DB::select("SELECT * from tbl_orc_hora_extra where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' ");
        if(count($he) == 0){
            $retorno['msg'] = 'Preencha os parâmetros do orçamento. Horas Extras inexistentes. Erro: 020220211624.';
            return $retorno;
        }

        
        $result = $this->liberarOrcLotacoesForecast($orc_id, $periodo);
        if($result['status'] == 'error'){
            $retorno['msg'] = "Falha ao liberar Lotações. ".$result['msg'];
            return $retorno;
        }
        DB::beginTransaction();
        try{
            $liberacao = $this->novoLiberar($orc_id, $periodo);
            if($liberacao['status'] == 'error'){
                $retorno['msg'] = $liberacao['msg'];
                DB::rollBack();
                return $retorno;
            }
            DB::commit();
            return $liberacao;
        }
        catch(\Exception $e){
            $retorno['msg'] = $e->getMessage();
            DB::rollBack();
            return $retorno;
        }
        
        goto saida;
        /*
            a. faz um for na headcout
            (olha regra que teve distribuição / ou <> zero nos meses) do tipo_tlabe 'O', senão  faz um for na headcount
            pelo ultimo forecast – ultimo Periodo e tipo_table 'F';
        */
        /*
            Vou pegar o ultimo forecast criado(pelos campos periodo tipo_table) na tbl_headcount e também filtrar pelo status e pegando o ultimo periodo
            Se for nulo ^, e pego o headcount do tipo_table 'O', pela lotacao, distribuição e orc_id
        */
        /*
            Antes de tudo, precisa abrir um for() para cada lotacao
        */
        $periodo_passado = substr($periodo, 5, 2);
        $ultimo_periodo = DB::select("SELECT dateadd(month, -1, '{$periodo}') as periodo_passado")[0]->periodo_passado;
        $condicao = null;
        
        if(intval($periodo_passado, 10) >= 2){
            $condicao[0] = " and st.periodo = DATEADD(month, -1, '{$periodo}') and st.tipo_table = 'F' ";
            $condicao[1] = " and hdf.periodo = DATEADD(month, -1, '{$periodo}') ";
        }
        else{
            $condicao[0] = "";
            $condicao[1] = "";
        }
        
        for($i = 0; $i < count($dados); $i++){ // testado, inseriu todos os registros
            $id = $dados[$i]['id'];
            $status = $this->status;
            $where_lotacao_anterior = $condicao == "" ? "" : " and hdf.lotacao_id = ".$this->getOrcLotForecastByOrc($id, $ultimo_periodo, $orc_id);

            $ultimo_criado_anterior = DB::select("SELECT  hdf.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_orc_lot_carg_headcount as hdf
                left join tbl_calc_orcamento as calc on calc.origem_id = hdf.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                where orc_id = $orc_id and
                hdf.tipo_table = 'F' and
                hdf.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hdf.lotacao_id = $id
                
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("SELECT hd.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_orc_lot_carg_headcount as hd
                    left join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                    
                    where tipo_table = 'O' and orc_id = $orc_id and hd.lotacao_id = $id and
                    (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc.jan_orcado <> 0 or calc.fev_orcado <> 0 or calc.mar_orcado <> 0 or calc.abr_orcado <> 0 or
                    calc.mai_orcado <> 0 or calc.jun_orcado <> 0 or calc.jul_orcado <> 0 or calc.ago_orcado <> 0 or
                    calc.set_orcado <> 0 or calc.out_orcado <> 0 or calc.nov_orcado <> 0 or calc.dez_orcado <> 0 ))
                ");

                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                try{
                    
                    foreach($ultimo_criado_anterior as $value){
                        // colocar validação de insert
                        $novo_cargo = $this->getOrcCargoForecastByOrc($value->orc_cargo_id, $periodo, $orc_id);
                        $nova_turma = $this->getOrcTurmaForecastByOrc($value->orc_turma_id, $periodo, $orc_id);
                        $nova_lot = $this->getOrcLotForecastByOrc($id, $periodo, $orc_id);

                        $existe = DB::select("SELECT * from tbl_orc_lot_carg_headcount where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orc_id, $novo_cargo, $value->ccusto_id, $nova_lot, $nova_turma, 'F', $periodo]);
                        
                        if(count($existe) == 0){
                            // ORCADO ANTERIOR DEZ
                            $existe_hd = DB::select("SELECT * from tbl_orc_lot_carg_headcount as hd
                            left join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                            where hd.orc_id = ? and hd.orc_cargo_id = ? and hd.ccusto_id = ? and hd.lotacao_id = ? and hd.orc_turma_id = ? and hd.tipo_table = ? and hd.periodo is null", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'O']);

                            $orcado_ant = count($existe_hd) > 0 ? intval($existe_hd[0]->dez_orcado) : 0;

                            $atual_total = DB::select("select COUNT(*) 'atual_total' from tbl_funcionario where lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = $id) and ccusto_id = (select cc_custo_id from tbl_orc_lotacao where id = $id) and cargo_id = (select cargo_id from tbl_orc_cargo where id = $value->orc_cargo_id) and dat_demis_func is null");
                            $atual_total = $atual_total[0]->atual_total;

                            $qtd_func_lot = DB::select("select COUNT(*) 'qtd_func_lot' from tbl_funcionario where lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = $id) and ccusto_id = (select cc_custo_id from tbl_orc_lotacao where id = $id) and cargo_id = (select cargo_id from tbl_orc_cargo where id = $value->orc_cargo_id)and turma_id = (select turma_id from tbl_orc_turma where id = $value->orc_turma_id) and dat_demis_func is null");
                            $qtd_func_lot = $qtd_func_lot[0]->qtd_func_lot;

                            $data = array(
                                'orc_id'=>$value->orc_id, 'lotacao_id'=>$nova_lot, 'orc_cargo_id'=>$novo_cargo, 'ccusto_id'=>$value->ccusto_id,
                                'orc_turma_id'=>$nova_turma, 'user_id'=>$this->fillCriadoPor(), 'empresa_id'=>$value->empresa_id, 'tipo_table'=>'F', 'qtd_func_lot'=>$qtd_func_lot,
                                'atual_total'=>$atual_total, 'forecast_anterior'=>$value->forecast_anterior, 'forecast_total'=>$value->forecast_total, 'created_at'=>$this->fillCriadoEm(), 'periodo'=>$periodo,
                                'created_by'=>$this->fillCriadoPor(), 'orcado_anterior'=>$orcado_ant, 'forecast_original'=>$value->forecast_original, 'origem_sistema'=>1
                            );

                            $insert = $this->create($data);
                            
                            $get_id = $insert->id;// DB::select("SELECT * from tbl_orc_lot_carg_headcount where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orc_id, $novo_cargo, $value->ccusto_id, $nova_lot, $nova_turma, 'F', $periodo]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id, 'tbl_orc_lot_carg_headcount', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }                        
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 090920201411ct");
                    return false;
                }
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $novo_cargo_f = $this->getOrcCargoForecastByOrc($value->orc_cargo_id, $periodo, $orc_id);
                        $nova_turma_f = $this->getOrcTurmaForecastByOrc($value->orc_turma_id, $periodo, $orc_id);
                        $nova_lot_f = $this->getOrcLotForecastByOrc($id, $periodo, $orc_id);

                        $novo_cargo = $this->getOrcCargoByForecast($novo_cargo_f, $orc_id);
                        $nova_turma = $this->getOrcCargoByForecast($nova_turma_f, $orc_id);
                        $nova_lot = $this->getOrcLotByForecast($nova_lot_f, $orc_id);

                        $existe = DB::select("SELECT * from tbl_orc_lot_carg_headcount where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orc_id, $novo_cargo, $value->ccusto_id, $nova_lot_f, $nova_turma, 'F', $periodo]);
                        if(count($existe) == 0){
                            
                            $existe_hd = DB::select("SELECT * from tbl_orc_lot_carg_headcount as hd
                            left join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                            where hd.orc_id = ? and hd.orc_cargo_id = ? and hd.ccusto_id = ? and hd.lotacao_id = ? and hd.orc_turma_id = ? and hd.tipo_table = ? and hd.periodo is null", [$value->orc_id, $novo_cargo, $value->ccusto_id, $nova_lot, $nova_turma, 'O']);

                            $orcado_ant = count($existe_hd) > 0 ? intval($existe_hd[0]->dez_orcado) : 0;

                            $atual_total = DB::select("select COUNT(*) 'atual_total' from tbl_funcionario where lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = $id) and ccusto_id = (select cc_custo_id from tbl_orc_lotacao where id = $id) and cargo_id = (select cargo_id from tbl_orc_cargo where id = $value->orc_cargo_id) and dat_demis_func is null");
                            $atual_total = $atual_total[0]->atual_total;

                            $qtd_func_lot = DB::select("select COUNT(*) 'qtd_func_lot' from tbl_funcionario where lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = $id) and ccusto_id = (select cc_custo_id from tbl_orc_lotacao where id = $id) and cargo_id = (select cargo_id from tbl_orc_cargo where id = $value->orc_cargo_id)and turma_id = (select turma_id from tbl_orc_turma where id = $value->orc_turma_id) and dat_demis_func is null");
                            $qtd_func_lot = $qtd_func_lot[0]->qtd_func_lot;

                            $insert = DB::insert("INSERT INTO tbl_orc_lot_carg_headcount(
                                [orc_id], [lotacao_id], [orc_cargo_id], [ccusto_id], [orc_turma_id], [user_id]
                                ,[empresa_id], [tipo_table], [qtd_func_lot], [atual_total], [forecast_anterior], [forecast_total]
                                ,[created_at], [periodo], [created_by], [orcado_anterior], [forecast_original], [origem_sistema]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $nova_lot_f, $novo_cargo_f, $value->ccusto_id, $nova_turma_f, $this->fillCriadoPor(), $value->empresa_id, 'F', $qtd_func_lot, $atual_total, $value->forecast_anterior, $value->forecast_total, $this->fillCriadoEm(), $periodo, $this->fillCriadoPor(), $orcado_ant, $value->forecast_original, 1]);
                            $get_id = DB::select("SELECT * from tbl_orc_lot_carg_headcount where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orc_id, $novo_cargo_f, $value->ccusto_id, $nova_lot_f, $nova_turma_f, 'F', $periodo]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_lot_carg_headcount', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 090920201423ct");
                    return false;
                }
            }
        }


        return $this->atualizaOrcFuncionario($orc_id);
        //$insert_tudo->liberarTudo($dados, $orc_id, $periodo);
        saida:
        return true;
    }

    public function atualizaOrcFuncionario($orc_id){
        $usuario_id = $this->fillModificadoPor();
        try{
            $sql="EXEC sp_atualiza_orc_funcionario :id_orc, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            
            if(!$stmt->execute()){
                $this->setError("Falha ao atualizar os funcionários de acordo com a folha! Erro: 140120211018");
                return false;
            }
        }
        catch(\Exception $e){
            dd($e);
            $this->setError("Falha ao atualizar os funcionários de acordo com a folha! Erro: 140120211015");
            return false;
        }
        return true;
    }

    public function notificacaoEmail($orc_id, $periodo){
        try{
            $parametro = DB::select("
                select opar.valor_parametro, orca.ano, orca.descricao_orc, orca.id from tblg_parametros as par
                inner join tbl_orc_parametros as opar on opar.parametro_id = par.id
                inner join tbl_orcamento as orca on orca.id = opar.orcamento_id
                where opar.orcamento_id = {$orc_id} and par.cod_parametro = 'HIER'
            ");
        
            $hierarquia = 3;// gerente de area
            //$parametro[0]->valor_parametro + 1;

            if(count($parametro) == 0){
                $this->setError("Não foi possível encontrar o parâmetro hierarquia do orçamento. Verifique em Parâmetros do Orçamento, aba configurações, sub-aba Parâmetros ! Erro: 061220201246");
                return false;
            }

            $preenchimento_liberado = DB::select("
                select cron.*, ac.id from tbl_activities as ac
                inner join tbl_orc_cronograma as cron on cron.activity_id = ac.id
                where title like ('%orecast%') and title like ('%reenchimento%') and (cron.end_date >= GETDATE()) and cron.orcamento_id = $orc_id
                order by cron.start_date asc
            ");

            if(count($preenchimento_liberado) == 0){
                $this->setError("Não foi possível encontrar uma atividade de preenchimento do forecast com data válida. Verifique em Ferramentas do orçamento, aba Lista de Atividades! Erro: 061220201247");
                return false;
            }
            //dd($hierarquia, $parametro[0]->ano, $parametro[0]->descricao_orc, $parametro[0]->id, '', 'de '.formataData($preenchimento_liberado[0]->start_date).' a '.formataData($preenchimento_liberado[0]->end_date));
            if(!$this->repo_notify->notifyLiberarForecast($hierarquia, $parametro[0]->ano, $parametro[0]->descricao_orc, $parametro[0]->id, '', 'de '.formataData($preenchimento_liberado[0]->start_date).' a '.formataData($preenchimento_liberado[0]->end_date) , $this->buildPeriodoDesc($periodo))){
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            $this->setError("Erro ao mandar notificação. Erro: 271120201410ct ".$e->getMessage());
            return false;
        }
    }
    public function periodosDisponiveis($orc_id){
        $select = DB::select("SELECT top(1) periodo as ultimo_periodo from tbl_orc_lot_carg_headcount
            where orc_id = $orc_id and tipo_table = 'F' order by periodo desc
        ");
        $dados = [];
        //$orcamento = DB::select("SELECT * from tbl_orcamento where id = $orc_id");
        if(count($select) > 0){
            $dados[0] = array('ultimo_periodo'=>$select[0]->ultimo_periodo,'original'=>true);
        }
        else{
            // $dados[0] = array('ultimo_periodo'=>date($orcamento[0]->ano+'-01-01'),'original'=>false);
            $dados[0] = array('ultimo_periodo'=>null);
        }
        return $dados;
    }
    public function listarToPreencherForecast($orc_id, $periodo = null){

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, null, 'F'); 
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        
        $where = "";
        if($periodo != null && $periodo != 'null'){
            $where = "'{$periodo}'";
        }
        else{
            $where = "(SELECT max(st.periodo) from tbl_orc_movto_status_ccusto as st
                inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = $orc_id and lot.tipo_table = 'F' and lot.periodo is not null
                inner join tbl_orc_lot_carg_headcount as hd on hd.lotacao_id = lot.id and hd.orc_id = $orc_id and hd.tipo_table = 'F'
                where st.periodo is not null and st.tipo_table = 'F')";
        }
        $select = DB::select("SELECT 
            lot.ativo,
            olot.cc_custo_id,
            olot.cc_custo_id_origem,
            cc.cod_ccusto,
            olot.created_at,
            olot.created_by,
            cc.des_ccusto,
            lot.des_unid_lotac,
            concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'description',
            olot.empresa_id,
            olot.has_error_calc,
            olot.has_transf,
            olot.hc_iniciado,
            olot.id,
            olot.lotacao_id,
            olot.lotacao_id_origem,
            olot.orcamento_id,
            lot.quadro_atual,
            olot.responder_orc,
            sc.status_atual,
            sc.status_anterior,
            status_label = 
            CASE sc.status_atual
                WHEN 9 THEN 'Pendente'
                WHEN 10 THEN 'Em Andamento'
                WHEN 11 THEN 'Enviado'
                WHEN 12 THEN 'Reaberto'

                WHEN 13 THEN 'Conferido'
                WHEN 14 THEN 'Liberado'
                WHEN 15 THEN 'Finalizado'
                WHEN 16 THEN 'Aprovado'

                WHEN 17 THEN 'Em Execução'
                WHEN 18 THEN 'Enviado Sistema'
                ELSE cast(sc.status_atual as varchar) END,
            lot.unid_lotac,
            olot.updated_at,
            olot.updated_by,
            olot.user_id,
            olot.status as status_orc_lotacao,
            sc.periodo
                
            from tbl_orc_movto_status_ccusto as sc
            
            inner join tbl_orc_lotacao as olot on olot.id = sc.orc_lotacao_id and olot.orcamento_id = $orc_id and olot.tipo_table = 'F'
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            
            where sc.periodo = {$where} and sc.tipo_table = 'F' and lot.id in ($lotacoes_string) order by lot.unid_lotac, cc.cod_ccusto asc
        ");
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            $dados[$i]['periodo_'] = $dados[$i]['periodo'];
            $dados[$i]['periodo'] = formataData($dados[$i]['periodo']);
        }
        return $dados;
    }
    public function desfazerForecast($dados, $orc_id){
        
        $periodo = $dados[0];
        
        $select = DB::select("SELECT * from tbl_orc_movto_status_ccusto where periodo > '{$periodo}' and tipo_table = 'F' and orc_lotacao_id in (select id from tbl_orc_lotacao as olot where olot.orcamento_id = {$orc_id} and olot.periodo > '{$periodo}' and olot.tipo_table = 'F')");
        
        // if(count($select) > 1){
        //     $this->setError("Não foi possível reabrir o período selecionado. Erro: 041220200949");
        //     return false;
        // }
        if(count($select) > 0){
            try{
                $this->deleteAllToReabrir($select[0]->periodo, $orc_id);
                $this->atualizaToReabrir($periodo, $orc_id);
                DB::commit();
                return true;
            }
            catch(\Exception $e){
                $this->setError('Falha ao reabrir forecast. Erro: 240920201501ct');
                DB::rollBack();
                return false;
            }
        }
        else{
            try{
                $this->atualizaToReabrir($periodo, $orc_id);
                DB::commit();
                return true;
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError('Falha ao reabrir forecast. Erro: 240920201501ctb'.$e);
                return false;
            }
        }
        return true;
    }
    public function atualizaStatusForecastLotacao($status, $orc_lotacao_id){
        DB::update("update tbl_orc_lotacao set status = ? where id = ?", [$status, $orc_lotacao_id]);
    }
    public function atualizaToReabrir($periodo, $orc_id){
        $data_select = DB::select("select * from tbl_orc_movto_status_ccusto where periodo = '{$periodo}' and tipo_table = 'F' and orc_lotacao_id in (select id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}')");
        
        for($i = 0; $i < count($data_select); $i++){
            //if($data_select[$i]->status_atual >= 1){
                DB::update("update tbl_orc_movto_status_ccusto set status_atual = ?, status_anterior = ? where id = ?",
                [self::STATUS_LOT_REABERTO_FCST, $data_select[$i]->status_atual, $data_select[$i]->id]);

                $this->atualizaStatusForecastLotacao(self::STATUS_LOT_REABERTO_FCST, $data_select[$i]->orc_lotacao_id);
            //}
        }

        $passa_rh_forecast = $this->getParamByOrc($orc_id, $this->getCodPassaRHForecast());
        $dados_orc = DB::select("select * from tbl_orcamento where id = ?", [$orc_id]);

        if($passa_rh_forecast){
            // $parametro = DB::select("
            //     select * from tbl_orc_parametros as opar
            //     inner join tblg_parametros as par on par.id = opar.parametro_id
            //     inner join tbl_orcamento as orc on orc.id = {$orc_id}
            //     where opar.orcamento_id = {$orc_id} and par.cod_parametro like ('%HIER%')
            // ");
            // if(count($parametro) > 0){
                
                if(!$this->repo_notify->reabreForecast($this->buildPeriodoDesc($periodo), $dados_orc[0]->ano, $dados_orc[0]->descricao_orc, $dados_orc[0]->id, null, $periodo, null)){
                    DB::rollBack();
                    $this->setError($this->repo_notify->getErrosFlatted());
                    return false;
                }
            // }
        }
    }
    public function deleteAllToReabrir($periodo, $orc_id){
        try{
            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
                (select id from tbl_headcount_hra_extra where tipo_table = ? and periodo = ? and orc_id = ?)', ['tbl_headcount_hra_extra', 'F', $periodo, $orc_id]
            );
        
            DB::delete('delete from tbl_headcount_hra_extra where tipo_table = ? and periodo = ? and orc_id = ?', ['F', $periodo, $orc_id]);

            // Ferias
            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
            (select id from tbl_orc_ferias where tipo_table = ? and periodo = ? and orcamento_id = ?)', ['tbl_orc_ferias', 'F', $periodo, $orc_id]);

            DB::delete('delete from tbl_orc_ferias where tipo_table = ? and periodo = ? and orcamento_id = ?', ['F', $periodo, $orc_id]);

            // Aumento Sal. 0 - Orçamento (RH) / 1 - Headcount ( GESTORES )
            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
            (select id from tbl_orc_salario_funcionario where tipo_table = ? and periodo = ? and orc_id = ? and tipo = 1)', ['tbl_orc_salario_funcionario', 'F', $periodo, $orc_id]);

            DB::delete('delete from tbl_orc_salario_funcionario where tipo_table = ? and periodo = ? and orc_id = ? and tipo = 1', ['F', $periodo, $orc_id]);

            // Promocoes
            DB::delete('delete from tbl_orc_promocao where tipo_table = ? and periodo = ? and orc_id = ?', ['F', $periodo, $orc_id]);

            // contratacoes
            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
            (select id from tbl_orc_headcount_contratacoes where tipo_table = ? and periodo = ? and orcamento_id = ?)', ['tbl_orc_headcount_contratacoes', 'F', $periodo, $orc_id]);

            DB::delete('delete from tbl_orc_headcount_contratacoes where tipo_table = ? and periodo = ? and orcamento_id = ?', ['F', $periodo, $orc_id]);
            

            // demissoes - Funcionando
            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
            (select id from tbl_orc_headcount_demissoes where tipo_table = ? and periodo = ? and orcamento_id = ?)', ['tbl_orc_headcount_demissoes', 'F', $periodo, $orc_id]);

            DB::delete('delete from tbl_orc_headcount_demissoes where tipo_table = ? and periodo = ? and orcamento_id = ?', ['F', $periodo, $orc_id]); 
            /**/
            // headcount - funcionando

            DB::delete('delete from tbl_calc_orcamento where tbl_origem = ? and origem_id in
            (select id from tbl_orc_lot_carg_headcount where tipo_table = ? and periodo = ? and orc_id = ?)', ['tbl_orc_lot_carg_headcount', 'F', $periodo, $orc_id]);

            DB::delete('delete from tbl_orc_lot_carg_headcount where tipo_table = ? and periodo = ? and orc_id = ?', ['F', $periodo, $orc_id]); 
            /**/

            // movto-status - funcionando
            /* FOI COMENTADO, PORQUE TALVEZ IRÁ INTEFERIR NO NOVO FORECAST - MATHEUS 08/02/2021*/
            // DB::delete('delete from tbl_orc_movto_status_ccusto where orc_lotacao_id in (select id from tbl_orc_lotacao where orcamento_id = ?) and tipo_table = ? and periodo = ?', [$orc_id, 'F', $periodo]); 
        }
        catch(\Exception $e){
            return $this->setError('Falha ao Reabrir Forecast. Erro: 240920201452');
        }
    }
    public function finalizarForecast($dados, $orc_id){
        // pegar todos os registros em tbl_movto e alterar o status final
        // filtrar pelo orc_id, atravez da lotacao_id

        // $status_finalizado = $this->status;
        // $CALCULADO = 5;
        try{
            $select = DB::select("
                select * from tbl_orc_lotacao as lot where lot.orcamento_id = ? and status < ? and periodo = '{$dados[0]}'
            ", [$orc_id, self::STATUS_LOT_CALCULADO_FCST]);
            // $select = DB::select('
            //     select st.* from tbl_orc_movto_status_ccusto as st
            //     inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = ?
            //     where st.tipo_table = ? and st.periodo = ? and status_atual < ?
            // ', [$orc_id, 'F', $dados[0], self::STATUS_LOT_CALCULADO_FCST]);

            if(count($select) > 0){
                $this->setError('Falha ao Finalizar o Forecast. É necessário concluir todas as etapas antes de Finalizá-lo. Erro: 110920201629');
                return false;
            }
            // $update = DB::update('
            //     update tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where id in (select st.id from tbl_orc_movto_status_ccusto as st
            //     inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = ?
            //     where st.tipo_table = ? and st.periodo = ?)
            // ', [self::STATUS_LOT_APROVADO_FCST, $orc_id, 'F', $dados[0]]);
            $usuario_id = $this->fillModificadoPor();

            $update_lotacao = DB::update("UPDATE tbl_orc_lotacao set status = ?, updated_at = getdate(), updated_by = $usuario_id where orcamento_id = $orc_id and periodo = '{$dados[0]}' and tipo_table = 'F'", [self::STATUS_LOT_APROVADO_FCST]);
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where orc_lotacao_id in (
                select id from tbl_orc_lotacao where orcamento_id = $orc_id and periodo = '{$dados[0]}' and tipo_table = 'F'
                )", [self::STATUS_LOT_APROVADO_FCST]
            );
            if(/*$update === false || */$update_lotacao === false){
                $this->setError('Falha ao finalizar o Forecast. Erro: 110920201610');
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            $this->setError('Falha ao finalizar o Forecast. Erro: 110920201609ct - '.$e->getMessage());
            return false;
        }
    }

    public function loadTotalFuncCargoTurma($lotacao_id, $cargo_id){
        // dd("parametros",$orc_id,$cargo_id,$turma_id);
        /*$olch =  $this->getModelEntity();

        $num_func= $olch
        ->where($olch->getColunaAlias('orc_id'), $orc_id)
        ->where($olch->getColunaAlias('orc_cargo_id'), $cargo_id)
        ->where($olch->getColunaAlias('orc_turma_id'), $turma_id)
        ->where($olch->getColunaAlias('tipo_table'), 'F')
        ->first();
        return $num_func;
        */
        // dd("numf unc", $num_func);
        
        $select = DB::select("SELECT count(*) qtd_funcionarios from tbl_funcionario as func
        inner join tbl_orc_lotacao as l on l.lotacao_id = func.lotacao_id and l.cc_custo_id = func.ccusto_id--and l.id = ?
        --inner join tbl_orc_turma as t on t.turma_id = func.turma_id --and t.id = ?
        where func.cargo_id = ? and l.id = ?", [$cargo_id, $lotacao_id]);
        return $select;
    }
    public function getOrcCargoByCargo($id, $orc_id, $periodo, $tipo_table){
        $select = DB::select("SELECT * from tbl_orc_cargo where cargo_id = ? and orcamento_id = ? and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' ", [$id, $orc_id]);
        return count($select) > 0 ? $select[0]->id : $id;
    }

    public function getStatusMovtoByLotacao($lotacao_id, $periodo){
        $select = DB::select("select * from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and periodo = ? and tipo_table = 'F'", [$lotacao_id, $periodo]);

        return count($select) > 0 ? $select[0] : false;
    }
    public function reabrirForecastGestor($orc_id, $lotacao_id, $periodo){
        // se houver um periodo maior que $periodo, cai no de baixo
        // não pode reabrir se o periodo estiver pendente = 1

        $select_compare = DB::select("SELECT * from tbl_orc_movto_status_ccusto where periodo > ? and tipo_table = 'F' and orc_lotacao_id in(select id from tbl_orc_lotacao where periodo = '{$periodo}' and tipo_table = 'F' and orcamento_id = $orc_id)", [$periodo]);
        
        if(count($select_compare) == 0){
            // SÓ VAI REABRIR SE NÃO EXISTIR UM PERIODO MAIOR QUE ESSE. PORQUE QUANDO CRIA UM PERIODO NOVO, JÁ VAI PARA PENDENTE DE DIGITAÇÃO
            try{
                $dados_antigos = $this->getStatusMovtoByLotacao($lotacao_id, $periodo);
                // $existe_maior = DB::select("SELECT * from tbl_orc_movto_status_ccusto where periodo > '{$periodo}' and tipo_table = 'F'");
                // if(count($existe_maior) != 0 && $existe_maior[0]->status_atual >= self::STATUS_LOT_PENDENTE_DIGITACAO_FCST){
                //     $this->setError("Impossível reabrir o último período, pois o período atual está em digitação! Erro: 240920201342");
                //     return false;
                // }
                if($dados_antigos->status_atual == 10){
                    $this->setError('Lotação já reaberta!');
                    return false;
                }
            
                DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = ?, status_atual = ? where orc_lotacao_id = ? and periodo = '{$periodo}' and tipo_table = 'F'",
                [$dados_antigos->status_atual, self::STATUS_LOT_REABERTO_FCST, $lotacao_id]);

                DB::update("UPDATE tbl_orc_lotacao set status = ? where id = ?", [self::STATUS_LOT_REABERTO_FCST, $lotacao_id]);
                
                $lotacao = DB::select('SELECT * from tbl_orc_lotacao as olot
                    inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
                    inner join tbl_orcamento as orc on orc.id = olot.orcamento_id
                    where olot.orcamento_id = ? and olot.id = ?',
                    [$orc_id, $lotacao_id]);
                    
                if(count($lotacao) > 0){
                    
                    $descricao = $lotacao[0]->unid_lotac.' - '.$lotacao[0]->des_unid_lotac;
                    
                    // $passa_rh_forecast = $this->getParamByOrc($orc_id, $this->getCodPassaRHForecast());

                    // if($passa_rh_forecast){
                        
                        $parametro = DB::select("SELECT lot.unid_lotac, lot.des_unid_lotac, opar.valor_parametro, orclot.status, orclot.lotacao_id, orcm.ano, orcm.descricao_orc, orcm.id from tbl_orc_lotacao orclot
                            join tbl_orcamento as orcm on orcm.id = orclot.orcamento_id
                            join tbl_lotacao as lot on lot.id = orclot.lotacao_id
                            join tbl_orc_parametros as opar on opar.orcamento_id = orcm.id
                            join tblg_parametros as par on par.id = opar.parametro_id
                            where orclot.id = $lotacao_id and par.cod_parametro = 'HIER' and orcm.id = $orc_id
                        ");
                        if(count($parametro) > 0){
                            $hierarquia = $parametro[0]->valor_parametro + 1;
                            
                            if(!$this->repo_notify->reabreForecast($descricao, $lotacao[0]->ano, $lotacao[0]->descricao_orc, $lotacao[0]->orcamento_id, $parametro[0]->lotacao_id, $this->buildPeriodoDesc($periodo), $hierarquia)){
                                DB::rollBack();
                                $this->setError($this->repo_notify->getErrosFlatted());
                                return false;
                            }
                        }
                    // }
                    // else{
                    //     // CALCULO, SE TIVER
                    // }
                }
                
                DB::commit();
                return true;
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Falha ao reabrir Lotação. Erro: 240920201344ct".$e);
                return false;
            }
        }
        $this->setError('Impossível reabrir pois há outro(s) período(s) em digitação. Erro: 240920201347');
        return false;
        // $select = DB::select("
        //     select * from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and
        //     periodo = (select max(periodo) from tbl_orc_movto_status_ccusto where tipo_table = 'F')
        //     and tipo_table = 'F'", [$lotacao_id]);
        
        // if(count($select) > 0){
        //     if($select[0]->status_atual >= 1){
        //         $this->setError("Impossível reabrir o último período, pois o período atual está em digitação! Erro: 240920201210");
        //         return false;
        //     }
        // }
        // $this->setError("pode reabrir!");
        // return false;
    }
    public function buildPeriodoDesc($periodo){
        $ano = substr($periodo, 0, 4);
        $mes = substr($periodo, 5, 2);

        $meses = [
            'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
            'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'
        ];
        $build = '';
        for($i = 0; $i < count($meses); $i++){
            if(intval($mes) == ($i+1)){
                $build = $meses[$i].'/'.$ano;
                break;
            }
        }
        return $build;
    }

    protected function getOrcCargoForecastByOrc($orc_cargo_id, $periodo, $orc_id){
        $select = DB::select("SELECT id from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and cargo_id = (
            SELECT cargo_id from tbl_orc_cargo where id = $orc_cargo_id
        )");

        return count($select) > 0 ? $select[0]->id : -1;
    }
    protected function getOrcTurmaForecastByOrc($orc_turma_id, $periodo, $orc_id){
        $select = DB::select("SELECT turma_id, turno_id from tbl_orc_turma where id = $orc_turma_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_turma where orc_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and turma_id = {$select[0]->turma_id} and turno_id = {$select[0]->turno_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }

        return -2;
    }
    protected function getOrcLotForecastByOrc($orc_lot_id, $periodo, $orc_id){
        $select = DB::select("SELECT lotacao_id, cc_custo_id from tbl_orc_lotacao where id = $orc_lot_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and lotacao_id = {$select[0]->lotacao_id} and cc_custo_id = {$select[0]->cc_custo_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }


    protected function getOrcCargoByForecast($orc_cargo_id, $orc_id){
        $select = DB::select("SELECT id from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'O' and periodo is null and cargo_id = (
            SELECT cargo_id from tbl_orc_cargo where id = $orc_cargo_id
        )");

        return count($select) > 0 ? $select[0]->id : -1;
    }
    protected function getOrcTurmaByForecast($orc_turma_id, $orc_id){
        $select = DB::select("SELECT turma_id, turno_id from tbl_orc_turma where id = $orc_turma_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_turma where orc_id = $orc_id and tipo_table = 'O' and turma_id = {$select[0]->turma_id} and turno_id = {$select[0]->turno_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }
    protected function getOrcLotByForecast($orc_lot_id, $orc_id){
        $select = DB::select("SELECT lotacao_id, cc_custo_id from tbl_orc_lotacao where id = $orc_lot_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'O' and lotacao_id = {$select[0]->lotacao_id} and cc_custo_id = {$select[0]->cc_custo_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }
    public function deleteForecast($form_data){
        $repo_calc_orc=new RepoCalcOrcamento();
        $retorno = [];
        DB::beginTransaction();
        try {
            
            $orc_cargo_id = DB::select("SELECT id from tbl_orc_cargo where cargo_id = ? and orcamento_id = ? and tipo_table = 'F' and periodo = '{$form_data['periodo']}'", [$form_data['cargo_id'], $form_data['orc_id']]);

            if(!$this->deleteDiarioBordoByCargoTurma($form_data['orc_id'], $form_data['lotacao_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], 'F')){
                $retorno['msg'] = "Impossível concluir a operação. Falha ao deletar Diário de Bordo. Erro: 230320210953";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }

            $delete = $this->getModelEntity()::where('id',$form_data['id_princ'])->delete();
            if(!$delete){
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 190120211830.");
                goto saida;
            }
            
            $delete_calc_orc = $repo_calc_orc->getModelEntity()::where('id',$form_data['id'])->delete();

            if($delete_calc_orc == false){
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 190120211830b.");
                DB::rollBack();
                goto saida;          
            }
            

            $a = DB::delete("DELETE from tbl_calc_orcamento where origem_id in (
                SELECT id from tbl_orc_headcount_contratacoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ? and orcamento_id = ?
            ) and tbl_origem = 'tbl_orc_headcount_contratacoes' ", [$orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $form_data['orc_id']]);

            $b = DB::delete("DELETE from tbl_orc_headcount_contratacoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ? and orcamento_id = ?", [$orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $form_data['orc_id']]);
            
            $c = DB::delete("DELETE from tbl_calc_orcamento where origem_id in (
                SELECT id from tbl_orc_headcount_demissoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ? and orcamento_id = ?
            ) and tbl_origem = 'tbl_orc_headcount_demissoes' ", [$orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $form_data['orc_id']]);
            
            $d = DB::delete("DELETE from tbl_orc_headcount_demissoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ? and orcamento_id = ?", [$orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $form_data['orc_id']]);
            
            $dados = DB::select("SELECT * from tbl_orc_promocao where orc_id = ? and (cargo_atual_id = ? and turma_atual_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ?) or (cargo_promovido_id = ? and turma_promovida_id = ? and tipo_table = 'F' and periodo = ? and lotacao_promovida_id = ?)", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id']]);
            foreach($dados as $dado){
                $existe_sub = DB::select("SELECT * from tbl_orc_promocao where sub_promocao_id = ?", [$dado->id]);
                if(count($existe_sub) > 0){
                    DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = 0 where id = ?", [$existe_sub[0]->id]);
                }
            }

            $e_ = DB::delete("DELETE from tbl_orc_promocao where orc_id = ? and (cargo_atual_id = ? and turma_atual_id = ? and tipo_table = 'F' and periodo = ? and lotacao_id = ?) or (cargo_promovido_id = ? and turma_promovida_id = ? and tipo_table = 'F' and periodo = ? and lotacao_promovida_id = ?)", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['periodo'], $form_data['lotacao_id']]);

            $f = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_orc_salario_funcionario where orc_id = ? and tipo_table = 'F' and orc_cargo_id = ? and orc_turma_id = ? and lotacao_id = ? and periodo = ? and tipo = 1) and tbl_origem = 'tbl_orc_salario_funcionario'", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['lotacao_id'], $form_data['periodo']]);
            $g = DB::delete("DELETE from tbl_orc_salario_funcionario where orc_id = ? and tipo_table = 'F' and orc_cargo_id = ? and orc_turma_id = ? and lotacao_id = ? and periodo = ? and tipo = 1", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['orc_turma_id'], $form_data['lotacao_id'], $form_data['periodo']]);
            
            $h = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_orc_ferias where orcamento_id = ? and orc_turma_id = ? and cargo_id = ? and periodo = ? and tipo_table = 'F') and tbl_origem = 'tbl_orc_ferias'", [$form_data['orc_id'], $form_data['orc_turma_id'], $orc_cargo_id[0]->id, $form_data['periodo']]);
            $i= DB::delete("DELETE FROM tbl_orc_ferias where orcamento_id = ? and orc_turma_id = ? and cargo_id = ? and periodo = ? and tipo_table = 'F'", [$form_data['orc_id'], $form_data['orc_turma_id'], $orc_cargo_id[0]->id, $form_data['periodo']]);
            
            $j = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and periodo = ? and orc_turma_id = ? and tipo_table = 'F') and tbl_origem = 'tbl_headcount_hra_extra'", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['periodo'], $form_data['orc_turma_id']]);
            $k = DB::delete("DELETE from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and periodo = ? and orc_turma_id = ? and tipo_table = 'F'", [$form_data['orc_id'], $orc_cargo_id[0]->id, $form_data['periodo'], $form_data['orc_turma_id']]);
            
            // dd($a,$b,$c,$d,$e_,$f,$g,$h,$i,$j,$k);
            $this->calcHeadcount($form_data['orc_id'], $form_data['lotacao_id'], 1, $form_data['periodo']);

            /*$dados = array('lotacao_id'=>$form_data['lotacao_id'], 'orc_id'=>$form_data['orc_id'], 'id_princ'=>null);
            for($i = 1; $i <= 12; $i++){
                $result = $this->validaDistribuicao($i, $form_data['periodo'], $dados);

                if( $result === false){
                    $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Erro';
                    DB::rollBack();
                    goto saida;
                }
            }*/

            $dados = $this->validaValoresNegativos($form_data['orc_id'], $form_data['lotacao_id'], $form_data['periodo'], 'F');
            if(count($dados) > 0){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }
            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar. Erro: 190120211830c.'.$e);
        }
        $retorno['msg'] = 'Registro deletado com sucesso!';
        $retorno['status'] = 'success';
        saida:
        ($retorno['status'] == 'error') ? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function liberarOrcLotacoesForecast($orc_id, $periodo){
        DB::beginTransaction();
        $usuario_id = $this->fillModificadoPor();
        $retorno = null;
        try {                   
            
            $sql = "EXEC gerar_orc_lotacao_forecast :orc_id, :periodo, :usuario_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Falha ao liberar Forecast";
                $retorno['msg'] = 'Falha ao atualizar registro. Erro: 200120211350 | gerar_orc_lotacao_forecast';
                DB::rollBack();
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage();
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros atualizado com sucesso!";
        return $retorno;
    }
    public function novoLiberar($orc_id, $periodo){
        // $retorno = $this->liberarOrcFuncionario($orc_id, $periodo);
        // if($retorno['status'] == 'error'){
        //     DB::rollBack();
        //     return $retorno;
        // }

        $retorno = $this->liberarHd($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarDemissoes($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarContratacoes($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarPromocoes($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarAumentoSalarial($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarFerias($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno = $this->liberarHoraExtra($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            return $retorno;
        }

        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Forecast Liberado com sucesso!";
        return $retorno;
    }

    private function liberarHd($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();

            $sql = "EXEC libera_headcount_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Forecast. Erro: 200120211337 | libera_headcount_forecast';
                DB::rollBack();
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_headcount_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno; 
    }

    public function liberarOrcFuncionario($orc_id, $periodo){
        // DB::beginTransaction();
        try {

            $sql = "EXEC sp_atualiza_orc_funcionario_forecast :orc_id, :periodo";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Controle de Funcionários. Erro: 050220210833 | sp_atualiza_orc_funcionario_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - sp_atualiza_orc_funcionario_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarDemissoes($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();

            $sql = "EXEC libera_demissoes_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Demissões. Erro: 050220210834 | libera_demissoes_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_demissoes_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarContratacoes($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();

            $sql = "EXEC libera_contratacoes_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Contratações. Erro: 050220210835 | libera_contratacoes_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_contratacoes_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarPromocoes($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();

            $sql = "EXEC libera_promocoes_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Promoções. Erro: 050220210835b | libera_promocoes_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_promocoes_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarAumentoSalarial($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();
            
            $sql = "EXEC libera_aumentos_salariais_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Aumentos Salariais. Erro: 050220210838 | libera_aumentos_salariais_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_aumentos_salariais_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarFerias($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();
            
            $sql = "EXEC libera_ferias_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Férias. Erro: 050220210838b | libera_ferias_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_ferias_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }

    private function liberarHoraExtra($orc_id, $periodo){
        // DB::beginTransaction();
        try {                   
            $user_id = $this->fillIdUser();
            $empresa_id = $this->fillCodEmpresa();
            
            $sql = "EXEC libera_horas_extras_forecast :orc_id, :periodo, :user_id, :empresa_id";

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':empresa_id', $empresa_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = 'Falha ao liberar Horas Extras. Erro: 050220210839 | libera_horas_extras_forecast';
                return $retorno;
            } 

        }catch(\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            $retorno['msg'] = $e->getMessage().' - libera_horas_extras_forecast';
            $retorno['submsg'] = "Erro";
            $retorno['status'] = "error";
            return $retorno;
        }
        // DB::commit();
        $retorno["status"] = "success";
        $retorno["msg"] = "Registros inseridos com sucesso!";
        return $retorno;
    }
    public function getIsPrimeiroPeriodo($periodo, $orc_id){        
        $existe_periodo_anterior = DB::select("select top 1 * from tbl_orc_lot_carg_headcount where tipo_table = 'F' and orc_id = $orc_id and periodo = DATEADD(month, -1, cast('$periodo' as date)) ");
        return count($existe_periodo_anterior) == 0 ? false : true;
    }
}