<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcCargo;
use Illuminate\Support\Facades\DB;

class RepoForecastContratacoes extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcContratacoes';
    protected $form_rules = [
        'orcamento_id'      =>'required|exists:tbl_orcamento,id',
        'lotacao_id'        =>'required|exists:tbl_orc_lotacao,id',
        'orc_cargo_id'      =>'required|exists:tbl_orc_cargo,id',
        'orc_turma_id'          =>'required|exists:tbl_orc_turma,id',
        'ccusto_id'         =>'required|exists:tbl_ccusto,id',
    ]; 
    protected $rules_msg = [
        'orcamento_id.required'     =>'Por gentileza, selecione um orçamento',
        'orcamento_id.exists'       =>'Por gentileza, selecione um orçamento',
        'tbl_orc_lotacao.required'       =>'Por gentiliza, selecione uma lotação',
        'tbl_orc_lotacao.exists'         =>'Por gentiliza, selecione uma lotação',
        'orc_cargo_id.required'     =>'O campo Cargo é obrigatório',
        'orc_cargo_id.exists'       =>'O campo Cargo é obrigatório',
        'ccusto_id.required'        =>'Por gentiliza selecione um centro de custo',
        'ccusto_id.exists'          =>'Por gentiliza selecione um centro de custo',
        'orc_turma_id.required'         =>'O campo Turma é obrigatório',
        'orc_turma_id.exists'           =>'O campo Turma é obrigatório',
    ]; 
     

    public function createContratacoes($data_request){
        $instance = $this;
        
        $hasErro = false;

        DB::transaction(function()use(&$hasErro, &$retorno, $data_request, $instance){

            $data_request = array_merge($data_request, $data_request['meses']);

            // $data_request['orc_cargo_id'] = OrcCargo::where([
            //     ['cargo_id', $data_request['cargo_id']],
            //     ['orcamento_id', $data_request['orcamento_id']]
            // ])->first()->id;
            
            if($instance->validaInsert($data_request, $retorno, $hasErro)){
                $repo_calc_orcamento = new RepoCalcOrcamento();
                
                $meses = $instance->dataFilterMesesCalcOrcamento($data_request);
                $data = $instance->dataFilterContratacoes($data_request);
                $data = $instance->putCargoIdOnData($data,$data['orc_cargo_id']);
                
                if(!$instance->hasCargoTurmaNaLotacao($data)){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'O Cargo selecionado não foi encontrado nessa Turma. Erro: 140920201128';
                    $retorno['submsg'] = 'Erro';
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;                  
                }
                //dd("nao entrou em hasCargoTurmaNaLotacao, isso quer dizer que possui");
                $id_orc_contratacoes = $instance->checkHeadcount($data);
                
                if(!$id_orc_contratacoes){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = $instance->getErrosFlatted();
                    $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 140920201128';
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }   
                
                
                $merge_tb_calc = [
                    'origem_id' => $id_orc_contratacoes->id,
                    'tbl_origem' => $instance->getModelEntity()->getTable()
                ];

                
                if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses))){
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 140920201129';
                    $retorno['msg']=$repo_calc_orcamento->getErrosFlatted();
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }

                $repoForecast = new RepoForecast();
                $mes_ini = 1;// intval(substr($data['periodo'], 5, 2), 10);
                // if($mes_ini == 13){
                //     $mes_ini = 1;
                // }

                // for ($i = $mes_ini; $i <= 12 ; $i++) { 
                //     if(!$repoForecast->validaDistribuicao($i, $data['periodo'], $data)){
                //         $retorno['status'] = "error";
                //         $retorno['msg'] = "Impossível realizar operação, pois a distribuição dos valores em Cargo/Turma assumira um valor negativo. Erro: 261220201517";
                //         $retorno['submsg'] = 'Erro';                        
                //         $hasErro = true;
                //         abort(500, $retorno['msg']);
                //         DB::rollBack();
                //         return false;
                //     }
                // }
                
                if(!$repoForecast->calcHeadcount($data['orcamento_id'], $data['lotacao_id'], $mes_ini, $data['periodo'])){
                    $retorno['status'] = "error";
                    $retorno['msg'] = $repoForecast->getErrosFlatted();
                    $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 140920201130';                        
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }
        });

        if($hasErro){
            goto saida;
        }

        $retorno["submsg"] = "Sucesso!";
        $retorno["status"] = "success";
        $retorno["msg"] = "Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;
    }

    public function validaInsertUpdateNegativo(){
        $headcount = new RepoHeadcount();
        $calc = new CalcOrcamento();

        $select_hd = $headcount->getModelEntity()
        ->join($calc->getTable(), $headcount->getModelEntity()->getColunaAlias('id'), $calc->getColunaAlias('origem_id'))
        ->select()
        ->where($calc->getColunaAlias('tbl_origem'), 'tbl_orc_lot_carg_headcount')
        ->get()->toArray();

        dd($select_hd);
    }

    public function updateContratacoes($form_data){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $calc_orc_id = $form_data['id'];
        $meses_calc_orc = $this->dataUpdateContratacoes($form_data); 
        
        DB::beginTransaction();
        if(!$calc_orc_id){
            $retorno['msg'] = 'Registro não encontrado!';
            $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201038';
            goto saida;  
        }
        $calc_orc = $repo_calc_orcamento->getModelEntity()->find($calc_orc_id);
        
        insereValorArray($meses_calc_orc, ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado',
        'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado']);

        if(!$repo_calc_orcamento->update($meses_calc_orc, $calc_orc_id)){  
            $retorno['msg'] = $this->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201041';
            goto saida;               
        }     
        
        if(!$calc_orc){  
            $retorno['msg'] = "Não foi possível encontrar esse registro!";
            $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201042';
            goto saida;               
        }  

        $orc_contratacao = $this->getModelEntity()->find($calc_orc->origem_id);

        if(!$orc_contratacao){  
            $retorno['msg'] = "Não foi possível encontrar essa contratação!";
            $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201042';
            goto saida;               
        }  
        
        // update campo de auditoria
        // $update = DB::update("UPDATE tbl_orc_headcount_contratacoes SET updated_at = ?, updated_by = ? where id = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $orc_contratacao['id']]);
        
        $repoForecast = new RepoForecast();
        $mes_ini = 1;// intval(substr($form_data['periodo'], 5, 2), 10);
        // if($mes_ini == 13){
        //     $mes_ini = 1;
        // }
        if(!$repoForecast->calcHeadcount($orc_contratacao['orcamento_id'], $form_data['lotacao_id'], $mes_ini, $form_data['periodo'])){
            $retorno['status'] = "error";
            $retorno['msg'] = $repoForecast->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 290420201601';                        
            goto saida;               
        }  
        
        /*$dados = array('lotacao_id'=>$form_data['lotacao_id'], 'orc_id'=>$orc_contratacao['orcamento_id'], 'id_princ'=>null);
        for($i = 1; $i <= 12; $i++){
            $result = $repoForecast->validaDistribuicao($i, $form_data['periodo'], $dados);

            if( $result === false){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                DB::rollBack();
                goto saida;
            }
        }*/

        $dados = $this->validaValoresNegativos($orc_contratacao['orcamento_id'], $form_data['lotacao_id'], $form_data['periodo'], 'F');
        if(count($dados) > 0){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            DB::rollBack();
            goto saida;
        }
        DB::commit();

        $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
        saida:
        return $retorno;
        
        
    }


    public function validaInsert($data_request, &$retorno, &$hasErro){
        
        $existe = $this->getModelEntity()::where([
            ['orc_cargo_id', $data_request['orc_cargo_id']],
            ['orcamento_id', $data_request['orcamento_id']],
            ['lotacao_id', $data_request['lotacao_id']],
            ['orc_turma_id', $data_request['orc_turma_id']],
            ['ccusto_id', $data_request['ccusto_id']],
            ['tipo_table', $data_request['tipo_table']],
            ['periodo', $data_request['periodo']]
        ])->count();

        if($existe != 0){
            $retorno['status'] = 'error';         
            $retorno['msg'] = 'Esse registro já existe!';
            $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 140920201128';
            $hasErro = true;
            return false;
        }

        return true;
    }

    public function dataUpdateContratacoes($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['meses', 'funcionario_id', 'orc_id', 'lotacao_id','cargo_id','orc_turma_id', 'lotacao_responsavel','orcamento_id','type', 'orc_cargo_id', 'ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterContratacoes($data){
        $array_orcamento=['meses','tbl_origem','cargo_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function getCargoContratacao($orc_id, $lotacao_id){
        // $repo_cargo_area_sal = new RepoOrcLotacaoCargoSal();

        // $cargos = $repo_cargo_area_sal->getModelEntity()
        // ->with(['getCargo'=>function($query){ 
        //     return $query->with('getCargo'); 
        // }])
        // ->where('lotacao_id',$lotacao_id)
        // ->where('orcamento_id',$orc_id)
        // ->get()->toArray();

        // $data_cargo = [];
        // foreach ($cargos as $cargo) {
        //     array_push($data_cargo, [
        //         'description_cargo'=>$cargo['get_cargo']['get_cargo']['cod_cargo_basic'] . ' - ' .$cargo['get_cargo']['get_cargo']['des_cargo_basic'],
        //         'id' => $cargo['cargo_id']
        //     ]);
        // }

        $orc_cargo = new OrcCargo();
        $repo_usuario = new RepoUsuario();

        $user = $repo_usuario->getModelEntity()->select('funcionario_id', 'tipo')->with([
            'getFuncionario'=>function($query){
                return $query->with('getCargo');
            }
        ])->find($this->getUserFromCurrentGuard()->id);

        if(!$user){
            return [];
        }

        $gs_usuario = substr($user->getFuncionario->getCargo->cod_cargo_basic, 0, 2);

        $cargos = $orc_cargo
        ->with(['getCargo'=>function($query){ 

        }])->where('orcamento_id',$orc_id)->get()->toArray();
        $data_cargo = [];
        foreach ($cargos as $cargo) {
            if(substr($cargo['get_cargo']['cod_cargo_basic'], 0, 2) > $gs_usuario && $user->tipo != 3){
                continue;
            }
            array_push($data_cargo, [
                'description_cargo'=>$cargo['get_cargo']['cod_cargo_basic'] . ' - ' .$cargo['get_cargo']['des_cargo_basic'],
                'id' => $cargo['id']
            ]);
        }

        return $data_cargo;

    }

    public function hasCargoTurmaNaLotacao($data){
        $repo_forecast = new RepoForecast();
        
        $data_compare = [
            'orc_id' => $data['orcamento_id'],
            'lotacao_id' => $data['lotacao_id'],
            'orc_cargo_id' => $data['orc_cargo_id'],
            'ccusto_id' => $data['ccusto_id'],
            'orc_turma_id' => $data['orc_turma_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo'=>$data['periodo']
        ];
        $headcount = $repo_forecast->getModelEntity()->where($data_compare)->get()->count();
        
        if(!$headcount){
            $data_insert = array_merge($data_compare,[            
                'qtd_func_lot' => 0,
                'atual_total' => 0,
                'forecast_anterior' => 0,
                'forecast_total' => 0,
                'fromMeses' => false,
                'quadroAtual' => 0,
            ]);
            
            $createHeadcount = $repo_forecast->createForecast($data_insert);
            if($createHeadcount['status'] != 'success'){
                $this->setError($repo_forecast->getErrosFlatted());
                return false;
            }
        }

        return true;
    }
}