<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcamlotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;

use Illuminate\Support\Facades\DB;
 
class RepoForecastDemissoes extends RepoOrcamento
{
     protected $model_name_space='App\Modules\Natureza51\Entities\OrcHeadcountDemissoes';

     public function getOrcCargoById($id, $orc_id, $periodo){
        $select = DB::select("SELECT id from tbl_orc_cargo where orcamento_id = ? and cargo_id = ? and periodo = '{$periodo}' and tipo_table = 'F' ", [$orc_id, $id]);
        return count($select) > 0 ? $select[0]->id : $id;
     }
     public function existePromocao($orc_id, $func_id, $tipo_table, $periodo){
        $confere = DB::select("select top 1 * from tbl_orc_promocao where orc_id = ? and tipo_table = ? and periodo = '$periodo' and funcionario_id = ? order by mes_promocao desc", [$orc_id, $tipo_table, $func_id]);
        return count($confere) > 0 ? $confere : false;
     }

    public function created($data_request){     
         
        $data_request['mes'] = (!isset($data_request['mes'])) ? 0 : $data_request['mes'];
        if( $data_request['tipo'] == 2 ){
            // se retornar true o existePromocao(), eu vejo se existe nesse mes da demissao
            $existe_prom = $this->existePromocao($data_request['orcamento_id'], $data_request['func_id'], $data_request['tipo_table'], $data_request['periodo']);
            if($existe_prom !== false){
                if($existe_prom[0]->mes_promocao >= $data_request['mes']){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'O funcionário selecionado foi promovido no mesmo mês ou no mês posterior!<br>Erro: 300920201030';
                    goto saida;
                }
                
                // && $this->existePromocao($data_request['orcamento_id'], $data_request['func_id'], $data_request['mes'], $data_request['tipo_table'])
                $data_request['lotacao_id'] = $existe_prom[0]->lotacao_promovida_id;
                $data_request['orc_cargo_id'] = $existe_prom[0]->cargo_promovido_id;
                $data_request['ccusto_id'] = $existe_prom[0]->ccusto_promovido_id;
                $data_request['orc_turma_id'] = $existe_prom[0]->turma_promovida_id;
            }
        }
        
        $clausule = array(
            'orcamento_id'=>$data_request['orcamento_id'],
            'ccusto_id'=>$data_request['ccusto_id'],
            'lotacao_id'=>$data_request['lotacao_id'],
            'orc_cargo_id'=>$data_request['orc_cargo_id'],
            'orc_turma_id'=>$data_request['orc_turma_id'],
            'tipo'=>$data_request['tipo'],
            'mes'=>$data_request['mes'],
            'tipo_table'=>$data_request['tipo_table'],
            'periodo'=>$data_request['periodo']
        ); 

         
        $clausuleFunc = array(
            'orcamento_id'=>$data_request['orcamento_id'],
            'func_id'=>$data_request['func_id'],
            'tipo_table'=>$data_request['tipo_table'],
            'periodo'=>$data_request['periodo']
        ); 
        
        if(array_key_exists('func_id',$data_request) && ($data_request['func_id'] != null || $data_request['func_id'] != 0)){
            if($this->funcionarioEstabilidade($data_request['func_id'])){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Funcionário selecionado possui estabilidade!';
                goto saida;
            }
        }
        // $a = $this->getQuadroAtual($data_request['orcamento_id'],$data_request['lotacao_id'],$data_request['orc_cargo_id']);
        
        // $valida = $this->validateQuadroAtual($a,$data_request['meses_orcado']);
        
        // if($valida['status']=='error'){
        //     return $valida;
        // }




        if($this->hasDataOnDB($clausule)){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }

          
        if($this->hasDataOnDB($clausuleFunc) && $data_request['tipo'] == 2){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
            
        }

        $headcount = new OrcamLotCargoHeadcount();
        $data_request['orc_cargo_id'] = $this->getOrcCargoById($data_request['orc_cargo_id'], $data_request['orcamento_id'], $data_request['periodo']);
                
        if($data_request['tipo'] == 2){
            if(!$this->hasCargoTurmaNaLotacao($data_request)){                    
                $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . '. Erro: 210920201028.');
                goto saida;
            }
        }

        $dados_hc = $headcount
        ->where([
            ['orc_id',$data_request['orcamento_id']],
            ['lotacao_id', $data_request['lotacao_id']],
            ['orc_cargo_id', $data_request['orc_cargo_id']],
            ['orc_turma_id', $data_request['orc_turma_id']],
            ['tipo_table', $data_request['tipo_table']],
            ['periodo', $data_request['periodo']]
        ])
        ->first();
        
        if($dados_hc == null){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Falha ao inserir registro. Dados não encontrados no Forecast!';
                goto saida;
        }
        $calc_orc = CalcOrcamento::where('tbl_origem',$headcount->getTable())->where('origem_id', $dados_hc->id)->first()->toArray();
        // dd("eeee", $calc_orc);
        $meses_hc= [1=>'jan_orcado',
                    2=>'fev_orcado',
                    3 =>'mar_orcado',
                    4 =>'abr_orcado',
                    5 =>'mai_orcado',
                    6 =>'jun_orcado',
                    7 =>'jul_orcado',
                    8 =>'ago_orcado',
                    9 =>'set_orcado',
                    10=>'out_orcado',
                    11=>'nov_orcado',
                    12=>'dez_orcado'];

        $demissao_sigilosa = ($data_request['tipo'] == 2 && $data_request['lotacao_id'] != $data_request['lotacao_origem_id']) ? true : false;

        

        if($data_request['tipo'] == 2 || $data_request['tipo'] == 3){
            $mes_demissao = $data_request['mes'];
            $qtde_pessoas = $data_request['tipo'] == 3 ? $data_request['qtde_pessoas'] : 1;
            
            if($qtde_pessoas > $calc_orc[$meses_hc[$mes_demissao]] && !$demissao_sigilosa){                
                $retorno['status'] = 'error'; 
                $retorno['msg'] = 'Falha ao inserir registro. Número de demissões maior que o Forecast!';
                goto saida;
            }
        }
           
        else {

            foreach ($meses_hc as $key => $mes) {
                //  dd("valor_mes", $data_request['meses_orcado']);
                $valor_mes = isset($data_request['meses_orcado'][$mes]) ? $data_request['meses_orcado'][$mes]: 0;
            
                if($calc_orc[$mes] <  $valor_mes){
                    // dd($valor_mes, $mes, $calc_orc);
                    // dd("calc_orc_mes", $calc_orc[$mes], $mes, $valor_mes);
                    // if($valor_mes < $calc_orc[$mes]){  
                    $retorno['status'] = 'error'; 
                    $retorno['msg'] = 'Falha ao inserir registro. Número de demissões maior que o Forecast!';
                    goto saida;
                }    
                for ($i=$key; $i <= 12; $i++) { 
                    // dd($valor_mes, $mes, $calc_orc);
                //    if($valor_mes > 0){
                //     dd($valor_mes, $mes, $calc_orc);
                //    }
                    $calc_orc[$meses_hc[$i]] =  $calc_orc[$meses_hc[$i]] - $valor_mes;
                }
            }
        }
        
        $repo_calc_orcamento = new RepoCalcOrcamento();
        DB::beginTransaction();
        
        try {
            $repoForecast = new RepoForecast();

            $mes_ini = 1;//intval(substr($data_request['periodo'], 5, 2), 10);
            // if($mes_ini == 13){
            //     $mes_ini = 1;
            // }
            
            // $orc_func = new OrcFuncionario();
   
            $func = OrcFuncionario::where('orcamento_id',$data_request['orcamento_id'])
            ->where('funcionario_id', $data_request['func_id'])
            ->where('tipo_table', $data_request['tipo_table'])
            ->where('periodo', $data_request['periodo'])
            ->first();
           
            if($func){
                if($func->cargo_atualizado == 0){
                    $func->orc_cargo_id=$data_request['orc_cargo_id'];
                    $func->orc_turma_id=$data_request['orc_turma_id'];
                    $func->cargo_atualizado = 1;
                    $func->updated_by = $this->fillModificadoPor();
                    $func->updated_at = $this->fillModificadoEm();
                    
                    $func->save();
                }
            }

            if($data_request['tipo'] == 2){
                if(!$this->hasCargoTurmaNaLotacao($data_request)){                    
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . '. Erro: 210920201028.');
                    goto saida;
                }
            }

            if($demissao_sigilosa){
                $data_request['l_sec'] = 1;
            }

            

            $id_orc_demissoes = $this->createParent($data_request);

            if(!$id_orc_demissoes){  
                // dd("nsjs30");

                $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted());
                goto saida;
            }  

            if($data_request['tipo'] == 1){

               

                $merge_tb_calc = [
                    'origem_id' => $id_orc_demissoes->id,
                    'tbl_origem' => $this->getModelEntity()->getTable()
                ];
                $meses = ['jan_orcado', 'fev_orcado', 'mar_orcado' ,'abr_orcado' ,'mai_orcado' ,'jun_orcado' ,'jul_orcado' ,'ago_orcado' ,'set_orcado' ,'out_orcado' ,'nov_orcado' ,'dez_orcado'];
                for($i = 0; $i < 10; $i++){
                    if( !array_key_exists($meses[$i], $data_request['meses_orcado']) ){
                        $data_request['meses_orcado'][$meses[$i]] = 0;
                    }
                }
                if(!$repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                    $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Erro: 13020201726.');
                    goto saida;
                }
            } 

            
            if(!$repoForecast->calcHeadcount($data_request['orcamento_id'], $data_request['lotacao_id'], $mes_ini, $data_request['periodo'])){
                $retorno['status']="error";
                $retorno['msg']=$repoForecast->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201112';                        
                $hasErro = true;
                abort(500, $retorno['msg']);
                return false;
            }

            /*$dados = array('lotacao_id'=>$data_request['lotacao_id'], 'orc_id'=>$data_request['orcamento_id'], 'id_princ'=>null);
            for($i = 1; $i <= 12; $i++){
                $result = $repoForecast->validaDistribuicao($i, $data_request['periodo'], $dados);
    
                if( $result === false){
                    $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Erro';
                    DB::rollBack();
                    goto saida;
                }
            }*/
            
            $dados = $this->validaValoresNegativos($data_request['orcamento_id'], $data_request['lotacao_id'], $data_request['periodo'], 'F');
            if(count($dados) > 0 && !$demissao_sigilosa){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }

            $msg_success = $demissao_sigilosa ? 'Demissão inserida com sucesso! <br> A demissão sigilosa cadastrada se encontra na lotação a contabilizar informada.' : 'Registro inserido com sucesso!';

            $retorno = array('status'=>'success','msg'=>$msg_success);
            goto saida;

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir o registro. Erro: 130120201728.'. $e);
        }
  

        saida:
        ($retorno['status']=='error') ? DB::rollBack() : DB::commit();
       
        return $retorno;
    }

    public function funcionarioEstabilidade($func_id){
        $select = DB::select("SELECT id, tp_estabi FROM tbl_funcionario where id = {$func_id} and tp_estabi = 1");
        return count($select) > 0 ? true : false;
    }
    public function hasCargoTurmaNaLotacao($data){
        $repo_forecast = new RepoForecast();

        $data_compare = [
            'orc_id' => $data['orcamento_id'],
            'lotacao_id' => $data['lotacao_id'],
            'orc_cargo_id' => $data['orc_cargo_id'],
            'ccusto_id' => $data['ccusto_id'],
            'orc_turma_id' => $data['orc_turma_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo' => $data['periodo']
        ];
        // DB::enableQueryLog();
        $headcount = $repo_forecast->getModelEntity()->where($data_compare)->get()->count();
        // dd(DB::getQueryLog());
        if($headcount){
            return true;
        }
        
        $data_insert = array_merge($data_compare,[            
            'qtd_func_lot' => 0,
            'atual_total' => 0,
            'forecast_anterior' => 0,
            'forecast_total' => 0,
            'fromMeses' => false,
            'quadroAtual' => 0,
        ]);
        $createHeadcount = $repo_forecast->createForecast($data_insert);
        if($createHeadcount['status'] == 'error'){
            $this->setError($repo_forecast->getErrosFlatted());
            return false;
        }

        return true;
    }

    public function createParent($data_request){
        $data_request = $this->putCargoIdOnData($data_request,$data_request['orc_cargo_id']);
        
        return parent::checkHeadcount($data_request);
    }

    public function deleteAll($value){
        // $repo_calc_orc = new RepoCalcOrcamento();
        
        $orc_cargo = OrcCargo::where('orcamento_id', $value['orcamento_id'])
        ->where('cargo_id', $value['cargo_id'])
        ->where('periodo', $value['periodo'])
        ->where('tipo_table', 'F')
        ->first();
        
        if(!$orc_cargo){
            $retorno = array('status'=>'error','msg'=>'Cargo não encontrado. Erro: 210920200917.');
            goto saida;
       }

       $value['orc_cargo_id'] = $orc_cargo->id;
       unset($value['cargo_id']);
        
        DB::beginTransaction();
        try {
            $id = $this->getModelEntity()->select('id')->where($value)
                ->where('tipo_table', 'F')
                ->where('periodo', $value['periodo'])->get()->toArray();

            if(count($id) > 0){
                if($this->deleteDiarioBordo($id[0]['id'], 'tbl_orc_headcount_demissoes') == false){
                    $retorno = array('status'=>'error','msg'=>'Falha ao deletar Diário de Bordo. Erro: 230320211009');
                    goto saida;
                }
            }
            $all = $this->getModelEntity()->select('id')->where($value)
            ->where('tipo_table', 'F')
            ->where('periodo', $value['periodo'])
            ->delete();
            
            if(!$all){
                $retorno = array('status'=>'error','msg'=>'Falha ao deletar registro. Erro: 210920200917b.');
                goto saida;
            }

            $repoForecast = new RepoForecast();

            $mes_ini = 1;//intval(substr($value['periodo'], 5, 2), 10);
            // if($mes_ini == 13){
            //     $mes_ini = 1;
            // }

            if(!$repoForecast->calcHeadcount($value['orcamento_id'], $value['lotacao_id'], $mes_ini, $value['periodo'])){
                $retorno['status'] = "error";
                $retorno['msg'] = $repoForecast->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 210920200917c';                        
                goto saida;               
            }  

            // $dados = array('lotacao_id'=>$value['lotacao_id'], 'orc_id'=>$value['orcamento_id'], 'id_princ'=>null);
            // for($i = 1; $i <= 12; $i++){
            //     $result = $repoForecast->validaDistribuicao($i, $value['periodo'], $dados);
    
            //     if( $result === false){
            //         $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            //         $retorno['status'] = 'error';
            //         $retorno['submsg'] = 'Erro';
            //         DB::rollBack();
            //         goto saida;
            //     }
            // }

            $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso.');

        } catch (\Exception $th) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro. Erro: 210920200918.');
        }
        
        saida:
        $retorno['status'] == 'success' ? DB::commit() : DB::rollBack();
        return $retorno;
    }

    public function validateQuadroAtual($quadro_atual,$meses){
        $cont =0;
        foreach ($meses as $mes) {
            if($mes > $quadro_atual[0]['qtd_func_lot']){
                return ['status'=>'error','msg'=>'Não é permitido demitir mais funcionário do que o quadro atual. Erro: 20320201602'];
            }
            if($cont > $quadro_atual[0]['qtd_func_lot']){
                //dd($cont);
                return ['status'=>'error','msg'=>'Não é permitido demitir mais funcionário do que o quadro atual. Erro: 20320201623'];
            }
            if($mes != null){
                // $cont++;
                $cont+=$mes;
                // dd($cont);
            }
        }
        return ['status'=>'success'];
    }

    


}