<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Entities\OrcParametros;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\Parametros;
use App\Modules\Natureza51\Entities\Usuario;

class RepoForecastFerias extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcFerias';
    protected $form_rules=[
        'orcamento_id'=>'required',
        'lotacao_id'=>'required',
        'cargo_id'=>'required',
        // 'lotacao_responsavel'=>'required', 
        'orc_turma_id'=>'required',
        // 'type'=>'required|string|max:1|min:1'
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'=>'Por gentileza, selecione um orçamento',
        'lotacao_id.required'=>'Por gentiliza, selecione uma lotação',
        'cargo_id.required'=>'O campo Cargo é obrigatório',
        // 'lotacao_responsavel.required'=>'Por gentiliza selecione uma lotaçao responsável',
        'required'=>'O campo Turma é obrigatório',
        // 'type.required'=>'O campo Tipo é obrigatório'
    ]; 
      
    public function listarByTurma($orc_id, $lotacao_id, $periodo, $tipo_table){

        $tbl_calc_orc = new CalcOrcamento(); //table for month;
        $tbl_lotacao = new OrcLotacao(); // table for lotação
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tbl_turma = new OrcTurma();
        $tbl_cargo = new Cargo();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_orc_ferias = new OrcFerias();
        // DB::enableQueryLog();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tbl_usuario = new Usuario();
     
        $data = $tbl_orc_ferias->join(
            $tbl_lotacao->getTable(),$tbl_orc_ferias->getColunaAlias('lotacao_id'),'=',$tbl_lotacao->getColunaAlias('id')
            )
            ->join(
                $tbl_calc_orc->getTable(),
                $tbl_orc_ferias->getColunaAlias('id'),'=', 
                DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
                                {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_ferias->getTable()}'")
            )
            ->join(
                $tbl_turma->getTable(),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),'=',$tbl_turma->getColunaAlias('id')
            )

            ->join(
                $tb_turno->getTable(),
                $tbl_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))
            ->join(
                $tbl_orc_cargo->getTable(), $tbl_orc_ferias->getColunaAlias('cargo_id'),'=',$tbl_orc_cargo->getColunaAlias('id')
            )
            
            ->join($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))
            ->join(
                $tb_orcamLot_cargo_headcount->getTable(),
                $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',

                DB::raw("{$tbl_orc_ferias->getColunaAlias('lotacao_id')}   
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = 
                {$tbl_orc_ferias->getColunaAlias('cargo_id')}              
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tbl_orc_ferias->getColunaAlias('orc_turma_id')}
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')} = {$tbl_orc_ferias->getColunaAlias('ccusto_id')}
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tbl_orc_ferias->getColunaAlias('tipo_table')}
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')} = {$tbl_orc_ferias->getColunaAlias('periodo')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$tbl_orc_ferias->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $tbl_calc_orc->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )

            ->select(
                $tbl_orc_ferias->getColunaAlias('id'),
                $tbl_orc_ferias->getColunaAlias('lotacao_id'),
                $tbl_cargo->getColunaAlias('des_cargo_basic'),
                // $tb_turma->getColunaAlias('des_turma_trab'), 
                DB::raw("CONCAT({$tb_turno->getColunaAlias('cdn_turno_trab')}, ' - ', {$tb_turno->getColunaAlias('des_turno_trab')}) as des_turno_trab"),
                // $tbl_lotacao->getColunaAlias('des_unid_lotac'),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),
                $tbl_orc_ferias->getColunaAlias('type'),
                $tbl_orc_ferias->getColunaAlias('orcamento_id'),
                DB::raw("CONCAT({$tbl_turma->getColunaAlias('cdn_turma_trab')}, ' - ', {$tbl_turma->getColunaAlias('des_turma_trab')}) as des_turma_trab"),
                $tbl_orc_ferias->getColunaAlias('cargo_id'),
                DB::raw("{$this->getModelEntity()->getColunaAlias('cargo_id')}+null as parent"),
                $tbl_orc_ferias->getColunaAlias('lotacao_responsavel'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
                $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),
                DB::raw("concat({$tbl_cargo->getColunaAlias('cod_cargo_basic')}, ' - ',{$tbl_cargo->getColunaAlias('des_cargo_basic')}) AS cargo"),

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jan_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jan, 
                {$tbl_calc_orc->getColunaAlias('jan_orcado')}"),

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('fev_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_fev, 
                {$tbl_calc_orc->getColunaAlias('fev_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('mar_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')},  
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_mar, 
                {$tbl_calc_orc->getColunaAlias('mar_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('abr_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_abr, 
                {$tbl_calc_orc->getColunaAlias('abr_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('mai_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_mai, 
                {$tbl_calc_orc->getColunaAlias('mai_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jun_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jun, 
                {$tbl_calc_orc->getColunaAlias('jun_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jul_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jul, 
                {$tbl_calc_orc->getColunaAlias('jul_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('ago_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_ago, 
                {$tbl_calc_orc->getColunaAlias('ago_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('set_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_set, 
                {$tbl_calc_orc->getColunaAlias('set_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('out_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_out, 
                {$tbl_calc_orc->getColunaAlias('out_orcado')}"),
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('nov_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_nov, 
                {$tbl_calc_orc->getColunaAlias('nov_orcado')}"), 
                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('dez_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},{$tbl_orc_ferias->getColunaAlias('tipo_table')},{$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_dez, 
                {$tbl_calc_orc->getColunaAlias('dez_orcado')}"),

                DB::raw("CASE WHEN {$tbl_orc_ferias->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_orc_ferias->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")

            )
            ->where([
                        [ $tbl_orc_ferias->getColunaAlias('orcamento_id'), '=', $orc_id],
                        ['type','=',0],
                        [$tbl_orc_ferias->getColunaAlias('lotacao_id'), '=', $lotacao_id],
                        [$tbl_orc_ferias->getColunaAlias('tipo_table'),$tipo_table],
                        [$tbl_orc_ferias->getColunaAlias('periodo'),$periodo]
                ])
            ->get()
            ->toArray();
        
       
        return ($data);  
    }

    public function listarByFuncionario($orc_id, $lotacao_id, $periodo, $tipo_table){
        
        $tbl_calc_orc = new CalcOrcamento(); //table for month;
        $tbl_lotacao = new OrcLotacao(); // table for lotação
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tbl_turma = new OrcTurma();
        $tbl_cargo = new Cargo();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_orc_ferias = new OrcFerias();
        $tbl_funcionario = new Funcionario();
        // DB::enableQueryLog();
        // $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tbl_usuario = new Usuario();

        $data = $tbl_orc_ferias->join(
            $tbl_funcionario->getTable(), $tbl_funcionario->getColunaAlias('id'), '=', $tbl_orc_ferias->getColunaAlias('func_id'))
            ->join($tbl_lotacao->getTable(),$tbl_orc_ferias->getColunaAlias('lotacao_id'),'=', DB::raw("{$tbl_lotacao->getColunaAlias('id')}"))
            ->join(
                $tbl_turma->getTable(), $tbl_turma->getColunaAlias('id'), '=', DB::raw("{$tbl_orc_ferias->getColunaAlias('orc_turma_id')}")
            )
            ->join($tb_turno->getTable(), $tbl_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))
            ->join(
                $tbl_calc_orc->getTable(),
                $tbl_orc_ferias->getColunaAlias('id'), '=', 
                DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
                                {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_ferias->getTable()}'")
            )
            ->join(
                $tbl_orc_cargo->getTable(), $tbl_orc_ferias->getColunaAlias('cargo_id'), '=',$tbl_orc_cargo->getColunaAlias('id')
            )
            ->join( $tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))
            ->join(
                $tb_orcamLot_cargo_headcount->getTable(),
                $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',

                DB::raw("{$tbl_orc_ferias->getColunaAlias('lotacao_id')}   
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = 
                {$tbl_orc_ferias->getColunaAlias('cargo_id')}              
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tbl_orc_ferias->getColunaAlias('orc_turma_id')}
                
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tbl_orc_ferias->getColunaAlias('tipo_table')}
                and {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')} = {$tbl_orc_ferias->getColunaAlias('periodo')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$tbl_orc_ferias->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $tbl_calc_orc->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
            ->select(
                $tbl_orc_ferias->getColunaAlias('id'),
                $tbl_orc_ferias->getColunaAlias('lotacao_id'),
                $tbl_funcionario->getColunaAlias('nome_funcionario'),
                $tbl_cargo->getColunaAlias('des_cargo_basic'),
                $tbl_funcionario->getColunaAlias('cdn_funcionario'),
                $tbl_turma->getColunaAlias('des_turma_trab'), 
                $tb_turno->getColunaAlias('des_turno_trab'),
                $tbl_orc_ferias->getColunaAlias('func_id'),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),
                $tbl_orc_ferias->getColunaAlias('type'),
                $tbl_orc_ferias->getColunaAlias('orcamento_id'),
                $tbl_orc_ferias->getColunaAlias('cargo_id'),
                DB::raw("{$this->getModelEntity()->getColunaAlias('type')}+null as parent"),
                $tbl_orc_ferias->getColunaAlias('lotacao_responsavel'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
                $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),
                // $tbl_calc_orc->getColunaAlias('jan_orcado'),
                // $tbl_calc_orc->getColunaAlias('fev_orcado'),
                // $tbl_calc_orc->getColunaAlias('mar_orcado'),
                // $tbl_calc_orc->getColunaAlias('abr_orcado'),
                // $tbl_calc_orc->getColunaAlias('mai_orcado'),
                // $tbl_calc_orc->getColunaAlias('jun_orcado'),
                // $tbl_calc_orc->getColunaAlias('jul_orcado'),
                // $tbl_calc_orc->getColunaAlias('ago_orcado'), 
                // $tbl_calc_orc->getColunaAlias('set_orcado'),
                // $tbl_calc_orc->getColunaAlias('out_orcado'),
                // $tbl_calc_orc->getColunaAlias('nov_orcado'),
                // $tbl_calc_orc->getColunaAlias('dez_orcado'),
                DB::raw("concat({$tbl_funcionario->getColunaAlias('cdn_funcionario')}, ' - ',{$tbl_cargo->getColunaAlias('nome_funcionario')}) AS description_funcionario"),
                DB::raw("concat({$tbl_cargo->getColunaAlias('cod_cargo_basic')}, ' - ',{$tbl_cargo->getColunaAlias('des_cargo_basic')}) AS cargo"),
                DB::raw("concat({$tbl_turma->getColunaAlias('cdn_turma_trab')}, ' - ',{$tbl_turma->getColunaAlias('des_turma_trab')}) AS turma"),
                DB::raw("concat({$tb_turno->getColunaAlias('cdn_turno_trab')}, ' - ',{$tb_turno->getColunaAlias('des_turno_trab')}) AS turno"),

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jan_orcado')}) 
                OVER(
                    partition by    {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                                    {$tbl_orc_ferias->getColunaAlias('lotacao_id')},
                                    {$tbl_orc_ferias->getColunaAlias('cargo_id')},
                                    {$tbl_orc_ferias->getColunaAlias('tipo_table')},
                                    {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jan, 
                {$tbl_calc_orc->getColunaAlias('jan_orcado')}") ,

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('fev_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_fev, 
                {$tbl_calc_orc->getColunaAlias('fev_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('mar_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')},  
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_mar, 
                {$tbl_calc_orc->getColunaAlias('mar_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('abr_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_abr, 
                {$tbl_calc_orc->getColunaAlias('abr_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('mai_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_mai, 
                {$tbl_calc_orc->getColunaAlias('mai_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jun_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jun, 
                {$tbl_calc_orc->getColunaAlias('jun_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('jul_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_jul, 
                {$tbl_calc_orc->getColunaAlias('jul_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('ago_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_ago, 
                {$tbl_calc_orc->getColunaAlias('ago_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('set_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_set, 
                {$tbl_calc_orc->getColunaAlias('set_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('out_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_out, 
                {$tbl_calc_orc->getColunaAlias('out_orcado')}"),

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('nov_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_nov, 
                {$tbl_calc_orc->getColunaAlias('nov_orcado')}"), 

                DB::raw("SUM({$tbl_calc_orc->getColunaAlias('dez_orcado')}) OVER(partition by {$tbl_orc_ferias->getColunaAlias('ccusto_id')}, 
                {$tbl_orc_ferias->getColunaAlias('lotacao_id')},{$tbl_orc_ferias->getColunaAlias('cargo_id')},
                {$tbl_orc_ferias->getColunaAlias('tipo_table')}, {$tbl_orc_ferias->getColunaAlias('periodo')}) t_event_dez, 
                {$tbl_calc_orc->getColunaAlias('dez_orcado')}"),

                DB::raw("CASE WHEN {$tbl_orc_ferias->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_orc_ferias->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")


            )
            ->where([
                    [ $tbl_orc_ferias->getColunaAlias('orcamento_id'), '=', $orc_id],
                    [$tbl_orc_ferias->getColunaAlias('type'),'=',1],
                    [$tbl_orc_ferias->getColunaAlias('lotacao_id'), '=', $lotacao_id],
                    [$tbl_orc_ferias->getColunaAlias('tipo_table'),$tipo_table],
                    [$tbl_orc_ferias->getColunaAlias('periodo'),$periodo]
                ])
            ->get()
            ->toArray();

            
            return ($data); 
    }
    public function getOrcCargoByCargo($id, $orc_id, $periodo){
        $select = DB::select('SELECT * from tbl_orc_cargo where cargo_id = ? and orcamento_id = ? and periodo = ? and tipo_table = \'F\' ', [$id, $orc_id, $periodo]);
        return count($select) > 0 ? $select[0]->id : $id;
    }
    public function insertFerias($data,$meses){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        
        /**
         * Colocar na Entitie o Campo tipo_table para diferenciar forecast de orçado
         * Quando Ajustar os métodos voltar aqui e descomentar o tipo_table 06/01/2020
         */
        
        // $data['cargo_id'] = $this->getOrcCargoByCargo($data['cargo_id'], $data['orcamento_id']);
        $data['orc_cargo_id'] = $this->getOrcCargoByCargo($data['cargo_id'], $data['orcamento_id'], $data['periodo']);
        
        $clausule = array(
            'orcamento_id'=>$data['orcamento_id'],
            'ccusto_id'=>$data['ccusto_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'cargo_id'=>$data['orc_cargo_id'],
            'orc_turma_id'=>$data['orc_turma_id'],
            'tipo_table'=>$data['tipo_table'],
            'periodo'=>$data['periodo'],
            'type'=>$data['type']
        ); 

        $data['cargo_id'] = $data['orc_cargo_id'];

        if(isset($data['func_id'])){
            $clausule['func_id'] = $data['func_id'];
        }

       
        if($this->hasDataOnDB($clausule)){
            $retorno["status"] = "error";
            $retorno['msg'] = 'Falha ao inserir o registro. Dados já cadastrados!';
            $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 170920200841';
            goto saida;
        } 
        
        DB::beginTransaction();
        try { 
            
            if(!$this->validaParametroFerias($data['orcamento_id'], array_values($meses), $data['type'])){

                $retorno["status"] = "warning";
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 170720201110.';
             
                goto saida;
            }

            $id_orc_ferias = $this->checkHeadcount($data); 

            if(!$id_orc_ferias){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 181220191458.';
                goto saida;
            }
            
            $merge_tb_calc = [
                'origem_id' =>$id_orc_ferias->id,
                'tbl_origem' => $this->getModelEntity()->getTable()
            ];

            if(isset($data['func_id'])){
                // $orc_func = new OrcFuncionario();
    
                $func = OrcFuncionario::where('orcamento_id', $data['orcamento_id'])
                ->where('funcionario_id', $data['func_id'])
                ->where('periodo', $data['periodo'])
                ->where('tipo_table', $data['tipo_table'])
                ->first();

                if($func){
                        if($func->cargo_atualizado == 0){
                            $func->orc_cargo_id = $data['cargo_id'];
                            $func->orc_turma_id = $data['orc_turma_id'];
                            $func->cargo_atualizado = 1;
                            $func->updated_by = $this->fillModificadoPor();
                            $func->updated_at = $this->fillModificadoEm();
                            

                        $func->save();
                    }
                }
            }
            $insert = array_merge($merge_tb_calc, $meses);
            // dd($insert);
            // dd("entrou a-qui0", $this->validaParametroFerias($data['orcamento_id'],array_values($meses),$data['type']));
        
            if(!$repo_calc_orcamento->create($insert)){
                $retorno['msg'] = 'Falha ao inserir o registro. Erro: 181220191459.';
                $retorno['submsg'] = $repo_calc_orcamento->getErrosFlatted();
                goto saida;
            }
            $retorno["status"] = "success";
            $retorno["msg"] = "Cadastro realizado com sucesso!";

        } catch (\Exception $e) {
            
            DB::rollBack();
            //dd("exception", $e);
            // abort(500,'Falha ao inserir registro no orçamento. Erro: 181220191500.');   
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao inserir o registro. Erro: 181220191500.';
            $retorno['submsg'] = $e->getMessage();
            goto saida; 
        }

        saida:
        // dd($retorno);
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno; 
    }

    public function deleteFerias($form_data){

        $repo_calc_orcamento = new RepoCalcOrcamento();
        $id = $form_data['id'];
        DB::beginTransaction();
        try {
            if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$id,'tbl_origem'=>$this->getModelEntity()->getTable()])->delete()){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao deletar os valores. Erro: 170920201125';
                goto saida;
            }     
            
            if(!$this->delete($id)){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao deletar dados. Erro: 170920201125';
                goto saida;
            }

            if($this->deleteDiarioBordo($id, 'tbl_orc_ferias') === false){
                $retorno["status"] = "error";
                $retorno['msg'] = "Falha ao deletar Diário de Bordo. Erro: 230320211034";
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
            $retorno["status"] = "success";
            $retorno["msg"] = "Registro deletado com sucesso!";
            $retorno["submsg"] = "Sucesso!";


        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro no orçamento. Erro: 170920201126.'.$e);   
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno; 

    }
    public function editarFerias($id, $data, $meses){
        
        $repo_calc_orcamento = new RepoCalcOrcamento();
        if(array_key_exists('funcionario',$meses)){
            unset($meses['funcionario']);
        }
        // $meses = convertDecimalEn($meses);    
        try {
            if(!$this->validaParametroFerias($data['orcamento_id'],array_values($meses),$data['type'])){
                $retorno["status"] = "warning";
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg'] = 'Falha atualizar o registro. Erro: 170920201111.';
                goto saida;
            }

            if(!$repo_calc_orcamento->update($meses,['origem_id'=>$id,'tbl_origem'=>'tbl_orc_ferias'])){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao atualizar o registro. Erro: 170920201111b';
                goto saida;               
            } 
            DB::update("UPDATE tbl_orc_ferias SET updated_at = ?, updated_by = ? where id = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $id]);
            
            // if(!$this->update($data, ['id'=>$id])){                
            // if(!$this->update($data, $id)){                    
            //     $retorno["status"] = "error";
            //     $retorno['msg'] = $this->getErrosFlatted();
            //     $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 271120191600';
            //     goto saida;               
            // }
            
            $retorno["status"] = "success";
            $retorno["msg"] = "Registro atualizado com sucesso!";
        
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro no orçamento. Erro: 170920201113ct.<br><br>'.$e);
        }
        saida:
        ($retorno['status'] == 'error') ? DB::rollBack() : DB::commit();    
        return $retorno; 
      

    }

    public function validaParametroFerias($orc_id,$meses,$tipo){
    
        $parametro = new OrcParametros();
        $par = new Parametros();
        $valor_parametro = $parametro
        ->join($par->getTable(), $parametro->getColunaAlias('parametro_id'), $par->getColunaAlias('id'))
        ->select('valor_parametro')
        ->where('orcamento_id', $orc_id)
        ->where($par->getColunaAlias('cod_parametro'),'=','PartFerias')->first();
        
        if($tipo == 0){
            return true;
        } 

        $dividiu = 0;
        $tot_dias = 0;
        for($i = 0; $i < count($meses); $i++){
            if($meses[$i]!=null && $meses[$i]!=0){
                $dividiu = $dividiu + 1;
                $tot_dias += $meses[$i];
            }

            
        }
        if($tot_dias > 30){
            $this->setError('As férias não podem ultrapassar 30 dias!');
            return false;
        }

        if($dividiu > $valor_parametro->valor_parametro){
            $this->setError('Número de partições maior que o permitido!');
            return false;

        }
      
        return true;    
    }
    
}