<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Illuminate\Support\Facades\DB;

class RepoForecastFuncoes extends RepoOrcamento{
    public $empresa_id;
    public $usuario_id;
    public $tempo;
    public $demissoes;

    public function __construct($empresa_id, $usuario_id, $tempo){
        parent::__construct();
        $this->empresa_id = $empresa_id;
        $this->usuario_id = $usuario_id;
        $this->tempo = $tempo;

        $this->demissoes = new RepoForecastDemissoes();
    }

    const STATUS_LOT_PENDENTE_DIGITACAO_FCST=9;
    const STATUS_LOT_REABERTO_FCST=10;
    const STATUS_LOT_ENVIADO_FCST=11;
    const STATUS_LOT_CONFERIDO_FCST=12; 
    const STATUS_LOT_CALCULADO_FCST=13;
    const STATUS_LOT_CALCULADO_LIBERADO_FCST=14;
    const STATUS_LOT_APROVADO_FCST=15; 
    const STATUS_LOT_APROVADO_DIRETOR_AREA_FCST=16;

    /*
        1. faz um for na headcount pelo ultimo Periodo(order by DESC) e tipo_table 'F';
        2. se não, faz um FOR na tabela de headcout(contratacao, demissão, etc)
        3. vê se teve distribuição e se é do tipo_tlabe 'O'
        
    */
    /*
        Vou pegar o ultimo forecast criado(pelos campos periodo, tipo_table) na tbl_demissoes e também filtrar pelo status e pegando o ultimo periodo
        Se for nulo ^, eu pego a demissão do tipo_table 'O', pela lotacao, distribuição e orc_id
    */
    /*
        Antes de tudo, precisa abrir um for() para cada lotacao
    */
    public function liberarTudo($dados, $orc_id, $periodo){
        // $this->inserirDemissoes($dados, $orc_id, $periodo);
        // $this->inserirContratacoes($dados, $orc_id, $periodo);
        $this->inserirPromocoes($dados, $orc_id, $periodo);
        // $this->inserirAumentoSalarial($dados, $orc_id, $periodo);
        // $this->inserirFerias($dados, $orc_id, $periodo);
        // $this->inserirHorasExtras($dados, $orc_id, $periodo); 
        // $this->inserirMovto($dados, $periodo);
    }
    public function inserirDemissoes($dados, $orc_id, $periodo){// testado, inseriu todos os registros
        set_time_limit(700);
        
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                select  hdm.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_orc_headcount_demissoes as hdm
                left join tbl_calc_orcamento as calc on calc.origem_id = hdm.id and calc.tbl_origem = 'tbl_orc_headcount_demissoes'
                where hdm.orcamento_id = $orc_id and
                hdm.tipo_table = 'F' and
                hdm.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hdm.lotacao_id = $id
                
                order by hdm.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                //$ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    select hdem.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_orc_headcount_demissoes as hdem
                    left join tbl_calc_orcamento as calc on calc.origem_id = hdem.id and calc.tbl_origem = 'tbl_orc_headcount_demissoes'
                    
                    /*Distribuição*/
                    left join tbl_orc_lot_carg_headcount as hd on
                    hdem.orcamento_id = hd.orc_id and
                    hdem.orc_cargo_id = hd.orc_cargo_id and
                    hdem.lotacao_id = hd.lotacao_id and
                    hdem.orc_turma_id = hd.orc_turma_id

                    left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'

                    where hdem.tipo_table = 'O' and hdem.orcamento_id = ? and hdem.lotacao_id = ? 
                    /*and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 ))*/
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                if(count($ultimo_criado_anterior) > 0){
                    try{
                    
                        foreach($ultimo_criado_anterior as $value){
                            // colocar validação de insert
                            $existe = DB::select("select * from tbl_orc_headcount_demissoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            if(count($existe) == 0){
                                /*$insert = DB::insert("INSERT INTO tbl_orc_headcount_demissoes(
                                    [orcamento_id]
                                    ,[lotacao_id]
                                    ,[func_id]
                                    ,[orc_cargo_id]
                                    ,[orc_turma_id]
                                    ,[ccusto_id]
                                    ,[user_id]
                                    ,[tipo]
                                    ,[qtde_pessoas]
                                    ,[tempo_casa]
                                    ,[mes]
                                    ,[empresa_id]
                                    ,[tipo_table]
                                    ,[created_at]
                                    ,[periodo]
                                    ,[created_by]
                                    ,[acordo]
                                    )VALUES($value->orcamento_id, $id, $value->func_id, $value->orc_cargo_id, $value->orc_turma_id, $value->ccusto_id, $this->fillCriadoPor(), $value->tipo, $value->qtde_pessoas, $value->tempo_casa, $value->mes, $this->fillCodEmpresa(), 'F', $this->fillCriadoEm(), $periodo, $this->fillCriadoPor(), $value->acordo)");*/

                                $data = array('orcamento_id'=>$value->orcamento_id, 'lotacao_id'=>$id, 'func_id'=>$value->func_id, 'orc_cargo_id'=>$value->orc_cargo_id, 'orc_turma_id'=>$value->orc_turma_id, 'ccusto_id'=>$value->ccusto_id, 'user_id'=>$this->fillCriadoPor(), 'tipo'=>$value->tipo, 'qtde_pessoas'=>$value->qtde_pessoas, 'tempo_casa'=>$value->tempo_casa, 'mes'=>$value->mes, 'empresa_id'=>$this->fillCodEmpresa(), 'tipo_table'=>'F', 'created_at'=>$this->fillCriadoEm(), 'periodo'=>$periodo, 'created_by'=>$this->fillCriadoPor(), 'acordo'=>$value->acordo);

                                $insert = $this->demissoes->create($data);
    
                                $get_id = DB::select("select * from tbl_orc_headcount_demissoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                                
                                $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                    [origem_id], [tbl_origem]
                                    ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                    ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                    ,[user_id], [empresa_id], [created_at], [created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_headcount_demissoes', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd("1",$e->getMessage());
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201002ct");
                        return false;
                    }
                }
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $existe = DB::select("select * from tbl_orc_headcount_demissoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                        
                        if(count($existe) == 0){
                            /*$insert = DB::insert("INSERT INTO tbl_orc_headcount_demissoes(
                                [orcamento_id]
                                ,[lotacao_id]
                                ,[func_id]
                                ,[orc_cargo_id]
                                ,[orc_turma_id]
                                ,[ccusto_id]
                                --,[user_id]
                                ,[tipo]
                                ,[qtde_pessoas]
                                ,[tempo_casa]
                                ,[mes]
                                --,[empresa_id]
                                ,[tipo_table]
                                ,[created_at]
                                ,[periodo]
                                --,[created_by]
                                ,[acordo]
                                )VALUES($value->orcamento_id, $id, $value->func_id, $value->orc_cargo_id, $value->orc_turma_id, $value->ccusto_id, $value->tipo, $value->qtde_pessoas, $value->tempo_casa, $value->mes, 'F', getdate(), $periodo, $value->acordo)");*/

                            $data = array('orcamento_id'=>$value->orcamento_id, 'lotacao_id'=>$id, 'func_id'=>$value->func_id, 'orc_cargo_id'=>$value->orc_cargo_id, 'orc_turma_id'=>$value->orc_turma_id, 'ccusto_id'=>$value->ccusto_id, 'user_id'=>$this->fillCriadoPor(), 'tipo'=>$value->tipo, 'qtde_pessoas'=>$value->qtde_pessoas, 'tempo_casa'=>$value->tempo_casa, 'mes'=>$value->mes, 'empresa_id'=>$this->fillCodEmpresa(), 'tipo_table'=>'F', 'created_at'=>$this->fillCriadoEm(), 'periodo'=>$periodo, 'created_by'=>$this->fillCriadoPor(), 'acordo'=>$value->acordo);

                            $insert = $this->demissoes->create($data);

                            $get_id = DB::select("select * from tbl_orc_headcount_demissoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_headcount_demissoes', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->usuario_id, $this->empresa_id, $this->tempo, $this->usuario_id]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd("2",$e, $ultimo_criado_anterior);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201007ct");
                    return false;
                }
            }
        }
        return true;
    }

    public function inserirContratacoes($dados, $orc_id, $periodo){// testado, inseriu todos os registros
        set_time_limit(700);
        // $periodo_anterior = Carbon::parse($periodo)->addMonth(-1)->format('Y-m-d');
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                SELECT  hd_cont.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_orc_headcount_contratacoes as hd_cont
                LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_cont.id and calc.tbl_origem = 'tbl_orc_headcount_contratacoes'
                where hd_cont.orcamento_id = $orc_id and
                hd_cont.tipo_table = 'F' and
                hd_cont.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hd_cont.lotacao_id = $id
                
                order by hd_cont.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    select hd_cont.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_orc_headcount_contratacoes as hd_cont
                    LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_cont.id and calc.tbl_origem = 'tbl_orc_headcount_contratacoes'
                    
                    /*Distribuição*/
                    LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                    hd_cont.orcamento_id = hd.orc_id and
                    hd_cont.orc_cargo_id = hd.orc_cargo_id and
                    hd_cont.lotacao_id = hd.lotacao_id and
                    hd_cont.orc_turma_id = hd.orc_turma_id

                    LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'

                    where hd_cont.tipo_table = 'O' and hd_cont.orcamento_id = ? and hd_cont.lotacao_id = ? 
                    /* and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 ))*/
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                
                if(count($ultimo_criado_anterior) > 0){
                    try{
                        
                        foreach($ultimo_criado_anterior as $value){
                            
                            $existe = DB::select("select * from tbl_orc_headcount_contratacoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            
                            if(count($existe) == 0){
                                $insert = DB::insert("INSERT INTO tbl_orc_headcount_contratacoes(
                                    [orcamento_id]
                                    ,[lotacao_id]
                                    ,[orc_cargo_id]
                                    ,[orc_turma_id]
                                    ,[ccusto_id]
                                    ,[user_id]
                                    ,[empresa_id]
                                    ,[tipo_table]
                                    ,[created_at]
                                    ,[periodo]
                                    ,[created_by]
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?)", [$value->orcamento_id, $id, $value->orc_cargo_id, $value->orc_turma_id, $value->ccusto_id, $this->fillCriadoPor(), $this->fillCodEmpresa(), 'F', $this->fillCriadoEm(), $periodo, $this->fillCriadoPor()]);

                                $get_id = DB::select("select * from tbl_orc_headcount_contratacoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                                
                                $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                    [origem_id], [tbl_origem]
                                    ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                    ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                    ,[user_id], [empresa_id], [created_at], [created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_headcount_contratacoes', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd($e);
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201433ct");
                        return false;
                    }
                }
            }
            else{
                
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $existe = DB::select("select * from tbl_orc_headcount_contratacoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                        
                        if(count($existe) == 0){
                            $insert = DB::insert("INSERT INTO tbl_orc_headcount_contratacoes(
                                [orcamento_id]
                                ,[lotacao_id]
                                ,[orc_cargo_id]
                                ,[orc_turma_id]
                                ,[ccusto_id]
                                ,[user_id]
                                ,[empresa_id]
                                ,[tipo_table]
                                ,[created_at]
                                ,[periodo]
                                ,[created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?)", [$value->orcamento_id, $id, $value->orc_cargo_id, $value->orc_turma_id, $value->ccusto_id, $this->fillCriadoPor(), $this->fillCodEmpresa(), 'F', $this->fillCriadoEm(), $periodo, $this->fillCriadoPor()]);

                            $get_id = DB::select("select * from tbl_orc_headcount_contratacoes where orcamento_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ?", [$value->orcamento_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_headcount_contratacoes', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201009ct");
                    return false;
                }
            }
        }
        return true;
    }

    public function inserirPromocoes($dados, $orc_id, $periodo){// testado, inseriu todos os registros

        set_time_limit(700);
        /*
            Não temos calc
        */
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                SELECT  hd_prom.*

                from tbl_orc_promocao as hd_prom                
                where hd_prom.orc_id = $orc_id and
                hd_prom.tipo_table = 'F' and
                hd_prom.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hd_prom.lotacao_id = $id
                
                order by hd_prom.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    select hd_prom.*

                    from tbl_orc_promocao as hd_prom
                    
                    /*Distribuição*/
                    LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                    hd.orc_id = hd_prom.orc_id and
                    hd.orc_cargo_id = hd_prom.cargo_atual_id and
                    hd.lotacao_id = hd_prom.lotacao_id and
                    hd.orc_turma_id = hd_prom.turma_atual_id
                    
                    LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'

                    where hd_prom.tipo_table = 'O' and hd_prom.orc_id = ? and hd_prom.lotacao_id = ? 
                    /* and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 )) */
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                if(count($ultimo_criado_anterior) > 0){
                    try{
                    
                        foreach($ultimo_criado_anterior as $value){
                            
                            $existe = DB::select("select * from tbl_orc_promocao where orc_id = ? and cargo_atual_id = ? and ccusto_id = ? and lotacao_id = ? and turma_atual_id = ? and tipo_table = ? and periodo = ? and cargo_promovido_id = ? and lotacao_promovida_id = ? and turma_promovida_id = ? and funcionario_id = ?", [$value->orc_id, $value->cargo_atual_id, $value->ccusto_id, $id, $value->turma_atual_id, 'F', $periodo, $value->cargo_promovido_id, $value->lotacao_promovida_id, $value->turma_promovida_id, $value->funcionario_id]);
                            
                            if(count($existe) == 0){
                                $insert = DB::insert("INSERT INTO tbl_orc_promocao(
                                    [orc_id], [lotacao_id]
                                    ,[ccusto_id], [cargo_atual_id], [cargo_promovido_id], [funcionario_id], [turma_atual_id]
                                    ,[turma_promovida_id], [mes_promocao], [tipo_table], [created_at], [periodo]
                                    ,[empresa_id], [created_by], [lotacao_promovida_id], [ccusto_promovido_id], sub_promocao_id
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $id, $value->ccusto_id, $value->cargo_atual_id, $value->cargo_promovido_id, $value->funcionario_id, $value->turma_atual_id, $value->turma_promovida_id, $value->mes_promocao, 'F', $this->fillCriadoEm(), $periodo, $this->fillCodEmpresa(), $this->fillCriadoPor(), $value->lotacao_promovida_id, $value->ccusto_promovido_id, $value->sub_promocao_id]);
    
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd($e);
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201455ct");
                        return false;
                    }
                }
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $existe = DB::select("select * from tbl_orc_promocao where orc_id = ? and cargo_atual_id = ? and ccusto_id = ? and lotacao_id = ? and turma_atual_id = ? and tipo_table = ? and periodo = ? and cargo_promovido_id = ? and lotacao_promovida_id = ? and turma_promovida_id = ? and funcionario_id = ?", [$value->orc_id, $value->cargo_atual_id, $value->ccusto_id, $id, $value->turma_atual_id, 'F', $periodo, $value->cargo_promovido_id, $value->lotacao_promovida_id, $value->turma_promovida_id, $value->funcionario_id]);
                        
                        if(count($existe) == 0){
                            $insert = DB::insert("INSERT INTO tbl_orc_promocao(
                                [orc_id], [lotacao_id]
                                ,[ccusto_id], [cargo_atual_id], [cargo_promovido_id], [funcionario_id], [turma_atual_id]
                                ,[turma_promovida_id], [mes_promocao], [tipo_table], [created_at], [periodo]
                                ,[empresa_id], [created_by], [lotacao_promovida_id], [ccusto_promovido_id], sub_promocao_id

                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $id, $value->ccusto_id, $value->cargo_atual_id, $value->cargo_promovido_id, $value->funcionario_id, $value->turma_atual_id, $value->turma_promovida_id, $value->mes_promocao, 'F', $this->fillCriadoEm(), $periodo, $this->fillCodEmpresa(), $this->fillCriadoPor(), $value->lotacao_promovida_id, $value->ccusto_promovido_id, $value->sub_promocao_id]);

                        }
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201457ct");
                    return false;
                }
            }
        }
        return true;
    }

    public function inserirAumentoSalarial($dados, $orc_id, $periodo){// testado, funcionando
        
        set_time_limit(700);
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                SELECT  hd_as.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_orc_salario_funcionario as hd_as
                LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_as.id and calc.tbl_origem = 'tbl_orc_salario_funcionario'
                
                where hd_as.tipo = 1 and
                hd_as.orc_id = $orc_id and
                hd_as.tipo_table = 'F' and
                hd_as.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hd_as.lotacao_id = $id
                
                order by hd_as.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    SELECT  hd_as.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_orc_salario_funcionario as hd_as
                    LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_as.id and calc.tbl_origem = 'tbl_orc_salario_funcionario'
                    
                    /*Distribuição*/
                    LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                    hd.orc_id = hd_as.orc_id and
                    hd.orc_cargo_id = hd_as.orc_cargo_id and
                    hd.lotacao_id = hd_as.lotacao_id and
                    hd.orc_turma_id = hd_as.orc_turma_id

                    LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'

                    where hd_as.tipo <> 3 and hd_as.tipo <> 2 and hd_as.tipo_table = 'O' and hd_as.orc_id = ? and hd_as.lotacao_id = ? 
                    /* and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 )) */
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                if(count($ultimo_criado_anterior) != 0){// se existir em headcount
                    try{
                    
                        foreach($ultimo_criado_anterior as $value){
                            
                            $existe = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                            
                            if(count($existe) == 0){
                                $insert = DB::insert("INSERT INTO tbl_orc_salario_funcionario(
                                    [orc_id]
                                    ,[funcionario_id]
                                    ,[orc_cargo_id]
                                    ,[lotacao_responsavel_id]
                                    ,[lotacao_id]
                                    ,[ccusto_id]
                                    ,[orc_turma_id]
                                    ,[tipo]
                                    ,[empresa_id]
                                    ,[tipo_table]
                                    ,[user_id]
                                    ,[created_at]
                                    ,[created_by]
                                    ,[periodo]
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $value->funcionario_id, $value->orc_cargo_id, $value->lotacao_responsavel_id, $id, $value->ccusto_id, $value->orc_turma_id, 1, $this->fillCodEmpresa(), 'F', $this->fillCriadoPor(), $this->fillCriadoEm(), $this->fillCriadoPor(), $periodo]);
    
                                $get_id = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                                
                                $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                    [origem_id], [tbl_origem]
                                    ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                    ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                    ,[user_id], [empresa_id], [created_at], [created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_salario_funcionario', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd($e, 'Erro: 100920201516ct');
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201516ct");
                        return false;
                    }
                }
                else{// se não existir em headcount
                    $ultimo_criado_anterior = [];
                    $ultimo_criado_anterior = DB::select("
                        SELECT  hd_as.*, calc.tbl_origem,
                        calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                        calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                        from tbl_orc_salario_funcionario as hd_as
                        LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_as.id and calc.tbl_origem = 'tbl_orc_salario_funcionario'
                        
                        /*Distribuição*/
                        LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                        hd.orc_id = hd_as.orc_id and
                        hd.orc_cargo_id = hd_as.orc_cargo_id and
                        hd.lotacao_id = hd_as.lotacao_id and
                        hd.orc_turma_id = hd_as.orc_turma_id

                        LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'

                        where hd_as.tipo <> 3 and hd_as.tipo <> 2 and hd_as.tipo_table = 'O' and hd_as.orc_id = ? and hd_as.lotacao_id = ? /*and
                        (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                        ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                        calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                        calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 ))*/
                    ", [$orc_id, $id]);
                    
                    if(count($ultimo_criado_anterior) > 0){
                        try{
                            foreach($ultimo_criado_anterior as $value){
                                
                                $existe = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                                
                                if(count($existe) == 0){
                                    $insert = DB::insert("INSERT INTO tbl_orc_salario_funcionario(
                                        [orc_id]
                                        ,[funcionario_id]
                                        ,[orc_cargo_id]
                                        ,[lotacao_responsavel_id]
                                        ,[lotacao_id]
                                        ,[ccusto_id]
                                        ,[orc_turma_id]
                                        ,[tipo]
                                        ,[empresa_id]
                                        ,[tipo_table]
                                        ,[user_id]
                                        ,[created_at]
                                        ,[created_by]
                                        ,[periodo]
                                        )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $value->funcionario_id, $value->orc_cargo_id, $value->lotacao_responsavel_id, $id, $value->ccusto_id, $value->orc_turma_id, 1, $this->fillCodEmpresa(), 'F', $this->fillCriadoPor(), $this->fillCriadoEm(), $this->fillCriadoPor(), $periodo]);
        
                                    $get_id = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                                    
                                    $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                        [origem_id], [tbl_origem]
                                        ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                        ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                        ,[user_id], [empresa_id], [created_at], [created_by]
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_salario_funcionario', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                                }
                                
                            }
                        }
                        catch(\Exception $e){
                            dd($e,'Erro: 100920201524ct');
                            $this->setError("Falha ao Liberar período selecionado! Erro: 100920201524ct");
                            return false;
                        }
                    }
                }
                
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $existe = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                        
                        if(count($existe) == 0){
                            $insert = DB::insert("INSERT INTO tbl_orc_salario_funcionario(
                                [orc_id]
                                ,[funcionario_id]
                                ,[orc_cargo_id]
                                ,[lotacao_responsavel_id]
                                ,[lotacao_id]
                                ,[ccusto_id]
                                ,[orc_turma_id]
                                ,[tipo]
                                ,[empresa_id]
                                ,[tipo_table]
                                ,[user_id]
                                ,[created_at]
                                ,[created_by]
                                ,[periodo]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $value->funcionario_id, $value->orc_cargo_id, $value->lotacao_responsavel_id, $id, $value->ccusto_id, $value->orc_turma_id, 1, $this->fillCodEmpresa(), 'F', $this->fillCriadoPor(), $this->fillCriadoEm(), $this->fillCriadoPor(), $periodo]);

                            $get_id = DB::select("select * from tbl_orc_salario_funcionario where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and tipo = 1 and funcionario_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->funcionario_id]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_salario_funcionario', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd($e,'Erro: 100920201523ct');
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201523ct");
                    return false;
                }
            }
        }
        return true; 
    }

    public function inserirFerias($dados, $orc_id, $periodo){// testado, funcionando
        set_time_limit(700);
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                SELECT  hd_ferias.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_orc_ferias as hd_ferias
                LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_ferias.id and calc.tbl_origem = 'tbl_orc_ferias'
                where hd_ferias.orcamento_id = $orc_id and
                hd_ferias.tipo_table = 'F' and
                hd_ferias.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hd_ferias.lotacao_id = $id
                
                order by hd_ferias.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    SELECT  hd_ferias.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_orc_ferias as hd_ferias
                    LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_ferias.id and calc.tbl_origem = 'tbl_orc_ferias'
                    
                    /*Distribuição*/
                    LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                    hd.orc_id = hd_ferias.orcamento_id and
                    hd.orc_cargo_id = hd_ferias.cargo_id and
                    hd.lotacao_id = hd_ferias.lotacao_id and
                    hd.orc_turma_id = hd_ferias.orc_turma_id

                    LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_ferias'

                    where hd_ferias.tipo_table = 'O' and hd_ferias.orcamento_id = ? and hd_ferias.lotacao_id = ? 
                    /*and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 ))*/
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                
                if(count($ultimo_criado_anterior) > 0){
                    try{
                    
                        foreach($ultimo_criado_anterior as $value){
                            $func_id = $value->func_id == null ? 'func_id is null' : 'func_id = '.$value->func_id;
                            $func_id_insert = $value->func_id == null ? NULL : $value->func_id;

                            $existe = DB::select("select * from tbl_orc_ferias where orcamento_id = ? and cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and $func_id", [$value->orcamento_id, $value->cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            
                            if(count($existe) == 0){
                                $insert = DB::insert("INSERT INTO tbl_orc_ferias(
                                    [orcamento_id]
                                    ,[ccusto_id]
                                    ,[lotacao_id]
                                    ,[cargo_id]
                                    ,[lotacao_responsavel]
                                    ,[orc_turma_id]
                                    ,[func_id]
                                    ,[type]
                                    ,[tipo_table]
                                    ,[user_id]
                                    ,[empresa_id]
                                    ,[created_at]
                                    ,[periodo]
                                    ,[created_by]
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orcamento_id, $value->ccusto_id, $id, $value->cargo_id, $value->lotacao_responsavel, $value->orc_turma_id, $func_id_insert, $value->type, 'F', $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $periodo, $this->fillCriadoPor()]);
                                
                                $get_id = DB::select("select * from tbl_orc_ferias where orcamento_id = ? and cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and $func_id", [$value->orcamento_id, $value->cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);

                                
                                $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                    [origem_id], [tbl_origem]
                                    ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                    ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                    ,[user_id], [empresa_id], [created_at], [created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_ferias', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                                
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd($e);
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201541ct");
                        return false;
                    }
                }
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){

                        $func_id = $value->func_id == null ? 'func_id is null' : 'func_id = '.$value->func_id;
                        $func_id_insert = $value->func_id == null ? NULL : $value->func_id;

                        $existe = DB::select("select * from tbl_orc_ferias where orcamento_id = ? and cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and $func_id", [$value->orcamento_id, $value->cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                        
                        if(count($existe) == 0){
                            $insert = DB::insert("INSERT INTO tbl_orc_ferias(
                                [orcamento_id]
                                ,[ccusto_id]
                                ,[lotacao_id]
                                ,[cargo_id]
                                ,[lotacao_responsavel]
                                ,[orc_turma_id]
                                ,[func_id]
                                ,[type]
                                ,[tipo_table]
                                ,[user_id]
                                ,[empresa_id]
                                ,[created_at]
                                ,[periodo]
                                ,[created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$value->orcamento_id, $value->ccusto_id, $id, $value->cargo_id, $value->lotacao_responsavel, $value->orc_turma_id, $func_id_insert, $value->type, 'F', $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $periodo, $this->fillCriadoPor()]);

                             $get_id = DB::select("select * from tbl_orc_ferias where orcamento_id = ? and cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and $func_id", [$value->orcamento_id, $value->cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_orc_ferias', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201542ct");
                    return false;
                }
            }
        }
        return true;
    }

    public function inserirHorasExtras($dados, $orc_id, $periodo){// funcionado. Ver se o tipo_table antigo está sendo populado(na base estava nulo)
        set_time_limit(700);
        for($i = 0; $i < count($dados); $i++){
            $id = $dados[$i]['id'];
            $status = self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
            $ultimo_criado_anterior = DB::select("
                SELECT  hd_he.*, calc.tbl_origem,
                calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                from tbl_headcount_hra_extra as hd_he
                LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_he.id and calc.tbl_origem = 'tbl_headcount_hra_extra'
                
                where hd_he.orc_id = $orc_id and
                hd_he.tipo_table = 'F' and
                hd_he.periodo = DATEADD(month, -1, cast('$periodo' as date)) and
                hd_he.lotacao_id = $id
                
                order by hd_he.periodo desc
            ");
            
            if(count($ultimo_criado_anterior) == 0 && !$this->getIsPrimeiroPeriodo($periodo, $orc_id)){
                $ultimo_criado_anterior = [];
                $ultimo_criado_anterior = DB::select("
                    SELECT  hd_he.*, calc.tbl_origem,
                    calc.jan_orcado, calc.fev_orcado, calc.mar_orcado, calc.abr_orcado, calc.mai_orcado, calc.jun_orcado,
                    calc.jul_orcado, calc.ago_orcado, calc.set_orcado, calc.out_orcado, calc.nov_orcado, calc.dez_orcado

                    from tbl_headcount_hra_extra as hd_he
                    LEFT JOIN tbl_calc_orcamento as calc on calc.origem_id = hd_he.id and calc.tbl_origem = 'tbl_headcount_hra_extra'
                    
                    /*Distribuição*/
                    LEFT JOIN tbl_orc_lot_carg_headcount as hd on
                    hd.orc_id = hd_he.orc_id and
                    hd.orc_cargo_id = hd_he.orc_cargo_id and
                    hd.lotacao_id = hd_he.lotacao_id and
                    hd.orc_turma_id = hd_he.orc_turma_id

                    LEFT JOIN tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_headcount_hra_extra'

                    where hd_he.tipo_table = 'O' and hd_he.orc_id = ? and hd_he.lotacao_id = ? 
                    /* and (hd.qtd_func_lot <> 0 or hd.forecast_anterior <> 0 or 
                    ( calc_hd.jan_orcado <> 0 or calc_hd.fev_orcado <> 0 or calc_hd.mar_orcado <> 0 or calc_hd.abr_orcado <> 0 or
                    calc_hd.mai_orcado <> 0 or calc_hd.jun_orcado <> 0 or calc_hd.jul_orcado <> 0 or calc_hd.ago_orcado <> 0 or
                    calc_hd.set_orcado <> 0 or calc_hd.out_orcado <> 0 or calc_hd.nov_orcado <> 0 or calc_hd.dez_orcado <> 0 )) */
                ", [$orc_id, $id]);
                
                /* PODE INSERIR DIRETO, DO QUE VEIO NO SELECT*/
                
                if(count($ultimo_criado_anterior) > 0){
                    try{
                    
                        foreach($ultimo_criado_anterior as $value){
                            
                            $existe = DB::select("select * from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and evento_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->evento_id]);

                            
                            if(count($existe) == 0){
                                $insert = DB::insert("INSERT INTO tbl_headcount_hra_extra(
                                    [orc_id]
                                    ,[lotacao_id]
                                    ,[orc_cargo_id]
                                    ,[evento_id]
                                    ,[ccusto_id]
                                    ,[orc_turma_id]
                                    ,[user_id]
                                    ,[empresa_id]
                                    ,[tipo_table]
                                    ,[created_at]
                                    ,[periodo]
                                    )VALUES(?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $id, $value->orc_cargo_id, $value->evento_id, $value->ccusto_id, $value->orc_turma_id, $this->fillCriadoPor(), $this->fillCodEmpresa(), 'F', $this->fillCriadoEm(), $periodo]);
    
                                $get_id = DB::select("select * from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and evento_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->evento_id]);
                                
                                $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                    [origem_id], [tbl_origem]
                                    ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                    ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                    ,[user_id], [empresa_id], [created_at], [created_by]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_headcount_hra_extra', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                            }
                            
                        }
                    }
                    catch(\Exception $e){
                        dd($e);
                        $this->setError("Falha ao Liberar período selecionado! Erro: 100920201553ct");
                        return false;
                    }
                }
            }
            else{
                try{
                    foreach($ultimo_criado_anterior as $value){
                        $existe = DB::select("select * from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and evento_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->evento_id]);
                        
                        if(count($existe) == 0){
                            $insert = DB::insert("INSERT INTO tbl_headcount_hra_extra(
                                [orc_id]
                                ,[lotacao_id]
                                ,[orc_cargo_id]
                                ,[evento_id]
                                ,[ccusto_id]
                                ,[orc_turma_id]
                                ,[user_id]
                                ,[empresa_id]
                                ,[tipo_table]
                                ,[created_at]
                                ,[periodo]
                                )VALUES(?,?,?,?,?,?,?,?,?,?,?)", [$value->orc_id, $id, $value->orc_cargo_id, $value->evento_id, $value->ccusto_id, $value->orc_turma_id, $this->fillCriadoPor(), $this->fillCodEmpresa(), 'F', $this->fillCriadoEm(), $periodo]);

                            $get_id = DB::select("select * from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and ccusto_id = ? and lotacao_id = ? and orc_turma_id = ? and tipo_table = ? and periodo = ? and evento_id = ?", [$value->orc_id, $value->orc_cargo_id, $value->ccusto_id, $id, $value->orc_turma_id, 'F', $periodo, $value->evento_id]);
                            
                            $insert_calc = DB::insert("INSERT INTO tbl_calc_orcamento(
                                [origem_id], [tbl_origem]
                                ,[jan_orcado], [fev_orcado], [mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado]
                                ,[jul_orcado], [ago_orcado], [set_orcado], [out_orcado], [nov_orcado], [dez_orcado]
                                ,[user_id], [empresa_id], [created_at], [created_by]
                            )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [$get_id[0]->id, 'tbl_headcount_hra_extra', $value->jan_orcado, $value->fev_orcado, $value->mar_orcado, $value->abr_orcado, $value->mai_orcado, $value->jun_orcado, $value->jul_orcado, $value->ago_orcado, $value->set_orcado, $value->out_orcado, $value->nov_orcado, $value->dez_orcado, $this->fillCriadoPor(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]);
                        }
                    }
                }
                catch(\Exception $e){
                    dd($e);
                    $this->setError("Falha ao Liberar período selecionado! Erro: 100920201554ct");
                    return false;
                }
            }
        }
        return true;
    }

    public function inserirMovto($dados, $periodo){// inseriu todos os registros
        $status = self::STATUS_LOT_PENDENTE_DIGITACAO_FCST;
        for($i = 0; $i < count($dados); $i++){
            $id = $this->getOrcLotForecastByOrc($dados[$i]['id'], $periodo, 264);

            try{
                $insert_status = DB::insert("INSERT INTO tbl_orc_movto_status_ccusto(
                    [orc_lotacao_id], [user_id], [status_anterior], [status_atual], [observacao],
                    [data_hora], [created_at], [empresa_id], [created_by], [periodo], [tipo_table]
                )VALUES(?,?,?,?,?,?,?,?,?,?,?)", [$id, $this->fillCriadoPor(), $status, $status, 'Nao Informada', $this->fillCriadoEm(), $this->fillCriadoEm(), $this->fillCodEmpresa(), $this->fillCriadoPor(), $periodo, 'F']);

                DB::update("update tbl_orc_lotacao set status = ? where id = ?", [self::STATUS_LOT_PENDENTE_DIGITACAO_FCST, $id]);
            }
            catch(\Exception $e){
                dd($e);
                $this->setError("Falha ao Liberar orçamento. Erro: 090920201503ct");
                return false;
            }
        }
    }

    protected function getOrcCargoForecastByOrc($orc_cargo_id, $periodo, $orc_id){
        $select = DB::select("SELECT id from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and cargo_id = (
            SELECT cargo_id from tbl_orc_cargo where id = $orc_cargo_id
        )");

        return count($select) > 0 ? $select[0]->id : -1;
    }
    protected function getOrcTurmaForecastByOrc($orc_turma_id, $periodo, $orc_id){
        $select = DB::select("SELECT turma_id, turno_id from tbl_orc_turma where id = $orc_turma_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_turma where orc_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and turma_id = {$select[0]->turma_id} and turno_id = {$select[0]->turno_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }

        return -2;
    }
    protected function getOrcLotForecastByOrc($orc_lot_id, $periodo, $orc_id){
        $select = DB::select("SELECT lotacao_id, cc_custo_id from tbl_orc_lotacao where id = $orc_lot_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F' and periodo = '{$periodo}' and lotacao_id = {$select[0]->lotacao_id} and cc_custo_id = {$select[0]->cc_custo_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }


    protected function getOrcCargoByForecast($orc_cargo_id, $orc_id){
        $select = DB::select("SELECT id from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'O' and periodo is null and cargo_id = (
            SELECT cargo_id from tbl_orc_cargo where id = $orc_cargo_id
        )");

        return count($select) > 0 ? $select[0]->id : -1;
    }
    protected function getOrcTurmaByForecast($orc_turma_id, $orc_id){
        $select = DB::select("SELECT turma_id, turno_id from tbl_orc_turma where id = $orc_turma_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_turma where orc_id = $orc_id and tipo_table = 'O' and turma_id = {$select[0]->turma_id} and turno_id = {$select[0]->turno_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }
    protected function getOrcLotByForecast($orc_lot_id, $orc_id){
        $select = DB::select("SELECT lotacao_id, cc_custo_id from tbl_orc_lotacao where id = $orc_lot_id");
        $atual = null;
        if(count($select) > 0){
            $atual = DB::select("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'O' and lotacao_id = {$select[0]->lotacao_id} and cc_custo_id = {$select[0]->cc_custo_id} ");
            return count($atual) > 0 ? $atual[0]->id : -1;
        }
        return -2;
    }
    public function getIsPrimeiroPeriodo($periodo, $orc_id){        
        $existe_periodo_anterior = DB::select("select top 1 * from tbl_orc_lot_carg_headcount where tipo_table = 'F' and orc_id = $orc_id and periodo = DATEADD(month, -1, cast('$periodo' as date)) ");
        return count($existe_periodo_anterior) == 0 ? false : true;
    }

}