<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Usuario;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\DB as FacadesDB;

class RepoFuncionario extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\Funcionario';
   protected $form_rules=[

                      'nome_funcionario'=>'required',
                      'num_reg_func'=>'required',
                      'cdn_funcionario'=>'required|unique:tbl_funcionario,cdn_funcionario',
                      'dat_nascimento'=>'required',
                      'dat_admis_func'=>'required',
                      'cpf'=>'required',
                      'salario'=>'required'
                      
                         ];

    protected $rules_msg=[
                      'nome_funcionario.required'=>'O campo nome do funcionário é obrigatório',
                      'num_reg_func.required'=>'O campo número de registro funcionário é obrigatório',
                      'cdn_funcionario.required'=>'O campo código funcionário é obrigatório', 
                      'cdn_funcionario.unique'=>'Cód. Funcionário já foi cadastrado', 
                      'data de nascimento.required'=>'O campo data de nascimento é obrigatório',
                      'dat_admis_func.required'=>'O campo data de admissão funcionário é obrigatório',              
                      'cpf.required'=>'O campo CPF é obrigatório',                  
                      'salario.required'=>'O campo salário é obrigatório'
                                        
                        ]; 
   public function update(array $data,$id,$attribute="id"){
      try{
         //$retorno = [];

         $this->form_rules['cdn_funcionario'].=','.$id;
         $data_array_nasc = explode('T', $data['dat_nascimento']);
         $data_array_admis = explode('T', $data['dat_admis_func']);
         $data_array_estab_ini = explode('T', $data['dt_estabi_ini']);
         $data_array_estab_fim = explode('T', $data['dt_estabi_fim']);

         $data_array_afast_ini = explode('T', $data['dt_afast_ini']);
         $data_array_afast_fim = explode('T', $data['dt_afast_fim']);

         // $data_array_updated = explode('T', $data['updated_at']);


         
         $data['dat_nascimento'] = Carbon::parse($data_array_nasc[0])->format('ymd H:i:s');
         $data['dat_admis_func'] = Carbon::parse($data_array_admis[0])->format('ymd H:i:s');
         $data['dt_estabi_ini'] = Carbon::parse($data_array_estab_ini[0])->format('ymd H:i:s');
         $data['dt_estabi_fim'] = Carbon::parse($data_array_estab_fim[0])->format('ymd H:i:s');

         $data['dt_afast_ini'] = Carbon::parse($data_array_afast_ini[0])->format('ymd H:i:s');
         $data['dt_afast_fim'] = Carbon::parse($data_array_afast_fim[0])->format('ymd H:i:s');
         // $data['updated_at'] = Carbon::parse($data_array_updated[0])->format('ymd H:i:s');


         

         if(!validaCPF($data['cpf'])){
            $this->setError("CPF inválido! erro:270120200956");
            return false;
         }
         $id = $data['id'];
         unset($data['id']);
         unset($data['_token']);

         unset($data['descr_afast']);
         unset($data['cod_afast']);

         $data['cargo_id'] = strval($data['cargo_id']);
         
         $func = new Funcionario();
         $atualizar = $func::where('id', $id)->update($data);

         /*$atualizar = DB::update("UPDATE tbl_funcionario set 
            nome_funcionario = '{$data['nome_funcionario']}',
            --cdn_funcionario = {$data['cdn_funcionario']},
            dat_nascimento = '{$data['dat_nascimento']}',
            dat_admis_func = '{$data['dat_admis_func']}',
            salario = '{$data['salario']}',
            num_reg_func = {$data['num_reg_func']},
            --cpf = {$data['cpf']},
            lotacao_id = {$data['lotacao_id']},
            recebe_pericul = {$data['recebe_pericul']},
            recebe_insal = {$data['recebe_insal']},
            func_sindlz = {$data['func_sindlz']},
            turma_id = {$data['turma_id']},
            cargo_id = {$data['cargo_id']},
            tp_func = {$data['tp_func']},
            dt_estabi_ini = '{$data['dt_estabi_ini']}',
            dt_estabi_fim = '{$data['dt_estabi_fim']}',
            tp_estabi = {$data['tp_estabi']},
            plano_lotac_id = {$data['plano_lotac_id']},
            ccusto_id = {$data['ccusto_id']},
            dt_afast_ini = '{$data['dt_afast_ini']}',
            dt_afast_fim = '{$data['dt_afast_fim']}',
            pne = {$data['pne']}
         ");*/
         
         if($atualizar === false){
            $this->setError("Falha ao atualizar registro. Erro: 080320211554");
            // $retorno['msg'] = "Falha ao atualizar registro.";
            // $retorno['submsg'] = "Erro";
            // $retorno['status'] = "error";

            return false;
         }
         
         // $retorno['msg'] = "Registro atualizado com sucesso!";
         // $retorno['submsg'] = "Sucesso";
         // $retorno['status'] = "success";

         return true;
      }
      catch(\Exception $e){
         // $retorno['msg'] = "Falha ao atualizar registro. - ".$e->getMessage();
         // $retorno['submsg'] = "Erro";
         // $retorno['status'] = "error";
         $this->setError("Falha ao atualizar registro. - ".$e->getMessage());
         return false;
      }
   } 
   public function listarDesabilitado($showSalarios = true){
      
      $turno = new Turno();
      $a = $this->getModelEntity()->with([
         'getLotacao'=>function($query){
            // $query->select('des_unid_lotac');
         },
         'getCargo'=>function($query){
            // $query->select('id')->get()->toArray();
         },
         'getPlanoLotacao'=>function($query){},
         'getCcusto'=>function($query){},
         'getTpFunc'=>function($query){},
         'getTurma'=>function($query){
            return $query->with('getTurno');
         },
         'getCriado'=>function($query){
            // return $query->select(
            //    DB::raw("CASE WHEN nome IS NOT NULL THEN nome ELSE '-' END as created_by")
            // )->get()->toArray();
         },
         'getAtualizado'=>function($query){
            // return $query->select(
            //    DB::raw("CASE WHEN nome IS NOT NULL THEN nome ELSE '-' END as updated_by")
            // )->get()->toArray();
         },

      ])->where(['dat_demis_func' => NULL]) 
      ->get()
      ->toArray();         
      
      for ($i=0; $i < count($a) ; $i++) {        
         // dd($a[$i]);
         $a[$i]['des_unid_lotac'] = $a[$i]['get_lotacao']['des_unid_lotac'];
         $a[$i]['des_cargo_basic'] = $a[$i]['get_cargo']['des_cargo_basic'];
         $a[$i]['cod_cargo_basic'] = $a[$i]['get_cargo']['cod_cargo_basic'];
         $a[$i]['des_ccusto'] = $a[$i]['get_ccusto']['des_ccusto'];
         $a[$i]['cod_ccusto'] = $a[$i]['get_ccusto']['cod_ccusto'];
         $a[$i]['tipo'] = $a[$i]['get_tp_func']['tipo'];
         $a[$i]['des_turno_trab'] = $a[$i]['get_turma']['get_turno']['des_turno_trab'];
         $a[$i]['Periculosidade'] = $a[$i]['recebe_pericul']==1?'Sim':'Não';
         $a[$i]['Insalubridade'] = $a[$i]['recebe_insal']==1?'Sim':'Não';
         $a[$i]['Sindicalizado'] = $a[$i]['func_sindlz']==1?'Sim':'Não';

         $a[$i]['salario_'] = number_format($a[$i]['salario'], 4,',','.');
         $a[$i]['description_lotacao'] = $a[$i]['get_lotacao']['unid_lotac'].' - '.$a[$i]['des_unid_lotac'];
         $a[$i]['des_turma_trab'] = $a[$i]['get_turma']['des_turma_trab'];
         $a[$i]['description_turma'] = $a[$i]['get_turma']['cdn_turma_trab'].'-'.$a[$i]['des_turma_trab'].' - '.$a[$i]['get_turma']['get_turno']['cdn_turno_trab'].' - '.$a[$i]['get_turma']['get_turno']['des_turno_trab'];
         $a[$i]['description_cargo'] = $a[$i]['cod_cargo_basic']. ' - '.$a[$i]['des_cargo_basic'];
         $a[$i]['desc_reg_funcionario'] = $a[$i]['cdn_funcionario']. ' - '.$a[$i]['nome_funcionario'];
         $a[$i]['desc_matricula_func_cargo'] = $a[$i]['cdn_funcionario']. ' - '.$a[$i]['nome_funcionario']. ' - '.$a[$i]['cod_cargo_basic']. ' - '.$a[$i]['des_cargo_basic'];

         $a[$i]['description_plano_lotac'] = $a[$i]['get_plano_lotacao']['cdn_plano_lotac']. ' - '.$a[$i]['get_plano_lotacao']['des_plano_lotac'];


         $a[$i]['desc_ccusto'] = $a[$i]['cod_ccusto'].' - '.$a[$i]['des_ccusto'];
         $a[$i]['description_dat_nasc'] = $a[$i]['dat_nascimento'] != null ? $this->formataData($a[$i], 'dat_nascimento') : '-';
         $a[$i]['description_dat_admis_func'] = $a[$i]['dat_nascimento'] != null ? $this->formataData($a[$i], 'dat_admis_func') : '-';
         $a[$i]['description_dt_estabi_ini'] = $a[$i]['dt_estabi_ini'] != null ? $this->formataData($a[$i], 'dt_estabi_ini') : '-';
         $a[$i]['description_dt_estabi_fim'] = $a[$i]['dt_estabi_fim'] != null ? $this->formataData($a[$i], 'dt_estabi_fim') : '-';

         // $a[$i]['description_created_at'] = $a[$i]['created_at'] != null ? $this->formataData($a['created_at']) : '-';
         // $a[$i]['description_updated_at'] = $a[$i]['updated_at'] != null ? $this->formataData($a['updated_at']) : '-';
         $a[$i]['des_origem'] = $a[$i]['origem']==1?'Sistema':'ERP';


         // $a[$i]['criado_em'] = $a[$i]['created_at'] != null ? formataData($a[$i]['created_at']) : '-';
         // $a[$i]['atualizado_em'] = $a[$i]['updated_at'] != null ? formataData($a[$i]['updated_at']) : '-';

         // $a[$i]['criado_por'] = $a[$i]['get_criado']['nome'] != null ? $a[$i]['get_criado']['nome'] : '-';
         // $a[$i]['atualizado_por'] = $a[$i]['get_atualizado']['nome'] != null ? $a[$i]['get_atualizado']['nome'] : '-';

         // $a[$i]['tipo']=$a[$i]['get_tp_func']['tipo'];
         unset($a[$i]['get_lotacao']);
         unset($a[$i]['get_turma']);
         unset($a[$i]['get_cargo']);
         unset($a[$i]['get_ccusto']);
         unset($a[$i]['get_tp_func']);
         if(!$showSalarios){
            unset($a[$i]['salario_']);
            unset($a[$i]['salario']);
         }
         $a[$i] = array_merge($a[$i],array("description"=>$a[$i]['cdn_funcionario'].' - '.$a[$i]['nome_funcionario']));
      }
     
      // for($i=0;$i<count($a);$i++){
      //    $dados[$i]=array_merge($a[$i],array("description"=>$a[$i]['cdn_funcionario'].' - '.$a[$i]['nome_funcionario']));
      // }
      // dd("aaaaaaaaaaaaaaaaaaaa",$a);
      return $a;
   }
   public function insert($request){
      $form_data=$request;

      $cpf=$form_data['cpf'];
      // dd("form data",$form_data);
      if(!validaCPF($cpf)){
         $this->setError("CPF inválido! Erro: 270120200956");
         return false;
      }
      // dd($form_data);
      // $form_data['created_at'] = date("Y-m-d H:i:s");
      return parent::create($form_data);
      
   }

   public function getFuncsByNivelHierarquico($nivel){
      $funcs = $this->getModelEntity()->with([
         'getUsuario' => function($query){

         }
      ])->where(['dat_demis_func' => NULL])->where('nivel_hier',$nivel)->get();
      return $funcs;
   }

   public function getFuncsByNivelHierarquicoLotac($nivel, $lot_id){
      $funcs = $this->getModelEntity()->with([
         'getUsuario' => function($query){

         }
      ])->where(['dat_demis_func' => NULL])->where('nivel_hier',$nivel)->where('lotacao_id',$lot_id)->get();
      return $funcs;

   }

   public function getFuncsByNivelHierarquicoLotacManager($cod_lotacao, $nivel_hier, $orc_id = 0, $periodo = null, $tipo_table = 'O'){
      
      $where = $tipo_table == 'F' ? " and ga.tipo_table = '{$tipo_table}' and ga.periodo = '{$periodo}' " : " and ga.tipo_table = '{$tipo_table}' ";
      $union = $orc_id = 0 ? "" : "UNION  
         SELECT func.id, func.cdn_funcionario, func.nome_funcionario, func.num_reg_func, func.dat_demis_func,
            func.nivel_hier, lot.id lotacao_id, lot.unid_lotac, lot.des_unid_lotac, usu.email

         from tbl_orc_gestor_alternativo as ga
         inner join tbl_orc_lotacao as olot on olot.id = ga.lotacao_id
         inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
         inner join tbl_funcionario as func on func.id = ga.funcionario_id
         inner join institb_usuario as usu on usu.funcionario_id = func.id

         where ga.orcamento_id = $orc_id {$where} and dat_demis_func is null and func.nivel_hier > 1 and func.nivel_hier < $nivel_hier
         and ( 
            func.nivel_hier = 5 and lot.unid_lotac like (left('$cod_lotacao', 8) + '%') or
            func.nivel_hier = 4 and lot.unid_lotac like (left('$cod_lotacao', 6) + '%') or 
            func.nivel_hier = 3 and lot.unid_lotac like (left('$cod_lotacao', 4) + '%') or
            func.nivel_hier = 2 and lot.unid_lotac like (left('$cod_lotacao', 2) + '%')
         ) 
         order by nivel_hier desc";

      $select = DB::select("SELECT
         f.id, f.cdn_funcionario, f.nome_funcionario, 
         f.num_reg_func, f.dat_demis_func, f.nivel_hier,
         l.id lotacao_id, l.unid_lotac, l.des_unid_lotac, tbl_user.email 
         
         from tbl_funcionario f
         
         inner join tbl_lotacao l on l.id = f.lotacao_id
         inner join institb_usuario tbl_user on tbl_user.funcionario_id = f.id
         
         where dat_demis_func is null and f.nivel_hier > 1 and f.nivel_hier < $nivel_hier
         and (
            f.nivel_hier = 5 and l.unid_lotac like (left('$cod_lotacao', 8) + '%') or
            f.nivel_hier = 4 and l.unid_lotac like (left('$cod_lotacao', 6) + '%') or 
            f.nivel_hier = 3 and l.unid_lotac like (left('$cod_lotacao', 4) + '%') or
            f.nivel_hier = 2 and l.unid_lotac like (left('$cod_lotacao', 2) + '%')
         )
         {$union}
      ");

     
      return $select;

   }

   public function getFuncsManagerAlternativo($func_id){
     
      $select = DB::select("
            select f.id, f.cdn_funcionario, f.nome_funcionario, 
                  f.num_reg_func, f.dat_demis_func, f.nivel_hier, tbl_user.email as email_user, f.email
            from tbl_funcionario f
            left join institb_usuario tbl_user on tbl_user.funcionario_id = f.id
            where f.dat_demis_func is null and f.id = $func_id
           
      ");

      return $select;
   }

   public function getFuncByDiretor($cod_lotacao){
      $select = DB::select("select f.id, f.cdn_funcionario, f.nome_funcionario, 
               f.num_reg_func, f.dat_demis_func, f.nivel_hier,
               l.id lotacao_id, l.unid_lotac, l.des_unid_lotac
         from tbl_funcionario f
         inner join tbl_lotacao l on l.id = f.lotacao_id            
         where dat_demis_func is null and l.unid_lotac like ('$cod_lotacao')
         and f.nivel_hier < 2");

      return $select;
   }

   public function getFuncsFromRH(){
      $repoUsuario = new RepoUsuario();
      //Pegar usuários técnicos  (RH) que são do tipo 3
      $usersTecnicos = $repoUsuario->getModelEntity()->select('funcionario_id')->where('tipo', 3)->get()->toArray();

      $usersTecnicos = array_column($usersTecnicos, 'funcionario_id');

      $funcs = $this->getModelEntity()->with([
         'getUsuario' => function($query){

         }
      ])->whereIn('id', $usersTecnicos)->get();
      return $funcs;
   }

   public function getQtdeFuncsByLotCarg($lot_id, $cargo_id){
      $qtde = $this->getModelEntity()->where([
         ['cargo_id', $cargo_id],
         ['lotacao_id', $lot_id]
      ])->count();
      return $qtde;
   }
   public function formataData($array, $label){
      $data = $array[$label];
      $ano = substr($data, 0, 4);
      $meses = substr($data, 5, 2);
      $dia = substr($data, 8, 2);
      $data = $dia.'/'.$meses.'/'.$ano;
      return $data;
  }   

   public function listar(){
      $select = FacadesDB::select("SELECT
         case when f.recebe_insal = 1 then 'Sim' else 'Não' End as 'Insalubridade',
         case when f.recebe_pericul = 1 then 'Sim' else 'Não' End as 'Periculosidade',
         case when f.func_sindlz = 1 then 'Sim' else 'Não' End as 'Sindicalizado',
         case when f.recebe_insal = 1 then 'Sim' else 'Não' End as 'Insalubridade',
         f.base_fgts, f.cargo_id, f.ccusto_id, f.cdn_funcionario, f.cod_afast, cargo.cod_cargo_basic,
         cc.cod_ccusto, f.cpf, f.created_at, f.created_by,
         case when user1.nome is null then '-' else user1.nome end as 'created_by_nome',
         case when user2.nome is null then '-' else user2.nome end as 'updated_by_nome',
         f.dat_admis_func, f.dat_demis_func, f.dat_nascimento, cargo.des_cargo_basic, cc.des_ccusto,
         case when f.origem = 1 then 'Sistema' else 'ERP' end as des_origem, tm.des_turma_trab, tn.des_turno_trab, lot.des_unid_lotac,
         concat(cc.cod_ccusto, ' - ', cc.des_ccusto) as desc_ccusto, concat(f.cdn_funcionario, ' - ', f.nome_funcionario, ' - ', cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as 'desc_matricula_func_cargo',
         concat(f.cdn_funcionario, ' - ', f.nome_funcionario) as desc_reg_funcionario, f.descr_afast, concat(f.cdn_funcionario, ' - ', f.nome_funcionario) as 'description',
         concat(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as 'description_cargo', case when f.created_at is not null then format(f.created_at, 'dd/MM/yyyy') else ' - ' end as description_created_at,
         case when f.dat_admis_func is not null then format(f.dat_admis_func, 'dd/MM/yyyy') else ' - ' end as description_dat_admis_func, case when f.dat_nascimento is not null then format(f.dat_nascimento, 'dd/MM/yyyy') else ' - ' end as description_dat_nasc,
         case when f.dt_estabi_fim is not null then format(f.dt_estabi_fim, 'dd/MM/yyyy') else ' - ' end as description_dt_estabi_fim, case when f.dt_estabi_ini is not null then format(f.dt_estabi_ini, 'dd/MM/yyyy') else ' - ' end as description_dt_estabi_ini,
         concat(lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'description_lotacao', concat(pl.cdn_plano_lotac, ' - ', pl.des_plano_lotac) as description_plano_lotac,
         concat(tm.cdn_turma_trab, ' - ', tm.des_turma_trab) as description_turma, case when f.updated_at is not null then format(f.updated_at, 'dd/MM/yyyy') else ' - ' end as description_updated_at,
         f.dt_afast_fim, f.dt_afast_ini, f.dt_ent_cargo, f.dt_estabi_fim, f.dt_estabi_ini, f.email, f.email_gestor, f.empresa_id, f.endereco_id, f.func_sindlz, f.id, f.is_demitido,
         f.lotacao_id, f.nivel_hier, f.nome_funcionario, f.num_reg_func, f.origem, f.plano_lotac_id, f.pne, f.pt_admissao, f.pt_alteracao, f.pt_inclusao, f.pt_total,
         f.recebe_insal, f.recebe_pericul, f.salario, f.tb_ams_vip, tpf.tipo as tipo, f.tp_estabi, f.tp_func, f.turma_id, f.updated_at, f.updated_by,
         f.user_id, f.vip_dir_exec,  case when f.dat_demis_func is not null then format(f.dat_demis_func, 'dd/MM/yyyy') else ' - ' end as data_demissao
         
         FROM tbl_funcionario as f
      
         left join tbl_lotacao as lot on lot.id = f.lotacao_id
         left join tbl_cargo as cargo on cargo.id = f.cargo_id
         left join tbl_plano_lotac as pl on pl.id = f.plano_lotac_id
         left join tbl_ccusto as cc on cc.id = f.ccusto_id
         left join tbl_turma as tm on tm.id = f.turma_id
         left join tbl_turno as tn on tn.id = tm.turno_id
         left join tbl_tipo_funcionario as tpf on tpf.id = f.tp_func
         left join institb_usuario as user1 on user1.id = f.created_by
         left join institb_usuario as user2 on user2.id = f.updated_by
         
         where f.dat_demis_func is null
      ");

      return $select;
   }

   public function listarOrcFuncionario($orc_id){
      return FacadesDB::select("SELECT
         f.id, CASE f.recebe_insal WHEN 1 THEN 'Sim' ELSE 'Não' END as 'Insalubridade',
         CASE f.recebe_pericul WHEN 1 THEN 'Sim' ELSE 'Não' END as 'Periculosidade',
         CASE f.func_sindlz WHEN 1 THEN 'Sim' ELSE 'Não' END as 'Sindicalizado',
         f.base_fgts, f.cargo_id, f.ccusto_id, f.cdn_funcionario, f.cod_afast, c.cod_cargo_basic,
         cc.cod_ccusto, f.cpf, f.created_at, f.created_by, f.dat_admis_func, f.dat_demis_func, f.dat_nascimento,
         c.des_cargo_basic, cc.des_ccusto, CASE f.origem WHEN 1 THEN 'Sistema' ELSE 'ERP' END as 'des_origem', ot.des_turma_trab,
         turno.des_turno_trab, lot.des_unid_lotac, CONCAT(cc.cod_ccusto, ' - ', cc.des_ccusto) as desc_ccusto,
         CONCAT(f.cdn_funcionario, ' - ', f.nome_funcionario, ' - ', cc.cod_ccusto, ' - ', lot.des_unid_lotac) as 'desc_matricula_func_cargo',
         CONCAT(f.cdn_funcionario, ' - ', f.nome_funcionario) as 'desc_reg_funcionario', CONCAT(f.cdn_funcionario, ' - ', f.nome_funcionario) as 'description',
         CONCAT(ot.cdn_turma_trab, ' - ', ot.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) as 'description_turma', lot.id as lotacao_id,
         olot.cc_custo_id as ccusto_id, ot.turma_id
         
         
         from tbl_orc_funcionario as ofunc
         inner join tbl_funcionario as f on f.id = ofunc.funcionario_id
         
         inner join tbl_orc_cargo as oc on oc.id = ofunc.orc_cargo_id
         inner join tbl_cargo as c on c.id = oc.cargo_id
         
         inner join tbl_orc_lotacao as olot on olot.id = ofunc.orc_lotacao_id
         inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
         inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
         
         inner join tbl_orc_turma as ot on ot.id = ofunc.orc_turma_id
         inner join tbl_turno as turno on turno.id = ot.turno_id
         
         where ofunc.orcamento_id = $orc_id
      ");
   }

   public function listarFuncionariosUsuarios($cdn_func){
      
      $select = FacadesDB::select("SELECT distinct
         case when f.recebe_insal = 1 then 'Sim' else 'Não' End as 'Insalubridade',
         case when f.recebe_pericul = 1 then 'Sim' else 'Não' End as 'Periculosidade',
         case when f.func_sindlz = 1 then 'Sim' else 'Não' End as 'Sindicalizado',
         case when f.recebe_insal = 1 then 'Sim' else 'Não' End as 'Insalubridade',
         f.base_fgts, f.cargo_id, f.ccusto_id, f.cdn_funcionario, f.cod_afast, cargo.cod_cargo_basic,
         cc.cod_ccusto, f.cpf, f.created_at, f.created_by,
         case when user1.nome is null then '-' else user1.nome end as 'created_by_nome',
         case when user2.nome is null then '-' else user2.nome end as 'updated_by_nome',
         f.dat_admis_func, f.dat_demis_func, f.dat_nascimento, cargo.des_cargo_basic, cc.des_ccusto,
         case when f.origem = 1 then 'Sistema' else 'ERP' end as des_origem, tm.des_turma_trab, tn.des_turno_trab, lot.des_unid_lotac,
         concat(cc.cod_ccusto, ' - ', cc.des_ccusto) as desc_ccusto, concat(f.cdn_funcionario, ' - ', f.nome_funcionario, ' - ', cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as 'desc_matricula_func_cargo',
         concat(f.cdn_funcionario, ' - ', f.nome_funcionario) as desc_reg_funcionario, f.descr_afast, concat(f.cdn_funcionario, ' - ', f.nome_funcionario) as 'description',
         concat(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as 'description_cargo', case when f.created_at is not null then format(f.created_at, 'dd/MM/yyyy') else ' - ' end as description_created_at,
         case when f.dat_admis_func is not null then format(f.dat_admis_func, 'dd/MM/yyyy') else ' - ' end as description_dat_admis_func, case when f.dat_nascimento is not null then format(f.dat_nascimento, 'dd/MM/yyyy') else ' - ' end as description_dat_nasc,
         case when f.dt_estabi_fim is not null then format(f.dt_estabi_fim, 'dd/MM/yyyy') else ' - ' end as description_dt_estabi_fim, case when f.dt_estabi_ini is not null then format(f.dt_estabi_ini, 'dd/MM/yyyy') else ' - ' end as description_dt_estabi_ini,
         concat(lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'description_lotacao', concat(pl.cdn_plano_lotac, ' - ', pl.des_plano_lotac) as description_plano_lotac,
         concat(tm.cdn_turma_trab, ' - ', tm.des_turma_trab) as description_turma, case when f.updated_at is not null then format(f.updated_at, 'dd/MM/yyyy') else ' - ' end as description_updated_at,
         f.dt_afast_fim, f.dt_afast_ini, f.dt_ent_cargo, f.dt_estabi_fim, f.dt_estabi_ini, f.email, f.email_gestor, f.empresa_id, f.endereco_id, f.func_sindlz, f.id, f.is_demitido,
         f.lotacao_id, f.nivel_hier, f.nome_funcionario, f.num_reg_func, f.origem, f.plano_lotac_id, f.pne, f.pt_admissao, f.pt_alteracao, f.pt_inclusao, f.pt_total,
         f.recebe_insal, f.recebe_pericul, f.salario, f.tb_ams_vip, tpf.tipo as tipo, f.tp_estabi, f.tp_func, f.turma_id, f.updated_at, f.updated_by,
         f.user_id, f.vip_dir_exec
         
         FROM tbl_funcionario as f
      
         left join tbl_lotacao as lot on lot.id = f.lotacao_id
         left join tbl_cargo as cargo on cargo.id = f.cargo_id
         left join tbl_plano_lotac as pl on pl.id = f.plano_lotac_id
         left join tbl_ccusto as cc on cc.id = f.ccusto_id
         left join tbl_turma as tm on tm.id = f.turma_id
         left join tbl_turno as tn on tn.id = tm.turno_id
         left join tbl_tipo_funcionario as tpf on tpf.id = f.tp_func
         left join institb_usuario as user1 on user1.id = f.created_by
         left join institb_usuario as user2 on user2.id = f.updated_by

         inner join institb_usuario as usu on usu.funcionario_id = f.id
         
         where f.dat_demis_func is null and f.cdn_funcionario <> {$cdn_func} order by f.nome_funcionario asc
      ");

      return $select;
   }
}
