<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\GrupoEmpresarial;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Facades\DB;

class RepoGrupoEmpresarial extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\GrupoEmpresarial'; 
    protected $form_rules = [                 
        'grupo'=>'required',
        'descricao'=>'required'
    ];
    protected $rules_msg=[
        'grupo.required'=>'O campo grupo é obrigatório',
        'descricao.required'=>'O campo descrição é obrigatório'
    ];  

    public function listarAll(){
        $tbl_usuario = new Usuario();
        $entity = $this->getModelEntity();

        $select = $this->getModelEntity()
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $this->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
        ->select(
            $entity->getColunaAlias('id'),
            $entity->getColunaAlias('grupo'),
            $entity->getColunaAlias('descricao'),
            $entity->getColunaAlias('empresa_id'),

            DB::raw("CONCAT({$entity->getColunaAlias('id')}, ' - ', {$entity->getColunaAlias('grupo')}, ' - ', {$entity->getColunaAlias('descricao')}) as description"),

            DB::raw("CASE WHEN {$entity->getColunaAlias('created_at')} IS NOT NULL THEN format({$entity->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$entity->getColunaAlias('updated_at')} IS NOT NULL THEN format({$entity->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )->get()->toArray();

        // $dados = [];

        // for($i=0;$i<count($select);$i++){
        //     $dados[$i] = array_merge($select[$i],array("description"=>$select[$i]['id'].' - '.$select[$i]['grupo'].' - '.$select[$i]['descricao']));
        
        //     unset($dados[$i]['created_at']);
        //     unset($dados[$i]['created_by']);
        //     unset($dados[$i]['updated_at']);
        //     unset($dados[$i]['updated_by']);
        //     unset($dados[$i]['empresa_id']);
        // }
        
        return $select;
    }
}