<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcamLotCargoHeadcount;
use App\Modules\Natureza51\Repositories\RepoFuncionario;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcLotCargoHeadcount;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Illuminate\Support\Arr;

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;



class RepoHeadcount extends RepoOrcamento
{


     protected $model_name_space='App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
     protected $form_rules=['lotacao_id' => 'required | min:1 | exists:tbl_orc_lotacao,id'];
     protected $rules_msg=[
         'lotacao_id.required'=>'O campo lotação é obrigatório',
         'lotacao_id.min'=>'Selecione uma lotação',
         'lotacao_id.exists'=> 'Lotação não cadastrada!'
    ];

    public function __construct(){
        parent::__construct();
        $this->setTimeOut(700);
    }
  
    /**
     * @author Samuel Domingos de Lima 09/01/2020
     * @param array  Pass array with model fields and months
     */
    public function createHeadcountOld($data){ 
        $repo_orc = $this->getOrcInstanceNew();
        $repo_lot = new RepoOrcLotacao();

        $orc = $repo_orc->find($this->extractOrcamentoIdFromData($data,'orc_id'));

        if($orc->status_orc != $this->getStatusLiberado()){
            $retorno = array('status'=>'error','msg'=>'Operação indisponível. Libere o orçamento para continuar. Erro 010220201104.');
            goto saida;
        }
        
        if($repo_orc->getModelEntity()->where('id',$this->extractOrcamentoIdFromData($data,'orc_id'))->first() == false){
            $retorno = array('status'=>'error','msg'=>'Orçamento não encontrado. Erro 090120201640.');
            goto saida;
        }
      
        $lot = $repo_lot->find($data['lotacao_id']);

        if($lot->status == $this->getStatusPendente() || 
                $lot->status == $this->getStatusEmAndamento() || 
                $lot->status == $this->getStatusReaberto()){
            
            $clausule = array(
                'orc_id'=>$data['orc_id'], 
                'lotacao_id'=>$data['lotacao_id'],
                'ccusto_id'=>$data['ccusto_id'],
                'orc_cargo_id'=>$data['orc_cargo_id'],
                'orc_turma_id'=>$data['orc_turma_id']
            );
            
            if($this->hasDataOnDB($clausule)){               
                $retorno['status']='warning';
                $retorno['msg']='Falha ao inserir o Registro! Dados já cadastrados.';
                goto saida;
            }
          

            $repo_calc_orcamento = new RepoCalcOrcamento();   
            $meses = $data['meses_orcado'];
            $meses['tbl_origem'] = $this->getModelEntity()->getTable();
            DB::beginTransaction();
            try {

                if($lot->status == $this->getStatusPendente()){
                    $this->inProgressStatus($lot->id,$repo_lot->getModelNameSpace());
                }
                // dd("creat orc turma", $data);
                $head = $this->create($data);
                if(!$head){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }
                $meses['origem_id']=$head->id;
                if(!$repo_calc_orcamento->create($meses)){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }

                $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
                goto saida;

            } catch (\Exception $e) {
                DB::rollBack();
                // dd("catch orc turma", $e);
                abort('Erro! Falha ao Inserir o Registro. Erro 030120201543');
            }

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            goto saida;

       
        
            saida:
            ($retorno['status']=='success')?DB::commit():DB::rollBack();
            return $retorno;
        }else{
            return array('status'=>'error','msg'=>'Operação indisponível. Tente novamente mais tarde. Erro: 010220201214.');
        }
    }

    /**
     * @author Samuel Domingos de Lima 09/01/2020
     * @param array  Pass array with model fields and months
     */
    public function createHeadcount($data){ 
        
        $repo_orc = $this->getOrcInstanceNew();
        $repo_lot = new RepoOrcLotacao();
        $orc = $repo_orc->find($this->extractOrcamentoIdFromData($data,'orc_id'));
        
        if(!$orc){
            $retorno = array('status'=>'error','msg'=>'Orçamento não encontrado. Erro 240420201118.');
            goto saida;
        }
       

        if(($orc->status_orc != $this->getStatusLiberado() && $orc->status_orc != $this->getStatusEmConferencia() ) && $data['tipo_table'] != 'R'){

            $retorno = array('status'=>'error','msg'=>'Operação indisponível. Libere o orçamento para continuar. Erro 010220201104.');
            goto saida;
        }

    
        $lot = $repo_lot->find($data['lotacao_id']);

        if(!$lot){
            $retorno = array('status'=>'error','msg'=>'Orçamento não encontrado. Erro 240920201520.');
            goto saida;
        }

        if($lot->status == $this->getStatusPendente() || 
                $lot->status == $this->getStatusEmAndamento() || 
                $lot->status == $this->getStatusReaberto()||
                $data['tipo_table'] == 'R'){
                               
            $clausule = array(
                'orc_id'=>$data['orc_id'], 
                'lotacao_id'=>$data['lotacao_id'],
                'ccusto_id'=>$data['ccusto_id'],
                'orc_cargo_id'=>$data['orc_cargo_id'],
                'orc_turma_id'=>$data['orc_turma_id'],
                'tipo_table'=>$data['tipo_table']
            );
            
            if($this->hasDataOnDB($clausule)){               
                $retorno['status']='warning';
                $retorno['msg']='Falha ao inserir o Registro! Dados já cadastrados.';
                goto saida;
            }
        
            
            $repo_calc_orcamento = new RepoCalcOrcamento();   

            $meses = ($data['fromMeses']) ? $data['meses_orcado'] :  $this->setMesesSameValue($data['quadroAtual']);
            $meses['tbl_origem'] = $this->getModelEntity()->getTable();
            DB::beginTransaction();

            try {

                // OBS: comentei essa parte pois de acordo com a nova modelagem de status das lotações, não existe mais o status Em andamento(inProgress)
                // if($lot->status == $this->getStatusPendente()){
                //     $this->inProgressStatus($lot->id,$repo_lot->getModelNameSpace());
                // }

                if(!($data['fromMeses'])){
                    $data['qtd_func_lot'] = $data['quadroAtual'];
                }
                
                $data = $this->setTotaisHeadcount($data);
                
                $head = $this->create($data);
                
                if(!$head){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }                

                $inserted = $this->getModelEntity()->where([
                    ['orc_id', $data['orc_id']],
                    ['lotacao_id', $data['lotacao_id']],
                    ['orc_cargo_id', $data['orc_cargo_id']],
                    ['ccusto_id', $data['ccusto_id']],
                    ['orc_turma_id', $data['orc_turma_id']],
                    ['tipo_table', $data['tipo_table']]
                ])->first();

                if(!$inserted){
                    $retorno = array('status'=>'error','msg'=>"registro inserido não encontrado",'submsg'=>'Erro ao inserir o registro. Erro: 210120211047');
                    goto saida;
                }
                
                $meses['origem_id']=$inserted->id;
                if(!$repo_calc_orcamento->create($meses)){
                    
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }
                // TALVEZ PRECISE SER COMENTADO DEPOIS - 21/01/2021 11:51
                if(! $this->scriptUpdateForecastOrcadoAnt($data['orc_id'], $data['lotacao_id'], $data['orc_cargo_id'])){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 300720201948');
                    goto saida;
                }
               



                $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
                goto saida;

            } catch (\Exception $e) {
                DB::rollBack();
                // dd("catch orc turma", $e);
                abort('Erro! Falha ao Inserir o Registro. Erro 030120201543');
            }

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            goto saida;

    
        
            saida:
            ($retorno['status']=='success')?DB::commit():DB::rollBack();
            return $retorno;
        }
        else{
            return array('status'=>'error','msg'=>'Operação indisponível. Tente novamente mais tarde. Erro: 010220201214.');
        }
    }

    public function updateHeadcount($form_data){
        $headcount_id=$form_data['id'];
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $meses_headcount = $this->dataUpdateHeadcount($form_data); 
        // dd($meses_headcount);
        if(!$repo_calc_orcamento->update($meses_headcount, $headcount_id)){ 
                $retorno['status']='error';
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 211120191925';
                goto saida;               
        } 
        
        $retorno = array('msg'=>'Registro atualizado com sucesso!','status'=>'success');
        saida:
        return $retorno;
    }

    public function deleteHeadcount($form_data){
        $repo_calc_orc=new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            $hd = DB::select("SELECT * from tbl_orc_lot_carg_headcount where id = ?", [$form_data['id_princ']]);

            if(!$this->deleteDiarioBordoByCargoTurma($hd[0]->orc_id, $hd[0]->lotacao_id, $hd[0]->orc_cargo_id, $hd[0]->orc_turma_id)){
                $retorno['msg'] = "Impossível concluir a operação. Falha ao deletar Diário de Bordo. Erro: 230320210944";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                return false;
            }
            
            $delete = $this->getModelEntity()::where('id',$form_data['id_princ'])->delete();
            if(!$delete){
                DB::rollBack();
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 100120201003.");
                goto saida;
            }
            
            $delete_calc_orc = $repo_calc_orc->getModelEntity()::where('id',$form_data['id'])->delete();

            if($delete_calc_orc == false){
                DB::rollBack();
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 100120201004.");
                goto saida;          
            }
            
            if(!$this->deleteTelasByCargoTurma($hd[0]->orc_cargo_id, $hd[0]->orc_turma_id, $hd[0]->lotacao_id, $hd[0]->orc_id)){
                DB::rollBack();
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar os dados relacionados a este registro. Erro: 210120211434.");
                goto saida;
            }
            if($this->deleteDiarioBordo($form_data['id'], 'tbl_orc_lot_carg_headcount') === false){
                DB::rollBack();
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar os dados relacionados a este registro (DB). Erro: 220320211533.");
                goto saida;
            }
            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar. Erro: 10012020005.');            
        }
        $retorno['msg']='Registro deletado com sucesso!';
        $retorno['status']='success';
        saida:
        ($retorno['status']=='error')?DB::rollBack():DB::commit();
        return $retorno;
    }

    public function dataUpdateHeadcount($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function setMesesSameValue($value){
        $array = [
            'jan_orcado'=>$value,
            'fev_orcado'=>$value,
            'mar_orcado'=>$value,
            'abr_orcado'=>$value,
            'mai_orcado'=>$value,
            'jun_orcado'=>$value,
            'jul_orcado'=>$value,
            'ago_orcado'=>$value,
            'set_orcado'=>$value,
            'out_orcado'=>$value,
            'nov_orcado'=>$value,
            'dez_orcado'=>$value,
        ];

        return $array;
    }

    public function getTipoTableOrcamento(){
        return 'O';
    }

    public function calcHeadcount($orc_id, $lotacao_id, $mes_ini = 1){
        for ($i=$mes_ini; $i<=12 ; $i++) { 
            if(!$this->updateHeadcountMes($i, $orc_id, $lotacao_id)){
                return false;
            }
        }

        return true;
    }

    public function updateHeadcountMes($mes, $orc_id, $lotacao_id){     
                        
        $meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];

        if(!array_key_exists($mes, $meses)){
            $this->setError("Mês inválido para o cálculo. Erro 290420201040");
            return false;
        }


        $mesAtual = $meses[$mes];

        $calcOrcamento = new CalcOrcamento();
        $tbl_calc_orcamento = $calcOrcamento->getTable();
        $orcLotCargHC = new OrcamLotCargoHeadcount();
        $tbl_orc_carg_hc = $orcLotCargHC->getTable();
        
    
        $values = ($mes==1) ? $this->getValoresJan($orc_id, $lotacao_id) : $this->getValoresMeses($mes, $orc_id, $lotacao_id);
        
        if(!$values){
            $this->setError("Não foi possível encontrar oo valor dos meses. Erro 150720201011");
            return false;
        }

        $cases = [];
        $ids = [];
        $params = [];

        foreach ($values as $value) {
            $id = (int) $value->lot_id;
            $cases[] = "WHEN {$id} then ?";
            $params[] = $value->valor;
            $ids[] = $id;
        }

        $ids = implode(',', $ids);
        $cases = implode(' ', $cases);
        // $params[] = Carbon::now()->format('Y-m-d H:i:s');
        $params[] = $this->fillModificadoEm();


        return \DB::update("UPDATE {$tbl_calc_orcamento} SET {$mesAtual} = CASE origem_id {$cases} END, updated_at = ? WHERE origem_id in ({$ids}) and tbl_origem = '{$tbl_orc_carg_hc}'", $params);

    }

    public function getValoresJan($orc_id, $lotacao_id){

        $tipoTableOrcamento = 'O';

        $values = DB::select("SELECT 
               olch.id	as lot_id,
               case op.valor_parametro
                   when 0 then COALESCE(olch.qtd_func_lot, 0)      + COALESCE((select coc.jan_orcado from tbl_orc_headcount_contratacoes ohc inner join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = 'O' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.jan_orcado from tbl_orc_headcount_demissoes ohdt1 inner join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = 'O' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = 'O' and  ohdt2.tipo = 2 and ohdt2.mes = 1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = 'O' and  ohdt3.tipo = 3 and ohdt3.mes = 1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = 'O' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = 'O' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)
                   when 1 then COALESCE(olch.forecast_anterior, 0) + COALESCE((select coc.jan_orcado from tbl_orc_headcount_contratacoes ohc inner join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = 'O' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.jan_orcado from tbl_orc_headcount_demissoes ohdt1 inner join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = 'O' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = 'O' and  ohdt2.tipo = 2 and ohdt2.mes = 1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = 'O' and  ohdt3.tipo = 3 and ohdt3.mes = 1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = 'O' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = 'O' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)--'Forecast dezembro anterior' 
                   when 2 then COALESCE(olch.forecast_anterior, 0) + COALESCE((select coc.jan_orcado from tbl_orc_headcount_contratacoes ohc inner join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = 'O' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((select cod.jan_orcado from tbl_orc_headcount_demissoes ohdt1 inner join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = 'O' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = 'O' and  ohdt2.tipo = 2 and ohdt2.mes = 1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = 'O' and  ohdt3.tipo = 3 and ohdt3.mes = 1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0) + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = 'O' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0)  - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = 'O' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)--'Importação' 
               end as valor
            FROM [tbl_orcamento]  orc
            left join tbl_orc_parametros op on op.orcamento_id = orc.id and op.parametro_id = 21
            left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
            where olch.lotacao_id = $lotacao_id
                and orc.id = $orc_id
                and olch.tipo_table = '$tipoTableOrcamento'           
        ");

    //     $values = DB::select("
    //         SELECT 
    //             olch.id	as lot_id,
    //             case op.valor_parametro
    //                 when 0 then COALESCE(olch.qtd_func_lot, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)
    //                 when 1 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Forecast dezembro anterior' 
    //                 when 2 then COALESCE(olch.forecast_anterior, 0) + COALESCE(coc.jan_orcado, 0) - COALESCE(cod.jan_orcado, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id)--'Importação' 
    //             end as valor
    //         FROM [tbl_orcamento]  orc
    //         left join tbl_orc_parametros op on op.orcamento_id = orc.id and op.parametro_id = 21
    //         left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
    //         left join tbl_orc_headcount_contratacoes ohc on ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id
    //         left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes'
    //         left join tbl_orc_headcount_demissoes ohdt1 on ohdt1.tipo_table = '$tipoTableOrcamento' and  ohdt1.tipo = 1 and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id
    //         left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes'
    //         left join tbl_orc_headcount_demissoes ohdt2 on ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes=1 and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id
    //         left join tbl_orc_headcount_demissoes ohdt3 on ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes=1 and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id
    //         left join tbl_orc_promocao ope on ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=1 and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id
    //         left join tbl_orc_promocao ops on ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=1 and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id
    //         where olch.lotacao_id = $lotacao_id
    //             and orc.id = $orc_id
    //             and olch.tipo_table = '$tipoTableOrcamento'
    //         group by olch.id, olch.qtd_func_lot, coc.jan_orcado, cod.jan_orcado, ohdt3.qtde_pessoas, op.valor_parametro, olch.forecast_anterior
    //     ");

        return $values;
    }

    public function getValoresMeses($mes, $orc_id, $lotacao_id){
        // $repoOrc = new RepoOrcamento();
        // $tbl_orc_lot_carg_headcount = new OrcamLotCargoHeadcount(); 
        // $calcOrcamento = new CalcOrcamento();
        // $tbl_calc_orcamento = $calcOrcamento->getTable();
        // $orcLotCargHC = new OrcamLotCargoHeadcount();
        // $tbl_orc_carg_hc = $orcLotCargHC->getTable();
        // $tbl_orc_lot_carg_headcount = new OrcamLotCargoHeadcount(); 
        // $tb_orcam_headcount_contratacoes = new OrcHeadcountContratacoes();        
        // $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();     
        // $tbl_orc_promocao = new OrcPromocao(); 
        
        $meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];

        $mesAnt = $meses[$mes-1];
        $mesAtual = $meses[$mes];

        $tipoTableOrcamento = 'O';

        $values = DB::select("SELECT 
                 olch.id as lot_id,             
                (COALESCE(co.$mesAnt, 0)
                - COALESCE((SELECT SUM(qtde_pessoas) from tbl_orc_headcount_demissoes ohdt3 where ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes = $mes and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id ),0)
                - COALESCE((SELECT COUNT(id) from tbl_orc_headcount_demissoes ohdt2 where ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes = $mes and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id  ), 0) 
                + COALESCE((select coc.$mesAtual from tbl_orc_headcount_contratacoes ohc inner join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes' where ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id), 0) 
                - COALESCE((select cod.$mesAtual from tbl_orc_headcount_demissoes ohdt1 inner join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' where ohdt1.tipo_table = '$tipoTableOrcamento' and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id), 0) 
                + COALESCE((select count(id) from tbl_orc_promocao ope where ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=$mes and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id), 0) 
                - COALESCE((select count(id) from tbl_orc_promocao ops where ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=$mes and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id), 0)) as valor
            FROM [tbl_orcamento]  orc
            left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
            left join tbl_calc_orcamento co on co.origem_id = olch.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
            where (olch.lotacao_id = $lotacao_id)
            and orc.id = $orc_id
            and olch.tipo_table = '$tipoTableOrcamento'
        ");

        // $values = DB::select("
        //     SELECT 
        //         olch.id			as lot_id,
        //         COALESCE(co.$mesAnt, 0) + COALESCE(coc.$mesAtual, 0) - COALESCE(cod.$mesAtual, 0) - COUNT(ohdt2.func_id) - COALESCE(ohdt3.qtde_pessoas,0) + COUNT(ope.funcionario_id) - COUNT(ops.funcionario_id) as valor
        //     FROM [tbl_orcamento]  orc
        //     left join tbl_orc_lot_carg_headcount olch on olch.orc_id = orc.id and olch.tipo_table = '$tipoTableOrcamento'
        //     left join tbl_calc_orcamento co on co.origem_id = olch.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
        //     left join tbl_orc_headcount_contratacoes ohc on ohc.tipo_table = '$tipoTableOrcamento' and ohc.orcamento_id = olch.orc_id and ohc.lotacao_id = olch.lotacao_id and ohc.orc_cargo_id = olch.orc_cargo_id and ohc.ccusto_id = olch.ccusto_id and ohc.orc_turma_id = olch.orc_turma_id
        //     left join tbl_calc_orcamento coc on coc.origem_id = ohc.id and coc.tbl_origem = 'tbl_orc_headcount_contratacoes'
        //     left join tbl_orc_headcount_demissoes ohdt1 on ohdt1.tipo_table = '$tipoTableOrcamento' and  ohdt1.tipo = 1 and ohdt1.orcamento_id = olch.orc_id and ohdt1.lotacao_id = olch.lotacao_id and ohdt1.orc_cargo_id = olch.orc_cargo_id and ohdt1.ccusto_id = olch.ccusto_id and ohdt1.orc_turma_id = olch.orc_turma_id
        //     left join tbl_calc_orcamento cod on cod.origem_id = ohdt1.id and cod.tbl_origem = 'tbl_orc_headcount_demissoes' 
        //     left join tbl_orc_headcount_demissoes ohdt2 on ohdt2.tipo_table = '$tipoTableOrcamento' and  ohdt2.tipo = 2 and ohdt2.mes = $mes and ohdt2.orcamento_id = olch.orc_id and ohdt2.lotacao_id = olch.lotacao_id and ohdt2.orc_cargo_id = olch.orc_cargo_id and ohdt2.ccusto_id = olch.ccusto_id and ohdt2.orc_turma_id = olch.orc_turma_id
        //     left join tbl_orc_headcount_demissoes ohdt3 on ohdt3.tipo_table = '$tipoTableOrcamento' and  ohdt3.tipo = 3 and ohdt3.mes = $mes and ohdt3.orcamento_id = olch.orc_id and ohdt3.lotacao_id = olch.lotacao_id and ohdt3.orc_cargo_id = olch.orc_cargo_id and ohdt3.ccusto_id = olch.ccusto_id and ohdt3.orc_turma_id = olch.orc_turma_id
        //     left join tbl_orc_promocao ope on ope.tipo_table = '$tipoTableOrcamento' and ope.mes_promocao=$mes and ope.orc_id = orc.id and ope.lotacao_promovida_id = olch.lotacao_id and ope.ccusto_promovido_id = olch.ccusto_id and ope.cargo_promovido_id = olch.orc_cargo_id and ope.turma_promovida_id = olch.orc_turma_id
        //     left join tbl_orc_promocao ops on ops.tipo_table = '$tipoTableOrcamento' and ops.mes_promocao=$mes and ops.orc_id = orc.id and ops.lotacao_id = olch.lotacao_id and ops.ccusto_id = olch.ccusto_id and ops.cargo_atual_id = olch.orc_cargo_id and ops.turma_atual_id = olch.orc_turma_id
        //     where (olch.lotacao_id = $lotacao_id)
        //     and orc.id = $orc_id
        //     and olch.tipo_table = '$tipoTableOrcamento'
        //     group by olch.id, olch.qtd_func_lot, ohdt3.qtde_pessoas, coc.$mesAtual, cod.$mesAtual, co.$mesAnt
        // ");

        return $values;
    }

    public function updateForecastTotal($data){        
        $registro = $this->getModelEntity()->find($data['id']);
        if(!$registro){
            $this->setError("Registro não encontrado. Erro: 040520201534");
            return false;
        }
        try { 
            // DB::enableQueryLog();
            $this->getModelEntity()->where([
                ['orc_id', $registro->orc_id],
                ['lotacao_id', $registro->lotacao_id],
                ['orc_cargo_id', $registro->orc_cargo_id],
                ['ccusto_id', $registro->ccusto_id],
                ['tipo_table', $registro->tipo_table]
            ])->update(['forecast_total' => $data['forecast_total']]);
            // dd(DB::getQueryLog());
        } catch(\Illuminate\Database\QueryException $ex){ 
            $this->setError($ex);
            return false;
        }
        return true;
    }

    public function setTotaisHeadcount($data){
        $sameCargo = $this->getModelEntity()->where([
            ['orc_id',$data['orc_id']], 
            ['lotacao_id',$data['lotacao_id']],
            ['ccusto_id',$data['ccusto_id']],
            ['orc_cargo_id',$data['orc_cargo_id']],
            ['tipo_table','O']
        ])->first();

        if($sameCargo){
            $data['atual_total'] = $sameCargo['atual_total'];
            $data['forecast_total'] = $sameCargo['forecast_total'];
            return $data;
        }

        $data['forecast_total'] = $this->getForecastAnterior($data['orc_id'], $data['lotacao_id']);
        $data['atual_total'] = $this->getAtualTotal($data['lotacao_id'], $data['orc_cargo_id']);

        return $data;
    }

    public function getAtualTotal($orc_lotacao_id, $orc_cargo_id){

        $lot_id = OrcLotacao::find($orc_lotacao_id)->lotacao_id;
        $cargo_id = OrcCargo::find($orc_cargo_id)->cargo_id;

        $repo_func = new RepoFuncionario();

        return $repo_func->getQtdeFuncsByLotCarg($lot_id, $cargo_id);
    }

    public function getForecastAnterior($orc_id, $lotacao_id){
        $tbl_orcamento = new Orcamento();
        $tbl_orc_lot_carg_headcount = $this->getModelEntity();        
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_calc_orcamento = new CalcOrcamento();
        $repo_orcamento = new RepoOrcamento();
        
        $orc_atual = $repo_orcamento->getModelEntity()->find($orc_id);

        if(!$orc_atual){
            return false;
        }

        $ano = $orc_atual->ano;
        $orcamento_anterior = DB::select("SELECT top 1* from tbl_orcamento where ano = ($ano - 1)");
        if(count($orcamento_anterior) == 0){
            return 0;
        }
        $ultimo_periodo = DB::select("SELECT max(periodo) periodo from tbl_orc_lotacao where orcamento_id = {$orcamento_anterior[0]->id} and tipo_table = 'F'");
        if(count($ultimo_periodo) == 0 || $ultimo_periodo[0]->periodo == null){
            return 0;
        }
        $lotacao_base = DB::select("SELECT * FROM tbl_orc_lotacao where id = $lotacao_id");
        if(count($lotacao_base) == 0){
            return 0;
        }
        
        $forecast_anterior = $tbl_orcamento
        ->leftJoin($tbl_orc_lot_carg_headcount->getTable(),
                    $tbl_orcamento->getColunaAlias('id'), $tbl_orc_lot_carg_headcount->getColunaAlias('orc_id')) 
        ->leftJoin($tbl_orc_lotacao->getTable(),
                    $tbl_orc_lot_carg_headcount->getColunaAlias('lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_calc_orcamento->getTable(), $tbl_orc_lot_carg_headcount->getColunaAlias('id'), '=', 
                    DB::raw("{$tbl_calc_orcamento->getColunaAlias('origem_id')} and 
                    {$tbl_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tbl_orc_lot_carg_headcount->getTable()}'"))

        ->select($tbl_calc_orcamento->getColunaAlias('dez_orcado'))
        ->where([
            [$tbl_orcamento->getColunaAlias('ano'),$ano-1],//Ano anterior
            [$tbl_orcamento->getColunaAlias('status_aprovacao'),$repo_orcamento->getStatusAprovado()],//Aprovado
            [$tbl_orcamento->getColunaAlias('status_orc'),$repo_orcamento->getStatusLiberado()],//Liberado
            [$tbl_orc_lot_carg_headcount->getColunaAlias('tipo_table'), 'F'], //Forecast
            [$tbl_orc_lot_carg_headcount->getColunaAlias('periodo'), $ultimo_periodo[0]->periodo],
            [$tbl_orc_lotacao->getColunaAlias('lotacao_id'), $lotacao_base[0]->lotacao_id]
        ])
        ->first();


        if(!$forecast_anterior){
            return 0;
        }

        return $forecast_anterior->toArray()['dez_orcado'];
    }

    public function updateValues($values, $field_update){
        $table = $this->getModelEntity()->getTable();

        $cases = [];
        $ids = [];
        $params = [];

        foreach ($values as $item) {
            $id = (int) $item['id_princ'];
            $cases[] = "WHEN {$id} then ?";
            $params[] = $item[$field_update];
            $ids[] = $id;
        }

        $ids = implode(',', $ids);
        $cases = implode(' ', $cases); 
        // $params[] = Carbon::now()->format('Y-d-m');
        $params[] = $this->fillModificadoEm();

        return \DB::update("UPDATE {$table} SET {$field_update} = CASE id {$cases} END, updated_at = ? WHERE id in ({$ids})", $params);
    }

    public function loadTotalFuncCargoTurma($orc_id,$cargo_id,$turma_id){
        // dd("parametros",$orc_id,$cargo_id,$turma_id);
        $olch =  $this->getModelEntity();

        $num_func= $olch
        ->where($olch->getColunaAlias('orc_id'), $orc_id)
        ->where($olch->getColunaAlias('orc_cargo_id'), $cargo_id)
        ->where($olch->getColunaAlias('orc_turma_id'), $turma_id)
        ->first();
        // dd("numf unc", $num_func);
        return $num_func;
    }

    public function scriptUpdateForecastOrcadoAnt($orc_id, $lotacao_id,$cargo_id){
        $value  = 'Falha ao inserir registros na tela Cargo/Turma Erro: 300720201942';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC update_forecast_orcado_anterior :orc_id, :lotacao_id, :cargo_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':lotacao_id', $lotacao_id, \PDO::PARAM_INT );
            $stmt->bindParam(':cargo_id', $cargo_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 300720201943 | update_forecast_orcado_anterior';

            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $this->setError($e);
            return false;
        }
       DB::commit();
        
        // dd("insert clone", $retorno);
        return true;    
    }

    public function montaPeriodo($mes, $orc_id){
        $ano = DB::select("SELECT ano from tbl_orcamento where id = $orc_id");
        $mes = strlen($mes) == 1 ? "0".$mes : $mes;
        $periodo_desc = $ano[0]->ano."-".$mes."-01";
        return $periodo_desc;
    }
    public function listarNotificacoesHeadcount($orc_id, $periodo, $tipo_table){
        set_time_limit($this->getTimeOut());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $periodo_desc = $tipo_table == 'O' ? null : $this->montaPeriodo($periodo, $orc_id);

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo_desc, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        
        $where = $tipo_table == "F" ? " and month(nt.periodo) = '{$periodo}' and nt.tipo_aprovacao > 2 order by nt.id desc" : " and nt.tipo_aprovacao <= 2 order by nt.id desc";
        $where_lot = $tipo_table == 'F' ? " and month(olot.periodo) = '{$periodo}' and olot.tipo_table = 'F' " : " and olot.tipo_table = 'O' ";
        //dd($where);
        $select = DB::select("SELECT
            nt.id, nt.orc_lotacao_id, nt.orc_id, nt.descricao as exibicao, nt.tipo_aprovacao, nt.situacao,
            nt.user_aprovador_id, nt.user_pendencia_id, nt.data_hora, nt.historico, nt.justificativa,
            func_1.nome_funcionario as aprovador, 
            isnull(func_2.nome_funcionario,' - ') as usuario_pendencia,
            CASE nt.situacao
            WHEN 1 THEN 'Pendente'
            WHEN 2 THEN 'Aprovado'
            ELSE 'Rejeitado' END desc_situacao,
            
            CASE tipo_aprovacao
            WHEN 1 THEN 'Headcount'
            WHEN 2 THEN 'Valores Orçamento'
            WHEN 3 THEN 'Forecast'
            WHEN 4 THEN 'Valores Forecast'
            ELSE '-' END tipo_aprovacao_desc,

            lot.unid_lotac, lot.des_unid_lotac, concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as descricao_lotacao
            from tbl_notificacao as nt
            inner join tbl_funcionario as func_1 on func_1.id = nt.user_aprovador_id
            left join tbl_funcionario as func_2 on func_2.id = nt.user_pendencia_id
            
            inner join tbl_orc_lotacao as olot on olot.id = nt.orc_lotacao_id and olot.orcamento_id = nt.orc_id
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            where nt.orc_id = ? and lot.id in ($lotacoes_string) $where_lot $where 
        ", [$orc_id]);

        return $select;
    }

    public function deleteTelasByCargoTurma($cargo_id, $turma_id, $lotacao_id, $orc_id){
        try{
            $a = DB::delete("DELETE from tbl_calc_orcamento where origem_id in (
                SELECT id from tbl_orc_headcount_contratacoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O' and lotacao_id = ? and orcamento_id = ?
            ) and tbl_origem = 'tbl_orc_headcount_contratacoes' ", [$cargo_id, $turma_id, $lotacao_id, $orc_id]);

            $b = DB::delete("DELETE from tbl_orc_headcount_contratacoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O' and lotacao_id = ? and orcamento_id = ?", [$cargo_id, $turma_id, $lotacao_id, $orc_id]);
            
            $c = DB::delete("DELETE from tbl_calc_orcamento where origem_id in (
                SELECT id from tbl_orc_headcount_demissoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O' and lotacao_id = ? and orcamento_id = ?
            ) and tbl_origem = 'tbl_orc_headcount_demissoes' ", [$cargo_id, $turma_id, $lotacao_id, $orc_id]);
            
            $d = DB::delete("DELETE from tbl_orc_headcount_demissoes where orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O' and lotacao_id = ? and orcamento_id = ?", [$cargo_id, $turma_id, $lotacao_id, $orc_id]);
            
            $dados = DB::select("SELECT * from tbl_orc_promocao where orc_id = ? and (cargo_atual_id = ? and turma_atual_id = ? and tipo_table = 'O' and lotacao_id = ?) or (cargo_promovido_id = ? and turma_promovida_id = ? and tipo_table = 'O' and lotacao_promovida_id = ?)", [$orc_id, $cargo_id, $turma_id, $lotacao_id, $cargo_id, $turma_id, $lotacao_id]);
            foreach($dados as $dado){
                $existe_sub = DB::select("SELECT * from tbl_orc_promocao where sub_promocao_id = ?", [$dado->id]);
                if(count($existe_sub) > 0){
                    DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = 0 where id = ?", [$existe_sub[0]->id]);
                }
            }
            $e_ = DB::delete("DELETE from tbl_orc_promocao where orc_id = ? and (cargo_atual_id = ? and turma_atual_id = ? and tipo_table = 'O' and lotacao_id = ?) or (cargo_promovido_id = ? and turma_promovida_id = ? and tipo_table = 'O' and lotacao_promovida_id = ?)", [$orc_id, $cargo_id, $turma_id, $lotacao_id, $cargo_id, $turma_id, $lotacao_id]);

            $f = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_orc_salario_funcionario where orc_id = ? and tipo_table = 'O' and orc_cargo_id = ? and orc_turma_id = ? and lotacao_id = ? and tipo = 1) and tbl_origem = 'tbl_orc_salario_funcionario'", [$orc_id, $cargo_id, $turma_id, $lotacao_id]);
            $g = DB::delete("DELETE from tbl_orc_salario_funcionario where orc_id = ? and tipo_table = 'O' and orc_cargo_id = ? and orc_turma_id = ? and lotacao_id = ? and tipo = 1", [$orc_id, $cargo_id, $turma_id, $lotacao_id]);
            
            $h = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_orc_ferias where orcamento_id = ? and orc_turma_id = ? and cargo_id = ? and tipo_table = 'O') and tbl_origem = 'tbl_orc_ferias'", [$orc_id, $turma_id, $cargo_id]);
            $i= DB::delete("DELETE FROM tbl_orc_ferias where orcamento_id = ? and orc_turma_id = ? and cargo_id = ? and tipo_table = 'O'", [$orc_id, $turma_id, $cargo_id]);
            
            $j = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id in (select id from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O') and tbl_origem = 'tbl_headcount_hra_extra'", [$orc_id, $cargo_id, $turma_id]);
            $k = DB::delete("DELETE from tbl_headcount_hra_extra where orc_id = ? and orc_cargo_id = ? and orc_turma_id = ? and tipo_table = 'O'", [$orc_id, $cargo_id, $turma_id]);

            $this->calcHeadcount($orc_id, $lotacao_id, 1);
            $dados = array('lotacao_id'=>$lotacao_id, 'orc_id'=>$orc_id, 'id_princ'=>null);
            for($i = 1; $i <= 12; $i++){
                $result = $this->validaDistribuicao($i, $dados);

                if( $result === false){
                    $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Erro';
                    DB::rollBack();
                    return false;
                }
            }            

            return true;
        }
        catch(\Exception $e){
            DB::rollBack();
            return false;
        }
    }

    public function validaDistribuicao($mes, $dados){
        
        /*$meses = [
            1 => 'jan_orcado', 2 => 'fev_orcado', 3 => 'mar_orcado', 4 => 'abr_orcado', 5 => 'mai_orcado', 6 => 'jun_orcado', 
            7 => 'jul_orcado', 8 => 'ago_orcado', 9 => 'set_orcado', 10 => 'out_orcado', 11 => 'nov_orcado', 12 => 'dez_orcado'
        ];
        $par_id = DB::select("SELECT id from tblg_parametros where cod_parametro = 'TPFORECAST'")[0]->id;*/
        $dado1 = [];
        $orc_id = array_key_exists('orc_id', $dados) ? $dados['orc_id'] : $dados['orcamento_id'];

        if($mes == 1){
            $dado1 = $this->getValoresJan($orc_id, $dados['lotacao_id']);
        }
        // else{
        //     $dado1 = $this->getValoresMes($orc_id, $dados['lotacao_id'], $periodo, $par_id, $meses[$mes]);
        // }
        $dado2 = [];
        if($mes > 1){
            $dado2 = $this->getValoresMeses($mes, $orc_id, $dados['lotacao_id']);
        }
        

        if(count($dado1) > 0){
            foreach($dado1 as $value){
                if($value->valor < 0){
                    return false;
                }
            }
            
        }
        if(count($dado2) > 0){
            foreach($dado2 as $value){
                if($value->valor < 0){
                    return false;
                }
            }
        }
        return true;
    }
} 
