<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcamlotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;







use Illuminate\Support\Facades\DB;
 
class RepoHeadcountDemissoes extends RepoOrcamento
{
     protected $model_name_space='App\Modules\Natureza51\Entities\OrcHeadcountDemissoes';

     public function existePromocao($orc_id, $func_id, $tipo_table){
        $confere = DB::select('SELECT * from tbl_orc_promocao where orc_id = ? and tipo_table = ? and funcionario_id = ?', [$orc_id, $tipo_table, $func_id]);
        return count($confere) > 0 ? $confere : false;
     }
  
     public function created($data_request){     

        $data_request['mes'] = (!isset($data_request['mes'])) ? 0 : $data_request['mes'];
        $data_request['tipo_table'] = array_key_exists('tipo_table', $data_request) ? $data_request['tipo_table'] : 'O';

        if( $data_request['tipo'] == 2 ){
            // se retornar true o existePromocao(), eu vejo se existe nesse mes da demissao
            $existe_prom = $this->existePromocao($data_request['orcamento_id'], $data_request['func_id'], $data_request['tipo_table']);
            if($existe_prom !== false){
                if($existe_prom[0]->mes_promocao >= $data_request['mes']){
                    $retorno['status'] = 'error';
                    $retorno['msg'] = 'O funcionário selecionado foi promovido no mesmo mês ou no mês posterior!<br>Erro: 300920201039';
                    goto saida;
                }
              
                // && $this->existePromocao($data_request['orcamento_id'], $data_request['func_id'], $data_request['mes'], $data_request['tipo_table'])
                $data_request['lotacao_id'] = $existe_prom[0]->lotacao_promovida_id;
                $data_request['orc_cargo_id'] = $existe_prom[0]->cargo_promovido_id;
                $data_request['ccusto_id'] = $existe_prom[0]->ccusto_promovido_id;
                $data_request['orc_turma_id'] = $existe_prom[0]->turma_promovida_id;
            }

            
            if($this->orcFuncCargo($data_request) == false){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'O cargo indicado do funcionário selecionado tem grade salarial menor do que possui atualmente!';
                goto saida;

            }
        }
        $clausule = array(
            'orcamento_id'=>$data_request['orcamento_id'],
            'ccusto_id'=>$data_request['ccusto_id'],
            'lotacao_id'=>$data_request['lotacao_id'],
            'orc_cargo_id'=>$data_request['orc_cargo_id'],
            'orc_turma_id'=>$data_request['orc_turma_id'],
            'tipo'=>$data_request['tipo'],
            'mes'=>$data_request['mes'],
            'tipo_table'=>$data_request['tipo_table']
        ); 
        
        $clausuleFunc = array(
            'orcamento_id'=>$data_request['orcamento_id'],
            'func_id'=>$data_request['func_id'],
            'tipo_table'=>$data_request['tipo_table']
        ); 
        
        if(array_key_exists('func_id',$data_request) && ($data_request['func_id'] != null || $data_request['func_id'] != 0)){
            if($this->funcionarioEstabilidade($data_request['func_id'])){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Funcionário selecionado possui estabilidade!';
                goto saida;
            }
        }
        // $a = $this->getQuadroAtual($data_request['orcamento_id'],$data_request['lotacao_id'],$data_request['orc_cargo_id']);
        
        // $valida = $this->validateQuadroAtual($a,$data_request['meses_orcado']);
        
        // if($valida['status']=='error'){
        //     return $valida;
        // }




        if($this->hasDataOnDB($clausule)){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }

          
        if($this->hasDataOnDB($clausuleFunc) && $data_request['tipo'] == 2){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
            
        }

                
        if($data_request['tipo'] == 2){
            if(!$this->hasCargoTurmaNaLotacao($data_request)){                    
                $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . '. Erro: 210920201028.');
                goto saida;
            }
        }

        $headcount = new OrcamLotCargoHeadcount();
        
        $dados_hc = $headcount
        ->where('orc_id',$data_request['orcamento_id'])
        ->where('lotacao_id', $data_request['lotacao_id'])
        ->where('orc_cargo_id', $data_request['orc_cargo_id'])
        ->where('orc_turma_id', $data_request['orc_turma_id'])
        ->where('tipo_table', $data_request['tipo_table'])
        ->first();
        
        if($dados_hc == null){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao inserir registro. Dados não encontrados no Headcount!';
            goto saida;
        }
        $calc_orc = CalcOrcamento::where('tbl_origem',$headcount->getTable())->where('origem_id', $dados_hc->id)->first()->toArray();
        $meses_hc= [1=>'jan_orcado',
                    2=>'fev_orcado',
                    3 =>'mar_orcado',
                    4 =>'abr_orcado',
                    5 =>'mai_orcado',
                    6 =>'jun_orcado',
                    7 =>'jul_orcado',
                    8 =>'ago_orcado',
                    9 =>'set_orcado',
                    10=>'out_orcado',
                    11=>'nov_orcado',
                    12=>'dez_orcado'];

        $demissao_sigilosa = ($data_request['tipo'] == 2 && $data_request['lotacao_id'] != $data_request['lotacao_origem_id']) ? true : false;

        if($data_request['tipo'] == 2 || $data_request['tipo'] == 3){
            $mes_demissao = $data_request['mes'];
            $qtde_pessoas = $data_request['tipo']== 3 ? $data_request['qtde_pessoas'] : 1;
              
            

            if($qtde_pessoas > $calc_orc[$meses_hc[$mes_demissao]] && !$demissao_sigilosa){ 
                $retorno['status']='error'; 
                $retorno['msg']='Falha ao inserir registro. Número de demissões maior que o Headcount!';
            goto saida;
            }
        }           
        else {

            foreach ($meses_hc as $key => $mes) {

                //  dd("valor_mes", $data_request['meses_orcado']);
                $valor_mes = isset($data_request['meses_orcado'][$mes])? $data_request['meses_orcado'][$mes]: 0;
            
                if($calc_orc[$mes] <  $valor_mes){
                    // dd($valor_mes, $mes, $calc_orc);
                    // dd("calc_orc_mes", $calc_orc[$mes], $mes, $valor_mes);
                    // if($valor_mes < $calc_orc[$mes]){
                    
                    $retorno['status']='error'; 
                    $retorno['msg']='Falha ao inserir registro. Número de demissões maior que o Headcount!';
                    goto saida;
                } 
                
                for ($i=$key; $i <= 12; $i++) { 
                    // dd($valor_mes, $mes, $calc_orc);
                //    if($valor_mes > 0){
                //     dd($valor_mes, $mes, $calc_orc);
                //    }
                    $calc_orc[$meses_hc[$i]] =  $calc_orc[$meses_hc[$i]] - $valor_mes;
                }
            }
            

        }

        $repo_calc_orcamento = new RepoCalcOrcamento();
        DB::beginTransaction();
        
        try {

            $orc_func = new OrcFuncionario();
   
            $func = OrcFuncionario::where('orcamento_id',$data_request['orcamento_id'])
                                  ->where('funcionario_id',$data_request['func_id'])
                                  ->where('tipo_table','O')->first();
           
            if($func){
                if($func->cargo_atualizado == 0){
                    $func->orc_cargo_id=$data_request['orc_cargo_id'];
                    $func->orc_turma_id=$data_request['orc_turma_id'];
                    $func->cargo_atualizado = 1;
                    $func->updated_by = $this->fillModificadoPor();
                    $func->updated_at = $this->fillModificadoEm();
                    

                    $func->save();
                }
            }

            if($data_request['tipo'] == 2){
                if(!$this->hasCargoTurmaNaLotacao($data_request)){                    
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . '. Erro: 13020201726.');
                    goto saida;
                }
            }

            if($demissao_sigilosa){
                $data_request['l_sec'] = 1;
            }

            $id_orc_demissoes = $this->createParent($data_request);

            if(!$id_orc_demissoes){  
                // dd("nsjs30");

                $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted());
                goto saida;
            }  

            if($data_request['tipo'] == 1){

               

                $merge_tb_calc = [
                    'origem_id' => $id_orc_demissoes->id,
                    'tbl_origem' => $this->getModelEntity()->getTable()
                ];
                
                if(!$repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                    $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Erro: 13020201726.');
                    goto saida;
                }
            } 

            
            $repoHeadcount = new RepoHeadcount();

            if(!$repoHeadcount->calcHeadcount($data_request['orcamento_id'], $data_request['lotacao_id'])){
                $retorno['status']="error";
                $retorno['msg']=$repoHeadcount->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201112';                        
                $hasErro = true;
                abort(500, $retorno['msg']);
                return false;
            }

            $dados_calc = $this->validaValoresNegativos($data_request['orcamento_id'], $data_request['lotacao_id']);
            if(count($dados_calc) > 0){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }

            $msg_success = $demissao_sigilosa ? 'Demissão inserida com sucesso! <br> A demissão sigilosa cadastrada se encontra na lotação a contabilizar informada.' : 'Registro inserido com sucesso!';

            $retorno = array('status'=>'success','msg'=>$msg_success);
            goto saida;

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir o registro. Erro: 130120201728.'. $e);
        }
  

        saida:
        ($retorno['status']=='error')?DB::rollBack():DB::commit();
       
        return $retorno;
    }

    public function funcionarioEstabilidade($func_id){
        $select = DB::select("SELECT id, tp_estabi FROM tbl_funcionario where id = {$func_id} and tp_estabi = 1");
        return count($select) > 0 ? true : false;
    }
    public function hasCargoTurmaNaLotacao($data){
        $repo_headcount = new RepoHeadcount();

        $data_compare = [
            'orc_id' => $data['orcamento_id'],
            'lotacao_id' => $data['lotacao_id'],
            'orc_cargo_id' => $data['orc_cargo_id'],
            'ccusto_id' => $data['ccusto_id'],
            'orc_turma_id' => $data['orc_turma_id'],
            'tipo_table' => 'O'
        ];

        $headcount = $repo_headcount->getModelEntity()->where($data_compare)->get()->count();

        if($headcount){
            return true;
        }
        
        $data_insert = array_merge($data_compare,[            
            'qtd_func_lot' => 0,
            'atual_total' => 0,
            'forecast_anterior' => 0,
            'forecast_total' => 0,
            'fromMeses' => false,
            'quadroAtual' => 0,
        ]);
        $createHeadcount = $repo_headcount->createHeadcount($data_insert);
        if($createHeadcount['status'] == 'error'){
            $this->setError($repo_headcount->getErrosFlatted());
            return false;
        }

        return true;
    }

    public function createParent($data_request){
        $data_request = $this->putCargoIdOnData($data_request,$data_request['orc_cargo_id']);
        
        return parent::checkHeadcount($data_request);
    }

    public function deleteAll($value){
        $repo_calc_orc = new RepoCalcOrcamento();

        $orc_cargo = OrcCargo::where('orcamento_id', $value['orcamento_id'])->where('cargo_id', $value['cargo_id'])
        ->where('tipo_table','O')->first();
        
        if(!$orc_cargo){
            $retorno = array('status'=>'error','msg'=>'Cargo não encontrado. Erro: 290420201828.');
            goto saida;
        }

        $value['orc_cargo_id'] = $orc_cargo->id;
        unset($value['cargo_id']);
        
        DB::beginTransaction();
        try {

            $select = DB::select("SELECT * from tbl_orc_headcount_demissoes where orc_cargo_id = ? and orc_turma_id = ? and lotacao_id = ? and orcamento_id = ? and tipo_table = 'O'", [$value['orc_cargo_id'], $value['orc_turma_id'], $value['lotacao_id'], $value['orcamento_id']]);
            if(count($select) == 0){
                $retorno = array('status'=>'error','msg'=>'Registro não encontrado. Erro: 210120211115.');
                goto saida;
            }
            $id = $select[0]->id;
            $delete = DB::delete("DELETE FROM tbl_calc_orcamento where origem_id = ? and tbl_origem = 'tbl_orc_headcount_demissoes'", [$id]);

            if($delete === false){
                $retorno = array('status'=>'error','msg'=>'Falha ao deletar registro. Erro: 210120211117.');
                DB::rollBack();
                goto saida;
            }
            $all = $this->getModelEntity()->select('id')->where($value)->delete();

            if(!$all){
                $retorno = array('status'=>'error','msg'=>'Falha ao deletar registro. Erro: 230120201410.');
                DB::rollBack();
                goto saida;
            }

            if($this->deleteDiarioBordo($id, 'tbl_orc_headcount_demissoes') === false){
                $retorno = array('status'=>'error','msg'=>'Falha ao deletar Diário de Bordo. Erro: 220320211549.');
                DB::rollBack();
                goto saida;
            }
            $repoHeadcount = new RepoHeadcount();

            if(!$repoHeadcount->calcHeadcount($value['orcamento_id'], $value['lotacao_id'])){
                $retorno['status']="error";
                $retorno['msg']=$repoHeadcount->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201601';                        
                goto saida;               
            }  


           $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso.');

        } catch (\Exception $th) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro. Erro: 230120201358.');
        }


        
        saida:
        $retorno['status']=='success'?DB::commit():DB::rollBack();
        return $retorno;
    }

    public function validateQuadroAtual($quadro_atual,$meses){
        $cont =0;
        foreach ($meses as $mes) {
            if($mes > $quadro_atual[0]['qtd_func_lot']){
                return ['status'=>'error','msg'=>'Não é permitido demitir mais funcionário do que o quadro atual. Erro: 20320201602'];
            }

            
            if($cont > $quadro_atual[0]['qtd_func_lot']){
                //dd($cont);
                return ['status'=>'error','msg'=>'Não é permitido demitir mais funcionário do que o quadro atual. Erro: 20320201623'];
            }

            if($mes != null){

                // $cont++;
                $cont+=$mes;
                // dd($cont);
            }
            
        }
        return ['status'=>'success'];

    }


    public function orcFuncCargo($data_request){
        // dd("data_request", $data_request);
        $orcFunc = new OrcFuncionario();

        $data = json_decode(json_encode($data_request), true);

        $orc_id = $data['orcamento_id'];
        $func_id = $data['func_id'];
        $cargo_request = array_key_exists('cargo_atual_id', $data) ? $data['cargo_atual_id'] : $data['orc_cargo_id'];

        $cargo_orc_func = DB::select("SELECT orc_cargo_id from tbl_orc_funcionario as ofunc
           where orcamento_id = $orc_id and ofunc.funcionario_id = $func_id and ofunc.tipo_table = 'O'
        ");


        $data = json_decode(json_encode($cargo_orc_func), true);
        $cargo_orc_func = $data[0]['orc_cargo_id'];

        $gs_select = DB::select("SELECT LEFT(c.cod_cargo_basic,2) 
            from tbl_cargo as c
            left join tbl_orc_cargo as oc on oc.cargo_id = c.id
            where oc.id = $cargo_request
        ");

        $gs_atualizado = DB::select("SELECT LEFT(c.cod_cargo_basic,2) 
            from tbl_orc_funcionario as ofunc
            left join tbl_orc_cargo as oc on ofunc.orc_cargo_id = oc.id
            left join tbl_cargo as c on oc.cargo_id =c.id
            where ofunc.orc_cargo_id = $cargo_orc_func and ofunc.funcionario_id = $func_id

        ");


        if ($gs_atualizado == $gs_select){
            return true;
        }
        else if($gs_select >= $gs_atualizado){
            return true;
        }
        else{
            return false;
        }
    }
}
 