<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;

use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;

use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use Illuminate\Support\Facades\DB;

class RepoHeadcountResumo extends RepoOrcamento 
{
    private $tbl_calc_orc;

    public function __construct(){
        $this->tbl_calc_orc = new CalcOrcamento();
        parent::__construct(); 
    }
    public function resHeadcount(){
        $tbl_headcount = new OrcamLotCargoHeadcount();
    }   
    public function resHorasExtras($orc_id, $lotacao_id, $tipo_table, $periodo = null){
        // $this->getoRC
        $str = $tipo_table == 'O' ? "" : " and he.periodo = '{$periodo}'";
        $select = DB::select("SELECT

        cast( SUM(
        isnull(calc.jan_orcado,0) + isnull(calc.fev_orcado,0) + isnull(calc.mar_orcado,0) + isnull(calc.abr_orcado,0) + isnull(calc.mai_orcado,0) + 
        isnull(calc.jun_orcado,0) + isnull(calc.jul_orcado,0) + isnull(calc.ago_orcado,0) + isnull(calc.set_orcado,0) + isnull(calc.out_orcado,0) + 
        isnull(calc.nov_orcado,0) + isnull(calc.dez_orcado,0)) as decimal(18,2)) HE
    
        from tbl_headcount_hra_extra as he
        left join tbl_calc_orcamento as calc on he.id = calc.origem_id and calc.tbl_origem = 'tbl_headcount_hra_extra'
    
        where he.orc_id = {$orc_id} and he.lotacao_id = {$lotacao_id} and he.tipo_table = ?
        ".$str, [$tipo_table]);
        $select[0] = count($select) > 0 ? number_format($select[0]->HE,2,',','.') : 0;
        return $select;
    }
    public function resFerias($orc_id, $lotacao_id, $tipo_table, $periodo){
        /*$tbl_ferias = new OrcFerias();
        $where = [
            ['orcamento_id', $orc_id],
            ['lotacao_id',$lotacao_id]
        ];
        return $this->selectForAll($tbl_ferias,$where);*/
        $str = $tipo_table == 'O' ? "" : " and ferias.periodo = '{$periodo}'";
        $select = DB::select("SELECT 

            cast(sum(
				( CASE WHEN ferias.type = 0 THEN isnull(calc.jan_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.fev_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.mar_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.abr_orcado,0) ELSE 0 END) +

				( CASE WHEN ferias.type = 0 THEN isnull(calc.mai_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.jun_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.jul_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.ago_orcado,0) ELSE 0 END) +

				( CASE WHEN ferias.type = 0 THEN isnull(calc.set_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.out_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.nov_orcado,0) ELSE 0 END) +
				( CASE WHEN ferias.type = 0 THEN isnull(calc.dez_orcado,0) ELSE 0 END) 
				) + sum(( CASE WHEN ferias.type = 1 THEN 1 ELSE 0 END) ) 
			as integer) ferias
         
            FROM [tbl_orc_ferias] as ferias 

            inner join [tbl_calc_orcamento] as calc on calc.origem_id = ferias.id and calc.tbl_origem = 'tbl_orc_ferias'
            inner join tbl_orc_lot_carg_headcount as hd on hd.lotacao_id = ferias.lotacao_id and hd.orc_cargo_id = ferias.cargo_id and hd.orc_turma_id = ferias.orc_turma_id 

            where ferias.orcamento_id = {$orc_id} and ferias.lotacao_id = {$lotacao_id} and ferias.tipo_table = ?
        ".$str, [$tipo_table]);
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            $dados[$i]['total_tbl_orc_ferias'] = $dados[$i]['ferias'];
        }
        return $dados;
    }
    public function resContratacoes($orc_id, $lotacao_id, $tipo_table, $periodo){
        // $where = [
        //     ['orcamento_id', $orc_id],
        //     ['lotacao_id',$lotacao_id]
        // ];
        // $tbl_contratacoes = new OrcHeadcountContratacoes();
        // return $this->selectForAll($tbl_contratacoes,$where);
        $str = $tipo_table == 'O' ? "" : " and cont.periodo = '{$periodo}'" ;
        $select = DB::select("SELECT 
        sum(
        isnull(calc_cont.jan_orcado,0) + isnull(calc_cont.fev_orcado,0) + isnull(calc_cont.mar_orcado,0) + isnull(calc_cont.abr_orcado,0) + isnull(calc_cont.mai_orcado,0) + 
        isnull(calc_cont.jun_orcado,0) + isnull(calc_cont.jul_orcado,0) + isnull(calc_cont.ago_orcado,0) + isnull(calc_cont.set_orcado,0) + isnull(calc_cont.out_orcado,0) + 
        isnull(calc_cont.nov_orcado,0) + isnull(calc_cont.dez_orcado,0)) as CONTRATACOES 	
        
        FROM [tbl_orc_lotacao] as orc_lot 
    
        left join [tbl_orc_headcount_contratacoes] as cont on cont.lotacao_id = orc_lot.id
        left join [tbl_calc_orcamento] as calc_cont on calc_cont.origem_id = cont.id and calc_cont.tbl_origem = 'tbl_orc_headcount_contratacoes'
    
        where orc_lot.orcamento_id = {$orc_id} and orc_lot.id = {$lotacao_id} and cont.tipo_table = ? 
        ".$str, [$tipo_table]);
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            $dados[$i]['total_tbl_orc_headcount_contratacoes'] = number_format($dados[$i]['CONTRATACOES'],0);
        }
        return $dados;
    }
    public function resDemissoes($orc_id, $lotacao_id, $tipo_table, $periodo){
        // $where = [
        //     ['orcamento_id', $orc_id],
        //     ['lotacao_id',$lotacao_id]
        // ];

        // $tbl_demissoes = new OrcHeadcountDemissoes();
        // return $this->selectForAll($tbl_demissoes,$where);
        $str = $tipo_table == 'O' ? "" : " and dem.periodo = '{$periodo}'" ; 
        $sub_str = $tipo_table == 'O' ? "" : " and d.periodo = '{$periodo}'" ; 

        $table = 'tbl_orc_headcount_demissoes';
        $select = DB::select("SELECT sum(
            isnull(calc.jan_orcado,0) + isnull(calc.fev_orcado,0) + isnull(calc.mar_orcado,0) + isnull(calc.abr_orcado,0) + isnull(calc.mai_orcado,0) + 
            isnull(calc.jun_orcado,0) + isnull(calc.jul_orcado,0) + isnull(calc.ago_orcado,0) + isnull(calc.set_orcado,0) + isnull(calc.out_orcado,0) + 
            isnull(calc.nov_orcado,0) + isnull(calc.dez_orcado,0)) as DEMISSOES, 
            
            (SELECT count(*) from tbl_orc_headcount_demissoes as d 
                where d.orcamento_id = {$orc_id} and d.lotacao_id = {$lotacao_id} and d.tipo <> 1 and d.tipo_table = ? {$sub_str} ) as count_d
            
            from tbl_orc_headcount_demissoes as dem
            left join [tbl_calc_orcamento] as calc on 
            dem.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_headcount_demissoes'
            where orcamento_id = {$orc_id} and lotacao_id = {$lotacao_id} and dem.tipo_table = ?
        ".$str, [$tipo_table, $tipo_table]);
        
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            $dados[$i]['total_tbl_orc_headcount_demissoes'] = intval($dados[$i]['DEMISSOES'], 10) + intval($dados[$i]['count_d'], 10);
        }
        return $dados;
    }

    public function resumoAll($orc_id, $lotacao_id, $tipo_table, $periodo){
        
       
        /*$repo_orc_turma = new RepoOrcTurma();
        $repo_orc_cargo = new RepoOrcCargo();
        $repo_cargo = new Cargo();

        $entity_headcount = $repo_headcount->getModelEntity();
        $entity_promocao = $repo_promocao->getModelEntity();
        $entity_contratacoes = $repo_contratacoes->getModelEntity();
        $entity_demissoes = $repo_demissoes->getModelEntity();
        $entity_calc_orc = $repo_calc_orc->getModelEntity();*/
        
        $orc_id = intval($orc_id, 10);
        if($tipo_table == 'F'){
            return $this->resumoAllForecast($orc_id, $lotacao_id, $tipo_table, $periodo);
        }
        else{

            $select = DB::select("SELECT distinct
            orc_lot.orcamento_id,
            orc_lot.id,
            lot.des_unid_lotac,
            CONCAT(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as des_cargo_basic,
            hd.orc_cargo_id,
            hd.ccusto_id, 
                cast( SUM(isnull(calc.dez_orcado,0)) as integer) HeadCount,

            AVG(isnull(hd.atual_total,0))  atual_total,
            AVG(isnull(hd.forecast_total,0))  forecast,
            cast(SUM(isnull(hd.orcado_anterior,0))  as integer) orcado,
            

            cast(  SUM(
            isnull(calc_cont.jan_orcado,0) + isnull(calc_cont.fev_orcado,0) + isnull(calc_cont.mar_orcado,0) + isnull(calc_cont.abr_orcado,0) + isnull(calc_cont.mai_orcado,0) + 
            isnull(calc_cont.jun_orcado,0) + isnull(calc_cont.jul_orcado,0) + isnull(calc_cont.ago_orcado,0) + isnull(calc_cont.set_orcado,0) + isnull(calc_cont.out_orcado,0) + 
            isnull(calc_cont.nov_orcado,0) + isnull(calc_cont.dez_orcado,0)) as integer)  CONTRATACOES,
                    
            cast(COUNT(promocao.mes_promocao)  as integer)PROM,
            
            cast(SUM(
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jan_orcado ,0) WHEN (tipo = 2 and mes = 1) THEN 1 WHEN (tipo = 3 and mes = 1) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.fev_orcado ,0) WHEN (tipo = 2 and mes = 2) THEN 1 WHEN (tipo = 3 and mes = 2) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.mar_orcado ,0) WHEN (tipo = 2 and mes = 3) THEN 1 WHEN (tipo = 3 and mes = 3) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.abr_orcado ,0) WHEN (tipo = 2 and mes = 4) THEN 1 WHEN (tipo = 3 and mes = 4) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +

                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.mai_orcado ,0) WHEN (tipo = 2 and mes = 5) THEN 1 WHEN (tipo = 3 and mes = 5) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jun_orcado ,0) WHEN (tipo = 2 and mes = 6) THEN 1 WHEN (tipo = 3 and mes = 6) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jul_orcado ,0) WHEN (tipo = 2 and mes = 7) THEN 1 WHEN (tipo = 3 and mes = 7) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.ago_orcado ,0) WHEN (tipo = 2 and mes = 8) THEN 1 WHEN (tipo = 3 and mes = 8) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +

                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.set_orcado ,0) WHEN (tipo = 2 and mes = 9) THEN 1 WHEN (tipo = 3 and mes = 9) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.out_orcado ,0) WHEN (tipo = 2 and mes = 10) THEN 1 WHEN (tipo = 3 and mes = 10) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.nov_orcado ,0) WHEN (tipo = 2 and mes = 11) THEN 1 WHEN (tipo = 3 and mes = 11) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
                ( CASE WHEN tipo = 1 THEN isnull(calc_dem.dez_orcado ,0) WHEN (tipo = 2 and mes = 12) THEN 1 WHEN (tipo = 3 and mes = 12) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END)
            )  as integer) DEMISSOES
        
            FROM [tbl_orc_lotacao] as orc_lot 
                    
            left join [tbl_lotacao] as lot on orc_lot.lotacao_id = lot.id

            left join [tbl_orc_lot_carg_headcount] as hd on 
            orc_lot.id = hd.lotacao_id and
            orc_lot.orcamento_id = hd.orc_id and
            orc_lot.cc_custo_id = hd.ccusto_id and
            hd.tipo_table = 'O'
                        
            left join [tbl_orc_promocao] as promocao on 
            
            hd.orc_cargo_id = promocao.cargo_promovido_id and
            hd.lotacao_id = promocao.lotacao_promovida_id and 
            hd.ccusto_id = promocao.ccusto_promovido_id and
            hd.orc_id = promocao.orc_id and
            hd.orc_turma_id = promocao.turma_atual_id and
            promocao.tipo_table = 'O' and
		    promocao.cargo_atual_id <> promocao.cargo_promovido_id
                    
            left join [tbl_orc_headcount_contratacoes] as hdcont on 
            
            hd.orc_id = hdcont.orcamento_id and
            hd.orc_cargo_id = hdcont.orc_cargo_id and
            hd.ccusto_id = hdcont.ccusto_id and
            hd.lotacao_id = hdcont.lotacao_id and
            hd.orc_turma_id = hdcont.orc_turma_id and
            hdcont.tipo_table = 'O'
                    
            left join [tbl_orc_headcount_demissoes] as hddem on 

            hd.lotacao_id = hddem.lotacao_id and
            hd.orc_id = hddem.orcamento_id and
            hd.orc_cargo_id = hddem.orc_cargo_id and
            hd.ccusto_id = hddem.ccusto_id and
            hd.orc_turma_id = hddem.orc_turma_id and
            hddem.tipo_table = 'O'

                    
            left join [tbl_orc_cargo] as orc_cargo on 
            hd.orc_cargo_id = orc_cargo.id and
            orc_cargo.orcamento_id = hd.orc_id

            left join [tbl_cargo] as cargo on
            orc_cargo.cargo_id = cargo.id
                    
            left join [tbl_calc_orcamento] as calc on 
            calc.origem_id = hd.id and
            calc.tbl_origem = 'tbl_orc_lot_carg_headcount'

            left join [tbl_calc_orcamento] as calc_cont on 
            calc_cont.origem_id = hdcont.id and 
            calc_cont.tbl_origem = 'tbl_orc_headcount_contratacoes'

            left join [tbl_calc_orcamento] as calc_dem on
            calc_dem.origem_id = hddem.id and
            calc_dem.tbl_origem = 'tbl_orc_headcount_demissoes'

            where orc_lot.orcamento_id = {$orc_id} and orc_lot.id = {$lotacao_id}
            and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
            calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
            calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = ?

            group by hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, orc_lot.orcamento_id, orc_lot.id, lot.des_unid_lotac, cargo.cod_cargo_basic, cargo.des_cargo_basic

            ", [$tipo_table]);
            $dados = [];
            
            for($i = 0; $i < count($select); $i++){
                $dados[$i] = (array) $select[$i];
                
            }
            $y = count($dados);
            $dados[$y]['des_cargo_basic'] = 'total';
            return $dados;
        }
    }

    public function resumoAllForecast($orc_id, $lotacao_id, $tipo_table, $periodo){
        $select = DB::select("SELECT distinct
        orc_lot.orcamento_id,
        orc_lot.id,
        lot.des_unid_lotac,
        CONCAT(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic) as des_cargo_basic,
        hd.orc_cargo_id,
        hd.ccusto_id, 
            cast( SUM(isnull(calc.dez_orcado,0)) as integer) HeadCount,

        AVG(isnull(hd.atual_total,0))  atual_total,
        AVG(isnull(hd.forecast_total,0))  forecast,
        cast(SUM(isnull(hd.orcado_anterior,0))  as integer) orcado,
        

        cast(  SUM(
        isnull(calc_cont.jan_orcado,0) + isnull(calc_cont.fev_orcado,0) + isnull(calc_cont.mar_orcado,0) + isnull(calc_cont.abr_orcado,0) + isnull(calc_cont.mai_orcado,0) + 
        isnull(calc_cont.jun_orcado,0) + isnull(calc_cont.jul_orcado,0) + isnull(calc_cont.ago_orcado,0) + isnull(calc_cont.set_orcado,0) + isnull(calc_cont.out_orcado,0) + 
        isnull(calc_cont.nov_orcado,0) + isnull(calc_cont.dez_orcado,0)) as integer)  CONTRATACOES,
                
        --cast(COUNT(promocao.mes_promocao)  as integer)PROM,
        (select count(*) from tbl_orc_promocao as prom
			where prom.orc_id = {$orc_id} and prom.lotacao_promovida_id = hd.lotacao_id and cargo_promovido_id = hd.orc_cargo_id /*and prom.turma_promovida_id = hd.orc_turma_id*/
			and prom.periodo = '{$periodo}' and prom.tipo_table = '{$tipo_table}' and prom.cargo_atual_id <> prom.cargo_promovido_id
		) as PROM,
        
        cast(SUM(
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jan_orcado ,0) WHEN (tipo = 2 and mes = 1) THEN 1 WHEN (tipo = 3 and mes = 1) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.fev_orcado ,0) WHEN (tipo = 2 and mes = 2) THEN 1 WHEN (tipo = 3 and mes = 2) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.mar_orcado ,0) WHEN (tipo = 2 and mes = 3) THEN 1 WHEN (tipo = 3 and mes = 3) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.abr_orcado ,0) WHEN (tipo = 2 and mes = 4) THEN 1 WHEN (tipo = 3 and mes = 4) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +

            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.mai_orcado ,0) WHEN (tipo = 2 and mes = 5) THEN 1 WHEN (tipo = 3 and mes = 5) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jun_orcado ,0) WHEN (tipo = 2 and mes = 6) THEN 1 WHEN (tipo = 3 and mes = 6) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.jul_orcado ,0) WHEN (tipo = 2 and mes = 7) THEN 1 WHEN (tipo = 3 and mes = 7) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.ago_orcado ,0) WHEN (tipo = 2 and mes = 8) THEN 1 WHEN (tipo = 3 and mes = 8) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +

            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.set_orcado ,0) WHEN (tipo = 2 and mes = 9) THEN 1 WHEN (tipo = 3 and mes = 9) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.out_orcado ,0) WHEN (tipo = 2 and mes = 10) THEN 1 WHEN (tipo = 3 and mes = 10) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.nov_orcado ,0) WHEN (tipo = 2 and mes = 11) THEN 1 WHEN (tipo = 3 and mes = 11) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END) +
            ( CASE WHEN tipo = 1 THEN isnull(calc_dem.dez_orcado ,0) WHEN (tipo = 2 and mes = 12) THEN 1 WHEN (tipo = 3 and mes = 12) THEN isnull(hddem.qtde_pessoas,0) ELSE 0 END)
        )  as integer) DEMISSOES
    
        FROM [tbl_orc_lotacao] as orc_lot 
                
        left join [tbl_lotacao] as lot on orc_lot.lotacao_id = lot.id

        left join [tbl_orc_lot_carg_headcount] as hd on 
        orc_lot.id = hd.lotacao_id and
        orc_lot.orcamento_id = hd.orc_id and
        orc_lot.cc_custo_id = hd.ccusto_id and
        hd.periodo = '{$periodo}' and
        hd.tipo_table = 'F'
                    
        /*left join [tbl_orc_promocao] as promocao on 
        
        hd.orc_cargo_id = promocao.cargo_promovido_id and
        hd.lotacao_id = promocao.lotacao_promovida_id and 
        hd.ccusto_id = promocao.ccusto_promovido_id and
        hd.orc_id = promocao.orc_id and
        hd.orc_turma_id = promocao.turma_promovida_id and
        promocao.periodo = '{$periodo}' and
        promocao.tipo_table = 'F' and
		promocao.cargo_atual_id <> promocao.cargo_promovido_id*/
                
        left join [tbl_orc_headcount_contratacoes] as hdcont on 
        
        hd.orc_id = hdcont.orcamento_id and
        hd.orc_cargo_id = hdcont.orc_cargo_id and
        hd.ccusto_id = hdcont.ccusto_id and
        hd.lotacao_id = hdcont.lotacao_id and
        hd.orc_turma_id = hdcont.orc_turma_id and
        hdcont.periodo = '{$periodo}' and
        hdcont.tipo_table = 'F'
                
        left join [tbl_orc_headcount_demissoes] as hddem on 

        hd.lotacao_id = hddem.lotacao_id and
        hd.orc_id = hddem.orcamento_id and
        hd.orc_cargo_id = hddem.orc_cargo_id and
        hd.ccusto_id = hddem.ccusto_id and
        hd.orc_turma_id = hddem.orc_turma_id and
        hddem.periodo = '{$periodo}' and
        hddem.tipo_table = 'F'

                
        left join [tbl_orc_cargo] as orc_cargo on 
        hd.orc_cargo_id = orc_cargo.id and
        orc_cargo.orcamento_id = hd.orc_id

        left join [tbl_cargo] as cargo on
        orc_cargo.cargo_id = cargo.id
                
        left join [tbl_calc_orcamento] as calc on 
        calc.origem_id = hd.id and
        calc.tbl_origem = 'tbl_orc_lot_carg_headcount'

        left join [tbl_calc_orcamento] as calc_cont on 
        calc_cont.origem_id = hdcont.id and 
        calc_cont.tbl_origem = 'tbl_orc_headcount_contratacoes'

        left join [tbl_calc_orcamento] as calc_dem on
        calc_dem.origem_id = hddem.id and
        calc_dem.tbl_origem = 'tbl_orc_headcount_demissoes'

        where orc_lot.orcamento_id = $orc_id and orc_lot.id = $lotacao_id
        and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
        ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
        calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
        calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = ? and hd.periodo = '{$periodo}'

        group by hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, orc_lot.orcamento_id, orc_lot.id, lot.des_unid_lotac, cargo.cod_cargo_basic, cargo.des_cargo_basic
        ", [$tipo_table]);
        
        $dados = [];
        
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array) $select[$i];
        }
        return $dados;
    }
    public function listarAllToForecast($orc_id, $lotacao_id, $tipo_table, $periodo){

    }
    public function selectForAll($table,$where){

        
        return $table->select(        
            DB::raw("format(sum({$this->tbl_calc_orc->getColunaAlias('jan_orcado')} + {$this->tbl_calc_orc->getColunaAlias('fev_orcado')} + {$this->tbl_calc_orc->getColunaAlias('mar_orcado')} + {$this->tbl_calc_orc->getColunaAlias('abr_orcado')} + {$this->tbl_calc_orc->getColunaAlias('mai_orcado')} + {$this->tbl_calc_orc->getColunaAlias('jun_orcado')} + {$this->tbl_calc_orc->getColunaAlias('jul_orcado')} + {$this->tbl_calc_orc->getColunaAlias('ago_orcado')} + {$this->tbl_calc_orc->getColunaAlias('set_orcado')} + {$this->tbl_calc_orc->getColunaAlias('out_orcado')} + {$this->tbl_calc_orc->getColunaAlias('nov_orcado')} + {$this->tbl_calc_orc->getColunaAlias('dez_orcado')}),'n','pt-br') as total_".$table->getTable())
            )
            ->leftJoin($this->tbl_calc_orc->getTable(), $table->getColunaAlias('id'), '=',                            
            DB::raw("{$this->tbl_calc_orc->getColunaAlias('origem_id')}")) 
            ->where($this->tbl_calc_orc->getColunaAlias('tbl_origem'), $table->getTable()) 
            ->where($where)->get(); 
    } 


    public function resJovemAprendiz($orc_id,$lotacao_id){
       

       $data=DB::select("select 
       SUM(tb_co.dez_orcado*CONVERT(DECIMAL,tb_op.valor_parametro)/100) as total
      
       from tbl_orc_lot_carg_headcount as tb_olch
      
       join tbl_orc_cargo as tb_oc on tb_oc.id = tb_olch.orc_cargo_id
       join tbl_cargo as tb_c on tb_oc.cargo_id = tb_c.id
       join tbl_orc_parametros as tb_op on tb_op.orcamento_id = tb_olch.orc_id and tb_op.parametro_id = 5
       join tbl_calc_orcamento as tb_co on tb_co.origem_id = tb_olch.id and tb_co.tbl_origem='tbl_orc_lot_carg_headcount'
       
       where tb_olch.orc_id= $orc_id and tb_olch.lotacao_id = $lotacao_id and tb_c.cota_jovem_aprendiz = 1
       group by tb_olch.orc_cargo_id"
    );
    return  count($data)!=0 ? number_format(is_null($data[0]->total) ? 0 : $data[0]->total) : 0;

    }

    public function resPcd($orc_id, $lotacao_id, $tipo_table, $periodo = null){
        $where_periodo = $tipo_table == 'F' ? " and tbl_orc_lotacao.periodo = '{$periodo}'" : "";

        $data = DB::select(
            "SELECT 
            COUNT(*)*CONVERT(DECIMAL,tb_op.valor_parametro)/100 as total
           
            from tbl_funcionario as tb_func
            
            join tbl_orc_lotacao on tbl_orc_lotacao.lotacao_id = tb_func.lotacao_id and tbl_orc_lotacao.cc_custo_id = tb_func.ccusto_id and tbl_orc_lotacao.tipo_table = '{$tipo_table}' {$where_periodo}
    
            join tblg_parametros as prm on prm.cod_parametro = 'CTPCD'
            join tbl_orc_parametros as tb_op on tb_op.orcamento_id = tbl_orc_lotacao.orcamento_id and tb_op.parametro_id = prm.id
                
            where tbl_orc_lotacao.id = $lotacao_id and tbl_orc_lotacao.orcamento_id = {$orc_id} and (tb_func.pne = 0 or tb_func.pne is null)  
            group by tbl_orc_lotacao.id, tb_op.valor_parametro"
        );
        
        $data[0] = count($data) > 0 ? number_format(ceil($data[0]->total), 2, ',', '.') : 0;
        return $data;
        // return number_format($data[0]->total,6,',','.');

        
        // $data=DB::select("select 
        // count(funcionario.qtde) as func_qtde, SUM(CONVERT(DECIMAL,tb_op.valor_parametro)/100) as parametro
       
        // from tbl_orc_lot_carg_headcount as tb_olch
       
        // join tbl_orc_cargo as tb_oc on tb_oc.id = tb_olch.orc_cargo_id
        // join tbl_cargo as tb_c on tb_oc.cargo_id = tb_c.id
        // join tbl_orc_parametros as tb_op on tb_op.orcamento_id = tb_olch.orc_id and tb_op.parametro_id = 1
        // join tbl_calc_orcamento as tb_co on tb_co.origem_id = tb_olch.id and tb_co.tbl_origem='tbl_orc_lot_carg_headcount'
        // left join tbl_orc_lotacao on tbl_orc_lotacao.id = tb_olch.lotacao_id

        // left join 

		// (select count(*) as qtde,  tbl_funcionario.cargo_id,  tbl_funcionario.lotacao_id,  tbl_funcionario.ccusto_id from tbl_funcionario 
		// where tbl_funcionario.pne = 0
		// group by tbl_funcionario.cargo_id, tbl_funcionario.lotacao_id, tbl_funcionario.ccusto_id)

		// as funcionario on
		// funcionario.lotacao_id = tbl_orc_lotacao.lotacao_id and
		// funcionario.cargo_id =  tb_oc.cargo_id and
		// funcionario.ccusto_id = tbl_orc_lotacao.cc_custo_id

        
        // where tb_olch.orc_id= {$orc_id} and tb_olch.lotacao_id = {$lotacao_id} and tb_c.cota_pcd = 1"
        // );
        // // dd("data", $data[0]->total);
        // //return  count($data)!=0 ? number_format(is_null($data[0]->total) ? 0 : $data[0]->total) : 0;
        // // return $data;
        // $total = (count($data) > 0 && $data != null) ? (floatval($data[0]->func_qtde) * floatval($data[0]->parametro)) : 0;
        
        // return number_format($total,6);

    }
}


     








