<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoHistorico extends RepoOrcamento{

    public function loadPremissas($orc_id, $periodo = null, $tipo_table = 'O'){
        $where = $tipo_table == 'F' ? " and periodo = '{$periodo}' " : "";
        $select = DB::select("SELECT * FROM tbl_orc_premissas_hist as oph
            where orcamento_id = {$orc_id} and tipo_table = '{$tipo_table}' {$where};
        ");

        return $select;
    }

    public function loadParametros($orc_id, $periodo = null, $tipo_table = 'O'){
        $where = $tipo_table == 'F' ? " and oph.periodo = '{$periodo}' " : "";
        $select = DB::select("SELECT oph.id, valor_parametro, par.id as param_id, par.cod_parametro, par.descricao,
            par.tipo_parametro, par.tipo_dados, popt.id as op_id, popt.parametro_id as op_param_id, popt.cod_opcao, popt.opcao
            from tbl_orc_parametros_hist as oph
            inner join tblg_parametros as par on par.id = oph.parametro_id
            left join tblg_parametros_options as popt on popt.parametro_id = par.id
            where oph.orcamento_id = {$orc_id} and oph.tipo_table = '{$tipo_table}' {$where}
        ");

        
        $pais = [];
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[] = (array) $select[$i];
            if($dados[$i]['op_id'] != null && $dados[$i]['param_id'] == $dados[$i]['op_param_id']){
                array_push($pais, $dados[$i]);
            }
        }
        for($i = 0; $i < count($dados); $i++){
            for($y = 0; $y < count($pais); $y++){
                if($dados[$i]['id'] == $pais[$y]['id']){
                    $dados[$i]['items'][] = $pais[$y];
                }
            }
        }
        
        $data = [];
        $existe = false;
        for($i = 0; $i < count($dados); $i++){
            for($y = 0; $y < count($data); $y++){
                if($data[$y]['id'] == $dados[$i]['id']){
                    $existe = true;
                    break;
                }
                else{
                    $existe = false;
                }
            }
            if($existe == false){
                $data[] = $dados[$i];
            }
        }

        return $data;
    }

    public function loadParametroNaturezaEvento($orc_id, $periodo = null, $tipo_table = 'O'){
        $where = $tipo_table == 'F' ? " and opnh.periodo = '{$periodo}' " : "";
        $select = DB::select("SELECT concat(ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as conta_contabil, concat(evento.cdn_event, ' - ', evento.des_event) as evento, opnh.handle_arguments,
                opnh.ordem_execucao, CASE opnh.base_recisao WHEN 1 THEN 'Sim' ELSE 'Não' END base_recisao, case when evt_ad.cdn_event is null then '-' else concat(evt_ad.cdn_event, ' - ', evt_ad.des_event) end evento_adicional,
                opnh.evento_principal_id, opnh.cta_contabil_id, opneh.evento_id as 'evento_adicional_id'
                
            from tbl_orc_param_natureza_hist as opnh
            inner join tbl_eventos as evento on evento.id = opnh.evento_principal_id
            inner join tbl_cta_contabil as ctactb on ctactb.id = opnh.cta_contabil_id
            
            left join tbl_orc_param_natureza_eventos_adicionais_hist as opneh on opneh.orc_param_natureza_id = opnh.id
            left join tbl_eventos as evt_ad on evt_ad.id = opneh.evento_id
            
            where opnh.orcamento_id = {$orc_id} and opnh.tipo_table = '{$tipo_table}' {$where} order by opnh.ordem_execucao asc
        ");

        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[] = (array)$select[$i];
        }
        return $dados;
    }
}