<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;


use DB;

class RepoHomeRealizado extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
    protected $form_rules = [];
    protected $rules_msg = [];

    public function listarRealizadoHome($orc_id){
		// dd("orcamento", $orc_id);
		set_time_limit(700);
		$tipo_table = 'R'; 
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		/*$tb_orc_lot_carg_headcount = new OrcamLotCargoHeadcount();
		$tb_calc_orcamento = new CalcOrcamento();
		$tb_cargo = new Cargo();
		$tb_centro_custo = new CentroCusto();
		$tb_turma = new OrcTurma();
		$tb_turno = new Turno();
		$tb_lotacao = new OrcLotacao();
		$tb_orc_cargo = new OrcCargo();*/
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );

			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
		// dd("lot str", $lotacoes_string);
        
		DB::enableQueryLog();
	
		$query = "
        select 	
		[tbl_calc_orcamento].id,
		tbl_orc_lot_carg_headcount.id as id_princ, 
		[tbl_orc_lot_carg_headcount].[orc_id], [tbl_orc_lot_carg_headcount].[qtd_func_lot], 
		[tbl_orc_lot_carg_headcount].[atual_total], 
		[tbl_orc_lot_carg_headcount].[lotacao_id], 
		tbl_lotacao.des_unid_lotac,
		tbl_lotacao.unid_lotac,
		[tbl_orc_lot_carg_headcount].[orcado_anterior], 
		[tbl_orc_lot_carg_headcount].[origem_sistema],
		[tbl_orc_lot_carg_headcount].[orc_cargo_id],
		[tbl_orc_cargo].[cargo_id], 
		[tbl_cargo].[cod_cargo_basic], 
		[tbl_cargo].[des_cargo_basic], 
		[tbl_orc_lot_carg_headcount].[ccusto_id], 
		[tbl_ccusto].[cod_ccusto], 
		[tbl_orc_turma].[cdn_turma_trab], 
		[tbl_orc_turma].[des_turma_trab], 
		[tbl_turno].[cdn_turno_trab], 
		[tbl_turno].[des_turno_trab], 
		[tbl_orc_lot_carg_headcount].[orc_turma_id], 
		[tbl_orc_lot_carg_headcount].[forecast_anterior], 
		[tbl_orc_lot_carg_headcount].[forecast_total],
		CONCAT(tbl_cargo.cod_cargo_basic, ' - ', tbl_cargo.des_cargo_basic) as 'cargo',
		CONCAT(tbl_lotacao.des_unid_lotac, ' - ', tbl_lotacao.unid_lotac) as 'lotacao',

		CASE when [tbl_orc_lotacao].ativo = 1 THEN 'Sim' ELSE 'Não' end 'lotacao_ativa',
		CASE when [tbl_cargo].ativo = 1 THEN 'Sim' ELSE 'Não' end 'cargo_ativo',
		SUM(tbl_calc_orcamento.jan_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id, 
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_jan, 
		SUM([tbl_calc_orcamento].[jan_orcado]) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as jan_orcado, 

		SUM(tbl_calc_orcamento.fev_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_fev, 
		sum([tbl_calc_orcamento].[fev_orcado]) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as fev_orcado, 

		SUM(tbl_calc_orcamento.mar_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_mar, 
		sum(tbl_calc_orcamento.mar_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as mar_orcado, 

		SUM(tbl_calc_orcamento.abr_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_abr, 
		sum(tbl_calc_orcamento.abr_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as abr_orcado, 

		SUM(tbl_calc_orcamento.mai_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_mai, 
		sum(tbl_calc_orcamento.mai_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as mai_orcado, 

		SUM(tbl_calc_orcamento.jun_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_jun, 
		sum(tbl_calc_orcamento.jun_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as jun_orcado,
			
		SUM(tbl_calc_orcamento.jul_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_jul, 
		sum(tbl_calc_orcamento.jul_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as jul_orcado,

		SUM(tbl_calc_orcamento.ago_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_ago, 
		sum(tbl_calc_orcamento.ago_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as ago_orcado,

		SUM(tbl_calc_orcamento.set_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_set, 
		sum(tbl_calc_orcamento.set_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as set_orcado,

		SUM(tbl_calc_orcamento.out_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_out, 
		sum(tbl_calc_orcamento.out_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as out_orcado,

		SUM(tbl_calc_orcamento.nov_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_nov, 
		sum(tbl_calc_orcamento.nov_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as nov_orcado,

		SUM(tbl_calc_orcamento.dez_orcado) OVER(partition by 
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,  
				tbl_orc_lot_carg_headcount.orc_cargo_id
			) t_headcount_dez, 
		sum(tbl_calc_orcamento.dez_orcado) OVER(partition by    
				tbl_orc_lot_carg_headcount.ccusto_id, 
				tbl_orc_lot_carg_headcount.lotacao_id,
				tbl_orc_lot_carg_headcount.orc_cargo_id,
				tbl_orc_lot_carg_headcount.orc_turma_id
			) as dez_orcado,


		(select count(*) from tbl_orc_headcount_contratacoes contrat where tipo_table = 'R' and contrat.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND contrat.orc_cargo_id = [tbl_orc_cargo].id AND contrat.orc_turma_id = [tbl_orc_lot_carg_headcount].[orc_turma_id]) as tot_contratacoes,
		(select count(*) from tbl_orc_headcount_contratacoes contrat where tipo_table = 'R' and contrat.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND contrat.orc_cargo_id = [tbl_orc_cargo].id) as tot_tot_contratacoes,	


		(select count(*) from tbl_orc_headcount_demissoes demiss where tipo_table = 'R' and demiss.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND demiss.orc_cargo_id = [tbl_orc_cargo].id AND demiss.orc_turma_id = [tbl_orc_lot_carg_headcount].[orc_turma_id]) as tot_demissoes,
		(select count(*) from tbl_orc_headcount_demissoes demiss where tipo_table = 'R' and demiss.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND demiss.orc_cargo_id = [tbl_orc_cargo].id) as tot_tot_demissoes, 


		(select count(*) from tbl_orc_promocao prom_ent where tipo_table = 'R' and prom_ent.lotacao_promovida_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND prom_ent.cargo_promovido_id = [tbl_orc_cargo].id AND prom_ent.turma_promovida_id = [tbl_orc_lot_carg_headcount].[orc_turma_id]) as tot_promocoes_entrada,
		(select count(*) from tbl_orc_promocao prom_ent where tipo_table = 'R' and prom_ent.lotacao_promovida_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND prom_ent.cargo_promovido_id = [tbl_orc_cargo].id) as tot_tot_promocoes_entrada,


		(select count(*) from tbl_orc_promocao prom_sai where tipo_table = 'R' and prom_sai.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND prom_sai.cargo_atual_id = [tbl_orc_cargo].id AND prom_sai.turma_atual_id = [tbl_orc_lot_carg_headcount].[orc_turma_id]) as tot_promocoes_saida,
		(select count(*) from tbl_orc_promocao prom_sai where tipo_table = 'R' and prom_sai.lotacao_id = [tbl_orc_lot_carg_headcount].[lotacao_id] AND prom_sai.cargo_atual_id = [tbl_orc_cargo].id) as tot_tot_promocoes_saida

			  
		from [tbl_orc_lotacao]
		inner join [tbl_orc_lot_carg_headcount] on [tbl_orc_lot_carg_headcount].[lotacao_id] = [tbl_orc_lotacao].[id]  and [tbl_orc_lot_carg_headcount].periodo is null
		inner join [tbl_calc_orcamento] as [tbl_calc_orcamento] on [tbl_orc_lot_carg_headcount].[id] = [tbl_calc_orcamento].origem_id 
			and [tbl_calc_orcamento].tbl_origem = 'tbl_orc_lot_carg_headcount' 
		inner join [tbl_orc_cargo] on [tbl_orc_lot_carg_headcount].[orc_cargo_id] = [tbl_orc_cargo].[id] 
		inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
		inner join [tbl_ccusto] on [tbl_orc_lot_carg_headcount].[ccusto_id] = [tbl_ccusto].[id] 
		inner join [tbl_orc_turma] on [tbl_orc_lot_carg_headcount].[orc_turma_id] = [tbl_orc_turma].[id] 
		inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 
		inner join tbl_lotacao  on tbl_orc_lotacao.lotacao_id = tbl_lotacao.id 	

		where ([tbl_orc_lot_carg_headcount].[orc_id] = $orc_id and [tbl_orc_lot_carg_headcount].[tipo_table] = '$tipo_table') 
		and [tbl_orc_lotacao].[lotacao_id] 
		in ($lotacoes_string)
		
		group by   
		tbl_calc_orcamento.jan_orcado,
                tbl_calc_orcamento.fev_orcado,tbl_calc_orcamento.mar_orcado,tbl_calc_orcamento.abr_orcado,tbl_calc_orcamento.mai_orcado,tbl_calc_orcamento.jun_orcado,tbl_calc_orcamento.jul_orcado,
                tbl_calc_orcamento.ago_orcado,tbl_calc_orcamento.set_orcado,tbl_calc_orcamento.out_orcado,tbl_calc_orcamento.nov_orcado,tbl_calc_orcamento.dez_orcado,

  		[tbl_calc_orcamento].id,
		tbl_orc_lot_carg_headcount.id, 
		[tbl_orc_lot_carg_headcount].[orc_cargo_id], 
		[tbl_orc_lot_carg_headcount].[orc_id],
		[tbl_orc_lot_carg_headcount].[qtd_func_lot], 
		[tbl_orc_lot_carg_headcount].[atual_total], 
		[tbl_orc_lot_carg_headcount].[lotacao_id], 
		tbl_lotacao.des_unid_lotac,
		tbl_lotacao.unid_lotac,
		[tbl_orc_lot_carg_headcount].[orcado_anterior], 
		[tbl_orc_lot_carg_headcount].[origem_sistema],
		[tbl_orc_cargo].[cargo_id], 
		[tbl_orc_cargo].id,
		[tbl_cargo].[cod_cargo_basic], 
		[tbl_cargo].[des_cargo_basic], 
		[tbl_orc_lot_carg_headcount].[ccusto_id], 
		[tbl_ccusto].[cod_ccusto], 
		[tbl_orc_turma].[cdn_turma_trab], 
		[tbl_orc_turma].[des_turma_trab], 
		[tbl_turno].[cdn_turno_trab], 
		[tbl_turno].[des_turno_trab], 
		[tbl_orc_lot_carg_headcount].[orc_turma_id], 
		[tbl_orc_lot_carg_headcount].[forecast_anterior], 
		[tbl_orc_lot_carg_headcount].[forecast_total],
		tbl_cargo.cod_cargo_basic,
		tbl_cargo.des_cargo_basic,
		tbl_lotacao.des_unid_lotac,
		tbl_lotacao.unid_lotac, [tbl_orc_lotacao].ativo, [tbl_cargo].ativo

		order by 
		[tbl_orc_lot_carg_headcount].[lotacao_id], 
		[tbl_orc_lot_carg_headcount].[orc_cargo_id], 
		[tbl_orc_lot_carg_headcount].[orc_turma_id]";

        $dados = [];
        $data = DB::select($query);

        $data = json_decode(json_encode($data), true);
        // dd("hgjhgjkshg", $data);

        return $data;
			// $dados = $data->get()->toArray();
			// dd("query", DB::getQueryLog());
			// dd("testeee",$data);
			//  dd("pivooooo",$this->pivo($data));
	
    }
}