<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcDespesas;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\OrcResultadosCalc;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoOrcFerias;
use App\Modules\Natureza51\Repositories\RepoOrcPromocao;
use App\Modules\Natureza51\Repositories\RepoOrcContratacoes;
use App\Modules\Natureza51\Repositories\RepoHeadcountDemissoes;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoImportacao extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $repo_headcount;
    protected $repo_hora_extra;
    protected $repo_ferias;
    protected $repo_promocao;
    protected $repo_contratacoes;
    protected $repo_demissoes;
    protected $tbl_orc_beneficio;
    protected $tbl_calc_orcamento;
    protected $tbl_calc_ind;
    protected $tbl_beneficio;
    protected $tbl_orc_ben_func;
    protected $tbl_orc_lotacao;
    protected $tbl_lotacao;
    protected $tbl_orc_salario_func;
    protected $tbl_orc_despesa;

    protected $repo_orc_cargo;
    protected $repo_orc_turma;
    public $msg;
    public $meses_orcado = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];

    public function __construct()
    {
        $this->repo_headcount = new RepoHeadcount();
        $this->repo_hora_extra = new RepoOrcHoraExtra();
        $this->repo_ferias = new RepoOrcFerias();
        $this->repo_promocao = new RepoOrcPromocao();
        $this->repo_contratacoes = new RepoOrcContratacoes();
        $this->repo_demissoes = new RepoHeadcountDemissoes();
        $this->tbl_orc_beneficio = new OrcBeneficio();
        $this->repo_orc_cargo = new RepoOrcCargo();
        $this->repo_orc_turma = new RepoOrcTurma();
        $this->tbl_calc_orcamento = new CalcOrcamento();
        $this->tbl_calc_ind = new CalcIndice();
        $this->tbl_beneficio = new Beneficio();
        $this->tbl_orc_ben_func = new OrcLotFuncionatioBeneficio();
        $this->tbl_orc_lotacao = new OrcLotacao();
        $this->tbl_lotacao = new Lotacao();
        $this->tbl_orc_salario_func = new OrcSalarioFuncionario();
        $this->tbl_orc_despesa = new OrcDespesas();
    }

    public function inserted($form_data, $orc_id, $lotacao_id, $tbl_name, $tipo_table, $periodo, $empresa_id){

        $chave = array_key_first($form_data);
        // $values = $form_data[$chave];
        
        if(empty($form_data[$chave])){
            $this->setError("A planilha enviada não possui dados.<br>Erro: 290620201154");
            return false;
        }
        if($form_data['lotacao_id'] != 0){
            $lotacao_id = $form_data['lotacao_id'];
        }

        $fields_headers = array_keys($form_data[$chave][0]);

        /* Beneficio Orc */
        if($this->tbl_orc_beneficio->getTable() == $tbl_name){
            $inserir_b = $this->insertOrcBeneficioImport($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $periodo, $tipo_table);
            return $inserir_b == true ? true : false;
        }
        /* Beneficio Funcionario Orc */
        if($this->tbl_orc_ben_func->getTable() == $tbl_name){
            
            $inserir_ben_func = $this->insertBeneficioFunc($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $periodo, $tipo_table);
            return $inserir_ben_func == true ? true : false;
        }
        /* SALARIO FUNCIONARIO ORÇAMENTO */
        if($this->tbl_orc_salario_func->getTable() == $tbl_name){
            $inserir_b = $this->inserirOrcSalarioFuncionario($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $tipo_table, $periodo);
            return $inserir_b == true ? true : false;
        }
        /* AUMENTOS SALARIAIS */
        $tabela_atr = $this->tbl_orc_salario_func->getTable().'2';
        if($tabela_atr == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_b = $this->inserirAumentoSalarial($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $tipo_table);
            return $inserir_b == true ? true : false;
        }
        /**Headcount */
        if($this->repo_headcount->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_b = $this->insertHeadCountImport($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $lotacao_id);
            return $inserir_b == true ? true : false;
        }

        /**Hora Extra */
        if($this->repo_hora_extra->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_b = $this->insertHoraExtraImport($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id);
            return $inserir_b == true ? true : false;
        }

        /**Férias */
        if($this->repo_ferias->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_ferias = $this->insertFerias($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id);
            return $inserir_ferias == true ? true : false;
        }

        /**Promoção */
        if($this->repo_promocao->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_promocao = $this->insertPromocao($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id);
            return $inserir_promocao == true ? true : false;
        }

        /**Contratações */
        if($this->repo_contratacoes->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_contratacoes = $this->insertContratacoes($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id);
            return $inserir_contratacoes == true ? true : false;

        }

        /**Demissões */
        if($this->repo_demissoes->getModelEntity()->getTable() == $tbl_name){
            if(!$this->obtStatusOfOrc($orc_id)){
                $this->setError("Libere o Orçamento para continuar.");
                return false;
            }
            $inserir_demissoes = $this->insertDemissoes($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id);
            return $inserir_demissoes == true ? true : false;

        }
        if($this->tbl_orc_despesa->getTable() == $tbl_name){
            
            $inserir_demissoes = $this->insertDespesas($form_data[$chave], $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $lotacao_id, $periodo, $tipo_table);
            return $inserir_demissoes == true ? true : false;
        }
    }
    public function existeKeysAtual($dados, $fields){
        return $this->checkHeadersBeneficio($dados,$fields,1);
    }
    public function inserirAumentoSalarial($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $tipo_table = null){
        $fields = array(
            0 => 'cod_funcionario', // faço um select e pego
            1 => "jan_orcado",// usuario
            2 => "fev_orcado",// usuario
            3 => "mar_orcado",// usuario
            4 => "abr_orcado",// usuario
            5 => "mai_orcado",// usuario
            6 => "jun_orcado",// usuario
            7 => "jul_orcado",// usuario
            8 => "ago_orcado",// usuario
            9 => "set_orcado",// usuario
            10 => "out_orcado",// usuario
            11 => "nov_orcado",
            12 => "dez_orcado",
            13 => "cod_lotacao",
            14 => "cod_ccusto",
            15 => "cod_turma",
            16 => "cod_turno",
            17 => "cod_cargo"

        );
        
        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data[$chave]); $i++){
            
            if(!$this->existeKeysAtual($form_data[$chave][$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                $this->msg = '';
            }
            else{
                $inserir = $this->inserirAumentoSalarialEnd($form_data[$chave][$i], $orc_id, $empresa_id, $tipo_table);
                if( $inserir == false ){
                    $lotacao = $this->formataCod($form_data[$chave][$i]['cod_lotacao'],8);
                    
                    $msg = $msg.'<br>'.$this->msg.'. Falha ao inserir o Aumento Salarial de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$chave][$i]['cod_ccusto'].'</b>, Cargo: <b>'.$form_data[$chave][$i]['cod_cargo'].'</b> e Funcionário: <b>'.$form_data[$chave][$i]['cod_funcionario'].'</b> na linha '.($i + 2).'<br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data[$chave]))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function inserirAumentoSalarialEnd($form_data, $orc_id, $empresa_id, $tipo_table = null){
        //$repo_sal_func = new RepoOrcSalarioFuncionario();
        set_time_limit(120);
        if(!$this->possuiPermissaoLotacao($orc_id, $form_data['cod_lotacao'])){
            $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($form_data['cod_lotacao'],8)."</b> no Centro de Custo <b>".$form_data['cod_ccusto']."</b>.";
            return false;
        }
        $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($form_data['cod_lotacao'],8),$form_data['cod_ccusto'],$orc_id);
        if(!$lotacao){
            $this->msg = "Lotação e Centro de Custo não encontrados.";
            return false;
        }
        $cargo_existe = DB::select("SELECT * from tbl_cargo where cod_cargo_basic = ?", [$form_data['cod_cargo']]);
        if( count($cargo_existe) == 0){
            $this->msg = "Cargo não encontrado";
            return false;
        }

        $func = $this->obtCargoFunc($orc_id, $form_data['cod_funcionario']);
        if(!$func){
            $this->msg = "Funcionário não encontrado.";
            return false;
        }
        $orc_turma_id = $this->getOrcTurma($form_data['cod_turma'], $form_data['cod_turno'], $orc_id);
        if(count($orc_turma_id) == 0){
            $this->msg = "Turma não cadastrada no Heacount.";
            return false;
        }
        $orc_cargo_id = $this->getOrcCargo($orc_id, $form_data['cod_cargo']);
        $orc_turma_id = $orc_turma_id[0]['id'];
        $meses = Arr::except($form_data,['cod_lotacao','cod_ccusto','cod_turma','cod_turno','cod_funcionario','cod_cargo']);

        $dados['funcionario_id'] = $func[0]['funcionario_id'];
        $dados['orc_cargo_id'] = $orc_cargo_id[0]['id'];
        $dados['orc_turma_id'] = $orc_turma_id;
        $dados['lotacao_id'] = $lotacao['lotacao_id'];
        $dados['ccusto_id'] = $lotacao['ccusto_id'];
        $dados['orc_id'] = $orc_id;
        $dados['empresa_id'] = $empresa_id;
        $dados['tipo'] = 1;
        $dados['lotacao_responsavel_id'] = 806;
        $dados['tipo_table'] = $tipo_table == null ? 'O' : $tipo_table;
        $dados['meses'] = $meses;
        $dados['cod_cargo'] = $form_data['cod_cargo'];
        $dados['cod_funcionario'] = $form_data['cod_funcionario'];
        $dados['cod_lotacao'] = $form_data['cod_lotacao'];
        $dados['cod_ccusto'] = $form_data['cod_ccusto'];
        $dados['cod_turma'] = $form_data['cod_turma'];
        
        $create = $this->insertAumentosSalariaisFinal($dados);

        if($create['status'] == 'error'){
            $this->msg = $create['msg'];
            return false;
        }
        return true;
    }
    public function insertAumentosSalariaisFinal(array $form_data){
        $msg = [];
        //DB::beginTransaction();
        try{
            $repo_calc_orcamento = new RepoCalcOrcamento();
            $orc_sal_func = new OrcSalarioFuncionario();
            $wheree = [
                ['orc_id',$form_data['orc_id']],
                ['funcionario_id',$form_data['funcionario_id']],
                ['orc_cargo_id',$form_data['orc_cargo_id']],
                //['orc_turma_id',$form_data['orc_turma_id']],
                ['tipo_table',$form_data['tipo_table']],
                ['tipo',$form_data['tipo']]
                //['lotacao_id',$form_data['lotacao_id']],
                //['ccusto_id',$form_data['ccusto_id']]
            ];
            $select = $orc_sal_func->where($wheree)->get()->toArray();
            
            if(!empty($select)){
                $update = $this->updateJanDez($select[0]['id'], $orc_sal_func->getTable(), $form_data['meses']);
                $msg['status'] = $update == false ? 'error' : 'success';
                $msg['msg'] = $this->msg;
                return $msg;
            }

            // coloca aqui a validação de orc_funcionario

            $orc_func = DB::select("SELECT * from tbl_orc_funcionario where funcionario_id = ? and orcamento_id = ?", [$form_data['funcionario_id'], $form_data['orc_id']]);
            if(count($orc_func) > 0 && $orc_func[0]->cargo_atualizado != 1){
                /*$msg['status'] = 'error';
                $msg['msg'] = $this->msg = "Não foi possível atualizar os dados do Funcionário de código: <b>".$form_data['cod_funcionario']."</b>. Erro: 241120201534";
                */
                //return $msg;

                $orc_cargo_id = $this->getOrcCargo($form_data['orc_id'], $form_data['cod_cargo']);
                if($this->confereGradeCargo( $form_data['cod_cargo'], $form_data['orc_id'], $orc_func[0]->orc_cargo_id)){
                    /*$msg['status'] = 'error';
                    $msg['msg'] = $this->msg = "Impossível atualizar o funcionário de código <b>".$form_data['cod_funcionario']."</b> para um grade menor. Erro: 241120201536";
                    return $msg;*/
                    if(!$this->atualizaOrcFuncionario($form_data['orc_id'], $form_data['orc_turma_id'], $orc_cargo_id[0]['id'], $form_data['funcionario_id'])){
                        $msg['status'] = 'error';
                        $msg['msg'] = $this->msg = "Falha ao atualizar dados do funcionário de código ".$form_data['cod_funcionario'].". Erro: 241120201353";
                        return $msg;
                    }
                }
            }
        

            unset( $form_data['cod_cargo'] );
            unset( $form_data['cod_funcionario'] );
            unset( $form_data['cod_lotacao'] );
            unset( $form_data['cod_ccusto'] );
            unset( $form_data['cod_turma'] );

            $form_data['created_at'] = $this->fillCriadoEm();
            $form_data['created_by'] = $this->fillCriadoPor();
            $id_orc_sal_func = $orc_sal_func->create($form_data);
            if(! $id_orc_sal_func){
                $msg['status'] = 'error';
                $msg['msg'] = 'Falha ao inserir o registro.';
                return $msg;
            }
            $meses_calc_orcamento = $form_data['meses'];
            $merge_tb_calc = [
                'origem_id' => $id_orc_sal_func->id,
                'tbl_origem' => $orc_sal_func->getTable()
            ];

            if(!$repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses_calc_orcamento))){
                $msg['status'] = 'error';
                $msg['msg'] = 'Falha ao inserir os meses.';
                return $msg;
            }
            DB::commit();
        }catch(\Exception $e){
            DB::rollBack();
            $msg['status'] = 'error';
            $msg['msg'] = "Falha ao inserir registro. Erro: 210720201120 - ".$e->getMessage();
            return $msg;
        }
        $msg['status'] = 'success';
        return $msg;
    }
    public function obtCargoFunc($orc_id,$cod_func){
        $select = DB::select("
            select
            func.id as funcionario_id,
            func.nome_funcionario as func,
            cargo.des_cargo_basic,
            orccargo.id as orc_cargo_id

            from [tbl_funcionario] as func
            join [tbl_cargo] as cargo on func.cargo_id = cargo.id
            join [tbl_orc_cargo] as orccargo on cargo.id = orccargo.cargo_id and orccargo.orcamento_id = {$orc_id}

            where func.cdn_funcionario = {$cod_func}
        ");
        $dados = [];
        if(count($select) > 0){
            for($i = 0; $i < count($select); $i++){
                $dados[$i] = (array) $select[$i];
            }
            return $dados;
        }
        else{
            return false;
        }
    }
    public function insertHoraExtraImport($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id){

        $fields = array(
            0 => "cod_evento",
            1 => "cod_ccusto",
            2 => "cod_lotacao",
            3 => "jan_orcado",
            4 => "fev_orcado",
            5 => "mar_orcado",
            6 => "abr_orcado",
            7 => "mai_orcado",
            8 => "jun_orcado",
            9 => "jul_orcado",
            10 => "ago_orcado",
            11 => "set_orcado",
            12 => "out_orcado",
            13 => "nov_orcado",
            14 => "dez_orcado",
            15 => "cod_cargo",
            16 => "cod_turma",
            17 => "cod_turno"
        );
        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data); $i++){
            
            if(!$this->existeKeysAtual($form_data[$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
            }
            else{
                $inserir = $this->insertHoraExtraEnd($form_data[$i], $orc_id, $empresa_id);
                if( $inserir == false ){
                    $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                    $evento = $this->formataCod($form_data[$i]['cod_evento'],3);
                    $msg = $msg.'<br>'.$this->msg.'. Falha ao inserir a Hora Extra de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Evento: <b>'.$evento.'</b> e Cargo: <b>'.$form_data[$i]['cod_cargo'].'</b> na linha '.($i + 2).'<br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
            $this->msg = '';
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function insertHoraExtraEnd($form_data, $orc_id, $empresa_id){
        set_time_limit(120);
        DB::beginTransaction();
        try{
            $cod_evento = strval($form_data['cod_evento']);
            $form_data['cod_evento'] = $this->formataCod($cod_evento, 3);
            $evento = $this->obtOrcEventoByCod($form_data['cod_evento'], $orc_id);

            if(!$evento){
                $this->msg = "Evento não encontrado.<br>Erro: 160720201129";
                return false;
            }

            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($form_data['cod_lotacao'],8),$form_data['cod_ccusto'],$orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo não encontrados.<br>Erro: 160720201130";
                return false;
            }
            $orc_turma_id = $this->getOrcTurma($form_data['cod_turma'], $form_data['cod_turno'], $orc_id);
            if(count($orc_turma_id) == 0){
                $this->msg = "Turma não cadastrada no Cargos/Turmas.";
                return false;
            }

            $orc_cargo_id = $this->getOrcCargo($orc_id,$form_data['cod_cargo']);
            if(!$orc_cargo_id){
                $this->msg = "Cargo não cadastrado em Cargos/Turmas.";
                return false;
            }
            $data['orc_id'] = $orc_id;
            $data['lotacao_id'] = $lotacao['lotacao_id'];
            $data['ccusto_id'] = $lotacao['ccusto_id'];
            $data['orc_cargo_id'] = $orc_cargo_id[0]['id'];
            $data['orc_turma_id'] = $orc_turma_id[0]['id'];
            $data['evento_id'] = $evento->evento_id;
            $data['empresa_id'] = $empresa_id;
            $data['tipo_table'] = 'O';

            $meses = Arr::except($form_data,['cod_lotacao','cod_ccusto','cod_cargo','cod_turma','cod_turno','cod_evento']);
            $dados = array_merge($data,$meses);
            $hora_extra = new RepoHeadcountHraExtra();
            $create = $hora_extra->insertHraExtra($dados);

            if($create['status'] != 'success'){
                $this->msg = $create['msg']."<br>Erro: 16072201157";
                return false;
            }
            DB::commit();
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->msg = "Falha ao cadastrar Hora Extra.<br>Erro: 16072020142 - ".$e->getMessage();
            return false;
        }
        return true;
    }
    public function obtOrcEventoByCod($cod_evento, $orc_id){
        $select = DB::select("
            select orc_he.id as evento_id from tbl_orc_hora_extra as orc_he
            join tbl_eventos as evento on orc_he.evento_id = evento.id and orc_he.orcamento_id = {$orc_id} and
            evento.cdn_event = '{$cod_evento}'
        ");

        return count($select) > 0 ? $select[0] : false;
    }
    public function insertDespesas($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $lotacao_id, $periodo, $tipo_table){
        
        $fields = array(
            0 => "cod_evento",
            1 => "cod_natureza",
            2 => "cod_lotacao",
            3 => "jan_orcado",
            4 => "fev_orcado",
            5 => "mar_orcado",
            6 => "abr_orcado",
            7 => "mai_orcado",
            8 => "jun_orcado",
            9 => "jul_orcado",
            10 => "ago_orcado",
            11 => "set_orcado",
            12 => "out_orcado",
            13 => "nov_orcado",
            14 => "dez_orcado",
            15 => "cod_ccusto"
        );
        $msg = '';
        $cont = 0;
        $status = 0;
        // if(!$this->checkHeadersBeneficio($fields,$fields_headers)){
        //     return false;
        // }
        // else{
        for($i = 0; $i < count($form_data); $i++){
            
            if(!$this->existeKeysAtual($form_data[$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
            }
            else{
                $inserir = $this->insertDespesasEnd($form_data[$i], $orc_id, $empresa_id, $periodo, $tipo_table);
                if( $inserir == false ){
                    $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                    $msg = $msg.'<br>'.$this->msg.'. Falha ao inserir a Despesa de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Evento: <b>'.$form_data[$i]['cod_evento'].'</b> e Natureza: <b>'.$form_data[$i]['cod_natureza'].'</b><br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
            
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function insertDespesasEnd($form_data, $orc_id, $empresa_id, $periodo, $tipo_table){
        set_time_limit(120);
        //DB::beginTransaction();
        // REVER REGRA DA DESPESA, POIS ALGUMAS NÃO POSSUEM EVENTO, QUE PODE CAUSAR UM ERRO AO TENTAR IMPORTAR
        try{
            $this->isMonetario($form_data, $this->meses_orcado);

            $form_data['cod_lotacao'] = $this->formataCod( strval($form_data['cod_lotacao']), 8);
            //$this->possuiPermissaoLotacao($orc_id,$form_data['cod_lotacao']);

            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($form_data['cod_lotacao'], $form_data['cod_ccusto'], $orc_id, $periodo, $tipo_table);//$this->getOrcLotacaoByCodLotacao($form_data['cod_lotacao'], $orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo não encontrados";// <br>Erro: 080720200957
                return false;
            }
            $ccusto = $lotacao['ccusto_id'];
            $lotacao = $lotacao['lotacao_id'];

            $cod_evento = strval($form_data['cod_evento']);
            $form_data['cod_evento'] = $this->formataCod($cod_evento, 3);
            
            $despesa = $this->obtDespesas($form_data['cod_evento'], $form_data['cod_natureza']);
            if(!$despesa){
                $this->msg = "Despesa não encontrada";// <br>Erro: 093708072020 //Lembre-se de colocar os códigos com formato de texto.
                return false;
            }
            
            $evento = $despesa['evento_id'];//$this->obtEventoByCod($form_data['cod_evento'])['id'];
            if(!$evento){
                $this->msg = "Evento não encontrado";// <br>Erro: 080720201007 //Lembre-se de colocar os códigos com formato de texto.
                return false;
            }
            $natureza = $despesa['cta_contabil_id'];//$this->obtNaturezaByCod($form_data['cod_natureza'])['id'];
            if(!$natureza){
                $this->msg = "Natureza não encontrada";// <br>Erro: 080720201051 //Lembre-se de colocar os códigos com formato de texto.
                return false;
            }

            // if(!$this->getCcustoByLotacaoId($lotacao, $form_data, $orc_id)){
            //     $this->setError("Falha ao encontrar Centro de Custo.<br>Erro: 080720200950");
            //     return false;
            // }
            $data = $this->existeDespesa($orc_id, $despesa['id'], $lotacao, $ccusto, $periodo, $tipo_table);
            if($data !== true){
                $dados = [];
                for($i = 0; $i < count($this->meses_orcado); $i++){
                    $dados[$this->meses_orcado[$i]] = $form_data[$this->meses_orcado[$i]];
                }
                return $this->updateJanDez($data[0]['id'], 'tbl_orc_despesas', $dados);
            }
            
            $form_data['empresa_id'] = $empresa_id;
            $form_data['orc_id'] = $orc_id;
            $form_data['despesa_id'] = $despesa['id'];
            $form_data['lotacao_id'] = $lotacao;
            $form_data['centro_custo_id'] = $ccusto;
            $form_data['valor_referencia'] = $despesa['valor_referencia'];

            $dados = Arr::except($form_data,['cod_evento','cod_natureza','cod_lotacao','ccusto_id']);
            $dados_despesa = Arr::only($dados,['empresa_id','orc_id','despesa_id','lotacao_id','centro_custo_id','valor_referencia']);
            
            $dados_despesa['tipo_table'] = $tipo_table;
            $dados_despesa['created_at'] = $this->fillCriadoEm();
            $dados_despesa['created_by'] = $this->fillCriadoPor();

            if($tipo_table == 'F'){
                $dados_despesa['periodo'] = $periodo;
            }

            $inserir_despesa = $this->tbl_orc_despesa->create($dados_despesa);
            if(!$inserir_despesa){
                $this->msg = "Falha ao inserir Despesa";//<br>Erro: 080720200931
                return false;
            }
            $dados_calc = Arr::except($dados,['empresa_id','orc_id','despesa_id','lotacao_id','centro_custo_id','valor_referencia']);

            $dados_calc['origem_id'] = $inserir_despesa->id;
            $dados_calc['tbl_origem'] = $this->tbl_orc_despesa->getTable();
            $dados_calc['created_by'] = $this->fillModificadoPor();
            $dados_calc['created_at'] = $this->fillModificadoEm();

            $inserir_calc = $this->tbl_calc_orcamento->create($dados_calc);
            if(!$inserir_calc){
                $this->msg = "Falha ao inserir dados";//<br>Erro: 080720200933
                return false;
            }
            //DB::commit();
        }
        catch(\Exception $e){
            //DB::rollBack();
            $this->msg = "Falha ao cadastrar Despesa. Erro: 080720201052 - ".$e->getMessage();
            return false;
        }
        return true;
    }
    public function insertHeadCountImport($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $lotacao_id){
        $fields = array(
            0 => "total_forecast_anterior",
            1 => "cod_cargo",
            2 => "cod_lotacao",
            3 => "cod_ccusto",
            4 => "total_orcado_anterior"
        );

        $msg = '';
        $cont = 0;
        $status = 0;

        for($i = 0; $i < count($form_data[$chave]); $i++){
            if(!$this->existeKeysAtual($form_data[$chave][$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                $this->msg = '';
            }
            else{
                $inserir = $this->insertHeadCountEnd($form_data[$chave][$i], $orc_id, $empresa_id);
                if($inserir == false){
                    $lotacao = $this->formataCod($form_data[$chave][$i]['cod_lotacao'],8);
                    $msg = $msg.'<br>'.$this->msg.' Falha ao inserir Cargo/Turma de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$chave][$i]['cod_ccusto'].'</b> e Cargo: <b>'.$form_data[$chave][$i]['cod_cargo'].'</b>.<br>';
                    $cont++;
                    $status--;
                }else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
            
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data[$chave]))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
        
    }
    public function obtLotacaoCcustoByCodLotCcusto($cod_lot, $cod_cc, $orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_ccusto = new CentroCusto();
        $query = $this->tbl_lotacao
        ->join($this->tbl_orc_lotacao->getTable(), $this->tbl_lotacao->getColunaAlias('id'), '=', DB::raw("{$this->tbl_orc_lotacao->getColunaAlias('lotacao_id')} and {$this->tbl_orc_lotacao->getColunaAlias('orcamento_id')} = {$orc_id}"))
        ->join($tbl_ccusto->getTable(), $this->tbl_orc_lotacao->getColunaAlias('cc_custo_id'), '=', DB::raw("{$tbl_ccusto->getColunaAlias('id')} and {$tbl_ccusto->getColunaAlias('cod_ccusto')} = {$cod_cc}"))
        ->select(
            DB::raw("{$this->tbl_orc_lotacao->getColunaAlias('id')} as lotacao_id"),
            DB::raw("{$this->tbl_orc_lotacao->getColunaAlias('cc_custo_id')} as ccusto_id")
        )
        ->where($this->tbl_lotacao->getColunaAlias('unid_lotac'),$cod_lot)
        ->where($this->tbl_orc_lotacao->getColunaAlias('tipo_table'), $tipo_table);

        $select = null;

        if($tipo_table == 'F'){
            $select = $query->where($this->tbl_orc_lotacao->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->tbl_orc_lotacao->getColunaAlias('periodo'))->get()->toArray();
        }

        return count($select) > 0 ? $select[0] : false;
    }
    public function insertHeadCountEnd($value, $orc_id, $empresa_id){
        set_time_limit(120);
        //DB::beginTransaction();

        try {
            if(!$this->possuiPermissaoLotacao($orc_id, $value['cod_lotacao'])){
                $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($value['cod_lotacao'],8)."</b> no Centro de Custo <b>".$value['cod_ccusto']."</b>.";
                return false;
            }
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($value['cod_lotacao'],8),$value['cod_ccusto'],$orc_id);
            if(!$lotacao){
                $this->msg = "Não foi possível encontrar a lotação e o centro de custo inseridos. Erro: 150720201858.";
                return false;
            }
            /*$orc_turma_id = $this->getOrcTurma($value['cod_turma'],$value['cod_turno'],$orc_id);
            if(!$orc_turma_id){
                return "Turma e Turno não cadastrados nesse orçamento. Erro: 060420201338.";
                return false;
            }    TURMA    */
            $orc_cargo_id = $this->getOrcCargo($orc_id,$value['cod_cargo']);
            if(!$orc_cargo_id){
                $this->msg = "Cargo não cadastrado no orçamento. Erro: 060420201527.";
                return false;
            }

            //$headcount = $this->putOrcTurmaIdOnData($value,$orc_turma_id[0]['id']);
            /* ----$headcount = $this->putOrcCargoIdOnData($value,$orc_cargo_id[0]['id']);

            $form_data = $this->removeArray($headcount, ['cod_ccusto','cod_lotacao','tipo_table','user_id','empresa_id','cod_turma','cod_cargo','cod_turno','jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

            $form_data['orc_id'] = $orc_id;
            $form_data['lotacao_id'] = $lotacao['lotacao_id'];

            $form_data['ccusto_id'] = $lotacao['ccusto_id'];
            $form_data['forecast_total'] = $value['total_forecast_anterior'];
            $form_data['orcado_anterior'] = $value['total_orcado_anterior'];
            $form_data = Arr::except($form_data,['total_forecast_anterior', 'total_orcado_anterior']);

            $meses = $this->removeArray($headcount,['orcado_anterior','cod_ccusto','cod_lotacao','cod_cargo','cod_turma','cod_turno','orc_turma_id','orc_cargo_id','forecast_anterior','forecast_total']);

            //$create = $this->created($this->repo_headcount,$form_data,$meses);
            $form_data['meses_orcado'] = $meses;
            $form_data['fromMeses'] = false;
            $quadro_atual = $this->putQuadroAtual( $form_data['lotacao_id'], $orc_cargo_id);// no repoHeadcount tem um desse, ver se precisa
            $form_data['quadroAtual'] = $quadro_atual;
            $form_data['tipo_table'] = 'O';-----*/

            $select_banco = DB::table('tbl_orc_lot_carg_headcount')
            ->select()
              ->where([
                ['lotacao_id','=',$lotacao['lotacao_id']],
                ['ccusto_id','=',$lotacao['ccusto_id']],
                ['orc_id','=',$orc_id],
                ['orc_cargo_id','=',$orc_cargo_id[0]['id']]
              ])->get()->toArray();

            if(count($select_banco) == 0){
                $this->msg = "Registro inexistente.";
                return false;
            }

            //   dd("njshfhsjkf", $select_banco);
            $data_update = ['forecast_total' => $value['total_forecast_anterior'] ,
                            'orcado_anterior' => $value['total_orcado_anterior'], 
                            'forecast_original' =>  is_null($select_banco[0]->forecast_original)? $value['total_forecast_anterior'] : $select_banco[0]->forecast_original
            ];

            $update = DB::table('tbl_orc_lot_carg_headcount')
              ->where([
                ['lotacao_id','=',$lotacao['lotacao_id']],
                ['ccusto_id','=',$lotacao['ccusto_id']],
                ['orc_id','=',$orc_id],
                ['orc_cargo_id','=',$orc_cargo_id[0]['id']]
              ])
              ->update($data_update);

            //$create = $this->repo_headcount->createHeadcount($form_data);
            //$create = $this->repo_headcount->update
            /*if($create['status'] != 'success'){
                return $create['msg'];
            }*/
            if($update == 0){
                $this->msg = "Falha ao inserir dados.";
                return false;
            }
            //DB::commit();
        }catch (\Exception $e) {
            //DB::rollBack();
            $this->msg = "Erro ao inserir registro. Erro: 060420201700. ".$e->getMessage();
            return false;
        }
        return true;
    }
    public function insertFerias($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id){
        $fields = array(
            0 => "cod_cargo",
            1 => "cod_turma",
            2 => "cod_turno",
            3 => "cod_lotacao",
            4 => "tipo_ferias",
            5 => "jan_orcado",
            6 => "fev_orcado",
            7 => "mar_orcado",
            8 => "abr_orcado",
            9 => "mai_orcado",
            10 => "jun_orcado",
            11 => "jul_orcado",
            12 => "ago_orcado",
            13 => "set_orcado",
            14 => "out_orcado",
            15 => "nov_orcado",
            16 => "dez_orcado",
            17 => "cod_ccusto"
        );
        $fields_2 = array(
            0 => "cod_lotacao",
            1 => "cod_turma",
            2 => "cod_turno",
            3 => "cod_funcionario",
            4 => "tipo_ferias",
            5 => "jan_orcado",
            6 => "fev_orcado",
            7 => "mar_orcado",
            8 => "abr_orcado",
            9 => "mai_orcado",
            10 => "jun_orcado",
            11 => "jul_orcado",
            12 => "ago_orcado",
            13 => "set_orcado",
            14 => "out_orcado",
            15 => "nov_orcado",
            16 => "dez_orcado",
            17 => "cod_ccusto"
        );

        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data); $i++){
            //$fields_headers = array_keys($form_data[$i]);
            if($form_data[$i]['tipo_ferias'] == 'Cargos x Funcionários'){
                if(!$this->existeKeysAtual($form_data[$i], $fields_2)){
                    $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
                }
                else{
                    $inserir = $this->insertFeriasEnd($form_data[$i], $orc_id, $empresa_id);
                    if($inserir == false){
                        $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                        $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a Férias de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Turma: <b>'.$form_data[$i]['cod_turma'].'</b> e Turno: <b>'.$form_data[$i]['cod_turno'].'</b> na linha '.($i + 2).'.<br>';
                        $cont++;
                        $status--;
                    }
                    else{
                        $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                        $status++;
                    }
                }
            }
            else{
                if(!$this->existeKeysAtual($form_data[$i], $fields)){
                    $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
                }
                else{
                    $inserir = $this->insertFeriasEnd($form_data[$i], $orc_id, $empresa_id);
                    if($inserir == false){
                        $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                        $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a Férias de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Turma: <b>'.$form_data[$i]['cod_turma'].'</b> e Turno: <b>'.$form_data[$i]['cod_turno'].'</b> na linha '.($i + 2).'.<br>';
                        $cont++;
                        $status--;
                    }
                    else{
                        $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                        $status++;
                    }
                }
                
            }
            //$fields_headers = [];
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function insertFeriasEnd($value, $orc_id, $empresa_id){
        set_time_limit(120);
        DB::beginTransaction();
        try{
            if(!$this->possuiPermissaoLotacao($orc_id, $value['cod_lotacao'])){
                $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($value['cod_lotacao'],8)."</b> no Centro de Custo <b>".$value['cod_ccusto']."</b>.";
                return false;
            }
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($value['cod_lotacao'],8), $value['cod_ccusto'], $orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo não encontrados.<br>Erro: 160720200936";
                return false;
            }
            $orc_turma_id = $this->getOrcTurma($value['cod_turma'],$value['cod_turno'],$orc_id);
            if(count($orc_turma_id) == 0){
                $this->msg = "Turma não da cadastra em Cargos/Turmas.";
                return false;
            }
            $ferias = [];
            if($value['tipo_ferias'] != 'Cargos x Funcionários' && array_key_exists('cod_cargo',$value)){
                $orc_cargo_id = $this->getOrcCargo($orc_id,$value['cod_cargo']);
                if(count($orc_cargo_id) == 0){
                    $this->msg = "Cargo não cadastrado em Cargos/Turmas";
                    return false;
                }
                $ferias = $this->putOrcCargoIdOnData($value, $orc_cargo_id[0]['id'], 'cargo_id');
            }
            else{
                $orc_cargo_id = $this->obtCargoFunc($orc_id, $value['cod_funcionario']);
                if(!$orc_cargo_id){
                    $this->msg = "Cargo não cadastrado em Cargos/Turmas";
                    return false;
                }
                $orc_cargo_id[0]['id'] = $orc_cargo_id[0]['orc_cargo_id'];
                $ferias = $this->putOrcCargoIdOnData($value, $orc_cargo_id[0]['orc_cargo_id'], 'cargo_id');
            }
            $ferias = $this->putOrcTurmaIdOnData($ferias, $orc_turma_id[0]['id']);
            $form_data = $this->removeArray($ferias,['modelo','tipo_table','user_id','empresa_id','cod_turma','cod_cargo','cod_turno','cod_funcionario','jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
            //dd($ferias,$lotacao,$this->existInHeadcount($ferias['cargo_id'],$ferias['orc_turma_id'], $orc_id, $lotacao['lotacao_id']));
            if( !$this->existInHeadcount($ferias['cargo_id'],$ferias['orc_turma_id'], $orc_id, $lotacao['lotacao_id']) ){
                $this->msg = "Falha ao inserir registro. Cargo e Turma não cadastrados no Headcount. Erro: 070420201315";
                return false;
            }

            $form_data['orcamento_id'] = $orc_id;
            $form_data['lotacao_id'] = $lotacao['lotacao_id'];
            $form_data['empresa_id'] = $empresa_id;
            $form_data['lotacao_responsavel'] = 1;
            $form_data['ccusto_id'] = $lotacao['ccusto_id'];

            if($form_data['tipo_ferias'] == 'Cargos x Funcionários'){
                $func_id = $this->getFuncionarioId($value['cod_funcionario']);
                
                if(count($func_id) == 0){
                    $this->msg = "Falha ao encontrar Funcionário.";
                    return false;
                }

                if( count($this->confereCargo($orc_cargo_id[0]['id'], $orc_id, $func_id[0]['id'])) == 0){
                    $this->msg = "Funcionário e Cargo digitados não possuem relação.<br>Erro: 020720200827";
                    return false;
                }
                $form_data['func_id'] = $func_id[0]['id'];
                $form_data['type'] = 1;
            }
            else{
                $form_data['func_id'] = null;
                $form_data['type'] = 0;
            }
            $reg = $this->repo_ferias->getModelEntity()->where([
                [$this->repo_ferias->getModelEntity()->getColunaAlias('cargo_id'),'=',$form_data['cargo_id']],
                [$this->repo_ferias->getModelEntity()->getColunaAlias('orc_turma_id'),'=',$form_data['orc_turma_id']],
                [$this->repo_ferias->getModelEntity()->getColunaAlias('orcamento_id'),'=',$form_data['orcamento_id']],
                [$this->repo_ferias->getModelEntity()->getColunaAlias('lotacao_id'),'=',$form_data['lotacao_id']],
                //[$this->repo_ferias->getModelEntity()->getColunaAlias('empresa_id'),'=',$form_data['empresa_id']],
                [$this->repo_ferias->getModelEntity()->getColunaAlias('ccusto_id'),'=',$form_data['ccusto_id']],
                [$this->repo_ferias->getModelEntity()->getColunaAlias('func_id'),'=',$form_data['func_id']]
            ])->get()->toArray();

            if(count($reg) > 0){
                $this->msg = "Falha ao inserir registro. Férias já existente!";
                return false;
            }

            $meses = $this->removeArray($ferias,['cod_cargo','orc_turma_id','cargo_id','cod_turma','cod_turno','modelo','user_id','cod_funcionario','tipo_ferias']);
            $create = $this->created($this->repo_ferias,$form_data,$meses);

            if(!$create){
                $this->msg = "Falha ao cadastrar o registro! Erro: 070420201527";
                return false;
            }
            DB::commit();
        }catch (\Exception $e) {
            DB::rollBack();
            $this->msg = "Falha ao cadastrar registro. Erro: 070420201114 - ".$e->getMessage();
            return false;
        }

        return true;
    }
    public function insertPromocao($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id){

        $fields = array(
            0 => "cod_funcionario",
            1 => "cod_cargo",
            2 => "cod_turma",
            3 => "cod_turno",
            4 => "mes_promocao",
            5 => "cod_lotacao",
            6 => "cod_ccusto"
        );

        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data); $i++){
            if(!$this->existeKeysAtual($form_data[$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                $this->msg = '';
            }
            else{
                $inserir = $this->insertPromocaoEnd($form_data[$i], $orc_id, $empresa_id,$lotacao_id);
                if($inserir == false){
                    $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                    $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a Promoção de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Turma: <b>'.$form_data[$i]['cod_turma'].'</b>, Turno: <b>'.$form_data[$i]['cod_turno'].'</b> e Funcionário: <b>'.$form_data[$i]['cod_funcionario'].'</b> na linha '.($i + 2).'.<br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
        }
        
        if( ($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
        
    }
    public function insertPromocaoEnd($value, $orc_id, $empresa_id, $lotacao_id){
        set_time_limit(120);
        DB::beginTransaction();

        try{

            if(!$this->possuiPermissaoLotacao($orc_id,$value['cod_lotacao'])){
                $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($value['cod_lotacao'],8)."</b> no Centro de Custo <b>".$value['cod_ccusto']."</b>.";
                return false;
            }
            if($value['mes_promocao'] < 1 || $value['mes_promocao'] > 12){
                $this->msg = "O campo mes_promocao não pode ser menor que 1 ou maior que 12.";
                return false;
            }
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($value['cod_lotacao'], 8), $value['cod_ccusto'],$orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo atuais não encontrados.";
                return false;
            }
            $orc_turma_id = $this->getOrcTurma($value['cod_turma'],$value['cod_turno'],$orc_id);
            if(!$this->falhaEncontrar("Turma",$orc_turma_id)){
                $this->msg = "Turma não encontrada.";
                return false;
            }
            $orc_cargo_id = $this->getOrcCargo($orc_id,$value['cod_cargo']);
            if(!$this->falhaEncontrar("Cargo",$orc_cargo_id)){
                $this->msg = "Cargo não encontrado.";
                return false;
            }
            $funcionario = $this->getFuncionarioId($value['cod_funcionario']);
            if(!$this->falhaEncontrar("Funcionário",$funcionario)){
                $this->msg = "Funcionário não encontrado.";
                return false;
            }

            $cargo_atual_id = $this->getOrcCargo($orc_id, $funcionario[0]['cargo_id'], NULL, 'O', 'id');
            /*$promocao = $this->putOrcCargoIdOnData($value,$orc_cargo_id[0]['id'],'cargo_promovido_id');
            $promocao = $this->putOrcTurmaIdOnData($promocao,$orc_turma_id[0]['id'],'turma_promovida_id');
            */
            if($cargo_atual_id[0]['id'] == $orc_cargo_id[0]['id']){
                $this->msg = "Cargo anterior e o Cargo promovido não podem ser iguais. Erro:080420201609";
                return false;
            }
            $dados = $this->existePromocaoHeadcount($value['cod_lotacao'], $value['cod_ccusto'], $value['cod_turma'], $value['cod_turno'], $value['cod_cargo'],$orc_id);
            if(!$dados){
                $this->msg = "Lotação, Centro de Custo, Cargo, Turma e Turno não encontrados.";
                return false;
            }

            // $form_data = $this->removeArray($promocao,['cod_lotacao','cod_ccusto','mes_promocao','cod_turma','cod_cargo','cod_turno','cod_funcionario']);

            $form_data['tipo_table'] = 'O';
            $form_data['mes_promocao'] = $value['mes_promocao'];
            $form_data['orc_id'] = $orc_id;
            $form_data['lotacao_id'] = $lotacao_id;//$lotacao['lotacao_id'];
            $form_data['ccusto_id'] = $lotacao['ccusto_id'];
            $form_data['empresa_id'] = $empresa_id;//
            $form_data['funcionario_id'] = $funcionario[0]['id'];
            $form_data['cargo_atual_id'] = $cargo_atual_id[0]['id'];
            $form_data['turma_atual_id'] = $orc_turma_id[0]['id'];

            $form_data['lotacao_destino'] = $dados['lotacao_promovida_id'];
            $form_data['ccusto_promovido_id'] = $dados['ccusto_promovido_id'];
            $form_data['turma_promovida_id'] = $dados['turma_promovida_id'];
            $form_data['cargo_promovido_id'] = $dados['cargo_promovido_id'];

            /*if(!$this->existInHeadcount($orc_cargo_id[0]['id'],$orc_turma_id[0]['id'],$orc_id,$form_data['lotacao_id'])){
                return "Cargo e Turma não cadastrados no Headcount.";
                //return false;
            }
            if($this->repo_promocao->getModelEntity()->where($form_data)->first()){
                return "Promoção já existente.";
                //return false;
            }

            $form_data['turma_atual_id'] = $orc_turma_id[0]['id'];
            $form_data['cargo_atual_id'] = $cargo_atual_id[0]['id'];
            $form_data['mes_promocao'] = $value['mes_promocao'];
            $form_data['']*/
            $create = $this->repo_promocao->insertPromocao($form_data,0);

            if($create['status'] != 'success'){
                $this->msg = $create['msg'];//"Falha ao inserir Promoção. Erro: 080420201703";
                return false;
                //return false;
            }
            DB::commit();
        } catch (\Exception $th) {
            DB::rollBack();
            $this->msg = "Falha ao inserir Promoção. Erro: 080420201428 - ".$th->getMessage();
            return false;
            //return false;
        }
        return true;
    }
    public function existePromocaoHeadcount($cod_lot, $cod_ccusto, $cod_turma, $cod_turno, $cod_cargo, $orc_id){
        $select = DB::select("SELECT orclot.id as lotacao_promovida_id, orclot.cc_custo_id as ccusto_promovido_id, orccargo.id as cargo_promovido_id, turma.id as turma_promovida_id

        FROM [tbl_orc_lot_carg_headcount] as headcount

        join [tbl_orc_lotacao] as orclot on headcount.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
        join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id and lot.unid_lotac = {$cod_lot}
        join [tbl_ccusto] as cc on orclot.cc_custo_id = cc.id and cc.cod_ccusto = {$cod_ccusto}

        join [tbl_orc_cargo] as orccargo on headcount.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
        join [tbl_cargo] as cargo on orccargo.cargo_id = cargo.id and cargo.cod_cargo_basic = {$cod_cargo}

        join [tbl_orc_turma] as turma on headcount.orc_turma_id = turma.id and orclot.orcamento_id = {$orc_id} and turma.cdn_turma_trab = {$cod_turma}
        join [tbl_turno] as tn on turma.turno_id = tn.id and tn.cdn_turno_trab = {$cod_turno} ");

        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array) $select[$i];
        }
        return count($dados) > 0 ? $dados[0] : false;
    }
    public function insertDemissoes($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id){
        $fields_func_mes = array(
            0 => "cod_lotacao",
            1 => "cod_turma",
            2 => "cod_turno",
            3 => "cod_ccusto",
            4 => "cod_funcionario",
            5 => "mes"
        );

        $fields_cargo_turma = array(
            0 => "cod_lotacao",
            1 => "cod_ccusto",
            2 => "cod_cargo",
            3 => "cod_turma",
            4 => "cod_turno",
            5 => "jan_orcado",
            6 => "fev_orcado",
            7 => "mar_orcado",
            8 => "abr_orcado",
            9 => "mai_orcado",
            10 => "jun_orcado",
            11 => "jul_orcado",
            12 => "ago_orcado",
            13 => "set_orcado",
            14 => "out_orcado",
            15 => "nov_orcado",
            16 => "dez_orcado"
        );

        $fields_tempo_casa = array(
            0 => "cod_lotacao",
            1 => "cod_ccusto",
            2 => "cod_cargo",
            3 => "cod_turma",
            4 => "cod_turno",
            5 => "mes",
            6 => "tempo_casa",
            7 => "quantidade_pessoas"
        );
        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data); $i++){
            if(!array_key_exists('tipo_demissao',$form_data[$i])){
                $msg = $msg."Impossível encontrar a(s) seguinte(s) coluna(s) na planilha: <b>tipo_demissao</b><br>";
            }
            else if($form_data[$i]['tipo_demissao'] == 'Funcionário x Mês'){
                if(!$this->existeKeysAtual($form_data[$i], $fields_func_mes)){
                    $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                }
                else{
                    $inserir = $this->insertDemissoesEnd($form_data[$i], $orc_id, $empresa_id, $lotacao_id);
                    if( $inserir == false){
                        $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a '.($i+1).'ª Demissão da planilha.<br>';
                        $status--;
                    }else{
                        $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                        $status++;
                    }
                }
            }

            else if($form_data[$i]['tipo_demissao'] == 'Cargo x Turma'){
                if(!$this->existeKeysAtual($form_data[$i], $fields_cargo_turma)){
                    $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                }
                else{
                    $inserir = $this->insertDemissoesEnd($form_data[$i], $orc_id, $empresa_id, $lotacao_id);
                    if( $inserir == false){
                        $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a '.($i+1).'ª Demissão da planilha.<br>';
                        $status--;
                    }else{
                        $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                        $status++;
                    }
                }
            }

            else{
                if(!$this->existeKeysAtual($form_data[$i], $fields_tempo_casa)){
                    $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                }
                else{
                    $inserir = $this->insertDemissoesEnd($form_data[$i], $orc_id, $empresa_id, $lotacao_id);
                    if( $inserir == false){
                        $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a '.($i+1).'ª Demissão da planilha.<br>';
                        $status--;
                    }else{
                        $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                        $status++;
                    }
                }
            }
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function insertDemissoesEnd($value, $orc_id, $empresa_id, $lotacao_id){
        set_time_limit(120);
        DB::beginTransaction();

        try {
            $funcionario_id = null;
            //$this->validaTipoDemissao($value);
            if(!$this->possuiPermissaoLotacao($orc_id,$value['cod_lotacao'])){
                $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($value['cod_lotacao'],8)."</b> no Centro de Custo <b>".$value['cod_ccusto']."</b>.";
                return false;
            }
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($value['cod_lotacao'], $value['cod_ccusto'], $orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo não encontrados.";
                return false;
            }
            if(empty($value['tipo_demissao'])){
                $this->msg = "Por favor, insira um valor no campo tipo_demissão.";
                return false;
            }
            $orc_turma_id = $this->getOrcTurma($value['cod_turma'],$value['cod_turno'],$orc_id);
            if(!$orc_turma_id){
                $this->msg = "Turma e turno não cadastrados nesse orçamento. Erro: 080420200910";
                return false;
            }
            $orc_cargo_id = [];
            if($value['tipo_demissao'] != 'Funcionário x Mês' && array_key_exists('cod_cargo',$value)){
                $orc_cargo_id = $this->getOrcCargo($orc_id,$value['cod_cargo']);
                if(!$orc_cargo_id){
                    $this->msg = "Cargo não cadastrado no orçamento. Erro: 080420200911";
                    return false;
                }
            }
            else{
                $dados = $this->obtCargoFunc($orc_id, $value['cod_funcionario']);
                if(!$dados){
                    $this->msg = "Cargo não cadastrado em Cargos/Turmas";
                    return false;
                }
                $orc_cargo_id[0]['id'] = $dados[0]['orc_cargo_id'];
            }

            if($value['tipo_demissao'] == 'Funcionário x Mês'){
                $funcionario_id = $this->getFuncionarioId($value['cod_funcionario'])[0]['id'];
                if(!$funcionario_id){
                    $this->msg = "Funcionário inexistente. Erro: 290620201459";
                    return false;
                }
            }

            $demissoes = $this->putOrcCargoIdOnData($value,$orc_cargo_id[0]['id']);
            $demissoes = $this->putOrcTurmaIdOnData($demissoes,$orc_turma_id[0]['id']);

            $form_data = Arr::except($demissoes, ['cod_cargo','cod_turno','cod_turma','cod_funcionario','jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
            $tipo = 0;
            if($value['tipo_demissao'] == 'Funcionário x Mês'){
                $tipo = 2;
            }
            else if($value['tipo_demissao'] == 'Cargo x Turma'){
                $tipo = 1;
            }
            else{
                $tipo = 3;
            }
            $form_data['orcamento_id'] = $orc_id;
            $form_data['lotacao_id'] = $lotacao['lotacao_id'];
            $form_data['tipo_table'] = 'O';
            $form_data['tipo'] = $tipo;
            $form_data['func_id'] = $funcionario_id;
            $form_data['tempo_casa'] = array_key_exists('tempo_casa',$value) ? $value['tempo_casa'] : null;

            if(!$this->existInHeadcount( $demissoes['orc_cargo_id'], $demissoes['orc_turma_id'], $orc_id, $lotacao['lotacao_id'] )){
                $this->msg = "Falha ao inserir registro. Cargo e Turma não cadastrados no Headcount. Erro: 080420200940";
                return false;
            }

            $form_data['qtde_pessoas'] = array_key_exists('quantidade_pessoas',$form_data) ? $form_data['quantidade_pessoas'] : null;

            unset($form_data['tipo_demissao']);
            unset($form_data['quantidade_pessoas']);
            unset($form_data['cod_lotacao']);
            unset($form_data['cod_ccusto']);

            $meses = Arr::except($value,['cod_lotacao','cod_ccusto','cod_cargo','cod_turma','cod_turno','tipo_demissao','cod_funcionario','mes','tempo_casa','quantidade_pessoas']);

            $form_data['meses_orcado'] = $meses;
            $form_data['ccusto_id'] = $lotacao['ccusto_id'];
            
            if($tipo == 2){
                $form_data['tempo_casa'] = null;
                $form_data['qtde_pessoas'] = null;
                $form_data['meses_orcado'] = [];
            }
            else if($tipo == 1){
                if(array_key_exists('mes',$form_data)){
                    unset($form_data['mes']);
                }
                $form_data['qtde_pessoas'] = null;
                $form_data['tempo_casa'] = null;
            }
            else{
                $form_data['meses_orcado'] = null;
            }
            $create = $this->repo_demissoes->created($form_data);

            if($create['status'] == 'error'){
                $this->msg = $create['msg'];
                return false;
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            $this->msg = "Falha ao cadastrar o registro. Erro: 090420200927 - ".$e->getMessage();
            return false;
        }
        return true;
    }
    public function insertContratacoes($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id,$lotacao_id){
        $fields = array(
            0 => "cod_cargo",
            1 => "cod_turma",
            2 => "cod_turno",
            3 => "jan_orcado",
            4 => "fev_orcado",
            5 => "mar_orcado",
            6 => "abr_orcado",
            7 => "mai_orcado",
            8 => "jun_orcado",
            9 => "jul_orcado",
            10 => "ago_orcado",
            11 => "set_orcado",
            12 => "out_orcado",
            13 => "nov_orcado",
            14 => "dez_orcado",
            15 => "cod_lotacao",
            16 => "cod_ccusto"
        );

        
        $msg = '';
        $cont = 0;
        $status = 0;
        
        for($i = 0; $i < count($form_data); $i++){
            if(!$this->existeKeysAtual($form_data[$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2).'<br>';
                $this->msg = '';
            }
            else{
                $inserir = $this->insereContratacaoEnd($form_data[$i], $orc_id, $empresa_id, $lotacao_id);
                if($inserir == false){
                    $lotacao = $this->formataCod($form_data[$i]['cod_lotacao'],8);
                    $msg = $msg.'<br>'.$this->msg.' Falha ao inserir a Contratação de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Turma: <b>'.$form_data[$i]['cod_turma'].'</b>, Turno: <b>'.$form_data[$i]['cod_turno'].'</b> e Cargo: <b>'.$form_data[$i]['cod_cargo'].'</b> na linha '.($i + 2).'.<br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
        }
        
        if( ($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
        
    }
    public function insereContratacaoEnd($value, $orc_id, $empresa_id, $lotacao_id){
        set_time_limit(120);
        DB::beginTransaction();

        try {

            if(!$this->possuiPermissaoLotacao($orc_id, $value['cod_lotacao'])){
                $this->msg = "Você não tem acesso a Lotação de Código <b>".$this->formataCod($value['cod_lotacao'],8)."</b> no Centro de Custo <b>".$value['cod_ccusto']."</b>.";
                return false;
            }

            $orc_turma_id = $this->getOrcTurma($value['cod_turma'],$value['cod_turno'],$orc_id);//dar uma olhada no turno depois
            if(count($orc_turma_id) == 0){
                $this->msg = "Turma e Turno não cadastrados nesse orçamento.";
                return false;
            }
            $orc_cargo_id = $this->getOrcCargo($orc_id,$value['cod_cargo']);
            if(!$orc_cargo_id){
                $this->msg = "Cargo não cadastrado no orçamento.";
                return false;
            }
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod($value['cod_lotacao'],8), $value['cod_ccusto'],$orc_id);
            if(!$lotacao){
                $this->msg = "Lotação e Centro de Custo inexistentes.";
                return false;
            }
            $contratacoes = $this->putOrcCargoIdOnData($value,$orc_cargo_id[0]['id']);
            $contratacoes = $this->putOrcTurmaIdOnData($contratacoes,$orc_turma_id[0]['id']);

            $form_data = $this->removeArray($contratacoes,['cod_lotacao','cod_ccusto','cod_turno','cod_cargo','cod_turma','jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
            if(!$this->existInHeadcount($contratacoes['orc_cargo_id'],$contratacoes['orc_turma_id'],$orc_id,$lotacao_id)){
                $this->msg = "Falha ao inserir registro. Cargo e Turma não cadastrados no Headcount.";
                return false;
            }

            $form_data['orcamento_id'] = $orc_id;
            $form_data['lotacao_id'] = $lotacao['lotacao_id'];
            $form_data['empresa_id'] = $empresa_id;

            $meses = $this->removeArray($contratacoes,['cod_lotacao','cod_ccusto','cod_cargo','orc_turma_id','orc_cargo_id','cod_turma','cod_turno']);
            $form_data['meses'] = $meses;
            $form_data['ccusto_id'] = $lotacao['ccusto_id'];
            $create = $this->repo_contratacoes->createContratacoes($form_data);

            if($create['status'] != "success"){
                $this->msg = $create['msg'];
                return false;
            }
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            $this->msg = "Falha ao cadastrar registro. Erro: 080420201026 - ".$th->getMessage();
            return false;
        }
        return true;
    }
    public function validaTipoDemissao(&$value){
        if($value['tipo_demissao'] == 1){
            $value['quantidade_pessoas'] = null;
            $value['tempo_casa'] = null;
            $value['mes'] = null;

        }
        if($value['tipo_demissao'] == 2){
            $value['quantidade_pessoas'] = null;
            $value['tempo_casa'] = null;
        }
    }
    public function getCcustoByLotacaoId($lotacao_id, &$dados, $orc_id){
        $select = $this->tbl_orc_lotacao->select()
        ->where([
            [$this->tbl_orc_lotacao->getColunaAlias('id'),$lotacao_id],
            [$this->tbl_orc_lotacao->getColunaAlias('orcamento_id'),$orc_id]
        ])
        ->get()->toArray();

        if(count($select) > 0){
            $dados['ccusto_id'] = $select[0]['cc_custo_id'];
            return true;
        }
        return false;
    }
    public function insertOrcBeneficioImport($form_data, $orc_id, $tbl_name, $fields_headers, $chave,$empresa_id, $periodo = null, $tipo_table = 'O'){
        
        $fields = array(
            0 => "cod_evento",
            1 => "tipo_calculo",
            2 => "vlr_movto",
            3 => "exclusivo_admissao",
            4 => "salario_corte",
            5 => "vlr_maximo",
            6 => "jan_orcado",
            7 => "fev_orcado",
            8 => "mar_orcado",
            9 => "abr_orcado",
            10 => "mai_orcado",
            11 => "jun_orcado",
            12 => "jul_orcado",
            13 => "ago_orcado",
            14 => "set_orcado",
            15 => "out_orcado",
            16 => "nov_orcado",
            17 => "dez_orcado",
            18 => "cod_natureza"
        );

        $msg = "";
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data[$chave]); $i++){
            if(!$this->existeKeysAtual($form_data[$chave][$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
                $this->msg = '';
            }
            else{
                $inserir = $this->inserirBeneficioEnd($form_data[$chave][$i], $orc_id, $empresa_id, $periodo, $tipo_table);
                if( $inserir == false ){
                    $evento = $this->formataCod($form_data[$chave][$i]['cod_evento'],3);
                    $msg = $msg.'<br>'.$this->msg.' Falha ao inserir o Benefício de </b>Evento: <b>'.$evento.'</b> e Natureza: <b>'.$form_data[$chave][$i]['cod_natureza'].'</b><br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                }
            }
        }
        if($cont == 0){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function inserirBeneficioEnd($form_data, $orc_id, $empresa_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(120);
        //DB::beginTransaction();
        try{
            $colunas = array_merge($this->meses_orcado, ['vlr_movto', 'salario_corte', 'vlr_maximo']);
            $this->isMonetario($form_data, $colunas);
            
            //$data = $this->getBeneficio($form_data['beneficio_id']);
            // $exclusivo_admissao = strtolower($form_data['exclusivo_admissao']);
            
            if($form_data['exclusivo_admissao'] == 'Sim'){
                $form_data['exclusivo_admissao'] = 1;
            }
            else if($form_data['exclusivo_admissao'] == 'Não'){
                $form_data['exclusivo_admissao'] = 0;
            }
            else{
                $this->msg = "Valor não conhecido no campo exclusivo_admissao. Por favor, insira apenas <b>Sim</b> ou <b>Não</b>";
                return false;
            }
            
            $data = $this->existeBeneficio($this->formataCod($form_data['cod_evento'],3), $form_data['cod_natureza']);
            
            if(count($data) == 0){
                $this->msg = 'Benefício não encontrado.';
                return false;
            }
            $tipo_calc = 0;
            if($form_data['tipo_calculo'] == 'Por Hora'){
                $tipo_calc = 1;
            }
            else if($form_data['tipo_calculo'] == 'Proporcional'){
                $tipo_calc = 2;
            }
            else if($form_data['tipo_calculo'] == 'Fixo'){
                $tipo_calc = 3;
            }
            else if($form_data['tipo_calculo'] == 'Dias Trabalhados'){
                $tipo_calc = 4;
            }
            else{
                $this->msg = "Falha ao indentificar o Tipo do Cálculo.";
                return false;
            }
            
            $dados_orc_beneficio = array_merge(
                Arr::except($form_data,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
                'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']),
                array("orcamento_id" => $orc_id, "cta_ctb_id"=>$data[0]['cta_ct_id'],'evento_id'=>$data[0]['evento_id'],
                'empresa_id'=>$empresa_id, 'tipo_acesso'=>$data[0]['tipo_acesso'],'beneficio_id'=>$data[0]['id']
                //'created_at'=>date('Y-m-d H:i:s')
            ));
            $dados_orc_beneficio['vlr_maximo'] = $tipo_calc == 2 ? $data[0]['vlr_maximo'] : 0;
            $dados_orc_beneficio['tipo_calc'] = $tipo_calc;

            $query = $this->tbl_orc_beneficio->select('id')
            ->where([
                [$this->tbl_orc_beneficio->getColunaAlias('cta_ctb_id'),'=',$dados_orc_beneficio['cta_ctb_id']],
                [$this->tbl_orc_beneficio->getColunaAlias('beneficio_id'),'=',$dados_orc_beneficio['beneficio_id']],
                [$this->tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$dados_orc_beneficio['orcamento_id']],
                [$this->tbl_orc_beneficio->getColunaAlias('tipo_table'), '=', $tipo_table]
            ]);
            
            $select = [];
            
            if($tipo_table == 'F'){
                $select = $query->where($this->tbl_orc_beneficio->getColunaAlias('periodo'), $periodo)->get()->toArray();
            }
            else{
                $select = $query->whereNull($this->tbl_orc_beneficio->getColunaAlias('periodo'))->get()->toArray();
            }
            
            if(count($select) > 0){
                
                $dados = [];
                for($i = 0; $i < count($this->meses_orcado); $i++){
                    $dados[$this->meses_orcado[$i]] = $form_data[$this->meses_orcado[$i]];
                }
                return $this->updateJanDez($select[0]['id'], 'tbl_orc_beneficio', $dados);
            }
            $dados_orc_beneficio['tipo_table'] = $tipo_table;

            if($tipo_table == 'F'){
                $dados_orc_beneficio['periodo'] = $periodo;
            }
            $dados_orc_beneficio['grade_maximo'] = $data[0]['grade_maximo'];
            $dados_orc_beneficio['valor_deducao'] = $data[0]['valor_deducao'];
            $dados_orc_beneficio['created_at'] = $this->fillModificadoEm();
            $dados_orc_beneficio['created_by'] = $this->fillModificadoPor();
            
            $inserir_beneficio = $this->tbl_orc_beneficio->create($dados_orc_beneficio);
            if(!$inserir_beneficio){
                $this->msg = "Falha ao inserir Benefícios. Erro: 240620201606";
                return false;
            }
            $id = $inserir_beneficio->id;
            $dados_calc_orc =
            array(
                "origem_id" => $id,
                "tbl_origem" => $this->tbl_orc_beneficio->getTable(),
                'jan_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['jan_orcado'],
                'fev_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['fev_orcado'],
                'mar_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['mar_orcado'],
                'abr_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['abr_orcado'],
                'mai_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['mai_orcado'],
                'jun_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['jun_orcado'],
                'jul_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['jul_orcado'],
                'ago_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['ago_orcado'],
                'set_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['set_orcado'],
                'out_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['out_orcado'],
                'nov_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['nov_orcado'],
                'dez_orcado' => $tipo_calc == 2 ? $data[0]['multiplica'] : $form_data['dez_orcado']
            );

            if(!$this->tbl_calc_orcamento->create($dados_calc_orc)){
                $this->msg = "Falha ao inserir Valores do Orçamento. Erro: 240620201608";
                return false;
            }

            $indice = 1;
            $dados_calc_ind = array(
                "tbl_origem"=>$this->tbl_orc_beneficio->getTable(),
                "origem_id"=>$id,
                'jan_indice'=>$indice,
                'fev_indice'=>$indice,
                'marc_indice'=>$indice,
                'abril_indice'=>$indice,
                'maio_indice'=>$indice,
                'jun_indice'=>$indice,
                'jul_indice'=>$indice,
                'agost_indice'=>$indice,
                'set_indice'=>$indice,
                'out_indice'=>$indice,
                'nov_indice'=>$indice,
                'dez_indice'=>$indice
            );
            if(!$this->tbl_calc_ind->create($dados_calc_ind)){
                $this->msg = "Falha ao inserir Índices no Orçamento. Erro: 240620201609";
                return false;
            }
            //DB::commit();
            return true;
        }catch(\Exception $e){
            //DB::rollBack();
            $this->msg = "Erro: 240620201610. <br>".$e->getMessage();
            return false;
        }
    }
    public function updateJanDez($origem_id, $tbl_origem, $dados){
        try{
            $dados['updated_at'] = $this->fillModificadoEm();
            $dados['updated_by'] = $this->fillModificadoPor();
            $dados['tbl_origem'] = $tbl_origem;
            $dados['origem_id'] = $origem_id;

            DB::update("UPDATE {$tbl_origem} set updated_at = getdate(), updated_by = {$dados['updated_by']} where id = {$origem_id}");

            $update = DB::table('tbl_calc_orcamento')
            ->where('origem_id', $origem_id)
            ->where('tbl_origem', $tbl_origem)
            ->update($dados);
            
            if($update !== false){
                if($update === 0){
                    unset($dados['updated_at'], $dados['updated_by']);
                    $dados['created_by'] = $this->fillCriadoEm();
                    $dados['created_at'] = $this->fillCriadoPor();
                    $insert = DB::table('tbl_calc_orcamento')->insert($dados);

                    if($insert !== false){
                        $this->msg = 'Registro inserido com sucesso!';
                        return true;
                    }
                }
                $this->msg = 'Registro atualizado com sucesso!';
                return true;
            }
            $this->msg = 'Falha ao atualizar registro!';
            return false;
        }catch(\Exception $e){
            $this->msg = "Falha ao atualizar registro! Erro: 020920201541 - ".$e->getMessage();
            return false;
        }
        
    }
    public function checkHeadersBeneficio($headers_cod, $headers_planilha, $id = 2){
        $cont = false; $campos = ""; $t = 0;
        if($id == 1){
            for($i = 0; $i < count($headers_planilha); $i++){
                $cont = true;
                if( !array_key_exists($headers_planilha[$i], $headers_cod) ){
                    $campos = $campos != '' ? $campos.', '.$headers_planilha[$i] : $headers_planilha[$i];
                }
            }
            if($campos != ''){
                $this->msg = "Impossível encontrar a(s) seguinte(s) coluna(s) na planilha: <b>".$campos."</b>.<br>Por favor, verifique o cabeçalho da planilha ";
                return false;
            }
            return true;
        }

        else{
            for($i = 0; $i < count($headers_cod); $i++){
                for($y = 0; $y < count($headers_planilha); $y++){
                    $cont = false;
                    if($headers_cod[$i] == $headers_planilha[$y]){
                        $cont = true;
                        break;
                    }   
                }
                if(!$cont){
                    $campos = $t > 0 ? $campos.', '.$headers_cod[$i] : $headers_cod[$i];
                    $t++;
                }
            }
            if($t > 0){
                $this->msg = "Impossível encontrar a(s) seguinte(s) coluna(s) na planilha: <b>".$campos."</b>.<br>Por favor, verifique o cabeçalho da planilha.";
                return false;
            }
            return true;
        }
    }
    public function getBeneficio($beneficio_id){
        $tbl_evento = new Eventos();
        $select = $this->tbl_beneficio
        ->join( $tbl_evento->getTable(), $this->tbl_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
        ->select(
            $this->tbl_beneficio->getColunaAlias('id'),
            $this->tbl_beneficio->getColunaAlias('cta_ct_id'),
            $this->tbl_beneficio->getColunaAlias('vlr_maximo'),
            $this->tbl_beneficio->getColunaAlias('evento_id'),
            $this->tbl_beneficio->getColunaAlias('tipo_acesso'),
            $tbl_evento->getColunaAlias('multiplica')
        )
        ->where([
            [$this->tbl_beneficio->getColunaAlias('id'),'=',$beneficio_id]
        ])
        ->get()->toArray();
        return count($select) > 0 ? $select : false;
    }
    public function getOrcCargo($orc_id, $cod_cargo, $periodo = null, $tipo_table = 'O', $name_field='cod_cargo_basic'){
        $cargo = new Cargo();

        $query = $this->repo_orc_cargo->getModelEntity()
        ->select($this->repo_orc_cargo->getModelEntity()->getColunaAlias('id'))
        ->leftJoin(
            $cargo->getTable(),
            $cargo->getColunaAlias('id'),
            $this->repo_orc_cargo->getModelEntity()->getColunaAlias('cargo_id')
        )->where([
            ["orcamento_id", $orc_id],
            [$cargo->getColunaAlias($name_field), $cod_cargo],
            [$this->repo_orc_cargo->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table]
        ]);
        
        if($tipo_table == 'F'){
            return $query->where('periodo', $periodo)->get()->toArray();
        }
        else{
            return $query->whereNull('periodo')->get()->toArray();
        }
        
    }

    public function getOrcTurma($cdn_turma,$cdn_turno,$orc_id){
        $turma = new Turma();
        $turno = new Turno();
        $entity_turma =$this->repo_orc_turma->getModelEntity();

       return $entity_turma->select(
           $entity_turma->getColunaAlias('id')
       )
        ->leftJoin($turma->getTable(),
            $turma->getColunaAlias('id'),
            $entity_turma->getColunaAlias('turma_id')
        )
        ->leftJoin($turno->getTable(),
            $turma->getColunaAlias('turno_id'),
            $turno->getColunaAlias('id')
        )
        ->where([
            [$turma->getColunaAlias('cdn_turma_trab'),$cdn_turma],
            [$turno->getColunaAlias('cdn_turno_trab'),$cdn_turno],
            [$entity_turma->getColunaAlias('orc_id'),$orc_id]
        ])->get()->toArray();

    }

    public function getOrcTurmaById($id_turma,$orc_id){
        $turma = new Turma();
        $turno = new Turno();
        $entity_turma =$this->repo_orc_turma->getModelEntity();

       return $entity_turma->select(
           $entity_turma->getColunaAlias('id')
       )
        ->leftJoin($turma->getTable(),
            $turma->getColunaAlias('id'),
            $entity_turma->getColunaAlias('turma_id')
        )
        ->leftJoin($turno->getTable(),
            $turma->getColunaAlias('turno_id'),
            $turno->getColunaAlias('id')
        )
        ->where([
            [$turma->getColunaAlias('id'),$id_turma],
            [$entity_turma->getColunaAlias('orc_id'),$orc_id]
        ])->get()->toArray();

    }

    public function getCcusto($cod_ccusto){

        $ccusto = new CentroCusto();

        return $ccusto->select("id")->where('cod_ccusto',$cod_ccusto)->get()->toArray();
    }

    public function removeArray($arr_elements,$arr_remove){

        foreach ($arr_remove as $value) {
            unset($arr_elements[$value]);
        }
        return $arr_elements;
    }


    public function putOrcCargoIdOnData($dados, $value, $cargo_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }

        $retorno = Arr::add($dados, empty($cargo_id_name) ? 'orc_cargo_id' : $cargo_id_name, $value);
        return $retorno;
    }

    public function putOrcTurmaIdOnData($dados, $value, $turma_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }

        $retorno = Arr::add($dados, empty($turma_id_name) ? 'orc_turma_id' : $turma_id_name, $value);
        return $retorno;
    }

    public function putCcustoIdOnData($dados, $value, $ccusto_name=''){
        if(is_array($dados)===false){
            return $dados;
        }

        $retorno = Arr::add($dados, empty($orcamento_id_name) ? 'ccusto_id' : $ccusto_name, $value);
        return $retorno;
    }

    /**CREATE */

    public function created($instance_repo,$form_data,$meses=0){
        $repo_calc_orc = new RepoCalcOrcamento();

        // DB::beginTransaction();
        // dd($instance_repo);
        try {

            $insert = $instance_repo->create($form_data);
            if(!$insert){
                $this->setError("Erro ao cadastrar registro. Erro: 060420201601");
                return false;
            }
            if($meses!=0){
                $meses['origem_id'] = $insert->id;
                $meses['tbl_origem'] = $instance_repo->getModelEntity()->getTable();

                $insert_calc = $repo_calc_orc->create(
                    $meses
                );
                if(!$insert_calc){
                    $this->setError("Erro ao cadastrar registro. Erro: 060420201646");
                    return false;
                }
            }
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            $this->setError('Erro ao cadatrar o registro. Erro: 060420201558. '.$e->getMessage());
            return false;
        }
    }
    public function checkHeaders($fields,$fields_headers){
        for ($i=0; $i < count($fields); $i++) {
            if($fields_headers[$i] != $fields[$i]){
                $this->setError('Erro! Verifique o cabeçalho da planilha! Erro: 030420201525');
                return false;
            }
        }

        return true;
    }

    public function existInHeadcount($orc_cargo,$turma_id,$orc_id,$lotacao_id){
        $select = $this->repo_headcount->getModelEntity()->where([
            ['orc_id',$orc_id],
            ['orc_cargo_id',$orc_cargo],
            ['lotacao_id',$lotacao_id],
            ['orc_turma_id',$turma_id]
        ])->get()->toArray();

        return count($select) > 0 ? $select[0] : false;
    }

    public function getFuncionarioId($cdn_func){
        $func = new Funcionario();
        return $func->select("id",'turma_id','cargo_id')->where("cdn_funcionario",$cdn_func)->get()->toArray();
    }
    public function insertBeneficioFunc($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $periodo = null, $tipo_table = 'O'){

        $fields = array(
            0 => "cod_funcionario",
            1 => "cod_evento", // não preciso
            2 => "cod_natureza",
            3 => "cod_lotacao", // buscar na tbl_lot depois em orc_lot
            4 => "tipo_calculo", // usuario
            5 => "vlr_movto",// usuario
            6 => "vlr_maximo",// usuario
            7 => "jan_orcado",// usuario
            8 => "fev_orcado",// usuario
            9 => "mar_orcado",// usuario
            10 => "abr_orcado",// usuario
            11 => "mai_orcado",// usuario
            12 => "jun_orcado",// usuario
            13 => "jul_orcado",// usuario
            14 => "ago_orcado",// usuario
            15 => "set_orcado",// usuario
            16 => "out_orcado",// usuario
            17 => "nov_orcado",// usuario
            18 => "dez_orcado",// usuario
            19 => "cod_ccusto"
        );
        // if(!$this->checkHeadersBeneficio($fields,$fields_headers)){
        //     return false;
        // }
        // else{
        $msg = '';
        $cont = 0;
        $status = 0;
        for($i = 0; $i < count($form_data); $i++){
            if(!$this->existeKeysAtual($form_data[$i], $fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
            }
            else{
                $inserir = $this->inserirOrcBeneficioFuncionarioEnd($form_data[$i], $orc_id, $empresa_id, $periodo, $tipo_table);
                if( $inserir == false ){
                    $lotacao = $this->formataCod(strval($form_data[$i]['cod_lotacao']),8);
                    $evento = $this->formataCod($form_data[$i]['cod_evento'],3);
                    $msg = $msg.'<br>'.$this->msg.' Falha ao inserir o Benefício por Funcionário de Lotação: <b>'.$lotacao.'</b>, Centro de Custo: <b>'.$form_data[$i]['cod_ccusto'].'</b>, Funcionário: <b>'.$form_data[$i]['cod_funcionario'].'</b>, Evento: <b>'.$evento.'</b> e Natureza: <b>'.$form_data[$i]['cod_natureza'].'</b><br>';
                    $cont++;
                    $status--;
                }
                else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
    }
    public function inserirOrcBeneficioFuncionarioEnd($form_data, $orc_id, $empresa_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(200);
        //DB::beginTransaction();
        try{
            $colunas = array_merge($this->meses_orcado, ['vlr_movto', 'vlr_maximo']);
            $this->isMonetario($form_data, $colunas);
            
            /// REVISAR OS CAMPOS
            $funcionario_id = $this->getFuncionarioId($form_data['cod_funcionario']);

            //$orc_lotacao_id = $this->getOrcLotacaoByCodLotacao($form_data['cod_lotacao'], $orc_id);
        

            if( $funcionario_id == false ){
                $this->msg = "Funcionário inexistente.";
                return false;
            }
            
            $dados_beneficio = $this->getOrcBeneficioIdByEventoCtaCtb($this->formataCod(strval($form_data['cod_evento']), 3), $form_data['cod_natureza'], $orc_id, $periodo, $tipo_table);
            if( $dados_beneficio == false ){
                $this->msg = "Benefício inexistente.";
                return false;
            }
            
            $lotacao = $this->obtLotacaoCcustoByCodLotCcusto($this->formataCod(strval($form_data['cod_lotacao']),8), $form_data['cod_ccusto'], $orc_id, $periodo, $tipo_table);
            if( $lotacao == false ){
                $this->msg = "Lotação e Centro de Custo inexistentes.";
                return false;
            }

            $query = $this->tbl_orc_ben_func
            ->select()
            ->where([
                [$this->tbl_orc_ben_func->getColunaAlias('orcamento_id'),'=',$orc_id],
                [$this->tbl_orc_ben_func->getColunaAlias('orc_lotacao_id'),'=',$lotacao['lotacao_id']],
                [$this->tbl_orc_ben_func->getColunaAlias('funcionario_id'),'=',$funcionario_id[0]['id']],
                [$this->tbl_orc_ben_func->getColunaAlias('orc_beneficio_id'),'=',$dados_beneficio[0]['orc_beneficio_id']],
                [$this->tbl_orc_ben_func->getColunaAlias('ccusto_id'),'=',$lotacao['ccusto_id']],
                [$this->tbl_orc_ben_func->getColunaAlias('cta_ctb_id'),'=',$dados_beneficio[0]['cta_ctb_id']],
                [$this->tbl_orc_ben_func->getColunaAlias('tipo_table'),'=',$tipo_table]
            ]);
            $select = [];
            if($tipo_table == 'F'){
                $select = $query->where($this->tbl_orc_ben_func->getColunaAlias('periodo'), $periodo)->get()->toArray();
            }
            else{
                $select = $query->whereNull($this->tbl_orc_ben_func->getColunaAlias('periodo'))->get()->toArray();
            }
            
            if(count($select) > 0){
                $this->msg = "Registro já existente.";
                
                $dados_update = [];
                for($i = 0; $i < count($this->meses_orcado); $i++){
                    $dados_update[$this->meses_orcado[$i]] = $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data[$this->meses_orcado[$i]];
                }
                $dados_update['vlr_movto'] = $form_data['vlr_movto'];
                $dados_update['vlr_maximo'] = $form_data['vlr_maximo'];
                
                $resp_update = $this->updateBeneficioFuncionario($select[0]['id'], $orc_id, $lotacao['lotacao_id'], $funcionario_id[0]['id'], $dados_beneficio[0]['orc_beneficio_id'], $lotacao['ccusto_id'], $dados_beneficio[0]['cta_ctb_id'], $dados_update);
                $this->msg = $resp_update == true ? 'Atualizado com sucesso!' : 'Falha ao atualizar';
                return true;
            }
            $tipo_calc = 0;
            if($form_data['tipo_calculo'] == 'Por Hora'){
                $tipo_calc = 1;
            }
            else if($form_data['tipo_calculo'] == 'Proporcional'){
                $tipo_calc = 2;
            }
            else if($form_data['tipo_calculo'] == 'Fixo'){
                $tipo_calc = 3;
            }
            else if($form_data['tipo_calculo'] == 'Dias Trabalhados'){
                $tipo_calc = 4;
            }
            else{
                $this->msg = "Falha ao indentificar o Tipo do Cálculo.";
                return false;
            }

            $dados_orc_ben_func = array(
                'orcamento_id' => $orc_id,
                'orc_lotacao_id' => $lotacao['lotacao_id'],
                'funcionario_id' => $funcionario_id[0]['id'],
                'orc_beneficio_id' => $dados_beneficio[0]['orc_beneficio_id'],
                'ccusto_id' => $lotacao['ccusto_id'],
                'tipo_calc' => $tipo_calc,
                'vlr_movto' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['vlr_movto'],
                'vlr_maximo' => $form_data['tipo_calculo'] == 'Proporcional' ? $form_data['vlr_maximo'] : 0,
                'cta_ctb_id' => $dados_beneficio[0]['cta_ctb_id'],
                'empresa_id' => $empresa_id,
                'tipo_table' => $tipo_table,
                'created_at' => $this->fillCriadoEm(),
                'created_by' => $this->fillCriadoPor()
            );
            if($tipo_table == 'F'){
                $dados_orc_ben_func['periodo'] = $periodo;
            }
            
            $inserir_orc_ben_func = $this->tbl_orc_ben_func->create($dados_orc_ben_func);
            if(!$inserir_orc_ben_func){
                $this->msg = "Falha ao inserir Benefício por Funcionário.";
                return false;
            }
            $id = $inserir_orc_ben_func->id;
            $dados_calc_orc = array(
                "origem_id" => $id,
                "tbl_origem" => $this->tbl_orc_ben_func->getTable(),
                'jan_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['jan_orcado'],
                'fev_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['fev_orcado'],
                'mar_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['mar_orcado'],
                'abr_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['abr_orcado'],
                'mai_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['mai_orcado'],
                'jun_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['jun_orcado'],
                'jul_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['jul_orcado'],
                'ago_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['ago_orcado'],
                'set_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['set_orcado'],
                'out_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['out_orcado'],
                'nov_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['nov_orcado'],
                'dez_orcado' => $form_data['tipo_calculo'] == 'Proporcional' ? $dados_beneficio[0]['multiplica'] : $form_data['dez_orcado']
            );

            $inserir_calc_orc = $this->tbl_calc_orcamento->create($dados_calc_orc);
            if(!$inserir_calc_orc){
                $this->msg = "Falha ao inserir Valores do Orçamento.";
                return false;
            }
            $indice = 1;
            $indices = DB::select("SELECT jan_indice,fev_indice, marc_indice, abril_indice
                ,maio_indice, jun_indice, jul_indice, agost_indice
                ,set_indice, out_indice, nov_indice, dez_indice
                from tbl_calc_indice where origem_id = {$dados_beneficio[0]['orc_beneficio_id']} and tbl_origem = 'tbl_orc_beneficio' ");
            $dados_calc_ind = array(
                "tbl_origem"=>$this->tbl_orc_ben_func->getTable(),
                "origem_id"=>$id,
                'jan_indice'=> count($indices) > 0 ? $indices[0]->jan_indice : $indice,
                'fev_indice'=> count($indices) > 0 ? $indices[0]->fev_indice : $indice,
                'marc_indice'=> count($indices) > 0 ? $indices[0]->marc_indice : $indice,
                'abril_indice'=> count($indices) > 0 ? $indices[0]->abril_indice : $indice,
                'maio_indice'=> count($indices) > 0 ? $indices[0]->maio_indice : $indice,
                'jun_indice'=> count($indices) > 0 ? $indices[0]->jun_indice : $indice,
                'jul_indice'=> count($indices) > 0 ? $indices[0]->jul_indice : $indice,
                'agost_indice'=> count($indices) > 0 ? $indices[0]->agost_indice : $indice,
                'set_indice'=> count($indices) > 0 ? $indices[0]->set_indice : $indice,
                'out_indice'=> count($indices) > 0 ? $indices[0]->out_indice : $indice,
                'nov_indice'=> count($indices) > 0 ? $indices[0]->out_indice : $indice,
                'dez_indice'=> count($indices) > 0 ? $indices[0]->dez_indice : $indice,
            );
            $inserir_calc_ind = $this->tbl_calc_ind->create($dados_calc_ind);
            if(!$inserir_calc_ind){
                $this->msg = "Falha ao inserir Índices no Orçamento.";
                return false;
            }
            //DB::commit();
        }catch(\Exception $e){
            //DB::rollBack();
            $this->msg = "Falha ao inserir Benefício por Funcionário. Erro: 250620201601 - ". $e->getMessage();
            return false;
        }
        return true;
    }
    public function updateBeneficioFuncionario($id, $orc_id, $lotacao_id, $funcionario_id, $orc_beneficio_id, $ccusto_id, $cta_ctb_id, $dados){
        $ben_func = new OrcLotFuncionatioBeneficio();
        $calc = new CalcOrcamento();
        // update em calc e em principal
        $data_calc = Arr::except($dados, ['vlr_movto','vlr_maximo']);
        $data_principal = Arr::only($dados, ['vlr_movto','vlr_maximo']);
        
        $update1 = DB::table($calc->getTable())
        ->where([
            ['tbl_origem','=',$ben_func->getTable()],
            ['origem_id','=',$id]
        ])
        ->update($data_calc);

        $update2 = DB::table($ben_func->getTable())
        ->where([
            // ['orcamento_id','=',$orc_id],
            // ['orc_lotacao_id','=',$lotacao_id],
            // ['funcionario_id','=',$funcionario_id],
            // ['orc_beneficio_id','=',$orc_beneficio_id],
            // ['ccusto_id','=',$ccusto_id],
            // ['cta_ctb_id','=',$cta_ctb_id]
            ['id', $id]
        ])
        ->update($data_principal);

        if($update1 > 0 && $update2 > 0){
            return true;
        }
        return false;
    }
    public function getOrcBeneficioIdByEventoCtaCtb($cdn_evento, $cod_ctb_ctb, $orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_evento = new Eventos();
        $tbl_cta_ctb = new ContaContabil();
        
        $query = $this->tbl_orc_beneficio
        ->join($tbl_evento->getTable(), $this->tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
        ->join($tbl_cta_ctb->getTable(), $this->tbl_orc_beneficio->getColunaAlias('cta_ctb_id'), $tbl_cta_ctb->getColunaAlias('id'))
        ->select(
            DB::raw("{$this->tbl_orc_beneficio->getColunaAlias('id')} as orc_beneficio_id"),
            $this->tbl_orc_beneficio->getColunaAlias('cta_ctb_id'),
            $tbl_evento->getColunaAlias('multiplica')
        )
        ->where([
            [$tbl_evento->getColunaAlias('cdn_event'),'=',$cdn_evento],
            [$tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),'=',$cod_ctb_ctb],
            [$this->tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$this->tbl_orc_beneficio->getColunaAlias('tipo_table'),'=',$tipo_table]
        ]);

        $select = [];
        if($tipo_table == 'F'){
            $select = $query->where($this->tbl_orc_beneficio->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->tbl_orc_beneficio->getColunaAlias('periodo'))->get()->toArray();
        }
        return count($select) > 0 ? $select : false;
    }
    public function getOrcLotacaoByCodLotacao($cod_lotacao, $orc_id){
        $select = $this->tbl_lotacao
        ->join($this->tbl_orc_lotacao->getTable(), $this->tbl_lotacao->getColunaAlias('id'), $this->tbl_orc_lotacao->getColunaAlias('lotacao_id'))
        ->select(
            DB::raw("{$this->tbl_orc_lotacao->getColunaAlias('id')} as orc_lotacao_id"),
            DB::raw("{$this->tbl_orc_lotacao->getColunaAlias('cc_custo_id')} as ccusto_id")
        )
        ->where([
            [$this->tbl_lotacao->getColunaAlias('unid_lotac'),'=',$cod_lotacao],
            [$this->tbl_orc_lotacao->getColunaAlias('orcamento_id'),'=',$orc_id]
        ])
        ->get()->toArray();
        return count($select) > 0 ? $select : false;
    }
    public function inserirOrcSalarioFuncionario($form_data, $orc_id, $tbl_name, $fields_headers, $chave, $empresa_id, $tipo_table, $periodo){

        $fields = array(
            0 => 'cod_funcionario', // faço um select e pego
            1 => "jan_orcado",// usuario
            2 => "fev_orcado",// usuario
            3 => "mar_orcado",// usuario
            4 => "abr_orcado",// usuario
            5 => "mai_orcado",// usuario
            6 => "jun_orcado",// usuario
            7 => "jul_orcado",// usuario
            8 => "ago_orcado",// usuario
            9 => "set_orcado",// usuario
            10 => "out_orcado",// usuario
            11 => "nov_orcado",// usuario
            12 => "dez_orcado",// usuario
            13 => "cod_turma",
            14 => "cod_turno",
            15 => "cod_cargo"
           
        );
        
        $msg = '';
        $cont = 0;
        $status = 0;

        for($i = 0; $i < count($form_data[$chave]); $i++){
            if(!$this->existeKeysAtual($form_data[$chave][$i],$fields)){
                $msg = $msg.'<br>'.$this->msg.' na linha '.($i + 2);
            }
            else{
                $inserir = $this->inserirOrcSalarioFuncionarioEnd($form_data[$chave][$i], $orc_id, $empresa_id, $tipo_table, $periodo);
                if($inserir == false){
                    $msg = $msg.'<br>'.$this->msg.'.<br> Falha ao inserir Salário por Funcionário de Funcionário: <b>'.$form_data[$chave][$i]['cod_funcionario'].'</b>, Cargo: <b>'.$form_data[$chave][$i]['cod_cargo'].'</b>, Turma: <b>'.$form_data[$chave][$i]['cod_turma'].'</b> e Turno: <b>'.$form_data[$chave][$i]['cod_turno'].'</b> na linha '.($i + 2).'.<br>';
                    $cont++;
                    $status--;
                }else{
                    $msg = $msg.'<br>Dados presentes na linha '.($i + 2).' foram inseridos com sucesso!<br>';
                    $status++;
                }
            }   
        }
        if(($msg == '' && $cont == 0) || ($status == count($form_data[$chave]))){
            return true;
        }
        $this->setError($msg);
        $this->msg = '';
        return false;
        
    }
    public function inserirOrcSalarioFuncionarioEnd($form_data, $orc_id, $empresa_id, $tipo_table = 'O', $periodo = null){
        set_time_limit(120);
        
        $this->isMonetario($form_data, $this->meses_orcado);
        
        $turma = $this->obtTurmaFromOrc($orc_id,$form_data['cod_turma'], $form_data['cod_turno'], $periodo, $tipo_table);
        if(!$turma){
            $this->msg = "Turma e Turno não encontrados no Orçamento";
            return false;
        }
        
        $select_dados_func = $this->getDadosOfFuncionario($form_data['cod_funcionario'], $orc_id, $turma, $periodo, $tipo_table);
        //dd(floatval($select_dados_func[0]['salario']),$form_data);
        if(!$select_dados_func){
            $this->msg = "Funcionário de código: <b>".$form_data['cod_funcionario']."</b>, Cargo: ".$form_data['cod_cargo'].", Turma: <b>".$form_data['cod_turma']."</b> e Turno: <b>".$form_data['cod_turno']."</b> não encontrados. Verifique se os dados informados existem! Erro: 130720201714";
            return false;
        }
         
        $cargo_existe = DB::select("SELECT * from tbl_cargo where cod_cargo_basic = ?", [$form_data['cod_cargo']]);
        if(count($cargo_existe) == 0){
            $this->msg = "Cargo de código <b>".$form_data['cod_cargo']."</b> não encontrado. Erro: 241120201606";
            return false;
        }

        $select_existe = $this->orcSalarioFuncionarioExiste($select_dados_func[0]['funcionario_id'], $select_dados_func[0]['orc_cargo_id'], $orc_id, $select_dados_func[0]['orc_lotacao_id'], $select_dados_func[0]['ccusto_id'], $turma, 0, $tipo_table, $periodo);
        if(!mesesValidacao(Arr::except($form_data,['cod_funcionario','cod_turma','cod_turno','tbl_origem','origem_id']))){
            $this->msg = "Os valores não podem diminuir ao longo dos meses";
            return false;
        }
        
        if($select_existe !== true){
            $dados = [];
            for($i = 0; $i < count($this->meses_orcado); $i++){
                $dados[$this->meses_orcado[$i]] = $form_data[$this->meses_orcado[$i]];
            }
            return $this->updateJanDez($select_existe[0]['id'], 'tbl_orc_salario_funcionario', $dados);
        }
        //DB::beginTransaction();
        
        /* SE JÁ TIVER SIDO CADASTRADO, PODERÁ ATUALIZAR OS VALORES, SENÃO NÃO(VAI CAIR NOS IF'S) */
        $orc_cargo_id = $this->getOrcCargo($orc_id, $form_data['cod_cargo'], $periodo, $tipo_table);
        
        $condicao[0] = $tipo_table == 'F' ? " and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' " : " and tipo_table = '{$tipo_table}' and periodo is null ";
        $orc_func = DB::select("SELECT * from tbl_orc_funcionario where funcionario_id = ? and orcamento_id = ? {$condicao[0]}", [$select_dados_func[0]['funcionario_id'], $orc_id]);
        if(count($orc_func) > 0 && $orc_func[0]->cargo_atualizado != 1){
            
            if($this->confereGradeCargo( $form_data['cod_cargo'], $orc_id, $orc_func[0]->orc_cargo_id, $periodo, $tipo_table)){
            
                if(!$this->atualizaOrcFuncionario($orc_id, $turma, $orc_cargo_id[0]['id'], $select_dados_func[0]['funcionario_id'], $periodo, $tipo_table)){
                    $this->msg = "Falha ao atualizar dados do funcionário de código ".$form_data['cod_funcionario'].". Erro: 241120201353";
                    return false;
                }
            }
        }
        

        try{
            
            $dados_func = array(
                'orc_id'=> $orc_id,
                'funcionario_id'=> $select_dados_func[0]['funcionario_id'],
                'orc_cargo_id'=> $orc_cargo_id[0]['id'],
                'lotacao_responsavel_id'=> 806,
                'lotacao_id'=> $select_dados_func[0]['orc_lotacao_id'],
                'ccusto_id'=> $select_dados_func[0]['ccusto_id'],
                'orc_turma_id'=> $turma,
                'tipo'=> $tipo_table == 'F' ? 3 : 0,
                'tipo_table'=> $tipo_table,
                'empresa_id'=> $empresa_id,
                'periodo' => $periodo,
                'created_at' => $this->fillModificadoEm(),
                'created_by' => $this->fillModificadoPor()
            );
            if($tipo_table != 'F'){
                unset($dados_func['periodo']);
            }
            
            $inserir = $this->tbl_orc_salario_func->create($dados_func);
            
            if(!$inserir){
                $this->msg = "Falha ao inserir Funcionário. Erro: 260620201052";
                return false;
            }
            $dados_calc = array_merge(
                Arr::except($form_data,['cod_funcionario','cod_turma','cod_turno']),
                array(
                    "tbl_origem"=>$this->tbl_orc_salario_func->getTable(),
                    "origem_id"=>$inserir->id
                )
            );
    
            if(!mesesValidacao(Arr::except($dados_calc,['tbl_origem','origem_id']))){
                $this->msg = "Os valores não podem diminuir ao longo dos meses.";
                return false;
            }
            $dados_calc['created_at'] = $this->fillModificadoEm();
            $dados_calc['created_by'] = $this->fillModificadoPor();

            if(!$this->tbl_calc_orcamento->create($dados_calc)){
                $this->msg = "Falha ao inserir Valores em Orçamento. Erro: 260620201053";
                return false;
            }
            //DB::commit();

        }catch(\Exception $e){
            //DB::rollBack();
            $this->msg = "Caiu no catch Erro: 260620201000 - ".$e->getMessage();
            return false;
        }
        return true;
    }

    public function atualizaOrcFuncionario($orc_id, $orc_turma_id, $orc_cargo_id, $funcionario_id, $periodo = null, $tipo_table = 'O'){
        try{
            $condicao = $tipo_table == 'F' ? " and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' " : " and tipo_table = '{$tipo_table}' and periodo is null";
            $update = DB::update("UPDATE tbl_orc_funcionario set cargo_atualizado = ?, orc_cargo_id = ?, orc_turma_id = ?, updated_at = ?, updated_by = ? where funcionario_id = ? and orcamento_id = ? {$condicao}",
            [1, $orc_cargo_id, $orc_turma_id, $this->fillCriadoEm(), $this->fillCriadoPor(), $funcionario_id, $orc_id]);
            return $update === false ? false : true;
        }
        catch(\Exception $e){
            $this->msg = "Caiu no catch, update orc_salario_funcionario. Erro: 241120201349 - ".$e->getMessage();
            return false;
        }
    }

    public function confereGradeCargo($cod_cargo_novo, $orc_id, $orc_cargo_antigo_id, $periodo = null, $tipo_table = 'O'){        

        $condicao = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        $cargo_cod = DB::select("SELECT c.cod_cargo_basic from tbl_orc_cargo as oc
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where oc.orcamento_id = ? and oc.id = ?".$condicao, [$orc_id, $orc_cargo_antigo_id]);

        $novo = substr($cod_cargo_novo, 0, 2);
        $antigo = substr($cargo_cod[0]->cod_cargo_basic, 0 , 2);
        
        if($antigo > $novo){
            $this->msg = "Impossível atualizar os dados do funcionário. Erro: 241120201416";
            return false;
        }
        return true;
    }

    public function obtTurmaFromOrc($orc_id, $cod_turma, $cod_turno, $periodo = null, $tipo_table = 'O'){
        
        $condicao = $tipo_table == 'O' ? " and turma.periodo is null and turma.tipo_table = '{$tipo_table}'" : " and turma.periodo = '{$periodo}' and turma.tipo_table = '{$tipo_table}'";
        $select = DB::select("
            select turma.id as orc_turma_id from tbl_orc_turma as turma
            join tbl_turno as turno on turma.turno_id = turno.id and turno.cdn_turno_trab = {$cod_turno}
            where turma.cdn_turma_trab = {$cod_turma} and turma.orc_id = {$orc_id}".$condicao
        );
        
        return count($select) > 0 ? $select[0]->orc_turma_id : null;
    }
    public function orcSalarioFuncionarioExiste($func_id, $orc_cargo_id, $orc_id, $orc_lot_id, $ccusto_id, $orc_turma_id, $tipo, $tipo_table = 'O', $periodo = null){
        
        $tipo = $tipo_table == 'F' ? 3 : $tipo;
        $query = $this->tbl_orc_salario_func
        ->select('tbl_orc_salario_funcionario.*')
        ->where([
            [$this->tbl_orc_salario_func->getColunaAlias('orc_id'),'=',$orc_id],
            [$this->tbl_orc_salario_func->getColunaAlias('funcionario_id'),'=',$func_id],
            [$this->tbl_orc_salario_func->getColunaAlias('orc_cargo_id'),'=',$orc_cargo_id],
            [$this->tbl_orc_salario_func->getColunaAlias('lotacao_id'),'=',$orc_lot_id],
            [$this->tbl_orc_salario_func->getColunaAlias('ccusto_id'),'=',$ccusto_id],
            [$this->tbl_orc_salario_func->getColunaAlias('orc_turma_id'),'=',$orc_turma_id],
            [$this->tbl_orc_salario_func->getColunaAlias('tipo'),'=',$tipo],
            [$this->tbl_orc_salario_func->getColunaAlias('tipo_table'),'=',$tipo_table]
            //[$this->tbl_orc_salario_func->getColunaAlias('periodo'),'=',$periodo]
        ]);
        $select = [];
        
        if($tipo_table == 'F'){
            $select = $query->where($this->tbl_orc_salario_func->getColunaAlias('periodo'),'=',$periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->tbl_orc_salario_func->getColunaAlias('periodo'))->get()->toArray();
        }
        
        return count($select) == 0 ? true : $select;
    }
    public function getDadosOfFuncionario($cod_funcionario, $orc_id, $turma_id, $periodo = null, $tipo_table = 'O'){
        // $tbl_funcionario = new Funcionario();
        // $tbl_orc_turma = new OrcTurma();
        // $tbl_cargo = new Cargo();
        $condicao[0] = $tipo_table == 'O' ? " and orccargo.periodo is null and orccargo.tipo_table = '{$tipo_table}'" : " and orccargo.periodo = '{$periodo}' and orccargo.tipo_table = '{$tipo_table}'";
        $condicao[1] = $tipo_table == 'O' ? " and turma.periodo is null and turma.tipo_table = '{$tipo_table}'" : " and turma.periodo = '{$periodo}' and turma.tipo_table = '{$tipo_table}'";
        $condicao[2] = $tipo_table == 'O' ? " and orc_lot.periodo is null and orc_lot.tipo_table = '{$tipo_table}'" : " and orc_lot.periodo = '{$periodo}' and orc_lot.tipo_table = '{$tipo_table}'";
        
        $select = DB::select("SELECT 
            func.id as funcionario_id,
            func.cdn_funcionario as cdn_funcionario,
            func.nome_funcionario as nome_funcionario,
            orccargo.orcamento_id as orcamento_id,
            orccargo.id as orc_cargo_id,
            cargo.salario as salario,
            orc_lot.id as orc_lotacao_id,
            orc_lot.cc_custo_id as ccusto_id,
            turma.id as orc_turma_id
            
            from tbl_funcionario as func
            
            join tbl_cargo as cargo on func.cargo_id = cargo.id
            join tbl_orc_cargo as orccargo on func.cargo_id = orccargo.cargo_id and orccargo.orcamento_id = $orc_id".$condicao[0]."
            join tbl_orc_lotacao as orc_lot on func.lotacao_id = orc_lot.lotacao_id and orc_lot.orcamento_id = $orc_id {$condicao[2]}
            join tbl_orc_turma as turma on turma.id = $turma_id".$condicao[1]."
            
            where func.cdn_funcionario = $cod_funcionario
        ");

        $dados = [];
        if(is_array($select) && count($select) > 0){
            $dados[0] = (array)$select[0];
        }
        return count($dados) == 0 ? false : $dados;
    }
    public function existeBeneficio($cod_evento, $cod_cta_ctb){
        $tbl_evento = new Eventos();

        $tbl_cta_ctb = new ContaContabil();
        $select = $this->tbl_beneficio
            ->join($tbl_evento->getTable(), $this->tbl_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
            ->join($tbl_cta_ctb->getTable(), $this->tbl_beneficio->getColunaAlias('cta_ct_id'), $tbl_cta_ctb->getColunaAlias('id'))
            ->select(
                $this->tbl_beneficio->getColunaAlias('id'),
                $this->tbl_beneficio->getColunaAlias('cta_ct_id'),
                $this->tbl_beneficio->getColunaAlias('evento_id'),
                $this->tbl_beneficio->getColunaAlias('tipo_acesso'),
                $this->tbl_beneficio->getColunaAlias('vlr_maximo'),
                $this->tbl_beneficio->getColunaAlias('multiplica'),
                $this->tbl_beneficio->getColunaAlias('grade_maximo'),
                $this->tbl_beneficio->getColunaAlias('valor_deducao')
            )
            ->where([
                [$tbl_evento->getColunaAlias('cdn_event'),'=',$cod_evento],
                [$tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),'=',$cod_cta_ctb],
            ])
        ->get()->toArray();
        return count($select) > 0 ? $select : false;
    }
    public function falhaEncontrar($label, $array){
        if(count($array) == 0){
            $this->setError($label." não encontrada(o). Erro: 010720201202");
            return false;
        }
        return true;
    }
    public function confereCargo($orc_cargo_id, $orc_id, $func_id){
        $tbl_cargo = new Cargo();
        $tbl_funcionario = new Funcionario();
        $select = $tbl_cargo

        ->join($tbl_funcionario->getTable(), $tbl_cargo->getColunaAlias('id'), $tbl_funcionario->getColunaAlias('cargo_id'))
        ->join($this->repo_orc_cargo->getModelEntity()->getTable(), $tbl_cargo->getColunaAlias('id'), '=', DB::raw("{$this->repo_orc_cargo->getModelEntity()->getColunaAlias('cargo_id')} and {$this->repo_orc_cargo->getModelEntity()->getColunaAlias('orcamento_id')} = {$orc_id}"))
        ->select()
        ->where([
            [$this->repo_orc_cargo->getModelEntity()->getColunaAlias('id'),$orc_cargo_id],
            [$tbl_funcionario->getColunaAlias('id'),$func_id]
        ])
        ->get()
        ->toArray();

        return $select;
    }
    public function putQuadroAtual($lot_id,$cargo_id){
        $cargo = $cargo_id[0]['id'];
        $quadro_atual = DB::select(
            "select

            count(func.id) as quadro_atual

            from [tbl_funcionario] as func
            join [tbl_cargo] as cargo on cargo.id = func.cargo_id
            join [tbl_orc_cargo] as orc_cargo on orc_cargo.cargo_id = cargo.id and orc_cargo.id = 22410

            join [tbl_lotacao] as lotacao on lotacao.id = func.lotacao_id
            join [tbl_orc_lotacao] as orc_lotacao on lotacao.id = orc_lotacao.lotacao_id and orc_lotacao.id = 11572

            group by func.lotacao_id, func.cargo_id"
        );
        return count($quadro_atual) > 0 ? $quadro_atual[0]->quadro_atual : 0;
    }
    public function obtEventoByCod($cod_evento){
        $cod_evento = strval($cod_evento);
        $tbl_evento = new Eventos();
        $select = $tbl_evento->select()
        ->where($tbl_evento->getColunaAlias('cdn_event'),$cod_evento)
        ->get()->toArray();
        return count($select) > 0 ? $select[0] : false;
    }
    public function obtNaturezaByCod($cod_natureza){
        $tbl_natureza = new ContaContabil();
        $cod_natureza = strval($cod_natureza);
        $select  = $tbl_natureza->select()
        ->where($tbl_natureza->getColunaAlias('cod_cta_ctbl'),$cod_natureza)
        ->get()->toArray();
        return count($select) > 0 ? $select[0] : false;
    }
    public function obtDespesas($cod_evento, $cod_natureza){
        $tbl_despesa = new Despesas();
        $tbl_evento = new Eventos();
        $tbl_natureza = new ContaContabil();
        $cod_evento = strval($cod_evento);

        $select = $tbl_despesa
        ->join($tbl_evento->getTable(), $tbl_despesa->getColunaAlias('evento_id'), '=', DB::raw("{$tbl_evento->getColunaAlias('id')} and {$tbl_evento->getColunaAlias('cdn_event')} = '{$cod_evento}'"))
        ->join($tbl_natureza->getTable(), $tbl_despesa->getColunaAlias('cta_contabil_id'), '=', DB::raw("{$tbl_natureza->getColunaAlias('id')} and {$tbl_natureza->getColunaAlias('cod_cta_ctbl')} = {$cod_natureza}"))
        ->select(
            $tbl_despesa->getColunaAlias('id'),
            $tbl_despesa->getColunaAlias('evento_id'),
            $tbl_despesa->getColunaAlias('cta_contabil_id'),
            $tbl_despesa->getColunaAlias('valor_referencia')
        )
        // ->where([
        //     [$tbl_despesa->getColunaAlias('evento_id'),'=',$cod_evento],
        //     [$tbl_despesa->getColunaAlias('cta_contabil_id'),'=',$cod_natureza]
        // ])
        ->get()->toArray();
        return count($select) > 0 ? $select[0] : false;
    }
    public function existeDespesa($orc_id, $despesa, $lotacao_id, $ccusto_id, $periodo = null, $tipo_table = 'O'){

        $query = $this->tbl_orc_despesa->select()
        ->where([
            [$this->tbl_orc_despesa->getColunaAlias('orc_id'),$orc_id],
            [$this->tbl_orc_despesa->getColunaAlias('despesa_id'),$despesa],
            [$this->tbl_orc_despesa->getColunaAlias('lotacao_id'),$lotacao_id],
            [$this->tbl_orc_despesa->getColunaAlias('centro_custo_id'),$ccusto_id],
            [$this->tbl_orc_despesa->getColunaAlias('tipo_table'),$tipo_table]
        ]);

        $select = [];
        if($tipo_table == 'F'){
            $select = $query->where($this->tbl_orc_despesa->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->tbl_orc_despesa->getColunaAlias('periodo'))->get()->toArray();
        }
        
        if(count($select) > 0){
            return $select;
        }
        return true;
    }
    public function formataCod($cod, $max){
        // $max: o valor máximo do campo no Banco
        $tamanho = strlen($cod);
        $qtd = $max - $tamanho;
        for($i = 0; $i < $qtd; $i++){
            $cod = '0'.$cod;
        }
        return $cod;
    }
    public function possuiPermissaoLotacao($orc_id,$cod_lotacao){
        $decrypt = json_decode(safeDecrypt(request()->bearerToken()),true);
        if($decrypt['token']['tipo_user'] == 3){
            return true;
        }
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        $tbl_lotacao = new Lotacao();

        $select = $tbl_lotacao->select()->where('unid_lotac',$cod_lotacao)
        ->get()->toArray();
        for($i = 0; $i < count($lotacoes); $i++){
            if($select[0]['id'] == $lotacoes[$i]){
                return true;
            }
        }
        return false;
    }
    public function obtStatusOfOrc($orc_id){

        $tbl_orcamento = new Orcamento();
        $select = $tbl_orcamento->select()->where([
            ['id', '=', $orc_id],
            ['status_orc', '=', 6],
        ])->get()->toArray();

        return count($select) > 0 ? $select : null;
    }
    public function isMonetario(Array &$valores, $colunas){
        for($i = 0; $i < count($colunas); $i++){
            if(gettype($valores[$colunas[$i]]) == 'string'){
                monetarioVirgula($valores[$colunas[$i]]);
            }
        }
        return true;
    }
}
