<?php

namespace App\Modules\Natureza51\Repositories;

use App\Jobs\Integracao as JobsIntegracao;
use App\Modules\Natureza51\Entities\ExecucaoSp;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Integracao;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoIntegracao extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Integracao'; 
    protected $form_rules = [];
    protected $rules_msg = [];

    // @pendente bigint = 1, @reenviar bigint = 2, @enviado bigint = 3, @integrado bigint = 4,
    // @integrado_erro bigint = 5, @excluido bigint = 6, @erro bigint = 7;
    const PENDENTE = 1;
    const REENVIAR = 2;
    const ENVIADO = 3;
    const INTEGRADO = 4;
    const INTEGRADO_ERRO = 5;
    const EXCLUIDO = 6;
    const ERRO = 7;
    const INUTILIZADO = 8;

    public function listarIntegracao($layout = null, $periodo = 60){
        set_time_limit(700);
        $select = DB::select("SELECT integr.nome_layout, integr.status, integr.id as id_fila, integr.id_layout,
            CASE integr.status
                WHEN 1 THEN 'Pendente'
                WHEN 2 THEN 'Reenviar'
                WHEN 3 THEN 'Enviado'
                WHEN 4 THEN 'Integrado'
                WHEN 5 THEN 'Integrado com Erro'
                WHEN 6 THEN 'Excluído'
                WHEN 7 THEN 'Com Erro'
                WHEN 8 THEN 'Inutilizado'
                ELSE '-'
            END as des_status,
            SUBSTRING(integr.conteudo, 1, 1) as empresa,
            integr.conteudo,
            integr.created_at,
            integr.retorno,
            CASE
                WHEN integr.tp_movto = 1 THEN 'Inserção'
                WHEN integr.tp_movto = 2 THEN 'Atualização'
                ELSE '-'
                END as des_tp_movto,
            CASE --integr.cod_estabelecimento
                WHEN integr.cod_estabelecimento = '' THEN '-'
                WHEN integr.cod_estabelecimento IS NULL THEN '-'
                ELSE integr.cod_estabelecimento
                END as cod_estabelecimento,
            integr.retorno,
            format(integr.created_at, 'dd/MM/yyyy') as criado_em,
            CASE WHEN integr.updated_at IS NOT NULL THEN format(integr.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em
            FROM tbl_es_integracao as integr
        
            inner join tbl_layouts as lout on lout.id = integr.id_layout
            where integr.id_layout = $layout and (integr.created_at >= dateadd(day, -{$periodo}, GETDATE()) or
            integr.updated_at >= dateadd(day, -{$periodo}, GETDATE()))
        ");

        return $select;
    }

    public function listarLayouts(){
        set_time_limit(700);
        $select = DB::select("SELECT lt.* from tbl_layouts as lt
            inner join tbl_execucao_sp as esp on esp.id_layout = lt.id
            where fl_ativo = 1 order by esp.ordem_execucao asc
        ");
        return $select;
    }

    public function listarSequencia(){
        set_time_limit(700);
        $select = DB::select("SELECT sp.*, laout.desc_layout from tbl_execucao_sp as sp
        inner join tbl_layouts as laout on laout.id = sp.id_layout order by ordem_execucao asc");

        return $select;
    }

    public function reenviar($id_fila){
        // if($this->existeFila($id_layout) == false){
        //     $this->setError('Fila inexistente! Erro: 221020201336');
        //     return false;
        // }
        set_time_limit(700);
        try{
            $update = DB::update("UPDATE tbl_es_integracao set status = ?, retorno = ?, updated_at = ? where id = ?", [self::REENVIAR, 'sucesso', date('Y-m-d H:i:s'), $id_fila]);
            if($update === false){
                $this->setError('Falha ao atualizar Fila. Erro: 221020201337');
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->setError('Falha ao atualizar Fila. Erro: 221020201338ct '.$e);
            return false;
        }
        return true;
    }

    // public function existeFila($id_layout){
    //     $select = DB::select("SELECT * FROM tbl_es_integracao where id_layout = ?", [$id_layout]);

    //     return count($select) > 0 ? true : false;
    // }

    public function inutilizar($id_fila){
        // if($this->existeFila($id_layout) == false){
        //     $this->setError('Fila inexistente! Erro: 221020201348');
        //     return false;
        // }
        set_time_limit(700);
        try{
            $update = DB::update("UPDATE tbl_es_integracao set status = ?, retorno = ?, updated_at = ? where id = ?", [self::INUTILIZADO, 'sucesso', date('Y-m-d H:i:s'), $id_fila]);
            if($update === false){
                $this->setError('Falha ao atualizar Fila. Erro: 221020201413');
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->setError('Falha ao atualizar Fila. Erro: 221020201349');
            return false;
        }
        return true;
    }

    public function integrar($id_layout, $email, $nome){
        set_time_limit(700);
        $select = DB::select("SELECT * from tbl_layouts where desc_layout like('%uo') and id = {$id_layout}");

        if(count($select) > 0){
            $job = new JobsIntegracao($email, $nome, date("d-m-Y H:i:s"), $id_layout);
            dispatch($job);
            return 'uo';
        }
        try{
            $sql = "EXEC sp_ordena_execucao :layout_id";
            $stmt = DB::getPdo()->prepare($sql);

            $stmt->bindParam(':layout_id', $id_layout, \PDO::PARAM_INT );
            
            if(!$stmt->execute()){    
                $this->setError('Falha ao Integrar Fila. Erro: 221020201441');
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->setError('Falha ao Integrar Fila. Erro: 221020201442');
            return false;
        }
        return true;
    }

    public function updateSequencia($dados){
        // $execucao_sp = new ExecucaoSp();
        // $tudo = '';
        unset($dados['_token']);
        set_time_limit(700);
        try{
            foreach($dados as $value){
                $sql = "update tbl_execucao_sp set ordem_execucao = {$value['ordem_execucao']} where id = {$value['id']}";
                
                //$tudo = $tudo.' ||||||||||| '.$sql;
                $update = DB::update($sql);
                
                if($update === false){
                    $this->setError('Falha ao atualizar registro. Erro: 221020201527');
                    return false;
                }
                
            }
            //dd($tudo);
            return true;
        }
        catch(\Exception $e){
            //DB::rollBack();
            $this->setError('Falha ao atualizar registro. Erro: 221020201526 '.$e);
            return false;
        }
        return true;
    }

    public function executaIntegracoes($email_user, $nome){
        $inicio = date("d-m-Y H:i:s");
        $email_user = "matheus@insti.com.br";
        $job = new JobsIntegracao($email_user, $nome, $inicio);
        dispatch($job);
    }
}