<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoLotacaoStatusCalculo extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\LotacaoStatusCalculo';
    protected $form_rules=[];
    protected $rules_msg=[];  

    const STATUS_PENDENTE=1;
    const STATUS_CALCULANDO=2;
    const STATUS_CALCULADA=3;
    const STATUS_COM_ERRO=4;
    
    public function getStatusPendente(){
        return self::STATUS_PENDENTE;
    }
    public function getStatusCalculando(){
        return self::STATUS_CALCULANDO;
    }
    public function getStatusCalculada(){
        return self::STATUS_CALCULADA;
    }
    public function getStatusComErro(){
        return self::STATUS_COM_ERRO;
    }
    public function getStatusAndamento(){
        return [$this->getStatusPendente(),$this->getStatusCalculando()];
    }
    
    public function checkIsCalculando($orc_id){
        $existe = $this->getModelEntity()->where('orcamento_id', $orc_id)
        ->where('is_historico', 0)
        // ->where('status', '!=', $this->getStatusCalculada())
        ->whereIn('status', $this->getStatusAndamento())
        ->count();

        if(!$existe){
            return false;
        }
        return $existe > 0 ? true : false;

    }

}

