<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoMenu extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\Menu';
   protected $form_rules=[];

   protected $rules_msg=[]; 

   // public function update(array $data,$attribute="id"){      
      
   //    return parent::update($data,$attribute);
                                         
   // } 

   public function listar(){      
      $tbl_usuario = new Usuario();
      
      $result = $this->getModelEntity()
      ->leftJoin(
         DB::raw("{$tbl_usuario->getTable()} as usuario1"),
         DB::raw("usuario1.id"),
         DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
      )
      ->leftJoin(
         DB::raw("{$tbl_usuario->getTable()} as usuario2"),
         $this->getModelEntity()->getColunaAlias('updated_by'),
         DB::raw("usuario2.id")
      )
      ->select(
         DB::raw("institb_menu.*"),
         DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
         DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

         DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
         DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
      )
      ->get()
      ->toArray();

      return $result;
   }

   public function insert(Request $request){
      $form_data = $request->all();
      try{
         $form_data['status'] = 1;
         if(parent::create($form_data)){
            return true;
         }
         else{
            $this->setError("Falha ao inserir registro. Erro: 271020200823");
            return false;
         }
      }
      catch(\Exception $e){
         $this->setError('Falha ao inserir registro. Erro: 271020200821ct<br> '.$e);
         return false;
      }
   }

   public function updateMenu($dados){
      try{
         $data = Arr::except($dados, ['id']);
         
         $update = parent::update($data, $dados['id'], "id");
         
         if($update === false){
            $this->setError("Falha ao atualizar registro. Erro: 271020201007");
            return false;
         }
         return true;
      }
      catch(\Exception $e){
         $this->setError("Falha ao atualizar dados. Erro: 271020201005ct");
         return false;
      }
      return true;
   }
}
