<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Menu;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use DB;

class RepoMenuItem extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\MenuItem';
   protected $form_rules=[];

   protected $rules_msg=[]; 

   // public function update(array $data,$attribute="id"){      
      
   //    return parent::update($data,$attribute);                                         
   // } 
   
   public function listar(){

      $result = $this->getModelEntity()
      ->get()
      ->toArray();         
               
      return $result;
   }

   public function insert(Request $request){
      $form_data=$request->all();
            
      return parent::create($form_data);
      
   }

   public function listaItem(){
      $lista_item = $this->getModelEntity()::with([
          'getMenu'=>function($query){  
          }
      ])
      ->get()
      ->toArray();
    
      for ($i=0; $i < count($lista_item); $i++) {   
         // dd("passou", $lista_item[$i]['get_menu']);
          $lista_item[$i]['menu_tbl_id'] = $lista_item[$i]['get_menu']['id'];         
          $lista_item[$i]['menu'] = $lista_item[$i]['get_menu']['menu'];
          $lista_item[$i]['descricao'] = $lista_item[$i]['get_menu']['descricao'];
          $lista_item[$i]['status'] = $lista_item[$i]['get_menu']['status'];
          $lista_item[$i]['description']=$lista_item[$i]['get_menu']['menu'].' - '.$lista_item[$i]['get_menu']['descricao'];
          Arr::forget($lista_item[$i], 'get_menu');  
      }
      
      return $this->montaTreetable($lista_item);
  }

   public function montaTreetable($data){
      //dd("cvxcv",$data);
      $column_fixeds=[ 
          ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
          ["field_out"=>"label", "from"=>"label", "render_value"=>null,]  
      ];

      $column_fixeds_children=[ 
          ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
          ["field_out"=>"menu_id", "from"=>"menu_id", "render_value"=>null,],
          ["field_out"=>"parent_id", "from"=>"parent_id", "render_value"=>null,],
          ["field_out"=>"label", "from"=>"label", "render_value"=>null,],
          ["field_out"=>"tipo", "from"=>"tipo", "render_value"=>null,],
          ["field_out"=>"icone", "from"=>"icone", "render_value"=>null,],  
          ["field_out"=>"url_fragment", "from"=>"url_fragment", "render_value"=>null,],
          ["field_out"=>"url_base", "from"=>"url_base", "render_value"=>null,],
          ["field_out"=>"description", "from"=>"description", "render_value"=>null,]
          
      ];

      // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
      // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 

      
      $settings=["columns"=>$column_fixeds,
          "keys"=>['id','parent_id'],
          "filter_data"=>['parent_id'=>function($value){
                  return is_null($value);
              }    
          ],            
          "children"=>["columns"=>$column_fixeds_children,
                  "keys"=>['id', 'parent_id'],
                  "filter_data"=>['parent_id'=>function($value){
                      return !is_null($value);
                  }],
                  'parent_filter'=> function($value, $parent_data){ 
                      
                          $result=($value['id']== $parent_data['id'] &&
                             $value['parent_id']== $parent_data['parent_id']);
                          return $result;
                  },
                  // "children"=>["is_recursive"=>true]

              ]
          ];
               
      $controller=new AtmTreeTable($settings, $data);
      dd("treetable",['data'=>$controller->render()] );
      return ['data'=>$controller->render()]; 
      
  }
}
