<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorioOrcamento;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorioComparacao;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use DB;

class RepoModeloRelatorio extends RepositoryNat51
{
  protected $periodo = null;
  protected $agrupar_apenas_forecast = 0;
  protected $array_estruta_lotacao_orc = [];
  protected $array_meses = ['jan'=>'01','fev'=>'02','mar'=>'03','abr'=>'04','mai'=>'05','jun'=>'06',
                            'jul'=>'07','ago'=>'08','set'=>'09','out'=>'10','nov'=>'11','dez'=>'12'];
  protected $array_tipos_orcamento = ['Orc'=> 1,'Real'=> 2, 'Fcst'=> 3];
  protected $array_tipos_orcamento_completo = ['Orçado'=> 1,'Realizado'=> 2, 'Forecast'=> 3];
  protected $array_tipos_exibir = [1 => 'Mês a mês', 2 => 'Trimestre', 3 => 'Semestre', 4 => 'Ano'];
  protected $array_tipos_visualizacao = [1 => 'Individual', 2 => 'Acumulado'];
  protected $array_tipos = [1 => 'Valor', 2 => 'Headcount'];
  protected $array_campos = [
                          'jan'=> 'Janeiro','fev'=> 'Fevereiro','mar'=> 'Março','abr'=> 'Abril','mai'=> 'Maio','jun'=> 'Junho',
                          'jul'=> 'Julho','ago'=> 'Agosto','set'=> 'Setembro','out'=> 'Outubro','nov'=> 'Novembro','dez'=> 'Dezembro',
                          '1Trim'=> '1º Trimestre', '2Trim'=> '2º Trimestre', '3Trim'=> '3º Trimestre', '4Trim'=> '4º Trimestre',
                          '1Sem'=> '1º Semestre', '2Sem'=> '2º Semestre', 'ano'=> 'Ano inteiro'];
  protected $visibilidade_todos = 1;
  protected $visibilidade_criador = 2;
  protected $model_name_space='App\Modules\Natureza51\Entities\ModeloRelatorio';
  protected $form_rules=['nome'=>'required|string|max:80|min:1',
                           'tipo'=>'required|integer',
                           'tipo_exibir'=>'required|integer',
                           'nivel_agrupamento'=>'required|integer',
                           'visibilidade'=>'required|integer',
                           'tipo_visualizacao'=>'required|integer',
                        ];

  protected $rules_msg=['nome.required'=>'O campo nome é obrigatório',
                          'nome.max'=>'O campo nome aceita até 80 caracteres',
                          'tipo.required'=>'O campo tipo é obrigatório',
                          'tipo.integer'=>'Valor inválido no campo tipo',
                          'tipo_exibir.required'=>'O campo exibir é obrigatório',
                          'tipo_exibir.integer'=>'Valor inválido no campo exibir',
                          'nivel_agrupamento.required'=>'O campo nivel agrupamento é obrigatório',
                          'nivel_agrupamento.integer'=>'Valor inválido no campo nivel agrupamento',
                          'visibilidade.required'=>'O campo visibilidade é obrigatório',
                          'visibilidade.integer'=>'Valor inválido no campo visibilidade',
                          'tipo_visualizacao.required'=>'O campo tipo de visualização é obrigatório',
                          'tipo_visualizacao.integer'=>'Valor inválido no campo tipo visualização',
  ];
  
  private $tipo_exibir = null;
   
  public function listar($id = null){
    $user = $this->getUserFromCurrentGuard();
    if(!$user){
      $this->setError('Registro não encontrado!');
      return false;
    }
    
    $dados = $this->getModelEntity()->select('*', DB::raw("format(created_at, 'dd/MM/yyyy') AS criado_em"))
            ->with(['getModeloRelatorioOrcamento'=>function($query){
                      $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
                    }, 
                    'getModeloRelatorioComparacao'=>function($query){
                      $query->with([
                        'getModeloRelatorioOrcamentoOrigem'=>function($query){
                          $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
                        },
                        'getModeloRelatorioOrcamentoDestino'=>function($query){
                          $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
                        }
                      ]);
                    },
                    'criadoPor:id,nome'
                    ]);
    if(!is_null($id)){
      $dados = $dados->where([['created_by', $user->id], ['id', $id]])
      ->orWhere([['visibilidade', $this->getVisibilidadeTodos()],['id', $id]])
      ->get()->toArray();
    }else{
      $dados = $dados->where('created_by', $user->id)
      ->orWhere('visibilidade', $this->getVisibilidadeTodos())
      ->get()->toArray();
    }


    $retorno = [];
    foreach ($dados as $modelo) {

      $modelo['criado_por'] = $modelo['criado_por']['nome'];
      $modelo['orcamentos'] = [];
      foreach ($modelo['get_modelo_relatorio_orcamento'] as $orcamento) {
        $orcamento['descricao'] = $orcamento['get_orcamento']['descricao_orc'].' '.$orcamento['get_orcamento']['ano'].' Ver. '.$orcamento['get_orcamento']['versao_desc'].' Rev. '.$orcamento['get_orcamento']['revisao_desc'];
        $orcamento['des_tipo'] = array_search($orcamento['tipo'], $this->array_tipos_orcamento);
        unset($orcamento['get_orcamento']);
        array_push($modelo['orcamentos'], $orcamento);
      }
      unset($modelo['get_modelo_relatorio_orcamento']);

      $modelo['comparacoes'] = [];
      foreach ($modelo['get_modelo_relatorio_comparacao'] as $comparacao) {
        $comparacao['orc_origem_id'] = $comparacao['get_modelo_relatorio_orcamento_origem']['orcamento_id'];
        $comparacao['orc_destino_id'] = $comparacao['get_modelo_relatorio_orcamento_destino']['orcamento_id'];
        $comparacao['tipo_orc_origem'] = $comparacao['get_modelo_relatorio_orcamento_origem']['tipo'];
        $comparacao['tipo_orc_destino'] = $comparacao['get_modelo_relatorio_orcamento_destino']['tipo'];
        
        $comparacao['descricao_orcamento_origem'] = $comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento']['descricao_orc'].' '.$comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento']['ano'].' Ver. '.$comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento']['versao_desc'].' Rev. '.$comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento']['revisao_desc']. ' - '. array_search($comparacao['get_modelo_relatorio_orcamento_origem']['tipo'], $this->array_tipos_orcamento);
        $comparacao['descricao_orcamento_destino'] = $comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento']['descricao_orc'].' '.$comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento']['ano'].' Ver. '.$comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento']['versao_desc'].' Rev. '.$comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento']['revisao_desc']. ' - '. array_search($comparacao['get_modelo_relatorio_orcamento_destino']['tipo'], $this->array_tipos_orcamento);
        $comparacao['des_campo_comparar_origem'] = $this->array_campos[$comparacao['campo_comparar_origem']];
        $comparacao['des_campo_comparar_destino'] = $this->array_campos[$comparacao['campo_comparar_destino']];

        unset($comparacao['get_modelo_relatorio_orcamento_origem']);
        unset($comparacao['get_modelo_relatorio_orcamento_destino']);
        array_push($modelo['comparacoes'], $comparacao);
      }
      unset($modelo['get_modelo_relatorio_comparacao']);
      
      array_push($retorno, $modelo);
    }

    return $retorno;
  }

  public function getVisibilidadeTodos(){ return $this->visibilidade_todos; }
  public function getVisibilidadeCriador(){ return $this->visibilidade_criador; }
  
  public function getTotalRegistros($modelo_id, $lotacoes = [], $naturezas = []){      
    return $this->gerarRelatorio($modelo_id, true, NULL, NULL, $lotacoes, $naturezas);
  }

  public function getOrcamentosIdsFromModelo($modelo_id){
    $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
    $orcamentos = $repo_modelo_relatorio_orcamento->getModelEntity()->with('getOrcamento:id')->where('modelo_relatorio_id', $modelo_id)->get();
    if(!$orcamentos){
      $this->setError('Esse modelo não possui orçamentos selecionados.');
      return false;
    }
    $orcamentos = $orcamentos->toArray();
    $orcamentos = array_column($orcamentos, 'get_orcamento');
    $orcamentos_ids = array_column($orcamentos, 'id');
    return $orcamentos_ids;
  }
  
  public function gerarRelatorio($modelo_id, $just_quantidades = false, $offset = NULL, $rows = NULL, $lotacoes = [], $naturezas = [], $divisor = 1){
    $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
    $repo_modelo_relatorio_comparacao = new RepoModeloRelatorioComparacao();
    $modelo = $this->getModelEntity()->find($modelo_id);
    if(!$modelo){
      $this->setError('Não foi possível encontrar esse modelo.');
      return false;
    }

    $this->tipo_exibir = $modelo->tipo_exibir;
    $this->agrupar_apenas_forecast = $modelo->agrupar_apenas_forecast;

    $orcamentos = $repo_modelo_relatorio_orcamento->getModelEntity()->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc')->where('modelo_relatorio_id', $modelo_id)->orderBy('tipo')->get();
    if(!$orcamentos){
      $this->setError('Esse modelo não possui orçamentos selecionados.');
      return false;
    }
   
    $dados = [];
    $prefixos = [];
    $array_primary_keys = $this->getArrayPrimaryKeys($modelo->tipo, $modelo->nivel_agrupamento);
    $exibir_totalizado = $modelo->tipo_visualizacao == 2 ? true : false;
    $itens_filtrar = [];
    
    if(!$just_quantidades){
      if($modelo->nivel_agrupamento <= 3){
        $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValores($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcount($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 4){
        $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresLotacao($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountLotacao($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 5){
        $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresCentroCusto($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountCentroCusto($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 6){
        $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresCargo($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountCargo($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 7){
        if($modelo->tipo != 1){
          $this->setError('Não é possível gerar um relatório agrupado por Natureza para o Tipo Headcount.');
          return false;
        }
        $itens_filtrar = $this->getItensValoresNatureza($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado);
      }
    }
    
    foreach ($orcamentos as $orcamento){
      $this->periodo = $orcamento->periodo;
      $period_separator = $this->getTipoTable($orcamento->tipo) == "F" ? '_' : '';
      
      $nome_orcamento = str_replace(' ', '_', $orcamento->getOrcamento->descricao_orc);
      // $prefix = $orcamento->getOrcamento->ano.'_'.$orcamento->getOrcamento->versao_desc.'_'.$orcamento->getOrcamento->revisao_desc.'_'. array_search($orcamento->tipo, $this->array_tipos_orcamento);
      $prefix = $orcamento->getOrcamento->ano.'_'.$orcamento->getOrcamento->id.'_'. array_search($orcamento->tipo, $this->array_tipos_orcamento).$period_separator.$this->getPeriodoTexto($orcamento->orcamento_id, $this->getTipoTable($orcamento->tipo), false);
      array_push($prefixos, $prefix);
      // dd($modelo->tipo);
      


      if($modelo->nivel_agrupamento <= 3){
        $itens = $modelo->tipo == 1 ? $this->getValores($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcount($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 4){
        $itens = $modelo->tipo == 1 ? $this->getValoresLotacao($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountLotacao($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 5){
        $itens = $modelo->tipo == 1 ? $this->getValoresCentroCusto($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountCentroCusto($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 6){
        $itens = $modelo->tipo == 1 ? $this->getValoresCargo($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountCargo($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 7){
        if($modelo->tipo != 1){
          $this->setError('Não é possível gerar um relatório agrupado por Natureza para o Tipo Headcount.');
          return false;
        }
        $itens = $this->getValoresNatureza($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      
      foreach ($itens as $item) {
        $dados = $this->adcItemToArray($dados, $item, $array_primary_keys, $prefix);
      }
      unset($itens);
      // var_dump(count($dados). '  -  ');
      // dd('shdashdasdsa',$dados);
      
    }
    // dd($dados);

    if($just_quantidades){
      return count($dados);
    }

    for ($i=0; $i < count($dados); $i++) { 
      foreach ($prefixos as $prefix) {   
        if($modelo->tipo_exibir == 1){ //mes a mes
          $dados[$i][$prefix.'_jan'] = array_key_exists($prefix.'_jan', $dados[$i])     ? floatval($dados[$i][$prefix.'_jan']) : 0;
          $dados[$i][$prefix.'_fev'] = array_key_exists($prefix.'_fev', $dados[$i])     ? floatval($dados[$i][$prefix.'_fev']) : 0;
          $dados[$i][$prefix.'_mar'] = array_key_exists($prefix.'_mar', $dados[$i])     ? floatval($dados[$i][$prefix.'_mar']) : 0;
          $dados[$i][$prefix.'_abr'] = array_key_exists($prefix.'_abr', $dados[$i])     ? floatval($dados[$i][$prefix.'_abr']) : 0;
          $dados[$i][$prefix.'_mai'] = array_key_exists($prefix.'_mai', $dados[$i])     ? floatval($dados[$i][$prefix.'_mai']) : 0;
          $dados[$i][$prefix.'_jun'] = array_key_exists($prefix.'_jun', $dados[$i])     ? floatval($dados[$i][$prefix.'_jun']) : 0;
          $dados[$i][$prefix.'_jul'] = array_key_exists($prefix.'_jul', $dados[$i])     ? floatval($dados[$i][$prefix.'_jul']) : 0;
          $dados[$i][$prefix.'_ago'] = array_key_exists($prefix.'_ago', $dados[$i])     ? floatval($dados[$i][$prefix.'_ago']) : 0;
          $dados[$i][$prefix.'_set'] = array_key_exists($prefix.'_set', $dados[$i])     ? floatval($dados[$i][$prefix.'_set']) : 0;
          $dados[$i][$prefix.'_out'] = array_key_exists($prefix.'_out', $dados[$i])     ? floatval($dados[$i][$prefix.'_out']) : 0;
          $dados[$i][$prefix.'_nov'] = array_key_exists($prefix.'_nov', $dados[$i])     ? floatval($dados[$i][$prefix.'_nov']) : 0;
          $dados[$i][$prefix.'_dez'] = array_key_exists($prefix.'_dez', $dados[$i])     ? floatval($dados[$i][$prefix.'_dez']) : 0;	 
        } 
        else if($modelo->tipo_exibir == 2){ //trimestral
          $dados[$i][$prefix.'_1Trim'] = array_key_exists($prefix.'_1Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_1Trim']) : 0;      
          $dados[$i][$prefix.'_2Trim'] = array_key_exists($prefix.'_2Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_2Trim']) : 0;
          $dados[$i][$prefix.'_3Trim'] = array_key_exists($prefix.'_3Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_3Trim']) : 0;
          $dados[$i][$prefix.'_4Trim'] = array_key_exists($prefix.'_4Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_4Trim']) : 0;
        }
        else if($modelo->tipo_exibir == 3){ //semestral
          $dados[$i][$prefix.'_1Sem'] = array_key_exists($prefix.'_1Sem', $dados[$i])   ? floatval($dados[$i][$prefix.'_1Sem']) : 0;
          $dados[$i][$prefix.'_2Sem'] = array_key_exists($prefix.'_2Sem', $dados[$i])   ? floatval($dados[$i][$prefix.'_2Sem']) : 0;
        }
        $dados[$i][$prefix.'_ano'] = array_key_exists($prefix.'_ano', $dados[$i])     ? floatval($dados[$i][$prefix.'_ano']) : 0;
      }
      
    }

    $comparacoes = $repo_modelo_relatorio_comparacao->getModelEntity()->with([
      'getModeloRelatorioOrcamentoOrigem'=>function($query){
        return $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
      },
      'getModeloRelatorioOrcamentoDestino'=>function($query){
        return $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
      }
    ])->where('modelo_relatorio_id', $modelo_id)->get()->toArray();
    
    foreach ($comparacoes as $comparacao) {
      $orc_origem =  $comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento'];
      // $prefix_origem = str_replace(' ', '_', $orc_origem['ano'].'_'.$orc_origem['versao_desc'].'_'.$orc_origem['revisao_desc'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_origem']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_origem'];
      $prefix_origem = str_replace(' ', '_', $orc_origem['ano'].'_'.$orc_origem['id'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_origem']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_origem'];
      $orc_destino =  $comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento'];
      // $prefix_destino = str_replace(' ', '_', $orc_destino['ano'].'_'.$orc_destino['versao_desc'].'_'.$orc_destino['revisao_desc'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_destino']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_destino'];
      $prefix_destino = str_replace(' ', '_', $orc_destino['ano'].'_'.$orc_destino['id'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_destino']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_destino'];

      for ($i=0; $i < count($dados); $i++) { 
        $dados[$i][$prefix_origem. ' X '. $prefix_destino] = $dados[$i][$prefix_origem] - $dados[$i][$prefix_destino];
      }
    }

    return $dados;

  }

  public function adcItemToArray($array, $item, $array_primary_keys = ['unidade_lotacao'], $prefixo = ''){
    $new_item = [];
    $prefixo = $prefixo == '' ? '' : $prefixo.'_';

    $posicao_encontrada = array_filter($array, function($el)use($item, $array_primary_keys){
      foreach ($array_primary_keys as $pk) {
        if($el[$pk] != $item[$pk]){
          return false;
        }
      }
      return true;
    });    

    foreach ($item as $key => $value) {
      $key = in_array($key, $array_primary_keys) ? $key : $prefixo.$key;
      $new_item[$key] = $value;
    }
    unset($item);

    if(count($posicao_encontrada) > 0){
      $indexes = array_keys($posicao_encontrada);
      $index_encontrado = $indexes[0];
      // dd($array[$index_encontrado], $new_item);
      $array[$index_encontrado] = array_merge($array[$index_encontrado], $new_item);
      // dd('nsdjkafndjskfnjkdsfhbdjsfndskfsaKLDHFSAYUHFDSAKNJFSDIFSD48485145', $array[$index_encontrado]);
    }
    else{
      array_push($array, $new_item); 
    }

    return $array;
  }

  public function getDescMesFromDate($date){
    $date = explode('-', $date);
    if(count($date)<3){
      return '';
    }
    return array_search($date[1], $this->array_meses);
  }

  public function getPeriodoTexto($orc_id, $tipo_table, $data_format = true){
    $periodo = $this->getPeriodo($orc_id, $tipo_table);
    if($data_format){
      return is_null($periodo) ? '' : $periodo;
    }
    return is_null($periodo) ? '' : $this->getDescMesFromDate($periodo);
  }

  public function getPeriodo($orc_id, $tipo_table){
    if($tipo_table != 'F'){
      return null;
    }    
    if($this->periodo == 'ultimo' || is_null($this->periodo)){
      $ultimo_periodo = DB::select("select MAX(periodo) periodo from tbl_orc_lot_carg_headcount where orc_id = $orc_id and tipo_table = 'F'");
      if(count($ultimo_periodo)<=0){
        return null;  
      }
      $ultimo_periodo = $ultimo_periodo[0]->periodo;
      return $ultimo_periodo;
    }  
    if($this->periodo == 'anterior'){
      $ultimo_periodo = DB::select("select DATEADD (m , -1 , MAX(periodo) ) periodo from tbl_orc_lot_carg_headcount where orc_id = $orc_id and tipo_table = 'F'");
      if(count($ultimo_periodo)<=0){
        return null;  
      }
      $ultimo_periodo = $ultimo_periodo[0]->periodo;
      return $ultimo_periodo;
    }
    
    $ultimo_periodo = DB::select("select CAST(CONCAT(ano, '-', {$this->array_meses[$this->periodo]}, '-01')as date) periodo from tbl_orcamento where id = $orc_id");
    if(count($ultimo_periodo)<=0){
      return null;    
    }
    $ultimo_periodo = $ultimo_periodo[0]->periodo;
    return $ultimo_periodo;
  }

  public function getWherePeriodo($orc_id, $tipo_table){
    if($tipo_table != 'F'){
      return ' is null';
    }    
    if($this->periodo == 'ultimo' || is_null($this->periodo)){
      $ultimo_periodo = DB::select("select MAX(periodo) periodo from tbl_orc_lot_carg_headcount where orc_id = $orc_id and tipo_table = 'F'");

      if(count($ultimo_periodo)<=0){
        return ' is null';      
      }
      $ultimo_periodo = $ultimo_periodo[0]->periodo;
      return " = '$ultimo_periodo'";
    }  
    if($this->periodo == 'anterior'){
      $ultimo_periodo = DB::select("select DATEADD (m , -1 , MAX(periodo) ) periodo from tbl_orc_lot_carg_headcount where orc_id = $orc_id and tipo_table = 'F'");
      if(count($ultimo_periodo)<=0){
        return ' is null';      
      }
      $ultimo_periodo = $ultimo_periodo[0]->periodo;
      return " = '$ultimo_periodo'";
    }
    
    $ultimo_periodo = DB::select("select CAST(CONCAT(ano, '-', {$this->array_meses[$this->periodo]}, '-01')as date) periodo from tbl_orcamento where id = $orc_id");
    
    if(count($ultimo_periodo)<=0){
      return ' is null';      
    }
    $ultimo_periodo = $ultimo_periodo[0]->periodo;
    return " = '$ultimo_periodo'";

  }

  public function getItensValores($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves = [];

    $query = '';
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];      
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      
      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              res_calc.natureza_hash_id as natureza,
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_resultados_calc as res_calc
            join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). "  
            and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'
          ";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }

          if(count($naturezas) > 0){
            $naturezas_string = implode(",",array_column($naturezas, 'header'));
            $naturezas_string = str_replace(',', "','", $naturezas_string);
            $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
          }
  
          $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id";
        }

      }
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;
        // for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        // switch ($nivel_agrupamento) {
        //   case '1':
        //     $quantidade_zeros = '000000';
        //     $casas_unidade_lotacao = 2;
        //     break;
        //   case '2':
        //     $quantidade_zeros = '0000';
        //     $casas_unidade_lotacao = 4;
        //     break;
        //   case '3':
        //     $quantidade_zeros = '00';
        //     $casas_unidade_lotacao = 6;
        //     break;
        //   case '4':
        //     $quantidade_zeros = '';
        //     $casas_unidade_lotacao = 8;
        //     break;
        // }
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
        select 
          res_calc.natureza_hash_id as natureza,
          LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
        from tbl_orc_resultados_calc as res_calc
        join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
        join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
        join tbl_lotacao l on l.id = ol.lotacao_id
        where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
        AND l.id in ($lotacoes_string) /*and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'*/";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        if(count($naturezas) > 0){
          $naturezas_string = implode(",",array_column($naturezas, 'header'));
          $naturezas_string = str_replace(',', "','", $naturezas_string);
          $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id";
      // }  
      }    
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      // $query = $query." order by unidade_lotacao";
      $query = $query." order by LEFT(res.unidade_lotacao, $casas_unidade_lotacao), res.natureza
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }

    
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    // dd('asjkdsajkdnsjh', $result);

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getItensValoresLotacao($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves = [];

    $query = '';
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];      
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      
      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              res_calc.natureza_hash_id as natureza,
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao',
              cc.cod_ccusto as 'centro_custo'
            from tbl_orc_resultados_calc as res_calc
            join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = res_calc.ccusto_id
            where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). "  
            and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'
          ";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }

          if(count($naturezas) > 0){
            $naturezas_string = implode(",",array_column($naturezas, 'header'));
            $naturezas_string = str_replace(',', "','", $naturezas_string);
            $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
          }
  
          $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id, cc.cod_ccusto";
        }

      }
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;
        // for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        // switch ($nivel_agrupamento) {
        //   case '1':
        //     $quantidade_zeros = '000000';
        //     $casas_unidade_lotacao = 2;
        //     break;
        //   case '2':
        //     $quantidade_zeros = '0000';
        //     $casas_unidade_lotacao = 4;
        //     break;
        //   case '3':
        //     $quantidade_zeros = '00';
        //     $casas_unidade_lotacao = 6;
        //     break;
        //   case '4':
        //     $quantidade_zeros = '';
        //     $casas_unidade_lotacao = 8;
        //     break;
        // }
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
        select 
          res_calc.natureza_hash_id as natureza,
          LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao',
          cc.cod_ccusto as 'centro_custo'
        from tbl_orc_resultados_calc as res_calc
        join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
        join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
        join tbl_lotacao l on l.id = ol.lotacao_id
        join tbl_ccusto cc on cc.id = res_calc.ccusto_id
        where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
        AND l.id in ($lotacoes_string) /*and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'*/";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        if(count($naturezas) > 0){
          $naturezas_string = implode(",",array_column($naturezas, 'header'));
          $naturezas_string = str_replace(',', "','", $naturezas_string);
          $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id, cc.cod_ccusto";
      // }  
      }    
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      // $query = $query." order by unidade_lotacao";
      $query = $query." order by LEFT(res.unidade_lotacao, $casas_unidade_lotacao), res.natureza, res.centro_custo
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }

    
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    // dd('asjkdsajkdnsjh', $result);

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getItensValoresCentroCusto($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves = [];

    $query = '';
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];      
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      
      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              res_calc.natureza_hash_id as natureza,
              cc.cod_ccusto as 'centro_custo'
              --,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_resultados_calc as res_calc
            join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = res_calc.ccusto_id
            where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
            and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'
          ";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }

          if(count($naturezas) > 0){
            $naturezas_string = implode(",",array_column($naturezas, 'header'));
            $naturezas_string = str_replace(',', "','", $naturezas_string);
            $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
          }
  
          $query = $query."group by res_calc.natureza_hash_id, cc.cod_ccusto /*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
        }

      }
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;
        // for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        // switch ($nivel_agrupamento) {
        //   case '1':
        //     $quantidade_zeros = '000000';
        //     $casas_unidade_lotacao = 2;
        //     break;
        //   case '2':
        //     $quantidade_zeros = '0000';
        //     $casas_unidade_lotacao = 4;
        //     break;
        //   case '3':
        //     $quantidade_zeros = '00';
        //     $casas_unidade_lotacao = 6;
        //     break;
        //   case '4':
        //     $quantidade_zeros = '';
        //     $casas_unidade_lotacao = 8;
        //     break;
        // }
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
        select 
          res_calc.natureza_hash_id as natureza,
          cc.cod_ccusto as 'centro_custo'
          --,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
        from tbl_orc_resultados_calc as res_calc
        join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
        join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
        join tbl_lotacao l on l.id = ol.lotacao_id
        join tbl_ccusto cc on cc.id = res_calc.ccusto_id
        where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table'AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
        AND l.id in ($lotacoes_string) /*and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'*/";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        if(count($naturezas) > 0){
          $naturezas_string = implode(",",array_column($naturezas, 'header'));
          $naturezas_string = str_replace(',', "','", $naturezas_string);
          $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
        }

        $query = $query."group by res_calc.natureza_hash_id, cc.cod_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
      // }  
      }    
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      // $query = $query." order by unidade_lotacao";
      $query = $query." order by res.centro_custo/*, LEFT(res.unidade_lotacao, $casas_unidade_lotacao)*/
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }

    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    // dd('asjkdsajkdnsjh', $result);

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getItensValoresCargo($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves = [];

    $query = '';
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];      
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      
      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              cc.cod_ccusto as 'centro_custo',
              CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_resultados_calc as res_calc
            join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = res_calc.ccusto_id
            left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
            left join tbl_cargo c on c.id = oc.cargo_id
            where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
            and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'
          ";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }

          if(count($naturezas) > 0){
            $naturezas_string = implode(",",array_column($naturezas, 'header'));
            $naturezas_string = str_replace(',', "','", $naturezas_string);
            $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
          }
  
          $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";
        }

      }
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;
        // for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        // switch ($nivel_agrupamento) {
        //   case '1':
        //     $quantidade_zeros = '000000';
        //     $casas_unidade_lotacao = 2;
        //     break;
        //   case '2':
        //     $quantidade_zeros = '0000';
        //     $casas_unidade_lotacao = 4;
        //     break;
        //   case '3':
        //     $quantidade_zeros = '00';
        //     $casas_unidade_lotacao = 6;
        //     break;
        //   case '4':
        //     $quantidade_zeros = '';
        //     $casas_unidade_lotacao = 8;
        //     break;
        // }
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
        select 
          cc.cod_ccusto as 'centro_custo',
          CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
          LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
        from tbl_orc_resultados_calc as res_calc
        join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
        join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
        join tbl_lotacao l on l.id = ol.lotacao_id
        join tbl_ccusto cc on cc.id = res_calc.ccusto_id
        left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
        left join tbl_cargo c on c.id = oc.cargo_id
        where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table'AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
        AND l.id in ($lotacoes_string) /*and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'*/";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        if(count($naturezas) > 0){
          $naturezas_string = implode(",",array_column($naturezas, 'header'));
          $naturezas_string = str_replace(',', "','", $naturezas_string);
          $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";
      // }  
      }    
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      // $query = $query." order by unidade_lotacao";
      $query = $query." order by LEFT(res.unidade_lotacao, $casas_unidade_lotacao), res.centro_custo, res.cargo
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }

    
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    // dd('asjkdsajkdnsjh', $result);

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getItensValoresNatureza($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves = [];

    $query = '';
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];        
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
            
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;
      
      $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

      $query = $query."
      select 
        res_calc.natureza_hash_id 'natureza'
      from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      join tbl_ccusto cc on cc.id = res_calc.ccusto_id
      left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
      left join tbl_cargo c on c.id = oc.cargo_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
      AND l.id in ($lotacoes_string) /*and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'*/";
      
      if(count($lotacoes_filtro) > 0){
        $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
        $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
      }

      if(count($naturezas) > 0){
        $naturezas_string = implode(",",array_column($naturezas, 'header'));
        $naturezas_string = str_replace(',', "','", $naturezas_string);
        $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
      }

      $query = $query."group by res_calc.natureza_hash_id";
  
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      // $query = $query." order by unidade_lotacao";
      $query = $query." order by res.natureza
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }

    
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    // dd('asjkdsajkdnsjh', $result);

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getItensHeadcount($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves['unidade_lotacao'] = [];

    $query = '';
    
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];       
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      


      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){ 
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_lot_carg_headcount as hc
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
            AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }
  
          $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao)";
        }       
      }   
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;

        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
          select 
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
           AND l.id in ($lotacoes_string) ";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao)";

      }
      
      
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      $query = $query." order by unidade_lotacao 
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }
   
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);

    foreach ($result as $res) {
      if(count($chaves['unidade_lotacao']) >= $rows){
        return $chaves;
      }
      if(in_array($res['unidade_lotacao'], $chaves['unidade_lotacao'])){
        continue;
      }
      $chaves['unidade_lotacao'][] = $res['unidade_lotacao'];
    }
    
    return $chaves;
  }

  public function getItensHeadcountLotacao($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves['unidade_lotacao'] = [];

    $query = '';
    
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];       
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      


      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){ 
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              cc.cod_ccusto as 'centro_custo'
              ,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_lot_carg_headcount as hc
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = hc.ccusto_id
            where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
            AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }
  
          $query = $query."group by cc.cod_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao)";
        }       
      }   
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;

        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo'
            ,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " AND l.id in ($lotacoes_string) ";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        $query = $query."group by cc.cod_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao)";

      }
      
      
    }
    $query = $query." ) as res";
    

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      $query = $query." order by centro_custo, unidade_lotacao
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }
  
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);
    
    // foreach ($result as $res) {
    //   if(count($chaves['unidade_lotacao']) >= $rows){
    //     return $chaves;
    //   }
    //   if(in_array($res['unidade_lotacao'], $chaves['unidade_lotacao'])){
    //     continue;
    //   }
    //   $chaves['unidade_lotacao'][] = $res['unidade_lotacao'];
    // }
    $chaves = [];
    
    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;

  }

  public function getItensHeadcountCentroCusto($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    $chaves['unidade_lotacao'] = [];

    $query = '';
    
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];       
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      


      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){ 
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              cc.cod_ccusto as 'centro_custo'
              --,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_lot_carg_headcount as hc
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = hc.ccusto_id
            where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
            AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }
  
          $query = $query."group by cc.cod_ccusto--, LEFT(l.unid_lotac, $casas_unidade_lotacao)";
        }       
      }   
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;

        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo'
            --,LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " AND l.id in ($lotacoes_string) ";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        $query = $query."group by cc.cod_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";

      }
      
      
    }
    $query = $query." ) as res";
    

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      $query = $query." /*order by unidade_lotacao*/
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }
  
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);
    
    // foreach ($result as $res) {
    //   if(count($chaves['unidade_lotacao']) >= $rows){
    //     return $chaves;
    //   }
    //   if(in_array($res['unidade_lotacao'], $chaves['unidade_lotacao'])){
    //     continue;
    //   }
    //   $chaves['unidade_lotacao'][] = $res['unidade_lotacao'];
    // }
    $chaves = [];
    
    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;

  }

  public function getItensHeadcountCargo($orcamentos, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $exibir_totalizado = true){
    $array_orcs = $orcamentos->toArray();
    // $chaves['unidade_lotacao'] = [];
    $chaves = [];

    $query = '';
    
    foreach ($array_orcs as $orcamento) {
      $tipo_table = $this->getTipoTable($orcamento['tipo']);
      $orc_id = $orcamento['orcamento_id'];       
    
      if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
        $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
      }
      else{
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
        // dd($nivel_agrupamento);
    
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }
        $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
      }
      


      if($exibir_totalizado){
        for ($i=1; $i <= $nivel_agrupamento; $i++){ 
          switch ($i) {
            case '1':
              $quantidade_zeros = '000000';
              $casas_unidade_lotacao = 2;
              break;
            case '2':
              $quantidade_zeros = '0000';
              $casas_unidade_lotacao = 4;
              break;
            case '3':
              $quantidade_zeros = '00';
              $casas_unidade_lotacao = 6;
              break;
            case '4':
              $quantidade_zeros = '';
              $casas_unidade_lotacao = 8;
              break;
          }
  
          $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
  
          $query = $query."
            select 
              cc.cod_ccusto as 'centro_custo',
              CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
            from tbl_orc_lot_carg_headcount as hc
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = hc.ccusto_id
            join tbl_orc_cargo oc on oc.id  = hc.orc_cargo_id
            join tbl_cargo c on c.id = oc.cargo_id
            where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
          
          if(count($lotacoes_filtro) > 0){
            $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
            $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
          }
  
          $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";
        }       
      }   
      else{
        $quantidade_zeros = '';
        $casas_unidade_lotacao = 8;

        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";

        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo',
            CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          join tbl_orc_cargo oc on oc.id  = hc.orc_cargo_id
          join tbl_cargo c on c.id = oc.cargo_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). "  AND l.id in ($lotacoes_string) ";
        
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";

      }
      
      
    }

    $query = $query." ) as res";

    if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
      $query = $query." order by unidade_lotacao, centro_custo, cargo
      OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
    }
   
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);


    // foreach ($result as $res) {
    //   if(count($chaves['unidade_lotacao']) >= $rows){
    //     return $chaves;
    //   }
    //   if(in_array($res['unidade_lotacao'], $chaves['unidade_lotacao'])){
    //     continue;
    //   }
    //   $chaves['unidade_lotacao'][] = $res['unidade_lotacao'];
    // }

    

    if($just_quantidades){
      return $result;
    }
    foreach ($result as $res) {
      if(count($chaves) >= $rows){
        return $chaves;
      }
      foreach($chaves as $chave){
        if($chave == $res){
          goto proximoRegistro;
        }
      }
      $chaves[] = $res;
      proximoRegistro:
      continue;
    }
    return $chaves;
  }

  public function getValores($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);
     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    
    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        

        $query = $query."
          select 
          REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
                LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
                (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                $colunas_Select
                (SUM(
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
              )/$divisor) as 'ano'
              from tbl_orc_resultados_calc as res_calc
          join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          where res_calc.orcamento_id = $orc_id and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). "  AND l.id in ($lotacoes_string) and RIGHT(LEFT(l.unid_lotac, $casas_unidade_lotacao),2) <> '00'
        ";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( res_calc.natureza_hash_id = '".$item_filtro['natureza']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }
        else{
          if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
            $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
          }
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id";
      }

      $query = $query." ) as res";

      if(count($itens_filtrar) == 0){
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." order by unidade_lotacao 
          OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }    
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;
      // switch ($nivel_agrupamento) {
      //   case '1':
      //     $quantidade_zeros = '000000';
      //     $casas_unidade_lotacao = 2;
      //     break;
      //   case '2':
      //     $quantidade_zeros = '0000';
      //     $casas_unidade_lotacao = 4;
      //     break;
      //   case '3':
      //     $quantidade_zeros = '00';
      //     $casas_unidade_lotacao = 6;
      //     break;
      //   case '4':
      //     $quantidade_zeros = '';
      //     $casas_unidade_lotacao = 8;
      //     break;
      // }
      $query = "
      select 
        REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
              (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              $colunas_Select
              (SUM(
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
              )/$divisor) as 'ano'
            from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " ";

      if(count($lotacoes_filtro) > 0){
        $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
        $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
      }

      if(count($naturezas) > 0){
        $naturezas_string = implode(",",array_column($naturezas, 'header'));
        $naturezas_string = str_replace(',', "','", $naturezas_string);
        $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
      }
      // dd($itens_filtrar);
      if(count($itens_filtrar) > 0){
        $query = $query." AND ( ";
        $cont = 0;
        foreach ($itens_filtrar as $item_filtro) {
          $query = $query."( res_calc.natureza_hash_id = '".$item_filtro['natureza']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
          $cont++;
          if($cont < count($itens_filtrar)){
            $query = $query." OR ";
          }
        }
        $query = $query." )";
        
        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id
        order by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id";
      }
      else{        
        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id
        order by LEFT(l.unid_lotac, $casas_unidade_lotacao), res_calc.natureza_hash_id";
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }
      }

    }

      
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result;

  }

  public function getValoresLotacao($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);
     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    

    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    
    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
                LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
                (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                cc.cod_ccusto as 'centro_custo',
                cc.des_ccusto as 'descricao_centro_custo',
                cta_ctbl.cod_cta_ctbl as 'cta_ctbl',
                cta_ctbl.desc_cta_ctbl as natureza,
                --REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
                --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                $colunas_Select
                (SUM(
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
              )/$divisor) as 'ano'
              from tbl_orc_resultados_calc as res_calc
          join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = res_calc.ccusto_id
          join tbl_cta_contabil cta_ctbl on cta_ctbl.id = res_calc.ccontabil_id
          where res_calc.orcamento_id = $orc_id and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(l.unid_lotac, $casas_unidade_lotacao),2) <> '00'
        ";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( res_calc.natureza_hash_id = '".$item_filtro['natureza']."' AND cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }
        


        else{
          if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
            $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
          }
        }

        $query = $query."group by cta_ctbl.cod_cta_ctbl, res_calc.natureza_hash_id, cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac";
      }

      $query = $query." ) as res";

      if(count($itens_filtrar) == 0){
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." order by unidade_lotacao, lotacao
          OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }    
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;
      // switch ($nivel_agrupamento) {
      //   case '1':
      //     $quantidade_zeros = '000000';
      //     $casas_unidade_lotacao = 2;
      //     break;
      //   case '2':
      //     $quantidade_zeros = '0000';
      //     $casas_unidade_lotacao = 4;
      //     break;
      //   case '3':
      //     $quantidade_zeros = '00';
      //     $casas_unidade_lotacao = 6;
      //     break;
      //   case '4':
      //     $quantidade_zeros = '';
      //     $casas_unidade_lotacao = 8;
      //     break;
      // }
      $query = "
      select 
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
              (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              cc.cod_ccusto as 'centro_custo',
              cc.des_ccusto as 'descricao_centro_custo',
              cta_ctbl.cod_cta_ctbl as 'cta_ctbl',
              cta_ctbl.desc_cta_ctbl as natureza,
              --REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
              --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              $colunas_Select
              (SUM(
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
            )/$divisor) as 'ano'
            from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      join tbl_ccusto cc on cc.id = res_calc.ccusto_id
      join tbl_cta_contabil cta_ctbl on cta_ctbl.id = res_calc.ccontabil_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " ";

      if(count($lotacoes_filtro) > 0){
        $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
        $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
      }

      if(count($naturezas) > 0){
        $naturezas_string = implode(",",array_column($naturezas, 'header'));
        $naturezas_string = str_replace(',', "','", $naturezas_string);
        $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
      }
      
      if(count($itens_filtrar) > 0){
        $query = $query." AND ( ";
        $cont = 0;
        foreach ($itens_filtrar as $item_filtro) {
          $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND  res_calc.natureza_hash_id = '".$item_filtro['natureza']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
          $cont++;
          if($cont < count($itens_filtrar)){
            $query = $query." OR ";
          }
        }
        $query = $query." )";
        
        $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac
        order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac";
      }
      else{        
        $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac
        order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac";
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }
      }

    }
    
      
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result;

  }

  public function getValoresCentroCusto($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);
     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    

    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    
    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
                cc.cod_ccusto as 'centro_custo',
                cc.des_ccusto as 'descricao_centro_custo',
                cta_ctbl.cod_cta_ctbl as 'cta_ctbl',
                cta_ctbl.desc_cta_ctbl as natureza,
                --REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
                --LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
                --(select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                $colunas_Select
                (SUM(
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
              )/$divisor) as 'ano'
              from tbl_orc_resultados_calc as res_calc
          join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = res_calc.ccusto_id
          join tbl_cta_contabil cta_ctbl on cta_ctbl.id = res_calc.ccontabil_id
          where res_calc.orcamento_id = $orc_id and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(l.unid_lotac, $casas_unidade_lotacao),2) <> '00'
        ";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( res_calc.natureza_hash_id = '".$item_filtro['natureza']."' AND cc.cod_ccusto = '".$item_filtro['centro_custo']."' /*AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."*/)";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }
        


        else{
          if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
            $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
          }
        }

        $query = $query."group by cta_ctbl.cod_cta_ctbl, res_calc.natureza_hash_id, cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
      }

      $query = $query." ) as res";

      if(count($itens_filtrar) == 0){
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." /*order by unidade_lotacao */
          OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }    
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;
      // switch ($nivel_agrupamento) {
      //   case '1':
      //     $quantidade_zeros = '000000';
      //     $casas_unidade_lotacao = 2;
      //     break;
      //   case '2':
      //     $quantidade_zeros = '0000';
      //     $casas_unidade_lotacao = 4;
      //     break;
      //   case '3':
      //     $quantidade_zeros = '00';
      //     $casas_unidade_lotacao = 6;
      //     break;
      //   case '4':
      //     $quantidade_zeros = '';
      //     $casas_unidade_lotacao = 8;
      //     break;
      // }
      $query = "
      select 
              cc.cod_ccusto as 'centro_custo',
              cc.des_ccusto as 'descricao_centro_custo',
              cta_ctbl.cod_cta_ctbl as 'cta_ctbl',
              cta_ctbl.desc_cta_ctbl as natureza,
              --REPLACE(res_calc.natureza_hash_id, '_', ' ') as natureza,
              --LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
              --(select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              $colunas_Select
              (SUM(
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
            )/$divisor) as 'ano'
            from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      join tbl_ccusto cc on cc.id = res_calc.ccusto_id
      join tbl_cta_contabil cta_ctbl on cta_ctbl.id = res_calc.ccontabil_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " ";

      if(count($lotacoes_filtro) > 0){
        $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
        $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
      }

      if(count($naturezas) > 0){
        $naturezas_string = implode(",",array_column($naturezas, 'header'));
        $naturezas_string = str_replace(',', "','", $naturezas_string);
        $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
      }
      
      if(count($itens_filtrar) > 0){
        $query = $query." AND ( ";
        $cont = 0;
        foreach ($itens_filtrar as $item_filtro) {
          $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND  res_calc.natureza_hash_id = '".$item_filtro['natureza']."')";///* AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."*/)";
          $cont++;
          if($cont < count($itens_filtrar)){
            $query = $query." OR ";
          }
        }
        $query = $query." )";
        
        $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/
        order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
      }
      else{        
        $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/
        order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl, cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }
      }

    }
    
      
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result;

  }

  public function getValoresCargo($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);
     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    
    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    
    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
                cc.cod_ccusto as 'centro_custo',
                c.cod_cargo_basic as 'cod_cargo',
                c.des_cargo_basic as 'cargo',
                --CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
                LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
                (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                $colunas_Select
                (SUM(
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                  IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
              )/$divisor) as 'ano'
              from tbl_orc_resultados_calc as res_calc
          join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = res_calc.ccusto_id
          left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
          left join tbl_cargo c on c.id = oc.cargo_id
          where res_calc.orcamento_id = $orc_id and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). "  
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(l.unid_lotac, $casas_unidade_lotacao),2) <> '00'
        ";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
            AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }
        else{
          if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
            $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
          }
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";
      }

      $query = $query." ) as res";

      if(count($itens_filtrar) == 0){
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." order by unidade_lotacao, c.cod_cargo_basic
          OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }    
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;
      // switch ($nivel_agrupamento) {
      //   case '1':
      //     $quantidade_zeros = '000000';
      //     $casas_unidade_lotacao = 2;
      //     break;
      //   case '2':
      //     $quantidade_zeros = '0000';
      //     $casas_unidade_lotacao = 4;
      //     break;
      //   case '3':
      //     $quantidade_zeros = '00';
      //     $casas_unidade_lotacao = 6;
      //     break;
      //   case '4':
      //     $quantidade_zeros = '';
      //     $casas_unidade_lotacao = 8;
      //     break;
      // }
      $query = "
      select 
              cc.cod_ccusto as 'centro_custo',
              c.cod_cargo_basic as 'cod_cargo',
              c.des_cargo_basic as 'cargo',
              --CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
              LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
              (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
                --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
              $colunas_Select
              (SUM(
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
                IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
            )/$divisor) as 'ano'
            from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      join tbl_ccusto cc on cc.id = res_calc.ccusto_id
      left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
      left join tbl_cargo c on c.id = oc.cargo_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table'
      AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " ";

      if(count($lotacoes_filtro) > 0){
        $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
        $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
      }

      if(count($naturezas) > 0){
        $naturezas_string = implode(",",array_column($naturezas, 'header'));
        $naturezas_string = str_replace(',', "','", $naturezas_string);
        $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
      }
      
      if(count($itens_filtrar) > 0){
        $query = $query." AND ( ";
        $cont = 0;
        foreach ($itens_filtrar as $item_filtro) {
          $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
            AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";
             $cont++;
          if($cont < count($itens_filtrar)){
            $query = $query." OR ";
          }
        }
        $query = $query." )";
        
        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic
        order by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic";
      }
      else{        
        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic
        order by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic";
        if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
          $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
        }
      }

    }

      
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result;

  }

  public function getValoresNatureza($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $naturezas, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);
     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }
    
    
    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    $query = '';
    
    $quantidade_zeros = '';
    $casas_unidade_lotacao = 8;
    
    $query = "
    select 
    
      cta_ctbl.cod_cta_ctbl as 'cta_ctbl',
      cta_ctbl.desc_cta_ctbl as natureza,
      --res_calc.natureza_hash_id as 'natureza',
      $colunas_Select
      (SUM(
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(res_calc.jan_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(res_calc.fev_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(res_calc.mar_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(res_calc.abr_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(res_calc.mai_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(res_calc.jun_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(res_calc.jul_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(res_calc.ago_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(res_calc.set_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(res_calc.out_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(res_calc.nov_val_total,0), 0) + 
        IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(res_calc.dez_val_total,0), 0)
    )/$divisor) as 'ano'
    from tbl_orc_resultados_calc as res_calc
    join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
    join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
    join tbl_lotacao l on l.id = ol.lotacao_id
    join tbl_ccusto cc on cc.id = res_calc.ccusto_id
    left join tbl_orc_cargo oc on oc.id  = res_calc.orc_cargo_id
    left join tbl_cargo c on c.id = oc.cargo_id
    join tbl_cta_contabil cta_ctbl on cta_ctbl.id = res_calc.ccontabil_id
    where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table'
    AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " ";

    if(count($lotacoes_filtro) > 0){
      $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
      $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
    }

    if(count($naturezas) > 0){
      $naturezas_string = implode(",",array_column($naturezas, 'header'));
      $naturezas_string = str_replace(',', "','", $naturezas_string);
      $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
    }
    
    if(count($itens_filtrar) > 0){
      $query = $query." AND ( ";
      $cont = 0;
      foreach ($itens_filtrar as $item_filtro) {
        $query = $query."( res_calc.natureza_hash_id = '".$item_filtro['natureza']."' )";
            $cont++;
        if($cont < count($itens_filtrar)){
          $query = $query." OR ";
        }
      }
      $query = $query." )";
      
      $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl
      order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl";
    }
    else{        
      $query = $query."group by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl
      order by cta_ctbl.cod_cta_ctbl, cta_ctbl.desc_cta_ctbl";
      if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
        $query = $query." OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
      }
    }


      
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result;

  }

  public function getHeadcount($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0))/$divisor) as int) as 'jan',
          CAST((SUM(ISNULL(co.fev_orcado,0))/$divisor) as int) as 'fev',
          CAST((SUM(ISNULL(co.mar_orcado,0))/$divisor) as int) as 'mar',
          CAST((SUM(ISNULL(co.abr_orcado,0))/$divisor) as int) as 'abr',
          CAST((SUM(ISNULL(co.mai_orcado,0))/$divisor) as int) as 'mai',
          CAST((SUM(ISNULL(co.jun_orcado,0))/$divisor) as int) as 'jun',
          CAST((SUM(ISNULL(co.jul_orcado,0))/$divisor) as int) as 'jul',
          CAST((SUM(ISNULL(co.ago_orcado,0))/$divisor) as int) as 'ago',
          CAST((SUM(ISNULL(co.set_orcado,0))/$divisor) as int) as 'set',
          CAST((SUM(ISNULL(co.out_orcado,0))/$divisor) as int) as 'out',
          CAST((SUM(ISNULL(co.nov_orcado,0))/$divisor) as int) as 'nov',
          CAST((SUM(ISNULL(co.dez_orcado,0))/$divisor) as int) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0))/$divisor) as int) as '1Trim',
          CAST((SUM(ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '2Trim',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0))/$divisor) as int) as '3Trim',
          CAST((SUM(ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '1Sem',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            --(SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0) + ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as 'ano'
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $itens_filtro_string = '';
          $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
          if(count($itens_filtrar['unidade_lotacao']) > 0){
            $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
          } 
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao)";
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;

      $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
                        CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string)";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $itens_filtro_string = '';
          $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
          if(count($itens_filtrar['unidade_lotacao']) > 0){
            $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
          } 
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao)";

    }
    $query = $query." ) as res";

    if(count($itens_filtrar) == 0){
      if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
        $query = $query." order by unidade_lotacao 
        OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
      }    
    }
    $result = DB::select($query);


    $result = json_decode(json_encode($result), true);
    // dd($result);
    return $result;

  }

  public function getHeadcountLotacao($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }


    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0))/$divisor) as int) as 'jan',
          CAST((SUM(ISNULL(co.fev_orcado,0))/$divisor) as int) as 'fev',
          CAST((SUM(ISNULL(co.mar_orcado,0))/$divisor) as int) as 'mar',
          CAST((SUM(ISNULL(co.abr_orcado,0))/$divisor) as int) as 'abr',
          CAST((SUM(ISNULL(co.mai_orcado,0))/$divisor) as int) as 'mai',
          CAST((SUM(ISNULL(co.jun_orcado,0))/$divisor) as int) as 'jun',
          CAST((SUM(ISNULL(co.jul_orcado,0))/$divisor) as int) as 'jul',
          CAST((SUM(ISNULL(co.ago_orcado,0))/$divisor) as int) as 'ago',
          CAST((SUM(ISNULL(co.set_orcado,0))/$divisor) as int) as 'set',
          CAST((SUM(ISNULL(co.out_orcado,0))/$divisor) as int) as 'out',
          CAST((SUM(ISNULL(co.nov_orcado,0))/$divisor) as int) as 'nov',
          CAST((SUM(ISNULL(co.dez_orcado,0))/$divisor) as int) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0))/$divisor) as int) as '1Trim',
          CAST((SUM(ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '2Trim',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0))/$divisor) as int) as '3Trim',
          CAST((SUM(ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '1Sem',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            cc.cod_ccusto as 'centro_custo',
            cc.des_ccusto as 'descricao_centro_custo',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";

        //     $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
        //     AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";

        //   } 
        // }
        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac";
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;

      $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            cc.cod_ccusto as 'centro_custo',
            cc.des_ccusto as 'descricao_centro_custo',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string)";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
        //   } 
        // }
        
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by cc.cod_ccusto, cc.des_ccusto, LEFT(l.unid_lotac, $casas_unidade_lotacao), l.des_unid_lotac";

    }
    $query = $query." ) as res";

    if(count($itens_filtrar) == 0){
      if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
        $query = $query." order by centro_custo, descricao_centro_custo, unidade_lotacao, lotacao
        OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
      }    
    }
    // dd($query);
    $result = DB::select($query);


    $result = json_decode(json_encode($result), true);
    // dd($query);
    return $result;

  }

  public function getHeadcountCentroCusto($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }


    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0))/$divisor) as int) as 'jan',
          CAST((SUM(ISNULL(co.fev_orcado,0))/$divisor) as int) as 'fev',
          CAST((SUM(ISNULL(co.mar_orcado,0))/$divisor) as int) as 'mar',
          CAST((SUM(ISNULL(co.abr_orcado,0))/$divisor) as int) as 'abr',
          CAST((SUM(ISNULL(co.mai_orcado,0))/$divisor) as int) as 'mai',
          CAST((SUM(ISNULL(co.jun_orcado,0))/$divisor) as int) as 'jun',
          CAST((SUM(ISNULL(co.jul_orcado,0))/$divisor) as int) as 'jul',
          CAST((SUM(ISNULL(co.ago_orcado,0))/$divisor) as int) as 'ago',
          CAST((SUM(ISNULL(co.set_orcado,0))/$divisor) as int) as 'set',
          CAST((SUM(ISNULL(co.out_orcado,0))/$divisor) as int) as 'out',
          CAST((SUM(ISNULL(co.nov_orcado,0))/$divisor) as int) as 'nov',
          CAST((SUM(ISNULL(co.dez_orcado,0))/$divisor) as int) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0))/$divisor) as int) as '1Trim',
          CAST((SUM(ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '2Trim',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0))/$divisor) as int) as '3Trim',
          CAST((SUM(ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '1Sem',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo',
            cc.des_ccusto as 'descricao_centro_custo',
            --LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            --(select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";

        //     $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
        //     AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";

        //   } 
        // }
        // dd($itens_filtrar);
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;

      $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo',
            cc.des_ccusto as 'descricao_centro_custo',
            --LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            --(select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string)";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
        //   } 
        // }
        
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao'].")";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by cc.cod_ccusto, cc.des_ccusto/*, LEFT(l.unid_lotac, $casas_unidade_lotacao)*/";

    }
    $query = $query." ) as res";

    if(count($itens_filtrar) == 0){
      if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
        $query = $query." order by cc.cod_ccusto, cc.des_ccusto/*, unidade_lotacao*/
        OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
      }    
    }
    // dd($query);
    $result = DB::select($query);


    $result = json_decode(json_encode($result), true);
    // dd($query);
    return $result;

  }

  public function getHeadcountCargo($orcamento, $nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes_filtro, $itens_filtrar = [], $divisor, $exibir_totalizado = true){
    $orc_id = $orcamento->orcamento_id;
    $tipo_table = $this->getTipoTable($orcamento->tipo);     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    
    switch ($this->tipo_exibir) {
      case '1':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0))/$divisor) as int) as 'jan',
          CAST((SUM(ISNULL(co.fev_orcado,0))/$divisor) as int) as 'fev',
          CAST((SUM(ISNULL(co.mar_orcado,0))/$divisor) as int) as 'mar',
          CAST((SUM(ISNULL(co.abr_orcado,0))/$divisor) as int) as 'abr',
          CAST((SUM(ISNULL(co.mai_orcado,0))/$divisor) as int) as 'mai',
          CAST((SUM(ISNULL(co.jun_orcado,0))/$divisor) as int) as 'jun',
          CAST((SUM(ISNULL(co.jul_orcado,0))/$divisor) as int) as 'jul',
          CAST((SUM(ISNULL(co.ago_orcado,0))/$divisor) as int) as 'ago',
          CAST((SUM(ISNULL(co.set_orcado,0))/$divisor) as int) as 'set',
          CAST((SUM(ISNULL(co.out_orcado,0))/$divisor) as int) as 'out',
          CAST((SUM(ISNULL(co.nov_orcado,0))/$divisor) as int) as 'nov',
          CAST((SUM(ISNULL(co.dez_orcado,0))/$divisor) as int) as 'dez',
        ";
        break;
      case '2':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0))/$divisor) as int) as '1Trim',
          CAST((SUM(ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '2Trim',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0))/$divisor) as int) as '3Trim',
          CAST((SUM(ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '4Trim',
        ";        
        break;
      case '3':
        $colunas_Select = "
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '1Sem',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '2Sem',
        ";        
        break;
      case '4':
        $colunas_Select = "";        
        break;
    }

    $query = '';
    if($exibir_totalizado){
      for ($i=1; $i <= $nivel_agrupamento; $i++){ 
        switch ($i) {
          case '1':
            $quantidade_zeros = '000000';
            $casas_unidade_lotacao = 2;
            break;
          case '2':
            $quantidade_zeros = '0000';
            $casas_unidade_lotacao = 4;
            break;
          case '3':
            $quantidade_zeros = '00';
            $casas_unidade_lotacao = 6;
            break;
          case '4':
            $quantidade_zeros = '';
            $casas_unidade_lotacao = 8;
            break;
        }
      
        $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo',            
            c.cod_cargo_basic as 'cod_cargo',
            c.des_cargo_basic as 'cargo',
            --CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          join tbl_orc_cargo oc on oc.id  = hc.orc_cargo_id
          join tbl_cargo c on c.id = oc.cargo_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string) and RIGHT(LEFT(unid_lotac, $casas_unidade_lotacao),2) <> '00'";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
        //   } 
        // }
        
        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
            AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto";
      }
    }
    else{
      $quantidade_zeros = '';
      $casas_unidade_lotacao = 8;

      $query = $query == '' ? $query. "SELECT * FROM ( " : $query." UNION ";
        
        $query = $query."
          select 
            cc.cod_ccusto as 'centro_custo',                       
            c.cod_cargo_basic as 'cod_cargo',
            c.des_cargo_basic as 'cargo',
            --CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
            LEFT(l.unid_lotac, $casas_unidade_lotacao) as 'unidade_lotacao', 
            (select SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac )) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            --(select CONCAT(unid_lotac, ' - ', SUBSTRING(des_unid_lotac, 0, PATINDEX ( '%-%' , des_unid_lotac ))) from tbl_lotacao where unid_lotac = CONCAT(LEFT(l.unid_lotac, $casas_unidade_lotacao),'$quantidade_zeros')) as 'lotacao',
            $colunas_Select
            CAST((SUM(
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 1 , ISNULL(co.jan_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 2 , ISNULL(co.fev_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 3 , ISNULL(co.mar_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 4 , ISNULL(co.abr_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 5 , ISNULL(co.mai_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 6 , ISNULL(co.jun_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 7 , ISNULL(co.jul_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 8 , ISNULL(co.ago_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 9 , ISNULL(co.set_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 10, ISNULL(co.out_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 11, ISNULL(co.nov_orcado,0), 0) + 
              IIF(".$this->getMesIniConsiderarForecast($orc_id, $tipo_table)." <= 12, ISNULL(co.dez_orcado,0), 0)
          )/$divisor) as int) as 'ano'
          from tbl_orc_lot_carg_headcount as hc
          join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
          join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
          join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
          join tbl_lotacao l on l.id = ol.lotacao_id
          join tbl_ccusto cc on cc.id = hc.ccusto_id
          join tbl_orc_cargo oc on oc.id  = hc.orc_cargo_id
          join tbl_cargo c on c.id = oc.cargo_id
          where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
          AND l.id in ($lotacoes_string)";
      
        if(count($lotacoes_filtro) > 0){
          $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
          $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
        }

        // dd($itens_filtrar);
        // if(count($itens_filtrar) > 0){
        //   $itens_filtro_string = '';
        //   $itens_filtro_string = implode("','",$itens_filtrar['unidade_lotacao']);       
        //   if(count($itens_filtrar['unidade_lotacao']) > 0){
        //     $query = $query." AND LEFT(l.unid_lotac, $casas_unidade_lotacao) in ('$itens_filtro_string')";
        //   } 
        // }

        if(count($itens_filtrar) > 0){
          $query = $query." AND ( ";
          $cont = 0;
          foreach ($itens_filtrar as $item_filtro) {
            // dd($itens_filtrar);
            $query = $query."( cc.cod_ccusto = '".$item_filtro['centro_custo']."' AND LEFT(l.unid_lotac, $casas_unidade_lotacao) = ".$item_filtro['unidade_lotacao']."
            AND CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) = '".$item_filtro['cargo']."')";
            $cont++;
            if($cont < count($itens_filtrar)){
              $query = $query." OR ";
            }
          }
          $query = $query." )";
        }

        $query = $query."group by LEFT(l.unid_lotac, $casas_unidade_lotacao), cc.cod_ccusto, c.cod_cargo_basic, c.des_cargo_basic";

    }
    $query = $query." ) as res";

    if(count($itens_filtrar) == 0){
      if(!$just_quantidades && !is_null($offset) && !is_null($rows) ){
        $query = $query." order by unidade_lotacao, cc.cod_ccusto 
        OFFSET $offset ROWS FETCH NEXT $rows ROWS ONLY";
      }    
    }
    
    $result = DB::select($query);


    $result = json_decode(json_encode($result), true);
    // dd($result);
    return $result;

  }
  
  public function getModeloInfo($modelo_id){
    $modelo = $this->getModelEntity()->find($modelo_id);
    if(!$modelo){
      $this->setError('Não foi possível encontrar esse modelo.');
      return false;
    }
    $modelo = $modelo->toArray();
    $modelo['des_tipo_exibir'] = $this->array_tipos_exibir[$modelo['tipo_exibir']];
    $modelo['filter_columns'] = [
      'values' => $this->getValuesFromTipoExibir($modelo['tipo_exibir']),
      'fixeds' => $this->getArrayPrimaryKeys($modelo['tipo'], $modelo['nivel_agrupamento']),
      'tamanho' => $this->getTamanhoFromTipoExibir($modelo['tipo_exibir'])
    ];
    return $modelo;
  }

  public function getModeloColumns($modelo_id){
    $modelo = $this->getModelEntity()->find($modelo_id);
    if(!$modelo){
      $this->setError('Não foi possível encontrar esse modelo.');
      return false;
    }
    $modelo = $modelo->toArray();
    return $this->getValuesFromTipoExibir($modelo['tipo_exibir']);
  }

  public function getValuesFromTipoExibir($tipo_exibir){
    $array_values = [
      '1'=>['jan','fev','mar','abr','mai','jun','jul','ago','set','out','nov','dez'],
      '2'=>['1Trim', '2Trim', '3Trim', '4Trim'],
      '3'=>['1Sem', '2Sem'],
      '4'=>['ano']
    ];
    return $array_values[$tipo_exibir];
  }

  public function getTamanhoFromTipoExibir($tipo_exibir){
    $array_tamanhos = [
      '1'=>3,
      '2'=>5,
      '3'=>4,
      '4'=>3
    ];
    return $array_tamanhos[$tipo_exibir];
  }

  public function getArrayPrimaryKeys($tipo, $nivel_agrupamento){
    if($nivel_agrupamento <= 3){
      return $tipo == 1 ? ['natureza', 'lotacao', 'unidade_lotacao'] : ['lotacao', 'unidade_lotacao'];
    }
    if($nivel_agrupamento == 4){
      return $tipo == 1 ? ['natureza', 'cta_ctbl', 'lotacao', 'unidade_lotacao', 'centro_custo', 'descricao_centro_custo'] : ['lotacao', 'unidade_lotacao', 'centro_custo', 'descricao_centro_custo'];
    }
    else if($nivel_agrupamento == 5){
      return $tipo == 1 ? ['natureza', 'cta_ctbl', 'centro_custo', 'descricao_centro_custo'/*, 'unidade_lotacao', 'lotacao'*/] : ['centro_custo', 'descricao_centro_custo'/*, 'unidade_lotacao', 'lotacao'*/];
    }
    else if($nivel_agrupamento == 6){
      return ['centro_custo', 'cargo', 'cod_cargo', 'unidade_lotacao', 'lotacao'];
    }
    else if($nivel_agrupamento == 7){
      return ['natureza', 'cta_ctbl'];
    }
    
  }

  public function getDataChart($modelo_id, $lotacoes, $naturezas, $divisor = 1){
    $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();

    $modelo = $this->getModelEntity()->find($modelo_id);
    if(!$modelo){
      $this->setError('Não foi possível encontrar esse modelo.');
      return false;
    }

    $orcamentos = $repo_modelo_relatorio_orcamento->getModelEntity()->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc')->where('modelo_relatorio_id', $modelo_id)->get();
    if(!$orcamentos){
      $this->setError('Esse modelo não possui orçamentos selecionados.');
      return false;
    }

    $data_chart = [];
    foreach ($orcamentos as $orcamento){    
      $this->periodo = $orcamento->periodo;
      $nome_orcamento = str_replace(' ', '_', $orcamento->getOrcamento->descricao_orc);
      $prefix = $orcamento->getOrcamento->ano.' '.$orcamento->getOrcamento->versao_desc.' '.$orcamento->getOrcamento->revisao_desc.' '. array_search($orcamento->tipo, $this->array_tipos_orcamento).'_'.$this->getPeriodoTexto($orcamento->orcamento_id, $this->getTipoTable($orcamento->tipo), false);
            
      $aux = [
        'label'=>$prefix,
        'data'=>[]
      ];
      
      $data = $modelo->tipo == 1 ? array_values($this->getValoresGrafico($orcamento, $modelo->tipo_exibir, $lotacoes, $naturezas, $divisor)) : array_values($this->getHeadcountGrafico($orcamento, $modelo->tipo_exibir, $lotacoes, $divisor));
      $data = array_map(function($value){
        return is_null($value) ? 0 : floatVal($value);
      }, $data);
      $aux['data'] = $data;
      array_push($data_chart, $aux);
    }

    return $data_chart;
  }

  public function getValoresGrafico($orcamento, $tipo_exibir, $lotacoes_filtro, $naturezas, $divisor){
    
    $orc_id = $orcamento->orcamento_id;
    if($orcamento->tipo == 1){
      $tipo_table = 'O';
    }
    else if ($orcamento->tipo == 2){
      $tipo_table = 'R';
    }
    else if ($orcamento->tipo == 3){
      $tipo_table = 'F';
    }     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    $query = "
    select ";

    switch ($tipo_exibir) {
      case '1':
        $query = $query."
          (SUM(ISNULL(res_calc.jan_val_total,0))/$divisor) as 'jan',
          (SUM(ISNULL(res_calc.fev_val_total,0))/$divisor) as 'fev',
          (SUM(ISNULL(res_calc.mar_val_total,0))/$divisor) as 'mar',
          (SUM(ISNULL(res_calc.abr_val_total,0))/$divisor) as 'abr',
          (SUM(ISNULL(res_calc.mai_val_total,0))/$divisor) as 'mai',
          (SUM(ISNULL(res_calc.jun_val_total,0))/$divisor) as 'jun',
          (SUM(ISNULL(res_calc.jul_val_total,0))/$divisor) as 'jul',
          (SUM(ISNULL(res_calc.ago_val_total,0))/$divisor) as 'ago',
          (SUM(ISNULL(res_calc.set_val_total,0))/$divisor) as 'set',
          (SUM(ISNULL(res_calc.out_val_total,0))/$divisor) as 'out',
          (SUM(ISNULL(res_calc.nov_val_total,0))/$divisor) as 'nov',
          (SUM(ISNULL(res_calc.dez_val_total,0))/$divisor) as 'dez'
        ";
        break;      
      case '2':
        $query = $query."          
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0))/$divisor) as '1Trim',
          (SUM(ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '2Trim',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0))/$divisor) as '3Trim',
          (SUM(ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '4Trim'
        ";
        break;     
      case '3':
        $query = $query."
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0))/$divisor) as '1Sem',
          (SUM(ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as '2Sem'
        ";
        break;     
      case '4':
        $query = $query."
          (SUM(ISNULL(res_calc.jan_val_total,0) + ISNULL(res_calc.fev_val_total,0) + ISNULL(res_calc.mar_val_total,0) + ISNULL(res_calc.abr_val_total,0) + ISNULL(res_calc.mai_val_total,0) + ISNULL(res_calc.jun_val_total,0) + ISNULL(res_calc.jul_val_total,0) + ISNULL(res_calc.ago_val_total,0) + ISNULL(res_calc.set_val_total,0) + ISNULL(res_calc.out_val_total,0) + ISNULL(res_calc.nov_val_total,0) + ISNULL(res_calc.dez_val_total,0))/$divisor) as 'ano'
        ";
        break;
    }

    $query = $query."
      from tbl_orc_resultados_calc as res_calc
      join tbl_orc_lotacao ol on ol.id = res_calc.orc_lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      where res_calc.orcamento_id = $orc_id AND l.id in ($lotacoes_string) and res_calc.tipo_table = '$tipo_table' AND res_calc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
    ";

    if(count($lotacoes_filtro) > 0){
      $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
      $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
    }

    if(count($naturezas) > 0){
      $naturezas_string = implode(",",array_column($naturezas, 'header'));
      $naturezas_string = str_replace(',', "','", $naturezas_string);
      $query = $query." AND res_calc.natureza_hash_id in ('$naturezas_string')";
    }
    
    $result = DB::select($query);
    
    $result = json_decode(json_encode($result), true);
    
    return $result[0];

  }

  public function getHeadcountGrafico($orcamento, $tipo_exibir, $lotacoes_filtro, $divisor){

    $orc_id = $orcamento->orcamento_id;
    if($orcamento->tipo == 1){
      $tipo_table = 'O';
    }
    else if ($orcamento->tipo == 2){
      $tipo_table = 'R';
    }
    else if ($orcamento->tipo == 3){
      $tipo_table = 'F';
    }     
    
    if(array_key_exists($orc_id.$this->getPeriodoTexto($orc_id, $tipo_table), $this->array_estruta_lotacao_orc)){
      $lotacoes_string = $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)];
    }
    else{
      $tbl_orc_lotacao_controller = new OrcLotacaoController();

      $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $this->getPeriodo($orc_id, $tipo_table), $tipo_table);
      // dd($nivel_agrupamento);
  
      $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
      if(!$lotacoes){
          $lotacoes_string = '0';
      }
      else{
          $lotacoes_string = implode(",",$lotacoes);
      }
      $this->array_estruta_lotacao_orc[$orc_id.$this->getPeriodoTexto($orc_id, $tipo_table)] = $lotacoes_string;      
    }

    $query = "
      select 
    ";

    switch ($tipo_exibir) {
      case '1':
        $query = $query."
          CAST((SUM(ISNULL(co.jan_orcado,0))/$divisor) as int) as 'jan',
          CAST((SUM(ISNULL(co.fev_orcado,0))/$divisor) as int) as 'fev',
          CAST((SUM(ISNULL(co.mar_orcado,0))/$divisor) as int) as 'mar',
          CAST((SUM(ISNULL(co.abr_orcado,0))/$divisor) as int) as 'abr',
          CAST((SUM(ISNULL(co.mai_orcado,0))/$divisor) as int) as 'mai',
          CAST((SUM(ISNULL(co.jun_orcado,0))/$divisor) as int) as 'jun',
          CAST((SUM(ISNULL(co.jul_orcado,0))/$divisor) as int) as 'jul',
          CAST((SUM(ISNULL(co.ago_orcado,0))/$divisor) as int) as 'ago',
          CAST((SUM(ISNULL(co.set_orcado,0))/$divisor) as int) as 'set',
          CAST((SUM(ISNULL(co.out_orcado,0))/$divisor) as int) as 'out',
          CAST((SUM(ISNULL(co.nov_orcado,0))/$divisor) as int) as 'nov',
          CAST((SUM(ISNULL(co.dez_orcado,0))/$divisor) as int) as 'dez'
        ";
        break;      
      case '2':
        $query = $query."   
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0))/$divisor) as int) as '1Trim',
          CAST((SUM(ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '2Trim',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0))/$divisor) as int) as '3Trim',
          CAST((SUM(ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '4Trim'
        ";
        break;     
      case '3':
        $query = $query."
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0))/$divisor) as int) as '1Sem',
          CAST((SUM(ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as '2Sem'
        ";
        break;     
      case '4':
        $query = $query."
          CAST((SUM(ISNULL(co.jan_orcado,0) + ISNULL(co.fev_orcado,0) + ISNULL(co.mar_orcado,0) + ISNULL(co.abr_orcado,0) + ISNULL(co.mai_orcado,0) + ISNULL(co.jun_orcado,0) + ISNULL(co.jul_orcado,0) + ISNULL(co.ago_orcado,0) + ISNULL(co.set_orcado,0) + ISNULL(co.out_orcado,0) + ISNULL(co.nov_orcado,0) + ISNULL(co.dez_orcado,0))/$divisor) as int) as 'ano'
        ";
        break;
    }

    $query = $query."        
      from tbl_orc_lot_carg_headcount as hc
      join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
      join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
      join tbl_orc_lotacao ol_orc on ol_orc.lotacao_id = ol.lotacao_id and ol_orc.tipo_table = 'O' and ol_orc.cc_custo_id = ol.cc_custo_id and ol_orc.orcamento_id = hc.orc_id
      join tbl_lotacao l on l.id = ol.lotacao_id
      where hc.orc_id = $orc_id and hc.tipo_table = '$tipo_table' AND hc.periodo ".$this->getWherePeriodo($orc_id, $tipo_table). " 
      AND l.id in ($lotacoes_string)
    ";
    
    if(count($lotacoes_filtro) > 0){
      $lotacoes_filtro_string = implode(",",array_column($lotacoes_filtro, 'id'));
      $query = $query." AND ol_orc.id in ($lotacoes_filtro_string)";
    }

    
    $result = DB::select($query);

    $result = json_decode(json_encode($result), true);
    
    return $result[0];

  }

  public function getTipoTable($tipo_orc){
    if($tipo_orc == 1){
      return 'O';
    }
    else if ($tipo_orc == 2){
      return 'R';
    }
    else if ($tipo_orc == 3){
      return 'F';
    }
    return false;
  }

  public function gerarRelatorioFormat($modelo_id, $just_quantidades = false, $offset = NULL, $rows = NULL, $lotacoes = [], $naturezas = [], $divisor = 1){
    $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
    $repo_modelo_relatorio_comparacao = new RepoModeloRelatorioComparacao();
    $modelo = $this->getModelEntity()->find($modelo_id);
    if(!$modelo){
      $this->setError('Não foi possível encontrar esse modelo.');
      return false;
    }
    $this->tipo_exibir = $modelo->tipo_exibir;
    $this->agrupar_apenas_forecast = $modelo->agrupar_apenas_forecast;
    $orcamentos = $repo_modelo_relatorio_orcamento->getModelEntity()->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc')->where('modelo_relatorio_id', $modelo_id)->orderBy('tipo')->get();
    if(!$orcamentos){
      $this->setError('Esse modelo não possui orçamentos selecionados.');
      return false;
    }

    $dados = [];
    $prefixos = [];
    $array_primary_keys = $this->getArrayPrimaryKeys($modelo->tipo, $modelo->nivel_agrupamento);
    $itens_filtrar = [];
    $exibir_totalizado = $modelo->tipo_visualizacao == 2 ? true : false;

    if($modelo->nivel_agrupamento <= 3){
      $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValores($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcount($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
    }else if($modelo->nivel_agrupamento == 4){
      $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresLotacao($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountLotacao($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
    }else if($modelo->nivel_agrupamento == 5){
      $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresCentroCusto($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountCentroCusto($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
    }else if($modelo->nivel_agrupamento == 6){
      $itens_filtrar = $modelo->tipo == 1 ? $this->getItensValoresCargo($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado) : $this->getItensHeadcountCargo($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $exibir_totalizado);
    }else if($modelo->nivel_agrupamento == 7){
      if($modelo->tipo != 1){
        $this->setError('Não é possível gerar um relatório agrupado por Natureza para o Tipo Headcount.');
        return false;
      }
      $itens_filtrar = $this->getItensValoresNatureza($orcamentos, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $exibir_totalizado);
    }

    foreach ($orcamentos as $orcamento){      
      $this->periodo = $orcamento->periodo;
      
      $nome_orcamento = str_replace(' ', '_', $orcamento->getOrcamento->descricao_orc);
      // $prefix = $orcamento->getOrcamento->ano.'_'.$orcamento->getOrcamento->versao_desc.'_'.$orcamento->getOrcamento->revisao_desc.'_'. array_search($orcamento->tipo, $this->array_tipos_orcamento);
      $prefix = $orcamento->getOrcamento->ano.'_'.$orcamento->getOrcamento->id.'_'. array_search($orcamento->tipo, $this->array_tipos_orcamento).'_'.$this->getPeriodoTexto($orcamento->orcamento_id, $this->getTipoTable($orcamento->tipo), false);
      array_push($prefixos, $prefix);
      // dd($modelo->tipo);
      // $itens = $modelo->tipo == 1 ? $this->getValores($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcount($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      // dd('acasdsa');      
      
      if($modelo->nivel_agrupamento <= 3){
        $itens = $modelo->tipo == 1 ? $this->getValores($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcount($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 4){
        $itens = $modelo->tipo == 1 ? $this->getValoresLotacao($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountLotacao($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 5){
        $itens = $modelo->tipo == 1 ? $this->getValoresCentroCusto($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountCentroCusto($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }
      else if($modelo->nivel_agrupamento == 6){
        $itens = $modelo->tipo == 1 ? $this->getValoresCargo($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado) : $this->getHeadcountCargo($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $itens_filtrar, $divisor, $exibir_totalizado);
      }else if($modelo->nivel_agrupamento == 7){
        if($modelo->tipo != 1){
          $this->setError('Não é possível gerar um relatório agrupado por Natureza para o Tipo Headcount.');
          return false;
        }
        $itens = $this->getValoresNatureza($orcamento, $modelo->nivel_agrupamento, $offset, $rows, $just_quantidades, $lotacoes, $naturezas, $itens_filtrar, $divisor, $exibir_totalizado);
      }

      foreach ($itens as $item) {        
        
        $dados = $this->adcItemToArray($dados, $item, $array_primary_keys, $prefix);
      }
      unset($itens);
      // var_dump(count($dados). '  -  ');
      
    }
    // dd($dados);
    if($just_quantidades){
      return count($dados);
    }    
    

    for ($i=0; $i < count($dados); $i++) {       
      foreach ($prefixos as $prefix) {     
        
        // if(strpos( $prefix, 'Real')){
        //   dd($dados[$i]);
        // }
        if($modelo->tipo_exibir == 1){ //mes a mes  
          $dados[$i][$prefix.'_jan'] = array_key_exists($prefix.'_jan', $dados[$i])     ? floatval($dados[$i][$prefix.'_jan']) : 0;
          $dados[$i][$prefix.'_fev'] = array_key_exists($prefix.'_fev', $dados[$i])     ? floatval($dados[$i][$prefix.'_fev']) : 0;
          $dados[$i][$prefix.'_mar'] = array_key_exists($prefix.'_mar', $dados[$i])     ? floatval($dados[$i][$prefix.'_mar']) : 0;
          $dados[$i][$prefix.'_abr'] = array_key_exists($prefix.'_abr', $dados[$i])     ? floatval($dados[$i][$prefix.'_abr']) : 0;
          $dados[$i][$prefix.'_mai'] = array_key_exists($prefix.'_mai', $dados[$i])     ? floatval($dados[$i][$prefix.'_mai']) : 0;
          $dados[$i][$prefix.'_jun'] = array_key_exists($prefix.'_jun', $dados[$i])     ? floatval($dados[$i][$prefix.'_jun']) : 0;
          $dados[$i][$prefix.'_jul'] = array_key_exists($prefix.'_jul', $dados[$i])     ? floatval($dados[$i][$prefix.'_jul']) : 0;
          $dados[$i][$prefix.'_ago'] = array_key_exists($prefix.'_ago', $dados[$i])     ? floatval($dados[$i][$prefix.'_ago']) : 0;
          $dados[$i][$prefix.'_set'] = array_key_exists($prefix.'_set', $dados[$i])     ? floatval($dados[$i][$prefix.'_set']) : 0;
          $dados[$i][$prefix.'_out'] = array_key_exists($prefix.'_out', $dados[$i])     ? floatval($dados[$i][$prefix.'_out']) : 0;
          $dados[$i][$prefix.'_nov'] = array_key_exists($prefix.'_nov', $dados[$i])     ? floatval($dados[$i][$prefix.'_nov']) : 0;
          $dados[$i][$prefix.'_dez'] = array_key_exists($prefix.'_dez', $dados[$i])     ? floatval($dados[$i][$prefix.'_dez']) : 0;	

        }
        else if($modelo->tipo_exibir == 2){ //trimestre
          $dados[$i][$prefix.'_1Trim'] = array_key_exists($prefix.'_1Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_1Trim']) : 0;      
          $dados[$i][$prefix.'_2Trim'] = array_key_exists($prefix.'_2Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_2Trim']) : 0;
          $dados[$i][$prefix.'_3Trim'] = array_key_exists($prefix.'_3Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_3Trim']) : 0;
          $dados[$i][$prefix.'_4Trim'] = array_key_exists($prefix.'_4Trim', $dados[$i]) ? floatval($dados[$i][$prefix.'_4Trim']) : 0;
        }
        else if ($modelo->tipo_exibir == 3){ //semestre
          $dados[$i][$prefix.'_1Sem'] = array_key_exists($prefix.'_1Sem', $dados[$i])   ? floatval($dados[$i][$prefix.'_1Sem']) : 0;
          $dados[$i][$prefix.'_2Sem'] = array_key_exists($prefix.'_2Sem', $dados[$i])   ? floatval($dados[$i][$prefix.'_2Sem']) : 0;
        }
        $dados[$i][$prefix.'_ano'] = array_key_exists($prefix.'_ano', $dados[$i])     ? floatval($dados[$i][$prefix.'_ano']) : 0;
        
      }
      
    }


    $comparacoes = $repo_modelo_relatorio_comparacao->getModelEntity()->with([
      'getModeloRelatorioOrcamentoOrigem'=>function($query){
        return $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
      },
      'getModeloRelatorioOrcamentoDestino'=>function($query){
        return $query->with('getOrcamento:id,descricao_orc,ano,versao_desc,revisao_desc');
      }
    ])->where('modelo_relatorio_id', $modelo_id)->get()->toArray();
    
    foreach ($comparacoes as $comparacao) {
      $orc_origem =  $comparacao['get_modelo_relatorio_orcamento_origem']['get_orcamento'];
      // $prefix_origem = str_replace(' ', '_', $orc_origem['ano'].'_'.$orc_origem['versao_desc'].'_'.$orc_origem['revisao_desc'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_origem']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_origem'];
      $prefix_origem = str_replace(' ', '_', $orc_origem['ano'].'_'.$orc_origem['id'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_origem']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_origem'];
      $orc_destino =  $comparacao['get_modelo_relatorio_orcamento_destino']['get_orcamento'];
      // $prefix_destino = str_replace(' ', '_', $orc_destino['ano'].'_'.$orc_destino['versao_desc'].'_'.$orc_destino['revisao_desc'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_destino']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_destino'];
      $prefix_destino = str_replace(' ', '_', $orc_destino['ano'].'_'.$orc_destino['id'].'_'.array_search($comparacao['get_modelo_relatorio_orcamento_destino']['tipo'], $this->array_tipos_orcamento)).'_'.$comparacao['campo_comparar_destino'];


      for ($i=0; $i < count($dados); $i++) { 
        $dados[$i][$prefix_origem. ' X '. $prefix_destino] = $dados[$i][$prefix_origem] - $dados[$i][$prefix_destino];
      }
    }
    
    $functions_format = [
      1=> function ($val){
        return number_format($val, 8, ',', '.');
      },
      2=> function ($val){
        return number_format($val, 0, '', '.');
      }
    ];

    $result = [];
    foreach ($dados as $dado) {
      
      foreach ($dado as $key => $value) {
        if(!in_array($key, $array_primary_keys)){
          $dado[$key] = $functions_format[$modelo->tipo]($value);
          // $dado[$key] = number_format($value, 8, ',', '.');
        }        
      }
      array_push($result, $dado);
    }
    
    return $result;

  }

  public function getMesIniConsiderarForecast($orc_id, $tipo_table){
    if($tipo_table != 'F'){
      return 1;
    }
    if($this->agrupar_apenas_forecast == 0){
      return 1;
    }
    return  (int) $this->array_meses[$this->getDescMesFromDate($this->getPeriodo($orc_id, $tipo_table))];
  }

}
