<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoModeloRelatorioComparacao extends RepositoryNat51
{
  protected $model_name_space='App\Modules\Natureza51\Entities\ModeloRelatorioComparacao';
  protected $form_rules=['campo_comparar_origem'=>'required|string|max:15|min:1',
                          'campo_comparar_destino'=>'required|string|max:15|min:1'                         
                        ];

  protected $rules_msg=['campo_comparar_origem.required'=>'O campo comparar origem é obrigatório',
                          'campo_comparar_origem.max'=>'Valor inválido para o campo comparar origem',
                          'campo_comparar_destino.required'=>'O campo comparar destino é obrigatório',
                          'campo_comparar_destino.max'=>'Valor inválido para o campo comparar destino'
                        ]; 
  
  public function deleteFromModeloRelatorio($modelo_relatorio_id) {

    try{
      $this->getModelInstance()->where('modelo_relatorio_id', $modelo_relatorio_id)->delete();
        
        goto saida;
    }
    catch(Exception $e){
        $this->setError("Registro não pode ser excluido. error: 220920201122");
        return false;    
        
    }
    
    saida:
    return true;
}

   
}
