<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Modulos;
use App\Modules\Natureza51\Entities\PermissoesTag;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoModuloPermissoes extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\ModuloPermissoes';
    protected $form_rules=[
        'modulo_id'=>'required',
        'tag_id'=>'required'
    ];

    protected $rules_msg=[
        'modulo_id.required'=>'O campo Módulo não pode estar vazio',
        'tag_id.required'=>'O campo Tag não pode estar vazio'
    ];  

    public function listarAll(){
        $tbl_modulo = new Modulos();
        $tbl_permissoes = new PermissoesTag();
        $tbl_usuario = new Usuario();

        $select = $this->getModelEntity()->
        leftJoin($tbl_modulo->getTable(), $this->getModelEntity()->getColunaAlias('modulo_id'), $tbl_modulo->getColunaAlias('id'))->
        leftJoin($tbl_permissoes->getTable(), $this->getModelEntity()->getColunaAlias('tag_id'), $tbl_permissoes->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(

            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('modulo_id'),
            $this->getModelEntity()->getColunaAlias('tag_id'),
            $tbl_modulo->getColunaAlias('modulo'),
            DB::raw("{$tbl_modulo->getColunaAlias('descricao')} as descricao_modulo"),
            $tbl_permissoes->getColunaAlias('tag'),
            $tbl_permissoes->getColunaAlias('descricao'),
            $tbl_permissoes->getColunaAlias('status'),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->orderBy('id','asc')
        ->get()->toArray();

        $data = [];

        for($i=0;$i<count($select);$i++){
            $data[$i]=array_merge($select[$i],array("description_modulo"=>$select[$i]['modulo'].' - '.$select[$i]['descricao_modulo']));
            $data[$i]=array_merge($data[$i],array("description_tags"=>$select[$i]['tag'].' - '.$select[$i]['descricao']));
        }

        return $data;
    }
    public function inserir($data){
        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('modulo_id'),'=',$data['modulo_id']],
            [$this->getModelEntity()->getColunaAlias('tag_id'),'=',$data['tag_id']]
        ])->get()->toArray();
        
        // if(count($select)>0){
        //     $this->setError('Registro já cadastrado. Erro:160420201503');
        //     return false;
        // }
        // else{
            $inserir = $this->create($data);
            if(!$inserir){
                $this->setError('Falha ao inserir registro. Erro:160420201505');
                return false;
            }
            return true;
        // }
    }
    public function updateModuloP($data){
        $select = $this->getModelEntity()->select()
        ->where([
            [$this->getModelEntity()->getColunaAlias('tag_id'),'=',$data['tag_id']],
            [$this->getModelEntity()->getColunaAlias('modulo_id'),'=',$data['modulo_id']]
        ])->get()->toArray();
        
        if(count($select) > 0){
            $this->setError('Registro já existente.');
            return false;
        }
        $resultado = $this->update($data,$data['id']);
        if(!$resultado){
            $this->setError('Falha ao atualizar registro. <br>Erro:170420200940');
            return false;
        }
        return true;
    }
}