<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoModulos extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Modulos';
    protected $form_rules=['modulo'=>'required|string|max:150|min:1',
                           'descricao'=>'required|string|max:500:min:1',
                           'status'=>'required'
                        ];

    protected $rules_msg=['modulo.required'=>'O campo Módulo é obrigatório',
                          'modulo.max'=>'O campo Módulo aceita até 150 caracteres',
                          'status.required'=>'O campo status é obrigatório',        
                          'descricao.required'=>'O campo Descrição é obrigatório',
                          'descricao.max'=>'O campo Descrição aceita até 500 caracteres',
                        ];  

    public function updateModulo($data,$id,$attribute){
      
      $dados = Arr::except($data,['id']);
      return $this->update($dados, $id, $attribute);
    }
    public function listarAll(){
      $tbl_usuario = new Usuario();
      
      $select = $this->getModelEntity()
      ->leftJoin(
        DB::raw("{$tbl_usuario->getTable()} as usuario1"),
        DB::raw("usuario1.id"),
        DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
      )
      ->leftJoin(
        DB::raw("{$tbl_usuario->getTable()} as usuario2"),
        $this->getModelEntity()->getColunaAlias('updated_by'),
        DB::raw("usuario2.id")
      )
      ->select('institb_modulos.*', DB::raw("CONCAT(institb_modulos.modulo, ' - ', institb_modulos.descricao) as description"),
        DB::raw("CASE WHEN institb_modulos.status = 1 THEN 'Ativo' ELSE 'Inativo' END as Status"),
        DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
        DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

        DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
        DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
      )
      ->get()->toArray();

      //$dados = [];

      // for($i=0;$i<count($select);$i++){
      //   $dados[$i] = array_merge($select[$i],array("description"=>$select[$i]['modulo'].' - '.$select[$i]['descricao']));
      // }
      
    //   for ($i=0; $i < count($dados) ; $i++) {        
         
        
    //     $dados[$i]['Status']=$dados[$i]['status']==1?'Ativo':'Inativo';
    //     // $a[$i]['Sindicalizado']=$a[$i]['func_sindlz']==1?'Sim':'Não';

    
    //     unset($dados[$i]['status']);
    //     unset($dados[$i]['description']);

       
    //  }

      return $select;
    }
}
