<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\Modulos;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoModulosEmpresa extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\ModulosEmpresa';
    protected $form_rules=[
        'modulo_id'=>'required',
        'empresa_id'=>'required'
                        ];

    protected $rules_msg=[
        'modulo_id.required'=>'O campo Módulo não pode estar vazio',
        'empresa_id.required'=>'O campo Empresa não pode estar vazio'
    ];

    public function insertModuloEmpresa($data){
        
        $resultado = $this->create($data);
        if(!$resultado){
            $this->setError('Falha ao inserir registro. Erro:170420200831');
            return false;
        }
        return true;
    }
    public function listarAll(){

        $tbl_empresa = new Empresa();
        $tbl_modulo = new Modulos();
        $tbl_usuario = new Usuario();

        $select = $this->getModelEntity()
        ->leftJoin($tbl_modulo->getTable(), $this->getModelEntity()->getColunaAlias('modulo_id'), $tbl_modulo->getColunaAlias('id'))
        ->leftJoin($tbl_empresa->getTable(), $this->getModelEntity()->getColunaAlias('empresa_id'), $tbl_empresa->getColunaAlias('id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('modulo_id'),
            $this->getModelEntity()->getColunaAlias('created_at'),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $tbl_modulo->getColunaAlias('modulo'),
            $tbl_modulo->getColunaAlias('descricao'),
            $tbl_modulo->getColunaAlias('status'),
            $tbl_empresa->getColunaAlias('cdn_empresa'),
            $tbl_empresa->getColunaAlias('razao'),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->orderBy('id','asc')
        ->get()->toArray();

        $data = [];

        for($i = 0; $i < count($select); $i++){
            $data[$i] = array_merge($select[$i], array("description_modulo"=>$select[$i]['modulo'].' - '.$select[$i]['descricao']));
            $data[$i] = array_merge($data[$i], array("description_empresa"=>$select[$i]['cdn_empresa'].' - '.$select[$i]['razao']));
        }
        // dd($data);
        // if(count($data) == 0){
        //     return 0;
        // }
        return $data;
    }
    public function updateDados($data){
        $select = $this->getModelEntity()->select()
        ->where([
            [$this->getModelEntity()->getColunaAlias('empresa_id'),'=',$data['empresa_id']],
            [$this->getModelEntity()->getColunaAlias('modulo_id'),'=',$data['modulo_id']]
        ])->get()->toArray();
        
        if(count($select) > 0){
            $this->setError('Registro já existente.');
            return false;
        }
        $resultado = $this->update($data,$data['id']);
        if(!$resultado){
            $this->setError('Falha ao atualizar registro. <br>Erro:170420200916');
            return false;
        }
        return true;
    }
}