<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Facades\DB;
class RepoNaturezaEvento extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\NaturezaEvento'; 
    protected $form_rules=[

                         ];
    protected $rules_msg=[];  

    public function listarToCadAutomatico(){
        $tbl_evento = new Eventos();
        $tbl_conta_ct = new ContaContabil();
        
        $select = $this->getModelEntity()
        ->join($tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('eventos_id'), $tbl_evento->getColunaAlias('id'))
        ->join($tbl_conta_ct->getTable(), $this->getModelEntity()->getColunaAlias('cta_contabil_id'), $tbl_conta_ct->getColunaAlias('id'))
        
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('cta_contabil_id'),
            $this->getModelEntity()->getColunaAlias('eventos_id'),
            $this->getModelEntity()->getColunaAlias('abre_ccusto'),
            $this->getModelEntity()->getColunaAlias('debito_credito'),
            $this->getModelEntity()->getColunaAlias('created_at'),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('updated_at'),
            $this->getModelEntity()->getColunaAlias('base_calc_orcamento'),
            $this->getModelEntity()->getColunaAlias('base_recisao'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_evento->getColunaAlias('dt_base_admissao_ini'),
            $tbl_evento->getColunaAlias('dt_base_admissao_fim'),
            $tbl_evento->getColunaAlias('multiplica'),
            $tbl_evento->getColunaAlias('inc_liquido'),
            $tbl_evento->getColunaAlias('tipo_evento_id'),
            $tbl_conta_ct->getColunaAlias('cod_cta_ctbl'),
            $tbl_conta_ct->getColunaAlias('desc_cta_ctbl'),
            $tbl_conta_ct->getColunaAlias('sequencia_execucao')

        )->orderBy('id','asc')
        ->where($this->getModelEntity()->getColunaAlias('base_calc_orcamento'),1)
        ->get()->toArray();

        return $select;
    }
    public function listarAll(){

        $tbl_evento = new Eventos();
        $tbl_conta_ct = new ContaContabil();
        $tbl_usuario = new Usuario();
        $entity = $this->getModelEntity();

        $select = $this->getModelEntity()
        ->leftJoin($tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('eventos_id'), $tbl_evento->getColunaAlias('id'))
        ->leftJoin($tbl_conta_ct->getTable(), $this->getModelEntity()->getColunaAlias('cta_contabil_id'), $tbl_conta_ct->getColunaAlias('id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
         )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('cta_contabil_id'),
            $this->getModelEntity()->getColunaAlias('eventos_id'),
            $this->getModelEntity()->getColunaAlias('abre_ccusto'),
            $this->getModelEntity()->getColunaAlias('debito_credito'),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('created_at'),
            $this->getModelEntity()->getColunaAlias('updated_at'),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            $this->getModelEntity()->getColunaAlias('created_by'),
            $this->getModelEntity()->getColunaAlias('base_calc_orcamento'),
            $this->getModelEntity()->getColunaAlias('base_recisao'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_evento->getColunaAlias('inc_liquido'),
            $tbl_evento->getColunaAlias('multiplica'),
            $tbl_evento->getColunaAlias('tipo_evento_id'),
            $tbl_conta_ct->getColunaAlias('cod_cta_ctbl'),
            $tbl_conta_ct->getColunaAlias('desc_cta_ctbl'),

            DB::raw("CONCAT({$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as description_evento"),
            DB::raw("CONCAT({$tbl_conta_ct->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_conta_ct->getColunaAlias('desc_cta_ctbl')}) as description_cta"),
            DB::raw("CONCAT({$tbl_conta_ct->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_conta_ct->getColunaAlias('desc_cta_ctbl')}, ' - ', {$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as description"),

            DB::raw("CASE WHEN {$entity->getColunaAlias('created_at')} IS NOT NULL THEN format({$entity->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            
            DB::raw("CASE WHEN {$entity->getColunaAlias('updated_at')} IS NOT NULL THEN format({$entity->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )->orderBy('id','asc')->get()->toArray();

        /*$dados = [];
        for($i=0;$i<count($select);$i++){
      
            //$dados[$i]=array_merge($select[$i],array("description_evento"=>$select[$i]['cdn_event'].' - '.$select[$i]['des_event']));
            //$dados[$i]=array_merge($dados[$i],array("description_cta"=>$dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl']));
            //$dados[$i]=array_merge($dados[$i],array("description"=>$dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl'].' - '.$select[$i]['cdn_event'].' - '.$dados[$i]['des_event']));
      
        }*/
        // dd($dados[1]['des_event'],strtolower(str_replace(' ','_',$dados[1]['des_event'])));
        return $select;
    }
    public function insert($dados){
        $select = $this->getModelEntity()->select()
        ->where([
            [$this->getModelEntity()->getColunaAlias('eventos_id'),'=',$dados['eventos_id']],
            [$this->getModelEntity()->getColunaAlias('cta_contabil_id'),'=',$dados['cta_contabil_id']]
            //[$this->getModelEntity()->getColunaAlias('empresa_id'),'=',$dados['empresa_id']],
        ])->get()->toArray();

        if(count($select)>0){
            $this->setError('Registro já cadastrado.<br>Erro: 290420201023');
            return false;
        }
        
        $inserir = $this->create($dados);
        if(!$inserir){
            $this->setError('Falha ao inserir registro.<br>Erro: 290420201024');
            return false;
        }
        return true;
    }
    public function updateCtaEvento($dados){
        if( ($dados['cta_contabil_id'] == $dados['dados_old']['cta_contabil_id']) && ($dados['eventos_id'] == $dados['dados_old']['eventos_id']) ){
            $update = $this->update($dados,$dados['id']);

            if(!$update){
                $this->setError('Falha ao atualizar registro.<br>Erro: 160620201432');
                return false;
            }
            return true;
        }
        else{
            $select = $this->getModelEntity()->select()
            ->where([
                [$this->getModelEntity()->getColunaAlias('eventos_id'),'=',$dados['eventos_id']],
                [$this->getModelEntity()->getColunaAlias('cta_contabil_id'),'=',$dados['cta_contabil_id']]
            ])->get()->toArray();
            if(count($select)>0){
                $this->setError('Registro já existente.<br>Erro: 290420201100');
                return false;
            }
            $update = $this->update($dados,$dados['id']);
            if(!$update){
                $this->setError('Falha ao atualizar registro.<br>Erro: 290420201101');
                return false;
            }
            return true;
        }
    }
}