<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoFuncionario;
use App\Modules\Natureza51\Repositories\RepoOrcNotificacoes;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\NivelHierarquico;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMailUser;
use App\Jobs\SendEmail;

class RepoNotify extends RepositoryNat51
{

    use \App\Core\Traits\NotificacaoTrait;

    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcNotificacoes';
    protected $repo_func;
    protected $repo_send_email;     
    protected $repo_notificacoes;    

    function __construct() {
        $this->repo_func = new RepoFuncionario();
        $this->repo_send_email = new RepoEnviarEmail();
        $this->repo_notificacoes = new RepoOrcNotificacoes();

        parent::__construct();
    }

    public function getRepoFunc(){
        return $this->repo_func;
    }

    public function getSendEmail(){
        return $this->repo_send_email;
    }

    public function getRepoNotification(){
        return $this->repo_notificacoes;
    }

    public function notifyLiberarForecast($hierarquia, $ano, $descricao, $orc_id, $observacao, $msg, $periodo){
        $funcs = $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia);
        
        $data_email = [
            'subject'=>'Reabertura do Forecast',
            'view'=>'emails.liberarForecast',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'periodo'=>$periodo,
            'msg'=>$msg
        ];

        $users = [];
        foreach ($funcs as $func) {    
            $data_email['nome'] = $func['nome_funcionario'];
            
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageliberarForecast($orc_id.' - '.$descricao.' - '.$ano, $periodo);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyLiberarForecast', $this->getTipoMessage('notifyLiberarForecast'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 250920201151');
                return false;
            }
        }
        return true;
    }

    public function reabreForecast($descricao_lotac, $ano, $descricao, $orc_id = null, $lot_id = null, $periodo = null, $hierarquia = null){
        
        if($lot_id == null){
            $funcs = $this->getRepoFunc()->getFuncsFromRH();
            $data_email = [
                'subject'=>'Reabertura do Forecast',
                'view'=>'emails.reabrirForecastGeral',
                'ano'=>$ano,
                'nome_lotacao'=>$descricao_lotac,
                'nome_orcamento'=>$descricao,
                'periodo'=>$periodo
            ];
        }
        else{
            $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
            
            $data_email = [
                'subject'=>'Reabertura do Forecast',
                'view'=>'emails.reabrirForecast',
                'ano'=>$ano,
                'nome_lotacao'=>$descricao_lotac,
                'nome_orcamento'=>$descricao,
                'periodo'=>$periodo
            ];
        }
        
        $users = [];
        foreach ($funcs as $func) {    
            $data_email['nome'] = $func['nome_funcionario'];
            
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $lot_id == null ? $this->getMessageReabreForecast($periodo) : $this->getMessageReabreForecastLotac($descricao_lotac);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'reabreForecast', $this->getTipoMessage('notifyReabreForecast'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 250920200943');
                return false;
            }
        }
        return true;
    }
    public function notifyCcustoVencido($lot_id = null, $hierarquia, $ano, $descricao, $orc_id= null, $observacao, $msg){
        
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs_rh = $this->getRepoFunc()->getFuncsFromRH();
        
        $data_email = [
            'subject'=>'Centro de Custo Vencido.',
            'view'=>'emails.centroCustoVencido',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao,
        ];

        $data_email_rh = [
            'subject'=>'Centro de Custo Vencido.',
            'view'=>'emails.centroCustoVencido',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao,

        ];    
        $users = [];
        $users_rh = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $msg;
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        
        foreach ($funcs_rh as $func_rh){
            $data_email_rh['nome'] = $func_rh['nome_funcionario'];
            if($func_rh->getUsuario){
                $users_rh[$func_rh->getUsuario->id] = $msg;
            
                $myJob = new SendEmail($func_rh->getUsuario->email, $data_email_rh);
                dispatch($myJob);
            }
        }
        
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, $msg, $orc_id, 'notifyCcustoVencido', $this->getTipoMessage('notifyCcustoVencido'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro: 010920201458');
                return false;
            }
        }
        
        if(count($users_rh) > 0 && $orc_id){
            if(!$this->insertNotify($users_rh, $msg, $orc_id, 'notifyCcustoVencido', $this->getTipoMessage('notifyCcustoVencido'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 010920201458');
                return false;
            }
        }
        return true;
    }

    public function notifyTrocaLotacao($lot_id = null, $hierarquia, $ano, $descricao, $orc_id= null, $observacao, $descricao_lotac, $nome_func){
        
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs_rh = $this->getRepoFunc()->getFuncsFromRH();
        
        // $emails = DB::select("select func.email from tbl_funcionario as func
        // where func.nivel_hier = 3 and func.lotacao_id = ?", [$lot_id]);

        // if(count($emails) == 0){
        //     $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        //     $funcs_rh = $this->getRepoFunc()->getFuncsFromRH();
        // }
        // dd($emails);

        $data_email = [
            'subject'=>'Tranferência de Lotação.',
            'view'=>'emails.transferencia',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao,
        ];

        $data_email_rh = [
            'subject'=>'Tranferência de Lotação.',
            'view'=>'emails.transferencia',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'nome_lotacao'=>$descricao_lotac,
            'observacao'=>$observacao,

        ];    
        

        $users = [];
        $users_rh = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];

            if($func->getUsuario){
                $users[$func->getUsuario->id] = "O Funcionário ".$nome_func." foi transferido para a lotação ".$descricao_lotac.".";
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
            
        }
        foreach ($funcs_rh as $func_rh){
            $data_email_rh['nome'] = $func_rh['nome_funcionario'];
            if($func_rh->getUsuario){
                $users_rh[$func_rh->getUsuario->id] = "O Funcionário ".$nome_func." foi transferido para a lotação ".$descricao_lotac.".";
            
                $myJob = new SendEmail($func_rh->getUsuario->email, $data_email_rh);
                dispatch($myJob);
            }
        }
        

        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyTrocaLotacao', $this->getTipoMessage('notifyTrocaLotacao'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro: 010920201032');
                return false;
            }
        }
        if(count($users_rh) > 0 && $orc_id){
            if(!$this->insertNotify($users_rh, null, $orc_id, 'notifyTrocaLotacao', $this->getTipoMessage('notifyTrocaLotacao'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 010920201032');
                return false;
            }
            
        }
        return true;
    }

    public function notifyReleaseBudget($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null){
       
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Liberação de Orçamento.',
            'view'=>'emails.releaseOrc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
        ];
        $users = [];
        foreach ($funcs as $func) {  
            $data_email['nome'] = $func['nome_funcionario'];          
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageReleaseOrc();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyReleaseBudget', $this->getTipoMessage('notifyReleaseBudget'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201127');
                return false;
            }
        }
        return true;
    }

    public function notifyTimeFillHC($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null, $daysToFill){
       
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Período para preenchimento e envio de headcount.',
            'view'=>'emails.sendSystemPrevious',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'dias'=>$daysToFill
        ];
        $users = [];
        foreach ($funcs as $func) {          
            $data_email['nome'] = $func['nome_funcionario'];  
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageNotifTimeHC($daysToFill);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyTimeFillHC', $this->getTipoMessage('notifyTimeFillHC'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201137');
                return false;
            }
        }
        return true;
    }

    public function notifySystemSend($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null){
       
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Envio sistêmico do headcount.',
            'view'=>'emails.sendSystem',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
        ];
        $users = [];
        foreach ($funcs as $func) {
            $data_email['nome'] = $func['nome_funcionario'];            
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageSendSystemHC();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifySystemSend', $this->getTipoMessage('notifySystemSend'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201159');
                return false;
            }
        }
        return true;
    }
    public function notifySendForecast($descricao_lotac, $ano, $descricao, $orc_id = null){
        $funcs = $this->getRepoFunc()->getFuncsFromRH();

        $data_email = [
            'subject'=>'Envio do Forecast.',
            'view'=>'emails.enviarForecast',
            'ano'=>$ano,
            'nome_lotacao'=>$descricao_lotac,
            'nome_orcamento'=>$descricao,
        ];
        $users = [];
        foreach ($funcs as $func) {    
            $data_email['nome'] = $func['nome_funcionario'];        
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageSendForecast($descricao_lotac);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifySendForecast', $this->getTipoMessage('notifySendForecast'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 230920201532');
                return false;
            }
        }
        return true;
    }

    public function notifySendHC($descricao_lotac, $ano, $descricao, $orc_id= null){
        // $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs = $this->getRepoFunc()->getFuncsFromRH();

        $data_email = [
            'subject'=>'Envio do headcount.',
            'view'=>'emails.sendHC',
            'ano'=>$ano,
            'nome_lotacao'=>$descricao_lotac,
            'nome_orcamento'=>$descricao,
        ];
        $users = [];
        foreach ($funcs as $func) {    
            $data_email['nome'] = $func['nome_funcionario'];        
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageSendHC($descricao_lotac);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifySendHC', $this->getTipoMessage('notifySendHC'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201400');
                return false;
            }
        }
        return true;
    }

    public function notifyReopen($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null, $observacao, $descricao_lotac){

        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs_rh = $this->getRepoFunc()->getFuncsFromRH();
        
        $data_email = [
            'subject'=>'Reabertura de headcount.',
            'view'=>'emails.reopenOrc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao,
        ];

        $data_email_rh = [
            'subject'=>'Reabertura de Headcount.',
            'view'=>'emails.reopenOrcRH',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'nome_lotacao'=>$descricao_lotac,
            'observacao'=>$observacao,

        ];    




        $users = [];
        $users_rh = [];
        foreach ($funcs as $func){
            // var_dump($func['nome_funcionario']);
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageReopenLotac();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        foreach ($funcs_rh as $func_rh){
            $data_email_rh['nome'] = $func_rh['nome_funcionario'];
            if($func_rh->getUsuario){
                $users_rh[$func_rh->getUsuario->id] = $this->getMessageReopenLotacRH($descricao_lotac);
            
                $myJob = new SendEmail($func_rh->getUsuario->email, $data_email_rh);
                dispatch($myJob);
            }
        }

        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyReopen', $this->getTipoMessage('notifyReopen'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201433');
                return false;
            }
        }
        if(count($users_rh) > 0 && $orc_id){
            if(!$this->insertNotify($users_rh, null, $orc_id, 'notifyReopen', $this->getTipoMessage('notifyReopen'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 290620201836');
                return false;
            }
            
        }  
        return true;
    }

    public function notifyConfer($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null, $descricao_lotac,$observacao){

        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs_rh = $this->getRepoFunc()->getFuncsFromRH();

        $data_email = [
            'subject'=>'Conferição de Headcount.',
            'view'=>'emails.conferOrc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'nome_lotacao'=>$descricao_lotac,
            'observacao'=>$observacao
        ];

        $data_email_rh = [
            'subject'=>'Conferição de Headcount.',
            'view'=>'emails.conferOrcRh',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'nome_lotacao'=>$descricao_lotac,

        ];

        $users = [];
        $users_rh = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageConferLotac();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        foreach ($funcs_rh as $func_rh){
            $data_email_rh['nome'] = $func_rh['nome_funcionario'];
            if($func_rh->getUsuario){
                $users_rh[$func_rh->getUsuario->id] = $this->getMessageConferLotacRh($descricao_lotac);
            
                $myJob = new SendEmail($func_rh->getUsuario->email, $data_email_rh);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyConfer', $this->getTipoMessage('notifyConfer'),$observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 240620201834');
                return false;
            }
            
        }
        if(count($users_rh) > 0 && $orc_id){
            if(!$this->insertNotify($users_rh, null, $orc_id, 'notifyConferRh', $this->getTipoMessage('notifyConferRh'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 240620201846');
                return false;
            }
            
        }
        return true;
    }

    public function notifyRelease($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null, $observacao){

        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Liberação de Orçamento.',
            'view'=>'emails.releaseCalc',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao

        ];
        $users = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageReleaseLotac();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyRelease', $this->getTipoMessage('notifyRelease'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201559');
                return false;
            }
        }
        return true;
    }

    public function notifyApproveManager($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null,$observacao){
        $hierarquia = 2; //OBS: Hierarquia para notificar apenas os diretores de área
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Aprovação de Orçamento.',
            'view'=>'emails.approveBudgetManager',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao


        ];
        $users = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageApproveManager();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyApproveManager', $this->getTipoMessage('notifyApproveManager'), $observacao)){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201654');
                return false;
            }
        }
        return true;
    }

    public function notifyApproveDirector($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null,$observacao){
        $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);

        $data_email = [
            'subject'=>'Aprovação de Orçamento.',
            'view'=>'emails.approveBudgetDirector',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'observacao'=>$observacao

        ];
        $users = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageApproveDirector();
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyApproveDirector', $this->getTipoMessage('notifyApproveDirector'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180520201701');
                return false;
            }
        }
        return true;
    }

    public function notifyCalculate($lot_id=null, $hierarquia, $ano, $descricao, $orc_id= null, $lotacao){

        // $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $funcs = $this->getRepoFunc()->getFuncsFromRH();
        $data_email = [
            'subject'=>'Cálculo de Orçamento.',
            'view'=>'emails.calculateLotac',
            'ano'=>$ano,
            'nome_orcamento'=>$descricao,
            'nome_lotacao'=>$lotacao,
        ];
        $users = [];
        foreach ($funcs as $func){
            $data_email['nome'] = $func['nome_funcionario'];
            if($func->getUsuario){
                $users[$func->getUsuario->id] = $this->getMessageCalculateLotac($lotacao);
            
                $myJob = new SendEmail($func->getUsuario->email, $data_email);
                dispatch($myJob);
            }
        }
        if(count($users) > 0 && $orc_id){
            if(!$this->insertNotify($users, null, $orc_id, 'notifyCalculate', $this->getTipoMessage('notifyCalculate'))){
                $this->setError($this->getRepoNotification()->getErrosFlatted());
                $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 290620200950');
                return false;
            }
        }
        return true;
    }

}
