<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
// use App\Modules\Natureza51\Entities\CalcOrcamento;


use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\Usuario;
use Exception;

class RepoOrcBeneficio extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcBeneficio';
                     
    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();        
    }
    public function createOrcBeneficio($data_request, $periodo = null, $tipo_table = 'O'){        
       
        // $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();
        
        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('beneficio_id'),'=',$data_request['beneficio_id']],
            [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']],
            [$this->getModelEntity()->getColunaAlias('evento_id'),'=',$data_request['evento_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $tipo_table] 
        ]);
        
        $beneficio = [];
        if($tipo_table == 'F'){
            $beneficio = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $beneficio = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
            
        if(count($beneficio) > 0){
            //dd($data_request);
            /*if($data_request['tipo_meses'] == 2)
            {
                $select_calc_orc = $tbl_calc_orc->select()->where([
                    [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$beneficio[0]['id']],
                    [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //dd($select_calc_orc);
                if(!empty($select_calc_orc))
                {
                    $this->setError("Registro já existente em valor absoluto.<br>Erro: 070420201409");
                    return false;
                }
                else
                {   
                    if(!$this->insereCalcOrc($beneficio[0]['id'],$data_request)){
                        $this->setError('Erro ao inserir registro.<br>Erro: 070420201410');
                        return false;
                    }
                }
            }
            if($data_request['tipo_meses']==1)
            {
                //dd("aqui",$beneficio[0]['id'],$this->getModelEntity()->getTable());
                $select_calc_ind = $tbl_calc_ind->select()->where([
                    [$tbl_calc_ind->getColunaAlias('origem_id'),'=',$beneficio[0]['id']],
                    [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //dd($select_calc_ind,$beneficio[0]['id'],$this->getModelEntity()->getTable());
                if(!empty($select_calc_ind))
                {
                    $this->setError("Registro já existente em índice.<br>Erro: 070420201410");
                    return false;
                }
                
                else
                {
                    if(!$this->insereIndice($beneficio[0]['id'],$data_request)){
                        $this->setError('Erro ao inserir registro.<br>Erro: 070420201155');
                        return false;
                    }
                }
            }*/

            $this->setError("Registro já existente.<br>Erro: 040620201113");
            return false;
        }
        else{
            /*if($data_request['tipo_meses']==1){
                if(!$this->createOrcBeneficioIndice($data_request)){
                    $this->setError('Não foi possível inserir os índices.<br>Erro:070420201449');
                    return false;
                }
                return true;
            }
            else{*/
            if(!$this->insereCalcBeneficio($data_request)){
                $this->setError('Não foi possível inserir o registro.<br>Erro:070420201450');
                return false;
            }
            return true;
            /*}*/
        
        }
        

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
    }

    public function insereCalcBeneficio($data_request){
        $retorno=true;
        $instance = $this;

        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            $data_request['empresa_id'] = $this->fillCodEmpresa();

            if($data_request['tipo_table'] != 'F'){
                unset($data_request['periodo']);
            }
            $id_orc_beneficio = $instance->createParent($data_request);
            
            if(! $id_orc_beneficio){  
                $retorno = false;
                return false;
            }  
            
            $merge_tb_calc = [
                'origem_id' => $id_orc_beneficio->id,
                'tbl_origem' => $instance->getModelEntity()->getTable()
            ];

            if(!$this->insereIndice($merge_tb_calc['origem_id'], $data_request['meses_orcado'])){
                $this->setError("Falha ao inserir índices.<br>Erro: 040620201117");
                return false;
            }
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        saida:
        return $retorno;
    }

    public function insereIndice($id, $dados){
        $tbl_calc_indice=new CalcIndice();
        
        //$dados = $dados['meses_orcado'];
        $indice = 1;
        $dados_indice=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$indice,
            'fev_indice'=>$indice,
            'marc_indice'=>$indice,
            'abril_indice'=>$indice,
            'maio_indice'=>$indice,
            'jun_indice'=>$indice,
            'jul_indice'=>$indice,
            'agost_indice'=>$indice,
            'set_indice'=>$indice,
            'out_indice'=>$indice,
            'nov_indice'=>$indice,
            'dez_indice'=>$indice
        );
        //$dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            abort(500,'Erro ao inserir índices.');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();

        $data=$data['meses_orcado'];
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable()
        );
        
        $orcamento = array_merge($orcamento,$data);
        
        if(!$calc_orcamento->create($orcamento))
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
    }

    public function createParent($data_request){
        
        $query = $this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('evento_id'),'=',$data_request['evento_id']],
                [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
                [$this->getModelEntity()->getColunaAlias('beneficio_id'),'=',$data_request['beneficio_id']],
                [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']]
        ]);
        
        $dados = [];
        if(array_key_exists('tipo_table', $data_request) && $data_request['tipo_table'] == 'F'){
            $dados = $query->where($this->getModelEntity()->getColunaAlias('tipo_table'), $data_request['tipo_table'])
            ->where($this->getModelEntity()->getColunaAlias('periodo'), $data_request['periodo'])
            ->get()->toArray();
        }
        else{
            $dados = $query->where($this->getModelEntity()->getColunaAlias('tipo_table'), '=', $data_request['tipo_table'])
            ->whereNull($this->getModelEntity()->getColunaAlias('periodo'))
            ->get()->toArray();
        }
        
        if(count($dados) == 0){
            return parent::create($data_request);
        }else{
            $this->setError("Registro já cadastrado! erro:180220201018");
            
            abort(500, "Registro já cadastrado! erro:180220201018");
            return false;
        }
    }

    public function createOrcBeneficioIndice(array $dados){

        $this->clearError();

        $tb_calc_indice=new CalcIndice();

        $dados_env=Arr::only($dados,['orcamento_id','beneficio_id','evento_id','tipo_calc','vlr_movto','vlr_depend','cta_ctb_id']);
        
        DB::beginTransaction();
        try{
            
            $salvou = $this->create($dados_env);

            if(!$salvou){
                return false;
            }
            //dd($salvou);
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['meses_orcado']['jan_orcado'],
            'fev_indice'=>$dados['meses_orcado']['fev_orcado'],
            'marc_indice'=>$dados['meses_orcado']['mar_orcado'],
            'abril_indice'=>$dados['meses_orcado']['abr_orcado'],
            'maio_indice'=>$dados['meses_orcado']['mai_orcado'],
            'jun_indice'=>$dados['meses_orcado']['jun_orcado'],
            'jul_indice'=>$dados['meses_orcado']['jul_orcado'],
            'agost_indice'=>$dados['meses_orcado']['ago_orcado'],
            'set_indice'=>$dados['meses_orcado']['set_orcado'],
            'out_indice'=>$dados['meses_orcado']['out_orcado'],
            'nov_indice'=>$dados['meses_orcado']['nov_orcado'],
            'dez_indice'=>$dados['meses_orcado']['dez_orcado'],
        );
            //dd($dados_indice);
            $salvar_indice=$tb_calc_indice->create($dados_indice);
             
            if(!$salvar_indice){
                $this->setError('Falha ao inserir indices. Erro: 010420201208');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar benefício no orçamento. Erro: 010420201208.'.$ex);
       }
       return true;
    }

    public function listar($id, $periodo = null, $tipo_table = 'O'){
        
        // $orcBeneficio = OrcBeneficio::with([
        //     'getEvento'=>function($query){
    
        //     },
        //     'getCalcOrcamento'=>function($query){
                
        //    }

        // ])->where('orcamento_id',$id)->get()
        // ->toArray();
        
        // for ($i=0; $i < count($orcBeneficio); $i++) {   
            
            
        //     $orcBeneficio[$i]['description'] = $orcBeneficio[$i]['get_evento']['cdn_event'].' - '.$orcBeneficio[$i]['get_evento']['des_event'];
        //     $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
        //     Arr::forget($orcBeneficio[$i], 'get_evento');
        //     $orcBeneficio[$i]['calc_orcamento_id'] = $orcBeneficio[$i]['get_calc_orcamento']['id'];
        //     unset($orcBeneficio[$i]['get_calc_orcamento']['id']);
        //     $orcBeneficio[$i]= array_merge($orcBeneficio[$i], $orcBeneficio[$i]['get_calc_orcamento']); 
        //     Arr::forget($orcBeneficio[$i], 'get_calc_orcamento');

            
        //     $orcBeneficio[$i]['vlr_movto']=formatarNumeroPtBr($orcBeneficio[$i]['vlr_movto']);
        //     $orcBeneficio[$i]['vlr_depend']=formatarNumeroPtBr($orcBeneficio[$i]['vlr_depend']);
        //     $orcBeneficio[$i]['jan_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jan_orcado']);
        //     $orcBeneficio[$i]['fev_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['fev_orcado']);
        //     $orcBeneficio[$i]['mar_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['mar_orcado']);
        //     $orcBeneficio[$i]['abr_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['abr_orcado']);
        //     $orcBeneficio[$i]['mai_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['mai_orcado']);
        //     $orcBeneficio[$i]['jun_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jun_orcado']);
        //     $orcBeneficio[$i]['jul_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jul_orcado']);
        //     $orcBeneficio[$i]['ago_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['ago_orcado']);
        //     $orcBeneficio[$i]['set_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['set_orcado']);
        //     $orcBeneficio[$i]['out_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['out_orcado']);
        //     $orcBeneficio[$i]['nov_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['nov_orcado']);
        //     $orcBeneficio[$i]['dez_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['dez_orcado']);      

        // }
        $tbl_orc_beneficio = $this->getModelEntity();
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_beneficio = new Beneficio();
        $tbl_evento = new Eventos();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();

        $query = $tbl_orc_beneficio
        ->leftJoin($tbl_calc_orc->getTable(), $tbl_orc_beneficio->getColunaAlias('id'), $tbl_calc_orc->getColunaAlias('origem_id'))

        ->leftJoin($tbl_beneficio->getTable(), $tbl_orc_beneficio->getColunaAlias('beneficio_id'), $tbl_beneficio->getColunaAlias('id'))

        ->leftJoin($tbl_cta_ctb->getTable(), $tbl_orc_beneficio->getColunaAlias('cta_ctb_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_evento->getTable(), $tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_orc->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $tbl_orc_beneficio->getColunaAlias('id'),
            $tbl_orc_beneficio->getColunaAlias('orcamento_id'),
            $tbl_orc_beneficio->getColunaAlias('grade_maximo'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_beneficio->getColunaAlias('evento_id'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),
            DB::raw("{$tbl_cta_ctb->getColunaAlias('id')} as cta_ctb_id"),
            DB::raw("{$tbl_beneficio->getColunaAlias('id')} as beneficio_id"),
            $tbl_orc_beneficio->getColunaAlias('tipo_calc'),
            $tbl_orc_beneficio->getColunaAlias('vlr_movto'),
            $tbl_orc_beneficio->getColunaAlias('vlr_maximo'),
            $tbl_orc_beneficio->getColunaAlias('salario_corte'),
            $tbl_beneficio->getColunaAlias('origem_beneficio'),
            DB::raw("CASE {$tbl_beneficio->getColunaAlias('origem_beneficio')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_origem_beneficio"),
            $tbl_orc_beneficio->getColunaAlias('exclusivo_admissao'),
            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('exclusivo_admissao')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_exclusivo_admissao"),
            // $tbl_beneficio->getColunaAlias('vlr_depend'),
            // $tbl_beneficio->getColunaAlias('formula'),
            $tbl_beneficio->getColunaAlias('empresa_id'),
            $tbl_orc_beneficio->getColunaAlias('tipo_acesso'),
            DB::raw("{$tbl_calc_orc->getColunaAlias('id')} as calc_orcamento_id"),    

            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('tipo_acesso')} 
                WHEN 1 THEN '1 - Todos Funcionários'
                WHEN 2 THEN '2 - Por Lotação e Cargo'
                WHEN 3 THEN '3 - Individual'
                END as des_tipo_acesso"),

            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),

            $tbl_calc_orc->getColunaAlias('origem_id'),
            $tbl_calc_orc->getColunaAlias('tbl_origem'),

            $tbl_calc_orc->getColunaAlias('jan_orcado'),
            $tbl_calc_orc->getColunaAlias('fev_orcado'),                                     
            $tbl_calc_orc->getColunaAlias('mar_orcado'),                                    
            $tbl_calc_orc->getColunaAlias('abr_orcado'),                                    
            $tbl_calc_orc->getColunaAlias('mai_orcado'),
            $tbl_calc_orc->getColunaAlias('jun_orcado'), 
            $tbl_calc_orc->getColunaAlias('jul_orcado'), 
            $tbl_calc_orc->getColunaAlias('ago_orcado'),
            $tbl_calc_orc->getColunaAlias('set_orcado'), 
            $tbl_calc_orc->getColunaAlias('out_orcado'),
            $tbl_calc_orc->getColunaAlias('nov_orcado'), 
            $tbl_calc_orc->getColunaAlias('dez_orcado'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            $tbl_orc_beneficio->getColunaAlias('created_at'),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            $tbl_calc_orc->getColunaAlias('updated_at')
        )

        ->where([
            [$tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$id],
            [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$tbl_orc_beneficio->getTable()],
            [$tbl_orc_beneficio->getColunaAlias('tipo_table'), '=', $tipo_table]
        ]);
        
        $dados = [];
        if($tipo_table == 'F'){
            $dados = $query->where($tbl_orc_beneficio->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $dados = $query->whereNull($tbl_orc_beneficio->getColunaAlias('periodo'))->get()->toArray();
        }
        
        for($i = 0; $i < count($dados); $i++){
            $dados[$i]['description'] = $dados[$i]['cdn_event'].' - '.$dados[$i]['des_event'];
            $dados[$i]['description_cta_ctb'] = $dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl'];
            $dados[$i]['identificador'] = "2";
        }

        //$meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        //dd('Meses aqui!!!',$this->getOnly($orcBeneficio,$meses));
        return $dados;


    } 

    public function listarIndice($id, $periodo = null, $tipo_table = 'O'){
        $tbl_orc_beneficio = $this->getModelEntity();
        $tbl_calc_ind = new CalcIndice();
        $tbl_beneficio = new Beneficio();
        $tbl_evento = new Eventos();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();

        $query = $tbl_orc_beneficio
        ->leftJoin($tbl_calc_ind->getTable(), $tbl_orc_beneficio->getColunaAlias('id'), $tbl_calc_ind->getColunaAlias('origem_id'))

        ->leftJoin($tbl_beneficio->getTable(), $tbl_orc_beneficio->getColunaAlias('beneficio_id'), $tbl_beneficio->getColunaAlias('id'))

        ->leftJoin($tbl_cta_ctb->getTable(), $tbl_orc_beneficio->getColunaAlias('cta_ctb_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_evento->getTable(), $tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_ind->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            
            $tbl_orc_beneficio->getColunaAlias('id'),
            $tbl_orc_beneficio->getColunaAlias('orcamento_id'),
            $tbl_orc_beneficio->getColunaAlias('grade_maximo'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_beneficio->getColunaAlias('evento_id'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),
            DB::raw("{$tbl_cta_ctb->getColunaAlias('id')} as cta_ctb_id"),
            DB::raw("{$tbl_beneficio->getColunaAlias('id')} as beneficio_id"),
            $tbl_orc_beneficio->getColunaAlias('tipo_calc'),
            $tbl_orc_beneficio->getColunaAlias('vlr_movto'),
            $tbl_orc_beneficio->getColunaAlias('vlr_maximo'),
            $tbl_orc_beneficio->getColunaAlias('salario_corte'),
            $tbl_orc_beneficio->getColunaAlias('exclusivo_admissao'),
            $tbl_beneficio->getColunaAlias('origem_beneficio'),
            DB::raw("CASE {$tbl_beneficio->getColunaAlias('origem_beneficio')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_origem_beneficio"),
            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('exclusivo_admissao')} 
                WHEN 1 THEN 'Sim'
                WHEN 0 THEN 'Não'
                ELSE '-'
                END as des_exclusivo_admissao"),
            // $tbl_beneficio->getColunaAlias('vlr_depend'),
            // $tbl_beneficio->getColunaAlias('formula'),
            $tbl_beneficio->getColunaAlias('empresa_id'),
            DB::raw("{$tbl_calc_ind->getColunaAlias('id')} as calc_indice_id"),
            
            $tbl_orc_beneficio->getColunaAlias('tipo_acesso'),
            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('tipo_acesso')} 
                WHEN 1 THEN '1 - Todos Funcionários'
                WHEN 2 THEN '2 - Por Lotação e Cargo'
                WHEN 3 THEN '3 - Individual'
                END as des_tipo_acesso"),

            DB::raw("CASE {$tbl_orc_beneficio->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),

            $tbl_calc_ind->getColunaAlias('origem_id'),
            $tbl_calc_ind->getColunaAlias('tbl_origem'),

            $tbl_calc_ind->getColunaAlias('jan_indice'),
            $tbl_calc_ind->getColunaAlias('fev_indice'),
            $tbl_calc_ind->getColunaAlias('marc_indice'),
            $tbl_calc_ind->getColunaAlias('abril_indice'),
            $tbl_calc_ind->getColunaAlias('maio_indice'),
            $tbl_calc_ind->getColunaAlias('jun_indice'),
            $tbl_calc_ind->getColunaAlias('jul_indice'),
            $tbl_calc_ind->getColunaAlias('agost_indice'),
            $tbl_calc_ind->getColunaAlias('set_indice'),
            $tbl_calc_ind->getColunaAlias('out_indice'),
            $tbl_calc_ind->getColunaAlias('nov_indice'),
            $tbl_calc_ind->getColunaAlias('dez_indice'),
            
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            $tbl_orc_beneficio->getColunaAlias('created_at'),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            $tbl_calc_ind->getColunaAlias('updated_at')
        )

        ->where([
            [$tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$id],
            [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$tbl_orc_beneficio->getTable()],
            [$tbl_orc_beneficio->getColunaAlias('tipo_table'), '=', $tipo_table]
        ]);
        
        $dados = [];
        if($tipo_table == 'F'){
            $dados = $query->where($tbl_orc_beneficio->getColunaAlias('periodo'), '=', $periodo)->get()->toArray();
        }
        else{
            $dados = $query->whereNull($tbl_orc_beneficio->getColunaAlias('periodo'))->get()->toArray();
        }

        for($i=0;$i<count($dados);$i++){
            $dados[$i]['description'] = $dados[$i]['cdn_event'].' - '.$dados[$i]['des_event'];
            $dados[$i]['description_cta_ctb'] = $dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl'];
            $dados[$i]['identificador'] = "1";
        }

        return $dados;
    }

    public function listaEventos($orc_id, $periodo = null, $tipo_table = 'O'){
        $query = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            },
            'getCtaCtb'=>function($query){

            }
        ])
        ->where('orcamento_id', $orc_id)->where('tipo_table', $tipo_table);

        $orcBeneficio = [];
        if($tipo_table == 'F'){
            $orcBeneficio = $query->where('periodo', $periodo)->get()->toArray();
        }
        else{
            $orcBeneficio = $query->whereNull('periodo')->get()->toArray();
        }
        
        for ($i=0; $i < count($orcBeneficio); $i++) {             
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            $orcBeneficio[$i]['cdn_event'] = $orcBeneficio[$i]['get_evento']['cdn_event'];
            $orcBeneficio[$i]['inc_liquido'] = $orcBeneficio[$i]['get_evento']['inc_liquido'];
            $orcBeneficio[$i]['multiplica'] = $orcBeneficio[$i]['get_evento']['multiplica'];
            $orcBeneficio[$i]['vlr_movto'] = $orcBeneficio[$i]['vlr_movto'];
            $orcBeneficio[$i]['vlr_movto_'] = number_format( $orcBeneficio[$i]['vlr_movto'],6,',','.' );
            $orcBeneficio[$i]['multiplica_'] = number_format( $orcBeneficio[$i]['multiplica'],6,',','.' );
            $orcBeneficio[$i]['vlr_maximo_'] = number_format( $orcBeneficio[$i]['vlr_maximo'],6,',','.' );
            $orcBeneficio[$i]['description_cta_ctb'] = $orcBeneficio[$i]['get_cta_ctb']['cod_cta_ctbl'].' - '.$orcBeneficio[$i]['get_cta_ctb']['desc_cta_ctbl'];
            $orcBeneficio[$i]['cta_ctb_id'] = $orcBeneficio[$i]['get_cta_ctb']['id'];
            Arr::forget($orcBeneficio[$i], 'get_evento', 'get_cta_ctb');
            $orcBeneficio[$i]['description']=$orcBeneficio[$i]['cdn_event'].' - '.$orcBeneficio[$i]['des_event'];
        }
        
        return $orcBeneficio;
    }  
    
    public function deleteOrcBeneficio($data_request){        
        $retorno=true;
        $instance = $this;
        // $tbl_orc_ben_carg = new OrcLotCargoBeneficio();
        // $tbl_orc_ben_func = new OrcLotFuncionatioBeneficio();
        
        // $select = $this->getModelEntity()
        // ->leftJoin($tbl_orc_ben_carg->getTable(), $this->getModelEntity()->getColunaAlias('id'),'=', 
        // DB::raw("{$tbl_orc_ben_carg->getColunaAlias('orc_beneficio_id')} and {$tbl_orc_ben_carg->getColunaAlias('orcamento_id')} = {$data_request['orcamento_id']}"))
        
        // ->leftJoin($tbl_orc_ben_func->getTable(), $this->getModelEntity()->getColunaAlias('id'),'=', 
        // DB::raw("{$tbl_orc_ben_func->getColunaAlias('orc_beneficio_id')} and {$tbl_orc_ben_func->getColunaAlias('orcamento_id')} = {$data_request['orcamento_id']}"))
        // ->select(
        //     $tbl_orc_ben_func->getColunaAlias('orc_beneficio_id'),
        //     $tbl_orc_ben_carg->getColunaAlias('orc_beneficio_id')
        // )
        // ->where([
        //     [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=', $data_request['orcamento_id']],
        //     [$tbl_orc_ben_carg->getColunaAlias('orc_beneficio_id'),'=', $data_request['id']],
        //     [$tbl_orc_ben_func->getColunaAlias('orc_beneficio_id'),'=', $data_request['id']]
        // ])
        // //->toSql();
        // ->get()->toArray();

        // dd($select,$data_request['orcamento_id']);
       // DB::transaction(function()use(&$retorno, $data_request, $instance){
        
        $ben_lot_cargo = DB::select("SELECT * from tbl_orc_benef_lot_carg where orc_beneficio_id = {$data_request['id']}");
        if(count($ben_lot_cargo) > 0){
            $this->setError('Não foi possível concluir a operação, pois o Benefício selecionado está sendo usado em Benefício por Cargo.');
            return false;
        }
        $ben_func = DB::select("SELECT * from tbl_orc_beneficio_funcionario where orc_beneficio_id = {$data_request['id']}");
        if(count($ben_func) > 0){
            $this->setError('Não foi possível concluir a operação, pois o Benefício selecionado está sendo usado em Benefício por Funcionário.');
            return false;
        }
        

        DB::beginTransaction();
        try{
        // DB::transaction(function()use(&$retorno, $data_request, $instance){

            $calc_indice = new CalcIndice();
            $repo_calc_ind = new RepoCalcIndice();
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            if(!$instance->deleteParent($data_request['id'])){                    
                $retorno = true;
                DB::rollback();
                // $this->setError($this->getRepository()->getErrosFlatted());
                // abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['calc_orcamento_id'];

            if(! $repo_calc_orcamento->delete($calc_orcamento_id['id'])){                    
                $retorno = true;
                DB::rollback();
                $this->setError( $repo_calc_orcamento->getErrosFlatted());
                // abort(500, $retorno['msg']);
                return false;
            }

            $select_indice = $calc_indice->select()->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();
            

            if(count($select_indice)>0){
                $delete_indices = $repo_calc_ind->getModelEntity()->where([
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]])
                ->delete();

                if(!$delete_indices){     
                    $retorno = true;
                    DB::rollback();
                    $this->setError( $repo_calc_ind->getErrosFlatted());
                    // abort(500, $retorno['msg']);
                    return false;
                }
            }     
        }
        catch (Exception $e) {
            DB::rollback();
            $this->setError($e->getMessage());
        }
    // });
    
        
        return $retorno;
    }

    public function deleteBeneficioIndice($form_data){
        $repo_calc_ind = new RepoCalcIndice();
        $calc_orcamento = new CalcOrcamento();
        
        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['origem_id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();
            
            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420200935");
                return false;
            }
        }
        else{

            DB::beginTransaction();
            try {
                if(!$this->deleteParent($form_data['id'])){
                    return false;
                }    
                
                if(!$repo_calc_ind->delete($form_data['calc_indice_id'])){
                    return false;
                }    
                
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 050420202009.'.$e);
                return false;
            }
        }
        return true;
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function updateOrcBeneficio($data_request){        
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            $dados_beneficio=Arr::only($data_request,['id','orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula']);

            $vlr_movto = array("vlr_movto"=>convertDec($data_request['vlr_movto']));
            $vlr_depend = array("vlr_depend"=>convertDec($data_request['vlr_depend']));
            $dados_b2 = array_merge($dados_beneficio,$vlr_movto,$vlr_depend);

            if(!$instance->updateParent($dados_b2, $dados_b2['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['calc_orcamento_id'];
            $dados_orc=Arr::except($data_request,['orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula','vlr_movto','vlr_depend']);

            $dados_orcamento = Arr::except($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','jul_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $meses=Arr::only($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $orcamento = convertDec($meses);
            $array_orcamento = array_merge($dados_orcamento,$orcamento);

            if(! $repo_calc_orcamento->update($array_orcamento, $calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function updateBeneficioIndice($form_data){
        $tbl_calc_indice = new RepoCalcIndice();
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        
        $id = $form_data['calc_indice_id'];

        $update = $tbl_calc_indice->update($meses,$id);
        if(!$update){
            $this->setError('Erro ao atualizar registro. Erro:030420201427');
            return false;
        }
        return true;
    }

    public function updateParent($data_request, $id){

        // $this->form_rules['evento_id'].=','.$id;
        $dados=$this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('id'),'=',$data_request['id'])->get()->toArray();
        if(count($dados)==1){
            return parent::update($data_request, $id);
        }
        return false;

    }
    public function getOnly($data,$fields){
        Arr::except($data,$fields );
    }

    public function insertDistribuir($dados){
    
        $orc_beneficio_id = $dados['id'];
        $cta_ctb_id = $dados['cta_ctb_id'];
        $orcamento_id = $dados['orcamento_id'];
        
        $meses = convertDecimalEn(Arr::only($dados,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice',
        'jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']));
        //dd($meses);
        $msg = [];

        $beneficio_cargo_orc = new OrcLotCargoBeneficio();
        $beneficio_funcionario_orc = new OrcLotFuncionatioBeneficio();
        $calc_indice = new CalcIndice();


        /* ==================== SELECTS PRIMARIOS ==================================== */

        

        /* ================= SELECTS SECUNDARIOS E 1ª VALIDAÇÃO ===============================*/

        if( (count($select) > 0) && (count( $select_funcionario_beneficio ) > 0)){

            $select_indice_cargo = $calc_indice->select()
            ->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$select[0]['id']],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$beneficio_cargo_orc->getTable()]
            ])->get()->toArray();

            /* =============== SECUNDA VALIDAÇÃO E INSERT ===================================*/
            if( ( count( $select_indice_cargo ) == 0) && ( count( $select_indice_func ) == 0) ){
                $dados_cargo_indice = array_merge(array(
                    "tbl_origem" => $beneficio_cargo_orc->getTable(),
                    "origem_id" => $select[0]['id']
                ),$meses);

                $dados_func_indice = array_merge(array(
                    "tbl_origem" => $beneficio_funcionario_orc->getTable(),
                    "origem_id" => $select[0]['id']
                ),$meses);
                
                $inserir = $calc_indice->create($dados_cargo_indice);
                $inserir_func = $calc_indice->create($dados_func_indice);

                if(!$inserir){
                    $this->setError("Falha ao inserir beneficio cargo indice");
                    return false;
                }
            }
        }
        return $msg;
    }

    public function inserirBeneficioFuncionarioIndice($dados, $periodo = null, $tipo_table = 'O'){
        set_time_limit(1200);
        $orc_beneficio_id = $dados['id'];
        $cta_ctb_id = $dados['cta_ctb_id'];
        $orcamento_id = $dados['orcamento_id'];
        $erros = 0;
        $beneficio_funcionario_orc = new OrcLotFuncionatioBeneficio();
        $calc_indice = new CalcIndice();

        $meses = convertDecimalEn(Arr::only($dados,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice',
        'jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']));

        $query = $beneficio_funcionario_orc->select()->
        where([
            [$beneficio_funcionario_orc->getColunaAlias('orcamento_id'),'=',$orcamento_id],
            [$beneficio_funcionario_orc->getColunaAlias('cta_ctb_id'),'=',$cta_ctb_id],
            [$beneficio_funcionario_orc->getColunaAlias('orc_beneficio_id'),'=',$orc_beneficio_id],
            [$beneficio_funcionario_orc->getColunaAlias('tipo_table'),'=',$tipo_table]
        ]);

        $select_funcionario_beneficio = [];
        if($tipo_table == 'F'){
            $select_funcionario_beneficio = $query->where($beneficio_funcionario_orc->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select_funcionario_beneficio = $query->whereNull($beneficio_funcionario_orc->getColunaAlias('periodo'))->get()->toArray();
        }
        
        if( count( $select_funcionario_beneficio ) > 0 ){
            for($i = 0; $i < count($select_funcionario_beneficio); $i++){
                $select_indice_func = $calc_indice->select('id')
                ->where([
                    [$calc_indice->getColunaAlias('origem_id'),'=',$select_funcionario_beneficio[$i]['id']],
                    [$calc_indice->getColunaAlias('tbl_origem'),'=',$beneficio_funcionario_orc->getTable()]
                ])->get()->toArray();

                if( count( $select_indice_func ) == 0){
                    $dados_func_indice = array_merge(
                    array("tbl_origem" => $beneficio_funcionario_orc->getTable(), "origem_id" => $select_funcionario_beneficio[$i]['id']),$meses);
                
                    $inserir_func = $calc_indice->create($dados_func_indice);

                    if(!$inserir_func){
                        $erros++;
                    }
                }
                else{
                    $repo_calc_ind = new RepoCalcIndice();
                    $update_calc = $repo_calc_ind->update($meses, $select_indice_func[0]['id']);
                    if(!$update_calc){
                        $erros++;
                    }
                }
            }
            if($erros > 0){
                $this->setError("Falha ao distribuir registros.");
                return false;
            }
            return true;
        }
        $this->setError("Registro inexistente em Beneficio por Funcionário.<br>Erro: 040620201625");
        return false;
    }

    public function inserirBeneficioCargoIndice($dados, $periodo = null, $tipo_table = 'O'){
        set_time_limit(1200);
        $orc_beneficio_id = $dados['id'];
        $cta_ctb_id = $dados['cta_ctb_id'];
        $orcamento_id = $dados['orcamento_id'];

        $beneficio_cargo_orc = new OrcLotCargoBeneficio();
        $calc_indice = new CalcIndice();
        $erros = 0;
        $meses = convertDecimalEn(Arr::only($dados,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice',
        'jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']));

        $query = $beneficio_cargo_orc->select()->
        where([
            [$beneficio_cargo_orc->getColunaAlias('orcamento_id'),'=',$orcamento_id],
            [$beneficio_cargo_orc->getColunaAlias('cta_ctb_id'),'=',$cta_ctb_id],
            [$beneficio_cargo_orc->getColunaAlias('orc_beneficio_id'),'=',$orc_beneficio_id],
            [$beneficio_cargo_orc->getColunaAlias('tipo_table'),'=',$tipo_table]
        ]);
        $select = [];
        if($tipo_table == 'F'){
            $select = $query->where($beneficio_cargo_orc->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($beneficio_cargo_orc->getColunaAlias('periodo'))->get()->toArray();
        }
        
        if( count( $select ) > 0 ){
            for($i = 0; $i < count($select); $i++){
                $select_indice_cargo = $calc_indice->select('id')
                ->where([
                    [$calc_indice->getColunaAlias('origem_id'),'=',$select[$i]['id']],
                    [$calc_indice->getColunaAlias('tbl_origem'),'=',$beneficio_cargo_orc->getTable()]
                ])->get()->toArray();
                
                if( count( $select_indice_cargo ) == 0){
                    $dados_cargo_indice = array_merge(
                    array("tbl_origem" => $beneficio_cargo_orc->getTable(), "origem_id" => $select[$i]['id']),$meses);
                
                    $inserir_cargo = $calc_indice->create($dados_cargo_indice);
                    if(!$inserir_cargo){
                        $erros++;
                    }
                }
                else{
                    $repo_calc_ind = new RepoCalcIndice();
                    $update_calc = $repo_calc_ind->update($meses, $select_indice_cargo[0]['id']);
                    if(!$update_calc){
                        $erros++;
                    }
                }
            }
            if($erros > 0){
                $this->setError("Falha ao distribuir registros.");
                return false;
            }
            return true;
        }
        $this->setError("Registro inexistente em Benefício por Cargo.<br>Erro: 040620201651");
        return false;
    }

    public function atualizaOrcBeneficio($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->clearError();
        set_time_limit($this->getTimeOut());
        
        $condicao[0] = $tipo_table == 'F' ? " and ob.periodo = '{$periodo}' and ob.tipo_table = '{$tipo_table}'" : " and ob.periodo is null and ob.tipo_table = '{$tipo_table}'";

        $select = DB::select("SELECT
            b.id as beneficio_id, b.cta_ct_id as cta_ctb_id, b.evento_id, b.tipo_calc, b.vlr_movto, b.formula, 
            b.vlr_maximo, b.tipo_acesso, b.exclusivo_admissao, b.salario_corte, b.grade_maximo, b.valor_deducao
            from tbl_beneficio as b

            inner join tbl_eventos as e on e.id = b.evento_id
            where (select count(*) from tbl_orc_beneficio ob where 
            ob.beneficio_id = b.id and ob.cta_ctb_id = b.cta_ct_id and ob.evento_id = b.evento_id
            and ob.empresa_id = b.empresa_id and ob.orcamento_id = ?".$condicao[0].") = 0", [$orc_id]
        );
        
        if(count($select) == 0){
            $this->setError("Nenhum Benefício para ser Incrementado. 251120200947");
            return 'warning';
        }
        else{
            foreach($select as $value){
                try{
                    $insert = null;
                    if($tipo_table == 'F'){
                        $insert = DB::insert("INSERT INTO tbl_orc_beneficio(
                            [orcamento_id], [empresa_id], [beneficio_id], [cta_ctb_id], [evento_id], [tipo_calc], [vlr_movto], [formula],
                            [vlr_maximo], [tipo_acesso], [created_at], [created_by], [exclusivo_admissao], [salario_corte], [grade_maximo], [valor_deducao], [periodo], [tipo_table]
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $this->fillCodEmpresa(), $value->beneficio_id, $value->cta_ctb_id, $value->evento_id, $value->tipo_calc, $value->vlr_movto, $value->formula, $value->vlr_maximo, $value->tipo_acesso, $this->fillCriadoEm(), $this->fillCriadoPor(), $value->exclusivo_admissao, $value->salario_corte, $value->grade_maximo, $value->valor_deducao, $periodo, $tipo_table]);
                    }
                    else{
                        $insert = DB::insert("INSERT INTO tbl_orc_beneficio(
                            [orcamento_id], [empresa_id], [beneficio_id], [cta_ctb_id], [evento_id], [tipo_calc], [vlr_movto], [formula],
                            [vlr_maximo], [tipo_acesso], [created_at], [created_by], [exclusivo_admissao], [salario_corte], [grade_maximo], [valor_deducao], [tipo_table]
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $this->fillCodEmpresa(), $value->beneficio_id, $value->cta_ctb_id, $value->evento_id, $value->tipo_calc, $value->vlr_movto, $value->formula, $value->vlr_maximo, $value->tipo_acesso, $this->fillCriadoEm(), $this->fillCriadoPor(), $value->exclusivo_admissao, $value->salario_corte, $value->grade_maximo, $value->valor_deducao, $tipo_table]);
                    }
                    

                    if($insert === false){
                        $this->setError("Falha ao inserir Benefício. Erro: 251120201406");
                        return false;
                    }

                    $select_beneficio_insert = DB::select("SELECT ob.*, e.multiplica FROM tbl_orc_beneficio as ob 
                        inner join tbl_eventos as e on e.id = ob.evento_id
                        where orcamento_id = ? and beneficio_id = ? and ob.evento_id = ? and cta_ctb_id = ?".$condicao[0], [$orc_id, $value->beneficio_id, $value->evento_id, $value->cta_ctb_id]);

                    $valor = $select_beneficio_insert[0]->tipo_calc == 2 ? $select_beneficio_insert[0]->multiplica : $select_beneficio_insert[0]->vlr_movto;

                    $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                        ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                        ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                        [$select_beneficio_insert[0]->id, $this->getModelEntity()->getTable(), $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, 
                        $valor, $valor, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );

                    if($insert_calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201417");
                        return false;
                    }

                    $insert_ind = DB::insert("INSERT INTO [tbl_calc_indice](
                        [origem_id], [tbl_origem], [jan_indice], [fev_indice], [marc_indice], [abril_indice], [maio_indice], [jun_indice]
                        ,[jul_indice], [agost_indice], [set_indice], [out_indice], [nov_indice], [dez_indice], [created_at], [created_by]
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$select_beneficio_insert[0]->id, $this->getModelEntity()->getTable(), 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );

                    if($insert_ind === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201434");
                        return false;
                    }
                }
                catch(\Exception $e){
                    DB::rollBack();
                    $this->setError("Erro ao inserir Benefício. Erro: 251120201427ct ".$e);
                    return false;
                }
            }
            return true;
        }
    }

    public function atualizaOrcBeneficioCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->clearError();
        set_time_limit($this->getTimeOut());

        $condicao[0] = $tipo_table == 'F' ? " and ob.periodo = '{$periodo}' and ob.tipo_table = '{$tipo_table}'" : " and ob.periodo is null and ob.tipo_table = '{$tipo_table}'";
        $condicao[1] = $tipo_table == 'F' ? " and oc.periodo = '{$periodo}' and oc.tipo_table = '{$tipo_table}'" : " and oc.periodo is null and oc.tipo_table = '{$tipo_table}'";
        $condicao[2] = $tipo_table == 'F' ? " and oblc.periodo = '{$periodo}' and oblc.tipo_table = '{$tipo_table}'" : " and oblc.periodo is null and oblc.tipo_table = '{$tipo_table}'";
        $condicao[3] = $tipo_table == 'F' ? " and ol.periodo = '{$periodo}' and ol.tipo_table = '{$tipo_table}'" : " and ol.periodo is null and ol.tipo_table = '{$tipo_table}'";
        $condicao[4] = $tipo_table == 'F' ? " and obf.periodo = '{$periodo}' and obf.tipo_table = '{$tipo_table}'" : " and obf.tipo_table = '{$tipo_table}'";

        $condicao[5] = $tipo_table == 'F' ? " and orf.periodo = '{$periodo}' and orf.tipo_table = '{$tipo_table}'" : " and orf.tipo_table = '{$tipo_table}'";

        $select = DB::select("SELECT 
            ol.id as orc_lotacao_id, oc.id as orc_cargo_id, ob.id as orc_beneficio_id, b.cta_ct_id as cta_ctb_id,
            blc.ccusto_id, b.tipo_calc, blc.vlr_movto, b.vlr_maximo, blc.vlr_depend, b.formula, b.empresa_id, b.valor_deducao, ob.tipo_acesso
            FROM tbl_beneficio_lotacao_cargo as blc
            
            inner join [tbl_orc_lotacao] as ol on ol.lotacao_id = blc.lotacao_id and ol.cc_custo_id = blc.ccusto_id and ol.orcamento_id = $orc_id {$condicao[3]}
            inner join [tbl_beneficio] as b on b.id = blc.beneficio_id
            inner join [tbl_eventos] as e on e.id = b.evento_id
            inner join [tbl_orc_beneficio] as ob on ob.beneficio_id = blc.beneficio_id and ob.orcamento_id = $orc_id {$condicao[0]}
            inner join [tbl_orc_cargo] as oc on oc.cargo_id = blc.cargo_id and oc.orcamento_id = $orc_id {$condicao[1]}
            --inner join [tbl_cargo] as c on c.id = oc.cargo_id
            where (select count(*) from tbl_orc_benef_lot_carg as oblc where oblc.orc_cargo_id = oc.id and oblc.orc_lotacao_id = ol.id and oblc.orc_beneficio_id = ob.id and oblc.cta_ctb_id = b.cta_ct_id and oblc.orcamento_id = $orc_id {$condicao[2] }) = 0
        ");
        
        if(count($select) == 0){
            $this->setError("Nenhum Benefício x Lotação x Cargo para ser Incrementado. 251120201509");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    $insert = null;

                    if($tipo_table == 'F'){
                        $insert = DB::insert("INSERT INTO tbl_orc_benef_lot_carg(
                            [orcamento_id], [orc_lotacao_id], [orc_cargo_id], [orc_beneficio_id], [cta_ctb_id], [ccusto_id], [tipo_calc], [vlr_movto],
                            [vlr_maximo], [vlr_depend], [formula], [user_id], [empresa_id], [created_at], [created_by], [valor_deducao], [tipo_table], [periodo]
                            )VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                        ", [$orc_id, $value->orc_lotacao_id, $value->orc_cargo_id, $value->orc_beneficio_id, $value->cta_ctb_id, $value->ccusto_id, $value->tipo_calc, $value->vlr_movto, $value->vlr_maximo, $value->vlr_depend, $value->formula, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor(), $value->valor_deducao, $tipo_table, $periodo]);
    
                        if($insert === false){
                            $this->setError("Falha ao inserir Benefício x Lotação x Cargo. Erro: 251120201522");
                            return false;
                        }
                    }
                    else{
                        $insert = DB::insert("INSERT INTO tbl_orc_benef_lot_carg(
                            [orcamento_id], [orc_lotacao_id], [orc_cargo_id], [orc_beneficio_id], [cta_ctb_id], [ccusto_id], [tipo_calc], [vlr_movto],
                            [vlr_maximo], [vlr_depend], [formula], [user_id], [empresa_id], [created_at], [created_by], [valor_deducao], [tipo_table]
                            )VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                        ", [$orc_id, $value->orc_lotacao_id, $value->orc_cargo_id, $value->orc_beneficio_id, $value->cta_ctb_id, $value->ccusto_id, $value->tipo_calc, $value->vlr_movto, $value->vlr_maximo, $value->vlr_depend, $value->formula, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor(), $value->valor_deducao, $tipo_table]);
    
                        if($insert === false){
                            $this->setError("Falha ao inserir Benefício x Lotação x Cargo. Erro: 251120201522");
                            return false;
                        }
                    }
                    $insert_calc = null;
                    $insert_ind = null;
                    $grade = DB::select("SELECT LEFT(c.cod_cargo_basic, 2) as grade from tbl_orc_cargo as oc
                        inner join tbl_cargo as c on c.id = oc.cargo_id
                        where oc.id = {$value->orc_cargo_id}
                    ");
                    $valores = [];
                    if($value->tipo_acesso == 3 && $value->tipo_calc != 2){
                        $valores = DB::select("SELECT 
                                ISNULL(AVG(obf.vlr_movto), 0) 'vlr_movto',
                                ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                                ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                                ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                                ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                                ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                                ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                                ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                                ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                                ISNULL(AVG(co.set_orcado), 0) set_orcado,
                                ISNULL(AVG(co.out_orcado), 0) out_orcado,
                                ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                                ISNULL(AVG(co.dez_orcado), 0) dez_orcado
                            from tbl_orc_beneficio_funcionario obf
                            join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id
                            join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                            join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id
                                and (oblc.orc_lotacao_id <> {$value->orc_lotacao_id} and oblc.orc_cargo_id <> {$value->orc_cargo_id} and oblc.orc_beneficio_id = {$value->orc_beneficio_id})
                            where obf.orcamento_id = {$orc_id} and obf.orc_lotacao_id = {$value->orc_lotacao_id} and obf.orc_beneficio_id = {$value->orc_beneficio_id}
                            and orf.orc_cargo_id = {$value->orc_cargo_id} {$condicao[4]}
                        ");

                        if(count($valores) > 0 && $valores[0]->jan_orcado == 0){
                            // SEM OLHAR A LOTAÇÃO
                            $valores = DB::select("SELECT 
                                    ISNULL(AVG(obf.vlr_movto), 0) 'vlr_movto',
                                    ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                                    ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                                    ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                                    ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                                    ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                                    ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                                    ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                                    ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                                    ISNULL(AVG(co.set_orcado), 0) set_orcado,
                                    ISNULL(AVG(co.out_orcado), 0) out_orcado,
                                    ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                                    ISNULL(AVG(co.dez_orcado), 0) dez_orcado
                                from tbl_orc_beneficio_funcionario obf
                                
                                join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id
                                join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                                join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id
                                    and (oblc.orc_lotacao_id <> {$value->orc_lotacao_id} and oblc.orc_cargo_id <> {$value->orc_cargo_id} and oblc.orc_beneficio_id = {$value->orc_beneficio_id})
                                
                                where obf.orcamento_id = {$orc_id} and obf.orc_beneficio_id = {$value->orc_beneficio_id}
                                and orf.orc_cargo_id = {$value->orc_cargo_id} {$condicao[4]}
                            ");
                        }
                        else if(count($valores) > 0 && $valores[0]->vlr_movto == 0){
                            $valores = DB::select("SELECT
                                ISNULL(AVG(obf.vlr_movto), 0) 'vlr_movto',
                                ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                                ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                                ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                                ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                                ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                                ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                                ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                                ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                                ISNULL(AVG(co.set_orcado), 0) set_orcado,
                                ISNULL(AVG(co.out_orcado), 0) out_orcado,
                                ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                                ISNULL(AVG(co.dez_orcado), 0) dez_orcado

                                from tbl_orc_beneficio_funcionario obf
                                join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id {$condicao[5]}
                                join tbl_orc_cargo oc on oc.id = orf.orc_cargo_id
                                join tbl_cargo c on c.id = oc.cargo_id
                                join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                                where obf.orcamento_id = {$orc_id} and obf.orc_beneficio_id = {$value->orc_beneficio_id} and LEFT(c.cod_cargo_basic, 2) = {$grade[0]->grade}
                            ");
                        }
                        else /*if(count($valores) > 0 && $valores[0]->jan_orcado == 0)*/{
                            $valores = DB::select("SELECT 
                                    ISNULL(AVG(ob.vlr_movto), 0) 'vlr_movto',
                                    ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                                    ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                                    ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                                    ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                                    ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                                    ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                                    ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                                    ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                                    ISNULL(AVG(co.set_orcado), 0) set_orcado,
                                    ISNULL(AVG(co.out_orcado), 0) out_orcado,
                                    ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                                    ISNULL(AVG(co.dez_orcado), 0) dez_orcado
                                from tbl_orc_beneficio ob
                                
                                -- join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id
                                -- join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                                -- join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id
                                
                                join tbl_calc_orcamento co on co.origem_id = ob.id and co.tbl_origem = 'tbl_orc_beneficio'
		                        where ob.orcamento_id = {$orc_id} and ob.id = {$value->orc_beneficio_id}
                            ");
                        }


                        $oblc_id = DB::select("SELECT id from tbl_orc_benef_lot_carg as oblc where orcamento_id = {$orc_id} and orc_lotacao_id = {$value->orc_lotacao_id}
                            and orc_cargo_id = {$value->orc_cargo_id} and orc_beneficio_id = {$value->orc_beneficio_id} {$condicao[2]}");

                        if(count($oblc_id) == 0){
                            continue;
                        }

                        // ATUALIZA O VLR_MOVTO E INSERE NA CALC
                        DB::update("UPDATE tbl_orc_benef_lot_carg set vlr_movto = {$valores[0]->vlr_movto} where id = {$oblc_id[0]->id}");

                        $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                            ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                            ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                            [$oblc_id[0]->id, 'tbl_orc_benef_lot_carg', $valores[0]->jan_orcado, $valores[0]->fev_orcado, $valores[0]->mar_orcado, $valores[0]->abr_orcado, $valores[0]->mai_orcado, $valores[0]->jun_orcado, $valores[0]->jul_orcado, $valores[0]->ago_orcado, $valores[0]->set_orcado, $valores[0]->out_orcado, 
                            $valores[0]->nov_orcado, $valores[0]->dez_orcado, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                        );
    
                        if($insert_calc === false){
                            $this->setError("Falha ao inserir registro. Erro: 020320211309");
                            return false;
                        }

                        $insert_ind = DB::insert("INSERT INTO [tbl_calc_indice](
                            [origem_id], [tbl_origem], [jan_indice], [fev_indice], [marc_indice], [abril_indice], [maio_indice], [jun_indice]
                            ,[jul_indice], [agost_indice], [set_indice], [out_indice], [nov_indice], [dez_indice], [created_at], [created_by]
                            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$oblc_id[0]->id, 'tbl_orc_benef_lot_carg', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, $this->fillCriadoEm(), $this->fillCriadoPor()]
                        );

                        if($insert_ind === false){
                            $this->setError("Falha ao inserir registro. Erro: 020320211158");
                            return false;
                        }
                    }
                    else{
                        $select_to_calc = DB::select("SELECT oblc.*, e.multiplica
                            FROM [tbl_orc_benef_lot_carg] as oblc
                        
                            inner join tbl_orc_beneficio as ob on ob.id = oblc.orc_beneficio_id and ob.orcamento_id = {$orc_id} {$condicao[0]}
                            inner join tbl_eventos as e on e.id = ob.evento_id
                            where oblc.orcamento_id = ? and oblc.orc_lotacao_id = ? and oblc.orc_cargo_id = ? and oblc.orc_beneficio_id = ? and oblc.cta_ctb_id = ? {$condicao[2]}", [$orc_id, $value->orc_lotacao_id, $value->orc_cargo_id, $value->orc_beneficio_id, $value->cta_ctb_id]);
    
                        
                        $valor = $select_to_calc[0]->tipo_calc == 2 ? $select_to_calc[0]->multiplica : $select_to_calc[0]->vlr_movto;
    
                        $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                            ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                            ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                            [$select_to_calc[0]->id, 'tbl_orc_benef_lot_carg', $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, 
                            $valor, $valor, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                        );
    
                        if($insert_calc === false){
                            $this->setError("Falha ao inserir registro. Erro: 251120201533");
                            return false;
                        }
    
                        $insert_ind = DB::insert("INSERT INTO [tbl_calc_indice](
                            [origem_id], [tbl_origem], [jan_indice], [fev_indice], [marc_indice], [abril_indice], [maio_indice], [jun_indice]
                            ,[jul_indice], [agost_indice], [set_indice], [out_indice], [nov_indice], [dez_indice], [created_at], [created_by]
                            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$select_to_calc[0]->id, 'tbl_orc_benef_lot_carg', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, $this->fillCriadoEm(), $this->fillCriadoPor()]
                        );
    
                        if($insert_ind === false){
                            $this->setError("Falha ao inserir registro. Erro: 251120201533");
                            return false;
                        }
                    }
                }
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Erro ao inserir registros. Erro: 251120201534ct ".$e->getMessage()." ---- ".$e);
                return false;
            }
            return true;
        }
    }

    public function atualizaOrcBeneficioFuncionario($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->clearError();
        set_time_limit($this->getTimeOut());
        
        $condicao[0] = $tipo_table == 'F' ? " and ob.periodo = '{$periodo}' and ob.tipo_table = '{$tipo_table}'" : " and ob.periodo is null and ob.tipo_table = '{$tipo_table}'";
        $condicao[1] = $tipo_table == 'F' ? " and obf.periodo = '{$periodo}' and obf.tipo_table = '{$tipo_table}'" : " and obf.periodo is null and obf.tipo_table = '{$tipo_table}'";
        $condicao[2] = $tipo_table == 'F' ? " and ol.periodo = '{$periodo}' and ol.tipo_table = '{$tipo_table}'" : " and ol.periodo is null and ol.tipo_table = '{$tipo_table}'";
        // $condicao[2] = $tipo_table == 'F' ? " and ob.periodo = '{$periodo}' and ob.tipo_table = '{$tipo_table}'" : " and ob.periodo is null and ob.tipo_table = '{$tipo_table}'";
        
        $select = DB::select("SELECT bf.funcionario_id, ol.id as orc_lotacao_id, bf.ccusto_id, ob.id as orc_beneficio_id, b.tipo_calc, b.vlr_movto, b.vlr_maximo, ob.vlr_depend, b.formula, b.cta_ct_id FROM tbl_beneficio_funcionario as bf

            inner join tbl_funcionario as f on f.id = bf.funcionario_id and f.dat_demis_func is null
            inner join tbl_orc_lotacao as ol on ol.lotacao_id = bf.lotacao_id and ol.cc_custo_id = bf.ccusto_id and ol.orcamento_id = {$orc_id} {$condicao[2]}
            inner join tbl_orc_beneficio as ob on ob.beneficio_id = bf.beneficio_id and ob.orcamento_id = {$orc_id} {$condicao[0]}
            inner join tbl_beneficio as b on b.id = bf.beneficio_id
            inner join tbl_eventos as ev on ev.id = b.evento_id
            
            where (select count(*) from tbl_orc_beneficio_funcionario as obf where obf.funcionario_id = bf.funcionario_id
            and obf.orc_lotacao_id = ol.id
            and obf.ccusto_id = ol.cc_custo_id
            and obf.cta_ctb_id = ob.cta_ctb_id
            and obf.orc_beneficio_id = ob.id {$condicao[1]}) = 0"
        );
        
        if(count($select) == 0){
            $this->setError("Nenhum Benefício x Funcionário para ser Incrementado. 251120201625");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    $insert = null;
                    if($tipo_table == 'F'){
                        $insert = DB::insert("INSERT INTO tbl_orc_beneficio_funcionario(
                            [orcamento_id],
                            [funcionario_id],
                            [orc_lotacao_id],
                            [ccusto_id],
                            [cta_ctb_id],
                            [orc_beneficio_id],
                            [tipo_calc],
                            [vlr_movto],
                            [vlr_maximo],
                            [vlr_depend],
                            [formula],
                            [created_at],
                            [user_id],
                            [empresa_id],
                            [created_by],
                            [tipo_table],
                            [periodo]
                            )values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $value->funcionario_id, $value->orc_lotacao_id, $value->ccusto_id, $value->cta_ct_id, $value->orc_beneficio_id, $value->tipo_calc, $value->vlr_movto, $value->vlr_maximo, $value->vlr_depend, $value->formula, $this->fillCriadoEm(), $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoPor(), $tipo_table, $periodo]
                        );
                    }
                    else{
                        $insert = DB::insert("INSERT INTO tbl_orc_beneficio_funcionario(
                            [orcamento_id],
                            [funcionario_id],
                            [orc_lotacao_id],
                            [ccusto_id],
                            [cta_ctb_id],
                            [orc_beneficio_id],
                            [tipo_calc],
                            [vlr_movto],
                            [vlr_maximo],
                            [vlr_depend],
                            [formula],
                            [created_at],
                            [user_id],
                            [empresa_id],
                            [created_by],
                            [tipo_table]
                            )values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $value->funcionario_id, $value->orc_lotacao_id, $value->ccusto_id, $value->cta_ct_id, $value->orc_beneficio_id, $value->tipo_calc, $value->vlr_movto, $value->vlr_maximo, $value->vlr_depend, $value->formula, $this->fillCriadoEm(), $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoPor(), $tipo_table]
                        );
                    }
                    

                    if($insert === false){
                        $this->setError("Falha ao inserir dados. Erro: 251120201642");
                        return false;
                    }

                    $select_calc = DB::select("SELECT obf.id, obf.tipo_calc, e.multiplica, b.vlr_movto FROM tbl_orc_beneficio_funcionario as obf
                    inner join tbl_orc_beneficio as ob on ob.id = obf.orc_beneficio_id and ob.orcamento_id = {$orc_id}
                    inner join tbl_beneficio as b on b.id = ob.beneficio_id
                    inner join tbl_eventos as e on e.id = ob.evento_id
                    where obf.orcamento_id = ? and obf.funcionario_id = ? and obf.orc_lotacao_id = ? and obf.ccusto_id = ? and obf.cta_ctb_id = ? and obf.orc_beneficio_id = ? {$condicao[1]}", [$orc_id, $value->funcionario_id, $value->orc_lotacao_id, $value->ccusto_id, $value->cta_ct_id, $value->orc_beneficio_id]);

                    $valor = $select_calc[0]->tipo_calc == 2 ? $select_calc[0]->multiplica : $select_calc[0]->vlr_movto;

                    $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                        ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                        ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                        [$select_calc[0]->id, 'tbl_orc_beneficio_funcionario', $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, $valor, 
                        $valor, $valor, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );

                    if($insert_calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201648");
                        return false;
                    }

                    $insert_ind = DB::insert("INSERT INTO [tbl_calc_indice](
                        [origem_id], [tbl_origem], [jan_indice], [fev_indice], [marc_indice], [abril_indice], [maio_indice], [jun_indice]
                        ,[jul_indice], [agost_indice], [set_indice], [out_indice], [nov_indice], [dez_indice], [created_at], [created_by]
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$select_calc[0]->id, 'tbl_orc_beneficio_funcionario', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );

                    if($insert_ind === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201652");
                        return false;
                    }
                }
                
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Erro ao inserir Benefício x Funcionário. Erro: 251120201627ct ".$e->getMessage());
                return false;
            }
            return true;
        }
    }
}

