<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

use App\Modules\Natureza51\Entities\OrcBonus;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;

use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto;


use Illuminate\Support\Facades\DB;

class RepoOrcBonus extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcBonus';
    protected $form_rules=[];
    protected $rules_msg=[]; 


    public function listar($orc_id, $periodo = null, $tipo_table = 'O'){
        
        // $orc_bonus = new OrcBonus(); 
        // $lotCcusto = new LotacaoCCusto();
        // $tb_orc_cargo = new OrcCargo();
        // $tb_orc_lotac = new OrcLotacao();
        // $tb_cargo = new Cargo();
        // $tb_lotac = new Lotacao();
        // $data = $orc_bonus
        // ->leftJoin($tb_orc_cargo->getTable(),$orc_bonus->getColunaAlias('cargo_id'),$tb_orc_cargo->getColunaAlias('id'))
        // ->leftJoin($tb_cargo->getTable(),$tb_orc_cargo->getColunaAlias('cargo_id'),$tb_cargo->getColunaAlias('id'))
        // ->leftjoin($lotCcusto->getTable(),$orc_bonus->getColunaAlias('ccusto_id'),$lotCcusto->getColunaAlias('ccusto_id'))
        // ->select(
        //     $orc_bonus->getColunaAlias('id'),
        //     $orc_bonus->getColunaAlias('porcentagem'),
        //     $orc_bonus->getColunaAlias('orc_id') ,
        //     $orc_bonus->getColunaAlias('ccusto_id'),
        //     $orc_bonus->getColunaAlias('updated_at'),
        //     DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, ccusto_id+null as parent'),
        //     $orc_bonus->getColunaAlias('num_sal') ,
        //     $tb_cargo->getColunaAlias('cod_cargo_basic'), 
        //     $tb_cargo->getColunaAlias('des_cargo_basic'),
        //     $lotCcusto->getColunaAlias('lotacao_id'),
        //     $lotCcusto->getColunaAlias('unid_lotac'))

        // ->where('orc_id',$orc_id)
        // ->get()
        // ->toArray(); 
        
        // return $data;
        $condicao[0] = $tipo_table == 'F' ? " and ob.tipo_table = '{$tipo_table}' and ob.periodo = '{$periodo}'" : " and ob.tipo_table = '{$tipo_table}' and ob.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        $data = DB::select("SELECT
            ob.id as id,
            ol.id as orc_lotacao_id,
            concat(cc.cod_ccusto, ' - ', l.unid_lotac, ' - ', l.des_unid_lotac) as lotacao,
            LEFT(c.cod_cargo_basic, 2) as grade_sal,
            ol.cc_custo_id+null as parent,
            c.des_cargo_basic as cargo,
            c.cod_cargo_basic as cod_cargo,
            ob.num_sal,
            ob.porcentagem,

            CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,
            CASE WHEN ob.created_at IS NOT NULL THEN format(ob.created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,
            
            CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por,
            CASE WHEN ob.updated_at IS NOT NULL THEN format(ob.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em
    
        from tbl_orc_bonus as ob
        join tbl_orc_cargo oc on oc.id = ob.cargo_id {$condicao[1]}
		join tbl_cargo c on c.id = oc.cargo_id
        join tbl_orc_lotacao ol on ol.id = ob.orc_lot_id
        join tbl_lotacao l on l.id = ol.lotacao_id
        join tbl_ccusto cc on cc.id = ol.cc_custo_id

        left join institb_usuario as usuario1 on usuario1.id = ob.created_by
        left join institb_usuario as usuario2 on usuario2.id = ob.updated_by
        where ob.orc_id = $orc_id {$condicao[0]}
        order by c.cod_cargo_basic ASC");

        return $data;
    }

    public function insert($orc_id, $data ){
      
        $diff_inser_up = $this->existInOrcBonus($orc_id,$data);
  
        DB::beginTransaction();
       
        try{ 

                foreach($diff_inser_up['update'] as $k=>$data_up){
                   
                    $data_update = [
                        'porcentagem'=>$data['porcentagem'],
                        'num_sal'=>$data['num_sal']
                    ];

                    if($k > 0){
                        $this->makeModel();
                    }

                    if(!$this->update($data_update, ['id'=>$data_up])){ 
                        // $this.getErrosFlatted();                             
                        $this->setError('Falha ao fazer update do registro. Erro: 080120202008 ' .$this.getErrosFlatted());
                        DB::rollBack();
                        // dd("update --".$k, $this->getErrosFlatted());
                        return false;                        
                    }
                }
                
                foreach($diff_inser_up['insert'] as $k => $data_up){

                    $this->makeModel();
                    
                    $insert = OrcBonus::insert([
                        'orc_id'=>$orc_id,
                        'ccusto_id'=>$data['ccusto_id'],
                        'cargo_id'=>$data['cargo_id'],
                        'porcentagem'=>$data['porcentagem'],
                        'num_sal'=>$data['num_sal']
                        // 'cargo_id'=>$data_up
                    ]);                    

                    if(!$insert){                         
                        $this->setError('Falha ao fazer insert do registro. Erro: 080120202010 ' .$this.getErrosFlatted());
                        DB::rollBack();
                        return false;  
                    }
                }                

            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 080120201624.');
        }
        
        return array('msg'=>"Cadastro Realizado com Sucesso",'status'=>"success");
    }
  
    public function getCargoByGrade($grades,$orc_id){
        // dd('dsdsd');
            $cargo = New Cargo(); 
            $orc_cargo = new OrcCargo();
        $result= $orc_cargo->leftJoin(
            $cargo->getTable(),
            $orc_cargo->getColunaAlias('cargo_id'),
            $cargo->getColunaAlias('id')
        )->where($orc_cargo->getColunaAlias('orcamento_id'),$orc_id)
        ->where(function ($query) use($grades) {
            for ($i = 0; $i < count($grades); $i++){
                 $query=$query->orwhere('cod_cargo_basic', 'like',  $grades[$i].'%');
            }
        
        })->select(
            DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, null as parent'),
            $cargo->getColunaAlias('cod_cargo_basic'),
            $cargo->getColunaAlias('des_cargo_basic'),
            $cargo->getColunaAlias('salario'),
            $orc_cargo->getColunaAlias('id'),
            DB::raw($orc_cargo->getColunaAlias('id').' as cargo_id')
        )
        ->get()
        ->toArray(); 
        
        // dd($result);
        return $result;
    } 

    public function existInOrcBonus($orc_id,$data, $op=false){ 
        
        if(isset($data['cargo_id'])) {
             $array_cargo_id = $data['cargo_id'];
        }
        
        if(!$op){             
            
            $data_grade = $this->getCargoByGrade($data['grade_salarial'],$orc_id);

            $array_cargo_id = array_column($data_grade, 'id');            
        }         
        
        $orc_bonus = $this->getModelEntity();
        
        $upadate = $orc_bonus->select(
            $orc_bonus->getColunaAlias('id'),
            $orc_bonus->getColunaAlias('cargo_id')
        )
        ->where($orc_bonus->getColunaAlias('orc_id'),$orc_id)
        ->whereIn(                
                $orc_bonus->getColunaAlias('cargo_id'), $array_cargo_id
        )
        ->get();
        
        $insert = array_diff($array_cargo_id, ($to_update=$upadate->pluck('cargo_id')->toArray()));
        
        $orc_bonus_insert = array(
                "update" => $upadate->pluck('id')->toArray(),
                "insert" => $insert               
        );
        
        return $orc_bonus_insert;
    }

    public function updateBonus($orc_id, $data){
           
        DB::beginTransaction();
       
        try{
            
            $data_update = [
                'porcentagem'=>$data['porcentagem'], 'num_sal'=>$data['num_sal']
            ];
            monetarioVirgula($data_update['porcentagem']);
            monetarioVirgula($data_update['num_sal']);

            if(!$this->update($data_update, ['id'=>$data['id']])){ 
                $this->setError('Falha ao fazer update do registro. Erro: 080120202008 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;                        
            }
                
               
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 210520200825.');
        }
        
        return array('msg'=>"Registro atualizado com Sucesso",'status'=>"success");;
    }

    public function deleteBonus($orc_id,$data){
        // dd("DATA DELETE BONUS", $data);
        // $instance = $this;

        // $result = OrcBonus::where([
        //     ['id', $data['id']],
        //     ['orc_id', $orc_id]
        // ])->first();
        
        // if(is_null($result)){
        //     $this->setError('Este registro não existe no orçamento. Erro: 100120200934 ');            
        //     return false;
        // }

        // DB::beginTransaction();
       
        // try{
             
        //     if(!$instance->deleteParent($data['id'])){  
        //         // dd("dddd2",$data,$orc_id);
        //         $this->setError('Falha ao deletar o registro. Erro: 100120200937 ' .$this->getErrosFlatted());
        //         DB::rollBack();
        //         return false;                                  
        //     }
        //     $this->makeModel();
        //     DB::commit();
                
        //     } catch (Exception $ex) {
        //         DB::rollBack();
        //         abort(500,'Falha ao atualizar . Erro: 080120201624.');
        // }
        
        // return array('msg'=>"Registro deletado com sucesso",'status'=>"success");


        $instance = $this;

        $result = OrcBonus::where([
            ['id', $data['id']],
            ['orc_id', $orc_id]
        ])->first();
        
        if(is_null($result)){
            $this->setError('Este registro não existe no orçamento. Erro: 250520201006 ');            
            return false;
        }

        DB::beginTransaction();
       
        try{
            
            if(!$instance->delete($data['id'])){  
                $this->setError('Falha ao deletar o registro. Erro: 250520201007 ' .$this->getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 250520201008.');
        }
        
        $this->makeModel();
        return array('msg'=>"Registro deletado com sucesso",'status'=>"success");





    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    } 

    public function atualizaBonus($orc_id, $periodo = null, $tipo_table = 'O'){
        /* MESMO ESQUEMA DO PR */
        $this->clearError();
        set_time_limit(700);

        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}' " : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}' " : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        $condicao[2] = $tipo_table == 'F' ? " and bo.tipo_table = '{$tipo_table}' and bo.periodo = '{$periodo}' " : " and bo.tipo_table = '{$tipo_table}' and bo.periodo is null";

        $select = DB::select("SELECT ocas.cargo_id as orc_cargo_id, ocas.lotacao_id, ocas.ccusto_id,
            substring(cast(c.cod_cargo_basic as varchar), 1, 2) as grade
            from tbl_orc_cargos_area_sal as ocas
                    
            inner join tbl_orc_cargo as oc on oc.id = ocas.cargo_id and oc.orcamento_id = {$orc_id} {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
                    
            where ocas.orcamento_id = {$orc_id} {$condicao[0]}
            and (select count(*) from tbl_orc_bonus as bo where bo.orc_id = {$orc_id} and bo.orc_lot_id = ocas.lotacao_id and bo.cargo_id = ocas.cargo_id {$condicao[2]}) = 0
                    
            order by c.cod_cargo_basic asc"
        );
        
        if(count($select) == 0){
            $this->setError("Nenhum cargo encontrado. 261120201514");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    $dados = $this->getOrcCargoByGrade($orc_id, $value->grade, $periodo, $tipo_table);
                    
                    if($dados == true){
                        
                        $insert = DB::insert("INSERT INTO tbl_orc_bonus(orc_id, cargo_id, ccusto_id, orc_lot_id, num_sal, porcentagem, created_at, created_by, tipo_table, periodo)values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $value->orc_cargo_id, $value->ccusto_id, $value->lotacao_id, $dados->num_sal, $dados->porcentagem, $this->fillCriadoEm(), $this->fillCriadoPor(), $tipo_table, $periodo]
                        );

                        if($insert === false){
                            $this->setError("Falha ao inserir registro. Erro: 261120201631");
                            return false;
                        }
                    }
                    continue;
                }
            }
            catch(\Exception $e){
                // DB::rollBack();
                $this->setError("Erro ao inserir registro. Erro: 261120201631ct ", $e);
                return false;
            }
            return true;
        }
    }
    public function getOrcCargoByGrade($orc_id, $grade, $periodo = null, $tipo_table = 'O'){
        $condicao[0] = $tipo_table == 'F' ? " and bo.tipo_table = '{$tipo_table}' and bo.periodo = '{$periodo}'" : " and bo.tipo_table = '{$tipo_table}' and bo.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $select = DB::select("SELECT top(1) bo.* from tbl_orc_bonus as bo

            inner join tbl_orc_cargo as oc on oc.id = bo.cargo_id {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
            
            where oc.orcamento_id = {$orc_id} and bo.orc_id = {$orc_id} and SUBSTRING(cast(c.cod_cargo_basic as varchar), 1, 2) = {$grade}".$condicao[0]    
        );

        return count($select) == 0 ? false : $select[0];
    }
}
