<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoCargo;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto as LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use \App\Core\Traits\ErrorTrait;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\OrcDissidio;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;       

use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\DB as FacadesDB;

class RepoOrcCargo extends RepoOrcamento
{    
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCargo';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        
        parent::__construct();
    }
    public function listAll($orc_id, $periodo = null, $tipo_table = 'O'){
        
        DB::enableQueryLog();

        $repo_calc_orcamento= new RepoCalcOrcamento();
        $tbl_usuario = new Usuario(); 
        
        $cargo_sal = null;

        if($tipo_table == 'F'){
            $cargo_sal = $this->getModelEntity()
            ->leftJoin(
                $repo_calc_orcamento->getModelEntity()->getTable(), $this->getModelEntity()->getColunaAlias('id'), '=',
                DB::raw("{$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id')} and 
                {$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'
            "))
    
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
    
            ->with([
                'getCargo'=>function($query){    
                }
            ])           
            ->where([
                ['orcamento_id','=', $orc_id],
                ['tipo_table', '=', $tipo_table],
                ['periodo', '=', $periodo]
            ])
               
            ->select(
                $this->getModelEntity()->getColunaAlias('id'),
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),
                //$this->getModelEntity()->getColunaAlias('sal_base'),
                DB::raw("format({$this->getModelEntity()->getColunaAlias('sal_base')}, 'N', 'pt-br') AS sal_base"),
                $this->getModelEntity()->getColunaAlias('sal_max'),
                $this->getModelEntity()->getColunaAlias('sal_med'),
                $this->getModelEntity()->getColunaAlias('sal_min'),
                $this->getModelEntity()->getColunaAlias('data_calc'),
                $this->getModelEntity()->getColunaAlias('grupo_salarial'),
                $this->getModelEntity()->getColunaAlias('created_at'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('updated_at'),
                DB::raw($repo_calc_orcamento->getModelEntity()->getColunaAlias('id').' AS id_calc'),
    
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jan_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('fev_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('mar_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('abr_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('mai_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jun_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jul_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('ago_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('set_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('out_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('nov_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('dez_orcado'),
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
            )->get();
        }
        else{

        
            $cargo_sal = $this->getModelEntity()
            ->leftJoin(
                $repo_calc_orcamento->getModelEntity()->getTable(), $this->getModelEntity()->getColunaAlias('id'), '=',
                DB::raw("{$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id')} and 
                {$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'
            "))

            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )

            ->with([
                'getCargo'=>function($query){    
                }
            ])           
            ->where([
                [ $this->getModelEntity()->getColunaAlias('orcamento_id'),'=', $orc_id],
                [ $this->getModelEntity()->getColunaAlias('tipo_table'), '=', $tipo_table]
            ])
            ->whereNull($this->getModelEntity()->getColunaAlias('periodo'))
            
            ->select(
                $this->getModelEntity()->getColunaAlias('id'),
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),
                //$this->getModelEntity()->getColunaAlias('sal_base'),
                DB::raw("format({$this->getModelEntity()->getColunaAlias('sal_base')}, 'N', 'pt-br') AS sal_base"),
                $this->getModelEntity()->getColunaAlias('sal_max'),
                $this->getModelEntity()->getColunaAlias('sal_med'),
                $this->getModelEntity()->getColunaAlias('sal_min'),
                $this->getModelEntity()->getColunaAlias('data_calc'),
                $this->getModelEntity()->getColunaAlias('grupo_salarial'),
                $this->getModelEntity()->getColunaAlias('created_at'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('updated_at'),
                DB::raw($repo_calc_orcamento->getModelEntity()->getColunaAlias('id').' AS id_calc'),

                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jan_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('fev_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('mar_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('abr_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('mai_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jun_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('jul_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('ago_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('set_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('out_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('nov_orcado'),
                $repo_calc_orcamento->getModelEntity()->getColunaAlias('dez_orcado'),
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
            )->get();
        }

        if(!($orc = $cargo_sal->first())){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
            return false;
        }

        $orc_f=$orc->getOrcamento();
        
        if(!$orc_f){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191803']);
            return false;
        }
        $sql=DB::getQueryLog();

        $atual=$orc_f->first();
        
        if(!$atual){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191804']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has()===false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191635']);
            return false;
        }
        if($this->isOwn()===false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 031220191637']);
            return false;
        }
        
        if(!$orc){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
               
        foreach ($cargo_sal as $i => $cargo) {
            if(!$cargo_sal[$i]->getCargo){
                continue;
            }
            
            $cargo_sal[$i]['cod_cargo_basic'] = $cargo_sal[$i]->getCargo->cod_cargo_basic;
            $cargo_sal[$i]['des_cargo_basic'] = $cargo_sal[$i]->getCargo->des_cargo_basic;
            
            $cargo_sal[$i]['atualizado_data'] = formataData($cargo_sal[$i]->updated_at);
            $cargo_sal[$i]['criado_data'] = formataData($cargo_sal[$i]->created_at);

            Arr::forget($cargo_sal[$i], ['getCargo','getUsuarioCreated']);
        }   
        
        return $cargo_sal->count() == 0 ? []: $cargo_sal;
       
    }
    public function listarIndices($orc_id){
        $tbl_calc_indice = new CalcIndice();
        $tbl_cargo = new Cargo();

        $dados = $this->getModelEntity()
        ->leftJoin($tbl_calc_indice->getTable(),$this->getModelEntity()->getColunaAlias('id'),$tbl_calc_indice->getColunaAlias('origem_id'))

        ->leftJoin($tbl_cargo->getTable(), $this->getModelEntity()->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))
        ->select(
                $this->getModelEntity()->getColunaAlias('id'),
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),

                $tbl_cargo->getColunaAlias('cod_cargo_basic'),
                $tbl_cargo->getColunaAlias('des_cargo_basic'),
                
                DB::raw("format({$this->getModelEntity()->getColunaAlias('sal_base')}, 'N', 'pt-br') AS sal_base"),
                $this->getModelEntity()->getColunaAlias('sal_max'),
                $this->getModelEntity()->getColunaAlias('sal_med'),
                $this->getModelEntity()->getColunaAlias('sal_min'),
                $this->getModelEntity()->getColunaAlias('data_calc'),
                $this->getModelEntity()->getColunaAlias('grupo_salarial'),
                DB::raw($tbl_calc_indice->getColunaAlias('id').' AS id_calc'),

                $tbl_calc_indice->getColunaAlias('jan_indice'),
                $tbl_calc_indice->getColunaAlias('fev_indice'),
                $tbl_calc_indice->getColunaAlias('marc_indice'),
                $tbl_calc_indice->getColunaAlias('abril_indice'),
                $tbl_calc_indice->getColunaAlias('maio_indice'),
                $tbl_calc_indice->getColunaAlias('jun_indice'),
                $tbl_calc_indice->getColunaAlias('jul_indice'),
                $tbl_calc_indice->getColunaAlias('agost_indice'),
                $tbl_calc_indice->getColunaAlias('set_indice'),
                $tbl_calc_indice->getColunaAlias('out_indice'),
                $tbl_calc_indice->getColunaAlias('nov_indice'),
                $tbl_calc_indice->getColunaAlias('dez_indice')
        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_calc_indice->getColunaAlias('tbl_origem'),'=','tbl_orc_cargo']

        ])
        ->get()->toArray();

        for($i=0;$i<count($dados);$i++){
            $dados[$i]['identificador']="1";
        }

        return $dados;

    }
    public function createOrcCargoIndice(array $dados){
        
        $this->clearError();

        $tb_calc_indice=new CalcIndice();
        //dd($dados);
        if(isset($dados['meses_orcado'])==false){
            $this->setError('Preencha os meses');
            return false;
        }
        $select=$this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('cargo_id'),'=',$dados['cargo_id']],
                [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']]
            ])->get()->toArray();

        if(count($select)>0){
            $this->setError('Registro já cadastrado');
            return false;
        }
        
        $dados_cargo=Arr::except($dados,['meses_orcado','tipo_meses','lotacao_id']);
        
        DB::beginTransaction();
        try{
            
            //dd($salvou = $this->create($dados_cargo));
            $salvou = $this->create($dados_cargo);
            if(!$salvou){
                return false;
            }
            
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['meses_orcado']['jan_orcado'],
            'fev_indice'=>$dados['meses_orcado']['fev_orcado'],
            'marc_indice'=>$dados['meses_orcado']['mar_orcado'],
            'abril_indice'=>$dados['meses_orcado']['abr_orcado'],
            'maio_indice'=>$dados['meses_orcado']['mai_orcado'],
            'jun_indice'=>$dados['meses_orcado']['jun_orcado'],
            'jul_indice'=>$dados['meses_orcado']['jul_orcado'],
            'agost_indice'=>$dados['meses_orcado']['ago_orcado'],
            'set_indice'=>$dados['meses_orcado']['set_orcado'],
            'out_indice'=>$dados['meses_orcado']['out_orcado'],
            'nov_indice'=>$dados['meses_orcado']['nov_orcado'],
            'dez_indice'=>$dados['meses_orcado']['dez_orcado'],
        );
            //dd($dados_indice);
            $salvar_indice=$tb_calc_indice->create($dados_indice);
    
            if(!$salvar_indice){
                $this->setError('Falha ao inserir indices. Erro: 010420200908');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 010420200908.'.$ex);
       }
       return true;
    }

    public function createOrc(array $dados, $call_back_success=null, $call_ball_error=null){
        $periodo = $dados['periodo'];
        $cargo = [];

        if($dados['tipo_table'] == 'F'){
            $cargo = $this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $dados['orcamento_id']],
                [$this->getModelEntity()->getColunaAlias('cargo_id'), '=', $dados['cargo_id']],
                [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $dados['tipo_table']],
                [$this->getModelEntity()->getColunaAlias('periodo'), '=', $periodo],
            ])->get()->toArray();
        }
        else{
            $cargo = $this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $dados['orcamento_id']],
                [$this->getModelEntity()->getColunaAlias('cargo_id'), '=', $dados['cargo_id']],
                [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $dados['tipo_table']]
            ])
            ->whereNull($this->getModelEntity()->getColunaAlias('periodo'))
            ->get()->toArray();
        }
        
        if(count($cargo)>0){
            $this->setError("Registro já existente. Erro: 080420201452");
            return false;
        }
        else{
            if(!$this->insereCalcOrcCargo($dados)){
                $this->setError('Não foi possível inserir os valores absolutos. Erro:080420201459');
                return false;
            }
            return true;
        }
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
        
    } 

    public function insereCalcOrcCargo(array $dados){
            $this->clearError(); 
       
       /**
         * ======= Verificar novamente estás validações. Não está fazendo sentido. Samuel Domingos de Lima =====
         */
        
        
            /*$orc= $this->getModelEntity()->select()->where([
                ['orcamento_id','=', $dados['orcamento_id']],
                ['cargo_id','=',$dados['cargo_id']],
            ])->get()->toArray();
            
            if(count($orc)!=0){
                $this->setError('Registro já cadastrado','Erro: 090320201331');
                return false;
            } 
            if(!$dados['orcamento_id']){
                $this->setError(['Informe um orçamento','Erro: 280120201210']);
                return false;
            }
            if(isset($dados['meses_orcado'])==false){
                $this->setError('Preencha os meses');
                return false;
            }*/            
             
            // if($this->setOrcamento($orc->getOrcamento()->first())->canEdit()===false){
            //     $this->setError('O estado do orçamento não permite este tipo de operação.', 'Erro: 021220191837');
            //     return false;
            // }
            

       DB::beginTransaction();
       
       try{

            $dados['sal_base'] = floatval($dados['sal_base']);
            $dados['sal_med'] = floatval($dados['sal_med']);
            $dados['sal_min'] = floatval($dados['sal_min']);
            $dados['sal_max'] = floatval($dados['sal_max']);
			
            $salvou = $this->create($dados);

            if(!$salvou){
                return false;
            }
            $dados_env = floatval($dados['meses_orcado']);
            $dados['meses_orcado']['jan_orcado'] = floatval($dados['meses_orcado']['jan_orcado']);
            $dados['meses_orcado']['fev_orcado'] = floatval($dados['meses_orcado']['fev_orcado']);
            $dados['meses_orcado']['mar_orcado'] = floatval($dados['meses_orcado']['mar_orcado']);
            $dados['meses_orcado']['abr_orcado'] = floatval($dados['meses_orcado']['abr_orcado']);

            $dados['meses_orcado']['mai_orcado'] = floatval($dados['meses_orcado']['mai_orcado']);
            $dados['meses_orcado']['jun_orcado'] = floatval($dados['meses_orcado']['jun_orcado']);
            $dados['meses_orcado']['jul_orcado'] = floatval($dados['meses_orcado']['jul_orcado']);
            $dados['meses_orcado']['ago_orcado'] = floatval($dados['meses_orcado']['ago_orcado']);

            $dados['meses_orcado']['set_orcado'] = floatval($dados['meses_orcado']['set_orcado']);
            $dados['meses_orcado']['out_orcado'] = floatval($dados['meses_orcado']['out_orcado']);
            $dados['meses_orcado']['nov_orcado'] = floatval($dados['meses_orcado']['nov_orcado']);
            $dados['meses_orcado']['dez_orcado'] = floatval($dados['meses_orcado']['dez_orcado']);

            
            $dados_env = $dados['meses_orcado'];

            $repo_calc_orc=new RepoCalcOrcamento();
            $salvou_calc= $repo_calc_orc->create(array_merge(
                $dados_env,["origem_id"=>$salvou->id,
                "tbl_origem"=>$this->getModelEntity()->getTable()]));

            if($salvou_calc == false){
                $this->setError([$repo_calc_orc->getErrosFlatted(),'Erro: 021220191908']);
                DB::rollBack();
                return false;
            }

            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
       }
        return $salvou;
    }

    public function insereIndice($id,$dados){
        $tbl_calc_indice=new CalcIndice();
        //dd($dados);
        $dados = $dados['meses_orcado'];
        $dados_indice=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['jan_orcado'],
            'fev_indice'=>$dados['fev_orcado'],
            'marc_indice'=>$dados['mar_orcado'],
            'abril_indice'=>$dados['abr_orcado'],
            'maio_indice'=>$dados['mai_orcado'],
            'jun_indice'=>$dados['jun_orcado'],
            'jul_indice'=>$dados['jul_orcado'],
            'agost_indice'=>$dados['ago_orcado'],
            'set_indice'=>$dados['set_orcado'],
            'out_indice'=>$dados['out_orcado'],
            'nov_indice'=>$dados['nov_orcado'],
            'dez_indice'=>$dados['dez_orcado']
        );
        //$dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            $this->setError('Erro ao inserir índices.');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();
        
        $data= $data['meses_orcado'];
        
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
        $inseriu=$calc_orcamento->create($orcamento);
        //dd($inseriu);
        if(!$inseriu)
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
      }

    public function updateOrcCargoIndice($form_data){
        $tbl_calc_indice = new RepoCalcIndice();
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        
        $id = $form_data['id_calc'];

        $update = $tbl_calc_indice->update($meses,$id);
        if(!$update){
            $this->setError('Erro ao atualizar registro');
            return false;
        }
        return true;
    }

    public function updateOrc($data_request){        
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

			monetarioVirgula($data_request['sal_base']);
            monetarioVirgula($data_request['sal_max']);
			monetarioVirgula($data_request['sal_med']);
			monetarioVirgula($data_request['sal_min']);
            
            $sem_meses=Arr::only($data_request,['id','id_calc','cargo_id','cod_cargo_basic','des_cargo_basic','orcamento_id','sal_base','sal_max','sal_med','sal_min','data_calc']);
            if($sem_meses['sal_base']==""){
                $sem_meses['sal_base']="0";
            }
            if($sem_meses['sal_max']==""){
                $sem_meses['sal_max']="0";
            }
            if($sem_meses['sal_med']==""){
                $sem_meses['sal_med']="0";
            }
            if($sem_meses['sal_min']==""){
                $sem_meses['sal_min']="0";
            }

            
            if(!$instance->updateParent($sem_meses, $sem_meses['id'])){ 
                                   
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            } 

            $meses = $this->dataFilterMesesCalcOrcamento($data_request); 
            $meses = convertDecimalEn($meses);
            
            $calc_orcamento_id= $this->getModelEntity()
            ->join($repo_calc_orcamento->getModelEntity()->getTable(), $this->getModelEntity()->getColunaAlias('id'),'=',

            DB::raw("{$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id')} and 
            {$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'
            "))      

            ->where([
                ['origem_id', $data_request['id']],
                ['tbl_origem', $this->getModelEntity()->getTable()]

            ])->first();
            
            if(!$calc_orcamento_id){
                $salvou_calc = $repo_calc_orcamento->create(array_merge($meses,["origem_id"=> $data_request['id'], "tbl_origem"=>$this->getModelEntity()->getTable()]));

                if($salvou_calc==false){
                    $this->setError([$repo_calc_orcamento->getErrosFlatted(),'Erro: 070120200959']);
                    $retorno = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
                return $retorno;
            }

            if(! $repo_calc_orcamento->update($meses, $calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function updateParent($data_request, $id){
        return parent::update($data_request, $id);
    }

    public function listarCargo($orc_id){
        $repo_cargo = new RepoCargo();
        $repo_cargo = $repo_cargo->getModelEntity();
        $repo_orc_cargo = $this->getModelEntity();
        $tbl_cargo = new Cargo();

        $user = $this->getUserFromCurrentGuard();
        $funcionario_id = $user->funcionario_id;

        if($user->tipo != 3){
            $grade = DB::select("select LEFT(c.cod_cargo_basic, 2) grade from tbl_funcionario f
            join tbl_cargo c on c.id = f.cargo_id
            where f.id = $funcionario_id");
            if(count($grade) == 0){
                $this->setError("Não foi possível encontrar o grade salarial do usuário logado. Erro: 220420211717");
                return false;
            }
            $grade = $grade[0]->grade;
            // dd($where)

        }

        $cargo_sal= $repo_orc_cargo->join($repo_cargo->getTable(),
        $repo_orc_cargo->getColunaAlias('cargo_id'),
        $repo_cargo->getColunaAlias('id')) 
        ->select($repo_cargo->getColunaAlias('des_cargo_basic'),
        $repo_cargo->getColunaAlias('sal_base'),
        $repo_cargo->getColunaAlias('salario'),
        $repo_cargo->getColunaAlias('salario_max'),
        $repo_cargo->getColunaAlias('salario_min'),
        $repo_cargo->getColunaAlias('cod_cargo_basic'),
        $repo_orc_cargo->getColunaAlias('id'),
        $repo_orc_cargo->getColunaAlias('cargo_id'),
        $tbl_cargo->getColunaAlias('ativo'))  
        ->where([
            [$repo_orc_cargo->getColunaAlias('orcamento_id'),'=', $orc_id],
            [$repo_orc_cargo->getColunaAlias('tipo_table'), '=', 'O'],
            [$tbl_cargo->getColunaAlias('ativo'),'=', 1]            
        ])
        ->whereNull($this->getModelEntity()->getColunaAlias('periodo'));

        
        if($user->tipo != 3){
            $cargo_sal->whereRaw("LEFT(tbl_cargo.cod_cargo_basic, 2)  <= $grade ");
        }

        $cargo_sal = $cargo_sal->get()->toArray();
        
        
        // if(!($orc = $cargo_sal->first())){
        //     $this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
        //     return false;
        // }
        $dados = [];
        for($i=0;$i<count($cargo_sal);$i++){
            $dados[$i]=array_merge($cargo_sal[$i],array(
                "description"=>$cargo_sal[$i]['cod_cargo_basic'].' - '.$cargo_sal[$i]['des_cargo_basic'],
                "salario_"=>number_format($cargo_sal[$i]['sal_base'],2,',','.')
            ));
        }
        
        //array_merge($cargo_sal,'description'=>$cargo_sal['cod_cargo_basic']);
        return count($dados)==0 ? false: $dados;
    }

    public function listarCargoForecast($orc_id, $periodo){
        $repo_cargo = new RepoCargo();
        $repo_cargo = $repo_cargo->getModelEntity();
        $repo_orc_cargo = $this->getModelEntity();

        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $cdn_func = $decrypted['token']['func_data']['cdn_funcionario'];

        $grade = null;
        if($decrypted['token']['tipo_user'] != 3){
            $grade = DB::select("SELECT left(c.cod_cargo_basic,2) as grade from tbl_funcionario as f
            inner join tbl_cargo as c on c.id = f.cargo_id
            where f.cdn_funcionario = $cdn_func");
        }
        
        // $where = '';
        // if($grade != null){
        //     $where = " and LEFT(c.cod_cargo_basic, 2) <= {$grade[0]->grade}";
        // }

        // $cargo_sal = DB::select("SELECT
        //     c.des_cargo_basic, c.sal_base, c.salario, c.salario_max, c.salario_min, c.cod_cargo_basic, oc.id, oc.cargo_id, {$periodo} periodo,
        //     'F' tipo_table, CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'description'
        //     from tbl_orc_cargo as oc
        //     inner join tbl_cargo as c on c.id = oc.cargo_id
        //     where oc.orcamento_id = {$orc_id} and oc.tipo_table = 'F' and oc.periodo = '{$periodo}' {$where}
        // ");

        $cargo_sal= $repo_orc_cargo->join($repo_cargo->getTable(),
        $repo_orc_cargo->getColunaAlias('cargo_id'),
        $repo_cargo->getColunaAlias('id'))
        ->select(
            $repo_cargo->getColunaAlias('des_cargo_basic'),
            $repo_cargo->getColunaAlias('sal_base'),
            $repo_cargo->getColunaAlias('salario'),
            $repo_cargo->getColunaAlias('salario_max'),
            $repo_cargo->getColunaAlias('salario_min'),
            $repo_cargo->getColunaAlias('cod_cargo_basic'),
            $repo_orc_cargo->getColunaAlias('id'),
            $repo_orc_cargo->getColunaAlias('cargo_id'),
            'periodo','tipo_table',
            DB::raw("CONCAT({$repo_cargo->getColunaAlias('cod_cargo_basic')}, ' - ', {$repo_cargo->getColunaAlias('des_cargo_basic')}) as description")
        )
        ->where([
            ['orcamento_id','=', $orc_id],
            ['tipo_table', '=', 'F'],
            ['periodo', '=', $periodo]
        ]);

        if($grade != null){
            $cargo_sal = $cargo_sal->where(DB::raw("LEFT([tbl_cargo].[cod_cargo_basic], 2)"), '<=', $grade[0]->grade)->get()->toArray();
        }
        else{
            $cargo_sal = $cargo_sal->get()->toArray();
        }
        
        $dados = [];
        for($i = 0; $i < count($cargo_sal); $i++){
            $dados[$i] = array_merge($cargo_sal[$i], array(
                "salario_"=>number_format($cargo_sal[$i]['sal_base'],2,',','.')
            ));
        }
        
        return $dados;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=[
            'id','cargo_id','cod_cargo_basic','des_cargo_basic',
            'orcamento_id','sal_base','sal_max','sal_med','sal_min','data_calc' 
        ];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteOrcCargo($data_request){        
        $retorno=true;
        $instance = $this;
        
        // $where_cargo = $data_request['tipo_table'] == 'F' ? " and tipo_table = 'F' and periodo = '{$data_request['periodo']}' " : " and tipo_table = 'O'";
        // $orc_cargo_id = DB::select("SELECT * from tbl_orc_cargo where orcamento_id = ? and cargo_id = ? {$where_cargo}", [$data_request['orcamento_id'], $data_request['cargo_id']]);

        // if(count($orc_cargo_id) == 0){
        //     $this->setError('Cargo não encontrado.', 'Erro: 260120211652');        
        //     return false;
        // }
        if($data_request['tipo_table'] == 'F' && $this->cargoExistenteOrcForecast($data_request['cargo_id'], $data_request['orcamento_id'], $data_request['periodo']) > 0){
            $this->setError('O Cargo está sendo utilizado como parâmetro em outras tabelas deste orçamento.', 'Erro: 171220201506');        
            return false;
        }
        if($data_request['tipo_table'] != 'F' && $this->cargoExistenteOrc($data_request['cargo_id'], $data_request['orcamento_id'])>0){
            $this->setError('O Cargo está sendo utilizado como parâmetro em outras tabelas deste orçamento.', 'Erro: 070120201714');        
            return false;
        }

        DB::transaction(function()use(&$retorno, $data_request, $instance){

            $calc_indice = new CalcIndice();
            $repo_calc_ind = new RepoCalcIndice();
            $repo_calc_orcamento = new RepoCalcOrcamento();

            if(!$instance->deleteParent($data_request['id'])){    
                $retorno = true;
                
                abort(500, $retorno['msg']);
                return false;
            }                 

            if(! $repo_calc_orcamento->delete($data_request['id_calc'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            } 
            $select_indice = $calc_indice->select()->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$data_request['id']],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();
                
            if(count($select_indice)>0)
            {
                $delete_indices = $repo_calc_ind->getModelEntity()->where([
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$data_request['id']],
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]])
                ->delete();

                if(!$delete_indices){
                    $retorno = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }
            
                        
        });
        
        return $retorno;
    }

    public function deleteOrcIndice($form_data,$id){
        $repo_calc_ind = new RepoCalcIndice();
        $calc_orcamento = new CalcOrcamento();

        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();
                
            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420201434");
                return false;
            }
        }
        else{

            DB::beginTransaction();
            try {
                if(!$this->deleteParent($form_data['id'])){
                    return false;
                }    
                
                if(!$repo_calc_ind->delete($form_data['id_calc'])){
                    return false;
                }    
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 030420201043.'.$e);
                return false;
            }
        }
        return true;
    }

    public function deleteParent($data_request){
        $cargo = $this->find($data_request);
        return $cargo->delete();
    }

    public function cargoExistenteOrc($cargo, $orc_id){
       
        $orcCargoBeneficio = new OrcLotCargoBeneficio();
        $orcFerias = new OrcFerias();
        $orcHeadcountContratacoes = new OrcHeadcountContratacoes();
        $orcHeadcountDemissoes = new OrcHeadcountDemissoes();
        $orcamLotCargoEvento = new OrcamLotCargoEvento();
        $orcamLotCargoHeadcount = new OrcamLotCargoHeadcount();
        $orcSalarioFuncionario = new OrcSalarioFuncionario();
        $orcCargosAreaSal = new OrcCargosAreaSal();
        $orcPromocao = new OrcPromocao();
        $dissidio = new OrcDissidio();
        $orcCargoPromocao = 'op';
        $tb_alias = $orcPromocao->getTable();       
        $tb_alias = $tb_alias . " AS {$orcCargoPromocao}";

        $orc_cargo = $this->getModelEntity()        
        ->leftJoin(
            $orcCargoBeneficio->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoBeneficio->getColunaAlias('orcamento_id')} and 
            {$orcCargoBeneficio->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $dissidio->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$dissidio->getColunaAlias('orcamento_id')} and 
            {$dissidio->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcFerias->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcFerias->getColunaAlias('orcamento_id')} and 
            {$orcFerias->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountContratacoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountContratacoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountContratacoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountDemissoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountDemissoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountDemissoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoEvento->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoEvento->getColunaAlias('orc_id')} and             
            {$orcamLotCargoEvento->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoHeadcount->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoHeadcount->getColunaAlias('orc_id')} and             
            {$orcamLotCargoHeadcount->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcPromocao->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcPromocao->getColunaAlias('orc_id')} and             
            {$orcPromocao->getColunaAlias('cargo_promovido_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )->leftJoin(
            $tb_alias,
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoPromocao}.orc_id and           
            {$orcCargoPromocao}.cargo_promovido_id = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcSalarioFuncionario->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcSalarioFuncionario->getColunaAlias('orc_id')} and             
            {$orcSalarioFuncionario->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )    
        ->leftJoin(
            $orcCargosAreaSal->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargosAreaSal->getColunaAlias('orcamento_id')} and             
            {$orcCargosAreaSal->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )        
        ->select(
            DB::raw("
            count(
                COALESCE(
                    {$orcamLotCargoHeadcount->getColunaAlias('id')},
                    {$orcCargoBeneficio->getColunaAlias('id')},
                    {$orcFerias->getColunaAlias('id')},
                    {$orcHeadcountContratacoes->getColunaAlias('id')},
                    {$orcHeadcountDemissoes->getColunaAlias('id')},
                    {$orcamLotCargoEvento->getColunaAlias('id')},                    
                    {$orcPromocao->getColunaAlias('id')},
                    {$orcCargoPromocao}.id,
                    {$orcSalarioFuncionario->getColunaAlias('id')},
                    {$orcCargosAreaSal->getColunaAlias('id')}
                    )) as id_orc
            ")
        )->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id],
            [$this->getModelEntity()->getColunaAlias('cargo_id'), $cargo],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), 'O']
        ])
        ->whereNull($this->getModelEntity()->getColunaAlias('periodo'))
        ->first();
        
        return !$orc_cargo ? 0 : $orc_cargo->id_orc;

    }

    public function cargoExistenteOrcForecast($cargo, $orc_id, $periodo){
        $orcCargoBeneficio = new OrcLotCargoBeneficio();
        $orcFerias = new OrcFerias();
        $orcHeadcountContratacoes = new OrcHeadcountContratacoes();
        $orcHeadcountDemissoes = new OrcHeadcountDemissoes();
        $orcamLotCargoEvento = new OrcamLotCargoEvento();
        $orcamLotCargoHeadcount = new OrcamLotCargoHeadcount();
        $orcSalarioFuncionario = new OrcSalarioFuncionario();
        $orcCargosAreaSal = new OrcCargosAreaSal();
        $orcPromocao = new OrcPromocao();
        $dissidio = new OrcDissidio();
        $orcCargoPromocao = 'op';
        $tb_alias = $orcPromocao->getTable();       
        $tb_alias = $tb_alias . " AS {$orcCargoPromocao}";

        $orc_cargo = $this->getModelEntity()        
        ->leftJoin(
            $orcCargoBeneficio->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoBeneficio->getColunaAlias('orcamento_id')} and 
            {$orcCargoBeneficio->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $dissidio->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$dissidio->getColunaAlias('orcamento_id')} and 
            {$dissidio->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcFerias->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcFerias->getColunaAlias('orcamento_id')} and 
            {$orcFerias->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountContratacoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountContratacoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountContratacoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountDemissoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountDemissoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountDemissoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoEvento->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoEvento->getColunaAlias('orc_id')} and             
            {$orcamLotCargoEvento->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoHeadcount->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoHeadcount->getColunaAlias('orc_id')} and             
            {$orcamLotCargoHeadcount->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcPromocao->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcPromocao->getColunaAlias('orc_id')} and             
            {$orcPromocao->getColunaAlias('cargo_promovido_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )->leftJoin(
            $tb_alias,
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoPromocao}.orc_id and           
            {$orcCargoPromocao}.cargo_promovido_id = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcSalarioFuncionario->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcSalarioFuncionario->getColunaAlias('orc_id')} and             
            {$orcSalarioFuncionario->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )    
        ->leftJoin(
            $orcCargosAreaSal->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargosAreaSal->getColunaAlias('orcamento_id')} and             
            {$orcCargosAreaSal->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )        
        ->select(
            DB::raw("
            count(
                COALESCE(
                    {$orcamLotCargoHeadcount->getColunaAlias('id')},
                    {$orcCargoBeneficio->getColunaAlias('id')},
                    {$orcFerias->getColunaAlias('id')},
                    {$orcHeadcountContratacoes->getColunaAlias('id')},
                    {$orcHeadcountDemissoes->getColunaAlias('id')},
                    {$orcamLotCargoEvento->getColunaAlias('id')},                    
                    {$orcPromocao->getColunaAlias('id')},
                    {$orcCargoPromocao}.id,
                    {$orcSalarioFuncionario->getColunaAlias('id')},
                    {$orcCargosAreaSal->getColunaAlias('id')}
                    )) as id_orc
            ")
        )->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id],
            [$this->getModelEntity()->getColunaAlias('cargo_id'), $cargo],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), 'F'],
            [$this->getModelEntity()->getColunaAlias('periodo'), $periodo]
        ])
        ->first();
        
        return !$orc_cargo ? 0 : $orc_cargo->id_orc;
    }
    public function populaSalCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        $orc_cargo_area_sal = new OrcCargosAreaSal();
        $funcionario = new Funcionario();
        $orc_cargo = new OrcCargo();
        $cargo = new Cargo();
        $orc_lotacao = new OrcLotacao();
        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();       
        $repo_orc_script_calculos = new RepoOrcScriptCalculos();
        $calc_orcamento = new CalcOrcamento();
        
        $entities = [
            'orcCargosAreaSal' => ['instance'=>$orc_cargo_area_sal],
            'funcionario' => ['instance'=>$funcionario],
            'orcCargo' => ['instance'=>$orc_cargo],
            'cargo' => ['instance' => $cargo],
            'orcLotacao' => ['instance' => $orc_lotacao],
            'lotacaoCCusto' => ['instance' => $lotacao_c_custo],
            'lotacao' => ['instance' => $lotacao],           
            'calcOrcamento' => ['instance' => $calc_orcamento]
        ];
        
        $result = $repo_orc_script_calculos->insertUpcalcOrcCargo($entities, $orc_id, $periodo, $tipo_table);        
        
        if($result["status"]!="success"){
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 030420201420';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 030420201420';
            goto saida;
        }

        $result_calc = $repo_orc_script_calculos->insertCalcOrcamentoCargo($entities, $orc_id, $periodo, $tipo_table);
        
        if($result_calc["status"]!="success"){                
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 030420201420';
            $retorno['submsg']='Falha ao atualizar registro. Erro: 030420201420';
            goto saida;
        } 
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastrado com sucesso!";
        $retorno['submsg']="Registro cadastrado com sucesso!";

        saida:
        return $retorno; 
    }

    public function deleteAll($orc_id, $periodo = null, $tipo_table = 'O'){
        try{
            
            $periodo = $periodo == null ? "periodo is null" : "periodo = '{$periodo}'";
            DB::beginTransaction();
            /*$delete_calc = FacadesDB::delete("DELETE
                FROM tbl_calc_orcamento where tbl_origem = 'tbl_orc_cargo' and origem_id in (
                    SELECT orc_cargo.id FROM tbl_orc_cargo as orc_cargo where orcamento_id = $orc_id and orc_cargo.tipo_table = '{$tipo_table}' and orc_cargo.".$periodo." and
                    orc_cargo.id not in (SELECT cargo_lot.cargo_id from tbl_orc_cargos_area_sal as cargo_lot where cargo_lot.orcamento_id = $orc_id and cargo_lot.tipo_table = '{$tipo_table}' and cargo_lot.".$periodo.") and
                    orc_cargo.id not in (SELECT cargo_func.orc_cargo_id from tbl_orc_salario_funcionario as cargo_func where cargo_func.orc_id = $orc_id and cargo_func.tipo_table = '{$tipo_table}' and cargo_func.".$periodo.") and
                    orc_cargo.id not in (SELECT dissidio.orc_cargo_id from tbl_orc_dissidio as dissidio where dissidio.orcamento_id = $orc_id and dissidio.tipo_table = '{$tipo_table}' and dissidio.".$periodo.") and
                    orc_cargo.id not in (SELECT ben_cargo.orc_cargo_id from tbl_orc_benef_lot_carg as ben_cargo where ben_cargo.orcamento_id = $orc_id and ben_cargo.tipo_table = '{$tipo_table}' and ben_cargo.".$periodo.") and
                    orc_cargo.id not in (SELECT ppr.cargo_id from tbl_orc_ppr as ppr where ppr.orc_id = $orc_id and ppr.tipo_table = '{$tipo_table}' and ppr.".$periodo.") and
                    orc_cargo.id not in (SELECT b.cargo_id from tbl_orc_bonus as b where b.orc_id = $orc_id and b.tipo_table = '{$tipo_table}' and b.".$periodo.") and
                    orc_cargo.id not in (SELECT ce.orc_cargo_id from tbl_orc_lot_carg_event as ce where ce.orc_id = $orc_id and ce.tipo_table = '{$tipo_table}' and ce.".$periodo.") and
                
                    orc_cargo.id not in (SELECT hd.orc_cargo_id from tbl_orc_lot_carg_headcount as hd where hd.orc_id = $orc_id and hd.tipo_table = '{$tipo_table}' and hd.".$periodo.") and
                    orc_cargo.id not in (SELECT dem.orc_cargo_id from tbl_orc_headcount_demissoes as dem where dem.orcamento_id = $orc_id and dem.tipo_table = '{$tipo_table}' and dem.".$periodo.") and
                    orc_cargo.id not in (SELECT cont.orc_cargo_id from tbl_orc_headcount_contratacoes as cont where cont.orcamento_id = $orc_id and cont.tipo_table = '{$tipo_table}' and cont.".$periodo.") and
                    orc_cargo.id not in (SELECT prom.cargo_atual_id from tbl_orc_promocao as prom where prom.orc_id = $orc_id and prom.tipo_table = '{$tipo_table}' and prom.".$periodo.") and
                    orc_cargo.id not in (SELECT he.orc_cargo_id from tbl_headcount_hra_extra as he where he.orc_id = $orc_id and he.tipo_table = '{$tipo_table}' and he.".$periodo.") and
                    orc_cargo.id not in (SELECT fe.cargo_id from tbl_orc_ferias as fe where fe.orcamento_id = $orc_id and fe.tipo_table = '{$tipo_table}' and fe.".$periodo.")
                )
            ");*/

            $delete_calc = DB::delete("DELETE FROM tbl_calc_orcamento where tbl_origem = 'tbl_orc_cargo' and origem_id in (
                select oc.id from tbl_orc_cargo as oc

                left join tbl_orc_cargos_area_sal as oca on oca.cargo_id = oc.id and oca.orcamento_id = oc.orcamento_id
                left join tbl_orc_salario_funcionario as osl on osl.orc_cargo_id = oc.id and osl.orc_id = oc.orcamento_id
                left join tbl_orc_dissidio as od on od.orc_cargo_id = oc.id and od.orcamento_id = oc.orcamento_id
                left join tbl_orc_benef_lot_carg as oblt on oblt.orc_cargo_id = oc.id and oblt.orcamento_id = oc.orcamento_id
                left join tbl_orc_ppr as ppr on ppr.cargo_id = oc.id and ppr.orc_id = oc.orcamento_id
                left join tbl_orc_bonus as ob on ob.cargo_id = oc.id and ob.orc_id = oc.orcamento_id
                left join tbl_orc_lot_carg_event as olce on olce.orc_cargo_id = oc.id and olce.orc_id = oc.orcamento_id
                left join tbl_orc_lot_carg_headcount as hd on hd.orc_cargo_id = oc.id and hd.orc_id = oc.orcamento_id
                left join tbl_orc_headcount_demissoes as dem on dem.orc_cargo_id = oc.id and dem.orcamento_id = oc.orcamento_id
                left join tbl_orc_headcount_contratacoes as cont on cont.orc_cargo_id = oc.id and cont.orcamento_id = oc.orcamento_id
                left join tbl_orc_promocao as prom on (prom.cargo_atual_id = oc.id or prom.cargo_promovido_id = oc.id) and prom.orc_id = oc.orcamento_id
                left join tbl_headcount_hra_extra as he on he.orc_cargo_id = oc.id and he.orc_id = oc.orcamento_id
                left join tbl_orc_ferias as ofe on ofe.cargo_id = oc.id and ofe.orcamento_id = oc.orcamento_id
                
                where oc.orcamento_id = {$orc_id} and oc.tipo_table = '{$tipo_table}' and oc.{$periodo} and oca.id is null
                and osl.id is null and od.id is null and oblt.id is null and ppr.id is null
                and ob.id is null and olce.id is null and hd.id is null and dem.id is null
                and cont.id is null and prom.id is null and he.id is null and ofe.id is null)
            ");

            if($delete_calc === false){
                $this->setError("Falha ao excluir registros. Erro: 100820201348");
                DB::rollBack();
                return false;
            }
            
            /*$delete = FacadesDB::delete("DELETE FROM tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = '{$tipo_table}' and ".$periodo." and
                id not in (SELECT cargo_lot.cargo_id from tbl_orc_cargos_area_sal as cargo_lot where cargo_lot.orcamento_id = $orc_id and cargo_lot.tipo_table = '{$tipo_table}' and cargo_lot.".$periodo.") and
                id not in (SELECT cargo_func.orc_cargo_id from tbl_orc_salario_funcionario as cargo_func where cargo_func.orc_id = $orc_id and cargo_func.tipo_table = '{$tipo_table}' and cargo_func.".$periodo.") and
                id not in (SELECT dissidio.orc_cargo_id from tbl_orc_dissidio as dissidio where dissidio.orcamento_id = $orc_id and dissidio.tipo_table = '{$tipo_table}' and dissidio.".$periodo.") and
                id not in (SELECT ben_cargo.orc_cargo_id from tbl_orc_benef_lot_carg as ben_cargo where ben_cargo.orcamento_id = $orc_id and ben_cargo.tipo_table = '{$tipo_table}' and ben_cargo.".$periodo.") and
                id not in (SELECT ppr.cargo_id from tbl_orc_ppr as ppr where ppr.orc_id = $orc_id and ppr.tipo_table = '{$tipo_table}' and ppr.".$periodo.") and
                id not in (SELECT b.cargo_id from tbl_orc_bonus as b where b.orc_id = $orc_id and b.tipo_table = '{$tipo_table}' and b.".$periodo.") and
                id not in (SELECT ce.orc_cargo_id from tbl_orc_lot_carg_event as ce where ce.orc_id = $orc_id and ce.tipo_table = '{$tipo_table}' and ce.".$periodo.") and
            
                id not in (SELECT hd.orc_cargo_id from tbl_orc_lot_carg_headcount as hd where hd.orc_id = $orc_id and hd.tipo_table = '{$tipo_table}' and hd.".$periodo.") and
                id not in (SELECT dem.orc_cargo_id from tbl_orc_headcount_demissoes as dem where dem.orcamento_id = $orc_id and dem.tipo_table = '{$tipo_table}' and dem.".$periodo.") and
                id not in (SELECT cont.orc_cargo_id from tbl_orc_headcount_contratacoes as cont where cont.orcamento_id = $orc_id and cont.tipo_table = '{$tipo_table}' and cont.".$periodo.") and
                id not in (SELECT prom.cargo_atual_id from tbl_orc_promocao as prom where prom.orc_id = $orc_id and prom.tipo_table = '{$tipo_table}' and prom.".$periodo.") and
                id not in (SELECT he.orc_cargo_id from tbl_headcount_hra_extra as he where he.orc_id = $orc_id and he.tipo_table = '{$tipo_table}' and he.".$periodo.") and
                id not in (SELECT fe.cargo_id from tbl_orc_ferias as fe where fe.orcamento_id = $orc_id and fe.tipo_table = '{$tipo_table}' and fe.".$periodo.")
            ");*/

            $delete = DB::delete("DELETE FROM tbl_orc_cargo where id in (SELECT oc.id from tbl_orc_cargo as oc

                left join tbl_orc_cargos_area_sal as oca on oca.cargo_id = oc.id and oca.orcamento_id = oc.orcamento_id
                left join tbl_orc_salario_funcionario as osl on osl.orc_cargo_id = oc.id and osl.orc_id = oc.orcamento_id
                left join tbl_orc_dissidio as od on od.orc_cargo_id = oc.id and od.orcamento_id = oc.orcamento_id
                left join tbl_orc_benef_lot_carg as oblt on oblt.orc_cargo_id = oc.id and oblt.orcamento_id = oc.orcamento_id
                left join tbl_orc_ppr as ppr on ppr.cargo_id = oc.id and ppr.orc_id = oc.orcamento_id
                left join tbl_orc_bonus as ob on ob.cargo_id = oc.id and ob.orc_id = oc.orcamento_id
                left join tbl_orc_lot_carg_event as olce on olce.orc_cargo_id = oc.id and olce.orc_id = oc.orcamento_id
                left join tbl_orc_lot_carg_headcount as hd on hd.orc_cargo_id = oc.id and hd.orc_id = oc.orcamento_id
                left join tbl_orc_headcount_demissoes as dem on dem.orc_cargo_id = oc.id and dem.orcamento_id = oc.orcamento_id
                left join tbl_orc_headcount_contratacoes as cont on cont.orc_cargo_id = oc.id and cont.orcamento_id = oc.orcamento_id
                left join tbl_orc_promocao as prom on (prom.cargo_atual_id = oc.id or prom.cargo_promovido_id = oc.id) and prom.orc_id = oc.orcamento_id
                left join tbl_headcount_hra_extra as he on he.orc_cargo_id = oc.id and he.orc_id = oc.orcamento_id
                left join tbl_orc_ferias as ofe on ofe.cargo_id = oc.id and ofe.orcamento_id = oc.orcamento_id
                
                where oc.orcamento_id = {$orc_id} and oc.tipo_table = '{$tipo_table}' and oc.{$periodo} and oca.id is null
                and osl.id is null and od.id is null and oblt.id is null and ppr.id is null
                and ob.id is null and olce.id is null and hd.id is null and dem.id is null
                and cont.id is null and prom.id is null and he.id is null and ofe.id is null)
            ");

            if($delete === false){
                $this->setError("Falha ao excluir registros.");
                DB::rollBack();
                return false;
            }
            if($delete == 0 || $delete_calc == 0){
                $local = $tipo_table == 'F' ? 'Forecast' : 'Orçamento';
                $this->setError("Nenhum registro para ser excluído. Os registros só podem ser excluídos caso não existam nas seguintes telas/etapas: Salário por Lotação e Cargo, 
                Salário por Funcionário, Acordo Coletivo, Benefício por Lotação e Cargo, PR, Bônus, Eventos por Lotação e Cargo e em {$local}");
                DB::rollBack();
                return 'warning';
            }
            DB::commit();
            return true;
        }
        catch(\Exception $e){
            $this->setError("Falha ao excluir registros. Erro: 100820201543". $e->getMessage());
            DB::rollBack();
            return false;
        }
        DB::commit();
        return true;
    }

    public function atualizaSalCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        /*
            1-De onde virão os dados? da tbl_cargo
            2-Se determinado cargo da tbl_cargo não existir na tbl_orc_cargo, insere, senão não
        */

        // SELECIONA CARGOS QUE NÃO EXISTEM NA ORC_CARGO E ESTÃO ATIVOS
        $condicao = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and periodo is null and tipo_table = '{$tipo_table}' ";
        $select_disponiveis = DB::select("SELECT * FROM [tbl_cargo] WHERE ativo = 1 and id not in (select cargo_id from [tbl_orc_cargo] where orcamento_id = $orc_id ".$condicao.")");

        // dd($select_disponiveis);
        
        if(count($select_disponiveis) == 0){
            $this->setError("Sem cargos para o Incremento. 251120200947");
            return 'warning';
        }
        else{                
                // INSERT NA ORC_CARGO
            try{
                    
                foreach($select_disponiveis as $value){
                    $insert = DB::insert("INSERT INTO [tbl_orc_cargo]([orcamento_id], [cargo_id], [sal_base], [sal_max], [sal_min],
                        [data_calc], [grupo_salarial], [user_id], [empresa_id], [created_at], [created_by], [tipo_table], [periodo]) VALUES
                        (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $value->id, $value->salario, $value->salario_max, $value->salario_min,
                        $value->data_salario, null, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor(), $tipo_table, $periodo]
                    );
                    
                    if($insert === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201017");
                        DB::rollBack();
                        return false;
                    }

                    $select = DB::select("SELECT id FROM [tbl_orc_cargo] where orcamento_id = ? and cargo_id = ? ".$condicao, [$orc_id, $value->id]);
                    
                    $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                        ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                        ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES (
                        ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                        [$select[0]->id, 'tbl_orc_cargo', $value->salario, $value->salario, $value->salario, $value->salario, 
                        $value->salario, $value->salario, $value->salario, $value->salario, $value->salario, $value->salario, 
                        $value->salario, $value->salario, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );
                    //dd($select, $insert_calc);
                    if($insert_calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201032");
                        DB::rollBack();
                        return false;
                    }
                    // dd("aqui");
                    // DB::commit();
                    
                    continue;
                }
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Falha ao inserir novo(s) cargo(s). Erro: 251120201016ct ".$e);
                return false;
            }
            return true;
        }
    }
    
    public function atualizaSalarios($orc_id, $periodo = null, $tipo_table = 'O'){
        $condicao = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and periodo is null and tipo_table = '{$tipo_table}' ";

        $select = DB::select("SELECT id, salario_max, salario_min from tbl_cargo where ativo = 1");
        // $i = 0;
        foreach($select as $value){
            try{
                $update = DB::update("UPDATE tbl_orc_cargo set sal_max = ?, sal_min = ?, updated_at = getdate(), updated_by = ? where cargo_id = ? and orcamento_id = ?".$condicao, [$value->salario_max, $value->salario_min, $this->fillModificadoPor(), $value->id, $orc_id]);

                if($update === false){
                    $this->setError("Falha ao atualizar salários. Erro: 011220201526");
                    return false;
                }
                
                // if($insert_calc === false){ -> essa variavel não existe
                //     $this->setError("Falha ao inserir registro. Erro: 050220211600");
                //     return false;
                // }
                
                DB::commit();

            }
            catch(\Exception $e){
                $this->setError("Erro ao atualizar salário. Erro: 011220201525 ".$e->getMessage());
                return false;
            }
        }
        try{
            $update_calc = DB::update("UPDATE tbl_calc_orcamento set updated_at = GETDATE(), updated_by = ? where tbl_origem = 'tbl_orc_cargo' and origem_id in (
                select id from tbl_orc_cargo where orcamento_id = ? {$condicao}
            )", [$this->fillModificadoPor(), $orc_id]);

            if($update_calc === false){
                $this->setError("Falha ao atualizar salários. Erro: 260420210937");
                return false;
            }
        }
        catch(\Exception $e){
            $this->setError("Erro ao atualizar salário. Erro: 260420210935 ".$e->getMessage());
            return false;
        }
        return true;
    }
} 