<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use Illuminate\Support\Facades\DB;

class RepoOrcContratacoes extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcContratacoes';
    protected $form_rules=[
        'orcamento_id'      =>'required|exists:tbl_orcamento,id',
        'lotacao_id'        =>'required|exists:tbl_orc_lotacao,id',
        'orc_cargo_id'      =>'required|exists:tbl_orc_cargo,id',
        'orc_turma_id'          =>'required|exists:tbl_orc_turma,id',
        'ccusto_id'         =>'required|exists:tbl_ccusto,id',
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'     =>'Por gentileza, selecione um orçamento',
        'orcamento_id.exists'       =>'Por gentileza, selecione um orçamento',
        'tbl_orc_lotacao.required'       =>'Por gentiliza, selecione uma lotação',
        'tbl_orc_lotacao.exists'         =>'Por gentiliza, selecione uma lotação',
        'orc_cargo_id.required'     =>'O campo Cargo é obrigatório',
        'orc_cargo_id.exists'       =>'O campo Cargo é obrigatório',
        'ccusto_id.required'        =>'Por gentiliza selecione um centro de custo',
        'ccusto_id.exists'          =>'Por gentiliza selecione um centro de custo',
        'orc_turma_id.required'         =>'O campo Turma é obrigatório',
        'orc_turma_id.exists'           =>'O campo Turma é obrigatório',
    ]; 
     

    public function createContratacoes($data_request){
        $instance = $this;
        
        $hasErro = false;

        DB::transaction(function()use(&$hasErro, &$retorno, $data_request, $instance){
            
            $data_request = array_merge($data_request, $data_request['meses']);

            // $data_request['orc_cargo_id'] = OrcCargo::where([
            //     ['cargo_id', $data_request['cargo_id']],
            //     ['orcamento_id', $data_request['orcamento_id']]
            // ])->first()->id;
            $data_request['tipo_table'] = array_key_exists('tipo_table', $data_request) ? $data_request['tipo_table'] : 'O';
            
            if($instance->validaInsert($data_request, $retorno, $hasErro)){
                $repo_calc_orcamento = new RepoCalcOrcamento();

                $meses = $instance->dataFilterMesesCalcOrcamento($data_request);
                $data = $instance->dataFilterContratacoes($data_request);
                $data = $instance->putCargoIdOnData($data,$data['orc_cargo_id']);

                
                if(!$instance->hasCargoTurmaNaLotacao($data)){  
                    $retorno['status'] = 'error';
                    $retorno['msg']=$instance->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 13020201726';
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;                  
                }

                $id_orc_contratacoes = $instance->checkHeadcount($data);
                if(! $id_orc_contratacoes){
                    $retorno['status'] = 'error';
                    $retorno['msg']=$instance->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 031220192047';
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }   
                
                
                $merge_tb_calc = [
                    'origem_id' => $id_orc_contratacoes->id,
                    'tbl_origem' => $instance->getModelEntity()->getTable()
                ];


                if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses))){
                    $retorno['status'] = 'error';
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 031220192046';
                    $retorno['msg']=$repo_calc_orcamento->getErrosFlatted();
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }

                $repoHeadcount = new RepoHeadcount();

                if(!$repoHeadcount->calcHeadcount($data['orcamento_id'], $data['lotacao_id'])){
                    $retorno['status']="error";
                    $retorno['msg']=$repoHeadcount->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201112';                        
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }

        });

        if($hasErro){
            goto saida;
        }

        $retorno["title"]="Sucesso!";
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;
    }
    public function updateContratacoes($form_data){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $calc_orc_id = $form_data['id'];
        $meses_calc_orc = $this->dataUpdateContratacoes($form_data); 
        
        insereValorArray($meses_calc_orc, ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado',
        'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado']);
        
        DB::beginTransaction();

        if(!$calc_orc_id){
            $retorno['msg'] = 'Registro não encontrado!';
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 051220191958';
            DB::rollBack();
            goto saida;  
        }
        $calc_orc = $repo_calc_orcamento->getModelEntity()->find($calc_orc_id);

        if(!$repo_calc_orcamento->update($meses_calc_orc, $calc_orc_id)){  
            $retorno['msg'] = $this->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 211120191924';
            DB::rollBack();
            goto saida;               
        }     

        if(!$calc_orc){  
            $retorno['msg'] = "Não foi possível encontrar esse registro!";
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 290420201610';
            DB::rollBack();
            goto saida;               
        }  

        $orc_contratacao = $this->getModelEntity()->find($calc_orc->origem_id);

        if(!$orc_contratacao){  
            $retorno['msg'] = "Não foi possível encontrar essa contratação!";
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 290420201612';
            DB::rollBack();
            goto saida;               
        }  
        
        DB::update("UPDATE tbl_calc_orcamento set updated_at = ?, updated_by = ? where id = ? and tbl_origem = '?'",
            [$this->fillModificadoEm(), $this->fillModificadoPor(), $calc_orc->id, "tbl_orc_headcount_contratacoes"]);
        
        $repoHeadcount = new RepoHeadcount();

        if(!$repoHeadcount->calcHeadcount($orc_contratacao['orcamento_id'], $form_data['lotacao_id'])){
            $retorno['status']="error";
            $retorno['msg']=$repoHeadcount->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201601';
            DB::rollBack();
            goto saida;               
        }  

        $dados_calc = $this->validaValoresNegativos($orc_contratacao['orcamento_id'], $form_data['lotacao_id']);
        if(count($dados_calc) > 0){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }
        DB::commit();
        $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
        saida:
        return $retorno;
        
        
    }


    public function validaInsert($data_request, &$retorno, &$hasErro){
        $existe = $this->getModelEntity()::where([
            ['orc_cargo_id', $data_request['orc_cargo_id']],
            ['orcamento_id', $data_request['orcamento_id']],
            ['lotacao_id', $data_request['lotacao_id']],
            ['orc_turma_id', $data_request['orc_turma_id']],
            ['ccusto_id', $data_request['ccusto_id']],
            ['tipo_table', $data_request['tipo_table']]
        ])->count();

        if($existe != 0){
            $retorno['status'] = 'error';         
            $retorno['msg']='Esse registro já existe!';
            $retorno['submsg']='Falha ao inserir o registro. Erro: 041220191357';
            $hasErro = true;
            return false;
        }

        return true;
    }

    public function dataUpdateContratacoes($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['meses', 'funcionario_id', 'orc_id', 'lotacao_id','cargo_id','orc_turma_id', 'lotacao_responsavel','orcamento_id','type', 'orc_cargo_id', 'ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterContratacoes($data){
        $array_orcamento=['meses','tbl_origem','cargo_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function getCargoContratacao($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){
    // $repo_cargo_area_sal = new RepoOrcLotacaoCargoSal();

    // $cargos = $repo_cargo_area_sal->getModelEntity()
    // ->with(['getCargo'=>function($query){ 
    //     return $query->with('getCargo'); 
    // }])
    // ->where('lotacao_id',$lotacao_id)
    // ->where('orcamento_id',$orc_id)
    // ->get()->toArray();

    // $data_cargo = [];
    // foreach ($cargos as $cargo) {
    //     array_push($data_cargo, [
    //         'description_cargo'=>$cargo['get_cargo']['get_cargo']['cod_cargo_basic'] . ' - ' .$cargo['get_cargo']['get_cargo']['des_cargo_basic'],
    //         'id' => $cargo['cargo_id']
    //     ]);
    // }

    $orc_cargo = new OrcCargo();
    $repo_usuario = new RepoUsuario();

    $user = $repo_usuario->getModelEntity()->select('funcionario_id', 'tipo')->with([
        'getFuncionario'=>function($query){
            return $query->with('getCargo');
        }
    ])->find($this->getUserFromCurrentGuard()->id);

    if(!$user){
        return [];
    }

    $gs_usuario = substr($user->getFuncionario->getCargo->cod_cargo_basic, 0, 2);

    $query = $orc_cargo
    ->with(['getCargo'=>function($query){ 

    }])->where('orcamento_id',$orc_id)->where('tipo_table', $tipo_table);
    
    $cargos = null;
    if($tipo_table == 'F'){
        $cargos = $query->where('periodo', $periodo)->get()->toArray();
    }
    else{
        $cargos = $query->whereNull('periodo')->get()->toArray();
    }
    
    $data_cargo = [];
    foreach ($cargos as $cargo) {
        if(substr($cargo['get_cargo']['cod_cargo_basic'], 0, 2) > $gs_usuario && $user->tipo != 3){
            continue;
        }
        array_push($data_cargo, [
            'description_cargo'=>$cargo['get_cargo']['cod_cargo_basic'] . ' - ' .$cargo['get_cargo']['des_cargo_basic'],
            'id' => $cargo['id']
        ]);
    }

    return $data_cargo;

}

public function hasCargoTurmaNaLotacao($data){
    $repo_headcount = new RepoHeadcount();

    $data_compare = [
        'orc_id' => $data['orcamento_id'],
        'lotacao_id' => $data['lotacao_id'],
        'orc_cargo_id' => $data['orc_cargo_id'],
        'ccusto_id' => $data['ccusto_id'],
        'orc_turma_id' => $data['orc_turma_id'],
        'tipo_table' => 'O',
    ];
    $headcount = $repo_headcount->getModelEntity()->where($data_compare)->get()->count();

    if(!$headcount){
        $data_insert = array_merge($data_compare,[            
            'qtd_func_lot' => 0,
            'atual_total' => 0,
            'forecast_anterior' => 0,
            'forecast_total' => 0,
            'fromMeses' => false,
            'quadroAtual' => 0,
        ]);
        $createHeadcount = $repo_headcount->createHeadcount($data_insert);
        if($createHeadcount['status'] == 'error'){
            $this->setError($repo_headcount->getErrosFlatted());
            return false;
        }
    }

    return true;
}


}
