<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Atividades;
use App\Modules\Natureza51\Entities\CadastroParametros;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoOrcParametros;
use App\Modules\Natureza51\Repositories\RepoAtividades;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Repositories\RepoOrcNotificacoes;
use App\Modules\Natureza51\Repositories\RepoNotify;
use Illuminate\Support\Facades\DB;
use Monolog\Handler\IFTTTHandler;
use Carbon\Carbon;

class RepoOrcCronograma extends RepoOrcamento
{
    use \App\Core\Traits\ParamTrait;

    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCronograma';
    protected $form_rules=[
        'orcamento_id'  =>'required|exists:tbl_orcamento,id',
        //'activity_id'   =>'required|exists:tbl_activities,id',
        'start_date'    =>'required',
        'end_date'      =>'required' 
        // 'creator_id'      =>'required|exists:tbl_orc_cargo,id',
    ]; 
    protected $rules_msg=[
        'orcamento_id.required' =>'Selecione um orçamento para continuar a operação.',
        'orcamento_id.exists'   =>'Selecione um orçamento para continuar a operação.',
        //'activity_id.required'  =>'Selecione uma atividade para continuar a operação.',
        //'activity_id.exists'    =>'Selecione uma atividade para continuar a operação.',
        'start_date.required'   =>'Preencha o campo data início para continuar a operação',
        'end_date.required'     =>'Preencha o campo data fim para continuar a operação'
    ];   

    protected $repo_send_email;
    protected $repo_notificacoes;
    protected $repo_orc_lotacao;
    protected $repo_notify;

    public function __construct()
    {   
        parent::__construct();
        $this->repo_send_email = new RepoEnviarEmail();
        $this->repo_notificacoes = new RepoOrcNotificacoes();
        $this->repo_orc_lotacao = new RepoOrcLotacao();
        $this->repo_notify = new RepoNotify();


    }
    
    public function getRepoSendEmail(){
        return $this->repo_send_email;
    }

    public function getRepoNotification(){
        return $this->repo_notificacoes;
    }

    public function getRepoOrcLotacao(){
        return $this->repo_orc_lotacao;
    }

    public function getRepoNotify(){
        return $this->repo_notify;
    }


    public function listar($orc_id){
        $atividade = new Atividades();
        $tbl_usuario = new Usuario();

        $all = $this->getModelEntity()
        ->leftJoin($atividade->getTable(),$atividade->getColunaAlias('id'),$this->getModelEntity()->getColunaAlias('activity_id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('activity_id'),
            $this->getModelEntity()->getColunaAlias('orc_lotacao_id'),
            $this->getModelEntity()->getColunaAlias('status'),
            $this->getModelEntity()->getColunaAlias('start_date'),
            $this->getModelEntity()->getColunaAlias('end_date'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),

            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $atividade->getColunaAlias('title'),
            $atividade->getColunaAlias('description')
        )
        ->where('orcamento_id',$orc_id)
        ->where('orc_lotacao_id',null)
        
        // ->groupBy($this->getModelEntity()->getColunaAlias('activity_id'))
        // ->having('orcamento_id','=',$orc_id)
        ->get()->toArray(); 
        foreach ($all as $key => $value) {
            $value['activity_id'] =intval($value['activity_id']);
        } 

        return $all;

    }

    public function getActivityHeadcount(){
        return 'Preenchimento do headcount';
    }

    public function getDatesHeadcountOfOrc($orc_id){
        $activityHeadcount = $this->getActivityHeadcount();
        $repo_orc = $this->getOrcInstanceNew();
        $tbl_orc = $repo_orc->getModelEntity()->getTable();
        $tbl_orc_crono = $this->getModelEntity()->getTable();
        $entity_atividade = new Atividades();
        $tbl_activities = $entity_atividade->getTable();
        $datesCronograma = $results = DB::select(DB::raw("select 
        orc.data_inicio as ini_orc,
        orc.data_fim as fim_orc,
        cro.orc_lotacao_id as lotac_id,
        COALESCE(cro.start_date, orc.data_inicio ) as ini,	
        COALESCE(cro.end_date, orc.data_fim ) as fim
        from 
        $tbl_orc orc
        left join $tbl_orc_crono cro
        on cro.orcamento_id = orc.id  
        left join $tbl_activities act 
        on act.id = cro.activity_id
        where orc.id = '$orc_id'
        and act.title = '$activityHeadcount'"));

        $datesOrc = DB::select(DB::raw("select 
        data_inicio,
        data_fim
        from 
        $tbl_orc orc
        where orc.id = '$orc_id'"));

        $return = [];

        $return['orc'] = ['ini'=>Carbon::parse($datesOrc[0]->data_inicio), 'fim'=>Carbon::parse($datesOrc[0]->data_fim)];


        foreach ($datesCronograma as $lotac) {
            //Retorna um array, onde a chave de cada posição é o id da lotacao e é formada por um array com o ini e o fim
            $return[$lotac->lotac_id] = ['ini'=>Carbon::parse($lotac->ini), 'fim'=>Carbon::parse($lotac->fim)];
        }

        return $return;
    }

    public function getDateLotac($typeDate, $datesToHeadcount,$lot_id){
        return array_key_exists($lot_id,$datesToHeadcount) ? $datesToHeadcount[$lot_id][$typeDate] : $datesToHeadcount['orc'][$typeDate];
    }

    public function handleReleaseHC($event){
        $repo_lotacao = new RepoOrcLotacao();
        $lot_name_space =$repo_lotacao->getModelNameSpace();
        $orc_lot_id = $event->orc_lotacao_id;
        $lot_id = $event->lotacao_id;
        $orc_id = $event->orc_id;
        $hierarquia = $event->hierarquia;
        $ano = $event->orc_ano;
        $descricao = $event->orcamento;
        $this->preencherArquivoLog('Liberar o preenchimento do headcount (orc - '.$orc_id.')(lotac - '.$orc_lot_id.') --> ');

        $sendLot = $this->releasedStatus($orc_lot_id,$lot_name_space);
        if($sendLot['status'] != 'success'){ 
            return false;
        }

        $this->getRepoSendEmail()->notifyManagersRelease($lot_id, $hierarquia, $ano, $descricao );
        if(!$this->insertNotify(10033, $this->getMessageReleaseHC(), $orc_id, $event->type, $this->getTipoMessage($event->type))){
            $this->setError($this->getRepoNotification()->getErrosFlatted());
            return false;
        }

        $this->sp_hnd_atualiza_headcount_ppr($orc_id);
        $this->sp_hnd_atualiza_headcount_bonus($orc_id);
        
        return true;
    }

    public function handleSendHeadcount($event){
        $repo_lotacao = new RepoOrcLotacao();
        $lot_name_space =$repo_lotacao->getModelNameSpace();
        $orc_lot_id = $event->orc_lotacao_id;
        $lot_id = $event->lotacao_id;
        $orc_id = $event->orc_id;
        $hierarquia = $event->hierarquia;
        $ano = $event->orc_ano;
        $descricao = $event->orcamento;

        $this->preencherArquivoLog('Enviar o headcount (orc - '.$orc_id.')(lotac - '.$orc_lot_id.') --> ');
        
        $sendLot = $this->getRepoOrcLotacao()->sendStatus($orc_lot_id, $this->getRepoOrcLotacao()->getModelNameSpace());
        if($sendLot['status'] != 'success'){ 
            return false;
        }

        
        if(!$this->getRepoNotify()->notifySystemSend($orc_lot_id, $hierarquia, $ano, $descricao, $orc_id)){
            return $this->getRepoNotify()->getErrosFlatted();
        }

        // $this->getRepoSendEmail()->notifyManagersSendSystem($lot_id, $hierarquia, $ano, $descricao);
        

        // if(!$this->insertNotify(10033, $this->getMessageSend(), $orc_id, $event->type, $this->getTipoMessage($event->type))){
        //     $this->setError($this->getRepoNotification()->getErrosFlatted());
        //     return false;
        // }

        return true;
    }

    public function handleNotifTimeHC($event){

        $orc_lot_id = $event->orc_lotacao_id;
        $lot_id = $event->lotacao_id;
        $orc_id = $event->orc_id;
        $timePreencher = $event->tempo_preencher;
        $hierarquia = $event->hierarquia;
        $ano = $event->orc_ano;
        $descricao = $event->orcamento;

        $this->preencherArquivoLog('notificar prazo do headcount (orc - '.$orc_id.')(lotac - '.$orc_lot_id.') --> ');

        if(!$this->getRepoNotify()->notifyTimeFillHC($orc_lot_id, $hierarquia, $ano, $descricao, $orc_id, $timePreencher)){
            return $this->getRepoNotify()->getErrosFlatted();
        }
        // $this->getRepoSendEmail()->notifyManagersSendSystemPrevious($lot_id, $hierarquia, $ano, $descricao, $timePreencher);

        // $this->notifyTimeHC($orc_id, $timePreencher, $event->type);


        return true;
    }

    public function handleReopenLotac($event){
        $repo_lotacao = new RepoOrcLotacao();
        $lot_name_space =$repo_lotacao->getModelNameSpace();
        $orc_lot_id = $event->orc_lotacao_id;
        $lot_id = $event->lotacao_id;
        $orc_id = $event->orc_id;
        $hierarquia = $event->hierarquia;
        $ano = $event->orc_ano;
        $descricao = $event->orcamento;

        $this->preencherArquivoLog('Reabrir o headcount (orc - '.$orc_id.')(lotac - '.$orc_lot_id.') --> ');
        
        $sendLot = $this->reopenedStatus($orc_lot_id,$lot_name_space);
        if($sendLot['status'] != 'success'){ 
            return false;
        }        

        if(!$this->getRepoNotify()->notifyReopen($orc_lot_id, $hierarquia, $ano, $descricao, $orc_id)){
            return $this->getRepoNotify()->getErrosFlatted();
        }

        return true;
    }

    public function handleReleaseBudget($event){
        $id_orc = $event->orc_id;
        $ano = $event->orc_ano;
        $descricao = $event->orcamento;
        $hierarquia = $event->hierarquia;
        $repo_script = new RepoOrcScriptCalculos();
        $repo_orcamento = new RepoOrcamento();
       
        $popula_headcount = $repo_script->scriptInsertOrcHeadCount($id_orc);

        if($popula_headcount['status']=='error'){
            return $popula_headcount;
        }

        // $this->getRepoNotify()->notifyReleaseBudget(null, $orc->getOrcParametros[0]->valor_parametro, $orc->ano, $orc->descricao_orc, $id_orc);
        // $this->getRepoSendEmail()->notifyManagersReleaseBudget($hierarquia, $ano, $descricao);


        $retorno = $repo_orcamento->releasedStatus($id_orc,$repo_orcamento->getModelNameSpace(),'status_orc');
        // $this->notifyReleaseOrc($id_orc);


        return $retorno;
        // $this->getRepoSendEmail()->notifyManagersReopened($lot_id, $hierarquia, $ano, $descricao);

        // if(!$this->insertNotify(10033, $this->getMessageReopenLotac(), $orc_id, $event->type, $this->getTipoMessage($event->type))){
        //     $this->setError($this->getRepoNotification()->getErrosFlatted());
        //     return false;
        // }

        // return true;
    }

    public function verifyBudget(){
        $allEvents = $this->getAllEvents();

        DB::beginTransaction();
        try {
            foreach ($allEvents as $event) {
                $metodo = $event->type;
                if(!$this->$metodo($event)){
                    dd("Deu alguma coisa errada", $event);
                };
            }
            DB::commit();

        } catch (\Exception $e) {
            abort(500,'Tente novamente mais tarde. Erro: 040220201010. '.$e);
        }

        return 'ok';
    }
    
    public function verifyBudgetDan(){
        $crono_name_space = $this->getModelNameSpace();
        $repo_lotacao = new RepoOrcLotacao();
        $repo_orc = $this->getOrcInstanceNew();
        $whereIn = [$this->getStatusPendente(),$this->getStatusLiberado()];//,$this->getStatusFinalizado()];
        $all_orc = $repo_orc->getModelEntity()->where('is_suspended',0)
        ->whereIn('status_orc',$whereIn)->get()->toArray();

        $all = $this->findBy('status_orc',$this->getStatusLiberado());

        $allEvents = $this->getAllEvents();

        DB::beginTransaction();

        $this->preencherArquivoLog('Pegou os orçamentos --> ');
            
        try {

            foreach ($all_orc as $orc) {
                $diasNotifHC = $this->getParamByOrc($orc['id'], $this->getCodDiasNotificarFimHeadCount());
                
                $datesToHeadcount = $this->getDatesHeadcountOfOrc($orc['id']);
                
                $this->handleReleaseOrc($orc['id'], $datesToHeadcount);
                $this->handleSendHeadcount($orc['id'], $datesToHeadcount, $diasNotifHC);
                DB::commit();
            }
         } catch (\Exception $e) {
            abort(500,'Tente novamente mais tarde. Erro: 040220201010. '.$e);
        }

        $this->preencherArquivoLog('Concluiu a rotina de verificação do budget --> ');

        return 'ok';
    }

    public function getAllEvents(){
        $result = DB::select("EXEC getValidationsBudget");
        if(!$result){
           return [];
        } 
        return $result;
    }

    public function getAllEventsOld(){
        $repo_orc_param = new RepoOrcParametros();
        $tbl_orc_param = $repo_orc_param->getModelEntity()->getTable();
        $repo_orc_lotac = new RepoOrcLotacao();
        $tbl_orc_lotac = $repo_orc_lotac->getModelEntity()->getTable();
        $repo_orc = new RepoOrcamento();
        $tbl_orc = $repo_orc->getModelEntity()->getTable();
        $tbl_orc_crono = $this->getModelEntity()->getTable();
        $repo_atividades = new RepoAtividades();
        $tbl_atividades = $repo_atividades->getModelEntity()->getTable();
        $statusPendente = $this->getStatusPendente();
        $statusLiberado = $this->getStatusLiberado();
        $ativPrenchHC = 'Preenchimento do headcount';

        $results = DB::select(DB::raw("DECLARE @date_now datetime; 
        select @date_now = CONVERT(DATETIME,CONVERT(VARCHAR, GETDATE() ,112));
        
        with Params as (
            SELECT orcamento_id, [19] as hierarquia, [20] as dias_notif
                FROM (
                    select parametro_id, orcamento_id, valor_parametro from $tbl_orc_param
                ) Param
                PIVOT(
                    max(valor_parametro)
                        FOR parametro_id
                        IN([19],[20])  
                )AS ParamPivot
            ),
            Lotacoes as (
                SELECT	
                    orc.id as orc_id
                    ,orc.ano as orc_ano
                    ,orc.descricao_orc as descricao_orc
                    ,orc.status_orc as status_orc
                    ,orc.data_fim
                    ,orc.data_inicio
                    ,cro.start_date
                    ,cro.end_date
                    ,act.title
                    ,lotac.[id] as orc_lotacao_id
                    ,lotac.lotacao_id as lotacao_id
                    ,lotac.[status] as status_lotac
                    ,Params.hierarquia
                    ,Params.dias_notif
                FROM $tbl_orc_lotac as lotac
                inner join $tbl_orc as orc 
                    on  orc.id = lotac.orcamento_id
                left join $tbl_orc_crono as cro
                    on cro.orc_lotacao_id = lotac.id  
                left join $tbl_atividades act 
                    on act.id = cro.activity_id
                left join Params
                    on Params.orcamento_id = orc.id
                where responder_orc = 1
                    and orc.is_suspended = 0
                    and orc.data_inicio is not null
                    and orc.data_fim is not null
            )
        
        /*SELECT DOS REGISTROS DE LIBERAR HEADCOUNT*/
        SELECT	
            lotac.orc_id as orc_id
            ,lotac.descricao_orc as orcamento
            ,lotac.orc_ano as orc_ano
            ,lotac.orc_lotacao_id as orc_lotacao_id
            ,lotac.lotacao_id as lotacao_id
            ,lotac.status_orc as status_orc
            ,lotac.status_lotac as status_lotac
            ,COALESCE(lotac.start_date, lotac.data_inicio ) as date
            ,'handleReleaseHC' as type
            ,lotac.hierarquia
            ,NULL as tempo_preencher
        FROM Lotacoes as lotac
        where @date_now = CONVERT(DATETIME,CONVERT(VARCHAR, COALESCE(lotac.start_date, lotac.data_inicio ) ,112))
          and lotac.status_lotac = $statusPendente
          and lotac.title = '$ativPrenchHC'
        
          union
        
           /*SELECT DOS REGISTROS DE ENVIAR O HEADCOUNT MESMO SE NÃO PREENCHIDO*/
        
        SELECT
            lotac.orc_id as orc_id
            ,lotac.descricao_orc as orcamento
            ,lotac.orc_ano as orc_ano
            ,lotac.orc_lotacao_id as orc_lotacao_id
            ,lotac.lotacao_id as lotacao_id
            ,lotac.status_orc as status_orc
            ,lotac.status_lotac as status_lotac
            ,COALESCE(lotac.end_date, lotac.data_fim ) as date
            ,'handleSendHeadcount' as type
            ,lotac.hierarquia as hierarquia
            ,null as tempo_preencher
        FROM Lotacoes as lotac
        where @date_now = CONVERT(DATETIME,CONVERT(VARCHAR, COALESCE(lotac.end_date, lotac.data_fim ) ,112))
            and lotac.status_lotac = $statusLiberado
            and lotac.title = '$ativPrenchHC'
        
          union  
          
          /*SELECT DOS REGISTROS para enviar a notificação de que o prazo para preencher está se encerrando*/
        
        SELECT	
            lotac.orc_id as orc_id
            ,lotac.descricao_orc as orcamento
            ,lotac.orc_ano as orc_ano
            ,lotac.orc_lotacao_id as orc_lotacao_id
            ,lotac.lotacao_id as lotacao_id
            ,lotac.status_orc as status_orc
            ,lotac.status_lotac as status_lotac
            ,COALESCE(lotac.end_date, lotac.data_fim ) as date
            ,'handleNotifTimeHC' as type			
            ,lotac.hierarquia as hierarquia
            ,DATEDIFF(day,@date_now,CONVERT(DATETIME,CONVERT(VARCHAR, COALESCE(lotac.end_date, lotac.data_fim ) ,112))) as tempo_preencher
        FROM Lotacoes as lotac
        where DATEDIFF(day,@date_now,CONVERT(DATETIME,CONVERT(VARCHAR, COALESCE(lotac.end_date, lotac.data_fim ) ,112))) <= lotac.dias_notif
            and lotac.status_lotac = $statusLiberado
            and lotac.title = '$ativPrenchHC'
        order by lotac.orc_id , lotac.lotacao_id"));

        return $results;
    }

    // public function verifyBudgetSam(){
        //     $crono_name_space = $this->getModelNameSpace();
        //     $repo_lotacao = new RepoOrcLotacao();
        //     $repo_orc = $this->getOrcInstanceNew();
        //     $whereIn = [$this->getStatusLiberado(),$this->getStatusFinalizado()];
        //     $all_orc = $repo_orc->getModelEntity()
        //     ->where('is_suspended',0)
        //     ->whereIn('status_orc',$whereIn)->get()->toArray();

        //     // $all = $this->findBy('status_orc',$this->getStatusLiberado());
        //     DB::beginTransaction();
            
        //     $data = Carbon::now()->format('d/m/Y H:i:s')."\n";
        //     $conteudo = 'Pegou os orçamentos --> ' . $data;
        //     file_put_contents('C:\Users\insti\Documents\Projetos\Desenvolvimento\MRN\natureza51\mrn-natureza-51\Entrou na rotina.txt', $conteudo, FILE_APPEND);

        //     try {
                
        //         /**Percorrendo os orçamentos */
        //         foreach ($all_orc as $orc) {
        //             $dt_atual = strtotime(Date('Y-m-d'));
        //             $orc_id = $orc['id'];
        //             $lotacoes = $repo_lotacao->getModelEntity()->where([
        //                 ['orcamento_id',$orc_id],
        //                 // ['status',$this->getStatusPendente()]
        //             ])->get()->toArray(); 

        //             $cronogramas = $this->getModelEntity()->where([
        //                 ['orcamento_id',$orc_id],       
        //                 // ['status',$this->getStatusPendente()]
        //             ])->get()->toArray();
                
        //             /**Percorrendo as atividades do Cronograma */
        //             foreach ($cronogramas as $cronograma) {
        //                 $crono_id = $cronograma['id'];
        //                 $crono_status = $cronograma['status'];
        //                 $end_date = strtotime($cronograma['end_date']);
        //                 $start_date = strtotime($cronograma['start_date']);
        //                 $validation = $dt_atual < $start_date;
        //                 /**Percorrendo as atividades da lotação*/ 
        //                 foreach ($lotacoes as $lotacao) {
        //                     $lot_name_space =$repo_lotacao->getModelNameSpace();
        //                     $lot_id = $lotacao['id'];
        //                     $lot_status = $lotacao['status'];
                
        //                      /**Verifica se a atividade está vencida */
        //                     if($end_date == $dt_atual){
                                
        //                         $data = Carbon::now()->format('d/m/Y H:i:s')."\n";
        //                         $conteudo = 'Achou um orçamento com a data vencida --> ' . $data;
        //                         file_put_contents('C:\Users\insti\Documents\Projetos\Desenvolvimento\MRN\natureza51\mrn-natureza-51\Entrou na rotina.txt', $conteudo, FILE_APPEND);

        //                         /** SE A LOTAÇÃO FOR PENDENTE OU EM ANDAMENTO ENVIA PELO SISTEMA */
        //                         if($lot_status == $this->getStatusPendente() || $lot_status == $this->getStatusEmAndamento()){
        //                             $sendLot = $this->sendSystemStatus($lot_id,$lot_name_space);
        //                             if($sendLot['status'] != 'success'){ 
        //                                 return false;
        //                             }

        //                             $this->getRepoSendEmail()->notifyManagersSendSystem($id_orc);

        //                             // $sendCrono = $this->completedStatus($crono_id,$crono_name_space);
        //                             // if($sendCrono['status'] != 'success'){
        //                             //     return false;
        //                             // }
        //                         }
                                
        //                     }
                            
        //                     /**Verifica se a atividade já iníciou */
        //                     if($start_date == $dt_atual){
                                
        //                         $data = Carbon::now()->format('d/m/Y H:i:s')."\n";
        //                         $conteudo = 'Achou um orçamento que a atividade ja iniciou --> ' . $data;
        //                         file_put_contents('C:\Users\insti\Documents\Projetos\Desenvolvimento\MRN\natureza51\mrn-natureza-51\Entrou na rotina.txt', $conteudo, FILE_APPEND);

                            
        //                         if($lot_status == $this->getStatusPendente() || $lot_status == $this->getStatusEmAndamento()){
                                
        //                             $sendLot = $this->inProgressStatus($lot_id,$lot_name_space);

        //                             if($sendLot['status'] != 'success'){ 
        //                                 return false;
        //                             }
        //                             // $sendCrono = $this->inProgressStatus($crono_id,$crono_name_space);
        //                             // if($sendCrono['status'] != 'success'){
        //                             //     return false;
        //                             // }
        //                         }
        //                         /**SE A LOTAÇÃO FOR FINALIZADA / PRONTA PARA FORECAST */
        //                         if($lot_status == $this->getStatusFinalizado()){
        //                             $sendLot = $this->inExecutionStatus($lot_id,$lot_name_space);
        //                             if($sendLot['status'] != 'success'){ 
        //                                 return false;
        //                             }
        //                         }
        //                     }  
        //                 }
        //             }  
        //         }
        //         saida:
        //         DB::commit();

        //     } catch (\Exception $e) {
        //         abort(500,'Tente novamente mais tarde. Erro: 040220201010. '.$e);
        //     }

            
        //     $data = Carbon::now()->format('d/m/Y H:i:s')."\n";
        //     $conteudo = 'Concluiu a rotina de verificação do budget --> ' . $data;
        //     file_put_contents('C:\Users\insti\Documents\Projetos\Desenvolvimento\MRN\natureza51\mrn-natureza-51\Entrou na rotina.txt', $conteudo, FILE_APPEND);


        //     return 'ok';
        //         // try {
        //         //     foreach ($all_orc as $key => $value) {
        //         //         $dt_atual = strtotime(Date('Y-m-d'));
        //         //         $orc_id = $value['id'];
        //         //         $repo_lotacao->findBy('orcamento_id',$orc_id);
                        
        //         //         $cronogramas = $this->getModelEntity()->where([
        //         //              ['orcamento_id',$orc_id],
        //         //             ['status',1]
        //         //         ])->get()->toArray();
                        
            
        //         //         foreach ($cronogramas as $cronograma) {
        //         //             if($cronograma['end_date']/*== Date('Y-m-d')*/){
                            
                                
        //         //                 $cronograma['status'] = $this->getStatusFinalizado();   
        //         //                 dd($cronograma);                                      
        //         //                 if(!$this->updated($cronograma,$cronograma['id'])){
        //         //                     abort(500,'Tente novamente mais tarde. Erro: 030220202021.');
        //         //                 }
            
        //         //             }
            
        //         //             // if(strtotime($cronograma['start_date']) >= $dt_atual ){
            
        //         //             // }
        //         //             // dd('samuel',$cronograma['end_date']);
            
        //         //         }
            
        //         //         // if($this->end_date == Date('Y-m-d')){
                        
        //         //         // }    
        //         //     }
        //         //     DB::commit();
        //         // } catch (\Exception $th) {
        //         //     DB::rollBack();
        //         //     abort(500,'Tente novamente. Erro: 030220202117.');
        //         // }


    // }

    public function updated($array,$id){
        // dd('aaaaaasamue',$array);
        if(!$this->update($array,$id)){
            return false;
        }

        return true;
    }

    public function insertCronograma($form_data){
        // dd("knskfnksnfkd",$form_data);

        $atividade = Atividades::find($form_data['activity_id']);
            //    dd("knskfnksnfkd",$atividade);

        //  $count_lot = count($form_data['op_values']);
     DB::beginTransaction();

     try {

        if(count($form_data['op_values']) == 0){

            $form_data['orc_lotacao_id'] = null;

            $select = $this->getModelEntity()->where([
                ['orcamento_id',$form_data['orcamento_id']],
                ['orc_lotacao_id',null],
                ['activity_id',$form_data['activity_id']]
            ])->get()->toArray();
           
 
         //  dd($select);

        
            if(!empty($select)){
                $this->setError('Registro já inserido. Erro: 170520201345.');
                return false;
            }



            $data_ini= Carbon::parse($form_data['start_date']);
            $data_fim=Carbon::parse($form_data['end_date']);
            for($i=0;$i<=$form_data['num_repeticao'];$i++){

                #COLOCANDO PARA OS PROXIMOS MESES DE ACORDO COM O NUMERO DE REPETIÇÕES

                $form_data['start_date'] =$data_ini->copy()->addMonths($i);
                $form_data['end_date'] =$data_fim->copy()->addMonths($i);


                if($atividade->ajusta_data == 1){
                        #COLOCANDO DATA INICIO SEMPRE PARA SEGUNDA-FEIRA
                                    
                        if($form_data['start_date']->dayOfWeek == 2){
                            $form_data['start_date']->addDays(6);
                        }
                        else if($form_data['start_date']->dayOfWeek == 3){
                            $form_data['start_date'] ->addDays(5);
                        }
                        else if($form_data['start_date']->dayOfWeek == 4){
                            $form_data['start_date']->addDays(4);
                        }
                        else if($form_data['start_date']->dayOfWeek == 5){
                            $form_data['start_date']->addDays(3);
                        }
                        else if($form_data['start_date']->dayOfWeek == 6){
                            $form_data['start_date']->addDays(2);
                        }  
                        else if($form_data['start_date']->dayOfWeek == 0){
                            $form_data['start_date']->addDays(1);
                        }      

                        #COLOCANDO DATA FIM SEMPRE PARA SEXTA-FEIRA

                        if($form_data['end_date']->dayOfWeek == 1){
                            $form_data['end_date']->addDays(4);
                        }               
                        if($form_data['end_date']->dayOfWeek == 2){
                            $form_data['end_date']->addDays(3);
                        }
                        else if($form_data['end_date']->dayOfWeek == 3){
                            $form_data['end_date'] ->addDays(2);
                        }
                        else if($form_data['end_date']->dayOfWeek == 4){
                            $form_data['end_date']->addDays(1);
                        }
                        else if($form_data['end_date']->dayOfWeek == 6){
                            $form_data['end_date']->addDays(6);
                        }  
                        else if($form_data['end_date']->dayOfWeek == 0){
                            $form_data['end_date']->addDays(5);
                        }      
                }            
                    
       
                
                    $create =$this->create($form_data);
        
                    if(!$create){
                    $this->setError('Falha ao inserir o registro. Erro: 170520201346.');
                    return false;
                    }
            }


 

        }
        
      
       foreach ($form_data['op_values'] as $value) {
           $form_data['orc_lotacao_id'] = $value;

           $select = $this->getModelEntity()->where([
               ['orcamento_id',$form_data['orcamento_id']],
               ['orc_lotacao_id',$value],
               ['activity_id',$form_data['activity_id']]
           ])->get()->toArray();
          

        //  dd($select);

           if(!empty($select)){
               $this->setError('Registro já inseridos. Erro: 020320201424.');
               return false;
           }
        
           $create =$this->create($form_data);

           if(!$create){
            $this->setError('Falha ao inserir o registro. Erro: 020320201412.');
             return false;
           }

       }

       


       DB::commit();
     } catch (\Exception $e) {
         DB::rollBack();
         abort(500,'Erro ao inserir o registro. Erro: 020320201146. '.$e);
     }

     return true;


    }

    public function insertAtvLotacao($dados){
        
        $inserir = $this->create($dados);
        if(!$inserir){
            $this->setError("Falha ao inserir registro.");
            return false;
        }
        return true;
    }

    public function updateAtvLotacao($dados, $id){
        
        $inserir = $this->update($dados, $id);
        if(!$inserir){
            // $this->setError("Falha ao atualizar registro.");
            return false;
        }
        return true;
    }

    public function listarLotacaoAtividade($orc_id, $periodo = null, $tipo_table = 'O'){
        
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_cc = new CentroCusto();
        $tbl_atividade = new Atividades();
        $tbl_lotacao = new Lotacao();
        $tbl_usuario = new Usuario();

        $select = $this->getModelEntity()
        ->leftJoin($tbl_atividade->getTable(), $this->getModelEntity()->getColunaAlias('activity_id'), $tbl_atividade->getColunaAlias('id'))

        ->leftJoin($tbl_orc_lotacao->getTable(), $this->getModelEntity()->getColunaAlias('orc_lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_cc->getTable(), $tbl_orc_lotacao->getColunaAlias('cc_custo_id'), $tbl_cc->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            $this->getModelEntity()->getColunaAlias('status'),
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('activity_id'),
            $this->getModelEntity()->getColunaAlias('orc_lotacao_id'),
            $this->getModelEntity()->getColunaAlias('start_date'),
            $this->getModelEntity()->getColunaAlias('end_date'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),

            $tbl_lotacao->getColunaAlias('unid_lotac'),
            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            $tbl_atividade->getColunaAlias('title'),
            $tbl_atividade->getColunaAlias('description'),
            $tbl_cc->getColunaAlias('cod_ccusto'),
            $tbl_cc->getColunaAlias('des_ccusto')
        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id)

        ->whereNotNull($this->getModelEntity()->getColunaAlias('orc_lotacao_id'))
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table);

        if($tipo_table == 'F'){
            $select = $select->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $select->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }

        return $select;
    }

    public function updateCronograma($form_data){
        
        $select = $this->getModelEntity()
        ->select()->where([
            [$this->getModelEntity()->getColunaAlias('activity_id'),'=',$form_data['activity_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$form_data['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$form_data['orcamento_id']]
        ])->get()->toArray();
            
        if(count($select) > 0){
            $this->setError('Registro já existente ou não atualizado.');
            return false;
        }

           #COLOCANDO DATA INICIO SEMPRE PARA SEGUNDA-FEIRA
            
           if($form_data['start_date']->dayOfWeek == 2){
            $form_data['start_date']->addDays(6);
        }
        else if($form_data['start_date']->dayOfWeek == 3){
            $form_data['start_date'] ->addDays(5);
        }
        else if($form_data['start_date']->dayOfWeek == 4){
            $form_data['start_date']->addDays(4);
        }
        else if($form_data['start_date']->dayOfWeek == 5){
            $form_data['start_date']->addDays(3);
        }
        else if($form_data['start_date']->dayOfWeek == 6){
            $form_data['start_date']->addDays(2);
        }  
       else if($form_data['start_date']->dayOfWeek == 0){
            $form_data['start_date']->addDays(1);
        }      
        
        #COLOCANDO DATA FIM SEMPRE PARA SEXTA-FEIRA

        if($form_data['end_date']->dayOfWeek == 1){
            $form_data['end_date']->addDays(4);
        }               
        if($form_data['end_date']->dayOfWeek == 2){
            $form_data['end_date']->addDays(3);
        }
        else if($form_data['end_date']->dayOfWeek == 3){
            $form_data['end_date'] ->addDays(2);
        }
        else if($form_data['end_date']->dayOfWeek == 4){
            $form_data['end_date']->addDays(1);
        }
       else if($form_data['end_date']->dayOfWeek == 6){
            $form_data['end_date']->addDays(6);
        }  
       else if($form_data['end_date']->dayOfWeek == 0){
            $form_data['end_date']->addDays(5);
        }      
        
        $edit = $this->update($form_data,$form_data['id']);

        if(!$edit){
           $this->setError('Erro ao atualizar o registro. Erro: 020320201548');
            return false;
        }
        return true;
    }

    public function deleteCronograma($id){
        // dd($id['id']);
        $delete = $this->delete($id['id']);

        if(!$delete){
            $this->setError('Erro ao deletar o registro. Erro: 020320201607');
             return false;
         }
         return true;
    }

    public function notifyReleaseOrc($orc_id){
        $this->insertNotify(10033, $this->getMessageReleaseOrc(), $orc_id, 'notifyReleaseOrc', $this->getTipoMessage('notifyReleaseOrc'));
    }

    public function notifyTimeHC($orc_id, $dias, $method){
        $this->insertNotify(10033, $this->getMessageNotifTimeHC($dias), $orc_id, $method, $this->getTipoMessage($method));
    }

    public function notifySendHeadcount($orc_id, $method){
        $this->insertNotify(10033, $this->getMessageSendHC(), $orc_id, $method, $this->getTipoMessage($method));
    }

    public function sp_hnd_atualiza_headcount_ppr($orc_id){
        $value  = 'Falha ao inserir registros na tela PPR! Erro: 020920200931';
        $usuario_id = $this->fillCriadoPor();
        
        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_ppr :p_orcamento_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200931 | sp_hnd_atualiza_headcount_ppr';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200931 - ' . 'sp_hnd_atualiza_headcount_ppr';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function sp_hnd_atualiza_headcount_bonus($orc_id){
        $value  = 'Falha ao inserir registros na tela PPR! Erro: 020920200935';
        $usuario_id = $this->fillCriadoPor();
        
        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_bonus :p_orcamento_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200935 | sp_hnd_atualiza_headcount_bonus';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao atualizar registro. Erro: 020920200935 - ' . 'sp_hnd_atualiza_headcount_bonus';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }
    
}