<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Repositories\RepoCalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcDespesas;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Illuminate\Support\Arr;
use Exception;
use Illuminate\Support\Facades\DB;
use stdClass;

class RepoOrcDespesas extends RepositoryNat51{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcDespesas';
    protected $form_rules=[];
    protected $rules_msg=[];
    protected $msg;

    public function listar($orc_id, $periodo = null, $tipo_table = 'O'){
        $calc_orcamento=new CalcOrcamento();
        $orc_despesa=new OrcDespesas();
        $tbl_orc_lotacao=new OrcLotacao();
        $tbl_lotacao=new Lotacao();
        $tbl_ccusto = new CentroCusto();
        $tbl_usuario = new Usuario();
        
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        $query = $this->getModelEntity()
        ->join($calc_orcamento->getTable(), $this->getModelEntity()->getColunaAlias('id'), '=', 
            DB::raw("{$calc_orcamento->getColunaAlias('origem_id')} and 
            {$calc_orcamento->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))
        
        ->leftJoin($tbl_orc_lotacao->getTable(),$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$tbl_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_lotacao->getTable(),$tbl_orc_lotacao->getColunaAlias('lotacao_id'),'=',$tbl_lotacao->getColunaAlias('id'))

        ->leftJoin($tbl_ccusto->getTable(), $tbl_orc_lotacao->getColunaAlias('cc_custo_id'), $tbl_ccusto->getColunaAlias('id'))
        
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
                                
        ->select(
            DB::raw($calc_orcamento->getColunaAlias('id')),
            
            $calc_orcamento->getColunaAlias('origem_id'),
            $orc_despesa->getColunaAlias('orc_id'), 
            $orc_despesa->getColunaAlias('lotacao_id'),
            $orc_despesa->getColunaAlias('despesa_id'),
            $orc_despesa->getColunaAlias('centro_custo_id'),
            $calc_orcamento->getColunaAlias('tbl_origem'),
            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            DB::raw("{$calc_orcamento->getColunaAlias('id')} as calc_orc"),
            DB::raw("CONCAT({$tbl_ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$tbl_lotacao->getColunaAlias('unid_lotac')}, ' - ', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as lotacao"),
            $orc_despesa->getColunaAlias('valor_referencia'),
            $calc_orcamento->getColunaAlias('jan_orcado'),
            $calc_orcamento->getColunaAlias('fev_orcado'),
            $calc_orcamento->getColunaAlias('mar_orcado'),
            $calc_orcamento->getColunaAlias('abr_orcado'),
            $calc_orcamento->getColunaAlias('mai_orcado'),
            $calc_orcamento->getColunaAlias('jun_orcado'),
            $calc_orcamento->getColunaAlias('jul_orcado'),
            $calc_orcamento->getColunaAlias('ago_orcado'),
            $calc_orcamento->getColunaAlias('set_orcado'),
            $calc_orcamento->getColunaAlias('out_orcado'),
            $calc_orcamento->getColunaAlias('nov_orcado'),
            $calc_orcamento->getColunaAlias('dez_orcado'),
            $this->getModelEntity()->getColunaAlias('id'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
            
        )
        ->where('orc_id','=',$orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'),'=',$tipo_table);
        //->whereIn($tbl_lotacao->getColunaAlias('id'),$lotacoes)
        
        $a = [];

        if($tipo_table == 'F'){
            $a = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->with('getDespesas', 'getLotacao')->get()->toArray();
        }
        else{
            $a = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->with('getDespesas', 'getLotacao')->get()->toArray();
        }

        
        for($i = 0; $i < count($a); $i++){
            $a[$i]['descricao'] = $a[$i]['get_despesas']['descricao'];
            //$a[$i]['des_unid_lotac']=$a[$i]['get_lotacao']['des_unid_lotac'];
            //$a[$i]['description']=$a[$i]['lotacao_id'].' - '.$a[$i]['des_unid_lotac'];

            // $a[$i]['valor_referencia']=formatarNumeroPtBr($a[$i]["valor_referencia"], 4);
            // $a[$i]['jan_orcado']=formatarNumeroPtBr($a[$i]["jan_orcado"], 4);
            // $a[$i]['fev_orcado']=formatarNumeroPtBr($a[$i]["fev_orcado"], 4);
            // $a[$i]['mar_orcado']=formatarNumeroPtBr($a[$i]["mar_orcado"], 4);
            // $a[$i]['abr_orcado']=formatarNumeroPtBr($a[$i]["abr_orcado"], 4);
            // $a[$i]['mai_orcado']=formatarNumeroPtBr($a[$i]["mai_orcado"], 4);
            // $a[$i]['jun_orcado']=formatarNumeroPtBr($a[$i]["jun_orcado"], 4);
            // $a[$i]['jul_orcado']=formatarNumeroPtBr($a[$i]["jul_orcado"], 4);
            // $a[$i]['ago_orcado']=formatarNumeroPtBr($a[$i]["ago_orcado"], 4);
            // $a[$i]['set_orcado']=formatarNumeroPtBr($a[$i]["set_orcado"], 4);
            // $a[$i]['out_orcado']=formatarNumeroPtBr($a[$i]["out_orcado"], 4);
            // $a[$i]['nov_orcado']=formatarNumeroPtBr($a[$i]["nov_orcado"], 4);
            // $a[$i]['dez_orcado']=formatarNumeroPtBr($a[$i]["dez_orcado"], 4);
            
            $a[$i]['identificador'] = "2";
            unset($a[$i]['get_despesas']);
            unset($a[$i]['get_lotacao']);
            

        } 

        return $a;
    }

    public function listarIndices($orc_id){
        $tbl_calc_ind = new CalcIndice();
        $tb_despesas = new Despesas();
        $tb_orc_lotacao = new OrcLotacao();
        $tb_lotacao = new Lotacao();

        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));

        $dados = $this->getModelEntity()
        
        ->leftJoin($tbl_calc_ind->getTable(),$this->getModelEntity()->getColunaAlias('id'),$tbl_calc_ind->getColunaAlias('origem_id'))

        ->leftJoin($tb_despesas->getTable(),$this->getModelEntity()->getColunaAlias('despesa_id'),$tb_despesas->getColunaAlias('id'))
        ->leftJoin($tb_orc_lotacao->getTable(),$this->getModelEntity()->getColunaAlias('lotacao_id'),$tb_orc_lotacao->getColunaAlias('id'))
        ->leftJoin($tb_lotacao->getTable(),$tb_orc_lotacao->getColunaAlias('lotacao_id'),$tb_lotacao->getColunaAlias('id'))
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),//
            $tb_lotacao->getColunaAlias('des_unid_lotac'),//
            $tb_despesas->getColunaAlias('descricao'),//
            DB::raw("{$tb_despesas->getColunaAlias('id')} as despesa_id"),//
            // DB::raw("{$this->getModelEntity()->getColunaAlias('id')} as orc_despesa_id"),
            DB::raw("{$tb_orc_lotacao->getColunaAlias('id')} as orc_lotacao_id"),
            DB::raw("{$tb_lotacao->getColunaAlias('id')} as lotacao_id"),
            
            
            $this->getModelEntity()->getColunaAlias('valor_referencia'),
            $this->getModelEntity()->getColunaAlias('centro_custo_id'),
            $this->getModelEntity()->getColunaAlias('orc_id'),
            
            DB::raw("{$tbl_calc_ind->getColunaAlias('id')} as calc_ind"),
            $tbl_calc_ind->getColunaAlias('origem_id'),
            $tbl_calc_ind->getColunaAlias('tbl_origem'),
            $tbl_calc_ind->getColunaAlias('jan_indice'),
            $tbl_calc_ind->getColunaAlias('fev_indice'),
            $tbl_calc_ind->getColunaAlias('marc_indice'),
            $tbl_calc_ind->getColunaAlias('abril_indice'),
            $tbl_calc_ind->getColunaAlias('maio_indice'),
            $tbl_calc_ind->getColunaAlias('jun_indice'),
            $tbl_calc_ind->getColunaAlias('jul_indice'),
            $tbl_calc_ind->getColunaAlias('agost_indice'),
            $tbl_calc_ind->getColunaAlias('set_indice'),
            $tbl_calc_ind->getColunaAlias('out_indice'),
            $tbl_calc_ind->getColunaAlias('nov_indice'),
            $tbl_calc_ind->getColunaAlias('dez_indice')
        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orc_id'),'=',$orc_id],
            [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()],
            ])

        //->whereIn($tb_lotacao->getColunaAlias('id'),$lotacoes)
        ->get()->toArray();
        
        for($i=0;$i<count($dados);$i++){
            $dados[$i]['identificador']="1";
        }
        return $dados;
    }
    
    public function insertOrcDespesasIndice($dados){

        $this->clearError();

        $tb_calc_indice=new CalcIndice();

        $dados_env=Arr::only($dados,['orc_id','despesa_id','centro_custo_id','lotacao_id','valor_referencia']);

        DB::beginTransaction();
        try{
            $salvou = $this->create($dados_env);

            if(!$salvou){
                return false;
            }
            
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['jan_orcado'],
            'fev_indice'=>$dados['fev_orcado'],
            'marc_indice'=>$dados['mar_orcado'],
            'abril_indice'=>$dados['abr_orcado'],
            'maio_indice'=>$dados['mai_orcado'],
            'jun_indice'=>$dados['jun_orcado'],
            'jul_indice'=>$dados['jul_orcado'],
            'agost_indice'=>$dados['ago_orcado'],
            'set_indice'=>$dados['set_orcado'],
            'out_indice'=>$dados['out_orcado'],
            'nov_indice'=>$dados['nov_orcado'],
            'dez_indice'=>$dados['dez_orcado']
        );
            
            $salvar_indice=$tb_calc_indice->create($dados_indice);
             
            if(!$salvar_indice){
                $this->setError('Falha ao inserir dados. Erro: 010420201109');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 010420201109.'.$ex);
       }
       return true;
    }

    public function insereIndice($id,$dados){
        $tbl_calc_indice=new CalcIndice();

        $dados_indice=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['jan_orcado'],
            'fev_indice'=>$dados['fev_orcado'],
            'marc_indice'=>$dados['mar_orcado'],
            'abril_indice'=>$dados['abr_orcado'],
            'maio_indice'=>$dados['mai_orcado'],
            'jun_indice'=>$dados['jun_orcado'],
            'jul_indice'=>$dados['jul_orcado'],
            'agost_indice'=>$dados['ago_orcado'],
            'set_indice'=>$dados['set_orcado'],
            'out_indice'=>$dados['out_orcado'],
            'nov_indice'=>$dados['nov_orcado'],
            'dez_indice'=>$dados['dez_orcado']
        );
        $dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            abort(500,'Erro ao inserir índices.');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id, $data){
        $calc_orcamento = new CalcOrcamento();
        $orcamento = array(
            'origem_id'=>$id,
            'tbl_origem'=>"tbl_orc_despesas",
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );

        //dd("caiu caqui");

        $inseriu=$calc_orcamento->create($orcamento);
        //dd($inseriu);
        if(!$inseriu)
        {
            abort(500,'Erro ao inserir valores.');
            return false;
        }
        return true;
    }

    public function insereCalcDespesa($data){
        
        
        $orcamento = array(

            'tbl_origem'=>"tbl_orc_despesas",
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
        $calc_orcamento = new RepoCalcOrcamento();
        $despesa_array = array(
            'orc_id'=>$data['orc_id'],
            'despesa_id'=>$data['despesa_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'centro_custo_id'=>$data['centro_custo_id'],
            'valor_referencia'=>monetarioVirgula($data['valor_referencia']),// str_replace(',', '.', str_replace('.', '', $data['valor_referencia'])),
            'tipo_table'=>$data['tipo_table'],
            'periodo'=>$data['periodo']
            // 'valor_referencia'=>$data['valor_referencia']
        );
        if($data['tipo_table'] != 'F'){
            unset($despesa_array['periodo']);
        }

        // dd($despesa_array,$orcamento);
        DB::beginTransaction();

            try {
                $despesa = parent::create($despesa_array);
                if(!$despesa){
                    $this->setError("erro!");
                    return false;
                }
                $orcamento['origem_id']=$despesa->id;
               
                $inseriu=$calc_orcamento->create($orcamento);

                if(!$inseriu){
                    $this->setError("erro no inserir");
                    return false;
                }

                DB::commit();

            }catch (Exception $th) {
                DB::rollBack();
                abort(500,'Erro ao tentar inserir registro 100120201749');
            }
            return true;
    }

    public function insertWithMeses($data){
        
        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();

        // $dados = $estrutura->makeEstrutura($data['orc_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$data['orc_id']],
        //     ['id',$data['lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->distinct()->get()->toArray();
        
        // if(count($select) == 0){
        //     $this->setError("Lotação selecionada não pertence a você(fazer uma msg melhor). <br>Erro: 200520201136");
        //     return false;
        // }

        /* JA ESTÁ VALIDANDO NO CONTROLLER - matheus (22/12/2020)
        $despesas = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orc_id'),'=',$data['orc_id']],
            [$this->getModelEntity()->getColunaAlias('despesa_id'),'=',$data['despesa_id']],
            [$this->getModelEntity()->getColunaAlias('centro_custo_id'),'=',$data['centro_custo_id']],
            [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$data['lotacao_id']]
        ])->get()->toArray();
        
       
        if(count($despesas) > 0){
            
            if($data['tipo_meses'] == 2)
            {                
                if(!$this->insereCalcOrc($despesas[0]['id'],$data)){
                    $this->setError('Erro ao inserir registro. Erro: 070420201157');
                    return false;
                }
            }
            if($data['tipo_meses'] == 1)
            {
                if(!$this->insereIndice($despesas[0]['id'],$data)){
                        
                    $this->setError('Erro ao inserir registro.  Erro: 070420201155');
                    return false;
                }
            }
        }*/
        
        // else{
        if($data['tipo_meses'] == 1){
            if(!$this->insertOrcDespesasIndice($data)){
                $this->setError('Não foi possível inserir os índices. Erro:070420201448');
                return false;
            }
            return true;
        }
        else{
            $meses = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
                'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
                
            for($i = 0; $i < count($meses); $i++){
                if(!array_key_exists($meses[$i], $data)){
                    $data[$meses[$i]] = 0;
                }
            }
            if(!$this->insereCalcDespesa($data)){
                $this->setError('Não foi possível inserir os valores. Erro:070420201449');
                return false;
            }
            return true;
        }
        //}
        
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
    }
    public function deleteDespesaIndice($value){
        $calc_indice = new CalcIndice();
        $calc_orcamento = new CalcOrcamento();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        
        // $dados = $estrutura->makeEstrutura($value['orc_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$value['orc_id']],
        //     ['lotacao_id',$value['lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->distinct()->get()->toArray();
        
        // if(count($select) == 0){
        //     $this->setError("Lotação selecionada não pertence a você(fazer uma msg melhor). <br>Erro: 200520201352");
        //     return false;
        // }

        $id=$value['id'];
        
        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$id],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $calc_indice->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$id],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();

            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420200801");
                return false;
            }
        }
        else{
            
            DB::beginTransaction();
            try {
                $result = $calc_indice->where([
                    [$calc_indice->getColunaAlias('origem_id'),'=',$value['id']],
                    [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->delete();
                
                if(!$result){
                    $this->setError("Erro ao excluir registro. erro:020420201554");
                    return false;
                }
                
                $del_despesas=$this->delete($value['origem_id']);
                
                if(!$del_despesas){
                    $this->setError('Erro ao excluir registro. Erro:090420200829');
                    return false;
                }
                DB::commit();
                goto saida;

            } catch (Exception $th) {
                DB::rollBack();
                abort(500,"Erro ao excluir registro. erro:020420201554".$th);
            }
        }
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro deletado com sucesso!';
        return $retorno;
    }
    public function deleteDespesa($value){
        $repo_calc=new RepoCalcOrcamento();
        $calc_indice = new CalcIndice();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($value['orc_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$value['orc_id']],
        //     ['id',$value['lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->distinct()->get()->toArray();
        
        // if(count($select) == 0){
        //     $this->setError("Lotação selecionada não pertence a você(fazer uma msg melhor). <br>Erro: 200520201355");
        //     return false;
        // }

        $id=$value['id'];

        /*Não existe mais indices em despesas - matheus(22/12/2020)
        $select_indice = $calc_indice->select()->where([
            [$calc_indice->getColunaAlias('origem_id'),'=',$id],
            [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        */
        

            DB::beginTransaction();
            try {
                $result = $repo_calc->getModelEntity()->where([
                    [$repo_calc->getModelEntity()->getColunaAlias('origem_id'),'=',$id],
                    [$repo_calc->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->delete();
            
                if(!$result){
                    $this->setError("Erro ao excluir registro. erro:110220201630");
                    return false;
                }
                
                $del_despesas=$this->delete($value['origem_id']);

                if(!$del_despesas){
                    $this->setError("Erro ao excluir registro. erro:090420200839");
                    return false;
                }
                /*Não existe mais indices em despesas - matheus(22/12/2020)
                if(count($select_indice)>0){
                    $del_indice = $calc_indice->where([
                        [$calc_indice->getColunaAlias('origem_id'),'=',$id],
                        [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                    ])->delete();

                    
                    if(!$del_indice){
                        $this->setError("Erro ao excluir registro. erro:090420200904");
                        return false;
                    }
                }
                */
                DB::commit();
                goto saida;

            } catch (Exception $th) {
                DB::rollBack();
                abort(500,"Erro ao excluir registro. erro:11022020".$th);
            }
        
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro deletado com sucesso!';
        return $retorno;
    }

    public function updateDespIndice($data){
        $calc_indice_ent = new RepoCalcIndice();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($data['orc_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$data['orc_id']],
        //     ['lotacao_id',$data['lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->distinct()->get()->toArray();

        // if(count($select) == 0){
        //     $this->setError("Lotação selecionada não pertence a você(fazer uma msg melhor). <br>Erro: 200520201238");
        //     return false;
        // }

        //conversao
        $despesa_orc=Arr::only($data,['origem_id','valor_referencia']);
        $calc_indice=Arr::except($data,['descricao','valor_referencia','_token','identificador']);
        
        $vlr_referencia=convertDecimalEn([$despesa_orc['valor_referencia']]);
        $origem_id=intval($despesa_orc['origem_id']);
        
        $env_desp_orc=array(
                    'origem_id'=>$origem_id,
                    'valor_referencia'=>$vlr_referencia
        );
        //conversao
        //validação
        if($env_desp_orc['valor_referencia']<=0){
            $this->setError("Erro ao atualizar registro. erro:120220201505");
            return false;
        }
        //validação

        DB::beginTransaction();
        $id_despesa_orc=$env_desp_orc['origem_id'];
        
        $valor= array('valor_referencia'=>$env_desp_orc['valor_referencia'][0]);

        try{
            
            $result=$this->update($valor,$id_despesa_orc);
            
            if(!$result){
                $this->setError("Erro ao atualizar registro. erro:020420201518");
                return false;
            }  
            
            $meses=Arr::except($calc_indice,['id','origem_id','des_unid_lotac','despesa_id','orc_lotacao_id','lotacao_id'
            ,'centro_custo_id']);
            $id_calc_indice=$calc_indice['id'];

            $select_calc_indice = $calc_indice_ent->getModelEntity()->select('id')->where([
                [$calc_indice_ent->getModelEntity()->getColunaAlias('origem_id'),'=',$id_calc_indice],
                [$calc_indice_ent->getModelEntity()->getColunaAlias('tbl_origem'),'=','tbl_orc_despesas']
            ])->get()->toArray();

            $id_calc_indice_select = $select_calc_indice[0]['id'];
            
            $meses_conv=convertDecimalEn($meses);
            
            $meses_conv = Arr::except($meses_conv,['orc_id']);
            
            $result_calc = $calc_indice_ent->update($meses_conv,$id_calc_indice_select);
            
            if(!$result_calc){
                
                $this->setError("Erro ao atualizar registro. erro:020420201518");
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            goto saida;
        }
        catch(Exception $th){
            DB::rollBack();
            abort(500,"Erro ao atualizar registro. erro:020420201519".$th);
        }

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro atualizado com sucesso!';
        return $retorno;

    }

    public function updateDespCalc($data,$attribute){
        
        $calc_orcamento=new RepoCalcOrcamento();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($data['orc_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$data['orc_id']],
        //     ['id',$data['lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->distinct()->get()->toArray();
        
        // if(count($select) == 0){
        //     $this->setError("Lotação selecionada não pertence a você(fazer uma msg melhor). <br>Erro: 200520201239");
        //     return false;
        // }

        $despesa_orc=Arr::only($data,['origem_id','valor_referencia']);
        $calc_orc=Arr::except($data,['descricao','valor_referencia','_token','identificador']);
        
        $vlr_referencia=convertDecimalEn([$despesa_orc['valor_referencia']]);
        $origem_id=intval($despesa_orc['origem_id']);
        
        $env_desp_orc=array(
                    'origem_id'=>$origem_id,
                    'valor_referencia'=>$vlr_referencia
        );
        //dd($env_desp_orc);
        if($env_desp_orc['valor_referencia']<=0){
            $this->setError("Erro ao atualizar registro. erro:120220201505");
            return false;
        }
        
        
        // if(!$calc_orc['jan_orcado']<0){
        //     dd("dsdcsdcsdcsdcsdcsdcsdc");
        // }

        DB::beginTransaction();
        $id_despesa_orc=$env_desp_orc['origem_id'];
        // dd('sasasa', $despesa_orc['valor_referencia'], convertDecimalEn([$despesa_orc['valor_referencia']]));
        
        $valor= array('valor_referencia'=>$env_desp_orc['valor_referencia'][0]);

        try{
            //dd("chegou aqui",$valor,$valor,$id_despesa_orc);
            $result=$this->update($valor,$id_despesa_orc);
            
            if(!$result){
        
                $this->setError("Erro ao atualizar registro. erro:120220201035");
                return false;
            }  
            
            $meses=Arr::except($calc_orc,['id','origem_id','des_unid_lotac']);
            $id_calc_orc=$calc_orc['id'];

            $select_calc_orc=$calc_orcamento->getModelEntity()->select('id')->where([
                [$calc_orcamento->getModelEntity()->getColunaAlias('origem_id'),'=',$id_calc_orc],
                [$calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem'),'=','tbl_orc_despesas']
            ])->get()->toArray();

            $id_calc_orc_select=$select_calc_orc[0]['id'];
            
            $meses_conv=convertDecimalEn($meses);
            //dd($meses_conv);
            $result_calc=$calc_orcamento->update($meses_conv,$id_calc_orc_select); 

            if(!$result_calc){
                $this->setError("Erro ao atualizar registro. erro:120220201041");
                return false;
            }
            
            DB::commit();
            goto saida;
        }
        catch(Exception $th){
            DB::rollBack();
            abort(500,"Erro ao atualizar registro. erro:120220201042".$th);
        }

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro atualizado com sucesso!';
        return $retorno;

    }

}