<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepoCargo;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
class RepoOrcDissidio extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcDissidio';
    protected $form_rules=[
        'orcamento_id'     =>'required|exists:tbl_orcamento,id',
        'orc_cargo_id'       =>'required|exists:tbl_orc_cargo,id'
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'  =>'Selecione um orçamento para continuar a operação!',
        'orcamento_id.exists'    =>'Orçamento inexistente, tente novamente.',
        'orc_cargo_id.required'  =>'Selecione um cargo para continuar a operação',
        'orc_cargo_id.exists'    =>'Cargo inexistentes, tente novamente.'
    ]; 

    public function listar($orc_id, $periodo = null, $tipo_table = 'O'){
        $repo_orc_cargo = new RepoOrcCargo();
        $repo_cargo = new RepoCargo();
        $repo_calc_orc = new RepoCalcOrcamento();
        $tbl_usuario = new Usuario();
        
        $calc_orc_entity = $repo_calc_orc->getModelEntity();
        $orc_cargo_entity = $repo_orc_cargo->getModelEntity();
        $cargo_entity = $repo_cargo->getModelEntity();

        $query = $this->getModelEntity()
        ->leftJoin($orc_cargo_entity->getTable(),$orc_cargo_entity->getColunaAlias('id'),$this->getModelEntity()->getColunaAlias('orc_cargo_id'))
        ->leftJoin($cargo_entity->getTable(),
        $cargo_entity->getColunaAlias('id'),$orc_cargo_entity->getColunaAlias('cargo_id'))
        ->leftJoin(
            $calc_orc_entity->getTable(),
            $this->getModelEntity()->getColunaAlias('id'),'=',
            DB::raw("{$calc_orc_entity->getColunaAlias('origem_id')} and {$calc_orc_entity->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))
        
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $calc_orc_entity->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('orc_cargo_id'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $orc_cargo_entity->getColunaAlias('cargo_id'),
            $cargo_entity->getColunaAlias('des_cargo_basic'), 
            $cargo_entity->getColunaAlias('cod_cargo_basic'),
            DB::raw("concat({$cargo_entity->getColunaAlias('cod_cargo_basic')}, ' - ',{$cargo_entity->getColunaAlias('des_cargo_basic')}) AS cargo"),
            DB::raw("LEFT({$cargo_entity->getColunaAlias('cod_cargo_basic')}, 2) as grade_salarial"),
            DB::raw($calc_orc_entity->getColunaAlias('id').' as id_calc_orc'),
            DB::raw("{$orc_cargo_entity->getColunaAlias('jan_orcado')} AS jan_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('fev_orcado')} AS fev_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('mar_orcado')} AS mar_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('abr_orcado')} AS abr_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('mai_orcado')} AS mai_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('jun_orcado')} AS jun_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('jul_orcado')} AS jul_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('ago_orcado')} AS ago_orcado"), 
            DB::raw("{$orc_cargo_entity->getColunaAlias('set_orcado')} AS set_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('out_orcado')} AS out_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('nov_orcado')} AS nov_orcado"),
            DB::raw("{$orc_cargo_entity->getColunaAlias('dez_orcado')} AS dez_orcado"),
            
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            $this->getModelEntity()->getColunaAlias('created_at'),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            $calc_orc_entity->getColunaAlias('updated_at')
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('jan_orcado')}, 'N0', 'pt-br') AS jan_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('fev_orcado')}, 'N0', 'pt-br') AS fev_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('mar_orcado')}, 'N0', 'pt-br') AS mar_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('abr_orcado')}, 'N0', 'pt-br') AS abr_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('mai_orcado')}, 'N0', 'pt-br') AS mai_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('jun_orcado')}, 'N0', 'pt-br') AS jun_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('jul_orcado')}, 'N0', 'pt-br') AS jul_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('ago_orcado')}, 'N0', 'pt-br') AS ago_orcado"), 
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('set_orcado')}, 'N0', 'pt-br') AS set_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('out_orcado')}, 'N0', 'pt-br') AS out_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('nov_orcado')}, 'N0', 'pt-br') AS nov_orcado"),
            // DB::raw("format({$orc_cargo_entity->getColunaAlias('dez_orcado')}, 'N0', 'pt-br') AS dez_orcado")
        )
        ->orderBy('grade_salarial','asc')
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table);

        if($tipo_table == 'F'){
            return $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        return $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();


    }
    public function inserir($grades, $orc_id, $meses, $periodo = null, $tipo_table = 'O'){
         
        $repo_orc_cargo = new RepoOrcCargo();
        $repo_cargo = new RepoCargo();
        $repo_calc_orc = new RepoCalcOrcamento();
        $user = $this->getUserFromCurrentGuard();

        // $array_insert = [];

        $calc_orc_entity = $repo_calc_orc->getModelEntity();
        
        $orc_cargo_entity = $repo_orc_cargo->getModelEntity();
        $cargo_entity = $repo_cargo->getModelEntity();
        DB::beginTransaction();
        try {
           foreach ($grades as $grade) {
                $query = $orc_cargo_entity
                ->leftJoin($cargo_entity->getTable(), $orc_cargo_entity->getColunaAlias('cargo_id'), $cargo_entity->getColunaAlias('id'))
                ->select(
                    $orc_cargo_entity->getColunaAlias('id'),
                    $cargo_entity->getColunaAlias('cod_cargo_basic'),
                    $orc_cargo_entity->getColunaAlias('cargo_id')
                )
                ->where($cargo_entity->getColunaAlias('cod_cargo_basic'), 'like', $grade.'%')
                ->where($orc_cargo_entity->getColunaAlias('orcamento_id'), $orc_id)
                ->where($orc_cargo_entity->getColunaAlias('tipo_table'), $tipo_table);
                
                $cargos_result = [];
                if($tipo_table == 'F'){
                    $cargos_result = $query->where($orc_cargo_entity->getColunaAlias('periodo'), $periodo)->get()->toArray();
                }
                else{
                    $cargos_result = $query->whereNull($orc_cargo_entity->getColunaAlias('periodo'))->get()->toArray();
                }
                
                foreach ($cargos_result as $cargo) {
                    $insert = array('orcamento_id'=>$orc_id,
                        'orc_cargo_id'=>$cargo['id'],
                        'created_at'=>$this->fillCriadoEm(),
                        'created_by'=>$this->fillCriadoPor(),
                        'tipo_table'=>$tipo_table,
                        'periodo'=>$periodo
                    );

                    if($tipo_table != 'F'){
                        unset($insert['periodo']);
                    }

                    $query = $this->getModelEntity()

                        ->leftJoin(
                            $calc_orc_entity->getTable(),
                            $this->getModelEntity()->getColunaAlias('id'),'=',
                            DB::raw("{$calc_orc_entity->getColunaAlias('origem_id')} and {$calc_orc_entity->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))
                        ->select(
                            DB::raw($calc_orc_entity->getColunaAlias('id').' as id_calc_orc'),
                            DB::raw($calc_orc_entity->getColunaAlias('origem_id').' as id')
                        )
                        ->where([
                            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id],
                            ['orc_cargo_id', $cargo['id']],
                            ['tipo_table', $tipo_table]
                    ]);

                    $exist = null;
                    if($tipo_table == 'F'){
                        $exist = $query->where('periodo', $periodo)->first();
                    }
                    else{
                        $exist = $query->whereNull('periodo')->first();
                    }
                        
                    if($exist){
                        $array_update = array_merge($exist->toArray(), $meses);
                        $array_update['updated_at'] = date('Y-m-d');
                        $array_update['updated_by'] = $user->id;
                        
                        $res = $this->editar($array_update, true);
                        // $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Dados já cadastrados. Erro: 070220200954.');
                        
                        if($res['status'] == 'error'){
                            $retorno = array('status'=>'error','msg'=>$res['msg']);
                            goto saida;
                        }

                        continue;
                    } 
                    else{
                        // dd('dendoelse', $meses);

                        $dissidio = parent::create($insert);

                        if(!$dissidio){
                            $retorno = array('status'=>'error','msg'=>$dissidio->getErrosFlatted());
                            goto saida;
                        }

                        $res_calc_orc = $this->createCalcOrc($dissidio->id, $meses);

                        if($res_calc_orc['status'] != 'success'){
                            abort(500,'Falha ao inserir o registro. Erro: 050320201500');
                        }

                    } 

                }
            }

            
            

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            DB::commit();  
            
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno = array(
                'status'=>'error',
                'msg'=>'Falha ao inserir o registro. Erro: 060220202041',
                'submsg'=>$e->getMessage()
            );
            goto saida;
        }
        saida:
        return $retorno;
    }
    public function editar($all, $from_insert = null){
       
        $dados_dissidio = Arr::only($all, ['updated_at','updated_by']);
        
        $meses = $from_insert ? $this->filterMesesCalcOrcamento($all) : convertDecimalEn($this->filterMesesCalcOrcamento($all));
        $repo_calc_orc = new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            
            $update_calc_orc = $repo_calc_orc->update($meses, $all['id_calc_orc']);
            if(!$update_calc_orc){
                $retorno = array('status'=>'error','msg'=>$repo_calc_orc->getErrosFlatted());
                goto saida;
            }
            //dd($dados_dissidio, $all['id']);
            
            $update = DB::table('tbl_orc_dissidio')
                ->where([
                    ['id', '=', $all['id']]
                ])
            ->update($dados_dissidio);
              
            if($update == 0){
                $retorno = array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 120820201602');
                goto saida;
            }

            $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno = array(
                'status'=>'error',
                'msg'=>'Falha ao atualizar o registro. Erro: 070220201450.',
                'msg'=>$e->getMessage()
            );
            goto saida;
        }
        saida:
        $this->makeModel();
        return $retorno;

    }
    public function deletar($all){
 
        $meses = $this->filterMesesCalcOrcamento($all);
        $repo_calc_orc = new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            $delete_dissidio = $this->delete($all['id']);
            if(!$delete_dissidio){
                $retorno = array('status'=>'error','msg'=>'$repo_calc_orc->getErrosFlatted()');
                goto saida;
            }

            $delete_calc_orc = $repo_calc_orc->delete($meses['id_calc_orc']);
            if(!$delete_calc_orc){
                $retorno = array('status'=>'error','msg'=>'$repo_calc_orc->getErrosFlatted()');
                goto saida;
            }

            $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 070220201538.');
        }
        saida:
        return $retorno;

    }

    public function deletarAll($all){
        $orc_cargo = new RepoOrcCargo();
        $cargo = new RepoCargo();
        // $meses = $this->filterMesesCalcOrcamento($all);
        $calc_orc = new CalcOrcamento();        
        $repo_calc_orc = new RepoCalcOrcamento();
        // dd($all['grade_salarial']);
        DB::beginTransaction();
        try {
            $query = $this->getModelEntity()
            ->select(
                $this->getModelEntity()->getColunaAlias('id'),
                $cargo->getModelEntity()->getColunaAlias('cod_cargo_basic'),
                DB::raw("{$calc_orc->getColunaAlias('id')} as id_orc")
            )
            ->leftJoin($orc_cargo->getModelEntity()->getTable(),$this->getModelEntity()->getColunaAlias('orc_cargo_id'),$orc_cargo->getModelEntity()->getColunaAlias('id'))
            ->leftJoin($cargo->getModelEntity()->getTable(),$orc_cargo->getModelEntity()->getColunaAlias('cargo_id'),$cargo->getModelEntity()->getColunaAlias('id'))
            ->leftJoin($calc_orc->getTable(),$calc_orc->getColunaAlias('origem_id'),'=',DB::raw("{$this->getModelEntity()->getColunaAlias('id')} and {$calc_orc->getColunaAlias('tbl_origem')} = 'tbl_orc_dissidio'"))

            ->where($cargo->getModelEntity()->getColunaAlias('cod_cargo_basic'),'like',$all['grade_salarial'].'%')
            ->where($this->getModelEntity()->getColunaAlias('tipo_table'), $all['tipo_table']);
            
            $delete_dissidio = null;
            if($all['tipo_table'] == 'F'){
                $delete_dissidio = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $all['periodo']);
            }
            else{
                $delete_dissidio = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'));
            }

            $delete = $delete_dissidio->delete();

            if(!$delete){
                $retorno = array('status'=>'error','msg'=>'$repo_calc_orc->getErrosFlatted()');
                DB::rollBack();
                goto saida;
            }

            // $delete_calc_orc = $repo_calc_orc->delete($meses['id_calc_orc']);
            
            $delete_calc_orc = DB::delete("DELETE from tbl_calc_orcamento where tbl_origem = '{$this->getModelEntity()->getTable()}' and origem_id not in (select id from tbl_orc_dissidio)");
            if($delete_calc_orc === false){
                $retorno = array('status'=>'error','msg'=>$repo_calc_orc->getErrosFlatted());
                DB::rollBack();
                goto saida;
            }

            $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 070220201538.'.$e);
        }
        saida:
        return $retorno;

    }


    public function filterMesesCalcOrcamento($data){
        $array_orcamento=['orcamento_id', 'orc_cargo_id', 'cod_cargo_basic', 'des_cargo_basic','cargo_id','turma_id', 'grade_salarial','id'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        return $filtered;
    }

    public function createCalcOrc($id_orc_dissidio, $meses){
        // $repo_orc_cargo = new OrcCargo();        
        $repo_calc_orc = new CalcOrcamento();        
        // $orc_dissidio = $this->getModelEntity();

        // $ids_orc_dissidio = $orc_dissidio->join(
        //                                 $repo_orc_cargo->getTable(), $repo_orc_cargo->getColunaAlias('orcamento_id'), '=',                            
        //                                 DB::raw("{$orc_id} and {$orc_dissidio->getColunaAlias('orc_cargo_id')} = 
        //                                          {$repo_orc_cargo->getColunaAlias('id')}")
        //                                 )->leftJoin(
        //                                     $repo_calc_orc->getTable(), $orc_dissidio->getColunaAlias('id'), '=',                            
        //                                 DB::raw("{$repo_calc_orc->getColunaAlias('origem_id')} and 
        //                                          {$repo_calc_orc->getColunaAlias('tbl_origem')} = '{$orc_dissidio->getTable()}'")
        //                             )
        //         ->select($orc_dissidio->getColunaAlias('id'))
        //         ->where($orc_dissidio->getColunaAlias('orcamento_id'),$orc_id)
        //         ->get()
        //         ->toArray();
        
        
        DB::beginTransaction();
        try {
            
            // foreach($ids_orc_dissidio as $id_orc_dissidio){
                $inf = ['origem_id'=>$id_orc_dissidio,'tbl_origem'=>$this->getModelEntity()->getTable()];
                
                $merge_meses = array_merge($meses,$inf);
                
                $res_calc_orc = $repo_calc_orc->create($merge_meses);
            
                if(!$res_calc_orc){
                    $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Erro: 050320201456.');
                    goto saida;
                }
            // }
        
            $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 050320201455.');
        }
        saida:
        return $retorno;       
    }
 
     
}