<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoCargo;

use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto as LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil; 
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcParametros;
use App\Modules\Natureza51\Entities\CadastroParametros;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcEventos extends RepoOrcamento
{
    
    //protected $model_name_space_local='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcEventos';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        parent::__construct();
    }

    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){

        $repo_calc = new RepoCalcOrcamento();
        $tbl_usuario = new Usuario();

        $tbl_orc_evento = $this->getModelEntity();
        $tbl_calc_orc = $repo_calc->getModelEntity();

        $query = $tbl_orc_evento
        ->leftJoin($tbl_calc_orc->getTable(),$tbl_orc_evento->getColunaAlias('id'),'=',DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_evento->getTable()}'"))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_orc->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $tbl_orc_evento->getColunaAlias('id'),
            $tbl_orc_evento->getColunaAlias('orcamento_id'),
            // $tbl_orc_evento->getColunaAlias('empresa_id'),
            $tbl_orc_evento->getColunaAlias('evento_id'),
            $tbl_orc_evento->getColunaAlias('cdn_event'),
            $tbl_orc_evento->getColunaAlias('des_event'),
            $tbl_orc_evento->getColunaAlias('inc_liquido'),
            $tbl_orc_evento->getColunaAlias('impr_envel'),
            $tbl_orc_evento->getColunaAlias('multiplica'),
            DB::raw($tbl_calc_orc->getColunaAlias('id').' id_calc'),
            $tbl_calc_orc->getColunaAlias('jan_orcado'),
            $tbl_calc_orc->getColunaAlias('fev_orcado'),
            $tbl_calc_orc->getColunaAlias('mar_orcado'),
            $tbl_calc_orc->getColunaAlias('abr_orcado'),
            $tbl_calc_orc->getColunaAlias('mai_orcado'),
            $tbl_calc_orc->getColunaAlias('jun_orcado'),
            $tbl_calc_orc->getColunaAlias('jul_orcado'),
            $tbl_calc_orc->getColunaAlias('ago_orcado'),
            $tbl_calc_orc->getColunaAlias('set_orcado'),
            $tbl_calc_orc->getColunaAlias('out_orcado'),
            $tbl_calc_orc->getColunaAlias('nov_orcado'),
            $tbl_calc_orc->getColunaAlias('dez_orcado'),

            /*DB::raw("CASE WHEN {$tbl_orc_evento->getColunaAlias('dt_base_admissao_ini')} IS NOT NULL THEN format({$tbl_orc_evento->getColunaAlias('dt_base_admissao_ini')}, 'dd/MM/yyyy') ELSE '-' END as dt_inicial"),
            DB::raw("CASE WHEN {$tbl_orc_evento->getColunaAlias('dt_base_admissao_fim')} IS NOT NULL THEN format({$tbl_orc_evento->getColunaAlias('dt_base_admissao_fim')}, 'dd/MM/yyyy') ELSE '-' END as dt_final"),
            */
            // $tbl_calc_orc->getColunaAlias('tipo_acesso'),
            DB::raw("IIF({$tbl_calc_orc->getColunaAlias('tipo_acesso')} = 2, 'Lotação/Cargo', 'Global') as tipo_acesso"),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$tbl_orc_evento->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_orc_evento->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
            
        )
        ->where($tbl_orc_evento->getColunaAlias('orcamento_id'),$orc_id)
        ->where($tbl_orc_evento->getColunaAlias('tipo_table'), $tipo_table);

        if($tipo_table == 'F'){
            $query->where($tbl_orc_evento->getColunaAlias('periodo'), $periodo);
        }


        $select = $query->get()->toArray();
        // dd("aaaaaaaaaaaaaaaaaaaaaaaaa",$select);
        return $select;

    }

    public function updateAll($data){
        unset($data['criado_por']);
        unset($data['criado_em']);
        unset($data['atualizado_por']);
        unset($data['atualizado_em']);

        $meses = convertDecimalEn($this->dataFilterMesesCalcOrcamento($data));
        $data_evento = $this->dataFilterEventos($data);
        $repo_calc = new RepoCalcOrcamento();
        // $calc_orc = new CalcOrcamento();
        $data_evento['multiplica'] = (1 + ($data['multiplica'] / 100));
        DB::beginTransaction();

        try {
            
            $update = $this->update($data_evento, ['id'=>$data['id']]);

            if(!$update){
                $this->setError('Erro ao atualizar o registro. Erro: 260220202029.');
                return false;
            }
            
            $data_update['tbl_origem'] = $this->getModelEntity()->getTable();

            $insert_calc = $repo_calc->update($meses, 
                                ['origem_id'=>$data['id'], 'tbl_origem'=>$data_update['tbl_origem']]);

            if(!$insert_calc){
                $this->setError('Erro ao inserir o registro. Erro: 260220202110.');
                return false;
            }


            DB::commit();

        } catch (\Exception $e) {
            // dd("aaaa",$e);
            DB::rollBack();
            abort(500,'Erro ao atualizar o registro. Erro: 260220202030.'.$e);
        }


        return true;

    }

    public function deleteAll($data){

        $repo_calc = new CalcOrcamento();

        $tbl_entitie = $this->getModelEntity()->getTable();
             
        $id_calc_orc = $repo_calc->where(
            'origem_id',$data['id']
        )->where('tbl_origem', $tbl_entitie)
        ->select('id')
        ->first();
        
        DB::beginTransaction();

        try {
            $del = $this->delete($data['id']);
            
            if(!$del){
                $this->setError('Erro ao deletar o registro. Erro: 260220202037.');
                return false;
            } 
            
            if(!is_null($id_calc_orc)){
                $del_calc_orc = $this->deleteCalcOrc($id_calc_orc);

                if(!$del_calc_orc){
                    $this->setError('Erro ao deletar o registro. Erro: 050320201929.');
                    return false;
                }
            }  

            DB::commit();
            
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao deletar o registro. Erro: 260220202032.');
        }


        return true;

    }

    public function insertAll($data){       
        
        $data['multiplica'] = (1 + ($data['multiplica'] / 100));
        
        $meses = $this->dataFilterMesesCalcOrcamento($data);
        // unset($data['meses']);
        $repo_calc = new RepoCalcOrcamento();


        $query =$this->getModelEntity()->where([
            ['evento_id',$data['evento_id']],
            ['orcamento_id',$data['orcamento_id']],
            ['tipo_table', $data['tipo_table']]
        ]);

        $dt = null;
        if($data['tipo_table'] == 'F'){
            $dt = $query->where('periodo', $data['periodo'])->get()->toArray();
        }
        else{
            $dt = $query->whereNull('periodo')->get()->toArray();
        }
        
        if(!empty($dt)){
            $this->setError('Evento já cadastrado. Erro: 260220202117');
            return false;
        }


        $dts = DB::select("SELECT dt_base_admissao_ini, dt_base_admissao_fim from tbl_eventos where id = ?", [$data['evento_id']]);
        $data['dt_base_ini'] = $dts[0]->dt_base_admissao_ini;
        $data['dt_base_fim'] = $dts[0]->dt_base_admissao_fim;

        DB::beginTransaction();

        try {
            $insert = $this->create($data);
            if(!$insert){
                $this->setError('Erro ao inserir o registro. Erro: 260220202100.');
                return false;
            }
            $meses['origem_id'] = $insert->id;
            $meses['tbl_origem'] = $this->getModelEntity()->getTable();
            $insert_calc = $repo_calc->create($meses);

            if(!$insert_calc){
                $this->setError('Erro ao inserir o registro. Erro: 260220202110.');
                return false;
            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao inserir o registro. Erro: 260220202105.'. $e);
        }
        return true;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['id', 'tipo_acesso', 'evento_id', 'cdn_event','des_event','multiplica', 'cargo_corrente_id','nome_funcionario','orcamento_id','inc_liquido','evento_id','impr_envel'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterEventos($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 
                        'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado', 
                        'dez_orcado', 'id', 'multiplica'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteCalcOrc($id_calc_orc){        
        $repo_calc = new RepoCalcOrcamento();
        
        DB::beginTransaction();

        try {                        
                        
            $del_calc_orc = $repo_calc->delete($id_calc_orc['id']);
            
            if(!$del_calc_orc){
                $this->setError('Erro ao deletar o registro. Erro: 050320201929.');
                return false;
            }

            DB::commit();
            
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao deletar o registro. Erro: 260220202032.');
        }

        return true;
    }

    public function populaEvento($orc_id){
        $orc_cargo_area_sal = new OrcCargosAreaSal();
        $funcionario = new Funcionario();
        $orc_cargo = new OrcCargo();
        $cargo = new Cargo();
        $orc_lotacao = new OrcLotacao();
        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();
        $centro_custo = new CentroCusto();
        $orc_eventos = new OrcEventos();
        $eventos = new Eventos();
        $empresa = new Empresa();
        $conta_contabil_vs_eventos = new ContaContabilVSEventos();
        $conta_contabil = new ContaContabil();
        $calc_orcamento = new CalcOrcamento();
        $orc_parametros = new OrcParametros();
        $repo_orc_script_calculos = new RepoOrcScriptCalculos();
        
        $entities = [
            'orcCargosAreaSal' => ['instance'=>$orc_cargo_area_sal],
            'funcionario' => ['instance'=>$funcionario],
            'orcCargo' => ['instance'=>$orc_cargo],
            'cargo' => ['instance' => $cargo],
            'orcLotacao' => ['instance' => $orc_lotacao],
            'lotacaoCCusto' => ['instance' => $lotacao_c_custo],
            'lotacao' => ['instance' => $lotacao],           
            'calcOrcamento' => ['instance' => $calc_orcamento],
            'centroCusto' => ['instance' => $centro_custo],
            'orcEventos' => ['instance' => $orc_eventos],
            'eventos' => ['instance' => $eventos],
            'empresa' => ['instance' => $empresa],
            'contaContabilVSEventos' => ['instance' => $conta_contabil_vs_eventos],
            'contaContabil' => ['instance' => $conta_contabil],
            'calcOrcamento' => ['instance' => $calc_orcamento]
        ];
        $this->clearError();

        $calc_eventos = $repo_orc_script_calculos->insertUpcalcOrcEventos($entities, $orc_id);         
        
        if($calc_eventos["status"]!="success"){            
            $retorno['msg']='Falha ao inserir o registro. Erro:030420201737';
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:030420201737';
            goto saida;
        }

        $result = $repo_orc_script_calculos->insertCalcOrcamentoEventos($orc_id);

        if($result["status"]!="success"){                       
            $retorno['msg']='Falha ao inserir o registro. Erro:030420201740';
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:030420201740';
            goto saida;
        }
          
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;        
    }
   
    // ----------------------------------------------------------------------------------------------------------

    public function atualizaOrcEvento($orc_id, $periodo = null, $tipo_table = 'O'){
        /*  */ 
        //$this->montaMesesOrc(1, ['origem_id', 'crea'], 1234);
        $condicao = $tipo_table == 'F' ? " and oe.tipo_table = '{$tipo_table}' and oe.periodo = '{$periodo}'" : " and oe.tipo_table = '{$tipo_table}'";
        
        $repo_calc = new RepoCalcOrcamento();
        $select = DB::select("SELECT e.id as evento_id,
        e.cdn_event, e.des_event, e.inc_liquido, e.impr_envel, e.multiplica, e.formula, e.ativo, e.origem, e.tipo_evento_id,
        e.dt_base_admissao_ini as dt_base_ini, e.dt_base_admissao_fim as dt_base_fim, e.tipo_acesso
        FROM tbl_eventos as e
        
        inner join tbl_cta_contabil_vs_eventos as cte on cte.eventos_id = e.id
        inner join tbl_cta_contabil as cta on cta.id = cte.cta_contabil_id
        inner join institb_empresa as emp on emp.id = e.empresa_id
        
        where e.ativo = 1 and (select count(*) from tbl_orc_eventos as oe where orcamento_id = {$orc_id} and oe.evento_id = e.id and oe.cdn_event = e.cdn_event".$condicao.") = 0");
        
        if(count($select) == 0){
            $this->setError("Nenhum evento encontrado. 271120200850");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    

                    $dado = (array) $value;
                    $where_existe = $tipo_table == 'F' ? " AND periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " AND tipo_table = '{$tipo_table}' ";
                    $existe = DB::select("SELECT * from tbl_orc_eventos where evento_id = ? and orcamento_id = ? {$where_existe} ", [$dado['evento_id'], $orc_id ]);

                    if( count($existe) > 0 ){
                        continue;
                    }

                    $dado['orcamento_id'] = $orc_id;
                    $dado['created_at'] = $this->fillCriadoEm();
                    $dado['created_by'] = $this->fillCriadoPor();
                    $dado['tipo_table'] = $tipo_table;
                    if($tipo_table == 'F'){
                        $dado['periodo'] = $periodo;
                    }
                    $insert = $this->create($dado);

                    if($insert === false){
                        $this->setError("Falha ao inserir registro. Erro: 301120201025");
                        return false;
                    }
                    $dados_calc = $this->montaMesesOrc($dado['multiplica'], ['origem_id', 'created_at', 'created_by', 'tbl_origem'], $insert->id);

                    $dados_calc['created_at'] = $this->fillCriadoEm();
                    $dados_calc['created_by'] = $this->fillCriadoPor();
                    $dados_calc['tbl_origem'] = $this->getModelEntity()->getTable();

                    $insert_calc = $repo_calc->create($dados_calc);
                    if($insert_calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 301120201026");
                        return false;
                    }
                }
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Erro ao inserir registro(s). Erro: 301120201024ct ".$e);
                return false;
            }
            return true;
        }
    }

    public function montaMesesOrc($valor, Array $campos = [], $origem_id){
        $meses = ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado'];
        $array = array_merge($meses, $campos);
        $dado = [];
        for($i = 0; $i < count($array); $i++){
            if($array[$i] == 'origem_id'){
                $dado = array_merge($dado, array($array[$i]=>$origem_id));
            }
            else if(strstr($array[$i], 'orcado')){
                $dado = array_merge($dado, array($array[$i]=>$valor));
            }
            else{
                $dado = array_merge($dado, array($array[$i]=>null));
            }
        }
        return $dado;
    }
}
