<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoOrcGestorAlternativo extends RepositoryNat51
{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcGestorAlternativo'; 
    protected $form_rules = [];
    protected $rules_msg = [];

    public function listar($orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_funcionario = new Funcionario();
        $tbl_usuario = new Usuario();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_ccusto = new CentroCusto();

        /*$select = $this->getModelEntity()
        ->leftJoin(
            DB::raw("{$tbl_funcionario->getTable()} as func1"),
            DB::raw("func1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('gestor_inicial_id')}")
        )

        ->leftJoin(
            DB::raw("{$tbl_funcionario->getTable()} as func2"),
            DB::raw("func2.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('gestor_final_id')}")
        )

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            DB::raw("CONCAT(func1.cdn_funcionario, ' - ', func1.nome_funcionario) as funcionario_1"),
            DB::raw("CONCAT(func2.cdn_funcionario, ' - ', func2.nome_funcionario) as funcionario_2"),
            
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")

        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), '=', $tipo_table);

        
        if($tipo_table == 'F'){
            $select = $select->where($this->getModelEntity()->getColunaAlias('periodo'), '=', $periodo)->get()->toArray();
        }
        else{
            $select = $select->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        ->get()->toArray();*/


        $select = $this->getModelEntity()
        ->join(
            DB::raw("{$tbl_funcionario->getTable()} as func1"),
            DB::raw("func1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('funcionario_id')}")
        )
        ->join(
            DB::raw("{$tbl_orc_lotacao->getTable()} as olot"),
            DB::raw("olot.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('lotacao_id')}")
        )

        ->join(
            DB::raw("{$tbl_ccusto->getTable()} as cc"),
            DB::raw("cc.id"),
            DB::raw("olot.cc_custo_id")
        )

        ->join(
            DB::raw("{$tbl_lotacao->getTable()} as lot"),
            DB::raw("lot.id"),
            DB::raw("olot.lotacao_id")
        )

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            DB::raw("CONCAT(func1.cdn_funcionario, ' - ', func1.nome_funcionario) as funcionario"),
            DB::raw("func1.id as funcionario_id"),

            DB::raw("cc.id as ccusto_id"),
            DB::raw("lot.id as lotacao_id"),

            DB::raw("CONCAT(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as lotacao"),
            
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),

            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('data_inicial')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('data_inicial')}, 'dd/MM/yyyy') ELSE '-' END as data_inicial_des"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('data_final')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('data_final')}, 'dd/MM/yyyy') ELSE '-' END as data_final_des"),

            $this->getModelEntity()->getColunaAlias('data_inicial'),
            $this->getModelEntity()->getColunaAlias('data_final')

        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), '=', $tipo_table);

        
        if($tipo_table == 'F'){
            $select = $select->where($this->getModelEntity()->getColunaAlias('periodo'), '=', $periodo)->get()->toArray();
        }
        else{
            $select = $select->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        
        return $select;
    }
    public function inserir($dados){
        
        try{
            $select = $this->getModelEntity()->select()
            ->where([
                [$this->getModelEntity()->getColunaAlias('gestor_inicial_id'), '=', $dados['gestor_inicial_id']],
                [$this->getModelEntity()->getColunaAlias('gestor_final_id'), '=',$dados['gestor_final_id']],
                [$this->getModelEntity()->getColunaAlias('tipo_table'), '=',$dados['tipo_table']],
                [$this->getModelEntity()->getColunaAlias('orcamento_id'), '=',$dados['orcamento_id']]
            ]);

            if($dados['tipo_table'] == 'F'){
                $select = $select->where($this->getModelEntity()->getColunaAlias('periodo'), $dados['periodo'])->get()->toArray();
            }
            else{
                $select = $select->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
            }
            if(count($select) > 0){
                $this->setError("Registro já existente. Erro: 260520201415");
                return false;
            }
            $inserir = $this->create($dados);
            if(!$inserir){
                $this->setError("Falha ao inserir registro. Erro: 260520201415");
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            $this->setError("Falha ao inserir registro. Erro: 260520201416#".$e);
            return false;
        }
    }

    public function novoInserir($dados){
        $msg = '';
        
        try{
            foreach($dados['lotacoes'] as $lotacao){
                
                $select = $this->getModelEntity()->select()
                ->where([
                    [$this->getModelEntity()->getColunaAlias('funcionario_id'), '=', $dados['gestor_inicial_id']],
                    [$this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $dados['orcamento_id']],
                    [$this->getModelEntity()->getColunaAlias('lotacao_id'), '=', $lotacao],
                    [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $dados['tipo_table']]
                ]);

                if($dados['tipo_table'] == 'F'){
                    $select = $select->where($this->getModelEntity()->getColunaAlias('periodo'), $dados['periodo'])->get()->toArray();
                }
                else{
                    $select = $select->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
                }
                if(count($select) > 0){
                    //$this->setError("Registro já existente. Erro: 150220211449");
                    $data = array(
                        "data_inicial" => $dados['data_inicial'],
                        "data_final" => $dados['data_final'],
                        "updated_at" => $this->fillModificadoEm(),
                        "updated_by" => $this->fillModificadoPor()
                    );
                    
                    $result = DB::table('tbl_orc_gestor_alternativo')->where('id', $select[0]['id'])->update(
                        $data
                    );
                    continue;
                }
                $mesma_lotacao = DB::select("SELECT * from tbl_funcionario as func
                    inner join tbl_orc_lotacao as olot on olot.lotacao_id = func.lotacao_id and olot.cc_custo_id = olot.cc_custo_id
                    where func.id = {$dados['gestor_inicial_id']} and olot.id = $lotacao
                ");
                if(count($mesma_lotacao) > 0){
                    $msg = $msg.'<br>Não foi possível inserir a lotação '.$this->getDesLotacaoByOrcId($lotacao).', pois ela já pertence ao funcionário selecionado.';
                    continue;
                }
                $data = array(
                    "funcionario_id" => $dados['gestor_inicial_id'],
                    "orcamento_id" => $dados['orcamento_id'],
                    "data_inicial" => $dados['data_inicial'],
                    "data_final" => $dados['data_final'],
                    "lotacao_id" => $lotacao,
                    "tipo_table" => $dados['tipo_table']
                );

                if($dados['tipo_table'] == 'F'){
                    $data['periodo'] = $dados['periodo'];
                }
                
                $inserir = $this->create($data);
                if(!$inserir){
                    $lot = $this->getDesLotacaoByOrcId($lotacao);
                    $msg = $msg.'<br>'.$lot == '' ? '' : 'Falha ao inserir registro para a lotação '.$lot;
                    continue;
                }
            }          
        }
        catch(\Exception $e){
            $this->setError("Falha ao inserir registro. Erro: 150220211527 - ".$e->getMessage());
            return false;
        }
        
        if(strlen($msg) != 0){
            $this->setError($msg);
            return false;
        }
        return true;
    }

    public function getDesLotacaoByOrcId($id_lot){
        $lotacao = DB::select("SELECT CONCAT(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'desc' FROM tbl_orc_lotacao as olot
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            where olot.id = $id_lot
        ");

        return count($lotacao) > 0 ? $lotacao[0]->desc : null;
    }
}