<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepositoryNat51; 
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Entities\OrcEventos;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
 
class RepoOrcHoraExtra extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcamLotCargoEvento';
    protected $form_rules=[];
    
    protected $rules_msg=[]; 
    
    public function insertHraExtra($form_data){
        // dd("evento orc", $form_data['evento_id']);
        // $orc_evento = OrcEventos::select('id')
        //                 ->where('evento_id', $form_data['evento_id'])
        //                 ->get();

                        // dd("aquiiiii", $orc_evento);

        $clausule = array(
            'orc_id'=>$form_data['orc_id'],
            'orc_cargo_id'=>$form_data['orc_cargo_id'],
            // 'orc_turma_id'=>$form_data['orc_turma_id'],
            'lotacao_id'=>$form_data['lotacao_id'],
            'ccusto_id'=>$form_data['ccusto_id'],
            'evento_id'=>$form_data['evento_id'],
            // 'tipo_table'=>$form_data['tipo_table']
        );


        if($this->hasDataOnDB($clausule)){
            $retorno = array('status'=>"error",'msg'=>'Falha ao inserir o registro. Dados já cadastrados!');
            goto saida;
        }
        
        $repo_calc_orc = new RepoCalcOrcamento();
        $meses = $this->dataFilterMesesCalcOrcamento($form_data);
        $data = $this->dataFilterHeadCount($form_data);
        $data = $this->putCargoIdOnData($data,$data['orc_cargo_id'],'cargo_id');
        
        DB::beginTransaction();

        try {
            $id_orc_event = $this->checkHeadcount($data);
            
            if(! $id_orc_event){
                $retorno['status']='error';
                $retorno['msg']=$this->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 140120201221.';
                goto saida;
            }    
            $merge_tb_calc = [
                'origem_id' => $id_orc_event->id,
                'tbl_origem' => $this->getModelEntity()->getTable()
            ];
            // dd("aquiiiiiii");
            if(! $repo_calc_orc->create(array_merge($merge_tb_calc, $meses))){
                $retorno['status']='error';
                $retorno['msg']='Falha ao inserir o registro. Erro: 140120201222';
                $retorno['submsg']=$repo_calc_orc->getErrosFlatted(); 
                goto saida;
            } 
            
            DB::commit();

        } catch (Exception $ex) {
            DB::rollBack();
            abort(500,'Falha ao inserir o registro. Erro: 140220201223.');            
        } 
        $retorno["title"]="Parabéns!";
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;
    }

    public function populaOrcHoraExtra($orc_id){
        
        $repo_orc_script_calculos = new RepoOrcScriptCalculos();  

        $result = $repo_orc_script_calculos->scriptInsertHoraExtra($orc_id, 1);  

        if($result["status"]!="success"){                       
            $retorno['msg']='Falha ao inserir o registro. Erro:060420201050';
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:060420201050';
            goto saida;
        }
          
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Atualizado com sucesso!";
        
        saida:
        return $retorno;        
    }
  
    public function deleteHraExtra($form_data){

        // dd($form_data);
        unset($form_data['_token']);
        // dd($form_data);
        $hra = $this->getModelEntity()->where($form_data);
        // dd($hra);
        if(!$hra->delete()){
            dd('entrou');
            return false;
        }
        // dd('n entrou');
        return true;
    }
    
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_id', 'lotacao_ancestral_id','lotacao_corrente_id','cargo_ancestral_id', 'cargo_corrente_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','evento_id','origem_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterHeadCount($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
   	
}