<?php

namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use \App\Core\Traits\ErrorTrait;

use Illuminate\Support\Facades\DB;

class RepoOrcInsertForecast extends RepoOrcamento
{
    
    public function createForecast($entities_param = ["headcount", "hora_extra", "ferias", "contratacoes", "promocao", "demissoes"], $orc_id){

        $orc_headcount = new OrcamLotCargoHeadcount();
        $orc_hora_extra = new OrcamLotCargoEvento();
        $orc_ferias = new OrcFerias();
        $orc_contratacoes = new OrcContratacoes();
        $orc_promocao = new OrcPromocao();
        $orc_demissoes = new OrcHeadcountDemissoes();     

        $entities = [
            'headcount' => ['instance'=>$orc_headcount, 'col_orc_id'=>'orc_id', 'orc_cargo_id'=>'orc_cargo_id', 
                'orc_turma_id'=>'orc_turma_id', 'ccusto_id'=>'ccusto_id'],
            'hora_extra' => ['instance'=>$orc_hora_extra, 'col_orc_id'=>'orc_id', 'orc_cargo_id'=>'orc_cargo_id', 
                'evento_id'=>'evento_id', 'orc_turma_id'=>'orc_turma_id', 'ccusto_id'=>'ccusto_id'],
            'ferias' => ['instance'=>$orc_ferias, 'col_orc_id'=>'orcamento_id', 'orc_cargo_id'=>'cargo_id', 
                'orc_turma_id'=>'orc_turma_id', 'ccusto_id'=>'ccusto_id', 'tipo_orc'=>'type', 'funcionario_id'=>'func_id'],
            'contratacoes' => ['instance'=>$orc_contratacoes, 'col_orc_id'=>'orcamento_id', 'orc_cargo_id'=>'orc_cargo_id', 
                'orc_turma_id'=>'orc_turma_id', 'ccusto_id'=>'ccusto_id'],
            'promocao' => ['instance'=>$orc_promocao, 'col_orc_id'=>'orc_id', 'orc_cargo_id'=>'cargo_atual_id', 
                'funcionario_id'=>'funcionario_id', 'orc_turma_id'=>'turma_atual_id', 'ccusto_id'=>'ccusto_id'],
            'demissoes' => ['instance'=>$orc_demissoes, 'col_orc_id'=>'orcamento_id', 'tipo_orc'=>'tipo', 
                'orc_cargo_id'=>'orc_cargo_id', 'orc_turma_id'=>'orc_turma_id', 'ccusto_id'=>'ccusto_id']
        ];

        foreach($entities as $key => $entitie){ 

            if(!in_array($key,$entities_param)){
                continue;
            }

            $result = $this->insertOrcamento($entitie, $orc_id);        
            
            if($result["status"]=="success"){  
                $result = $this->insertCalcOrcamento($entitie, $orc_id); 
            }
            
        }   
         
        return $result;       
    }

    public function insertOrcamento($entitie, $orc_id){
        
        $table_entitie = $entitie['instance'];
            
        $alias_table_a = 'table_a_'.$table;
        $alias_table_b = 'table_b_'.$table;

        $campos_remover = array("id", "created_at", "updated_at", "tipo_table");

        $col_entitie_insert = $this->colEntitie($entitie['instance'], $campos_remover);

        $col_select_diff = $this->colEntitieSelectDiff($entitie['instance'], $campos_remover);

        $col_select = [];
        
        foreach($col_select_diff as $value){            
            $col_select[] = $alias_table_a .".". $value;
        }

        $col_select_insert = implode(',', $col_select);

        $left_join = "LEFT JOIN ";        
        
        $where_orc = "
            {$alias_table_a}.{$entitie['col_orc_id']}=?
            AND {$alias_table_a}.tipo_table='O'
            AND {$alias_table_b}.id IS NULL;
        ";

        $evento_id = '';
        $funcionario_id = '';

        if(isset($entitie['evento_id'])){
            $evento_id = " AND {$alias_table_a}.{$entitie['evento_id']} = {$alias_table_b}.{$entitie['evento_id']}";           
        }   
        
        if(isset($entitie['funcionario_id'])){
            $funcionario_id = " AND isNULL({$alias_table_a}.{$entitie['funcionario_id']},-36) = 
                            isNULL({$alias_table_b}.{$entitie['funcionario_id']},-36)";           
        } 

        $on_orc = "{$alias_table_a}.{$entitie['col_orc_id']} = {$alias_table_b}.{$entitie['col_orc_id']}
                    AND 
                    {$alias_table_a}.[lotacao_id] = {$alias_table_b}.[lotacao_id] 
                    {$funcionario_id}
                    AND
                    {$alias_table_a}.{$entitie['orc_turma_id']} = {$alias_table_b}.{$entitie['orc_turma_id']}
                    AND
                    {$alias_table_a}.{$entitie['orc_cargo_id']} = {$alias_table_b}.{$entitie['orc_cargo_id']}                    
                    AND
                    {$alias_table_a}.{$entitie['ccusto_id']} = {$alias_table_b}.{$entitie['ccusto_id']}
                    {$evento_id}                    
                    AND 
                    {$alias_table_b}.tipo_table='F'";

        $select = $this->scriptSelectInsert($col_select_insert, $entitie['instance'], 
            $left_join, $on_orc, $where_orc);
            
        $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);

        return $result;
    }

    public function insertCalcOrcamento($entitie, $orc_id){
        $calc_orcamento = new CalcOrcamento(); 
        $table_entitie =$calc_orcamento;
        $table = $calc_orcamento->getTable();
        $insert_calc_orc = true;

        $tb_alias_c = $this->getAlias('c',$calc_orcamento); 
        $tb_alias_d = $this->getAlias('d',$calc_orcamento);
        $alias_table_c = 'table_c_'.$table;
        $alias_table_d = 'table_d_'.$table;

        $alias_table_a = 'table_a_'.$entitie['instance']->getTable();
        $alias_table_b = 'table_b_'.$entitie['instance']->getTable();

        $tipo = '';
        $evento_id = '';
        $funcionario_id = '';

        $campos_calc_orc = "{$alias_table_b}.id  origem_id  
        ,'{$entitie['instance']->getTable()}' tbl_origem,";

        if(isset($entitie['tipo_orc'])){
           $tipo = " AND {$alias_table_a}.{$entitie['tipo_orc']} = {$alias_table_b}.{$entitie['tipo_orc']}";           
        }

        if(isset($entitie['evento_id'])){
            $evento_id = " AND {$alias_table_a}.{$entitie['evento_id']} = {$alias_table_b}.{$entitie['evento_id']}";           
        }        

        if(isset($entitie['funcionario_id'])){
            $funcionario_id = " AND isNULL({$alias_table_a}.{$entitie['funcionario_id']},-36) = 
                                isNULL({$alias_table_b}.{$entitie['funcionario_id']},-36)";           
        }

        $campos_remover = array("id", "created_at", "updated_at", "tipo_table");

        $col_entitie_insert = $this->colEntitie($calc_orcamento, $campos_remover);

        $remover = array("id", "created_at", "updated_at", "tipo_table", "origem_id", "tbl_origem");

        $col_select_diff = $this->colEntitieSelectDiff($calc_orcamento, $remover);

        $col_select = [];
        
        foreach($col_select_diff as $value){            
            $col_select[] = $alias_table_c .".". $value;
        }

        $col_select_insert = implode(',', $col_select);                        
        
        $inner_join = "INNER JOIN ";

        $where_calc = "
            {$alias_table_a}.{$entitie['col_orc_id']}=?
            AND {$alias_table_b}.tipo_table='F'
            AND {$alias_table_d}.id is null
        ";       

        $on_cal_orc = "{$alias_table_a}.{$entitie['col_orc_id']} = {$alias_table_b}.{$entitie['col_orc_id']} 
                        AND  
                        {$alias_table_a}.[lotacao_id] = {$alias_table_b}.[lotacao_id]   
                        {$funcionario_id} 
                        AND 
                        {$alias_table_a}.{$entitie['orc_turma_id']} = {$alias_table_b}.{$entitie['orc_turma_id']}
                        AND 
                        {$alias_table_a}.{$entitie['orc_cargo_id']} = {$alias_table_b}.{$entitie['orc_cargo_id']}                        
                        AND 
                        {$alias_table_a}.{$entitie['ccusto_id']} = {$alias_table_b}.{$entitie['ccusto_id']} 
                        {$tipo}
                        {$evento_id}                        
                        AND 
                        {$alias_table_b}.tipo_table='F' 
                        AND  
                        {$alias_table_a}.tipo_table='O'
                        LEFT JOIN {$tb_alias_c} on 
                        {$alias_table_a}.id = {$alias_table_c}.origem_id 
                        AND
                        '{$entitie['instance']->getTable()}' = {$alias_table_c}.tbl_origem
                        LEFT JOIN {$tb_alias_d} on 
                        {$alias_table_b}.id = {$alias_table_d}.origem_id 
                        AND
                        '{$entitie['instance']->getTable()}' = {$alias_table_d}.tbl_origem";
       
        $select = $this->scriptSelectInsert($col_select_insert, $entitie['instance'], 
        $inner_join, $on_cal_orc, $where_calc, $campos_calc_orc);

        $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id, $insert_calc_orc);

        return $result;
    }

    public function scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id, $insert_calc_orc = null){        
        $tipo_table = ', tipo_table';
        $table = $table_entitie->getTable();
        if(!is_null($insert_calc_orc)){
            $tipo_table = '';
        }

        $insert = DB::raw("
                INSERT INTO $table (                   
                    $col_entitie_insert
                    , created_at
                    , updated_at                        
                    $tipo_table
                    ) 
            " . $select);
                    
        DB::beginTransaction();

        try {

            $result = DB::connection()->insert(
                $insert , [$orc_id]
            );

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 290120201505';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir forecast. Erro: 29012021500.'.$e);   
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno;   
    }
    
    public function scriptSelectInsert($col_select_insert, $entitie, $tipo_join, $condicoes_join, $where, $campos_calc_orc = null){
        $entitie_a = $this->getAlias('a',$entitie); 
        $entitie_b = $this->getAlias('b',$entitie);
        $col_calc_orc = '';
        $tipo_table = ", 'F' tipo_table";

        if(!is_null($campos_calc_orc)){
            $col_calc_orc = $campos_calc_orc;
            $tipo_table = '';
        }

        $select = "select 
                        {$col_calc_orc}  
                        {$col_select_insert}
                        , getDate() created_at
                        , NULL updated_at                        
                        {$tipo_table}
                    FROM 
                        {$entitie_a}
                    {$tipo_join}  
                        {$entitie_b} 
                    on
                        {$condicoes_join}
                WHERE
                    {$where}
            ";
        return $select;
    }

    public function getAlias($alias, $entitie){
        $alias_table = 'table_'.$alias.'_'.$entitie->getTable();
        $tb_alias_a = $entitie->getTable();       
        $tb_alias_a = $tb_alias_a . " AS {$alias_table}";

        return $tb_alias_a;
    }   

    public function colEntitie($entitie, $campos_remover){
        $col_entitie = implode(',', array_diff($entitie->getNomeColunas(), $campos_remover));

        return $col_entitie;
    }

    public function colEntitieSelectDiff($entitie, $campos_remover){
        $col_select_diff = array_diff($entitie->getNomeColunas(), $campos_remover);

        return $col_select_diff;
    }

}
