<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;

//use DB;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcLotCargoEvento extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcamLotCargoEvento';
    protected $form_rules=[];
    protected $rules_msg=[]; 

    public function updateLotCargo($orc_id, $data){
      
        DB::beginTransaction();
       
        try{      
            
            $data_update = [

                'jan_orcado' =>$data['jan'],
                'fev_orcado' =>$data['fev'],
                'mar_orcado' =>$data['mar'],
                'abr_orcado' =>$data['abr'],
                'mai_orcado' =>$data['mai'],
                'jun_orcado' =>$data['jun'],
                'jul_orcado' =>$data['jul'],
                'ago_orcado' =>$data['ago'],
                'set_orcado' =>$data['set'],
                'out_orcado' =>$data['out'],
                'nov_orcado' =>$data['nov'],
                'dez_orcado' =>$data['dez']
                ];       
                
                $data_update = convertDecimalEn($data_update);
                
                // dd("data",$data);
                $repoCalcOrc = new RepoCalcOrcamento();
                
                if(!$repoCalcOrc->update($data_update, ['tbl_origem'=>$this->getModelEntity()->getTable(),'origem_id'=>$data['id']])){ 
                    $this->setError('Falha ao fazer update do registro. Erro: 090620200953 ' .$this.getErrosFlatted());
                    DB::rollBack();
                    return false;                        
                }
                
               
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 090620200954.');
        }
        
        return array('msg'=>"Registro atualizado com Sucesso",'status'=>"success");
    }
    
    public function deleteLotCargo($orc_id, $data){
        $instance = $this;
        $repo_calc = new CalcOrcamento();
        
        $result = OrcamLotCargoEvento::where([
            ['id', $data['id']],
        ])->first();
        
        if(is_null($result)){
            $this->setError('Este registro não existe no orçamento. Erro: 090620200655 ');            
            return false;
        }

        DB::beginTransaction();
       
        try{
            
            if(!$instance->delete($data['id'])){  
                $this->setError('Falha ao deletar o registro. Erro: 090620200656 ' .$this->getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            $delete = DB::delete("DELETE from tbl_calc_orcamento where origem_id = ? and tbl_origem = ?", [$data['id'], $this->getModelEntity()->getTable()]);
            if($delete === false){
                $this->setError('Falha ao deletar o registro. Erro: 050120211725 ' .$this->getErrosFlatted());
                DB::rollBack();
                return false;
            }
            $this->makeModel();
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 090620200657.');
        }
        
        return array('msg'=>"Registro deletado com sucesso",'status'=>"success");
    }

    public function listarLotCargo($orc_id){
        
        $data = DB::select("
        select 
            event.id as id,
            ol.id as orc_lotacao_id,
            concat(cc.cod_ccusto, ' - ', l.des_unid_lotac) as lotacao,
            LEFT(c.cod_cargo_basic, 2) as grade_sal,
            ol.cc_custo_id+null as parent,
            c.des_cargo_basic as cargo,
            c.cod_cargo_basic as cod_cargo,
           
    
        from tbl_orc_eventos as event
        left join tbl_orc_cargo oc on oc.id = event.cargo_id
		left join tbl_cargo c on c.id = oc.cargo_id
        left join tbl_orc_lotacao ol on ol.id = event.orc_lot_id
        left join tbl_lotacao l on l.id = ol.lotacao_id
        left join tbl_ccusto cc on cc.id = ol.cc_custo_id
        where ol.orcamento_id = $orc_id");
        
        return $data;
    } 

    public function listarEventoLotCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(700);
        $condicao[0] = $tipo_table == 'F' ? " and event.tipo_table = '{$tipo_table}' and event.periodo = '{$periodo}'" : " and event.tipo_table = '{$tipo_table}' and event.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $data = DB::select("SELECT
            event.id as id,
            tb_ev.des_event,
            co.jan_orcado as jan,
            co.fev_orcado as fev,
            co.mar_orcado as mar,
            co.abr_orcado as abr,
            co.mai_orcado as mai,
            co.jun_orcado as jun,
            co.jul_orcado as jul,
            co.ago_orcado as ago,
            co.set_orcado as 'set',
            co.out_orcado as out, 
            co.nov_orcado as nov,
            co.dez_orcado as dez,
            ol.id as orc_lotacao_id,
            concat(cc.cod_ccusto, ' - ', l.unid_lotac, ' - ', l.des_unid_lotac) as lotacao,
            LEFT(c.cod_cargo_basic, 2) as grade_sal,
            ol.cc_custo_id+null as parent,
            c.des_cargo_basic as cargo,
            c.cod_cargo_basic as cod_cargo,
            concat(tb_ev.cdn_event, ' - ', tb_ev.des_event) as evento,
            concat(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description_cargo,

            CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,
            CASE WHEN event.created_at IS NOT NULL THEN format(event.created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,

            CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por,
            CASE WHEN co.updated_at IS NOT NULL THEN format(co.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em

            
           
    
        from tbl_orc_lot_carg_event as event
        left join tbl_orc_cargo oc on oc.id = event.orc_cargo_id {$condicao[1]}
		left join tbl_cargo c on c.id = oc.cargo_id
        left join tbl_orc_lotacao ol on ol.id = event.lotacao_id
        left join tbl_lotacao l on l.id = ol.lotacao_id
        left join tbl_ccusto cc on cc.id = ol.cc_custo_id
        left join tbl_calc_orcamento as co on co.origem_id  = event.id and co.tbl_origem='tbl_orc_lot_carg_event' 
        left join tbl_eventos as tb_ev on tb_ev.id =event.evento_id
        left join institb_usuario as usuario1 on usuario1.id = event.created_by
        left join institb_usuario as usuario2 on usuario2.id = co.updated_by
        where ol.orcamento_id = $orc_id
        ".$condicao[0]." order by  LEFT(c.cod_cargo_basic, 2) asc");
        
        
        return $data;
    }

    /**Método inutilizado em 04/05/2021 para começo de utilização do método seguinte: repopulate() 
     * DJRS.
    */
    public function repopulateOld($orc_id, $tipo_table = 'O', $periodo = null){
        $this->clearError();
        set_time_limit(700);
        $condicao[0] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}' " : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oca.tipo_table = '{$tipo_table}' and oca.periodo = '{$periodo}' " : " and oca.tipo_table = '{$tipo_table}' and oca.periodo is null";
        $condicao[2] = $tipo_table == 'F' ? " and ecl.tipo_table = '{$tipo_table}' and ecl.periodo = '{$periodo}' " : " and ecl.tipo_table = '{$tipo_table}' and ecl.periodo is null";

        $repoCalcOrc = new RepoCalcOrcamento();
        $select = DB::select("SELECT substring(cast(c.cod_cargo_basic as varchar), 1, 2) as grade,
            oca.lotacao_id, oca.ccusto_id, oc.id as orc_cargo_id, ce.evento_id,
            {$orc_id} as orc_id, ? as 'user_id', getdate() as created_at, ? as created_by, e.multiplica
            
            from tbl_cargos_eventos as ce
            
            inner join tbl_cargo as c on c.id = ce.cargo_id
            inner join tbl_orc_cargo as oc on oc.cargo_id = c.id and oc.orcamento_id = {$orc_id} {$condicao[0]}
            inner join tbl_orc_cargos_area_sal as oca on oca.cargo_id = oc.id and oca.orcamento_id = {$orc_id} {$condicao[1]}
            inner join tbl_eventos as e on e.id = ce.evento_id
            
            where (select count(*) from tbl_orc_lot_carg_event as ecl where ecl.orc_id = {$orc_id} and ecl.orc_cargo_id = oca.cargo_id and ecl.lotacao_id = oca.lotacao_id and ecl.evento_id = ce.evento_id {$condicao[2]}) = 0
            order by c.cod_cargo_basic asc", [$this->fillCriadoPor(), $this->fillCriadoPor()]
        );
        
        if(count($select) == 0){
            $this->setError("Nenhum Evento x Lotação x Cargo encontrado. 301120201327");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    $existe = DB::select("SELECT * from tbl_orc_lot_carg_event as ecl where ecl.orc_id = {$orc_id} and ecl.orc_cargo_id = {$value->orc_cargo_id} and ecl.lotacao_id = {$value->lotacao_id} and ecl.evento_id = {$value->evento_id}");                    
                    
                    if(count($existe) > 0){
                        continue;
                    }

                    $data = (array) $value;
                    $data = array_merge($data, array('tipo_table'=>$tipo_table));

                    $where_existe =  $tipo_table == 'F' ? " AND periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " AND tipo_table = '{$tipo_table}' ";
                    $existe = DB::select("SELECT *  from tbl_orc_lot_carg_event where orc_id = {$orc_id} and orc_cargo_id = {$data['orc_cargo_id']} and lotacao_id = {$data['lotacao_id']} and evento_id = {$data['evento_id']} {$where_existe}");

                    if( count($existe) > 0 ){
                        continue;
                    }

                    if($tipo_table == 'F'){
                        $data['periodo'] = $periodo;
                    }
                    if($data['ccusto_id'] == null){
                        $data['ccusto_id'] = DB::select("SELECT cc_custo_id from tbl_orc_lotacao where id = {$data['lotacao_id']}")[0]->cc_custo_id;
                    }
                    $data['created_at'] = $this->fillModificadoEm();
                    $data['created_by'] = $this->fillModificadoPor();

                    $insert = $this->create($data);

                    if($insert === false){
                        $this->setError("Falha ao inserir registro. Erro: 301120201409");
                        return false;
                    }

                    $multiplica = $this->getMultiplicaByEvento($value->evento_id, $orc_id, $tipo_table);
                    if($multiplica === false){
                        $dados = $this->montaMesesOrc( $value->multiplica, ['origem_id', 'created_at', 'created_by', 'tbl_origem'], $insert->id);
                    }
                    else{
                        $dados = Arr::except((array) $multiplica, ['user_id', 'empresa_id', 'created_at', 'created_by', 'updated_at', 'updated_by', 'id', 'origem_id', 'I_sec', 'tbl_origem']);
                    }
                    
                    $dados['origem_id'] = $insert->id;
                    $dados['tbl_origem'] = $this->getModelEntity()->getTable();
                    $dados['created_at'] = $this->fillCriadoEm();
                    $dados['created_by'] = $this->fillCriadoPor();
                    
                    $calc = $repoCalcOrc->create($dados);

                    if($calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 301120201408");
                        return false;
                    }
                }
            }
            catch(\Exception $e){
                DB::rollBack();
                if($e->getCode() == 1213){ // deadlock;
                    $this->setError("Erro ao inserir registro. Deadlock em: ".$e->getMessage().' - '.$e->getCode().' - '.$e->getFile().' - '.$e->getLine().' - '.$e->getTrace());
                    return false;
                }
                $this->setError("Erro ao inserir registro. Erro: 301120201328ct ".$e->getMessage());
                return false;
            }
            return true;
        }
    }

    public function repopulate($orc_id, $tipo_table = 'O', $periodo = null){
        
        $this->clearError();
        set_time_limit(700);
        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}' " : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and olce.tipo_table = '{$tipo_table}' and olce.periodo = '{$periodo}' " : " and olce.tipo_table = '{$tipo_table}' and olce.periodo is null";
        $condicao[2] = $tipo_table == 'F' ? " and olce_lot_current.tipo_table = '{$tipo_table}' and olce_lot_current.periodo = '{$periodo}' " : " and olce_lot_current.tipo_table = '{$tipo_table}' and olce_lot_current.periodo is null";
        // $condicao[3] = $tipo_table == 'F' ? " and ecl.tipo_table = '{$tipo_table}' and ecl.periodo = '{$periodo}' " : " and ecl.tipo_table = '{$tipo_table}' and ecl.periodo is null";

        $repoCalcOrc = new RepoCalcOrcamento();
        $select = DB::select("select 
                                ol.id orc_lotacao_id,	
                                ol.cc_custo_id ccusto_id,	
                                oc.id orc_cargo_id,	
                                l.unid_lotac,
                                c.cod_cargo_basic
                            from tbl_orc_cargos_area_sal ocas
                            join tbl_orc_lotacao ol on ol.id = ocas.lotacao_id
                            join tbl_orc_cargo oc on oc.id = ocas.cargo_id
                            join tbl_lotacao l on l.id = ol.lotacao_id
                            join tbl_cargo c on c.id = oc.cargo_id
                            where ocas.orcamento_id = $orc_id".$condicao[0]
        );
        
        if(count($select) == 0){
            $this->setError("Não foram encontrados cargo por lotação. Cod. 040520210848");
            return 'warning';
        }
        else{
            try{
               
                foreach($select as $value){
                    // if($value->orc_lotacao_id == 149515 && $value->orc_cargo_id == 286067){

                    // }
                    $dados_inserir = DB::select("                    
                        select 
                            olce.evento_id evento_id,
                            co.jan_orcado,
                            co.fev_orcado,
                            co.mar_orcado,
                            co.abr_orcado,
                            co.mai_orcado,
                            co.jun_orcado,
                            co.jul_orcado,
                            co.ago_orcado,
                            co.set_orcado,
                            co.out_orcado,
                            co.nov_orcado,
                            co.dez_orcado
                        from tbl_orc_lot_carg_event olce
                        join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_event' and co.origem_id = olce.id
                        join tbl_orc_lotacao ol on ol.id = olce.lotacao_id
                        join tbl_orc_cargo oc on oc.id = olce.orc_cargo_id
                        join tbl_lotacao l on l.id = ol.lotacao_id
                        join tbl_cargo c on c.id = oc.cargo_id
                        where olce.orc_id = $orc_id 
                        and oc.id = {$value->orc_cargo_id} and LEFT(l.unid_lotac, 6) = LEFT('{$value->unid_lotac}', 6)
                        ".$condicao[1]."
                        and not exists (select olce_lot_current.id 
                                    from tbl_orc_lot_carg_event olce_lot_current 
                                    where olce_lot_current.lotacao_id = {$value->orc_lotacao_id}
                                    and olce_lot_current.orc_cargo_id = {$value->orc_cargo_id}
                                    and olce_lot_current.evento_id = olce.evento_id
                                    ".$condicao[2].")
                    ");                    
                    
                    if(count($dados_inserir) == 0){
                        $dados_inserir = DB::select("                    
                            select 
                                olce.evento_id evento_id,
                                co.jan_orcado,
                                co.fev_orcado,
                                co.mar_orcado,
                                co.abr_orcado,
                                co.mai_orcado,
                                co.jun_orcado,
                                co.jul_orcado,
                                co.ago_orcado,
                                co.set_orcado,
                                co.out_orcado,
                                co.nov_orcado,
                                co.dez_orcado
                            from tbl_orc_lot_carg_event olce
                            join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_event' and co.origem_id = olce.id
                            join tbl_orc_lotacao ol on ol.id = olce.lotacao_id
                            join tbl_orc_cargo oc on oc.id = olce.orc_cargo_id
                            join tbl_lotacao l on l.id = ol.lotacao_id
                            join tbl_cargo c on c.id = oc.cargo_id
                            where olce.orc_id = $orc_id 
                            and oc.id = {$value->orc_cargo_id} and LEFT(l.unid_lotac, 4) = LEFT('{$value->unid_lotac}', 4)
                            ".$condicao[1]."
                            and not exists (select olce_lot_current.id 
                                        from tbl_orc_lot_carg_event olce_lot_current 
                                        where olce_lot_current.lotacao_id = {$value->orc_lotacao_id}
                                        and olce_lot_current.orc_cargo_id = {$value->orc_cargo_id}
                                        and olce_lot_current.evento_id = olce.evento_id
                                        ".$condicao[2].")
                        "); 
                    }
                    
                    
                    if(count($dados_inserir) == 0){
                        continue;
                    }
                    
                    $data = (array) $value;
                    $data = array_merge($data, array('tipo_table'=>$tipo_table));
                    $data['orc_id'] = $orc_id;
                    $data['lotacao_id'] = $data['orc_lotacao_id'];
                    $data['empresa_id'] = $this->fillCodEmpresa();                    
                    $data['created_at'] = $this->fillCriadoEm();
                    $data['created_by'] = $this->fillCriadoPor();

                    if($tipo_table == 'F'){
                        $data['periodo'] = $periodo;
                    }
                    if($data['ccusto_id'] == null){
                        $data['ccusto_id'] = DB::select("SELECT cc_custo_id from tbl_orc_lotacao where id = {$data['lotacao_id']}")[0]->cc_custo_id;
                    }

                    foreach ($dados_inserir as $item) {
                        $data['evento_id'] = $item->evento_id;

                        if($data['tipo_table'] == 'F'){
                            $existe = DB::select("
                            select id from tbl_orc_lot_carg_event where
                                lotacao_id = ".$data['lotacao_id']." and
                                orc_cargo_id = ".$data['orc_cargo_id']." and
                                evento_id = ".$data['evento_id']." and
                                orc_id = ".$data['orc_id']." and
                                tipo_table = '".$data['tipo_table']."' and 
                                periodo = '".$data['periodo']."' and
                                empresa_id = ".$data['empresa_id']."
                            ");
                        }
                        else{                            
                            $existe = DB::select("
                            select id from tbl_orc_lot_carg_event where
                                lotacao_id = ".$data['lotacao_id']." and
                                orc_cargo_id = ".$data['orc_cargo_id']." and
                                evento_id = ".$data['evento_id']." and
                                orc_id = ".$data['orc_id']." and
                                tipo_table = '".$data['tipo_table']."' and 
                                empresa_id = ".$data['empresa_id']."
                            ");
                        }
                      
                        if(count($existe) > 0 ){
                            continue;
                        }
                        

                        $insert = $this->create($data);

                        if($insert === false){
                            $this->setError("Falha ao inserir registro. Erro: 301120201409");
                            return false;
                        }

                        
                        $dados['jan_orcado'] = $item->jan_orcado;
                        $dados['fev_orcado'] = $item->fev_orcado;
                        $dados['mar_orcado'] = $item->mar_orcado;
                        $dados['abr_orcado'] = $item->abr_orcado;
                        $dados['mai_orcado'] = $item->mai_orcado;
                        $dados['jun_orcado'] = $item->jun_orcado;
                        $dados['jul_orcado'] = $item->jul_orcado;
                        $dados['ago_orcado'] = $item->ago_orcado;
                        $dados['set_orcado'] = $item->set_orcado;
                        $dados['out_orcado'] = $item->out_orcado;
                        $dados['nov_orcado'] = $item->nov_orcado;
                        $dados['dez_orcado'] = $item->dez_orcado;

                        $dados['origem_id'] = $insert->id;
                        $dados['tbl_origem'] = $this->getModelEntity()->getTable();
                        $dados['created_at'] = $this->fillCriadoEm();
                        $dados['created_by'] = $this->fillCriadoPor();
                        
                        $calc = $repoCalcOrc->create($dados);

                        if($calc === false){
                            $this->setError("Falha ao inserir registro. Erro: 301120201408");
                            return false;
                        }
                    }
                    // $where_existe =  $tipo_table == 'F' ? " AND periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " AND tipo_table = '{$tipo_table}' ";
                    // $existe = DB::select("SELECT *  from tbl_orc_lot_carg_event where orc_id = {$orc_id} and orc_cargo_id = {$data['orc_cargo_id']} and lotacao_id = {$data['lotacao_id']} and evento_id = {$data['evento_id']} {$where_existe}");

                    // if( count($existe) > 0 ){
                    //     continue;
                    // }

                }
            }
            catch(\Exception $e){
                DB::rollBack();
                if($e->getCode() == 1213){ // deadlock;
                    $this->setError("Erro ao inserir registro. Deadlock em: ".$e->getMessage().' - '.$e->getCode().' - '.$e->getFile().' - '.$e->getLine().' - '.$e->getTrace());
                    return false;
                }
                $this->setError("Erro ao inserir registro. Erro: 301120201328ct ".$e->getMessage());
                return false;
            }
            return true;
        }
    }

    public function getMultiplicaByEvento($evento_id, $orc_id, $tipo_table = 'O'){//INSERT NA MÃO ESTÁ PARECIDO COM ESSE
        $valor = DB::select("SELECT * from tbl_calc_orcamento where tbl_origem = 'tbl_orc_eventos' and origem_id in (select id from tbl_orc_eventos where evento_id = $evento_id and orcamento_id = {$orc_id})");
        return count($valor) == 0 ? false : $valor[0];
    }

    public function montaMesesOrc($valor, Array $campos = [], $origem_id){
        $meses = ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado'];
        $array = array_merge($meses, $campos);
        $dado = [];
        for($i = 0; $i < count($array); $i++){
            if($array[$i] == 'origem_id'){
                $dado = array_merge($dado, array($array[$i]=>$origem_id));
            }
            else if(strstr($array[$i], 'orcado')){
                $dado = array_merge($dado, array($array[$i]=>$valor));
            }
            else{
                $dado = array_merge($dado, array($array[$i]=>null));
            }
        }
        return $dado;
    }
    public function repopulateAll($orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(700);
        try{
            $orc_id = intval($orc_id, 10);
            $created_by = intval($this->fillCriadoPor(), 10);
            $empresa_id = intval($this->fillCodEmpresa(), 10);

            $sql = '';
            if($tipo_table == 'F'){
                $sql = "EXEC sp_orc_evento_lot_cargo_forecast :orc_id, :empresa_id, :tipo_table, :periodo, :user_id";
                $stmt = DB::getPdo()->prepare($sql);
                $stmt->bindValue(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindValue(':empresa_id', $empresa_id, \PDO::PARAM_INT );
                $stmt->bindValue(':tipo_table', 'F', \PDO::PARAM_STR );
                $stmt->bindValue(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindValue(':user_id', $created_by, \PDO::PARAM_INT );

                
                if(!$stmt->execute()){
                    $this->setError('Falha ao atualizar registros. Erro: 021220201350');
                    return false;
                }
            }
            else{
                $sql = "EXEC sp_orc_evento_lot_cargo :orc_id, :empresa_id, :tipo_table, :periodo, :user_id";
                $stmt = DB::getPdo()->prepare($sql);
                $stmt->bindValue(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindValue(':empresa_id', $empresa_id, \PDO::PARAM_INT );
                $stmt->bindValue(':tipo_table', 'O', \PDO::PARAM_STR );
                $stmt->bindValue(':periodo', null, \PDO::PARAM_NULL );
                $stmt->bindValue(':user_id', $created_by, \PDO::PARAM_INT );

                
                if(!$stmt->execute()){
                    $this->setError('Falha ao atualizar registros. Erro: 021220201350');
                    return false;
                }
            }
            
        }
        catch(\Exception $e){
            DB::rollBack();
            $this->setError("Erro ao atualizar registros. Erro: 021220201352ct ".$e->getMessage());
            return false;
        }
        return true;
    }
}