<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Exception;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcLotFuncionarioBeneficio extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio';
//     protected $form_rules=[
//         ''=>'required|unique:tbl_evetbl_orc_beneficio_funcionariontos,cdn_event'
//    ];
//    protected $rules_msg=[
//         'cdn_event.required'=>'O campo Cód. Evento é obrigatório',
//         'cdn_event.unique'=>'Cód. Evento já cadastrado'
//    ]; 
                            
    public function createOrcLotFuncionarioBeneficio($data_request){     
        
        // if(!$this->getRespEstrutura($data_request['orcamento_id'],$data_request['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520200919");
        //     return false;
        // }
        
        // $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();

        //CONFERE SE EXISTE
        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$data_request['funcionario_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$data_request['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']],
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$data_request['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$data_request['orc_beneficio_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$data_request['tipo_table']]

        ]);
        $funcionario_beneficio = [];

        if($data_request['tipo_table'] == 'F'){
            $funcionario_beneficio = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $data_request['periodo'])->get()->toArray();
        }
        else{
            $funcionario_beneficio = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        
        //dd($funcionario_beneficio);
        
        //SE EXISTE
        if(count($funcionario_beneficio)>0){
            //E SE É ABSOLUTO
            /*if($data_request['tipo_meses']==2)
            {
                $select_calc_orc = $tbl_calc_orc->select()->where([
                    [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$funcionario_beneficio[0]['id']],
                    [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //SE EXISTE
                //dd($select_calc_orc);

                if(count($select_calc_orc)>0)
                {
                    $this->setError("Registro já existente em valor absoluto. Erro: 080420201002");
                    return false;
                }
                //SENAO
                else
                {
                    if(!$this->insereCalcOrc($funcionario_beneficio[0]['id'],$data_request)){
                        $this->setError('Erro ao inserir registro. Erro: 080420201003');
                        return false;
                    }
                }
            }*/
            //SE É INDICE
            /*else if($data_request['tipo_meses']==1)
            {
                $select_calc_ind = $tbl_calc_ind->select()->where([
                    [$tbl_calc_ind->getColunaAlias('origem_id'),'=',$funcionario_beneficio[0]['id']],
                    [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //SE EXISTE
                if(count($select_calc_ind)>0)
                {
                    $this->setError("Registro já existente em índice.  Erro: 070420201150");
                    return false;
                }
                //SENAO
                else
                {   
                    if(!$this->insereIndice($funcionario_beneficio[0]['id'],$data_request)){
                        
                        $this->setError('Erro ao inserir registro.  Erro: 080420201005');
                        return false;
                    }
                }
            }*/
            $this->setError("Falha ao inserir registro.<br>Erro: 050620200953");
            return false;
        }
        //SE NÃO EXISTE
        else{
            
            /*if($data_request['tipo_meses']==1){
                if(!$this->createOrclotFuncionarioBeneficioInidice($data_request)){
                    $this->setError('Não foi possível inserir os índices. Erro:070420201448');
                    return false;
                }
                return true;
            }*/
            //else{
                //dd("AQUI");
                if(!$this->insereCalcFuncionarioBeneficio($data_request)){
                    $this->setError('Não foi possível inserir os valores absolutos. Erro:070420201449');
                    return false;
                }
                return true;
            //}
        }
        
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
    }

    public function insereCalcFuncionarioBeneficio($data_request){
        $retorno=true;
        $instance = $this;
        //dd("AQUI2",$data_request);
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            $id_orc_lot_funcionario_ben = $instance->createParent($data_request);
            
            if(! $id_orc_lot_funcionario_ben){  
                $retorno = false;
                return false;
            }  
            
            $merge_tb_calc = [
                'origem_id' => $id_orc_lot_funcionario_ben->id,
                'tbl_origem' => $instance->getModelEntity()->getTable()
            ];
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }

            if(!$this->insereIndice($id_orc_lot_funcionario_ben->id, $data_request)){
                $this->setError("Falha ao inserir índices.<br>Erro: 050620201002");
                return false;
            }
                        
        });
        //dd("fbmgkl",$data_request);
        return $retorno;
    }

    public function insereIndice($id,$dados){
        $tbl_calc_indice=new CalcIndice();
        $data = $dados;
        $dados = $dados['meses_orcado'];
        $indice = 1;
        $select = $tbl_calc_indice->select()
        ->where([
            [$tbl_calc_indice->getColunaAlias('origem_id'), '=', $data['orc_beneficio_id']],
            [$tbl_calc_indice->getColunaAlias('tbl_origem'), '=', 'tbl_orc_beneficio'],
        ])->get()->toArray();
            
        if(count($select) > 0){
            $env_meses = Arr::except($select[0],['created_at','user_id','updated_at','empresa_id','updated_by','created_by','id','origem_id','tbl_origem']);
            
            $dados_indice = array_merge(array(
                'origem_id'=>$id,
                'tbl_origem'=>$this->getModelEntity()->getTable()
            ),$env_meses);
            
        }else{
            $dados_indice=array(
                'origem_id'=>$id,
                'tbl_origem'=>$this->getModelEntity()->getTable(),
                'jan_indice'=>$indice,
                'fev_indice'=>$indice,
                'marc_indice'=>$indice,
                'abril_indice'=>$indice,
                'maio_indice'=>$indice,
                'jun_indice'=>$indice,
                'jul_indice'=>$indice,
                'agost_indice'=>$indice,
                'set_indice'=>$indice,
                'out_indice'=>$indice,
                'nov_indice'=>$indice,
                'dez_indice'=>$indice
            );
        }

        //$dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            $this->setError('Erro ao inserir índices.');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();
        $data = $data['meses_orcado'];
        
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
        $inseriu=$calc_orcamento->create($orcamento);
        //dd($inseriu);
        if(!$inseriu)
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
    }

    public function createOrclotFuncionarioBeneficioInidice(array $dados){

        $this->clearError();

        $tb_calc_indice=new CalcIndice();
        
        // $select=$this->getModelEntity()->select()->where([
        //         [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']],
        //         [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$dados['funcionario_id']],
        //         [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$dados['orc_lotacao_id']],
        //         [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$dados['ccusto_id']],
        //         [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$dados['orc_beneficio_id']]
        // ])->get()->toArray();

        // if(count($select)>0){
        //     $this->setError('Registro já cadastrado');
        //     return false;
        // }

        $dados_env=Arr::except($dados,['meses_orcado']);

        //dd("asdasdasfrge",$dados_env);
        DB::beginTransaction();
        try{
            $salvou = $this->create($dados_env);

            if(!$salvou){
                return false;
            }
            //dd($salvou);
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['meses_orcado']['jan_orcado'],
            'fev_indice'=>$dados['meses_orcado']['fev_orcado'],
            'marc_indice'=>$dados['meses_orcado']['mar_orcado'],
            'abril_indice'=>$dados['meses_orcado']['abr_orcado'],
            'maio_indice'=>$dados['meses_orcado']['mai_orcado'],
            'jun_indice'=>$dados['meses_orcado']['jun_orcado'],
            'jul_indice'=>$dados['meses_orcado']['jul_orcado'],
            'agost_indice'=>$dados['meses_orcado']['ago_orcado'],
            'set_indice'=>$dados['meses_orcado']['set_orcado'],
            'out_indice'=>$dados['meses_orcado']['out_orcado'],
            'nov_indice'=>$dados['meses_orcado']['nov_orcado'],
            'dez_indice'=>$dados['meses_orcado']['dez_orcado'],
        );
            //dd($dados_indice);
            $salvar_indice=$tb_calc_indice->create($dados_indice);
             
            if(!$salvar_indice){
                $this->setError('Falha ao inserir indices. Erro: 010420201109');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 010420201109.'.$ex);
       }
       return true;
    }

    public function listarIndice($orc_id, $periodo = null, $tipo_table = 'O'){

        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        $tbl_calc_ind = new CalcIndice();
        $tbl_funcionario = new Funcionario();
        $tbl_orc_beneficio = new OrcBeneficio();
        $tbl_eventos = new Eventos();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_ccusto = new CentroCusto();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();

        $query = $this->getModelEntity()
        ->join($tbl_calc_ind->getTable(), $this->getModelEntity()->getColunaAlias('id'), DB::raw($tbl_calc_ind->getColunaAlias('origem_id').' and '.$tbl_calc_ind->getColunaAlias('tbl_origem').' = '."'tbl_orc_beneficio_funcionario'"))
        ->leftJoin($tbl_funcionario->getTable(), $this->getModelEntity()->getColunaAlias('funcionario_id'), $tbl_funcionario->getColunaAlias('id'))
        ->leftJoin($tbl_orc_beneficio->getTable(), $this->getModelEntity()->getColunaAlias('orc_beneficio_id'), $tbl_orc_beneficio->getColunaAlias('id'))
        ->leftJoin($tbl_eventos->getTable(), $tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_eventos->getColunaAlias('id'))

        ->leftJoin($tbl_cta_ctb->getTable(), $tbl_orc_beneficio->getColunaAlias('cta_ctb_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_orc_lotacao->getTable(), $this->getModelEntity()->getColunaAlias('orc_lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_ccusto->getTable(), $this->getModelEntity()->getColunaAlias('ccusto_id'), $tbl_ccusto->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_ind->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('vlr_maximo'),
            DB::raw("CASE {$this->getModelEntity()->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1- Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),
            
            $this->getModelEntity()->getColunaAlias('tipo_calc'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            DB::raw("{$tbl_calc_ind->getColunaAlias('id')} as calc_ind_id"),

            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            $tbl_lotacao->getColunaAlias('unid_lotac'),
            $this->getModelEntity()->getColunaAlias('funcionario_id'),
            $this->getModelEntity()->getColunaAlias('orc_lotacao_id'),
            $this->getModelEntity()->getColunaAlias('ccusto_id'),
            $this->getModelEntity()->getColunaAlias('orc_beneficio_id'),
            
            $this->getModelEntity()->getColunaAlias('vlr_movto'),
            $this->getModelEntity()->getColunaAlias('vlr_depend'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('formula'),

            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),

            $tbl_calc_ind->getColunaAlias('origem_id'),
            $tbl_calc_ind->getColunaAlias('tbl_origem'),
            $tbl_orc_beneficio->getColunaAlias('evento_id'),
            $tbl_eventos->getColunaAlias('cdn_event'),
            $tbl_eventos->getColunaAlias('des_event'),
            $tbl_funcionario->getColunaAlias('cdn_funcionario'),
            $tbl_funcionario->getColunaAlias('nome_funcionario'),
            $tbl_funcionario->getColunaAlias('num_reg_func'),

            $tbl_ccusto->getColunaAlias('cod_ccusto'),
            $tbl_ccusto->getColunaAlias('des_ccusto'),
            
            $tbl_calc_ind->getColunaAlias('jan_indice'),
            $tbl_calc_ind->getColunaAlias('fev_indice'),
            $tbl_calc_ind->getColunaAlias('marc_indice'),
            $tbl_calc_ind->getColunaAlias('abril_indice'),
            $tbl_calc_ind->getColunaAlias('maio_indice'),
            $tbl_calc_ind->getColunaAlias('jun_indice'),
            $tbl_calc_ind->getColunaAlias('jul_indice'),
            $tbl_calc_ind->getColunaAlias('agost_indice'),
            $tbl_calc_ind->getColunaAlias('set_indice'),
            $tbl_calc_ind->getColunaAlias('out_indice'),
            $tbl_calc_ind->getColunaAlias('nov_indice'),
            $tbl_calc_ind->getColunaAlias('dez_indice'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$tbl_calc_ind->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_ind->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id ],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table ]
        ]);
        //->whereIn($tbl_lotacao->getColunaAlias('id'),$lotacoes)
        
        $dados = [];
        if($tipo_table == 'F'){
            $dados = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $dados = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        

        for($i = 0; $i < count($dados); $i++){
            $dados[$i] = array_merge($dados[$i],array("description"=>$dados[$i]['cod_ccusto'].' - '.$dados[$i]['unid_lotac'].' - '.$dados[$i]['des_unid_lotac']));
            $dados[$i] = array_merge($dados[$i],array("description_cta_ctb"=>$dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl']));
            $dados[$i] = array_merge($dados[$i],array("description_func"=>$dados[$i]['cdn_funcionario'].' - '.$dados[$i]['nome_funcionario']));
            $dados[$i] = array_merge($dados[$i],array("description_ben"=>$dados[$i]['cdn_event'].' - '.$dados[$i]['des_event']));
            $dados[$i]['identificador']="1";
        }

        return $dados;
    }

    public function createParent($data_request){
        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$data_request['funcionario_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$data_request['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']],
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$data_request['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$data_request['orc_beneficio_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$data_request['tipo_table']]
        ]);
        $dados = [];

        if($data_request['tipo_table'] == 'F'){
            $dados = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $data_request['periodo'])->get()->toArray();
        }
        else{
            $dados = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        
        if(count($dados)==0){
            return parent::create($data_request);
        }else{
            $this->setError("Registro já cadastrado! erro:180220201018");
            
            abort(500, "Registro já cadastrado! erro:180220201018");
            return false;
        }
    }

    public function listar($data_request, $periodo = null, $tipo_table = 'O'){

        $tbl_calc_orc=new CalcOrcamento();
        // $tbl_orc_lotacao = new OrcLotacao();
        $orcamento_id = $data_request['orcamento_id'];
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($data_request['orcamento_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));

        /* 
        $orc_lot_funcionario_beneficio = OrcLotFuncionatioBeneficio::
        join($tbl_calc_orc->getTable(),$this->getModelEntity()->getColunaAlias('id'),
        DB::raw($tbl_calc_orc->getColunaAlias('origem_id').' and '.$tbl_calc_orc->getColunaAlias('tbl_origem').' = '."'tbl_orc_beneficio_funcionario'"))

        ->leftJoin($tbl_orc_lotacao->getTable(), $this->getModelEntity()->getColunaAlias('orc_lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))
        
        ->with([
            'getOrcBeneficio'=>function($query){
                return $query->with([
                    'getEvento'=>function($query){
                        return $query;
                    },
                    'getCtaCtb'=>function($query){
                        return $query;
                    }
                    ]);
            },
            'getFuncionario'=>function($query){
                return $query;
            },
            'getCalcOrcamento'=>function($query){
                return $query;
            },
            'getCentroCusto'=>function($query){
                return $query;
            },
            'getOrcLotacao'=>function($query){
                return $query->with([
                    'getLotacao'=>function($query){
                        return $query;
                    }
                ]);
            }
        ])->where([
            $this->getModelEntity()->getColunaAlias('orcamento_id')=> $data_request['orcamento_id']
        ])

        //->whereIn($tbl_orc_lotacao->getColunaAlias('lotacao_id'),$lotacoes)

        ->get()
        ->toArray();*/
        // dd($orc_lot_funcionario_beneficio);
        // $orc_lot_funcionario_beneficio = DB::select(
        //     "
        //     SELECT
        //     orc_func.id,
        //     orc_func.[orcamento_id]
        
        //     ,CASE orc_func.[tipo_calc]
        //     WHEN 1 THEN 'Por Hora'
        //     WHEN 2 THEN 'Proporcional'
        //     WHEN 3 THEN 'Fixo'
        //     WHEN 4 THEN 'Dias Trabalhados'
        //     END as des_tipo_calc

        //     ,lot.des_unid_lotac
        //     ,evento.id as event_id
        //     ,evento.cdn_event
        //     ,evento.des_event
        //     ,cta_ctb.cod_cta_ctbl
        //     ,cta_ctb.desc_cta_ctbl
        //     ,func.cdn_funcionario
        //     ,func.nome_funcionario
        //     ,func.num_reg_func
        //     ,calc.id as calc_id
        //     ,cc.cod_ccusto
        //     ,cc.des_ccusto

        //     ,orc_func.[vlr_movto]
        //     ,orc_func.[vlr_maximo]
        //     ,orc_func.[vlr_depend]
        //     ,orc_func.[formula]
        //     ,calc.*
        //     ,func.nome_funcionario
        //     ,lot.des_unid_lotac
        //     ,cta_ctb.desc_cta_ctbl
        //     ,evento.des_event

        //     FROM [natureza].[dbo].[tbl_orc_beneficio_funcionario] as orc_func

        //     left join [natureza].[dbo].[tbl_calc_orcamento] as calc on orc_func.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_beneficio_funcionario'
        //     left join [natureza].[dbo].[tbl_funcionario] as func on orc_func.funcionario_id = func.id
        //     left join [natureza].[dbo].[tbl_orc_lotacao] as orc_lot on orc_func.orc_lotacao_id = orc_lot.id and orc_lot.orcamento_id = $orcamento_id
        //     left join [natureza].[dbo].[tbl_lotacao] as lot on orc_lot.lotacao_id = lot.id
        //     left join [natureza].[dbo].[tbl_cta_contabil] as cta_ctb on orc_func.cta_ctb_id = cta_ctb.id
        //     left join [natureza].[dbo].[tbl_orc_beneficio] as orc_ben on orc_func.orc_beneficio_id = orc_ben.id and orc_ben.orcamento_id = $orcamento_id
        //     left join [natureza].[dbo].[tbl_beneficio] as ben on orc_ben.beneficio_id = ben.id
        //     left join [natureza].[dbo].[tbl_eventos] as evento on ben.evento_id = evento.id
        //     left join [natureza].[dbo].[tbl_ccusto] as cc on orc_func.ccusto_id = cc.id


        //     where orc_func.orcamento_id = $orcamento_id
        //     "
        // );
        $tbl_funcionario = new Funcionario();
        $tbl_orc_lot = new OrcLotacao();
        $tbl_lot = new Lotacao();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_orc_ben = new OrcBeneficio();
        $tbl_ben = new Beneficio();
        $tbl_eventos = new Eventos();
        $tbl_ccusto = new CentroCusto();
        $tbl_usuario = new Usuario();

        $query = $this->getModelEntity()
        ->leftJoin($tbl_calc_orc->getTable(), $this->getModelEntity()->getColunaAlias('id'), '=', 
                                DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
                                {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))

        ->leftJoin($tbl_funcionario->getTable(), $this->getModelEntity()->getColunaAlias('funcionario_id'), $tbl_funcionario->getColunaAlias('id'))
        
        ->leftJoin($tbl_orc_lot->getTable(), $this->getModelEntity()->getColunaAlias('orc_lotacao_id'), '=',
        DB::raw("{$tbl_orc_lot->getColunaAlias('id')} and {$tbl_orc_lot->getColunaAlias('orcamento_id')} = {$orcamento_id}"))

        ->leftJoin($tbl_lot->getTable(), $tbl_orc_lot->getColunaAlias('lotacao_id'), $tbl_lot->getColunaAlias('id'))
        ->leftJoin( $tbl_cta_ctb->getTable(), $this->getModelEntity()->getColunaAlias('cta_ctb_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_orc_ben->getTable(), $this->getModelEntity()->getColunaAlias('orc_beneficio_id'), '=',
        DB::raw("{$tbl_orc_ben->getColunaAlias('id')} and {$tbl_orc_ben->getColunaAlias('orcamento_id')} = {$orcamento_id}"))
        
        ->leftJoin( $tbl_ben->getTable(), $tbl_orc_ben->getColunaAlias('beneficio_id'), $tbl_ben->getColunaAlias('id'))
        ->leftJoin($tbl_eventos->getTable(), $tbl_orc_ben->getColunaAlias('evento_id'), $tbl_eventos->getColunaAlias('id'))
        ->leftJoin($tbl_ccusto->getTable(), $this->getModelEntity()->getColunaAlias('ccusto_id'), $tbl_ccusto->getColunaAlias('id'))
        
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_orc->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('vlr_maximo'),
            DB::raw("CASE {$this->getModelEntity()->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),
            
            $this->getModelEntity()->getColunaAlias('tipo_calc'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            DB::raw("{$tbl_calc_orc->getColunaAlias('id')} as calc_id"),

            $tbl_lot->getColunaAlias('des_unid_lotac'),
            $tbl_lot->getColunaAlias('unid_lotac'),
            $this->getModelEntity()->getColunaAlias('funcionario_id'),
            $this->getModelEntity()->getColunaAlias('orc_lotacao_id'),
            $this->getModelEntity()->getColunaAlias('ccusto_id'),
            $this->getModelEntity()->getColunaAlias('orc_beneficio_id'),
            
            $this->getModelEntity()->getColunaAlias('vlr_movto'),
            $this->getModelEntity()->getColunaAlias('vlr_depend'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('formula'),

            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),

            $tbl_calc_orc->getColunaAlias('origem_id'),
            $tbl_calc_orc->getColunaAlias('tbl_origem'),
            DB::raw("{$tbl_calc_orc->getColunaAlias('id')} as calc_id"),
            $tbl_orc_ben->getColunaAlias('evento_id'),
            $tbl_eventos->getColunaAlias('cdn_event'),
            $tbl_eventos->getColunaAlias('des_event'),
            $tbl_funcionario->getColunaAlias('cdn_funcionario'),
            $tbl_funcionario->getColunaAlias('nome_funcionario'),
            $tbl_funcionario->getColunaAlias('num_reg_func'),

            $tbl_ccusto->getColunaAlias('cod_ccusto'),
            $tbl_ccusto->getColunaAlias('des_ccusto'),
            
            $tbl_calc_orc->getColunaAlias('jan_orcado'),
            $tbl_calc_orc->getColunaAlias('fev_orcado'),
            $tbl_calc_orc->getColunaAlias('mar_orcado'),
            $tbl_calc_orc->getColunaAlias('abr_orcado'),
            $tbl_calc_orc->getColunaAlias('mai_orcado'),
            $tbl_calc_orc->getColunaAlias('jun_orcado'),
            $tbl_calc_orc->getColunaAlias('jul_orcado'),
            $tbl_calc_orc->getColunaAlias('ago_orcado'),
            $tbl_calc_orc->getColunaAlias('set_orcado'),
            $tbl_calc_orc->getColunaAlias('out_orcado'),
            $tbl_calc_orc->getColunaAlias('nov_orcado'),
            $tbl_calc_orc->getColunaAlias('dez_orcado'),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orcamento_id ],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table ]
        ]);
        
        $select = [];
        if($tipo_table == 'F'){
            $select = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        
        for($i = 0; $i < count($select); $i++){
            $select[$i] = array_merge($select[$i],array("description"=>$select[$i]['cod_ccusto'].' - '.$select[$i]['unid_lotac'].' - '.$select[$i]['des_unid_lotac']));
            $select[$i] = array_merge($select[$i],array("description_cta_ctb"=>$select[$i]['cod_cta_ctbl'].' - '.$select[$i]['desc_cta_ctbl']));
            $select[$i] = array_merge($select[$i],array("description_func"=>$select[$i]['cdn_funcionario'].' - '.$select[$i]['nome_funcionario']));
            $select[$i] = array_merge($select[$i],array("description_ben"=>$select[$i]['cdn_event'].' - '.$select[$i]['des_event']));
            $select[$i]['identificador'] = "2";
        }
        return $select;
    }  

    public function listaEventos(){
        $orcBeneficio = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            }
        ])->get()
        ->toArray();
      
       
        for ($i=0; $i < count($orcBeneficio); $i++) {             
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            Arr::forget($orcBeneficio[$i], 'get_evento');

        }

        return $orcBeneficio;
    }  
    
    public function deleteOrcLotFuncionarioBeneficio($data_request){     
        
        // if(!$this->getRespEstrutura($data_request['orcamento_id'],$data_request['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520200925");
        //     return false;
        // }
        $retorno=true;
        $instance = $this;
       
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $calc_indice = new CalcIndice();
            $repo_calc_ind = new RepoCalcIndice();
            $repo_calc_orcamento = new RepoCalcOrcamento();

            if(!$instance->getModelEntity()->where($instance->getModelEntity()->getColunaAlias('id'),'=',$data_request['origem_id'])->delete()){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          

            if(!$repo_calc_orcamento->getModelEntity()->where($repo_calc_orcamento->getModelEntity()->getColunaAlias('id'),'=',$data_request['calc_id'])->delete()){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
            $select_indice = $calc_indice->select()->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();

            if(count($select_indice)>0){
                
                $delete_indices = $repo_calc_ind->getModelEntity()->where([
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]])
                ->delete();
    
                if(!$delete_indices){
                    
                    $retorno = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }
                        
        });
        
        return $retorno;
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function updateOrcLotFuncionarioBeneficio($data_request){   
        
        // if(!$this->getRespEstrutura($data_request['orcamento_id'],$data_request['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520200928");
        //     return false;
        // }

        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            $orc_lot_func = Arr::only($data_request,['id','orcamento_id', 'funcionario_id', 'orc_lotacao_id', 'ccusto_id',
            'orc_beneficio_id', 'tipo_calc', 'formula','origem_id']);

            if($data_request['vlr_depend']==null){
                $data_request['vlr_depend']=0;
            }
            if($data_request['vlr_movto']==null){
                $data_request['vlr_movto']=0;
            }

            // $vlr_movto=array('vlr_movto'=>convertDec($data_request['vlr_movto']));
            // $vlr_depend=array('vlr_depend'=>convertDec($data_request['vlr_depend']));

            $vlr_movto = array("vlr_movto"=>convertDec($data_request['vlr_movto']));
            $vlr_depend = array("vlr_depend"=>convertDec($data_request['vlr_depend']));
    
            $array_lot_cargo = array_merge( $orc_lot_func, $vlr_movto, $vlr_depend );
            
            if(!$instance->updateParent($array_lot_cargo, $array_lot_cargo['origem_id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['id'];
            $dados_orc=Arr::except($data_request,['orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula','vlr_movto','vlr_depend']);

            // $dados_orcamento = Arr::except($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','jul_orcado','set_orcado',
            // 'out_orcado','nov_orcado','dez_orcado']);

            $meses=Arr::only($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $orcamento = convertDec($meses);
            // $array_orcamento = array_merge($dados_orcamento,$orcamento);
            
            $calc_orcamento_id['id'] = $data_request['id'];

            if(! $repo_calc_orcamento->update($orcamento, $data_request['calc_id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }
    public function updateIndice($form_data){

        // if(!$this->getRespEstrutura($form_data['orcamento_id'],$form_data['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520200931");
        //     return false;
        // }

        $tbl_calc_indice = new RepoCalcIndice();
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        
        $id = $form_data['calc_ind_id'];
        
        $update = $tbl_calc_indice->update($meses,$id);
        
        if(!$update){
            $this->setError('Erro ao atualizar registro. Erro:060420201051');
            
            return false;
        }
        return true;
    }
    public function updateParent($data_request, $id){
        $dados=$this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('id'),'=',$id)->get()->toArray();
        if(count($dados)==1){
            return parent::update($data_request, $id);
        }
        return false;

    }
    public function deleteIndice($form_data){

        // if(!$this->getRespEstrutura($form_data['orcamento_id'],$form_data['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520200924");
        //     return false;
        // }

        $repo_calc_ind = new RepoCalcIndice();
        $calc_orcamento = new CalcOrcamento();

        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();

            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420200801");
                return false;
            }
        }
        else{

            DB::beginTransaction();
            try {
                if(!$this->delete($form_data['id'])){
                    return false;
                }    
                
                if(!$repo_calc_ind->delete($form_data['calc_ind_id'])){
                    return false;
                }    
                
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 060420201052.');
                return false;
            }
        }
        return true;
    }
}

