<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcNotificacoes;
use App\Modules\Natureza51\Repositories\RepoOrcMovtoStatusCCusto;
use App\Modules\Natureza51\Repositories\RepoOrcParamNatureza;
use App\Modules\Natureza51\Repositories\RepoNotify;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Jobs\SendEmail;
use App\Jobs\CalculateLotacao;


class RepoOrcLotacao extends RepoOrcamento
{        
    use \App\Core\Traits\ParamTrait;

    protected $model_name_space='App\Modules\Natureza51\Entities\OrcLotacao';
    protected $form_rules=[];
    protected $repo_notificacoes;
    protected $repo_movto_status;
    protected $repo_notify;
    private $user_id;
    private $last_error;

    protected $rules_msg=[]; 

    function __construct($user_id = null) { 
        if(!is_null($user_id)){
            $this->setUserId($user_id);
        }
        $this->repo_notificacoes = new RepoOrcNotificacoes();
        $this->repo_movto_status = new RepoOrcMovtoStatusCCusto();
        $this->repo_notify = new RepoNotify();
        parent::__construct();
    }

        //Status da lotação
    const STATUS_LOT_PENDENTE_DIGITACAO=1;
    const STATUS_LOT_REABERTO=2;
    const STATUS_LOT_ENVIADO=3;
    const STATUS_LOT_CONFERIDO=4; 
    const STATUS_LOT_CALCULADO=5;
    const STATUS_LOT_CALCULADO_LIBERADO=6;
    const STATUS_LOT_APROVADO=7; 
    const STATUS_LOT_APROVADO_DIRETOR_AREA=8; 
    
    const STATUS_LOT_PENDENTE_DIGITACAO_FCST=9;
    const STATUS_LOT_REABERTO_FCST=10;
    const STATUS_LOT_ENVIADO_FCST=11;
    const STATUS_LOT_CONFERIDO_FCST=12; 
    const STATUS_LOT_CALCULADO_FCST=13;
    const STATUS_LOT_CALCULADO_LIBERADO_FCST=14;
    const STATUS_LOT_APROVADO_FCST=15; 
    const STATUS_LOT_APROVADO_DIRETOR_AREA_FCST=16;  


    public function getStatusLotPendenteDigitacao(){
        return self::STATUS_LOT_PENDENTE_DIGITACAO;
    }
    public function getStatusLotReaberto(){
        return self::STATUS_LOT_REABERTO;
    }
    public function getStatusLotEnviado(){
        return self::STATUS_LOT_ENVIADO;
    }
    public function getStatusLotConferido(){
        return self::STATUS_LOT_CONFERIDO;
    }
    public function getStatusLotCalculado(){
        return self::STATUS_LOT_CALCULADO;
    }
    public function getStatusLotCalculadoLiberado(){
        return self::STATUS_LOT_CALCULADO_LIBERADO;
    }
    public function getStatusLotAprovado(){
        return self::STATUS_LOT_APROVADO;
    }
    public function getStatusLotAprovadoGestor(){
        return self::STATUS_LOT_APROVADO_GESTOR;
    }
    public function getStatusLotAprovadoDiretorArea(){
        return self::STATUS_LOT_APROVADO_DIRETOR_AREA;
    } 

    public function getStatusLotPendenteDigitacaoFCST(){
        return self::STATUS_LOT_PENDENTE_DIGITACAO_FCST;
    }
    public function getStatusLotReabertoFCST(){
        return self::STATUS_LOT_REABERTO_FCST;
    }
    public function getStatusLotEnviadoFCST(){
        return self::STATUS_LOT_ENVIADO_FCST;
    }
    public function getStatusLotConferidoFCST(){
        return self::STATUS_LOT_CONFERIDO_FCST;
    }
    public function getStatusLotCalculadoFCST(){
        return self::STATUS_LOT_CALCULADO_FCST;
    }
    public function getStatusLotCalculadoLiberadoFCST(){
        return self::STATUS_LOT_CALCULADO_LIBERADO_FCST;
    }
    public function getStatusLotAprovadoFCST(){
        return self::STATUS_LOT_APROVADO_FCST;
    }
    public function getStatusLotAprovadoGestorFCST(){
        return self::STATUS_LOT_APROVADO_GESTOR_FCST;
    }
    public function getStatusLotAprovadoDiretorAreaFCST(){
        return self::STATUS_LOT_APROVADO_DIRETOR_AREA_FCST;
    }

    public function getRepoNotification(){
        return $this->repo_notificacoes;
    }

    public function getRepoMovtoStatusLot(){
        return $this->repo_movto_status;
    }

    public function getRepoNotify(){
        return $this->repo_notify;
    }

    public function getUserId(){
        return $this->user_id;
    }
    public function setUserId($id){
        $this->user_id = $id;
        return $this;
    }

    public function getLastError(){
        return $this->last_error;
    }
    public function setLastError($e){
        $this->last_error = $e;
        return $this;
    }


    public function listarExistemPlanoLotacao($orc_id, $cod_plano_lotacao, $periodo = null, $tipo_table = 'O'){  

        $lots_plano = DB::select("SELECT lot.id from tbl_lotacao lot
        join tbl_estrutura_plano_lotac est on est.lotacao_id = lot.id
        join tbl_plano_lotac plan_lot on plan_lot.id = est.plano_lotacao_id
        where lot.ativo = 1 and plan_lot.cdn_plano_lotac = $cod_plano_lotacao");
        
        $lots_plano = array_map(function($lot) {
            return $lot->id;
        }, $lots_plano);


        $lotacoes = OrcLotacao::with([
            'getLotacao'=>function($query){            
                return $query;
            },
            'getCentroCusto'=>function($query){
                return $query;
            }
        ])
        ->whereIn('lotacao_id', $lots_plano)
        ->where('orcamento_id','=',intval($orc_id))
        ->where('tipo_table', $tipo_table)
        ->where('ativo', 1);

        if($tipo_table == 'F'){
            $lotacoes = $lotacoes->where('periodo', $periodo)->get();
        }
        else{
            $lotacoes = $lotacoes->whereNull('periodo')->get();
        }
        
     

        
        $array_lotacao = [];
        for ($i=0; $i < count($lotacoes); $i++) { 
            if($lotacoes[$i]->getLotacao->ativo != 1){
                continue;
            }
            
        
            $lotacoes[$i]['quadro_atual'] = $lotacoes[$i]->getLotacao->quadro_atual;
            $lotacoes[$i]['ativo'] = $lotacoes[$i]->getLotacao->ativo;
            $lotacoes[$i]['unid_lotac'] = $lotacoes[$i]->getLotacao->unid_lotac;
            $lotacoes[$i]['des_unid_lotac'] = $lotacoes[$i]->getLotacao->des_unid_lotac;
            $lotacoes[$i]['cod_ccusto'] = $lotacoes[$i]->getCentroCusto->cod_ccusto;
            $lotacoes[$i]['des_ccusto'] = $lotacoes[$i]->getCentroCusto->des_ccusto;
            $lotacoes[$i]['description'] = $lotacoes[$i]->getCentroCusto->cod_ccusto.' - '.$lotacoes[$i]->getLotacao->unid_lotac.' '. $lotacoes[$i]->getLotacao->des_unid_lotac;
            $lotacoes[$i]['status_atual'] = $lotacoes[$i]['status'];
            $lotacoes[$i]['status_orc_lotacao'] = $lotacoes[$i]['status'];

            switch ($lotacoes[$i]['status']) {
                case '1':
                    $lotacoes[$i]['status_label'] = 'Pendente';
                break;
                case '2':
                    $lotacoes[$i]['status_label'] = 'Em Andamento';
                break;
                case '3':
                    $lotacoes[$i]['status_label'] = 'Enviado';
                break;  
                case '4':
                    $lotacoes[$i]['status_label'] = 'Reaberto';
                break;
                case '5':
                    $lotacoes[$i]['status_label'] = 'Conferido';
                break;  
                case '6':
                    $lotacoes[$i]['status_label'] = 'Liberado';
                break;
                case '7':
                    $lotacoes[$i]['status_label'] = 'Finalizado';
                break;
                case '8':
                    $lotacoes[$i]['status_label'] = 'Aprovado';
                break;
                case '9':
                    $lotacoes[$i]['status_label'] = 'Em Execução';
                break;
                case '10':
                    $lotacoes[$i]['status_label'] = 'Enviado Sistema';
                break;
                default:
                    $lotacoes[$i]['status_label'] = $lotacoes[$i]['status']; 
                break;
            }

            Arr::forget($lotacoes[$i], 'getLotacao');
            Arr::forget($lotacoes[$i], 'getCentroCusto');

            array_push($array_lotacao,$lotacoes[$i]);
        }
        
            return $array_lotacao;
    } 
   
    public function listar($orc_id, $periodo = null, $tipo_table = 'O', $all = false){  
        // dd($periodo);
        // DB::enableQueryLog();
        $query = OrcLotacao::with([
            'getLotacao'=>function($query){            
                return $query;
            },
            'getCentroCusto'=>function($query){
                return $query;
            }
        ])->where('orcamento_id','=',intval($orc_id))
        ->where('tipo_table', $tipo_table);

        $lotacoes = null;
        if($tipo_table == 'F'){
            $lotacoes = $query->where('periodo', $periodo)->get();
        }
        else{
            $lotacoes = $query->whereNull('periodo')->get();
        }
        // dd(DB::getQueryLog());
        
        $array_lotacao = [];
        for ($i = 0; $i < count($lotacoes); $i++) { 
            // if($lotacoes[$i]->getLotacao->ativo != 1){
            //     continue;
            // }
            if($lotacoes[$i]->ativo != 1 && !$all){
                continue;
            }
            
        
            $lotacoes[$i]['quadro_atual'] = $lotacoes[$i]->getLotacao->quadro_atual;
            // $lotacoes[$i]['ativo'] = $lotacoes[$i]->getLotacao->ativo;
            $lotacoes[$i]['unid_lotac'] = $lotacoes[$i]->getLotacao->unid_lotac;
            $lotacoes[$i]['des_unid_lotac'] = $lotacoes[$i]->getLotacao->des_unid_lotac;
            $lotacoes[$i]['cod_ccusto'] = $lotacoes[$i]->getCentroCusto->cod_ccusto;
            $lotacoes[$i]['des_ccusto'] = $lotacoes[$i]->getCentroCusto->des_ccusto;
            $lotacoes[$i]['description'] = $lotacoes[$i]->getCentroCusto->cod_ccusto.' - '.$lotacoes[$i]->getLotacao->unid_lotac.' '. $lotacoes[$i]->getLotacao->des_unid_lotac;

            switch ($lotacoes[$i]['status']) {
                case '1':
                    $lotacoes[$i]['status_label'] = 'Pendente';
                break;
                case '2':
                    $lotacoes[$i]['status_label'] = 'Em Andamento';
                break;
                case '3':
                    $lotacoes[$i]['status_label'] = 'Enviado';
                break;  
                case '4':
                    $lotacoes[$i]['status_label'] = 'Reaberto';
                break;
                case '5':
                    $lotacoes[$i]['status_label'] = 'Conferido';
                break;  
                case '6':
                    $lotacoes[$i]['status_label'] = 'Liberado';
                break;
                case '7':
                    $lotacoes[$i]['status_label'] = 'Finalizado';
                break;
                case '8':
                    $lotacoes[$i]['status_label'] = 'Aprovado';
                break;
                case '9':
                    $lotacoes[$i]['status_label'] = 'Em Execução';
                break;
                case '10':
                    $lotacoes[$i]['status_label'] = 'Enviado Sistema';
                break;
                default:
                    $lotacoes[$i]['status_label'] = $lotacoes[$i]['status']; 
                break;
            }

            Arr::forget($lotacoes[$i], 'getLotacao');
            Arr::forget($lotacoes[$i], 'getCentroCusto');

            array_push($array_lotacao,$lotacoes[$i]);
        }
        
            return $array_lotacao;
    } 

    public function listarLotAtiva($orc_id, $periodo = null, $tipo_table = 'O'){
        // dd("orc id ", $orc_id);
        $lotacao = new Lotacao();
        // $funcionario = new Funcionario();
        $ccusto = new CentroCusto();

        $query = /*$lotacao
        ->join($funcionario->getTable(),
        $funcionario->getColunaAlias('lotacao_id'),'=',
        DB::raw($lotacao->getColunaAlias('id') .' and '. $funcionario->getColunaAlias('dat_demis_func') .' is null ' )
        )
        ->join($ccusto->getTable(),
        $ccusto->getColunaAlias('id'),'=', 
        DB::raw($funcionario->getColunaAlias('ccusto_id') .' and '. $ccusto->getColunaAlias('ativo') .' = 1' )
        )
        ->join($this->getModelEntity()->getTable(),
        $this->getModelEntity()->getColunaAlias('lotacao_id'),'=',
        DB::raw($lotacao->getColunaAlias('id') .' and '. $this->getModelEntity()->getColunaAlias('cc_custo_id') .' = ' . $ccusto->getColunaAlias('id'))
        )*/
        $this->getModelEntity()
        ->join($lotacao->getTable(), $this->getModelEntity()->getColunaAlias('lotacao_id'), '=', $lotacao->getColunaAlias('id'))
        ->join($ccusto->getTable(), $this->getModelEntity()->getColunaAlias('cc_custo_id'), '=', $ccusto->getColunaAlias('id'))
        ->select(
            DB::raw("DISTINCT {$lotacao->getColunaAlias('unid_lotac')}"),
            $this->getModelEntity()->getColunaAlias('id'), 
            $lotacao->getColunaAlias('des_unid_lotac'),
            DB::raw("CONCAT({$ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$lotacao->getColunaAlias('unid_lotac')}, ' - ' , {$lotacao->getColunaAlias('des_unid_lotac')}) description "),
            $this->getModelEntity()->getColunaAlias('orcamento_id'), 
            $this->getModelEntity()->getColunaAlias('responder_orc'), 
            $this->getModelEntity()->getColunaAlias('cc_custo_id'), 
            $ccusto->getColunaAlias('des_ccusto'), 
            $this->getModelEntity()->getColunaAlias('status'),   
            DB::raw("CASE 
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 1 THEN 'Pendente'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 2 THEN 'Em Andamento'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 3 THEN 'Enviado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 4 THEN 'Reaberto'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 5 THEN 'Conferido'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 6 THEN 'Liberado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 7 THEN 'Finalizado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 8 THEN 'Aprovado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 9 THEN 'Em Execução'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 10 THEN 'Enviado Sistema'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 11 THEN 'Rejeitado'
                        END as status_label"),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('created_at'), 
            $this->getModelEntity()->getColunaAlias('updated_at')
        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table);

        $resp = null;
        if($tipo_table == 'F'){
            $resp = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)
            ->orderby($lotacao->getColunaAlias('des_unid_lotac'))->get();
        }
        else{
            $resp = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))
            ->orderby($lotacao->getColunaAlias('des_unid_lotac'))->get(); 
        }
           
        return $resp;

    }

    public function sendManager($data, $situacao = null, $metodo = null, $tipo_table = false){   
        
        $hierarquia_max = [1,2,3];
        $repo_func = new RepoFuncionario();   

        $lot = $this->getDataLotacaoOrcamento($data['lotacao_id']);
        $orc = $lot->getOrcamento;
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        $tipo_table = $tipo_table != 'F' ? 'O' : 'F';
        ($tipo_table == 'F') ? $periodo = $data['periodo'] : $periodo = date('Y-m-d');// date('Y').'-'.$data['periodo'].'-'.'01'
        
        // if($lot->status != $this->getStatusLotPendenteDigitacao() && $lot->status != $this->getStatusLotReaberto()){            
        //     $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 210920201521.');            
        //     return false;
        // };
        $data_funcionario = $this->getDataFuncionario();
        
        $data_manager = $repo_func->getFuncsByNivelHierarquicoLotacManager($lot->getLotacao->unid_lotac, $data_funcionario->getFuncionario->nivel_hier, $orc->id, $periodo, $tipo_table); 
        
        $observacao = "teste";        
        
        ($tipo_table == 'F') ? $tipo_aprovacao = 3 : $tipo_aprovacao = 1 ;
        ($tipo_table == 'F') ? $tipo = "forecast" : $tipo = "headcount" ;

        if(!is_null($situacao)) {
            $situacao = $situacao;
        } else {
            ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1 ;
        }
         
        $descricao = $tipo;       
        $tela = $tipo;
        
        DB::beginTransaction();
        if($metodo == null) {
            $this->insertNotificacaoLiberado($data['lotacao_id'], $lot->getOrcamento->id, $descricao, $tipo_aprovacao, $tipo_table, $periodo);
        }
        
        $dados_notificacao = $this->prepareinsertNotification($data['lotacao_id'], $lot->getOrcamento->id, $situacao, $descricao, $tipo_aprovacao, $tipo_table, $periodo);

        if(in_array($data_funcionario->getFuncionario->nivel_hier, $hierarquia_max) || empty($data_manager)) {            
            $ret = $this->sendRh($data['lotacao_id'], $tipo_table);  
        
            if(!$ret){
                return $ret;
            }

            goto saida;
        }      
        
        if($metodo != null) {
            $data_manager_id = $data_manager[0]->id;
            $data_manager_alter = NULL;             
            ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1;
           
            $historico = "aprovado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            $ret = $this->insertNotification($data['lotacao_id'], $lot->getOrcamento->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
        }
            
        $ret_noti_apv_Man = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);

        /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
        if($ret_noti_apv_Man) {
            $p2 = $tipo_table == 'O' ? null : $periodo;
            $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $lot->getOrcamento->id, $tipo_table, $p2);

            if($user_aprov_alternativo_id){
                $data_manager_alter= $repo_func->getFuncsManagerAlternativo($user_aprov_alternativo_id);
               
                $ret_noti_apv_Man_alter = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager_alter[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);
            }
        }*/
       
        if(!$this->sendStatus($data['lotacao_id'],$this->getModelNameSpace(), 'status', $tipo_table)){
            DB::rollBack();
            return false;
        }
        if($tipo_table == 'F'){
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where orc_lotacao_id = ? and periodo = '{$periodo}' and tipo_table = 'F' ", [$this->getStatusLotEnviadoFCST(), $data['lotacao_id']]);
        }
        saida:
        
        DB::commit();        

        return true;  
    }

    public function sendManagerForecast($data, $situacao = null, $metodo = null, $tipo_table = false){   
        
        $hierarquia_max = [1,2,3];
        $repo_func = new RepoFuncionario();   
        $data['lotacao_id'] = ($tipo_table == 'F' && (array_key_exists('stringId', $data)))  ? $data['stringId'] : $data['lotacao_id'];
        // dd($data);
        $lot = $this->getDataLotacaoOrcamento($data['lotacao_id']);
        $pieces = explode("-", $data['periodo']);
        
        $periodo = (count($pieces) == 3) ? $pieces[0] . "-" .  $pieces[1] . "-" . $pieces[2] : $data['periodo'];
        // dd($periodo);
        $orc = $lot->getOrcamento;
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        
        $tipo_table = $tipo_table != 'F' ? 'O' : 'F';
        ($tipo_table == 'F') ? $periodo : $periodo = date('Y-m-d');
        
        // if($lot->status != $this->getStatusLotPendenteDigitacao() && $lot->status != $this->getStatusLotReaberto()){            
        //     $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 210920201521.');            
        //     return false;
        // };
        $data_funcionario = $this->getDataFuncionario();
        
        $data_manager = $repo_func->getFuncsByNivelHierarquicoLotacManager($lot->getLotacao->unid_lotac, $data_funcionario->getFuncionario->nivel_hier, $orc->id, $periodo, $tipo_table); 
 
        $observacao = "teste";        
        
        ($tipo_table == 'F') ? $tipo_aprovacao = 3 : $tipo_aprovacao = 1 ;
        ($tipo_table == 'F') ? $tipo = "forecast" : $tipo = "headcount" ;

        if(!is_null($situacao)) {
            $situacao = $situacao;
        } else {
            ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1 ;
        }
         
        $descricao = $tipo;       
        $tela = $tipo;
        
        DB::beginTransaction();
        if($metodo == null) {
            $this->insertNotificacaoLiberado($data['lotacao_id'], $lot->getOrcamento->id, $descricao, $tipo_aprovacao, $tipo_table, $periodo);
        }
        
        $dados_notificacao = $this->prepareinsertNotification($data['lotacao_id'], $lot->getOrcamento->id, $situacao, $descricao, $tipo_aprovacao, $tipo_table, $periodo);

        if(in_array($data_funcionario->getFuncionario->nivel_hier, $hierarquia_max) || empty($data_manager)) {            
            $ret = $this->sendRh($data['lotacao_id'], $tipo_table);  
        
            if(!$ret){
                return $ret;
            }

            goto saida;
        }      
        
        if($metodo != null) {
            $data_manager_id = $data_manager[0]->id;
            $data_manager_alter = NULL;             
            ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1;
           
            $historico = "aprovado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            $ret = $this->insertNotification($data['lotacao_id'], $lot->getOrcamento->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
        }
            
        $ret_noti_apv_Man = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);

        /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
        if($ret_noti_apv_Man) {
            $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $lot->getOrcamento->id, $periodo, $tipo_table);

            if($user_aprov_alternativo_id){
                $data_manager_alter= $repo_func->getFuncsManagerAlternativo($user_aprov_alternativo_id);
               
                $ret_noti_apv_Man_alter = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager_alter[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);
            }
        }*/
       
        if(!$this->sendStatus($data['lotacao_id'],$this->getModelNameSpace(), 'status', $tipo_table)){
            DB::rollBack();
            return false;
        }
        
        saida:
        
        DB::commit();        

        return true;  
    }
  
    public function sendRh($id, $tipo_table = false){ 
        $lot = $this->getModelEntity()->with([
                'getOrcamento'=>function($query){

                },
                'getLotacao'=>function($query){

                }
        ])->where('id',$id)->first();
        
        $orc = $lot->getOrcamento;
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;   
        
        if($tipo_table == 'F') {
            if($lot->status != $this->getStatusLotPendenteDigitacaoFCST() && $lot->status != $this->getStatusLotReabertoFCST() && $lot->status != $this->getStatusLotEnviadoFCST()){
                $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 191020201733.');
                return false;
            };
        } else {
            if($lot->status != $this->getStatusLotPendenteDigitacao() && $lot->status != $this->getStatusLotReaberto() && $lot->status != $this->getStatusLotEnviado()){
                $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 150120200952.');
                return false;
            };
        }        
        
        DB::beginTransaction();
        
        if(!$this->sendStatus($id,$this->getModelNameSpace(), 'status', $tipo_table)){
            
            DB::rollBack();
            return false;
        } 

        $passa_rh = $this->getParamByOrc($orc->id, $this->getCodPassaRH());
        
        if($passa_rh){
            if(!$this->getRepoNotify()->notifySendHC($descricao, $orc->ano, $orc->descricao_orc, $orc->id)){
                DB::rollBack();
                $this->setError($this->getRepoNotify()->getErrosFlatted());
                return false;
            }             
        }
        else{
            $user = $this->getUserFromCurrentGuard();       
            $myJob = new CalculateLotacao($orc->id, $user->id, $user->id_empresa, $id, $tipo_table);
            dispatch($myJob);
            // if(!$this->calculate($id, true)){
            //     DB::rollBack();
            //     $this->setError($this->getRepoNotify()->getErrosFlatted());
            //     return false;
            // }  
        }

        DB::commit();        

        return true;   
    }  
    public function reopen($lotacao_id, $data, $tipo_table, $lotacao_desc = null, $p_periodo = null, $tipo_aprovacao){
        set_time_limit(500);
        
        $lotacao_desc = $lotacao_desc == null ? "" : " para a lotacao $lotacao_desc";
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]);
            },
        ])->where('id',$lotacao_id)->first();
        
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        
        $observacao= (!empty($data['justificativa'])) ? $data['justificativa'] : 'Não informada';

        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        if($tipo_table == 'F') {
            if($lot->status == $this->getStatusLotPendenteDigitacaoFCST() || $lot->status == $this->getStatusLotReabertoFCST()){
                return array('status'=>'error','msg'=>"Operação indisponível".$lotacao_desc.". Lotação ainda não foi enviada.<br/> Erro: 040220211627.");
            }
            if($lot->status == $this->getStatusLotAprovadoFCST()){
                return array('status'=>'error','msg'=>"Operação indisponível".$lotacao_desc.". Lotação já foi aprovada.<br/> Erro: 040220211626.");
            }
        } else {
            if($lot->status == $this->getStatusLotPendenteDigitacao() || $lot->status == $this->getStatusLotReaberto()){
                return array('status'=>'error','msg'=>"Operação indisponível".$lotacao_desc.". Lotação ainda não foi enviada.<br/> Erro: 040220211628.");
            }
            if($lot->status == $this->getStatusLotAprovado()){
                return array('status'=>'error','msg'=>"Operação indisponível".$lotacao_desc.". Lotação já foi aprovada.<br/> Erro: 040220211629.");
            }
            
        }      

        $retorno = $this->reopenedStatus($lotacao_id, $this->getModelNameSpace(),$observacao, 'status', $tipo_table); 
       
        if(!$this->getRepoNotify()->notifyReopen($lot->lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id,$observacao, $descricao)){
            return $this->getRepoNotify()->getErrosFlatted();
        }  
        
        if($tipo_table == 'F'){
            $select = DB::select("SELECT status_atual as status_anterior from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and tipo_table = ?
            and periodo = ?", [$lotacao_id, $tipo_table, $p_periodo]);
            if(count($select) != 0 ){
                try{
                    $update = DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = ?, status_atual = ? where orc_lotacao_id = ? and tipo_table = ?
                    and periodo = ?", [$select[0]->status_anterior, $this->getStatusLotReabertoFCST(), $lotacao_id, $tipo_table, $p_periodo]);
                }
                catch(\Exception $e){
                    return array('status'=>'error', 'msg'=>$e, 'submsg'=>'Erro');
                }
            }
        }
        // if (!empty($data['reopen']) && $data['reopen'] == 1) {
        $data_funcionario = $this->getDataFuncionario();
        $situacao = $tipo_table == "F" ? 6 : 3;
        $descricao = $tipo_table == "F" ? "forecast" : "headcount";
        $tipo_aprovacao = $tipo_aprovacao;
        $data_manager_alter = null;
        $historico = "Rejeitado por: " . $data_funcionario->getFuncionario->nome_funcionario;
        $periodo = $p_periodo == null ? date('Y-m-d') : $p_periodo;
        $this->insertNotification($lotacao_id, $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_funcionario->funcionario_id, $data_manager_alter, $historico, $periodo, $observacao);
        // }
       
        return $retorno; 
    }   

    public function calculate($lotacao_id, $has_transaction_open = false, $array_hashs=[], $tipo_table = null, $lotacao_desc = null, $periodo = null){
        $this->clearError();
        $lotacao_desc = $lotacao_desc == null ? "" : " para a lotação $lotacao_desc";
        // dd($periodo);
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]); 
            },
        ])->where('id',$lotacao_id)->first();
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        
        if ($tipo_table == 'F'){
            
            if($lot->status == $this->getStatusLotPendenteDigitacaoFCST() || $lot->status == $this->getStatusLotReabertoFCST() || $lot->status == $this->getStatusLotAprovadoFCST()){
                $this->setError('Operação indisponível'.$lotacao_desc.'. Tente novamente mais tarde. Erro: 201020201702.');
                return false;
            };
        }
        else{
            if($lot->status == $this->getStatusLotPendenteDigitacao() || $lot->status == $this->getStatusLotReaberto() || $lot->status == $this->getStatusLotAprovado()){
                $this->setError('Operação indisponível'.$lotacao_desc.'. Tente novamente mais tarde. Erro: 250620201131.');
                return false;
            };
        }
               
        if(!$has_transaction_open) { DB::beginTransaction(); }
        if(!$this->execCalculate($lotacao_id, $orc->id, $lot->cc_custo_id, $lot->status, $array_hashs, $tipo_table, $periodo)){
            if(!$has_transaction_open) { DB::rollBack(); }
            $this->insertMovtoStatus($lotacao_id, $lot->status, $lot->status, $this->getLastError());

            if($tipo_table != null && $tipo_table == 'F') $this->atualizaMovtoToStatus($lotacao_id, $periodo, $lot->status);

            $this->setLastError(null);
            $this->setHasErroCalc($lotacao_id, 1);
            return false;
        } 

        if(!$this->calculatedStatus($lotacao_id,$this->getModelNameSpace(), 'status', $tipo_table, $periodo)){
            if(!$has_transaction_open) { DB::rollBack(); }
            return false;
        } 
       
        if(!$this->getRepoNotify()->notifyCalculate($lot->lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $descricao)){
            if(!$has_transaction_open) { DB::rollBack(); }
            $this->setError($this->getRepoNotify()->getErrosFlatted());
            return false;
        }      

        $this->setHasErroCalc($lotacao_id, 0);
     
        
        if(!$has_transaction_open) { DB::commit(); }

        return true;
    }   
    
    public function confer($lotacao_id, $observacao='', $tipo_table = false, $desc_lot = '', $periodo = null){
        set_time_limit(700);
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]);
            },
            'getLotacao'=>function($query){

            }
        ])->where('id',$lotacao_id)->first();
        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;

        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;

        
        if($lot->status != $this->getStatusLotEnviado() && $lot->status != $this->getStatusLotEnviadoFCST()){
            return array("status"=>"error","msg"=>"Operação indisponível <b>$descricao</b>. Tente novamente mais tarde.<br/> Erro: 240620201805.");
        };

        $retorno = $this->conferedStatus($lotacao_id, $this->getModelNameSpace(), $observacao, 'status', $tipo_table); 
        if($tipo_table != false && $tipo_table == 'F') $this->atualizaMovtoToStatus($lotacao_id, $periodo, $this->getStatusLotConferidoFCST());

        if(!$this->getRepoNotify()->notifyConfer($lot->lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $descricao, $observacao)){
            return $this->getRepoNotify()->getErrosFlatted();
        }  
        
        if($tipo_table != 'F'){
            $repo_orcamento = new RepoOrcamento();

            $res = $repo_orcamento->inConferenceStatus($orc->id, null);

            if($res['status'] == 'error'){
                return $res;
            }
        }
       
       return $retorno;   
    }


    public function release($data, $observacao='Não informada', $tipo_table = false){
        $repo_func = new RepoFuncionario(); 
        $tela = "valores";
        $descricao = 'valores_orcamento';
        $tipo_table = $tipo_table == 'F' ? 'F' : 'O';
        ($tipo_table == 'F') ? $tipo_aprovacao = 4 : $tipo_aprovacao = 2;
        
        $data_lotacao = $this->getDataLotacao($data['orc_lot_id']);
       
        $data_user = $this->getDataFuncionario();

        $lot = $this->getDataOrcamentoHierarquia($data['orc_lot_id']);
        
        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        ($tipo_table == 'F') ? $periodo = $data['periodo'] : $periodo = date('Y-m-d');

        if ($tipo_table == 'F') {
            if($lot->status != $this->getStatusLotCalculadoFCST()){
                return array("status"=>"error","msg"=>'Operação indisponível. Tente novamente mais tarde.<br/>Erro: 211020201937.');
            }    
        } else {
            if($lot->status != $this->getStatusLotCalculado()){
                return array("status"=>"error","msg"=>'Operação indisponível. Tente novamente mais tarde.<br/> Erro: 140520201920.');
            }
        }        
        
        $retorno = $this->releasedStatus($data['orc_lot_id'],$this->getModelNameSpace(),$observacao, 'status', $tipo_table);
        if($tipo_table == 'F'){
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where orc_lotacao_id = ? and tipo_table = 'F' and periodo = '{$periodo}'", [$this->getStatusLotCalculadoLiberadoFCST(), $data['orc_lot_id']]);
        }
        

        $lot_status = $this->getDataOrcamentoHierarquia($data['orc_lot_id']);
        
        if(!$this->getRepoNotify()->notifyRelease($lot->lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $observacao)){
            return $this->getRepoNotify()->getErrosFlatted();
        } 
        
        $nivel_hierarquico = $this->getParamByOrc($orc->id, $this->getCodHierarquia()) + 1;

        if ($lot_status->status == $this->getStatusLotCalculadoLiberado() || $lot_status->status == $this->getStatusLotCalculadoLiberadoFCST() ) {   
            
            $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $nivel_hierarquico, $orc->id, $tipo_table, $periodo); 

            if(empty($data_manager) && $data_user->tipo == 3 ) {
                ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
                $historico = "aprovado automatico por: " . $data_user->getFuncionario->nome_funcionario;
                $data_manager_id = $data_user->funcionario_id;
                $data_manager_alter = null;
                
                $ret = $this->insertNotification($data['orc_lot_id'], $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

                
                $retorno = $this->approvedManagerStatus($data['orc_lot_id'],$this->getModelNameSpace(),$observacao, 'status', $tipo_table); 

                if(!$this->getRepoNotify()->notifyApproveManager($data['orc_lot_id'], $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $observacao)){
                    return $this->getRepoNotify()->getErrosFlatted();
                }  
       
                return $retorno;    
            }           
        }

        $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $nivel_hierarquico, $orc->id, $periodo, $tipo_table);               

        // inserir linha do prox aprovador
        ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1;  
        $data_manager_alter = null;
        $data_manager_id = $data_manager[0]->id;
        $historico = "liberado por: " . $data_user->nome;

        $data = $this->insertNotification($data['orc_lot_id'], $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
        $tipo = "valores orcamento";

        $ret_noti_apv_Man = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela); 

              
        /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
        // $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc->id);  
        // se tiver usuario alternativo , inserir uma linha de user alternativo
        if(!empty($user_aprov_alternativo_id)){
            
            foreach($user_aprov_alternativo_id as $key => $id){
                
                $resp = $repo_func->getFuncsManagerAlternativo($id->gestor_final_id);
                
                if ($resp) {
                    $data_manager_alter = $id->gestor_final_id;
                    $ret = $this->insertNotification($lot->lotacao_id, $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

                    $ret_noti_apv_Man_alter = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager_alter, $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);
                    
                    $data[$key] = $ret;
                }               
            }
            return $retorno; 
        }*/
        
        return $retorno;   
    }  

    public function approveManager($data,$observacao = 'Não informada', $tipo_table = false){
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]);
            },
        ])->where('id',$data['orc_lot_id'])->first();
        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        
        if($lot->status != $this->getStatusLotCalculadoLiberado() && $lot->status != $this->getStatusLotCalculadoLiberadoFCST()){
                return array("status"=>"error","msg"=>'Operação indisponível. Tente novamente mais tarde.<br/> Erro: 150520200956.');
        };

        $data_envio = [
            'lotacao_id' => $data['orc_lot_id'],
            'observacao' => $observacao,
            'hierarquia' => $hierarquia,
            'ano' => $orc->ano,
            'descricao_orc' => $orc->descricao_orc,
            'tipo_table' => $tipo_table,
            'data' => $data
        ];
        
        $retorno = $this->prepareApproveValue($orc->id, $data_envio);
       
        // $retorno = $this->approvedManagerStatus($lotacao_id,$this->getModelNameSpace(),$observacao); 
        // if(!$this->getRepoNotify()->notifyApproveManager($lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $observacao)){
        //     return $this->getRepoNotify()->getErrosFlatted();
        // }         
        return $retorno;   
    }  
    public function approveDirector($lotacao_id,$observacao){
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]);
            },
        ])->where('id',$lotacao_id)->first();
        $orc = $lot->getOrcamento;
        $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        if($lot->status != $this->getStatusLotAprovado()){
                return array("status"=>"error","msg"=>'Operação indisponível. Tente novamente mais tarde.<br/> Erro: 150520201030.');
        };

        $retorno = $this->approvedDirectorStatus($lotacao_id,$this->getModelNameSpace(),$observacao); 
        if(!$this->getRepoNotify()->notifyApproveDirector($lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id,$observacao)){
            return $this->getRepoNotify()->getErrosFlatted();
        }         
        return $retorno;   
    }

    public function sendStatus($id,$model_name_space,$field_name='status', $tipo_table = false){
        
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)){
            $this->setError('Falha ao atualizar registro. Erro: 080120201022.');
            return false;
        } 

        if ($tipo_table == 'F') {
            if(!$this->insertMovtoStatus($id, $data->$field_name, $this->getStatusLotEnviadoFCST())){
                $this->setError('Falha ao atualizar registro. Erro: 080120201022.');
                return false;
            }
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where orc_lotacao_id = ? and tipo_table = 'F' and periodo in(
                select max(periodo) from tbl_orc_lot_carg_headcount where lotacao_id = ? and tipo_table = 'F')
            ", [$this->getStatusLotEnviadoFCST(), $id, $id]);
            $data->$field_name = $this->getStatusLotEnviadoFCST();
        } else {
            if(!$this->insertMovtoStatus($id, $data->$field_name, $this->getStatusLotEnviado())){
                $this->setError('Falha ao atualizar registro. Erro: 080120201022.');
                return false;
            }
            $data->$field_name = $this->getStatusLotEnviado();
        }
        
        $data->save();
        return true;
    }
    public function reopenedStatus($id,$model_name_space,$observacao='Não informado',$field_name='status', $tipo_table=false){
        
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201040'); /**Lotação não encontrada */
        
        if ($tipo_table == 'F') {
            
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotReabertoFCST(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 290620201653.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotReabertoFCST();

        } else {
           
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotReaberto(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 290620201653.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }

            $data->$field_name = $this->getStatusLotReaberto();
        }
        
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function calculatedStatus($id,$model_name_space,$field_name='status', $tipo_table = false, $periodo = null){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)){
            $this->setError('Falha ao atualizar registro. Erro: 250620201134');
            return false; /**Lotação não encontrada */
        }
        
        if ($tipo_table == 'F') {
            $this->atualizaMovtoToStatus($id, $periodo, $this->getStatusLotCalculadoFCST());
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotCalculadoFCST())){
                return false; /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotCalculadoFCST();
        } else {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotCalculado())){
                return false; /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotCalculado();
        }
        
        $data->save();
        return true;
    }

    public function conferedStatus($id,$model_name_space,$observacao='Não informado',$field_name='status', $tipo_table = false){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 240620201807'); /**Lotação não encontrada */
        if ($tipo_table == 'F') {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotConferidoFCST(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 240620201808.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotConferidoFCST();
        } else {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotConferido(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 240620201808.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotConferido();
        }
        
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    public function releasedStatus($id,$model_name_space,$observacao='Não informado',$field_name='status', $tipo_table = false){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201040'); /**Lotação não encontrada */
        if ($tipo_table == 'F') {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotCalculadoLiberadoFCST(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201134.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotCalculadoLiberadoFCST();
        } else {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotCalculadoLiberado(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201134.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotCalculadoLiberado();
        }

        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    public function approvedManagerStatus($id,$model_name_space,$observacao='Não informado',$field_name='status', $tipo_table = false){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) {
            return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201028'); /**Lotação não encontrada */
        }
        if ($tipo_table == 'F') {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotAprovadoFCST(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201134.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            DB::update("UPDATE tbl_orc_movto_status_ccusto set status_anterior = status_atual, status_atual = ? where orc_lotacao_id = ? and tipo_table = 'F' and periodo in(
                select max(periodo) from tbl_orc_lot_carg_headcount where lotacao_id = ? and tipo_table = 'F')
            ", [$this->getStatusLotAprovadoFCST(), $id, $id]);
            $data->$field_name = $this->getStatusLotAprovadoFCST();
        } else {
            if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotAprovado(),$observacao)){
                return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201134.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
            }
            $data->$field_name = $this->getStatusLotAprovado();
        }
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    public function approvedDirectorStatus($id,$model_name_space,$observacao='Não informado',$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201031'); /**Lotação não encontrada */
        if(!$this->insertMovtoStatus($id,  $data->$field_name, $this->getStatusLotAprovado(),$observacao)){
            return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 150520201134.', 'submsg'=>$this->getErrosFlatted()); /**Falha ao inserir movimentação*/
        }
        $data->$field_name = $this->getStatusLotAprovado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function insertMovtoStatus($lot_id, $old_status, $new_status, $observacao = 'Não informada'){
        $data = [
            'orc_lotacao_id' => $lot_id,
            'user_id' => $this->getUserId(), //OBS pegar status do usuário logado
            'status_anterior' => $old_status,
            'status_atual' => $new_status,
            'observacao' => $observacao,
            'data_hora' => Carbon::now()->format('ymd H:i:s')
        ];

        if(!$this->getRepoMovtoStatusLot()->create($data)){
            $this->setError($this->getRepoMovtoStatusLot()->getErrosFlatted());
            $this->setError("Falha ao inserir movimentação. Erro 150520201132");
            return false;
        }

        return true;
    } 

   
    public function setStatus($id){
        
        $retorno['msg']='Envio Realizado com Sucesso';
        $retorno['status']='success';
            
            $lot = $this->getModelEntity()->find($id);

            if(!$lot){
                $retorno['msg']='Lotação escolhida inexistente!';
                $retorno['status']='warning';
                goto saida;
            }
        $lot->status = 3;
        if(!$lot->save()){
                $retorno['msg']='Erro ao Enviar o Headcount';
                $retorno['status']='error';
        }
            
        saida:
        return $retorno;
    }

    public function execCalculate($orc_lotacao_id, $orc_id, $cc_custo_id, $status_lot, $array_hashs, $tipo_table = null, $periodo = NULL){
        set_time_limit (100);
        $repoOrcParamNatureza = new RepoOrcParamNatureza();
        $tipo_table = $tipo_table == null ? 'O' : $tipo_table;
        
        if(count($array_hashs) > 0){
            $eventos = $repoOrcParamNatureza->getModelEntity()->where('orcamento_id', $orc_id)
            ->whereIn('hash_id', array_column($array_hashs,'hash_id'))
            ->orderBy('ordem_execucao')->get()->toArray();
            // dd("eventos",$eventos);

        }
        else{
            $eventos = $repoOrcParamNatureza->getModelEntity()->where('orcamento_id', $orc_id)
            ->orderBy('ordem_execucao')->get()->toArray();
        }
        
        $eventos_unicos = $this->getEventosUnicos($eventos);//Removendo elementos com a mesma hash_id;
        $user = $this->getUserFromCurrentGuard();
        $empresa_id = $user->id_empresa;
        $user_id = $user->id;
        
        $eventos_unicos = $this->addEventDespesasAdicionais($eventos_unicos);

        for ($i=0; $i < count($eventos_unicos); $i++) {
            $sql= "SET NOCOUNT ON; EXEC ".$eventos_unicos[$i]['handle_sql']." :p_empresa_id, :p_orcamento_id, :p_orc_lotacao_id, :p_ccusto_id, :p_user_id, :p_hash, :p_tipo_table, :p_periodo";
            // dd('sdfgnm,',$eventos_unicos[$i]);
            
            /* $tipo_table='O';
            $periodo = NULL;*/
            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':p_empresa_id', $empresa_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_orc_lotacao_id', $orc_lotacao_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_ccusto_id', $cc_custo_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_user_id', $user_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_hash', $eventos_unicos[$i]['hash_id'], \PDO::PARAM_STR  );
            $stmt->bindParam(':p_tipo_table', $tipo_table, \PDO::PARAM_STR  );
            // $stmt->bindParam(':p_tipo_table', 'O', \PDO::PARAM_STR  );
            if($tipo_table == 'F'){
                $stmt->bindParam(':p_periodo', $periodo, \PDO::PARAM_STR  );
            }     
            else{                
                $stmt->bindParam(':p_periodo', $periodo, \PDO::PARAM_NULL  );
            }

            $stmt->execute();
            // dd('sdfgnm,',$eventos_unicos[$i]);
            
            $res = $stmt->fetchAll(\PDO::FETCH_COLUMN, 0);
            if($res[0] != 0){
                $this->setError("Erro ao calcular ". $eventos_unicos[$i]['hash_id'] . ". Erro " . $res[0]);
                $this->setLastError("Erro ao calcular ". $eventos_unicos[$i]['hash_id'] . ". Erro " . $res[0]);
                return false;
            }
        }


        return true;
    }

    public function addEventDespesasAdicionais($eventos){
        $event_despesas_adicionais = [
            'hash_id' => 'DESPESAS_ADICIONAIS',
            'handle_sql' => 'sp_hnd_despesas_adicionais'
        ];

        array_push($eventos, $event_despesas_adicionais);


        return $eventos;
    }

    public function getEventosUnicos($eventos){
        $hashs = array_column($eventos,'hash_id');
        $hashs_unicas = array_unique($hashs);
        $array_unico = [];
        foreach ($hashs_unicas as $hash) {
            foreach ($eventos as $evento) {
                if($evento['hash_id'] == $hash){
                    array_push($array_unico, $evento);
                    break;
                }
            }
        }
        return $array_unico;
    }

    
    public function setHasErroCalc($id,$val, $field_name='has_error_calc'){
        $model = $this->getModelEntity();
        $data = $model->find($id);
        if(empty($data)) {
            $this->setError('Falha ao atualizar registro. Erro: 250620202008');
            return false; /**Lotação não encontrada */
        }
        $data->$field_name = $val;
        $data->save();
        return true;
    }

    public function sendNotifyApproveManager($tipo, $observacao, $data_manager, $ano, $descricao, $orc_id= null, $descricao_lotacao, $tela ){
        //$hierarquia = [3,4,5]; //OBS: Hierarquia para notificar apenas os gerentes.
        // $funcs = (!$lot_id) ? $this->getRepoFunc()->getFuncsByNivelHierarquico($hierarquia) : $this->getRepoFunc()->getFuncsByNivelHierarquicoLotac($hierarquia, $lot_id);
        $msg = 'Envio aprovação de ' . $tipo . ' .';
        if( $this->getParamValue($this->getCodEnviaEmail()) ){
            $data_email = [
                'subject'=>'Aprovação de ' . $tipo . ' .',
                'view'=>'emails.approveBudgetManager',
                'lotacao'=>$descricao_lotacao,
                'ano'=>$ano,
                'nome_orcamento'=>$descricao,
                'observacao'=>$observacao,
                'nome'=>$data_manager->nome_funcionario,
                'tela' => $tela
            ];
            // return true;
                
            $myJob = new SendEmail($data_manager->email, $data_email);
            dispatch($myJob);
        }
        
        if(!$this->insertNotify($data_manager->id, $msg, $orc_id, 'sendNotifyApproveManager', $this->getTipoMessage('sendNotifyApproveManager'), $observacao)){
            $this->setError($this->getRepoNotification()->getErrosFlatted());
            $this->setError('Ocorreu uma falha ao notificar o usuário. Erro 180920200948');
            return false;
        }
       
        return true;
    }

    public function getDataLotacao($lotacao_id){
        $lot = $this->getModelEntity()->with([
            'getLotacao'=>function($query){            
                return $query;
            }
        ])->where('id',$lotacao_id)
        ->first(); 

        $lotacao = $lot->getLotacao;
       
       return $lotacao;   
    }   

    public function sendRhForecast($id, $periodo, $orc_id){

        $lotacoes = $this->getDadosLotacaoByOrcLot($orc_id, $id);

        /*$lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){

            },
            'getLotacao'=>function($query){

            }
        ])->where('id',$id)->first();*/

        // TROCAR PELO LISTAR USADO NO CAMPO DE SELEÇÃO DO FORECAST - ok
        
        $descricao = $lotacoes->unid_lotac. ' - '. $lotacoes->des_unid_lotac;
        
        try{        
            if($lotacoes->status_atual != self::STATUS_LOT_PENDENTE_DIGITACAO_FCST && $lotacoes->status_atual != self::STATUS_LOT_REABERTO_FCST){
                $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 230920201452.');
                return false;
            };
            
            if( !$this->atualizaStatus($id, $periodo) ){
                return false;
            }

            $passa_rh = $this->getParamByOrc($lotacoes->orcamento_id, $this->getCodPassaRHForecast());
            if($passa_rh){
                if(!$this->getRepoNotify()->notifySendForecast($descricao, $lotacoes->ano, $lotacoes->descricao_orc, $lotacoes->orcamento_id)){
                    DB::rollBack();
                    $this->setError($this->getRepoNotify()->getErrosFlatted());
                    return false;
                }  
            }
            else{
                // CALCULO
            }
            return true;
        }
        catch(\Exception $e){
            $this->setError("Falha ao Enviar o Forecast. Erro: 240920200927ct ". $e);
            return false;
        }
    }
    public function atualizaStatus($lotacao_id, $periodo){
        if(strpos($periodo, '/') !== false){
            $periodo = Carbon::createFromFormat('d/m/Y', $periodo)->format('Y-m-d');
        }
        $select = DB::select('select * from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and periodo = ? and tipo_table = ?', [$lotacao_id, $periodo, 'F']);
        
        if(count($select) > 0){
            try{
                DB::update('update tbl_orc_movto_status_ccusto set status_anterior = ?, status_atual = ? where id = ?',
                [$select[0]->status_atual, self::STATUS_LOT_ENVIADO_FCST, $select[0]->id]);

                DB::update("update tbl_orc_lotacao set status = ? where id = ?", [self::STATUS_LOT_ENVIADO_FCST, $lotacao_id]);
                DB::commit();
                return true;
            }
            catch(\Exception $e){
                DB::rollBack();
                
                return false;
            }
            return true;
        }
        else{
            $this->setError('Não foi possível encontrar forecast para essa lotação no período selecionado. Erro 061220201345');
            return false;
        }
    }

    public function atualizaMovtoToStatus($lotacao_id, $periodo, $status){
        if(strpos($periodo, '/') !== false){
            $periodo = Carbon::createFromFormat('d/m/Y', $periodo)->format('Y-m-d');
        }
        $select = DB::select('select * from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and periodo = ? and tipo_table = ?', [$lotacao_id, $periodo, 'F']);
        
        if(count($select) > 0){
            try{
                DB::update('update tbl_orc_movto_status_ccusto set status_anterior = ?, status_atual = ? where id = ?',
                [$select[0]->status_atual, $status, $select[0]->id]);

                DB::update("update tbl_orc_lotacao set status = ? where id = ?", [$status, $lotacao_id]);
                DB::commit();
                //return true;
            }
            catch(\Exception $e){
                DB::rollBack();
                
                return false;
            }
            return true;
        }
        else{
            $this->setError('Não foi possível encontrar forecast para essa lotação no período selecionado. Erro 061220201345');
            return false;
        }
    }
    public function getDadosLotacaoByOrcLot($orc_id, $lotacao_id){
        $select = DB::select("
            select 
            lot.ativo,
            olot.cc_custo_id,
            olot.cc_custo_id_origem,
            cc.cod_ccusto,
            olot.created_at,
            olot.created_by,
            cc.des_ccusto,
            lot.des_unid_lotac,
            concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'description',
            olot.empresa_id,
            olot.has_error_calc,
            olot.has_transf,
            olot.hc_iniciado,
            olot.id,
            olot.lotacao_id,
            olot.lotacao_id_origem,
            olot.orcamento_id,
            lot.quadro_atual,
            olot.responder_orc,
            sc.status_atual,
            sc.status_anterior,
            status_label = 
            CASE sc.status_atual
                WHEN 1 THEN 'Pendente'
                WHEN 2 THEN 'Em Andamento'
                WHEN 3 THEN 'Enviado'
                WHEN 4 THEN 'Reaberto'

                WHEN 5 THEN 'Conferido'
                WHEN 6 THEN 'Liberado'
                WHEN 7 THEN 'Finalizado'
                WHEN 8 THEN 'Aprovado'

                WHEN 9 THEN 'Em Execução'
                WHEN 10 THEN 'Enviado Sistema'
                ELSE cast(sc.status_atual as varchar) END,
            lot.unid_lotac,
            olot.updated_at,
            olot.updated_by,
            olot.user_id,
            sc.periodo,
            orc.descricao_orc,
            orc.ano
                
            from tbl_orc_movto_status_ccusto as sc
            
            inner join tbl_orc_lotacao as olot on olot.id = sc.orc_lotacao_id and olot.orcamento_id = $orc_id
            inner join tbl_orcamento as orc on orc.id = olot.orcamento_id
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            
            where periodo = (
                select max(st.periodo) from tbl_orc_movto_status_ccusto as st
                inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = $orc_id
                where  periodo is not null and tipo_table = 'F'
            ) and tipo_table = 'F' and olot.id = $lotacao_id order by lot.unid_lotac, cc.cod_ccusto asc
        ");

        return count($select) > 0 ? $select[0] : false;
    }

    /**
     * Encontrar gestor para envio aprovação alternativo
     */
    public function searchGestorAprovAlternativo($func_id, $orc_id, $periodo = null, $tipo_table = 'O'){
        $where = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and tipo_table = '{$tipo_table}' ";
        $select = DB::select("
            select gestor_final_id from tbl_orc_gestor_alternativo where gestor_inicial_id = $func_id and orcamento_id = $orc_id {$where}
        ");

        return $select;
    } 

    public function prepareApproveHeadcount($orc_id, $data, $tipo_table = false) {
        
        $data_funcionario = $this->getDataFuncionario();
        ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1;
        $data_notificacoes = $this->getLastDataNotification($data['data']['lotacao_id'], $orc_id, $situacao);  
        (empty($data_notificacoes[0]->user_pendencia_id)) ? $user_pendencia_id = 0 : $user_pendencia_id = $data_notificacoes[0]->user_pendencia_id;  
        (empty($data_notificacoes[0]->user_aprovador_id)) ? $user_aprovador_id = 0 : $user_aprovador_id = $data_notificacoes[0]->user_aprovador_id;     
        
        if($user_aprovador_id == $data_funcionario->funcionario_id || $data_funcionario->tipo == 3 || $user_pendencia_id == $data_funcionario->funcionario_id){
            
            $resp = $this->approveHeadcount($orc_id, $data, $data_funcionario, $data_notificacoes, $tipo_table);

            $retorno['msg']='Headcount aprovado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

            return $retorno;
        }
       
        return array("status"=>"error","msg"=>'Esta aprovação não está disponível para seu usuário. <br/> Erro: 011020201735.');  
    }

    public function prepareApproveValue($orc_id, $data) {
        $data_funcionario = $this->getDataFuncionario();
        ($data['tipo_table'] == 'F') ? $situacao = 4 : $situacao = 1;
        $data_notificacoes = $this->getLastDataNotification($data['lotacao_id'], $orc_id, $situacao);       
        
        (empty($data_notificacoes[0]->user_pendencia_id)) ? $user_pendencia_id = 0 : $user_pendencia_id = $data_notificacoes[0]->user_pendencia_id;  
        (empty($data_notificacoes[0]->user_aprovador_id)) ? $user_aprovador_id = 0 : $user_aprovador_id = $data_notificacoes[0]->user_aprovador_id;     
        
        if($user_aprovador_id == $data_funcionario->funcionario_id || $data_funcionario->tipo == 3 || $user_pendencia_id == $data_funcionario->funcionario_id){
           
            $retorno = $this->approveValores($orc_id, $data, $data_funcionario, $data_notificacoes);
            
            // $retorno['msg']='Valores aprovado com sucesso!';
            // $retorno['submsg']='Sucesso';
            // $retorno['status']='success';

            return $retorno;
        }
       
        return array("status"=>"error","msg"=>'Esta aprovação não está disponível para seu usuário. <br/> Erro: 170320211025.');  
    }

    public function approveHeadcount($orc_id, $data, $data_funcionario, $data_notificacoes, $tipo_table = false) {
        // dd("testando", $data['data']['lotacao_id']);
        $lot = $this->getDataLotacaoOrcamento($data['data']['lotacao_id']);
        $orc = $lot->getOrcamento;
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        $hierarquia_max = [1,2,3];

        if ($tipo_table == 'F') {
            $descricao = "forecast";
            $tela = "forecast";
            $tipo_aprovacao = 3;
            $situacao = 5;
            $periodo = $data['data']['periodo'];
        } else {
            $descricao = "headcount";
            $tela = "headcount";
            $tipo_aprovacao = 1;
            $situacao = 2;
            $periodo = date('Y-m-d');
        }
        
        $observacao = $data['justificativa'];    
        $user_pendencia_id = (empty($data_notificacoes[0]->user_pendencia_id)) ? 0 : $data_notificacoes[0]->user_pendencia_id;  
        $user_aprovador_id = (empty($data_notificacoes[0]->user_aprovador_id)) ? 0 : $data_notificacoes[0]->user_aprovador_id;
        
        // if($data_funcionario->tipo == 3 || $user_pendencia_id == $data_funcionario->funcionario_id){
            
            $usuario = new Usuario();
            $repo_func = new RepoFuncionario();            

            $data_lotacao = $this->getDataLotacao( $data['data']['lotacao_id']);
            
            $data_user = $usuario->with([
            'getFuncionario'=>function($query){
    
            }])->where('funcionario_id', $user_aprovador_id)->first();
            
            (is_null($data_user)) ? $nivel_hier = 0 : $nivel_hier = $data_user->getFuncionario->nivel_hier;
            
            $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $nivel_hier, $orc->id, $periodo, $tipo_table); 
            
            if (empty($data_manager) || in_array($data_funcionario->getFuncionario->nivel_hier, $hierarquia_max)) {
               
                $data_manager_id = $data_funcionario->funcionario_id;
                $data_manager_alter = NULL;    
                
                $historico = "aprovado automatico por: " . $data_funcionario->getFuncionario->nome_funcionario;
                
                $ret = $this->insertNotification($data['data']['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
                
                $this->sendRh($data['data']['lotacao_id'], $tipo_table);
                return $ret;
            }
            
            // inserir usuario aprovador
            $data_manager_id = $data_funcionario->funcionario_id;
            
            $data_manager_alter = NULL;
            $historico = "aprovado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            $ret = $this->insertNotification($data['data']['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
            
            
            // -> $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id, $data['data']['periodo'], $tipo_table);      
            // $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id);      
            
            ($tipo_table == 'F') ? $situacao = 4 : $situacao = 1;
            $data_manager_id = $data_manager[0]->id;
            $historico = "liberado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
            // se tiver usuario alternativo , inserir uma linha de user alternativo
            /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
            if(!empty($user_aprov_alternativo_id)){
                
                foreach($user_aprov_alternativo_id as $key => $id){
                    
                    $resp = $repo_func->getFuncsManagerAlternativo($id->gestor_final_id);
                    
                    if ($resp) {
                        $data_manager_alter = $id->gestor_final_id;
                        $ret = $this->insertNotification($data['data']['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

                        $ret_noti_apv_Man_alter = $this->sendNotifyApproveManager($descricao, $observacao, $data_manager_alter, $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);
                        // $tipo
                        $data[$key] = $ret;
                    }               
                }
                return $data;
            }*/
            
            // inserir linha do prox aprovador
            $data_manager_alter = null;
            $lotacao_id = $data['data']['lotacao_id'];
            $data = $this->insertNotification($data['data']['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
            ($tipo_table == 'F') ? $tipo = "forecast" : $tipo = "headcount";

            $ret_noti_apv_Man = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac,$tela);      
            
            // $this->sendManager($lotacao_id, $situacao = 2, $metodo = "approveHeadcount");

            $retorno['msg']='Aprovado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

            return $retorno;           
        // }
        
        // $this->sendManager($data['data'], $situacao = 2, $metodo = "approveHeadcount");

        // $retorno['msg']='Aprovado com sucesso!';
        // $retorno['submsg']='Sucesso';
        // $retorno['status']='success';

        // return $retorno;

    }

    public function approveValores($orc_id, $data, $data_funcionario, $data_notificacoes) {
        
        $lot = $this->getDataLotacaoOrcamento($data['lotacao_id']);
        $orc = $lot->getOrcamento;
        $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
        $hierarquia_max = [1,2,3];
        ($data['tipo_table'] == 'F') ? $periodo = $data['data']['periodo'] : $periodo = date('Y-m-d');
        
        if ($data['tipo_table'] == 'F') {
            $tipo_aprovacao = 4;
            $situacao = 5;
            $descricao = "valores forecast";
            $tela = "valores forecast";
        } else {
            $tipo_aprovacao = 2;
            $situacao = 2;
            $descricao = "valores orcamento";
            $tela = "valores orcamento";
        }
        
        $observacao = $data['observacao'];        
        
        if($data_funcionario->tipo == 3 || (!empty($data_notificacoes[0]->user_pendencia_id) == $data_funcionario->funcionario_id) || 
		(!empty($data_notificacoes[0]->user_aprovador_id) == $data_funcionario->funcionario_id)){
            // dd("dentro");
			
            $usuario = new Usuario();
            $repo_func = new RepoFuncionario();            

            $data_lotacao = $this->getDataLotacao( $data['lotacao_id']);

            $data_user = $usuario->with([
            'getFuncionario'=>function($query){
    
            }])->where('funcionario_id',$data_notificacoes[0]->user_aprovador_id)->first();
            
            $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $data_user->getFuncionario->nivel_hier, $orc->id, $periodo, $data['tipo_table']); 
           
            if (empty($data_manager) || in_array($data_funcionario->getFuncionario->nivel_hier, $hierarquia_max)) {
                $data_manager_id = $data_funcionario->funcionario_id;
                $data_manager_alter = NULL;             
                
                
                $historico = "aprovado automatico por: " . $data_funcionario->getFuncionario->nome_funcionario;
                
                $ret = $this->insertNotification($data['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

                
                $retorno = $this->approvedManagerStatus($data['lotacao_id'],$this->getModelNameSpace(),$data['observacao'], 'status', $data['tipo_table']); 

                if(!$this->getRepoNotify()->notifyApproveManager($data['lotacao_id'], $data['hierarquia'], $data['ano'], $data['descricao_orc'], $orc_id, $data['observacao'])){
                    return $this->getRepoNotify()->getErrosFlatted();
                }  
       
                return $retorno;
            }
            // dd("fora");
            // inserir usuario aprovador
            $data_manager_id = $data_funcionario->funcionario_id;
            $data_manager_alter = NULL;
            $historico = "aprovado automatico por: " . $data_funcionario->getFuncionario->nome_funcionario;
            $ret = $this->insertNotification($data['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);            
            
            // -> $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id, $periodo, $data['tipo_table']);      
            // $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id);      
        
            ($data['tipo_table'] == 'F') ? $situacao = 4 : $situacao = 1;
            $data_manager_id = $data_manager[0]->id;
            $historico = "liberado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            
            /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
            // se tiver usuario alternativo , inserir uma linha de user alternativo
            if(!empty($user_aprov_alternativo_id)){
               
                foreach($user_aprov_alternativo_id as $key => $id){
                    
                    $resp = $repo_func->getFuncsManagerAlternativo($id->gestor_final_id);
                    
                    if ($resp) {
                        $data_manager_alter = $id->gestor_final_id;
                        $ret = $this->insertNotification($data['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

                        $ret_noti_apv_Man_alter = $this->sendNotifyApproveManager($descricao, $observacao, $data_manager_alter, $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac, $tela);
                        // $tipo
                        $data[$key] = $ret;
                    }               
                }
                $retorno['msg']='Aprovado com sucesso!';
                $retorno['submsg']='Sucesso';
                $retorno['status']='success';

                return $retorno;
            }*/
            
            // inserir linha do prox aprovador
            $data_manager_alter = null;
            $data = $this->insertNotification($data['lotacao_id'], $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
            $tipo = "valores";

            $ret_noti_apv_Man = $this->sendNotifyApproveManager($tipo, $observacao, $data_manager[0], $lot->getOrcamento->ano, $lot->getOrcamento->descricao_orc, $lot->getOrcamento->id, $lot->getLotacao->des_unid_lotac,$tela);      
            
            
            if($tipo_table != 'F'){
                $status_aprovado = $this->getStatusLotAprovado();
                $faltam_aprovar = DB::SELECT("SELECT id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'O' and status < $status_aprovado");

                if(count($faltam_aprovar) == 0){
                    $repo_orcamento = new RepoOrcamento();
    
                    $res = $repo_orcamento->completedStatus($orc_id, null);
    
                    if($res['status'] == 'error'){
                        return $res;
                    }

                }
            }


            $retorno['msg']='Aprovado com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';

            return $retorno;           
        }
		// dd("foraaaa", $data['tipo_table']);
        // ($data['tipo_table'] == 'F') ? $situacao = 5 : $situacao = 2;
        $data = [
            'lotacao_id' => $data['lotacao_id'],
            'periodo' => $periodo
        ];

        $this->sendManager($data, $situacao, $metodo = "approveValores", $data['tipo_table']);

        $retorno['msg']='Aprovado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        return $data;

    }


    
    public function prepareinsertNotification($lotacao_id, $orc_id, $situacao, $descricao, $tipo_aprovacao, $tipo_table = false, $periodo = null){
        $hierarquia_max = [1,2,3];
        $repo_func = new RepoFuncionario();
        $orcamento = new Orcamento();
        
        $periodo = $periodo == null ? date('Y-m-d') : $periodo;
        
        $data_funcionario = $this->getDataFuncionario();
        if(in_array($data_funcionario->getFuncionario->nivel_hier, $hierarquia_max)) {               
            $data_manager_id = $data_funcionario->funcionario_id;
            $data_manager_alter = NULL;
            ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
            $historico = "aprovado automatico por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            $ret = $this->insertNotification($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
            return $ret;
        }
        
        $data_lotacao = $this->getDataLotacao($lotacao_id);
        $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $data_funcionario->getFuncionario->nivel_hier, $orc_id, $periodo, $tipo_table);        
       
        if(empty($data_manager)){ 
            $data_manager_id = $data_funcionario->getFuncionario->id; 
            $data_manager_alter = NULL;
            ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
            $historico = "aprovado automatico por: " . $data_funcionario->getFuncionario->nome_funcionario;
            
            $ret = $this->insertNotification($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
            return $ret;
        }
          
        // $orc = $orcamento->where('id' , $orc_id)->first();
        $data_manager_alter = NULL;
        $tipo_table = $tipo_table == 'F' ? 'F' : 'O';

        /* POR CAUSA DA MUDANÇA NA TELA DE GESTOR ALTERNATIVO, ESSE CÓDIGO NÃO SERÁ USADO - 16/02/2021 - MATHEUS
        $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id, $periodo, $tipo_table);      
        $user_aprov_alternativo_id = $this->searchGestorAprovAlternativo($data_manager[0]->id, $orc_id);      
        
        if(!empty($user_aprov_alternativo_id)){
           
            $historico = "liberado por: " . $data_funcionario->getFuncionario->nome_funcionario;
            foreach($user_aprov_alternativo_id as $key => $id){
                
                $resp = $repo_func->getFuncsManagerAlternativo($id->gestor_final_id);
                
                if ($resp) {
                    $data_manager_alter = $id->gestor_final_id;
                    
                    $ret = $this->insertNotification($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_alter, $data_manager_alter, $historico, $periodo);
                    // $data_manager_id - 6º parametro
                    $data[$key] = $ret;
                }               
            }
            return $data;
        }*/
        
        $historico = "liberado por: " . $data_funcionario->getFuncionario->nome_funcionario;
        $data_manager_id = $data_manager[0]->id;
        $data_manager_alter = null;
        
        $data = $this->insertNotification($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);

        return $data;
        
    }

    public function insertNotificacaoLiberado($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $tipo_table = false, $periodo = null){    
        $data_funcionario = $this->getDataFuncionario();  

        $data_manager_id = $data_funcionario->funcionario_id;
        $data_manager_alter = NULL;
        ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
        $historico = "Liberado para aprovação por: " . $data_funcionario->getFuncionario->nome_funcionario;
        $periodo = $periodo == null ? date("Y-m-d") : $periodo;
        
        // dd("periodo liberado", $periodo);
        $data_hora = Carbon::now()->format('ymd H:i:s');    

        $data = [
            'orc_lotacao_id'=>$lotacao_id,
            'orc_id'=>$orc_id,
            'periodo'=>$periodo,
            'descricao'=>$descricao,
            'tipo_aprovacao'=>$tipo_aprovacao,
            'situacao'=>$situacao,
            'user_aprovador_id'=> $data_manager_id,
            'user_pendencia_id'=>$data_manager_alter,
            'data_hora'=>$data_hora,
            'historico'=>$historico,
            'created_at'=>$data_hora

        ];
        
        $db = DB::table('tbl_notificacao')->insert($data);
        $data["nivel_hier"] = $data_funcionario->getFuncionario->nivel_hier;
        $data["db"] = $db;
        // dd("passou", $data);  
        return $data;
    }

    public function insertNotification($lotacao_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo, $justificativa = 'Não informada'){
        $data_funcionario = $this->getDataFuncionario();
                
        $data_hora = Carbon::now()->format('ymd H:i:s');    

        $data = [
            'orc_lotacao_id'=>$lotacao_id,
            'orc_id'=>$orc_id,
            'periodo'=>$periodo,
            'descricao'=>$descricao,
            'tipo_aprovacao'=>$tipo_aprovacao,
            'situacao'=>$situacao,
            'user_aprovador_id'=> $data_manager_id,
            'user_pendencia_id'=>$data_manager_alter,
            'data_hora'=>$data_hora,
            'historico'=>$historico,
            'created_at'=>$data_hora,
            'justificativa'=>$justificativa

        ];
      
        DB::table('tbl_notificacao')->insert($data);
        $data["nivel_hier"] = $data_funcionario->getFuncionario->nivel_hier;

        return $data;
    }

    public function getDataFuncionario() {
        $usuario = new Usuario();
  
        $user_id = $this->getUserId();
  
        $data_user = $usuario->with([
           'getFuncionario'=>function($query){
  
           }])->where('id',$user_id)->first();
     return $data_user;
    }

    public function getDataLotacaoOrcamento($orc_lotacao_id){
        $lot = $this->getModelEntity()->with([
                'getOrcamento'=>function($query){

                },
                'getLotacao'=>function($query){

                }
        ])->where('id',$orc_lotacao_id)->first();

        return $lot;
    }

    public function getLastDataNotification($orc_lotacao_id, $orc_id, $situacao) {
        $select = DB::select("SELECT  top 1 
                                 *
                            FROM [tbl_notificacao] where orc_lotacao_id = $orc_lotacao_id and orc_id = $orc_id and situacao = $situacao order by situacao, data_hora desc");

        return $select;
    }

    public function getDataOrcamentoHierarquia($lotacao_id){
        $lot = $this->getModelEntity()->with([
            'getOrcamento'=>function($query){
                return $query->with([
                    'getOrcParametros'=>function($query){
                        return $query->where('parametro_id',19)->first();//pegar hierarquia
                    },
                ]);
            },
        ])->where('id',$lotacao_id)->first();

        return $lot;
    }

    public function releaseFullLotacao($orc_id,$observacao='Não informada', $tipo_table = 'O'){
        set_time_limit(0);
        $repo_func = new RepoFuncionario(); 
        $tela = "valores";
        $descricao = ($tipo_table == 'F') ? 'valores_forecast' : 'valores_orcamento';
        $data_user = $this->getDataFuncionario();        
        $historico = "liberado para análise de cálculo por: " . $data_user->getFuncionario->nome_funcionario;
        $data_manager_id = $data_user->funcionario_id;
        $data_manager_alter = null;
        ($tipo_table == 'F') ? $tipo_aprovacao = 4 : $tipo_aprovacao = 2;
        ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
        $periodo = date('Y-m-d');

        if($data_user->tipo != 3 ) {
            $this->setError("Está ação é exclusiva de usuários técnicos!");
            return array("status"=>"error", "msg"=>'Está ação é exclusiva de usuários técnicos!', "submsg"=>"Erro");
        }

        
        if($tipo_table == "F"){
            $ultimo_periodo = DB::select("select max(mov.periodo) ultimo_periodo from tbl_orc_movto_status_ccusto mov
                                            join tbl_orc_lotacao ol on mov.orc_lotacao_id = ol.id
                                            where mov.tipo_table = 'F' AND ol.orcamento_id = $orc_id");
            if(count($ultimo_periodo)<= 0){
                return array("status"=>"error","msg"=>'Não foi possível encontrar o último período em aberto!'); 
            }
            $ultimo_periodo = $ultimo_periodo[0]->ultimo_periodo;
        }

        $where_periodo = $tipo_table == "O" ? '' : " AND head.periodo = '$ultimo_periodo' ";

        $status_pendente_digitacao = $tipo_table == "O" ? $this->getStatusLotPendenteDigitacao() : $this->getStatusLotPendenteDigitacaoFCST();
        $status_calculado = $tipo_table == "O" ? $this->getStatusLotCalculado() : $this->getStatusLotCalculadoFCST();


        $tipo_aprovacao_valores = $tipo_table == "O" ? 2 : 4;
        $tipo_aprovacao_headcount = $tipo_table == "O" ? 1 : 3;

        $situacao_pendente = $tipo_table == "O" ? 1 : 4;
        $situacao_aprovada = $tipo_table == "O" ? 2 : 5;
        $status_aprovado = $tipo_table == "O" ? $this->getStatusLotAprovado() : $this->getStatusLotAprovadoFCST();

        $select = DB::select("select orc_lot.id,
                                situacao = ISNULL((SELECT top 1 situacao
                                    FROM tbl_notificacao noti where noti.orc_lotacao_id = orc_lot.id and noti.orc_id = {$orc_id} and noti.tipo_aprovacao = $tipo_aprovacao_valores order by id desc), 1)
            from tbl_orc_lot_carg_headcount head 
                inner join tbl_orc_lotacao orc_lot on orc_lot.id = head.lotacao_id
                inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                inner join tbl_ccusto cc on cc.id = orc_lot.cc_custo_id
                inner join tbl_calc_orcamento calc_orc on calc_orc.origem_id = head.id and calc_orc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                where status >= $status_pendente_digitacao and status < $status_calculado $where_periodo and orcamento_id = {$orc_id} and lot.ativo = 1 and head.tipo_table = '{$tipo_table}'
                and (calc_orc.jan_orcado = 0 and calc_orc.fev_orcado = 0 and calc_orc.mar_orcado = 0 and calc_orc.abr_orcado = 0 and calc_orc.mai_orcado = 0 and calc_orc.jun_orcado = 0 
                and calc_orc.jul_orcado = 0 and calc_orc.ago_orcado = 0 and calc_orc.set_orcado = 0 and calc_orc.out_orcado = 0 and calc_orc.nov_orcado = 0 and calc_orc.dez_orcado = 0
                )
                group by orc_lot.id");
        
        if( count($select) > 0) {
            foreach($select as $data_id) {   
                if ($data_id->situacao != $situacao_pendente) {
                    continue;
                }             
                $update = DB::update(
                    "UPDATE tbl_orc_lotacao
                    SET status = $status_aprovado
                    WHERE id in ($data_id->id)"
                );
            }
            
            $ret = $this->insertNotification($data_id->id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);            
        }

        $select_sem_headcount = DB::select("  
            select orc_lot.id id 
            from tbl_orc_lotacao orc_lot 
            left join tbl_orc_lot_carg_headcount head on orc_lot.id = head.lotacao_id $where_periodo and head.tipo_table = '$tipo_table'
            where orc_lot.orcamento_id = $orc_id and orc_lot.status < $status_aprovado and head.id is null
        ");

        if( count($select_sem_headcount) > 0) {
            foreach($select_sem_headcount as $data_id) {          
                $update = DB::update(
                    "UPDATE tbl_orc_lotacao
                    SET status = $status_aprovado
                    WHERE id in ($data_id->id)"
                );
            }
            
            $ret = $this->insertNotification($data_id->id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);            
        }
		
		$lot_pendente = DB::select("select distinct orc_lot.id, CONCAT(lot.unid_lotac, ' - ', lot.des_unid_lotac) desc_lot
            from tbl_orc_lot_carg_headcount head 
                    inner join tbl_orc_lotacao orc_lot on orc_lot.id = head.lotacao_id
                    inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                    where status >= $status_pendente_digitacao and status < $status_calculado  and orcamento_id = {$orc_id} $where_periodo and head.tipo_table = '$tipo_table'"); 
        
        
        if(count($lot_pendente) > 0){
            
            $var = "Para liberar o orçamento, verificar as seguintes lotações que ainda estao pendentes de calculo: <br>";
            foreach($lot_pendente as $lot){
                $var = $var . $lot->desc_lot . "<br>";
            }
			return array("status"=>"warning","msg"=> $var); 
        }

        $lot_liberado = DB::select("select distinct orc_lot.id as orc_lot_id , CONCAT(lot.unid_lotac, ' - ', lot.des_unid_lotac) desc_lot,
            situacao = (SELECT top 1 situacao
          FROM tbl_notificacao noti where noti.orc_lotacao_id = orc_lot.id and noti.tipo_aprovacao = $tipo_aprovacao_headcount and noti.orc_id = {$orc_id} order by id desc)
          from tbl_orc_lotacao orc_lot
                inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                inner join tbl_ccusto cc on cc.id = orc_lot.cc_custo_id
                where status >= $status_pendente_digitacao and status <= $status_calculado  and orcamento_id = {$orc_id}") ;  
		
		if(count($lot_liberado) > 0) {
			$var = "";
            foreach($lot_liberado as $lot){
                if($lot->situacao != $situacao_aprovada && !is_null($lot->situacao)){                    
			        $var = $var == "" ? "Existem lotações com pendências de aprovação de headcount: <br>" : $var;
                    $var = $var . $lot->desc_lot . "<br>";
                }
            }
            $var = $var == "" ? "" : $var . "Para prosseguir, você pode aprovar todas através do botão 'Aprovar Headcount'";
            if($var != ""){
                return array("status"=>"warning","msg"=> $var); 
            }		 
		}
		
		$lot_liberado = DB::select("select orc_lot.id as orc_lot_id, lot.unid_lotac as unid_lotac 
          from tbl_orc_lotacao orc_lot
                inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                inner join tbl_ccusto cc on cc.id = orc_lot.cc_custo_id
                where status = $status_calculado  and orcamento_id = {$orc_id} ") ;  


		$retorno = null;
        foreach($lot_liberado as $liberado) {

                $lot = $this->getDataOrcamentoHierarquia($liberado->orc_lot_id);
                
                $orc = $lot->getOrcamento;
                $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
                // ($tipo_table == 'F') ? $periodo = $data['periodo']: $periodo = date('Y-m-d');
                $hierarquia = $hierarquia + 1; //Somando 1 porque deve gerar a pendencia para o nivel definido no parâmetro, e o método que busca os funcionarios filtra funcionarios com a hierarquia menor que a enviada por parâmetro
                
                if ($tipo_table == 'F') {
                    // $descricao = "forecast";
                    $tela = "forecast";
                    $tipo_aprovacao = $tipo_aprovacao;
                    $situacao = $situacao_pendente;
                    $periodo = $ultimo_periodo;//$data['data']['periodo'];
                } else {
                    // $descricao = "headcount";
                    $tela = "headcount";
                    $tipo_aprovacao = $tipo_aprovacao_valores;
                    $situacao = $situacao_pendente;
                    $periodo = date('Y-m-d');
                }

                $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($liberado->unid_lotac, $hierarquia, $orc->id, $periodo, $tipo_table);  

                if(!empty($data_manager)){
                    $ret = $this->insertNotification($liberado->orc_lot_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager[0]->id, $data_manager_alter, $historico, $periodo); 
                }
                
                $data_manager_alter = null;
                $historico = "liberado por: " . $data_user->nome;

                
                $nivel_hierarquico = $this->getParamByOrc($orc->id, $this->getCodHierarquia()) + 1;
                
                $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($liberado->unid_lotac, $nivel_hierarquico, $orc->id);  
                
                $retorno = $this->releasedStatus($liberado->orc_lot_id,$this->getModelNameSpace(),$observacao, 'status', $tipo_table); 

                $lot_status = $this->getDataOrcamentoHierarquia($liberado->orc_lot_id);
                
                if(!$this->getRepoNotify()->notifyRelease($lot->lotacao_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $observacao)){
                    return $this->getRepoNotify()->getErrosFlatted();
                } 
                else{   
                    if(empty($data_manager) && $data_user->tipo == 3 ) {
                        ($tipo_table == 'F') ? $situacao = 5 : $situacao = 2;
                        $historico = "aprovado automático por: " . $data_user->getFuncionario->nome_funcionario;
                        $data_manager_id = $data_user->funcionario_id;
                        $data_manager_alter = null;
                        
                        $ret = $this->insertNotification($liberado->orc_lot_id, $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
                    }
                }
                // if ($lot_status->status == $this->getStatusLotCalculadoLiberado() || $lot_status->status == $this->getStatusLotCalculadoLiberadoFCST() ) {   
                                        
                //     $ret = $this->insertNotification($liberado->orc_lot_id, $orc->id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
                    
                //     $retorno = $this->approvedManagerStatus($data['orc_lot_id'],$this->getModelNameSpace(),$observacao, 'status', $tipo_table); 

                //     if(!$this->getRepoNotify()->notifyApproveManager($data['orc_lot_id'], $hierarquia, $orc->ano, $orc->descricao_orc, $orc->id, $observacao)){
                //         return $this->getRepoNotify()->getErrosFlatted();
                //     }  
        
                //     continue;                     
                // }
            }    
            
        if(count($lot_liberado) > 0 && $tipo_table != 'F')    {
            $repo_orcamento = new RepoOrcamento();

            $res = $repo_orcamento->releasedStatus($orc->id, null);

            if($res['status'] == 'error'){
                return $res;
            }
        }
		
        return ($retorno == null) ? array("status"=>"warning","msg"=> 'Não existem lotações pendentes de liberação') : $retorno;   
    }  
    
    public function approveHeadcountFullLot($orc_id, $tipo_table = "O") {
        set_time_limit(0);

        if($tipo_table == "F"){
            $ultimo_periodo = DB::select("select max(mov.periodo) ultimo_periodo from tbl_orc_movto_status_ccusto mov
                                            join tbl_orc_lotacao ol on mov.orc_lotacao_id = ol.id
                                            where mov.tipo_table = 'F' AND ol.orcamento_id = $orc_id");
            if(count($ultimo_periodo)<= 0){
                return array("status"=>"error","msg"=>'Não foi possível encontrar o último período em aberto!'); 
            }
            $ultimo_periodo = $ultimo_periodo[0]->ultimo_periodo;
        }
        
        $where_periodo = $tipo_table == "O" ? '' : " AND head.periodo = '$ultimo_periodo' ";

        $status_enviado = $tipo_table == "O" ? $this->getStatusLotEnviado() : $this->getStatusLotEnviadoFCST();
        $status_calculado = $tipo_table == "O" ? $this->getStatusLotCalculado() : $this->getStatusLotCalculadoFCST();

        $tipo_aprovacao_headcount = $tipo_table == "O" ? 1 : 3;

        $data_funcionario = $this->getDataFuncionario();


        $select =  DB::select("
                select orc_lot.id as orc_lot_id ,
                    situacao = (SELECT top 1 situacao
                    FROM tbl_notificacao noti where noti.orc_lotacao_id = orc_lot.id and noti.tipo_aprovacao = $tipo_aprovacao_headcount and noti.orc_id = {$orc_id} order by id desc)
                    from tbl_orc_lot_carg_headcount head 
                    inner join tbl_orc_lotacao orc_lot on orc_lot.id = head.lotacao_id
                    inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                    inner join tbl_ccusto cc on cc.id = orc_lot.cc_custo_id
                    inner join tbl_calc_orcamento calc_orc on calc_orc.origem_id = head.id and calc_orc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                where status >= $status_enviado and status <= $status_calculado and orcamento_id = {$orc_id} and head.tipo_table = '{$tipo_table}' $where_periodo
                /*and (calc_orc.jan_orcado <> 0 or calc_orc.fev_orcado <> 0 or calc_orc.mar_orcado <> 0 or calc_orc.abr_orcado <> 0 or calc_orc.mai_orcado <> 0 or calc_orc.jun_orcado <> 0 
                    or calc_orc.jul_orcado <> 0 or calc_orc.ago_orcado <> 0 or calc_orc.set_orcado <> 0 or calc_orc.out_orcado <> 0 or calc_orc.nov_orcado <> 0 or calc_orc.dez_orcado <> 0
                    ) */
                group by orc_lot.id
        ");
		// dd($select);
		if(count($select) == 0) {
			return array("status"=>"success","msg"=>'Aprovado com sucesso!'); 
		}
        
        $situacao_pendente = $tipo_table == "O" ? 1 : 4;
        $situacao_aprovada = $tipo_table == "O" ? 2 : 5;

        foreach($select as $data_lot_id) {
            if($data_lot_id->situacao == $situacao_aprovada) {
                continue;
            }

            $lot = $this->getDataLotacaoOrcamento($data_lot_id->orc_lot_id);
            $orc = $lot->getOrcamento;
            $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
            
            if ($tipo_table == 'F') {
                $descricao = "forecast";
                $tela = "forecast";
                $tipo_aprovacao = 3;
                $situacao = 5;
                $periodo = $ultimo_periodo;//$data['data']['periodo'];
            } else {
                $descricao = "headcount";
                $tela = "headcount";
                $tipo_aprovacao = 1;
                $situacao = 2;
                $periodo = date('Y-m-d');
            }
            
            $observacao = "Aprovado automático para fazer o cálculo!";
        
            $data_notificacoes = $this->getLastDataNotification($data_lot_id->orc_lot_id, $orc_id, $situacao);       
        
            (empty($data_notificacoes[0]->user_pendencia_id)) ? $user_pendencia_id = 0 : $user_pendencia_id = $data_notificacoes[0]->user_pendencia_id;  
            (empty($data_notificacoes[0]->user_aprovador_id)) ? $user_aprovador_id = 0 : $user_aprovador_id = $data_notificacoes[0]->user_aprovador_id;
            
            if($data_funcionario->tipo == 3){
                
                $usuario = new Usuario();
                $repo_func = new RepoFuncionario();            

                $data_lotacao = $this->getDataLotacao( $data_lot_id->orc_lot_id);
                
                $data_user = $usuario->with([
                'getFuncionario'=>function($query){
        
                }])->where('funcionario_id', $user_aprovador_id)->first();
                
                (is_null($data_user)) ? $nivel_hier = 0 : $nivel_hier = $data_user->getFuncionario->nivel_hier;
                
                $data_manager= $repo_func->getFuncsByNivelHierarquicoLotacManager($data_lotacao->unid_lotac, $nivel_hier, $orc_id, $periodo, $tipo_table);
                
                $data_manager_id = $data_funcionario->funcionario_id;
                $data_manager_alter = NULL;    
                
                $historico = "aprovado automático por: " . $data_funcionario->getFuncionario->nome_funcionario;

                $ret = $this->insertNotification($data_lot_id->orc_lot_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
                
            }   
        }        
            
        
        // $this->sendManager($data['data'], $situacao = 2, $metodo = "approveHeadcount");

        $retorno['msg']='Aprovado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        return $retorno;

    }

    public function approveValoresFullLot($orc_id, $tipo_table = 'O') {
        set_time_limit(0);
        $ultimo_periodo = null;
        if($tipo_table == "F"){
            $ultimo_periodo = DB::select("select max(mov.periodo) ultimo_periodo from tbl_orc_movto_status_ccusto mov
                                            join tbl_orc_lotacao ol on mov.orc_lotacao_id = ol.id
                                            where mov.tipo_table = 'F' AND ol.orcamento_id = $orc_id");
            if(count($ultimo_periodo)<= 0){
                return array("status"=>"error","msg"=>'Não foi possível encontrar o último período em aberto!'); 
            }
            $ultimo_periodo = $ultimo_periodo[0]->ultimo_periodo;
        }

        $where_periodo = $tipo_table == "O" ? '' : " AND head.periodo = '$ultimo_periodo' ";
        $tipo_aprovacao_valores = $tipo_table == "O" ? 2 : 4;

        $status_calculado_liberado = $tipo_table == "O" ? $this->getStatusLotCalculadoLiberado() : $this->getStatusLotCalculadoLiberadoFCST();

        $data_funcionario = $this->getDataFuncionario();
        
        $select = DB::select("
            select orc_lot.id as orc_lot_id , orc_lot.status,
                situacao = (SELECT top 1 situacao
            FROM tbl_notificacao noti where noti.orc_lotacao_id = orc_lot.id and noti.orc_id = {$orc_id} and noti.tipo_aprovacao = $tipo_aprovacao_valores  order by id desc)
            from tbl_orc_lot_carg_headcount head 
                right join tbl_orc_lotacao orc_lot on orc_lot.id = head.lotacao_id
                inner join tbl_lotacao lot on lot.id = orc_lot.lotacao_id
                inner join tbl_ccusto cc on cc.id = orc_lot.cc_custo_id
                left join tbl_calc_orcamento calc_orc on calc_orc.origem_id = head.id and calc_orc.tbl_origem = 'tbl_orc_lot_carg_headcount'
            where status = $status_calculado_liberado $where_periodo and orcamento_id = {$orc_id} and (head.tipo_table = '{$tipo_table}')
                /*and (calc_orc.jan_orcado <> 0 or calc_orc.fev_orcado <> 0 or calc_orc.mar_orcado <> 0 or calc_orc.abr_orcado <> 0 or calc_orc.mai_orcado <> 0 or calc_orc.jun_orcado <> 0 
                or calc_orc.jul_orcado <> 0 or calc_orc.ago_orcado <> 0 or calc_orc.set_orcado <> 0 or calc_orc.out_orcado <> 0 or calc_orc.nov_orcado <> 0 or calc_orc.dez_orcado <> 0
                )*/
            group by orc_lot.id, orc_lot.status
        ");
        
        
		// if(count($select) == 0) {
		// 	return array("status"=>"success","msg"=>'Aprovado com sucesso!'); 
		// }
        
        
        $situacao_pendente = $tipo_table == "O" ? 1 : 4;
        
        foreach($select as $data_lot_id) {
            if($data_lot_id->situacao != $situacao_pendente && !is_null($data_lot_id->situacao) && $data_lot_id->status == $this->getStatusLotAprovadoFCST()) {
                continue;
            }
            
            $lot = $this->getModelEntity()->with([
                'getOrcamento'=>function($query){
                    return $query->with([
                        'getOrcParametros'=>function($query){
                            return $query->where('parametro_id',19)->first();//pegar hierarquia
                        },
                    ]);
                },
            ])->where('id',$data_lot_id->orc_lot_id)->first();
            $orc = $lot->getOrcamento;
            $hierarquia = $orc->getOrcParametros[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;            
            
            $lot = $this->getDataLotacaoOrcamento($data_lot_id->orc_lot_id);
            $orc = $lot->getOrcamento;
            $descricao = $lot->getLotacao->unid_lotac. ' - '. $lot->getLotacao->des_unid_lotac;
            
            ($tipo_table == 'F') ? $periodo = $ultimo_periodo : $periodo = date('Y-m-d');
                    
            if ($tipo_table == 'F') {
                $tipo_aprovacao = 4;
                $situacao = 5;
                $descricao = "valores forecast";
                $tela = "valores forecast";
            } else {
                $tipo_aprovacao = 2;
                $situacao = 2;
                $descricao = "valores orcamento";
                $tela = "valores orcamento";
            }
            
            $observacao = "aprovado automático!!";        
            
            if($data_funcionario->tipo == 3){
                // dd("dentro");
                $usuario = new Usuario();
                $repo_func = new RepoFuncionario();            

                $data_lotacao = $this->getDataLotacao( $data_lot_id->orc_lot_id);
                        
                $data_manager_id = $data_funcionario->funcionario_id;
                $data_manager_alter = NULL;   
                
                $historico = "aprovado automático por: " . $data_funcionario->getFuncionario->nome_funcionario;
                
                $ret = $this->insertNotification($data_lot_id->orc_lot_id, $orc_id, $descricao, $tipo_aprovacao, $situacao, $data_manager_id, $data_manager_alter, $historico, $periodo);
                
                $retorno = $this->approvedManagerStatus($data_lot_id->orc_lot_id,$this->getModelNameSpace(),$observacao, 'status', $tipo_table); 

                if(!$this->getRepoNotify()->notifyApproveManager($data_lot_id->orc_lot_id, $hierarquia, $orc->ano, $orc->descricao_orc, $orc_id, $observacao)){
                    return $this->getRepoNotify()->getErrosFlatted();
                }  
    
                $retorno['msg']='Aprovado com sucesso!';
                $retorno['submsg']='Sucesso';
                $retorno['status']='success';
            }        
        }

        
        if($tipo_table != 'F')    {
            $repo_orcamento = new RepoOrcamento();

            $res = $repo_orcamento->completedStatus($orc_id, null);

            if($res['status'] == 'error'){
                return $res;
            }
        }
    
        $retorno['msg']='Aprovado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
        // ($data['tipo_table'] == 'F') ? $situacao = 5 : $situacao = 2;
        // $data = [
        //     'lotacao_id' => $data['lotacao_id'],
        //     'periodo' => $periodo
        // ];

        // $this->sendManager($data, $situacao, $metodo = "approveValores");        

        return $retorno;

    }

    public function atualizaLotacaoRepositorio($orc_id, $dados){
        $data_update = [
            'ativo' => $dados['ativo'],
        ];
        
        return parent::update($data_update, $dados['id']);

        // UPDATE
    }

    

    public function aprovarTodas($orc_id, $tipo_table, $tipo_dados, $periodo = null, $controller_instance = null){
        $tipo_aprovacao_headcount_orcado = 1;
        $tipo_aprovacao_headcount_forecast = 3;
        $tipo_aprovacao_valores_orcado = 2;
        $tipo_aprovacao_valores_forecast = 4;
        $situacao_pendente = $tipo_table == 'O' ? 1 : 4;


        if($tipo_dados == 'headcount'){
            $tipo_aprovacao = $tipo_table == 'O' ? $tipo_aprovacao_headcount_orcado : $tipo_aprovacao_headcount_forecast;
        }
        else{
            $tipo_aprovacao = $tipo_table == 'O' ? $tipo_aprovacao_valores_orcado : $tipo_aprovacao_valores_forecast;
        }

        $lotacoes = $controller_instance->makeEstrutura($orc_id, $periodo, $tipo_table);

        $lotacoes = ( array_column( $lotacoes, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $data_user = $this->getUserFromCurrentGuard();
        $data_funcionario = $this->getDataFuncionario();
        $funcionario_id = $data_funcionario->funcionario_id;
        $where_lotacoes = $data_user->tipo == 3 ? "" : " AND ol.lotacao_id in ($lotacoes_string)";
        $where_periodo = $tipo_table != 'F' ? " AND ol.periodo IS NULL" : " AND ol.periodo = '$periodo'";

        $lotacoes_aprovar = DB::select("
            select 
                ol.id,
                (select top 1 situacao from tbl_notificacao notif where notif.orc_lotacao_id = ol.id and notif.tipo_aprovacao = $tipo_aprovacao and (notif.user_aprovador_id = $funcionario_id OR notif.user_pendencia_id = $funcionario_id) order by id desc) situacao
            from tbl_orc_lotacao ol
            where ol.orcamento_id = $orc_id and ol.tipo_table = '$tipo_table' $where_lotacoes $where_periodo
        ");

        DB::beginTransaction();

        foreach ($lotacoes_aprovar as $lotacao) {
            if(is_null($lotacao->situacao)){
                continue;
            }   
            if($lotacao->situacao != $situacao_pendente){
                continue;
            }             
            if($tipo_dados == 'headcount'){
                $data['data'] = [
                    'lotacao_id' => $lotacao->id,
                    'periodo' => $periodo
                ];
                $data['justificativa'] = 'Não informada';

                $res = $this->prepareApproveHeadcount($orc_id, $data, $tipo_table);
                if($res['status'] == 'error'){
                    DB::rollBack();
                    $this->setError($res['msg']. ' Erro 170320210940');
                    return false;
                }
            }
            else{
                $data = [
                    'orc_lot_id' => $lotacao->id,
                    'lotacao_id' => $lotacao->id,
                    'periodo' => $periodo
                ];
                $res = $this->approveManager($data, 'Não informada', $tipo_table);
                if($res['status'] == 'error'){
                    DB::rollBack();
                    $this->setError($res['msg']. ' Erro 170320211000');
                    return false;
                }
            }
        }

        DB::commit();
        return true;

    }

}
