<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoCargo;

use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto as LotacaoCCusto;

use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CargosArea;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;

class RepoOrcLotacaoCargoSal extends RepoOrcamento
{
    
    //protected $model_name_space_local='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        //$this->setModelNameSpace('App\Modules\Natureza51\Entities\OrcCargosAreaSal');
        parent::__construct();
    }
    public function listAll($orc_id, $lotac_id = null, $periodo = null, $tipo_table = 'O'){
        $repo_orc_lot = new RepoOrcLotacao();
        $tbl_orc_lot = $repo_orc_lot->getModelEntity();

        // $tbl_orc_lotacao_controller = new OrcLotacaoController();
        // $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));

        $repo_cargo = new RepoCargo();
        $tbl_cargo = $repo_cargo->getModelEntity();

        $tbl_ccusto = new CentroCusto();

        $repo_orc_cargo = new RepoOrcCargo();
        $tbl_orc_cargo = $repo_orc_cargo->getModelEntity();

        $repo_lot = new RepoLotacao();

        $tbl_usuario = new Usuario();
        $tbl_lot =  $repo_lot->getModelEntity();

        $calc_orc_repo=$this->setCalOrcRepo()->getCalcOrcRepo();
        $tbl_calc_orc = $calc_orc_repo->getModelEntity();
        $calc_orc_table=$calc_orc_repo->getModelEntity()->getTable();
        
        $lotacao_carg_sal_table=$this->getModelEntity()->getTable();
        $query = $this->getModelEntity()
            ->leftJoin($tbl_orc_cargo->getTable(), $this->getModelEntity()->getColunaAlias('cargo_id'),'=',$tbl_orc_cargo->getColunaAlias('id'))
            ->leftJoin($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'),'=',$tbl_cargo->getColunaAlias('id'))

            ->leftJoin($tbl_orc_lot->getTable(), $this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$tbl_orc_lot->getColunaAlias('id'))
            ->leftJoin($tbl_lot->getTable(), $tbl_orc_lot->getColunaAlias('lotacao_id'),'=', $tbl_lot->getColunaAlias("id"))

            ->leftJoin($tbl_ccusto->getTable(), $tbl_orc_lot->getColunaAlias('cc_custo_id'), $tbl_ccusto->getColunaAlias('id'))
            ->leftJoin($calc_orc_table, $this->getModelEntity()->getColunaAlias('id'), '=', DB::raw($calc_orc_repo->getModelEntity()->getColunaAlias('origem_id')." AND tbl_origem='".$lotacao_carg_sal_table."'"))

            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $this->getModelEntity()->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
    
            ->select(
                //DB::raw("{$this->getModelEntity()->getColunaAlias('id')} as origem_id"),
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),
                $this->getModelEntity()->getColunaAlias('lotacao_id'),
                $this->getModelEntity()->getColunaAlias('sal_base'),
                DB::raw("{$this->getModelEntity()->getColunaAlias('sal_maior')} as sal_max"),
                $this->getModelEntity()->getColunaAlias('sal_med'), 
                $this->getModelEntity()->getColunaAlias('sal_menor'),
                // $this->getModelEntity()->getColunaAlias('periculosidade'),
                // $this->getModelEntity()->getColunaAlias('insalubridade'),
                DB::raw("IIF({$this->getModelEntity()->getColunaAlias('periculosidade')} = 1, 'Sim', 'Não') as periculosidade"),
                DB::raw("IIF({$this->getModelEntity()->getColunaAlias('insalubridade')} = 1, 'Sim', 'Não') as insalubridade"),
                DB::raw("CONCAT({$tbl_ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$tbl_lot->getColunaAlias('unid_lotac')}, ' - ' , {$tbl_lot->getColunaAlias('des_unid_lotac')}) as lotac_description"),
                DB::raw("CONCAT({$tbl_lot->getColunaAlias('cod_cargo_basic')}, ' - ' , {$tbl_lot->getColunaAlias('des_cargo_basic')}) as cargo_description"),
                $tbl_lot->getColunaAlias('unid_lotac'),
                $tbl_cargo->getColunaAlias('cod_cargo_basic'),
                $tbl_lot->getColunaAlias('des_unid_lotac'),
                $tbl_cargo->getColunaAlias('des_cargo_basic'),
                $tbl_calc_orc->getColunaAlias("id"),
                $tbl_calc_orc->getColunaAlias('origem_id'),
                $tbl_calc_orc->getColunaAlias('jan_orcado'),
                $tbl_calc_orc->getColunaAlias('fev_orcado'),
                $tbl_calc_orc->getColunaAlias('mar_orcado'),
                $tbl_calc_orc->getColunaAlias('abr_orcado'),
                $tbl_calc_orc->getColunaAlias('mai_orcado'),
                $tbl_calc_orc->getColunaAlias('jun_orcado'),
                $tbl_calc_orc->getColunaAlias('jul_orcado'),
                $tbl_calc_orc->getColunaAlias('ago_orcado'),
                $tbl_calc_orc->getColunaAlias('set_orcado'),
                $tbl_calc_orc->getColunaAlias('out_orcado'),
                $tbl_calc_orc->getColunaAlias('nov_orcado'),
                $tbl_calc_orc->getColunaAlias('dez_orcado'),
                DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_data"),
                DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_data"),
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
            
            )
            ->where($this->getModelEntity()->getColunaAlias('orcamento_id'),'=', $orc_id)
            
            ->orderBy($tbl_lot->getColunaAlias('cod_cargo_basic'), 'asc')->orderBy($tbl_lot->getColunaAlias('unid_lotac'), 'asc');

            //->whereIn($tbl_lot->getColunaAlias('id'),$lotacoes);
            
        if(!is_null($lotac_id)){
            $query->where('lotacao_id', '=', $lotac_id);
        }

        if($periodo != null && $periodo != "" || strlen($periodo) > 0){
            $query->where([
                [$this->getModelEntity()->getColunaAlias('periodo'), '=', $periodo],
                [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $tipo_table]
            ]);
        }
        else{
            $query->where($this->getModelEntity()->getColunaAlias('tipo_table'), 'O')
            ->whereNull($this->getModelEntity()->getColunaAlias('periodo'));
        }
        
        return $query->get();
        
        $cargo_sal = $query->get()->toArray();
        
        if(!($orc = $cargo_sal->first())){
            //$this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
            return $cargo_sal;
        }
        $orc_f = $orc->getOrcamento();
        
        if(!$orc_f){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191803']);
            return false;
        }
        $atual = $orc_f->first();
        
        if(!$atual){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191804']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has() === false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191635']);
            return false;
        }
        if($this->isOwn() === false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 031220191637']);
            return false;
        }
        
        if(!$orc){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
        
        return $cargo_sal->count() == 0 ? []: $cargo_sal;
       
    }

    public function indiceListar($orc_id){
        $tbl_calc_ind = new CalcIndice();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_cargo = new Cargo();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();

        $dados = $this->getModelEntity()
        ->leftJoin($tbl_calc_ind->getTable(), $this->getModelEntity()->getColunaAlias('id'), $tbl_calc_ind->getColunaAlias('origem_id'))
        ->leftJoin($tbl_orc_cargo->getTable(), $this->getModelEntity()->getColunaAlias('cargo_id'), $tbl_orc_cargo->getColunaAlias('id'))
        ->leftJoin($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'),$tbl_cargo->getColunaAlias('id'))
        ->leftJoin($tbl_orc_lotacao->getTable(), $this->getModelEntity()->getColunaAlias('lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $tbl_calc_ind->getColunaAlias('origem_id'),
            DB::raw("{$tbl_calc_ind->getColunaAlias('id')} as calc_id"),
            $this->getModelEntity()->getColunaAlias('cargo_id'),
            DB::raw("{$tbl_orc_lotacao->getColunaAlias('id')} as lotacao_id"),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $this->getModelEntity()->getColunaAlias('sal_base'),
            $this->getModelEntity()->getColunaAlias('sal_maior'),
            $this->getModelEntity()->getColunaAlias('sal_med'),
            $this->getModelEntity()->getColunaAlias('sal_menor'),
            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            $tbl_cargo->getColunaAlias('des_cargo_basic'),

            $tbl_calc_ind->getColunaAlias('jan_indice'),
            $tbl_calc_ind->getColunaAlias('fev_indice'),
            $tbl_calc_ind->getColunaAlias('marc_indice'),
            $tbl_calc_ind->getColunaAlias('abril_indice'),
            $tbl_calc_ind->getColunaAlias('maio_indice'),
            $tbl_calc_ind->getColunaAlias('jun_indice'),
            $tbl_calc_ind->getColunaAlias('jul_indice'),
            $tbl_calc_ind->getColunaAlias('agost_indice'),
            $tbl_calc_ind->getColunaAlias('set_indice'),
            $tbl_calc_ind->getColunaAlias('out_indice'),
            $tbl_calc_ind->getColunaAlias('nov_indice'),
            $tbl_calc_ind->getColunaAlias('dez_indice')
        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])
        ->get()->toArray();

        for($i=0;$i<count($dados);$i++){
            $dados[$i]['identificador']="1";
        }
        
        return $dados;
    }

    public function createOrcLotCargoIndice(array $dados){

        $this->clearError();
        
        $tb_calc_indice=new CalcIndice();
        $tb_orc_cargo_area_sal=new OrcCargosAreaSal();
        
        if(isset($dados['meses_orcado'])==false){
            $this->setError('Preencha os meses');
            return false;
        }
        $select=$this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
                [$this->getModelEntity()->getColunaAlias('cargo_id'),'=',$dados['cargo_id']],
                [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']]
            ])->get()->toArray();

        if(count($select)>0){
            $this->setError('Registro já cadastrado');
            return false;
        }
        //dd($dados);
        $dados_cargo=array('orcamento_id'=>$dados['orcamento_id'],'cargo_id'=>$dados['cargo_id'],'lotacao_id'=>$dados['lotacao_id'],
        'sal_base'=>$dados['sal_base'],'sal_maior'=>$dados['sal_max'],'sal_med'=>$dados['sal_med'],'sal_menor'=>$dados['sal_min']);

        DB::beginTransaction();
        try{
            
            //dd($salvou = $this->create($dados_cargo));
            $salvou = $this->create($dados_cargo);
            if(!$salvou){
                return false;
            }
            
            
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['meses_orcado']['jan_orcado'],
            'fev_indice'=>$dados['meses_orcado']['fev_orcado'],
            'marc_indice'=>$dados['meses_orcado']['mar_orcado'],
            'abril_indice'=>$dados['meses_orcado']['abr_orcado'],
            'maio_indice'=>$dados['meses_orcado']['mai_orcado'],
            'jun_indice'=>$dados['meses_orcado']['jun_orcado'],
            'jul_indice'=>$dados['meses_orcado']['jul_orcado'],
            'agost_indice'=>$dados['meses_orcado']['ago_orcado'],
            'set_indice'=>$dados['meses_orcado']['set_orcado'],
            'out_indice'=>$dados['meses_orcado']['out_orcado'],
            'nov_indice'=>$dados['meses_orcado']['nov_orcado'],
            'dez_indice'=>$dados['meses_orcado']['dez_orcado'],
        );
            //dd($dados_indice);
            $salvar_indice=$tb_calc_indice->create($dados_indice);
    
            if(!$salvar_indice){
                $this->setError('Falha ao inserir indices. Erro: 310320201528');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 310320201516.');
       }
       return true;
    }

    public function createOrcLotCargo(array $dados, $empresa_id, $call_back_success=null, $call_ball_error=null){

        // if(!$this->getRespEstrutura($dados['orcamento_id'],$dados['lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520201001");
        //     return false;
        // }
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_calc_ind = new CalcIndice();
        //dd($dados);
        //CONFERE SE EXISTE
        
        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('cargo_id'),'=',$dados['cargo_id']],
            [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$dados['tipo_table']]

        ]);
        $salario_cargo = [];
        if($dados['tipo_table'] == 'F'){
            $salario_cargo = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $dados['periodo'])->get()->toArray();
        }
        else{
            $salario_cargo = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
                
        //SE EXISTE
        if(count($salario_cargo) > 0){
            //E SE É ABSOLUTO
            if($dados['tipo_meses'] == 2)
            {
                $select_calc_orc = $tbl_calc_orc->select()->where([
                    [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$salario_cargo[0]['id']],
                    [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //SE EXISTE
                //dd(count($select_calc_orc));

                if(count($select_calc_orc)>0)
                {
                    //dd("aqui",$salario_funcionario,$select_calc_orc);
                    $this->setError("Registro já existente. Erro: 080420201352");
                    return false;
                }
                //SENAO
                else
                {
                    if(!$this->insereCalcOrc($salario_cargo[0]['id'],$dados)){
                        $this->setError('Erro ao inserir registro. Erro: 080420201348');
                        return false;
                    }
                }
            }
            //SE É INDICE
            else if($dados['tipo_meses']==1)
            {
                
                $select_calc_ind = $tbl_calc_ind->select()->where([
                    [$tbl_calc_ind->getColunaAlias('origem_id'),'=',$salario_cargo[0]['id']],
                    [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //SE EXISTE
                
                if(count($select_calc_ind)>0)
                {
                    $this->setError("Registro já existente.  Erro: 080420201351");
                    return false;
                }
                //SENAO
                else
                {   
                    if(!$this->insereIndice($salario_cargo[0]['id'],$dados)){
                        
                        $this->setError('Erro ao inserir registro.  Erro: 080420201348');
                        return false;
                    }
                }
            }
        }
        //SE NÃO EXISTE
        else{
            
            if($dados['tipo_meses']==1){
                if(!$this->createOrcLotCargoIndice($dados)){
                    $this->setError('Não foi possível inserir o registro. Erro:080420201349');
                    return false;
                }
                return true;
            }
            else{
                if(!$this->insereCalcCargoSalario($dados, $empresa_id)){
                    $this->setError('Não foi possível inserir o registro. Erro:080420201350');
                    return false;
                }
                return true;
            }
        }
        
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
        
    } 
    // public function updateOrc(array $data, $id, $attribute = "id", $call_back_success=null, $call_ball_error=null) {
    //     parent::update($data, $id, $attribute);
    // }

    public function insereCalcCargoSalario(array $dados, $empresa_id){

        $this->clearError();
       
        // $orc= $this->getModelEntity()->where('orcamento_id','=', $this->extractOrcamentoIdFromData($dados,'orcamento_id'))->first();
       
        // if(!$orc){
        //    $this->setError(['Informe um orçamento','Erro: 240220201703']);
        //    return false;
        // }

        //dd($dados);
        if(isset($dados['meses_orcado'])==false){
            $this->setError('Preencha os meses');
            return false;
        }
        
    //    if($this->setOrcamento($orc->getOrcamento()->first())->canEdit()===false){
    //        $this->setError('O estado do orçamento não permite este tipo de operação.', 'Erro: 021220191837');
    //        return false;
    //    }

        /*$orc_sal_salario = $this->getModelEntity()->where([
            ['orcamento_id',$this->extractOrcamentoIdFromData($dados)],
            ['lotacao_id',$this->extractLotacaoIdFromData($dados,'lotacao_id')],
            //    ['ccusto_id',$dados['ccusto_id']],
            ['cargo_id',$dados['cargo_id']]
        ])->get()->toArray();
    
        if(!empty($orc_sal_salario)){
            $this->setError('Cargo já cadastrado.');
            return false;
        }*/

    
        DB::beginTransaction();

        $dados['empresa_id'] = $empresa_id;
        // $dados['sal_maior'] = $dados['sal_maior'];
        $dados['sal_menor'] = $dados['sal_min'];
        // $dados['sal_med'] = $dados['sal_med'];//(floatval($dados['sal_max']) + floatval($dados['sal_min']))/2;
        
        /*$condicao = "";
        if($dados['tipo_table'] == 'F'){
            $condicao = " where cargo.tipo_table = 'F' and cargo.periodo = '{$dados['periodo']}'";
        }
        else{
            $condicao = " where cargo.tipo_table = 'O' and cargo.periodo is null";
        }

        $insa_per = DB::select("SELECT ca.periculosidade, ca.insalubridade
            FROM tbl_cargos_area as ca
        
            join tbl_orc_lotacao as orclot on orclot.cc_custo_id = ca.ccusto_id and orclot.lotacao_id = ca.lotacao_id and orclot.orcamento_id = {$dados['orcamento_id']} and orclot.id = {$dados['lotacao_id']}
        
            join tbl_orc_cargo as cargo on ca.cargo_id = cargo.cargo_id and cargo.orcamento_id = {$dados['orcamento_id']} and cargo.id = {$dados['cargo_id']}
        ".$condicao);

        
        if(count($insa_per) > 0){
            $dados['periculosidade'] = $insa_per[0]->periculosidade;
            $dados['insalubridade'] = $insa_per[0]->insalubridade;
        }
        else{
            $dados['periculosidade'] = 0;
            $dados['insalubridade'] = 0;
        }*/
        try{
            $salvou = $this->create($dados);
            if(!$salvou){
                return false;
            }

            $repo_calc_orc=new RepoCalcOrcamento();
            $salvou_calc= $repo_calc_orc->create(array_merge($dados['meses_orcado'],["origem_id"=>$salvou->id, "tbl_origem"=>$this->getModelEntity()->getTable()]));
            
            if($salvou_calc==false){
                $this->setError([$repo_calc_orc->getErrosFlatted(),'Erro: 021220191908']);
                DB::rollBack();
                return false;
            }

            DB::commit();
            
        } catch (Exception $ex) {
            DB::rollBack();
            abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
        }
        return true;
    }

    public function insereIndice($id,$dados){
        $tbl_calc_indice=new CalcIndice();
        $dados = $dados['meses_orcado'];

        $dados_indice=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['jan_orcado'],
            'fev_indice'=>$dados['fev_orcado'],
            'marc_indice'=>$dados['mar_orcado'],
            'abril_indice'=>$dados['abr_orcado'],
            'maio_indice'=>$dados['mai_orcado'],
            'jun_indice'=>$dados['jun_orcado'],
            'jul_indice'=>$dados['jul_orcado'],
            'agost_indice'=>$dados['ago_orcado'],
            'set_indice'=>$dados['set_orcado'],
            'out_indice'=>$dados['out_orcado'],
            'nov_indice'=>$dados['nov_orcado'],
            'dez_indice'=>$dados['dez_orcado']
        );
        $dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            $this->setError('Erro ao inserir índices.');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();
        
        $data= $data['meses_orcado'];
        
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
        $inseriu=$calc_orcamento->create($orcamento);
        //dd($inseriu);
        if(!$inseriu)
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
      }
 
    public function updateOrcIndice($form_data,$id){
        $repo_calc_ind = new RepoCalcIndice();
        $id_calc = $form_data['calc_id'];
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        $update = $repo_calc_ind->update($meses,$id_calc);
        if(!$update){
            return false;
        }
        return true;
    }

    public function deleteOrcIndice($form_data,$id){
        $repo_calc_ind = new RepoCalcIndice();
        $calc_orcamento = new CalcOrcamento();
        
        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();
                
            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420201310");
                return false;
            }
        }
        else{

            DB::beginTransaction();
            try {
                if(!$this->delete($id)){
                    return false;
                }      
                if(!$repo_calc_ind->delete($form_data['calc_id'])){
                    return false;
                }    
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 030420201043.');
                return false;
            }
        }
        return true;
    }

    public function updateOrc(array $data, $id, $attribute = "id") {
        
        // if(!$this->getRespEstrutura($data['orcamento_id'],$data['lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520201015");
        //     return false;
        // }
        $repo_calc_orc= new RepoCalcOrcamento();
        $meses_filter = $this->clearData($data);
        $data_filter = $this->clearMeses($data);
        //dd($data_filter);
        $data_filter['sal_maior'] = $data['sal_max'];
		
        if($data_filter['sal_base']==null || $data_filter['sal_base']==""){
            $data_filter['sal_base']="0";
        }
        if($data_filter['sal_med']==null || $data_filter['sal_med']==""){
            $data_filter['sal_med']="0";
        }
        if($data_filter['sal_menor']==null || $data_filter['sal_menor']==""){
            $data_filter['sal_menor']="0";
        }
        if($data_filter['sal_maior']==null || $data_filter['sal_maior']==""){
            $data_filter['sal_maior']="0";
        }
        if($data_filter['sal_min']==null || $data_filter['sal_min']==""){
            $data_filter['sal_min']="0";
        }

        DB::beginTransaction();
        try {
            
            $data_filter['sal_base'] = $this->formataSalario($data_filter['sal_base']);
            $data_filter['sal_med'] = $this->formataSalario($data_filter['sal_med']);
            $data_filter['sal_menor'] = $this->formataSalario($data_filter['sal_menor']);
            $data_filter['sal_maior'] = $this->formataSalario($data_filter['sal_maior']);
            $data_filter['sal_min'] = $this->formataSalario($data_filter['sal_min']);
            
            $dados = Arr::only($data_filter, ['sal_menor', 'sal_maior', 'periculosidade', 'insalubridade']);
            if(!$this->update($dados, $id)){
                return false;
            }  
            
            $meses=Arr::only($meses_filter,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
            $meses=convertDecimalEn($meses);
            //$meses_filter=array_merge($meses_filter,$meses);
            
            if(!$repo_calc_orc->update($meses,$data['id'])){
                return false;
            }    
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            // dd( $e);
            abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
            return false;
        }
        return true;
    }

    public function deleteOrc(array $data, $id, $attribute = "id") {

        // if(!$this->getRespEstrutura($data['orcamento_id'],$data['lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 210520201011");
        //     return false;
        // }
        $repo_calc_orc= new RepoCalcOrcamento();
        // $calc_indice = new CalcIndice();
        // $repo_calc_ind = new RepoCalcIndice();
        
        DB::beginTransaction();
        try {
            if(!$this->delete($id)){
                return false;
            }      
            if(!$repo_calc_orc->delete($data['id'])){
                return false;
            }   
            /*
            $select_indice = $calc_indice->select()->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$id],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();

            if(count($select_indice)>0)
            {
                $delete_indices = $repo_calc_ind->getModelEntity()->where([
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$id],
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]])
                ->delete();

                if(!$delete_indices){
                    return false;
                }
            }*/
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
            return false;
        }
        return true;
    }

    public function clearMeses($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','sal_max','data_calc','origem_id','id'];
        return $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));          
    }
    public function clearData($data){
        $array_orcamento=['id','origem_id','sal_max','sal_min','data_calc','orcamento_id','cargo_id','lotacao_id','sal_base','sal_maior','sal_med','sal_menor','empresa_id','ccusto_id'];
        return $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));   
    }
    public function formataSalario($value){
        $value=str_replace('.','',$value);
        $value=str_replace(',','.',$value);
        return $value;
    }
    
    public function populaLotCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        $orc_cargo_area_sal = new OrcCargosAreaSal();
        $funcionario = new Funcionario();
        $orc_cargo = new OrcCargo();
        $cargo = new Cargo();
        $orc_lotacao = new OrcLotacao();
        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();       
        $repo_orc_script_calculos = new RepoOrcScriptCalculos();
        $calc_orcamento = new CalcOrcamento();
        $cargo_lotacao = new CargosArea();
        
        $entities = [
            'orcCargosAreaSal' => ['instance'=>$orc_cargo_area_sal],
            'funcionario' => ['instance'=>$funcionario],
            'orcCargo' => ['instance'=>$orc_cargo],
            'cargo' => ['instance' => $cargo],
            'orcLotacao' => ['instance' => $orc_lotacao],
            'lotacaoCCusto' => ['instance' => $lotacao_c_custo],
            'lotacao' => ['instance' => $lotacao],           
            'calcOrcamento' => ['instance' => $calc_orcamento],
            'CargoLotacao' => ['instance' => $cargo_lotacao]
        ];
        $this->clearError();

        $result[] = $repo_orc_script_calculos->insertUpcalcOrcCargoAreaSal($entities, $orc_id, $periodo, $tipo_table);
         
        if($result[0]["status"]=="success"){
            $result[] = $repo_orc_script_calculos->insertCalcOrcamentoCargoAreaSal($entities, $orc_id, $periodo, $tipo_table);
        }

        if($this->hasError()){
            return $result;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastrado com sucesso!";
        $retorno['submsg']="Registro cadastrado com sucesso!";

        return $retorno; 
    }
    public function deleteAll($orc_id, $periodo = null, $tipo_table = 'O'){
        DB::beginTransaction();
        try{
            
            $condicao = $tipo_table == 'F' ? " and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' " : " and tipo_table = '{$tipo_table}' and periodo is null";
            $condicao2 = $tipo_table == 'F' ? " and oca.tipo_table = '{$tipo_table}' and oca.periodo = '{$periodo}' " : " and oca.tipo_table = '{$tipo_table}' and oca.periodo is null";

            $delete_calc = DB::delete("DELETE FROM tbl_calc_orcamento where tbl_origem = 'tbl_orc_cargos_area_sal' and origem_id in
                /*SELECT id FROM tbl_orc_cargos_area_sal where orcamento_id = $orc_id {$condicao}*/
                (select oca.id from tbl_orc_cargos_area_sal as oca

                left join tbl_orc_bonus as ob on ob.cargo_id = oca.cargo_id and ob.orc_lot_id = oca.lotacao_id
                left join tbl_orc_ppr as ppr on ppr.cargo_id = oca.cargo_id and ppr.orc_lot_id = oca.lotacao_id
                left join tbl_orc_lot_carg_event as elc on elc.orc_cargo_id = oca.cargo_id and elc.lotacao_id = oca.lotacao_id

                left join tbl_orc_lot_carg_headcount as hd on hd.orc_cargo_id = oca.cargo_id and hd.lotacao_id = oca.lotacao_id

                where oca.orcamento_id = $orc_id {$condicao2} and ob.id is null and ppr.id is null and elc.id is null and hd.id is null
                )
            ");
            
            if($delete_calc === false){
                $this->setError("Falha ao excluir registros.");
                DB::rollBack();
                return false;
            }

            $delete = DB::delete("DELETE FROM tbl_orc_cargos_area_sal where id in (
                select oca.id from tbl_orc_cargos_area_sal as oca

                left join tbl_orc_bonus as ob on ob.cargo_id = oca.cargo_id and ob.orc_lot_id = oca.lotacao_id
                left join tbl_orc_ppr as ppr on ppr.cargo_id = oca.cargo_id and ppr.orc_lot_id = oca.lotacao_id
                left join tbl_orc_lot_carg_event as elc on elc.orc_cargo_id = oca.cargo_id and elc.lotacao_id = oca.lotacao_id

                left join tbl_orc_lot_carg_headcount as hd on hd.orc_cargo_id = oca.cargo_id and hd.lotacao_id = oca.lotacao_id

                where oca.orcamento_id = $orc_id {$condicao2} and ob.id is null and ppr.id is null and elc.id is null and hd.id is null
            )");
            
            if($delete === false){
                $this->setError("Falha ao excluir registros. Erro: 100820201356b");
                DB::rollBack();
                return false;
            }
            DB::commit();
            if($delete_calc === 0 && $delete === 0){
                $orc_fore = $tipo_table == 'F' ? "Forecast" : "Orçamento";
                $this->setError("Nenhum registro para ser excluído. Os registros só podem ser excluídos caso não existam nas seguintes telas/etapas: Bônus, PR, Eventos por Lotação e Cargo e em {$orc_fore}.");
                return 'warning';
            }
            return true;
        }catch(\Exception $e){
            $this->setError("Falha ao excluir registros. Erro: 100820201356".$e->getMessage());
            DB::rollBack();
            return false;
        }
        DB::commit();
        return true;
    }

    public function atualizaLotCargo($orc_id, $periodo = null, $tipo_table = 'O'){
        /*
            1-De onde virão os dados? da tbl_funcionario, com join na tbl_orc_cargo e tbl_orc_lotacao
        */
        set_time_limit(700);
        $condicao[0] = $tipo_table == 'F' ? " and oc.periodo = '{$periodo}' and oc.tipo_table = '{$tipo_table}' " : " and oc.periodo is null and oc.tipo_table = '{$tipo_table}' ";
        $condicao[1] = $tipo_table == 'F' ? " and cas.periodo = '{$periodo}' and cas.tipo_table = '{$tipo_table}' " : " and cas.periodo is null and cas.tipo_table = '{$tipo_table}' ";
        $condicao[2] = $tipo_table == 'F' ? " and ocas.periodo = '{$periodo}' and ocas.tipo_table = '{$tipo_table}' " : " and ocas.periodo is null and ocas.tipo_table = '{$tipo_table}' ";
        $condicao[3] = $tipo_table == 'F' ? " and ol.periodo = '{$periodo}' and ol.tipo_table = '{$tipo_table}' " : " and ol.periodo is null and ol.tipo_table = '{$tipo_table}' ";

        $select_existentes = DB::select("SELECT oc.id as cargo_id, ol.id as lotacao_id, ol.lotacao_id as lot_id, oc.cargo_id as cargo_id_b,
            avg(f.salario) as sal_base, max(oc.sal_max) as sal_max,
            avg(f.salario) as sal_med, min(oc.sal_min) as sal_min,
            f.empresa_id, f.ccusto_id
            
            FROM tbl_funcionario as f
            
            inner JOIN tbl_orc_cargo as oc on oc.cargo_id = f.cargo_id ".$condicao[0]."
            inner JOIN tbl_orc_lotacao as ol on ol.lotacao_id = f.lotacao_id and ol.cc_custo_id = f.ccusto_id".$condicao[3]."
            inner join tbl_cargo as c on c.id = f.cargo_id
            
            WHERE oc.orcamento_id = ? and ol.orcamento_id = ? and f.dat_demis_func is null and (SELECT count(*) from tbl_orc_cargos_area_sal as cas where cas.cargo_id = oc.id and cas.lotacao_id = ol.id and cas.orcamento_id = {$orc_id} {$condicao[1]}) = 0
            GROUP BY oc.id, ol.id, f.empresa_id, f.ccusto_id, oc.tipo_table, oc.periodo, ol.lotacao_id, oc.cargo_id",
            [$orc_id, $orc_id, $orc_id]
        );      

        
        // if(count($select_existentes) == 0){
        //     $this->setError("Nenhum Cargo x Lotação encontrado para atualizar. Erro: 251120201145");
        //     return 'warning';
        // }
        // else{
        
            foreach($select_existentes as $value){
                DB::beginTransaction();
                try{
                    $sal_med = DB::select("SELECT 
                        CASE (select count(*) from tbl_funcionario where cargo_id = (select cargo_id from tbl_orc_cargo where id = ?) and lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = {$value->lotacao_id}) and dat_demis_func is null)
                            when 0 then (select salario_min from tbl_cargo where id = (select cargo_id from tbl_orc_cargo where id = ?))
                            else (select avg(salario) sal_med from tbl_funcionario where cargo_id = (select cargo_id from tbl_orc_cargo where id = ?) and lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = {$value->lotacao_id}) and dat_demis_func is null) end sal_med", [$value->cargo_id, $value->cargo_id, $value->cargo_id]);
                    
                    $sal_med = count($sal_med) > 0 ? $sal_med[0]->sal_med : $value->sal_med;

                    $insal_per = DB::select("SELECT periculosidade, insalubridade from tbl_cargos_area where cargo_id = {$value->cargo_id_b} and lotacao_id = {$value->lot_id} and ccusto_id = {$value->ccusto_id}");
                    
                    $insal = 0;
                    $peric = 0;
                    if(count($insal_per) > 0){
                        $insal = $insal_per[0]->insalubridade;
                        $peric = $insal_per[0]->periculosidade;
                    }
                    
                    $insert = DB::insert("INSERT INTO tbl_orc_cargos_area_sal(orcamento_id, cargo_id, lotacao_id, sal_base,
                        sal_maior, sal_med, sal_menor, empresa_id, ccusto_id, created_at, created_by, tipo_table, periodo, periculosidade, insalubridade) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                        [$orc_id, $value->cargo_id, $value->lotacao_id, $value->sal_base, $value->sal_max, $sal_med, $value->sal_min,
                        $value->empresa_id, $value->ccusto_id, $this->fillCriadoEm(), $this->fillCriadoPor(), $tipo_table, $periodo, $peric, $insal]
                    );

                    if($insert === false){
                        $this->setError("Falha ao inserir novo(s) Cargo(s) x Lotação. Erro: 251120201158");
                        return false;
                    }

                    $select_insert = DB::select("SELECT id FROM tbl_orc_cargos_area_sal as ocas WHERE ocas.orcamento_id = ? and ocas.cargo_id = ? and ocas.lotacao_id = ?".$condicao[2], [$orc_id, $value->cargo_id, $value->lotacao_id]);

                    $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                        ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                        ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES (
                        ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                        [$select_insert[0]->id, 'tbl_orc_cargos_area_sal', $sal_med, $sal_med, $sal_med, $sal_med, 
                        $sal_med, $sal_med, $sal_med, $sal_med, $sal_med, $sal_med, 
                        $sal_med, $sal_med, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                    );

                    if($insert_calc === false){
                        $this->setError("Falha ao inserir registro. Erro: 251120201304");
                        DB::rollBack();
                        return false;
                    }
                    DB::commit();
                }
                catch(\Exception $e){
                    DB::rollBack();
                    $this->setError("Erro ao inserir novos dados. Erro: 251120201159ct ".$e);
                    return false;
                }
            }
        
            $condicao2[0] = $tipo_table == 'F' ? " and orc_cargo_h.periodo = '{$periodo}' and orc_cargo_h.tipo_table = '{$tipo_table}' " : " and orc_cargo_h.periodo is null and orc_cargo_h.tipo_table = '{$tipo_table}' ";
            $condicao2[1] = $tipo_table == 'F' ? " and head.periodo = '{$periodo}' and head.tipo_table = '{$tipo_table}' " : " and head.periodo is null and head.tipo_table = '{$tipo_table}' ";
            $condicao2[2] = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and periodo is null and tipo_table = '{$tipo_table}' ";

            $select_cargo_area_sem_cargos = DB::select("SELECT distinct lotacao_id, ccusto_id, orc_cargo.id as cargo_id, orc_cargo.sal_base, 
                orc_cargo.sal_max, orc_cargo.sal_min sal_med, orc_cargo.sal_min, orc_cargo_h.empresa_id, orc_cargo_h.ccusto_id,
                orc_cargo.cargo_id as cargo_id_b
            from [dbo].[tbl_orc_lot_carg_headcount] orc_cargo_h
            inner join [dbo].[tbl_calc_orcamento] calc on calc.origem_id = orc_cargo_h.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
            inner join tbl_orc_cargo orc_cargo on orc_cargo.id = orc_cargo_h.orc_cargo_id and orc_cargo.orcamento_id = orc_cargo_h.orc_id
            
            where orc_id = {$orc_id} and orc_cargo_h.id not in 
                (SELECT head.id from [tbl_orc_lot_carg_headcount] head
                    inner join tbl_orc_cargos_area_sal orc_c_a on orc_c_a.orcamento_id = head.orc_id 
                    and orc_c_a.lotacao_id = head.lotacao_id and orc_c_a.ccusto_id = head.ccusto_id and orc_c_a.cargo_id = head.orc_cargo_id
                    where orcamento_id = {$orc_id} {$condicao2[1]} ) 
                and (orc_cargo_h.forecast_anterior != 0 or calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado!= 0 or calc.abr_orcado != 0 or calc.mai_orcado != 0 or
                calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or calc.set_orcado != 0 or calc.out_orcado != 0 or
                calc.nov_orcado != 0 or calc.dez_orcado != 0 ) {$condicao2[0]} ");
            
            if(count($select_cargo_area_sem_cargos) != 0){
               
                foreach($select_cargo_area_sem_cargos as $value){
                    DB::beginTransaction();
                    try{
                        $where_existe = $tipo_table == 'F' ? " and tipo_table = 'F' and periodo = '{$periodo}' " : " and tipo_table = 'O' ";
                        $existe = DB::select("SELECT * from tbl_orc_cargos_area_sal where orcamento_id = ? and cargo_id = ? and lotacao_id = ? {$where_existe}", [$orc_id, $value->cargo_id, $value->lotacao_id]);
                        
                        if(count($existe) > 0){
                            continue;
                        }

                        $sal_med = DB::select("SELECT 
                        CASE (select count(*) from tbl_funcionario where cargo_id = (select cargo_id from tbl_orc_cargo where id = ?) and lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = {$value->lotacao_id}) and dat_demis_func is null)
                            when 0 then (select salario_min from tbl_cargo where id = (select cargo_id from tbl_orc_cargo where id = ?))
                            else (select avg(salario) sal_med from tbl_funcionario where cargo_id = (select cargo_id from tbl_orc_cargo where id = ?) and lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = {$value->lotacao_id}) and dat_demis_func is null) end sal_med", [$value->cargo_id, $value->cargo_id, $value->cargo_id]);
                    
                        $sal_med = count($sal_med) > 0 ? $sal_med[0]->sal_med : $value->sal_min;

                        $insal_per = DB::select("SELECT periculosidade, insalubridade from tbl_cargos_area as ca
                            inner join tbl_orc_lotacao as olot on olot.lotacao_id = ca.lotacao_id and olot.cc_custo_id = ca.ccusto_id
                            where cargo_id = {$value->cargo_id_b} and olot.id = {$value->lotacao_id}");
                        $insal = 0;
                        $peric = 0;
                        
                        if(count($insal_per) > 0){
                            $insal = $insal_per[0]->insalubridade;
                            $peric = $insal_per[0]->periculosidade;
                        }
                        
                        $insert = DB::insert("INSERT INTO tbl_orc_cargos_area_sal(orcamento_id, cargo_id, lotacao_id, sal_base,
                            sal_maior, sal_med, sal_menor, empresa_id, ccusto_id, created_at, created_by, tipo_table, periodo, periculosidade, insalubridade) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                            [$orc_id, $value->cargo_id, $value->lotacao_id, $value->sal_base, $value->sal_max, $sal_med, $value->sal_min,
                            $value->empresa_id, $value->ccusto_id, $this->fillCriadoEm(), $this->fillCriadoPor(), $tipo_table, $periodo, $peric, $insal]
                        );

                        if($insert === false){
                            $this->setError("Falha ao inserir novo(s) Cargo(s) x Lotação. Erro: 251120201158");
                            return false;
                        }

                        $select_insert = DB::select("SELECT id FROM tbl_orc_cargos_area_sal WHERE orcamento_id = ? and cargo_id = ? and lotacao_id = ? {$condicao2[2]}", [$orc_id, $value->cargo_id, $value->lotacao_id]);

                        $insert_calc = DB::insert("INSERT INTO [tbl_calc_orcamento]([origem_id], [tbl_origem], [jan_orcado], [fev_orcado]
                            ,[mar_orcado], [abr_orcado], [mai_orcado], [jun_orcado], [jul_orcado], [ago_orcado], [set_orcado], [out_orcado]
                            ,[nov_orcado], [dez_orcado], [user_id], [empresa_id], [created_at], [created_by]) VALUES (
                            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 
                            [$select_insert[0]->id, 'tbl_orc_cargos_area_sal', $sal_med, $sal_med, $sal_med, $sal_med, 
                            $sal_med, $sal_med, $sal_med, $sal_med, $sal_med, $sal_med, 
                            $sal_med, $sal_med, $this->fillIdUser(), $this->fillCodEmpresa(), $this->fillCriadoEm(), $this->fillCriadoPor()]
                        );

                        if($insert_calc === false){
                            $this->setError("Falha ao inserir registro. Erro: 291220200920");
                            return false;
                        }
                        DB::commit();
                    }
                    catch(\Exception $e){
                        DB::rollBack();
                        $this->setError("Erro ao inserir novos dados. Erro: 291220200859 ".$e);
                        return false;
                    }
                }
            }            
            DB::commit();
            return true;
        // }
    }

    public function atualizaSalario($orc_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(700);
        $condicao[0] = $tipo_table == 'F' ? " and oc.periodo = '{$periodo}' and oc.tipo_table = '{$tipo_table}' " : " and oc.periodo is null and oc.tipo_table = '{$tipo_table}' ";
        $condicao[1] = $tipo_table == 'F' ? " and oca.periodo = '{$periodo}' and oca.tipo_table = '{$tipo_table}' " : " and oca.periodo is null and oca.tipo_table = '{$tipo_table}' ";
        $condicao[2] = $tipo_table == 'F' ? " and periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : " and periodo is null and tipo_table = '{$tipo_table}' ";

        $select = DB::select("SELECT oca.cargo_id, c.salario_max, c.salario_min from tbl_orc_cargos_area_sal as oca
            inner join tbl_orc_cargo as oc on oc.id = oca.cargo_id and oc.orcamento_id = {$orc_id} ".$condicao[0]."
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where oca.orcamento_id = {$orc_id}".$condicao[1]
        );
        
        foreach($select as $value){
            try{
                $update = DB::update("UPDATE tbl_orc_cargos_area_sal set sal_maior = ?, sal_menor = ?, updated_at = getdate(), updated_by = {$this->fillModificadoPor()} where orcamento_id = ? and cargo_id = ?".$condicao[2], [$value->salario_max, $value->salario_min, $orc_id, $value->cargo_id]
                );

                if($update === false){
                    $this->setError("Falha ao atualizar salários. Erro: 011220201606");
                    continue;
                    // return false;
                }
            }
            catch(\Exception $e){
                $this->setError("Erro ao atualizar salário. Erro: 011220201602ct ".$e->getMessage());
                return false;
            }
        }

        try{
            $update_calc = DB::update("UPDATE tbl_calc_orcamento set updated_at = getdate(), updated_by = {$this->fillModificadoPor()} where tbl_origem = 'tbl_orc_cargos_area_sal' and origem_id in (
                select id from tbl_orc_cargos_area_sal where orcamento_id = $orc_id {$condicao[2]}
            )");

            if($update_calc === false){
                $this->setError("Falha ao atualizar salários. Erro: 260420210947");
                return false;
            }
        }
        catch(\Exception $e){
            $this->setError("Erro ao atualizar salário. Erro: 260420210945 ".$e->getMessage());
            return false;
        }
        return true;
    }
}
