<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\DB as FacadesDB;

class RepoOrcNaturezaEvento extends RepositoryNat51
{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcNaturezaEvento'; 
    protected $form_rules = [];
    protected $rules_msg = [];

    public function inserir($dados){
        $dados['natureza_has_id'] = tirarAcentos($dados['natureza_has_id']);
        $query = $this->getModelEntity()->where([
            [$this->getModelEntity()->getColunaAlias('cod_natureza'), '=', $dados['cod_natureza']],
            [$this->getModelEntity()->getColunaAlias('evento_id'), '=', $dados['evento_id']],
            [$this->getModelEntity()->getColunaAlias('empresa_id'), '=', $dados['empresa_id']],
            [$this->getModelEntity()->getColunaAlias('orc_id'), '=', $dados['orc_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'), '=', $dados['tipo_table']]
        ]);
        
        $select = null;
        if($dados['tipo_table'] == 'F'){
            $select = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $dados['periodo'])->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }
        
        if(count($select) > 0){
            $this->setError("Registro já existente.<br>Erro: 290620200923");
            return false;
        }
        
        $inserir = $this->create($dados);
        if(!$inserir){
            $this->setError("Falha ao inserir registro.<br>Erro: 290620200925");
            return false;
        }
        return true;
    }
    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_evento = new Eventos();
        $tbl_usuario = new Usuario();

        $query = $this->getModelEntity()
        ->leftJoin( $tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('orc_id'),
            $this->getModelEntity()->getColunaAlias('natureza_has_id'),
            $this->getModelEntity()->getColunaAlias('evento_id'),
            $this->getModelEntity()->getColunaAlias('cod_natureza'),
            $this->getModelEntity()->getColunaAlias('natureza_id'),
            $this->getModelEntity()->getColunaAlias('cdn_event'),
            $this->getModelEntity()->getColunaAlias('multiplica'),
            $this->getModelEntity()->getColunaAlias('dt_base_admissao_ini'),
            $this->getModelEntity()->getColunaAlias('dt_base_admissao_fim'),
            $tbl_evento->getColunaAlias('des_event'),

            DB::raw("CONCAT({$this->getModelEntity()->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as description"),
            DB::raw("CONCAT({$this->getModelEntity()->getColunaAlias('cod_natureza')}, ' - ', {$this->getModelEntity()->getColunaAlias('natureza_has_id')}) as description_natureza"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('dt_base_admissao_ini')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('dt_base_admissao_ini')}, 'dd/MM/yyyy') ELSE '-' END as dt_base_admissao_ini_description"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('dt_base_admissao_fim')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('dt_base_admissao_fim')}, 'dd/MM/yyyy') ELSE '-' END as dt_base_admissao_fim_description"),

            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
        )
        ->where($this->getModelEntity()->getColunaAlias('orc_id'), $orc_id)
        ->where($this->getModelEntity()->getColunaAlias('tipo_table'), $tipo_table);

        $select = null;
        if($tipo_table == 'F'){
            $select = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $select = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }

        // for($i = 0; $i < count($select); $i++){
        //     $select[$i]['description'] = $select[$i]['cdn_event'].' - '.$select[$i]['des_event'];
        //     $select[$i]['description_natureza'] = $select[$i]['cod_natureza'].' - '.$select[$i]['natureza_has_id'];
        //     $select[$i]['dt_base_admissao_ini_description'] = $this->formataData($select[$i], 'dt_base_admissao_ini');
        //     $select[$i]['dt_base_admissao_fim_description'] = $this->formataData($select[$i], 'dt_base_admissao_fim');
        // }
        return $select;
    }
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
    public function deletar($dados){
        $deletar = $this->delete($dados['id']);
        if(!$deletar){
            $this->setError("Falha ao deletar registro. Erro:020720201454");
            return false;
        }
        return true;
    }
    public function atualizar($dados){
        $data = Arr::except($dados,['dt_base_admissao_ini_description','dt_base_admissao_fim_description','description','empresa_id']);
        $data['multiplica'] = monetarioVirgula($data['multiplica']);
        
        $update = $this->update($data, $data['id']);
        if(!$update){
            $this->setError("Falha ao atualizar registro. Erro: 020720201638");
            return false;
        }
        return true;
    }
    public function listToPickList(){
        $tbl_evento = new Eventos();
        $tbl_natureza_evento = new NaturezaEvento();
        $data = $tbl_evento->select()->orderBy('des_event')
        ->join($tbl_natureza_evento->getTable(), $tbl_evento->getColunaAlias('id'), $tbl_natureza_evento->getColunaAlias('eventos_id'))
        ->select(
            $tbl_evento->getColunaAlias('multiplica'),
            $tbl_evento->getColunaAlias('id'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            DB::raw("CONCAT({$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')}) as description")
        )
        // ->where([
        //     [$tbl_natureza_evento->getColunaAlias('base_calc_orcamento'),'=',1]
        // ])
        ->get()->toArray();
        
        return $data;
    }

    public function repopulate($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->clearError();
        set_time_limit(700);
        $condicao = $tipo_table == 'F' ? " and octe.tipo_table = '{$tipo_table}' and octe.periodo = '{$periodo}'" : " and octe.tipo_table = '{$tipo_table}' and octe.periodo is null";

        $select = DB::select("SELECT {$orc_id} as orc_id, replace(cta.desc_cta_ctbl, ' ', '_') as natureza_has_id,
            cte.eventos_id as evento_id, e.cdn_event, e.multiplica, e.dt_base_admissao_ini,
            e.dt_base_admissao_fim, cta.cod_cta_ctbl as cod_natureza, cta.id as natureza_id,
            getdate() as created_at, ? as tipo_table
            
            from tbl_cta_contabil_vs_eventos as cte
            
            inner join tbl_eventos as e on e.id = cte.eventos_id
            inner join tbl_cta_contabil as cta on cta.id = cte.cta_contabil_id
            
            where cte.base_calc_orcamento = 1 and (select count(*) from tbl_orc_natureza_eventos octe where orc_id = {$orc_id} and octe.evento_id = cte.eventos_id and octe.cod_natureza = cta.cod_cta_ctbl".$condicao.") = 0"
        , [$tipo_table]);
        
        if(count($select) == 0){
            $this->setError("Nenhum dado para ser inserido. 011220201305");
            return 'warning';
        }
        else{
            foreach($select as $value){
                try{
                    $value->natureza_has_id = tirarAcentos($value->natureza_has_id);
                    $value = (array) $value;
                    if($tipo_table == 'F'){
                        $value['periodo'] = $periodo;
                    }
                    $value['created_at'] = $this->fillModificadoEm();
                    $value['created_by'] = $this->fillModificadoPor();

                    $insert = $this->create($value);
                    if($insert === false){
                        $this->setError("Falha ao inserir registro. Erro: 011220201318");
                        return false;
                    }
                }
                catch(\Exception $e){
                    DB::rollBack();
                    $this->setError("Erro ao inserir registro. Erro: 011220201319ct ".$e->getMessage());
                    return false;
                }
            }
            return true;
        }

    }

    public function repopulateAll($orc_id, $periodo = null, $tipo_table = 'O'){
        $condicao = $tipo_table == 'F' ? " and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' " : " and tipo_table = '{$tipo_table}' and periodo is null";
        
        $select = DB::select("SELECT replace(ct.desc_cta_ctbl, ' ', '_') as desc_natureza, cta_e.eventos_id as evento_id, e.cdn_event, e.multiplica, e.dt_base_admissao_ini, e.dt_base_admissao_fim,
            cta_e.empresa_id, ct.cod_cta_ctbl as cod_natureza, ct.id as natureza_id
            FROM tbl_cta_contabil_vs_eventos as cta_e
            inner join tbl_eventos as e on e.id = cta_e.eventos_id
            inner join tbl_cta_contabil as ct on ct.id = cta_e.cta_contabil_id
            where cta_e.base_calc_orcamento = 1"
        );
        
        foreach($select as $value){
            try{
                
                $existe = DB::select("SELECT * from tbl_orc_natureza_eventos where orc_id = {$orc_id} and natureza_id = ? and evento_id = ?".$condicao,
                    [$value->natureza_id, $value->evento_id]
                );
                
                if(count($existe) != 0){
                    $update = DB::update("UPDATE tbl_orc_natureza_eventos set cod_natureza = {$value->cod_natureza}, multiplica = ?, dt_base_admissao_ini = ?, dt_base_admissao_fim = ?, updated_by = ?, updated_at = getdate() where orc_id = {$orc_id} and natureza_id = {$value->natureza_id} and evento_id = {$value->evento_id}".$condicao, [$value->multiplica, $value->dt_base_admissao_ini, $value->dt_base_admissao_fim, $this->fillModificadoPor()]);

                    if($update === false){
                        $this->setError("Falha ao atualizar. Erro: 021220201031");
                        return false;
                    }
                }
                else{
                    $dados = array('orc_id'=>$orc_id, 'natureza_has_id'=>tirarAcentos($value->desc_natureza), 'evento_id'=>$value->evento_id, 'cdn_event'=>$value->cdn_event, 'multiplica'=>$value->multiplica, 'dt_base_admissao_ini'=>$value->dt_base_admissao_ini, 'dt_base_admissao_fim'=>$value->dt_base_admissao_fim, 'created_at'=>$this->fillCriadoEm(), 'empresa_id'=>$value->empresa_id, 'cod_natureza'=>$value->cod_natureza, 'natureza_id'=>$value->natureza_id, 'created_by'=>$this->fillCriadoPor(), 'tipo_table'=>$tipo_table);

                    if($tipo_table == 'F'){
                        $dados['periodo'] = $periodo;
                    }
                    $inserir = $this->create($dados);

                    if(!$inserir){
                        $this->setError("Falha ao inserir registro. Erro: 021220201029");
                        return false;
                    }
                }
            }
            catch(\Exception $e){
                $this->setError("Erro ao repopular. Erro: 021220201030ct ".$e->getMessage());
                return false;
            }
        }
        return true;
            
    }
}