<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\OrcParamNaturezaEventoAd;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Http\Controllers\OrcParamNaturezaEventoAdController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcParamNatureza extends RepositoryNat51
{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcParamNatureza'; 
    protected $form_rules = [];
    protected $rules_msg = [];

    public function listarAll($orc_id){

        $tbl_evento = new Eventos();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();
        $select = $this->getModelEntity()
        
        ->leftJoin($tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('evento_principal_id'), $tbl_evento->getColunaAlias('id'))
        ->leftJoin($tbl_cta_ctb->getTable(), $this->getModelEntity()->getColunaAlias('cta_contabil_id'), $tbl_cta_ctb->getColunaAlias('id'))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('evento_principal_id'),
            $this->getModelEntity()->getColunaAlias('cta_contabil_id'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $this->getModelEntity()->getColunaAlias('hash_id'),
            $this->getModelEntity()->getColunaAlias('ordem_execucao'),
            //DB::raw("MAX({$this->getModelEntity()->getColunaAlias('ordem_execucao')}) as ordem_execucao_max"),
            $this->getModelEntity()->getColunaAlias('handle_sql'),
            $this->getModelEntity()->getColunaAlias('handle_arguments'),
            $this->getModelEntity()->getColunaAlias('created_at'),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('updated_at'),
            $this->getModelEntity()->getColunaAlias('modify_by'),
            $this->getModelEntity()->getColunaAlias('base_recisao'),
            $this->getModelEntity()->getColunaAlias('usa_eventos_adicionais'),
            DB::raw("CASE {$this->getModelEntity()->getColunaAlias('base_recisao')} 
            WHEN 1 THEN 'Sim'
            WHEN 0 THEN 'Não'
            ELSE '-'
            END as des_base_recisao"),
            DB::raw("CASE {$this->getModelEntity()->getColunaAlias('usa_eventos_adicionais')} 
            WHEN 1 THEN 'Sim'
            WHEN 0 THEN 'Não'
            ELSE '-'
            END as des_usa_eventos_adicionais"),

            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),
            
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")

        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'),$orc_id)
        ->orderBy($this->getModelEntity()->getColunaAlias('ordem_execucao'),'asc')
        ->get()->toArray();
        
        for($i = 0; $i < count($select); $i++){
            $select[$i]['description_evento'] = $select[$i]['cdn_event'].' - '.$select[$i]['des_event'];
            $select[$i]['description_cta_ctb'] = $select[$i]['cod_cta_ctbl'].' - '.$select[$i]['desc_cta_ctbl'];
            $select[$i]['atualizado_data'] = formataData($select[$i]['updated_at']);
            //$select[$i]['criado_data'] = formataData($select[$i]['created_at']);

        }
        
        return $select;
    }
    public function inserirParamNatureza(array $dados){
        
        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('hash_id'),'=',$dados['hash_id']],
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('cta_contabil_id'),'=',$dados['cta_contabil_id']],
            [$this->getModelEntity()->getColunaAlias('evento_principal_id'),'=',$dados['evento_principal_id']],
        ])->get()->toArray();
        
        if(count($select) != 0){
            $this->setError('Registro já existente.<br>Erro: 080620201452');
            return false;
        }
        
        $inserir = $this->create($dados);
        
        if(!$inserir){
            $this->setError('Falha ao inserir registro.<br>Erro: 080620201500');
            return false;
        }
        return true;
    }
    public function deletarParamNatureza($dados){
        
        $tbl_param_natureza = $this->getModelEntity();
        $tbl_param_natureza_evento_ad = new OrcParamNaturezaEventoAd();
        $tente_deletar = $tbl_param_natureza_evento_ad
            ->select()->where('orc_param_natureza_id',$dados['id'])->get()->toArray();
        if(count($tente_deletar) > 0){
            $this->setError("Registro não pode ser deletado, pois está vinculado a tela \"Natureza por Eventos Adicionais\".<br>Erro: 180720201508");
            return false;
        }
        try{
            $delete = $tbl_param_natureza->where([
                [$tbl_param_natureza->getColunaAlias('evento_principal_id'),'=',$dados['evento_principal_id']],
                [$tbl_param_natureza->getColunaAlias('cta_contabil_id'),'=',$dados['cta_contabil_id']],
                [$tbl_param_natureza->getColunaAlias('orcamento_id'),'=',$dados['orcamento_id']],
                [$tbl_param_natureza->getColunaAlias('hash_id'),'=',$dados['hash_id']],
            ])->delete();

            if(!$delete){
                $this->setError("Falha ao deletar registro.<br>Erro: 090620200958");
                return false;
            }
            return true;

        }catch(\Exception $e){
            abort(500,'Falha ao deletar registro'.$e);
            return false;
        }
    }
    public function inserirSequenciaExecucao($dados){
        
        for($i = 0; $i < count($dados); $i++){
            try{
                $ordem_execucao = $dados[$i]['ordem_execucao'];
                
                $update = DB::table('tbl_orc_param_natureza')->where('id',$dados[$i]['id'])
                ->update(['ordem_execucao'=>$ordem_execucao, 'updated_at'=>$this->fillModificadoEm(), 'updated_by'=>$this->fillModificadoPor()]);

                if(!$update){
                    $this->setError("Falha ao inserir a sêquencia de numero ".($i+1));
                    return false;
                    
                }
            }
            catch(\Exception $e){
                $this->setError($e);
            }            
        }
        return true;
    }
    public function listarToSequencia($orc_id){
        
        $tbl_evento = new Eventos();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_natureza_evento = new NaturezaEvento();
        $select = $this->getModelEntity()
        
        ->leftJoin($tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('evento_principal_id'), $tbl_evento->getColunaAlias('id'))
        ->leftJoin($tbl_cta_ctb->getTable(), $this->getModelEntity()->getColunaAlias('cta_contabil_id'), $tbl_cta_ctb->getColunaAlias('id'))
        //->leftJoin($tbl_natureza_evento->getTable(), $this->getModelEntity()->getColunaAlias('cta_contabil_id'), $tbl_natureza_evento->getColunaAlias('cta_contabil_id'))

        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('evento_principal_id'),
            $this->getModelEntity()->getColunaAlias('cta_contabil_id'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $this->getModelEntity()->getColunaAlias('hash_id'),
            $this->getModelEntity()->getColunaAlias('ordem_execucao'),
            $this->getModelEntity()->getColunaAlias('handle_sql'),
            $this->getModelEntity()->getColunaAlias('handle_arguments'),
            $this->getModelEntity()->getColunaAlias('created_at'),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('updated_at'),
            $this->getModelEntity()->getColunaAlias('modify_by'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl')

        )
        ->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), '=', $orc_id]
            //[$tbl_natureza_evento->getColunaAlias('base_calc_orcamento'), '=', 1]
        ])
        ->orderByRaw($this->getModelEntity()->getColunaAlias('ordem_execucao').' , '.$tbl_cta_ctb->getColunaAlias('cod_cta_ctbl').' ASC')
        ->get()->toArray();

        return $select;
    }
    public function updateBaseRecisao($dados){
        $update = $this->update($dados, $dados['id']);
        if(!$update){
            $this->setError("Falha ao atualizar o registro. Erro: 150820201627");
            return false;
        }
        return true;
    }
    public function updateEvtAdc($dados){
        $update = $this->update($dados, $dados['id']);
        if(!$update){
            $this->setError("Falha ao atualizar o registro. Erro: 150820201627");
            return false;
        }
        return true;
    }

    // public function usaEventoAdc(){
    //     $tbl_opnea = new OrcParamNaturezaEventoAd;

        

    // }


} 