<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcParamNatureza;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;


class RepoOrcParamNaturezaEventoAd extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcParamNaturezaEventoAd';
    protected $form_rules=[];
    protected $rules_msg=[]; 

    public function listarOrcParamNatureza($orc_id){
        $tbl_param_natureza = new OrcParamNatureza();
        $tbl_evento = new Eventos();

        $select = $tbl_param_natureza
        
        ->join($tbl_evento->getTable(), $tbl_param_natureza->getColunaAlias('evento_principal_id'), $tbl_evento->getColunaAlias('id'))
        ->select(
            DB::raw("{$tbl_evento->getColunaAlias('id')} as evento_id"),
            $tbl_param_natureza->getColunaAlias('hash_id'),
            $tbl_param_natureza->getColunaAlias('empresa_id'),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event')
        )->where($tbl_param_natureza->getColunaAlias('orcamento_id'),$orc_id)
        ->get()->toArray();

        for($i = 0; $i < count($select); $i++){
            $select[$i]['description'] = $select[$i]['cdn_event'].' - '.$select[$i]['des_event'];
        }
        return $select;
    }
    public function listarAll($orc_id){
        $tbl_evento = new Eventos();
        $tbl_orc_param_natureza = new OrcParamNatureza();
        $tbl_ctactb = new ContaContabil();
        $select = $this->getModelEntity()
        ->leftJoin($tbl_evento->getTable(), $this->getModelEntity()->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))
        ->leftJoin($tbl_orc_param_natureza->getTable(), $this->getModelEntity()->getColunaAlias('orc_param_natureza_id'), $tbl_orc_param_natureza->getColunaAlias('id'))
        ->leftJoin($tbl_ctactb->getTable(), $tbl_orc_param_natureza->getColunaAlias('cta_contabil_id'), $tbl_ctactb->getColunaAlias('id'))
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('evento_id'),
            $this->getModelEntity()->getColunaAlias('orc_param_natureza_id'),
            $this->getModelEntity()->getColunaAlias('cod_evento'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            DB::raw("CONCAT( {$this->getModelEntity()->getColunaAlias('cod_evento')}, ' - ', {$tbl_evento->getColunaAlias('des_event')} ) as description"),
            $tbl_ctactb->getColunaAlias('desc_cta_ctbl'),
            $tbl_ctactb->getColunaAlias('cod_cta_ctbl'),
            DB::raw("CONCAT( {$tbl_ctactb->getColunaAlias('cod_cta_ctbl')}, ' - ', {$tbl_ctactb->getColunaAlias('desc_cta_ctbl')} ) as description_conta"),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_orc_param_natureza->getColunaAlias('hash_id')
        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'),$orc_id)
        ->get()->toArray();
        return $select;
    }
    public function insertDados($dados, $empresa_id){
        $orcParamNatureza = new OrcParamNatureza();
        $select = $this->getModelEntity()->select()
        ->where([
            [$this->getModelEntity()->getColunaAlias('evento_id'), $dados['evento_id']],
            [$this->getModelEntity()->getColunaAlias('empresa_id'), $empresa_id],
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $dados['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('orc_param_natureza_id'), $dados['orc_param_natureza_id']]
        ])->get()->toArray();
        if(count($select) > 0){
            $this->setError("Registro já existente. Erro: 220620201100");
            return false; 
        }
        $inserir = $this->create($dados);
        if(!$inserir){
            $this->setError("Falha ao inserir registro. Erro: 220620201057");
            return false;
        }
        $opne = $orcParamNatureza->find($dados['orc_param_natureza_id']);
        $opne->usa_eventos_adicionais = 1;
        $opne->save();
       
        return true;
    
    }
    public function deleteDados($id){
        // $delete = $this->delete($id);
        $delete = DB::table('tbl_orc_param_natureza_eventos_adicionais')->where('id','=',$id)->delete();
        if(!$delete){
            $this->setError("Falha ao deletar registro. Erro: 220620201127");
            return false;
        }
        return true;
    }
    public function updateDados($dados){

        $update = $this->update($dados,$dados['id']);
        if(!$update){
            $this->setError("Falha ao atualizar registro. Erro: 220620201129");
            return false;
        }
       
        return true;
    }
    public function eventosParamNatureza($orc_id){
        $tbl_evento = new Eventos();
        $tbl_para_natureza = new OrcParamNatureza();
        $select = $tbl_para_natureza
        ->leftJoin($tbl_evento->getTable(), $tbl_para_natureza->getColunaAlias('evento_principal_id'), $tbl_evento->getColunaAlias('id'))
        ->select(
            $tbl_evento->getColunaAlias('id'),
            $tbl_evento->getColunaAlias('cdn_event'),
            DB::raw("CONCAT( {$tbl_evento->getColunaAlias('cdn_event')}, ' - ', {$tbl_evento->getColunaAlias('des_event')} ) as description")
        )
        ->where($tbl_para_natureza->getColunaAlias('orcamento_id'),$orc_id)
        ->distinct()
        ->get()->toArray();

        return $select;
    }
}