<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCadastroParametros;
use App\Modules\Natureza51\Entities\OrcParametros;
use App\Modules\Natureza51\Entities\CadastroParametros;
use App\Modules\Natureza51\Entities\Parametros;
use Illuminate\Support\Facades\DB;

class RepoOrcParametros extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcParametros';
    protected $form_rules=[
        'parametro_id'=>'required',
        'orcamento_id'=>'required',
        'valor_parametro'=>'required'
    ];
    protected $rules_msg=[
        'parametro_id.required'     =>'Informe um parâmetro para continuar!',
        'orcamento_id.required'     =>'Informe um orçamento para continuar!',
        'valor_parametro.required'  =>'Informe o valor do parâmetro para continuar!',
    ]; 

    public function __construct()
    {
        parent::__construct();
    }


    public function getOrcParams($orc_id){
        $parametrosOrcamento = OrcParametros::with([
            'getParametro'=>function($query){
                return $query->with([
                    'getParametrosOptions'=>function($query){
        
                    }
                ]);
            }
        ])->where('orcamento_id', $orc_id)->get()->toArray();  

        $params_retorno = [];
        foreach ($parametrosOrcamento as $paramOrc) {            
            $paramOrc['descricao'] = $paramOrc['get_parametro']['descricao'];
            $paramOrc['tipo_dados'] = $paramOrc['get_parametro']['tipo_dados'];
            $paramOrc['getParametrosOptions'] = $paramOrc['get_parametro']['get_parametros_options'];
            $paramOrc['cod_param'] = $paramOrc['get_parametro']['cod_parametro'];
            unset($paramOrc['get_parametro']);
            array_push($params_retorno, $paramOrc);
        }
        // return $params_retorno;

        // $params_retorno = usort($params_retorno, function($a, $b) {
        //     return $a['descricao'] <=> $b['descricao'];
        // });
        usort($params_retorno, function($a, $b) {
            return $a['descricao'] <=> $b['descricao'];
        });
        
        
// dd("kjwbnfjkcnwkvcnwkvnweklv0", $params_retorno);

        return $this->tratarOptions($params_retorno);
	}

	public function tratarOptions($data){
        $retorno = [];
			foreach ($data as $param) {
					$lista = [];
					foreach ($param['getParametrosOptions'] as $option) {                        
						array_push($lista,$option['opcao']);
                    }			
                    $param['lista']	= implode(';', $lista);
                    unset($param['getParametrosOptions']);

                    if($param['tipo_dados'] == 8){
                        $param['valor_parametro'] = $param['valor_parametro'] == 1 ? true : false;
                    }

                    array_push($retorno,$param);
            }            
        return $retorno;
	}


    public function salvarParametros($parametros){
        $table = $this->getModelEntity()->getTable();
        // dd('daskjdhsakjd', $parametros);

        $cases = [];
        $ids = [];
        $params = [];
        unset($parametros['_token']);

        foreach ($parametros as $parametro) {
            if($parametro['tipo_dados'] == 8){
                $parametro['valor_parametro'] = $parametro['valor_parametro'] == true ? 1 : 0;
            }

            $id = (int) $parametro['id'];
            $cases[] = "WHEN {$id} then CAST (? as varchar)";
            $params[] = $parametro['valor_parametro'];
            $ids[] = $id;
        }

        $ids = implode(',', $ids);
        $cases = implode(' ', $cases);
  
        return DB::update("UPDATE {$table} SET valor_parametro = CASE id {$cases} END WHERE id in ({$ids})", $params);

    }

    public function parametroAuditoria($orc_id){
        
        if($this->getUserFromCurrentGuard()->tipo != 4){
            return 'true';
        }

        $param = new Parametros();
        $select = $param
        //->join($param->getTable(), $this->getModelEntity()->getColunaAlias('parametro_id'), $param->getColunaAlias('id'))
        ->select('*')->where(
            //['orcamento_id', $orc_id],
            'cod_parametro', 'CMPAUD'
        )->get()->toArray();
        
        if(count($select) > 0){
            return $select[0]['valor_default'] == 0 ? 'false' : 'true';
        }
        else{
            return 'false';
        }
    }
    
}
