<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcPpr;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use Illuminate\Support\Facades\DB;

class RepoOrcPpr extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcPpr';
    protected $form_rules=[];
    protected $rules_msg=[]; 


    public function listar($orc_id, $periodo = null, $tipo_table = 'O'){
        $condicao[0] = $tipo_table == 'F' ? " and oppr.tipo_table = '{$tipo_table}' and oppr.periodo = '{$periodo}'" : " and oppr.tipo_table = '{$tipo_table}' and oppr.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $data = DB::select("SELECT
            oppr.id as id,
            ol.id as orc_lotacao_id,
            concat(cc.cod_ccusto, ' - ', l.unid_lotac, ' - ', l.des_unid_lotac) as lotacao,
            LEFT(c.cod_cargo_basic, 2) as grade_sal,
            ol.cc_custo_id+null as parent,
            c.des_cargo_basic as cargo,
            c.cod_cargo_basic as cod_cargo,
            oppr.num_sal,
            oppr.mes_base,

            CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,
            CASE WHEN oppr.created_at IS NOT NULL THEN format(oppr.created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,
            
            CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por,
            CASE WHEN oppr.updated_at IS NOT NULL THEN format(oppr.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em
    
            from tbl_orc_ppr as oppr
            join tbl_orc_cargo oc on oc.id = oppr.cargo_id {$condicao[1]}
            join tbl_cargo c on c.id = oc.cargo_id
            join tbl_orc_lotacao ol on ol.id = oppr.orc_lot_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            join tbl_ccusto cc on cc.id = ol.cc_custo_id

            left join institb_usuario as usuario1 on usuario1.id = oppr.created_by
            left join institb_usuario as usuario2 on usuario2.id = oppr.updated_by
            where ol.orcamento_id = $orc_id {$condicao[0]}
            order by c.cod_cargo_basic ASC"
        );
        
        return $data;
    } 
    

    public function updateBonus($orc_id, $data){
      
        
        DB::beginTransaction();
       
        try{
            
            
            $data_update = [
                'mes_base'=>$data['mes_base'],
                'num_sal'=>$data['num_sal'],
            ];                   
            
            if(!$this->update($data_update, ['id'=>$data['id']])){ 
                $this->setError('Falha ao fazer update do registro. Erro: 080120202008 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;                        
            }
                
               
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 210520200825.');
        }
        
        return array('msg'=>"Registro atualizado com Sucesso",'status'=>"success");
    }

    public function deletePpr($orc_id, $data){
        $instance = $this;

        $result = OrcPpr::where([
            ['id', $data['id']],
            ['orc_id', $orc_id]
        ])->first();
        
        if(is_null($result)){
            $this->setError('Este registro não existe no orçamento. Erro: 250520201006 ');            
            return false;
        }

        DB::beginTransaction();
       
        try{
            
            if(!$instance->delete($data['id'])){  
                $this->setError('Falha ao deletar o registro. Erro: 250520201007 ' .$this->getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (\Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 250520201008.');
        }
        
        return array('msg'=>"Registro deletado com sucesso",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    
    public function delete($id) {
        /**
         * @TODO 
         * Aluisio Ferreira de Sousa 26/08/2019
         * Passar para um metodo a verificação se a chave é composta. E tratamento 
         * Tem que criar um metodo igual ao keysCombine do controller
         * O Mesmo se aplica ao metodo update
         */
        
        $result =$this->getModelInstance()->find($id);
        if(empty($result)){
            $this->setError("Registro não localizado . error: 190920191844");
            return false;
        }
        try{
            $result->delete();
            
            goto saida;
        }
        catch(\Exception $e){
            $this->setError("Registro não pode ser excluido. error: 200120201139");
            return false;    
            
        }
        
        saida:
        $this->makeModel();
        return true;
    }

    public function atualizaPr($orc_id, $periodo = null, $tipo_table = 'O'){
        /*
            PEGAR TODOS OS CARGOS QUE NÃO EXISTEM NA TELA DE PPR
        */
        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}' " : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}' " : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
        $condicao[2] = $tipo_table == 'F' ? " and ppr.tipo_table = '{$tipo_table}' and ppr.periodo = '{$periodo}' " : " and ppr.tipo_table = '{$tipo_table}' and ppr.periodo is null";

        $this->clearError();
        $this->setError('');
        $select = DB::select("SELECT ocas.cargo_id as orc_cargo_id, ocas.lotacao_id,
            substring(cast(c.cod_cargo_basic as varchar), 1, 2) as grade
            from tbl_orc_cargos_area_sal as ocas
            
            inner join tbl_orc_cargo as oc on oc.id = ocas.cargo_id and oc.orcamento_id = {$orc_id} {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
            
            where ocas.orcamento_id = {$orc_id} {$condicao[0]}
            and (select count(*) from tbl_orc_ppr as ppr where ppr.orc_id = {$orc_id} and ppr.orc_lot_id = ocas.lotacao_id and ppr.cargo_id = ocas.cargo_id {$condicao[2]}) = 0
            -- and ppr.orc_lot_id = ocas.lotacao_id
            order by c.cod_cargo_basic asc"
        );
        
        /*
            PROCURAR UM CARGO COM O MESMO GRADE NA PPR
        */

        if(count($select) == 0){
            $this->setError("Nenhum cargo encontrado. 261120201514");
            return 'warning';
        }
        else{
            try{
                foreach($select as $value){
                    $dados = $this->getOrcCargoByGrade($orc_id, $value->grade, $periodo, $tipo_table);
                    
                    if($dados == true){
                        
                        $insert = DB::insert("INSERT INTO tbl_orc_ppr(orc_id, cargo_id, orc_lot_id, num_sal, mes_base, created_at, created_by, tipo_table, periodo)values(?, ?, ?, ?, ?, ?, ?, ?, ?)", [$orc_id, $value->orc_cargo_id, $value->lotacao_id, $dados->num_sal, $dados->mes_base, $this->fillCriadoEm(), $this->fillCriadoPor(), $tipo_table, $periodo]
                        );

                        if($insert === false){
                            $this->setError("Falha ao inserir registro. Erro: 261120201542");
                            return false;
                        }
                    }
                    continue;
                }
            }
            catch(\Exception $e){
                DB::rollBack();
                $this->setError("Erro ao inserir registro. Erro: 261120201543ct ", $e);
                return false;
            }
            return true;
        }
    }
    
    public function getOrcCargoByGrade($orc_id, $grade, $periodo = null, $tipo_table = 'O'){// PEGA O PRIMEIRO
        $condicao[0] = $tipo_table == 'F' ? " and ppr.tipo_table = '{$tipo_table}' and ppr.periodo = '{$periodo}'" : " and ppr.tipo_table = '{$tipo_table}' and ppr.periodo is null";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";

        $select = DB::select("SELECT top(1) ppr.* from tbl_orc_ppr as ppr

            inner join tbl_orc_cargo as oc on oc.id = ppr.cargo_id {$condicao[1]}
            inner join tbl_cargo as c on c.id = oc.cargo_id
            
            where oc.orcamento_id = {$orc_id} and SUBSTRING(cast(c.cod_cargo_basic as varchar), 1, 2) = {$grade}".$condicao[0]
        );

        return count($select) == 0 ? false : $select[0];
    }
}
