<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\Usuario;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcPromocao extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcPromocao';
    protected $form_rules=[
        'orc_id'=>'required',
        // 'lotacao_id'=>'required',
        'cargo_atual_id'=>'required',
        'cargo_promovido_id'=>'required',
        'funcionario_id'=>'required',
        // 'turma_atual_id'=>'required',
        'turma_promovida_id'=>'required',
        'ccusto_id'=>'required',
        'mes_promocao'=>'required',
        'lotacao_promovida_id'=>'required'
    ];
    protected $rules_msg=[
        'orc_id.required'=>'Selecione um orçamento para continuar!',
        'cargo_atual_id.required'=>'Selecione o cargo ancestral para continuar!',
        'cargo_promovido_id.required'=>'Selecione o cargo destino para continuar!',
        // 'turma_atual_id.required'=>'Selecione uma turma para continuar',
        'turma_promovida_id.required'=>'Selecione uma turma para continuar',
        'ccusto_id.required'=>'Selecione um centro de custo para continuar',
        'funcionario_id.required'=>'Selecione um funcionário para continuar!',
        'mes_promocao.required'=>'Selecione um mês para continuar!',
        'lotacao_promovida_id.required'=> 'Selecione uma lotação de destino para continuar!'
    ]; 

    public function __construct()
    {
        parent::__construct();
    }
    
    public function listar(){
        $tbl_lotacao = new Lotacao();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_orc_promo = new OrcPromocao();    
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_orc_cargo = new OrcCargosAreaSal();
        $tbl_cargo = new Cargo();
        $tbl_func = new Funcionario();
 
        $data = $tbl_orc_promo->join(
            $tbl_calc_orc->getTable(),
            $tbl_orc_promo->getColunaAlias('id'),'=',
            DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
            {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_promo->getTable()}'"))
            
            ->leftJoin(
                $tbl_func->getTable(),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),'=',$tbl_func->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_orc_lotacao->getTable(),
                $tbl_orc_promo->getColunaAlias('lotacao_promovida_id'),'=',   $tbl_orc_lotacao->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_lotacao->getTable(),
                $tbl_orc_lotacao->getColunaAlias('lotacao_id'),'=', $tbl_lotacao->getColunaAlias('id')
            )
            //
            ->select(
                $tbl_orc_promo->getColunaAlias('id'),
                $tbl_orc_promo->getColunaAlias('orc_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_ancestral_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_corrente_id'),
                $tbl_orc_promo->getColunaAlias('lotacao_id'),
                $tbl_orc_promo->getColunaAlias('cargo_atual_id'),
                $tbl_orc_promo->getColunaAlias('cargo_promovido_id'),
                $tbl_orc_promo->getColunaAlias('sub_promocao_id'),
                DB::raw($tbl_orc_promo->getColunaAlias('cargo_promovido_id').'+null as des_cargo_basic'),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),
                $tbl_func->getColunaAlias('nome_funcionario'),
                $tbl_orc_promo->getColunaAlias('lotacao_promovida_id'),
                // DB::raw($tbl_cargo->getColunaAlias('des_cargo_basic').' as des_cargo_basic_ancestral'),
                // 'c.des_cargo_basic as des_cargo_basic_corrente',
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jan_orcado')}, 'N', 'pt-br') AS jan_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('fev_orcado')}, 'N', 'pt-br') AS fev_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mar_orcado')}, 'N', 'pt-br') AS mar_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('abr_orcado')}, 'N', 'pt-br') AS abr_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mai_orcado')}, 'N', 'pt-br') AS mai_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jun_orcado')}, 'N', 'pt-br') AS jun_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jul_orcado')}, 'N', 'pt-br') AS jul_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('ago_orcado')}, 'N', 'pt-br') AS ago_orcado"), 
                DB::raw("format({$tbl_calc_orc->getColunaAlias('set_orcado')}, 'N', 'pt-br') AS set_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('out_orcado')}, 'N', 'pt-br') AS out_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('nov_orcado')}, 'N', 'pt-br') AS nov_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('dez_orcado')}, 'N', 'pt-br') AS dez_orcado"),

                DB::raw("CONCAT({$tbl_lotacao->getColunaAlias('unid_lotac')}, ' - ', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as description_lotacao_promovida")

            )->get()->toArray();

            // dd("data promocao", $data);
            return $data; 
            
    } 
    public function listarByLotacao($orc_id, $lotacao_id, $tipo_table, $periodo = null){
        
        $tbl_orc_promo = new OrcPromocao();    
        
        $where_periodo = $periodo == null ? '' : " and op.periodo = '{$periodo}'";
        
        DB::EnableQueryLog();
        
            $query = "            
            select op.[id], 
            op.[orc_id], 
            op.[lotacao_id], 
            op.[cargo_promovido_id], 
            op.[cargo_atual_id], 
            op.[turma_atual_id], 
            op.[turma_promovida_id], 
            op.[ccusto_id], 
            op.[mes_promocao], 
            op.[lotacao_promovida_id], 
            op.[tipo_table], 
            op.[sub_promocao_id],
            CASE op.lotacao_id
                WHEN $lotacao_id THEN '1'
                ELSE '1'
            END as lotacao_mostrar, 
            op.cargo_promovido_id as cargo_id, 
            op.[funcionario_id], 
            CONCAT(tbl_funcionario.cdn_funcionario, ' - ', tbl_funcionario.nome_funcionario) as nome_funcionario, 
            CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description_cargo,
            CONCAT(c_p.cod_cargo_basic, ' - ', c_p.des_cargo_basic) as description_cargo_promovido,
            CONCAT(t.cdn_turma_trab, ' - ', t.des_turma_trab, ' - ', turno.des_turno_trab, ' - ', turno.cdn_turno_trab) as description_turma,
            CONCAT(t_p.cdn_turma_trab, ' - ', t_p.des_turma_trab, ' - ', turno_p.des_turno_trab, ' - ', turno_p.cdn_turno_trab) as description_turma_promovido,
            CONCAT(l.unid_lotac, ' - ', l.des_unid_lotac) as description_lotacao,
            CONCAT(l_p.unid_lotac, ' - ', l_p.des_unid_lotac) as description_lotacao_promovida,
            CONCAT(cc.cod_ccusto, ' - ',cc.des_ccusto) as description_ccusto,
            CONCAT(cc_p.cod_ccusto, ' - ',cc.des_ccusto) as description_ccusto_promovida,
            CASE WHEN op.created_at IS NOT NULL 
                THEN format(op.created_at, 'dd/MM/yyyy') 
                ELSE '-' 
            END as criado_em, 
            CASE WHEN usuario1.nome IS NOT NULL 
                THEN usuario1.nome 
                ELSE '-' 
            END as criado_por, 
            CASE WHEN op.updated_at IS NOT NULL 
                THEN format(op.updated_at, 'dd/MM/yyyy') 
                ELSE '-' 
            END as atualizado_em, 
            CASE WHEN usuario2.nome IS NOT NULL 
                THEN usuario2.nome 
                ELSE '-' 
            END as atualizado_por,
            
            CASE mes_promocao
                
            WHEN 1 THEN 'Janeiro'
            WHEN 2 THEN 'Fevereiro'
            WHEN 3 THEN 'Março'
            WHEN 4 THEN 'Abril'
            WHEN 5 THEN 'Maio'
            WHEN 6 THEN 'Junho'
            WHEN 7 THEN 'Julho'
            WHEN 8 THEN 'Agosto'
            WHEN 9 THEN 'Setembro'
            WHEN 10 THEN 'Outubro'
            WHEN 11 THEN 'Novembro'
            WHEN 12 THEN 'Dezembro'
            
            END  as mes_promocao_desc
            
            from [tbl_orc_promocao] as op
            
            left join [tbl_funcionario] on op.[funcionario_id] = [tbl_funcionario].[id] 
            
            
            left join institb_usuario as usuario1 on usuario1.id = op.created_by 
            left join institb_usuario as usuario2 on op.[updated_by] = usuario2.id 


            left join tbl_orc_lotacao as ol on ol.id = op.lotacao_id and ol.orcamento_id = $orc_id
            left join tbl_orc_lotacao as ol_p on ol_p.id = op.lotacao_promovida_id and ol.orcamento_id = $orc_id
            left join tbl_lotacao as l on l.id = ol.lotacao_id
            left join tbl_lotacao as l_p on l_p.id = ol_p.lotacao_id
                
            left join tbl_ccusto as cc on cc.id = ol.cc_custo_id
            left join tbl_ccusto as cc_p on cc_p.id = ol_p.cc_custo_id

            left join tbl_orc_cargo as oc on oc.id = op.cargo_atual_id and oc.orcamento_id = $orc_id
            left join tbl_orc_cargo as oc_p on oc_p.id = op.cargo_promovido_id and oc.orcamento_id = $orc_id
            left join tbl_cargo as c on c.id = oc.cargo_id
            left join tbl_cargo as c_p on c_p.id = oc_p.cargo_id
                
            left join tbl_orc_turma as ot on ot.id = op.turma_atual_id and ot.orc_id = $orc_id
            left join tbl_orc_turma as ot_p on ot_p.id = op.turma_promovida_id and ot.orc_id = $orc_id
            left join tbl_turma as t on t.id = ot.turma_id
            left join tbl_turma as t_p on t_p.id = ot_p.turma_id

            left join tbl_turno as turno on turno.id = t.turno_id
            left join tbl_turno as turno_p on turno_p.id = t_p.turno_id
            
            where (op.[orc_id] = $orc_id and op.[lotacao_id] = $lotacao_id and (op.[tipo_table] = '$tipo_table')
                or (op.[orc_id] = $orc_id) and op.[lotacao_promovida_id] = $lotacao_id and op.[tipo_table] = '$tipo_table')".$where_periodo."
                order by tbl_funcionario.nome_funcionario, mes_promocao
                ";

            
            $data = DB::select($query);
            // dd("aquiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii",$data);
            $data = json_decode(json_encode($data), true);
            // dd("data", $data);
                
            return $data;
    }

    public function listarByLotacaoForecast($lotacao_id, $orc_id, $periodo, $tipo_table){
        $tbl_lotacao = new Lotacao();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_orc_promo = new OrcPromocao();
        $tbl_func = new Funcionario();
        $tbl_usuario = new Usuario();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_cargo = new Cargo();
        
        $whereClause = [
            [$tbl_orc_promo->getColunaAlias('orc_id'), $orc_id],
            [$tbl_orc_promo->getColunaAlias('lotacao_id'), $lotacao_id],
            [$tbl_orc_promo->getColunaAlias('tipo_table'), $tipo_table],
            [$tbl_orc_promo->getColunaAlias('periodo'), $periodo]
        ];

        $whereClause2 = [
            [$tbl_orc_promo->getColunaAlias('orc_id'), $orc_id],
            [$tbl_orc_promo->getColunaAlias('lotacao_promovida_id'), $lotacao_id],
            [$tbl_orc_promo->getColunaAlias('tipo_table'), $tipo_table],
            [$tbl_orc_promo->getColunaAlias('periodo'), $periodo]
        ];
        //dd("clausule", $whereClause);
 
        $data = $tbl_orc_promo
        // ->join(
        //     $tbl_calc_orc->getTable(),
        //     $tbl_orc_promo->getColunaAlias('id'),'=',
        //     DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
        //     {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_promo->getTable()}'"))
            
            ->leftJoin(
                $tbl_func->getTable(),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),'=',$tbl_func->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_orc_lotacao->getTable(),
                $tbl_orc_promo->getColunaAlias('lotacao_promovida_id'),'=',   $tbl_orc_lotacao->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_lotacao->getTable(),
                $tbl_orc_lotacao->getColunaAlias('lotacao_id'),'=', $tbl_lotacao->getColunaAlias('id')
            )

            ->leftJoin(
                $tbl_orc_cargo->getTable(),
                $tbl_orc_promo->getColunaAlias('cargo_promovido_id'),'=',$tbl_orc_cargo->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_cargo->getTable(),
                $tbl_orc_cargo->getColunaAlias('cargo_id'),'=',$tbl_cargo->getColunaAlias('id')
            )

            ->leftJoin(
                DB::raw("{$tbl_orc_lotacao->getTable()} as lot_origem"),
                DB::raw("lot_origem.id"),
                DB::raw("{$tbl_orc_promo->getColunaAlias('lotacao_id')} and lot_origem.orcamento_id = {$orc_id}")
            )
            ->leftJoin(
                DB::raw("{$tbl_lotacao->getTable()} as lot"),
                DB::raw("lot.id"),
                DB::raw("lot_origem.lotacao_id")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$tbl_orc_promo->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $tbl_orc_promo->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
            ->select(
                $tbl_orc_promo->getColunaAlias('id'),
                $tbl_orc_promo->getColunaAlias('orc_id'),
                $tbl_orc_promo->getColunaAlias('lotacao_id'),
                $tbl_orc_promo->getColunaAlias('cargo_promovido_id'),
                $tbl_orc_promo->getColunaAlias('cargo_atual_id'),
                $tbl_orc_promo->getColunaAlias('turma_atual_id'),
                $tbl_orc_promo->getColunaAlias('turma_promovida_id'),
                $tbl_orc_promo->getColunaAlias('ccusto_id'),
                $tbl_orc_promo->getColunaAlias('mes_promocao'),
                $tbl_orc_promo->getColunaAlias('lotacao_promovida_id'),
                $tbl_orc_promo->getColunaAlias('tipo_table'),
                
                DB::raw("CASE {$tbl_orc_promo->getColunaAlias('lotacao_id')}
                WHEN {$lotacao_id} THEN '1'
                ELSE '1'
                END as lotacao_mostrar"),

                DB::raw($tbl_orc_promo->getColunaAlias('cargo_promovido_id').' as cargo_id'),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),
                DB::raw("CONCAT({$tbl_func->getColunaAlias('num_reg_func')}, ' - ', {$tbl_func->getColunaAlias('nome_funcionario')}) as nome_funcionario"),
                DB::raw("CONCAT({$tbl_lotacao->getColunaAlias('unid_lotac')}, ' - ', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as description_lotacao_promovida"),
                DB::raw("CONCAT(lot.unid_lotac, ' - ', lot.des_unid_lotac) as description_lotacao_origem"),
                DB::raw("CONCAT(tbl_cargo.cod_cargo_basic, ' - ', tbl_cargo.des_cargo_basic) as description_cargo_promo"),
                DB::raw($tbl_cargo->getColunaAlias('des_cargo_basic').' as des_cargo'),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),
                // 'c.des_cargo_basic as des_cargo_basic_corrente',
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('jan_orcado')}, 'N', 'pt-br') AS jan_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('fev_orcado')}, 'N', 'pt-br') AS fev_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('mar_orcado')}, 'N', 'pt-br') AS mar_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('abr_orcado')}, 'N', 'pt-br') AS abr_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('mai_orcado')}, 'N', 'pt-br') AS mai_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('jun_orcado')}, 'N', 'pt-br') AS jun_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('jul_orcado')}, 'N', 'pt-br') AS jul_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('ago_orcado')}, 'N', 'pt-br') AS ago_orcado"), 
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('set_orcado')}, 'N', 'pt-br') AS set_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('out_orcado')}, 'N', 'pt-br') AS out_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('nov_orcado')}, 'N', 'pt-br') AS nov_orcado"),
                // DB::raw("format({$tbl_calc_orc->getColunaAlias('dez_orcado')}, 'N', 'pt-br') AS dez_orcado")
                DB::raw("CASE WHEN {$tbl_orc_promo->getColunaAlias('created_at')} IS NOT NULL THEN format({$tbl_orc_promo->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                DB::raw("CASE WHEN {$tbl_orc_promo->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_orc_promo->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
            )
            ->where($whereClause)
            ->orWhere($whereClause2)
            ->orderBy($tbl_func->getColunaAlias('nome_funcionario'))
            ->orderBy('mes_promocao')
            ->get()
            ->toArray();

            //dd("data promocao", $data);
            return $data;
    }
    public function existeDemissao($orc_id, $func_id, $mes, $tipo_table, $periodo = null){
        $where_periodo = $tipo_table == 'F' ? " and periodo = '{$periodo}'" : "";

        $confere = DB::select("SELECT * from tbl_orc_headcount_demissoes where orcamento_id = ? and func_id = ? and mes <= ? and tipo_table = ? and tipo = 2 {$where_periodo}", [$orc_id, $func_id, $mes, $tipo_table]);
        return count($confere) > 0 ? true : false;
    }
    public function insertPromocao($data){
        
        // dd("data", $data);
        DB::beginTransaction();
        $clausule = array(
            'orc_id'=>$data['orc_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'lotacao_promovida_id'=>$data['lotacao_destino'],
            'funcionario_id'=>$data['funcionario_id'],
            'cargo_atual_id'=>$data['cargo_atual_id'],
            'cargo_promovido_id'=>$data['cargo_promovido_id'],
            'turma_atual_id'=>$data['turma_atual_id'],
            'turma_promovida_id'=>$data['turma_promovida_id'],
            'tipo_table' => $data['tipo_table'],
            'mes_promocao'=>$data['mes_promocao']
        );

        $clausule_existe = array(
            'orc_id'=>$data['orc_id'],
            'lotacao_promovida_id'=>$data['lotacao_destino'],
            'funcionario_id'=>$data['funcionario_id'],
            'cargo_promovido_id'=>$data['cargo_promovido_id'],
            'turma_promovida_id'=>$data['turma_promovida_id'],
            'tipo_table' => $data['tipo_table'],
            'mes_promocao'=>$data['mes_promocao']
        );
        
        if($this->existeDemissao($data['orc_id'], $data['funcionario_id'], $data['mes_promocao'], $data['tipo_table'])){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'O funcionário selecionado foi demitido.<br>Erro: 300920200952';
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }
        if($clausule['cargo_atual_id'] == $data['cargo_promovido_id'] && 
            $clausule['lotacao_id'] == $data['lotacao_destino'] && 
            $data['turma_atual_id'] == $data['turma_promovida_id']){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'As informações de origem e destino não podem ser iguais.';
            $retorno['submsg'] = 'As informações de origem e destino não podem ser iguais. Erro: 200320200855';
            goto saida;
        }

        
        // if($clausule['turma_atual_id']==$data['turma_promovida_id']){
        //     $retorno['status']='error';
        //     $retorno['msg']='Turma Atual não pode ser o igual ao Turma Promovido';
        //     $retorno['submsg']='Turma Atual não pode ser o igual ao Turma Promovido. Erro: 200320200856';
        // }
           
        if($this->hasDataOnDB($clausule_existe)){ 
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }
        

        //validação
        // $conferir=$this->getModelEntity()->select()->where(
        //     [
        //         [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$data['funcionario_id']],
        //         [$this->getModelEntity()->getColunaAlias('orc_id'),'=',$data['orc_id']],
        //         [$this->getModelEntity()->getColunaAlias('turma_atual_id'),'=',$data['turma_atual_id']],
        //         [$this->getModelEntity()->getColunaAlias('cargo_atual_id'),'=',$data['cargo_atual_id']],
        //         [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$data['lotacao_id']],
        //     ]
        // )->get()->toArray();
        
        // if(!count($conferir)==0){
        //     $retorno['status']="error";
        //     $retorno['msg']=$this->getErrosFlatted().' Dados já cadastrados.';
        //     $retorno['submsg']='Dados já cadastrados. Erro: 180320200832';
        //     goto saida;
        // }
        //validação

        $orc_func = new OrcFuncionario();
           // dd("gagagagaga", $data);
        $func = OrcFuncionario::where('orcamento_id',$data['orc_id'])
            ->where('funcionario_id',$data['funcionario_id'])
            ->where('tipo_table',$data['tipo_table'])->first();
       
        if($func){
            if($func->cargo_atualizado == 0){
                $func->orc_cargo_id=$data['cargo_atual_id'];
                $func->orc_turma_id=$data['turma_atual_id'];
                $func->cargo_atualizado = 1;
                $func->updated_by = $this->fillModificadoPor();
                $func->updated_at = $this->fillModificadoEm();
                

                $func->save();
            }
        }

        $data = $this->putCargoIdOnData($data,$data['cargo_promovido_id']);
        $data = $this->putTurmaIdOnData($data,$data['turma_promovida_id']);
        $data['lotacao_promovida_id']= $data['lotacao_destino'];
        // $data['tipo_table'] = 'O';
        

        if(!$this->hasCargoTurmaNaLotacao($data)){              
            $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . ' Erro: 13020201726.');
            DB::rollBack();
            goto saida;
        }
        $data['cargo_id'] = $data['cargo_atual_id'];
        $data['orc_turma_id'] = $data['turma_atual_id'];
        $data['l_sec'] = $data['is_secreto'];
        // dd("cargo", $data);
        $id_orc_promocao = $this->checkHeadcount($data);
        
        if(!$id_orc_promocao){
            $retorno['status']="error";
            $retorno['msg']=$this->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 130120201242';
            DB::rollBack();
            goto saida;
        }    

        $repoHeadcount = new RepoHeadcount();

        if(!$repoHeadcount->calcHeadcount($data['orc_id'], $data['lotacao_id'], $data['mes_promocao'])){
            $retorno['status']="error";
            $retorno['msg']=$repoHeadcount->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201102';
            DB::rollBack();
            goto saida;
        }
        $dados_calc1 = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_id']);
        if(count($dados_calc1) > 0 && !$data['is_secreto']){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }

        if(!$repoHeadcount->calcHeadcount($data['orc_id'], $data['lotacao_promovida_id'], $data['mes_promocao'])){
            $retorno['status']="error";
            $retorno['msg']=$repoHeadcount->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 190720201257';
            DB::rollBack();
            goto saida;
        }

        $dados_calc2 = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_promovida_id']);
        if(count($dados_calc2) > 0 && !$data['is_secreto']){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores da lotação de destino irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }

        // enviar email se trocar de lotacao
        if($data['is_secreto'] == false && ($data['lotacao_id'] != $data['lotacao_destino']) ){
            if(!$this->enviarEmailTrocaLot($data['lotacao_destino'], "Não informada", $data['funcionario_id'], $data['orc_id'])){
                $retorno['status'] = "error";
                $retorno['msg'] = '';
                $retorno['submsg'] = 'Falha ao enviar e-mail. Erro: 010920200923';
                DB::rollBack();
            }
        }

        if(isset($data['is_sub']) == 1){
            $select_promo = DB::select("select * from tbl_orc_promocao where id = " . $data['sub_promocao_id']);
            
            if(count($select_promo) > 0) {
                
                try{
                    $update = DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = ? where id = ?", [$id_orc_promocao->id,  $data['sub_promocao_id']]);
                    
                    if($update === false){
                        $retorno['status'] = "error";
                        $retorno['msg'] = '';
                        $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 301220201513';
                        DB::rollBack();
                        goto saida;
                    }                    
                }
                catch(\Exception $e){
                    $this->setError('Erro 301220201522 - '.$e);
                    DB::rollBack();
                    return false;
                }
            }
            
        }        
        DB::commit();
        $retorno['status']="success";
        $retorno['msg']="Cadastro realizado com sucesso!";
        goto saida;

        saida:    
        return $retorno;
    }

    public function insertPromocaoForecast($data){
        //$this->enviarEmailTrocaLot($data['lotacao_destino'], "Não informada", $data['funcionario_id']);
        
        // validação do GS
        set_time_limit(1200);
        DB::beginTransaction();
        $atual = $this->getCodCargoByOrc($data['orc_id'], $data['cargo_atual_id']);
        $promovido = $this->getCodCargoByOrc($data['orc_id'], $data['cargo_promovido_id']);
        
        if($atual->gs > $promovido->gs){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'O Grade Salarial do Funcionário não pode diminuir. Erro: 111220201320';
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }

        $clausule = array(
            'orc_id'=>$data['orc_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'lotacao_promovida_id'=>$data['lotacao_destino'],
            'funcionario_id'=>$data['funcionario_id'],
            'cargo_atual_id'=>$data['cargo_atual_id'],
            'cargo_promovido_id'=>$data['cargo_promovido_id'],
            'turma_atual_id'=>$data['turma_atual_id'],
            'turma_promovida_id'=>$data['turma_promovida_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo' => $data['periodo'],
            'mes_promocao'=>$data['mes_promocao']
        );

        $clausule_existe = array(
            'orc_id'=>$data['orc_id'],
            'lotacao_promovida_id'=>$data['lotacao_destino'],
            'funcionario_id'=>$data['funcionario_id'],
            'cargo_promovido_id'=>$data['cargo_promovido_id'],
            'turma_promovida_id'=>$data['turma_promovida_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo' => $data['periodo'],
            'mes_promocao'=>$data['mes_promocao']
        );
        
        if($this->existeDemissao($data['orc_id'], $data['funcionario_id'], $data['mes_promocao'], $data['tipo_table'], $data['periodo'])){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'O funcionário selecionado foi demitido.<br>Erro: 300920200958';
            $retorno['submsg'] = 'Erro!';
            goto saida;
        }

        if($clausule['cargo_atual_id'] == $data['cargo_promovido_id'] && 
            $clausule['lotacao_id'] == $data['lotacao_destino'] && 
            $data['turma_atual_id'] == $data['turma_promovida_id']){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'As informações de origem e destino não podem ser iguais.';
            $retorno['submsg'] = 'As informações de origem e destino não podem ser iguais. Erro: 210920201541';
            goto saida;
        }


        // if($clausule['turma_atual_id']==$data['turma_promovida_id']){
        //     $retorno['status']='error';
        //     $retorno['msg']='Turma Atual não pode ser o igual ao Turma Promovido';
        //     $retorno['submsg']='Turma Atual não pode ser o igual ao Turma Promovido. Erro: 200320200856';
        // }

        //dd($this->hasDataOnDB($clausule_existe), $clausule_existe);
        if($this->hasDataOnDB($clausule_existe)){ 
            $retorno['status'] = 'error';
            $retorno['msg'] = 'Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }
        

        //validação
        // $conferir=$this->getModelEntity()->select()->where(
        //     [
        //         [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$data['funcionario_id']],
        //         [$this->getModelEntity()->getColunaAlias('orc_id'),'=',$data['orc_id']],
        //         [$this->getModelEntity()->getColunaAlias('turma_atual_id'),'=',$data['turma_atual_id']],
        //         [$this->getModelEntity()->getColunaAlias('cargo_atual_id'),'=',$data['cargo_atual_id']],
        //         [$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$data['lotacao_id']],
        //     ]
        // )->get()->toArray();
        
        // if(!count($conferir)==0){
        //     $retorno['status']="error";
        //     $retorno['msg']=$this->getErrosFlatted().' Dados já cadastrados.';
        //     $retorno['submsg']='Dados já cadastrados. Erro: 180320200832';
        //     goto saida;
        // }
        //validação

        $orc_func = new OrcFuncionario();
           // dd("gagagagaga", $data);
        $func = OrcFuncionario::where('orcamento_id', $data['orc_id'])
            ->where('funcionario_id', $data['funcionario_id'])
            ->where('tipo_table', $data['tipo_table'])
            ->where('periodo', $data['periodo'])->first();
       
        if($func){
            if($func->cargo_atualizado == 0){
                $func->orc_cargo_id=$data['cargo_atual_id'];
                $func->orc_turma_id=$data['turma_atual_id'];
                $func->cargo_atualizado = 1;
                $func->updated_by = $this->fillModificadoPor();
                $func->updated_at = $this->fillModificadoEm();
                

                $func->save();
            }
        }

        $data = $this->putCargoIdOnData($data,$data['cargo_promovido_id']);
        $data = $this->putTurmaIdOnData($data,$data['turma_promovida_id']);
        $data['lotacao_promovida_id']= $data['lotacao_destino'];
        // $data['tipo_table'] = 'O';
        
        
        if(!$this->hasCargoTurmaNaLotacao($data)){                    
            $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted() . '. Erro: 210920201542.');
            goto saida;
        }
        
        $data['cargo_id'] = $data['cargo_atual_id'];
        $data['orc_turma_id'] = $data['turma_atual_id'];

        $data['l_sec'] = $data['is_secreto'];

        // dd("cargo", $data);
        $id_orc_promocao = $this->checkHeadcount($data);
        
        if(!$id_orc_promocao){
            $retorno['status']="error";
            $retorno['msg']=$this->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201542b';
                
            goto saida;
        }    
        
        $repoForecast = new RepoForecast();

        // $mes_ini = intval(substr($data['periodo'], 5, 2), 10);
        // if($mes_ini == 13){
        //     $mes_ini = 1;
        // }
        
        if(!$repoForecast->calcHeadcount($data['orc_id'], $data['lotacao_id'], 1, $data['periodo'])){
            $retorno['status']="error";
            $retorno['msg']=$repoForecast->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201542c';
            DB::rollBack();
            goto saida;
        }
        // VALIDAÇÃO DO NEGATIVO
        /*$dados = array('lotacao_id'=>$data['lotacao_id'], 'orc_id'=>$data['orc_id'], 'id_princ'=>null);
        for($i = 1; $i <= 12; $i++){
            $result = $repoForecast->validaDistribuicao($i, $data['periodo'], $dados);

            if( $result === false){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }
        }*/
        
        $dados = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_id'], $data['periodo'], 'F');

        if(count($dados) > 0 && !$data['is_secreto']){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }

        if(!$repoForecast->calcHeadcount($data['orc_id'], $data['lotacao_promovida_id'], 1, $data['periodo'])){
            $retorno['status']="error";
            $retorno['msg']=$repoForecast->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201542d';
            DB::rollBack();
            goto saida;
        }
        // VALIDAÇÃO DO NEGATIVO
        /*$dados2 = array('lotacao_id'=>$data['lotacao_promovida_id'], 'orc_id'=>$data['orc_id'], 'id_princ'=>null);
        for($i = 1; $i <= 12; $i++){
            $result2 = $repoForecast->validaDistribuicao($i, $data['periodo'], $dados2);

            if( $result2 === false){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211534b";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }
        }*/
        $dados2 = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_promovida_id'], $data['periodo'], 'F');
        if(count($dados2) > 0 && !$data['is_secreto']){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores da lotação de destino irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }
        // enviar email se trocar de lotacao
        if($data['is_secreto'] == false && ($data['lotacao_id'] != $data['lotacao_destino']) ){
            if(!$this->enviarEmailTrocaLot($data['lotacao_destino'], "Não informada", $data['funcionario_id'], $data['orc_id'])){
                $retorno['status'] = "error";
                $retorno['msg'] = '';
                $retorno['submsg'] = 'Falha ao enviar e-mail. Erro: 210920201542e';
            }
        }
        

        if(isset($data['is_sub']) == 1){
            $select_promo = DB::select("select * from tbl_orc_promocao where id = " . $data['sub_promocao_id']);
            
            if(count($select_promo) > 0) {
                
                try{
                    $update = DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = ? where id = ?", [$id_orc_promocao->id,  $data['sub_promocao_id']]);
                    
                    if($update === false){
                        $retorno['status'] = "error";
                        $retorno['msg'] = '';
                        $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 130120211658';
                        goto saida;
                    }                    
                }
                catch(\Exception $e){
                    $this->setError('Erro 130120211657 - '.$e);
                    return false;
                }
            }
            
        }       
        DB::commit();
        $retorno['status']="success";
        $retorno['msg']="Cadastro realizado com sucesso!";
        goto saida;

        saida:    
        return $retorno;
    }

    public function enviarEmailTrocaLot($lotacao_destino_id, $observacao = "Não informada", $func_id, $orc_id){
        
        $select_func = DB::select("
            select concat(cdn_funcionario, ' - ', nome_funcionario) as funcionario from tbl_funcionario where id = $func_id
        ");
        $nome_func = $select_func[0]->funcionario;
        $lot = DB::select("
            select lot.unid_lotac, lot.des_unid_lotac, opar.valor_parametro, orclot.status, orclot.lotacao_id, orcm.ano, orcm.descricao_orc, orcm.id from tbl_orc_lotacao orclot
            join tbl_orcamento as orcm on orcm.id = orclot.orcamento_id
            join tbl_lotacao as lot on lot.id = orclot.lotacao_id
            join tbl_orc_parametros as opar on opar.orcamento_id = orcm.id
            join tblg_parametros as par on par.id = opar.parametro_id
            where orclot.id = $lotacao_destino_id and par.cod_parametro = 'HIER' and orcm.id = $orc_id
        ");
        
        $descricao = $lot[0]->unid_lotac. ' - '. $lot[0]->des_unid_lotac;
        $hierarquia = $lot[0]->valor_parametro + 1; //Somando 1 por que o valor do parametro retorna a posição da opção no array e nao o codigo da hierarquia, ver como corrigir;
        $observacao = 'O funcionário '.$nome_func.' foi promovido para a lotação '.$descricao;
        $repo_notify = new RepoNotify();
        $retorno = $repo_notify->notifyTrocaLotacao($lot[0]->lotacao_id, $hierarquia, $lot[0]->ano, $lot[0]->descricao_orc, $lot[0]->id, $observacao, $descricao, $nome_func);
        if(!$retorno){
            return $repo_notify->getErrosFlatted();
        }   
        return $retorno;
    }
    public function hasCargoTurmaNaLotacao($data){
        
        $repo_headcount = new RepoHeadcount();
        $repo_forecast = new RepoForecast();

        $data_compare_atual = [
            'orc_id' => $data['orc_id'],
            'lotacao_id' => $data['lotacao_id'],
            'orc_cargo_id' => $data['cargo_atual_id'],
            'ccusto_id' => $data['ccusto_id'],
            'orc_turma_id' => $data['turma_atual_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo' => array_key_exists('periodo', $data) ? $data['periodo'] : null
        ];

        $data_compare_destino = [
            'orc_id' => $data['orc_id'],
            'lotacao_id' => $data['lotacao_promovida_id'],
            'orc_cargo_id' => $data['cargo_promovido_id'],
            'ccusto_id' => $data['ccusto_promovido_id'],
            'orc_turma_id' => $data['turma_promovida_id'],
            'tipo_table' => $data['tipo_table'],
            'periodo' => array_key_exists('periodo', $data) ? $data['periodo'] : null
        ];
        $headcount_atual = $repo_headcount->getModelEntity()->where($data_compare_atual)->get()->count();
        $headcount_destino = $repo_headcount->getModelEntity()->where($data_compare_destino)->get()->count();
        
        if(!$headcount_atual){
            $data_insert = array_merge($data_compare_atual,[            
                'qtd_func_lot' => 0,
                'atual_total' => 0,
                'forecast_anterior' => 0,
                'forecast_total' => 0,
                'fromMeses' => false,
                'quadroAtual' => 0,
            ]);
            if($data['tipo_table'] == 'F'){
                $createHeadcount = $repo_forecast->createForecast($data_insert);
            }
            else{
                $createHeadcount = $repo_headcount->createHeadcount($data_insert);
            }
            
            if($createHeadcount['status'] == 'error'){
                $this->setError($createHeadcount['msg']);
                return false;
            }
        }
        
        if(!$headcount_destino){
            
            $data_insert = array_merge($data_compare_destino,[            
                'qtd_func_lot' => 0,
                'atual_total' => 0,
                'forecast_anterior' => 0,
                'forecast_total' => 0,
                'fromMeses' => false,
                'quadroAtual' => 0,
            ]);
            if($data['tipo_table'] == 'F'){
                $createHeadcount = $repo_forecast->createForecast($data_insert);
            }
            else{
                $createHeadcount = $repo_headcount->createHeadcount($data_insert);
            }
            if($createHeadcount['status'] == 'error'){
                $this->setError($createHeadcount['msg']);
                return false;
            }else{
                $this->scriptInsertCalcOrcamentoParaHeadCount($data['orc_id']);
            }
        }
        return true;
    }

    public function deletePromocao($id){
        
        $repo_calc_orcamento = new RepoCalcOrcamento();        
        $repoHeadcount = new RepoHeadcount();
        
        try {
            DB::beginTransaction();
            $promocao = $this->getModelEntity()->find($id);           
            
            // if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$id,'tbl_origem'=>'tbl_orc_promocao'])->delete()){                  
            //     $retorno["status"]="error";
            //     $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            //     $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
            //     goto saida;               
            // } 

            if(!$promocao->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
                DB::rollBack();
                goto saida;               
            }

            if($this->deleteDiarioBordo($id, 'tbl_orc_promocao') === false){
                $retorno["status"] = "error";
                $retorno['msg'] = "Falha ao delete Diário de Bordo. Erro: 220320211608";
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }
            if(!$repoHeadcount->calcHeadcount($promocao['orc_id'], $promocao['lotacao_id'], $promocao['mes_promocao'])){
                $retorno['status']="error";
                $retorno['msg']=$repoHeadcount->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 300420200834';
                DB::rollBack();
                goto saida;
            }
            if(!$repoHeadcount->calcHeadcount($promocao['orc_id'], $promocao['lotacao_promovida_id'], $promocao['mes_promocao'])){
                $retorno['status']="error";
                $retorno['msg']=$repoHeadcount->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 120420211536';
                DB::rollBack();
                goto saida;
            }

            $dados_calc = $this->validaValoresNegativos($promocao['orc_id'], $promocao['lotacao_id']);
            $dados_calc2 = $this->validaValoresNegativos($promocao['orc_id'], $promocao['lotacao_promovida_id']);
            if((count($dados_calc) > 0 || count($dados_calc2) > 0)  && !$data['is_secreto']){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }

            $select_promo = DB::select("select * from tbl_orc_promocao where sub_promocao_id = ? and orc_id = ?" ,[$id, $promocao['orc_id']] );
                
            if(count($select_promo) > 0) {
                
                try{
                    $update = DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = ? where id = ?", [0,  $select_promo[0]->id]);
                    
                    if($update === false){
                        $retorno['status'] = "error";
                        $retorno['msg'] = '';
                        $retorno['submsg'] = 'Falha ao deletar registro. Erro: 040120211445';
                        DB::rollBack();
                        goto saida;
                    }                    
                }
                catch(\Exception $e){
                    $this->setError('Erro 040120211446 - '.$e);
                    $retorno['status'] = "error";
                    $retorno['msg'] = '';
                    $retorno['submsg'] = 'Falha ao deletar registro. Erro: 040120211516';
                    DB::rollBack();
                    return $retorno;
                }
            }
            DB::commit();
            $retorno["status"]="success";
            $retorno["msg"]="Registro deletado com sucesso!";
            goto saida;      
      
        } catch (\Exception $e) {
            abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);
        }
        saida:
        return $retorno;
         
    }

    public function deletePromocaoForecast($id){
        $repo_calc_orcamento = new RepoCalcOrcamento();        
        $repoForecast = new RepoForecast();

        DB::beginTransaction();
        try{

            $promocao = $this->getModelEntity()->find($id);
            // if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$id,'tbl_origem'=>'tbl_orc_promocao'])->delete()){                  
            //     $retorno["status"]="error";
            //     $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            //     $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
            //     goto saida;               
            // } 
            if($this->deleteDiarioBordo($id, 'tbl_orc_promocao') === false){
                $retorno["status"] = "error";
                $retorno['msg'] = "Falha ao deletar Diário de Bordo. Erro: 230320211020";
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
            if(!$promocao->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
                goto saida;               
            }

            // $mes_ini = intval(substr($promocao['periodo'], 5, 2), 10);
            // if($mes_ini == 13){
            //     $mes_ini = 1;
            // }
            if(!$repoForecast->calcHeadcount($promocao['orc_id'], $promocao['lotacao_id'], $promocao['mes_promocao'], $promocao['periodo'])){
                $retorno['status']="error";
                $retorno['msg']=$repoForecast->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 300420200834';
                DB::rollBack();
                goto saida;
            }
            if(!$repoForecast->calcHeadcount($promocao['orc_id'], $promocao['lotacao_promovida_id'], $promocao['mes_promocao'], $promocao['periodo'])){
                $retorno['status']="error";
                $retorno['msg']=$repoForecast->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 300420200834';
                DB::rollBack();
                goto saida;
            }

            /*$dados = array('lotacao_id'=>$promocao['lotacao_id'], 'orc_id'=>$promocao['orc_id'], 'id_princ'=>null);
            for($i = 1; $i <= 12; $i++){
                $result = $repoForecast->validaDistribuicao($i, $promocao['periodo'], $dados);

                if( $result === false){
                    $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Erro';
                    DB::rollBack();
                    goto saida;
                }
            }*/
            $dados = $this->validaValoresNegativos($promocao['orc_id'], $promocao['lotacao_id'], $promocao['periodo'], 'F');
            $dados2 = $this->validaValoresNegativos($promocao['orc_id'], $promocao['lotacao_promovida_id'], $promocao['periodo'], 'F');
            if((count($dados) > 0 || count($dados2) > 0 ) && !$data['is_secreto']){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }


            /* TALVEZ PRECISE SER ALTERADA ESSA PARTE NO FUTURO, POIS HOUVE UMA FALHA NA MRN (o campo sub_promocao_id não foi atualizado)*/
            $select_promo = DB::select("select * from tbl_orc_promocao where sub_promocao_id = ? and orc_id = ?" ,[$id, $promocao['orc_id']] );
                
            if(count($select_promo) > 0) {
                
                try{
                    $update = DB::update("UPDATE tbl_orc_promocao set sub_promocao_id = ? where id = ?", [0,  $select_promo[0]->id]);
                    
                    if($update === false){
                        $retorno['status'] = "error";
                        $retorno['msg'] = '';
                        $retorno['submsg'] = 'Falha ao deletar registro. Erro: 130120211659';
                        goto saida;
                    }                    
                }
                catch(\Exception $e){
                    $this->setError('Erro 040120211446 - '.$e);
                    $retorno['status'] = "error";
                    $retorno['msg'] = '';
                    $retorno['submsg'] = 'Falha ao deletar registro. Erro: 130120211660';
                    DB::rollBack();
                    return $retorno;
                }
            }
        

            DB::commit();
            $retorno["status"]="success";
            $retorno["msg"]="Registro deletado com sucesso!";
            goto saida;      
      
        }
        catch(\Exception $e){
            abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);
        }
        saida:
        return $retorno;
         
    }

    public function update(array $data, $id, $attribute="id"){
        $repoHeadcount = new RepoHeadcount();
        $repoForecast = new RepoForecast();
        DB::beginTransaction();
        $periodo = $data['tipo_table'] == 'F' ? $data['periodo'] : null;
        if( $this->existeDemissao($data['orc_id'], $data['funcionario_id'], $data['mes_promocao'], $data['tipo_table'], $periodo)){
            $this->setError('O funcionário selecionado foi demitido.<br>Erro: 300920201010');
            return false;
        }
        
        $where = $data['tipo_table'] == 'F' ? " and periodo = '{$periodo}' " : "";
        
        $select = DB::select("SELECT * from tbl_orc_promocao where orc_id = ? and funcionario_id = ? and turma_promovida_id = ?
            and cargo_promovido_id = ? and lotacao_promovida_id = ? and tipo_table = ? and mes_promocao = ? {$where}",
            [$data['orc_id'], $data['funcionario_id'], $data['turma_promovida_id'], $data['cargo_promovido_id'], $data['lotacao_promovida_id'], $data['tipo_table'], $data['mes_promocao']]
        );
        if(count($select) > 0){
            $this->setError("Promoção/Transferência já existente. Erro: 220320211054");
            return false;
        }
        $dados = Arr::only($data, ['mes_promocao']);
        try{
            $update = DB::update("UPDATE tbl_orc_promocao set mes_promocao = ?, updated_at = ?, updated_by = ? where id = ?", [$dados['mes_promocao'], $this->fillModificadoEm(), $this->fillModificadoPor(), $id['id']]);
            if($update === false){
                DB::rollBack();
                return false;
            }
            //return false;
        }
        catch(\Exception $e){
            $this->setError('Erro 191120201135ct - '.$e);
            DB::rollBack();
            return false;
        }

        if( array_key_exists('tipo_table', $data) == true && $data['tipo_table'] == 'F' ){
            // $mes_ini = intval(substr($data['periodo'], 5, 2), 10);
            // if($mes_ini == 13){
            //     $mes_ini = 1;
            // }
            
            if(!$repoForecast->calcHeadcount($data['orc_id'], $data['lotacao_id_atual'], 1, $data['periodo'])){
                $this->setError($repoForecast->getErrosFlatted().'. Erro 020220211346');
                DB::rollBack();
                return false;
            }
            if(!$repoForecast->calcHeadcount($data['orc_id'], $data['lotacao_promovida_id'], 1, $data['periodo'])){
                $this->setError($repoForecast->getErrosFlatted().'. Erro 120420211525');
                DB::rollBack();
                return false;
            }

            /*$dados = array('lotacao_id'=>$data['lotacao_id_atual'], 'orc_id'=>$data['orc_id'], 'id_princ'=>null);
            for($i = 1; $i <= 12; $i++){
                $result = $repoForecast->validaDistribuicao($i, $data['periodo'], $dados);
    
                if( $result === false){
                    $this->setError("Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITP");
                    $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITP";
                    $retorno['status'] = 'error';
                    $retorno['submsg'] = 'Erro';
                    DB::rollBack();
                    return false;
                }
            }*/
            $dados = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_id_atual'], $data['periodo'], 'F');
            $dados2 = $this->validaValoresNegativos($data['orc_id'], $data['lotacao_promovida_id'], $data['periodo'], 'F');
            if((count($dados) > 0 || count($dados2) > 0) && !$data['is_secreto']){
                $this->setError("Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITP");
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITP";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                return false;
            }
        }
        else{
            $lotacao_id = $this->getModelEntity()->select()->where('id',$id)->get()->toArray();
            if(count($lotacao_id) == 0){
                $this->setError("Promoção não encontrada! Erro: 220120211430");
                return false;
            }
            if(!$repoHeadcount->calcHeadcount($data['orc_id'], $lotacao_id[0]['lotacao_id'])){
                $this->setError($repoHeadcount->getErrosFlatted());
                DB::rollBack();
                return false;
            }
            if(!$repoHeadcount->calcHeadcount($data['orc_id'], $lotacao_id[0]['lotacao_promovida_id'])){
                $this->setError($repoHeadcount->getErrosFlatted());
                DB::rollBack();
                return false;
            }

            $dados_hd = $this->validaValoresNegativos($data['orc_id'], $lotacao_id[0]['lotacao_id']);
            $dados_hd2 = $this->validaValoresNegativos($data['orc_id'], $lotacao_id[0]['lotacao_promovida_id']);
            if((count($dados_hd) > 0 || count($dados_hd2) > 0) && !$data['is_secreto']){
                $this->setError("Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITPHD");
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo. Erro: 290120211539EDITPHD";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                return false;
            }
        }
        DB::commit();
        return true;
    }

    public function getCodCargoByOrc($orc_id, $orc_cargo_id){
        $select = DB::select("SELECT substring(cast(cod_cargo_basic as varchar), 1, 2) as gs from tbl_orc_cargo as oc
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where oc.orcamento_id = $orc_id and oc.id = $orc_cargo_id
        ");

        return count($select) > 0 ? $select[0] : false;
    }

    public function scriptInsertCalcOrcamentoParaHeadCount($orc_id){
        $value  = 'Falha ao inserir registros dos meses no Headcount! Erro: 070120211641';
        $user = $this->getUserFromCurrentGuard();
        $empresa_id = $user->id_empresa;
        $user_id = $user->id;

        DB::beginTransaction();

        try {
            $sql="EXEC popula_calc_orcamento_com_tbl_orc_lot_carg_headcount :orc_id, :p_empresa_id, :p_user_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_empresa_id', $empresa_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_user_id', $user_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 070120211640 | popula_calc_orcamento_com_tbl_orc_lot_carg_headcount';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $e;
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060120211437 - ' . 'popula_orc_headcount';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }
}
