<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Lotacao; 
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcResultadosCalc;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Illuminate\Support\Facades\DB;

class RepoOrcResultadosCalc extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcResultadosCalc';
    protected $form_rules=[];
    protected $rules_msg=[];
    public $tbl_natureza;
    public $tbl_ccusto;
    public $tbl_evento;
    public $tbl_orc_lot;
    public $tbl_lot;
    public $tbl_orc_cargo;
    public $tbl_cargo;
    public $qtd;

    public function __construct()
    {
        $this->tbl_natureza = new ContaContabil();
        $this->tbl_ccusto = new CentroCusto();
        $this->tbl_evento = new Eventos();
        $this->tbl_orc_lot = new OrcLotacao();
        $this->tbl_lot = new Lotacao();
        $this->tbl_orc_cargo = new OrcCargo();
        $this->tbl_cargo = new Cargo();
        parent::__construct();
        $this->setTimeOut(700);
    }
    public function relatorioO1($orc_id, $ind, $pag, $qtd, $clausula, $periodo = null, $tipo_table = 'F'){
        set_time_limit(700);

        
        if($qtd != 0){
            $this->qtd = $qtd;
            $off_set = $this->qtd * ($ind);// onde vai começar
            //$quantidade = ($this->qtd * ($ind+1)) + 1;
        }
        
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

        // dd('chegou aquieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee', $tipo_table);

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
		if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        }
        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $where_tipo_table = $periodo != null ? " and calc.tipo_table = '$tipo_table' and calc.periodo = '{$periodo}' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_tipo_table = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }
        // dd($where_tipo_table);
        $paginacao = $pag == false ? "" : " order by calc.id asc OFFSET {$off_set} ROWS FETCH NEXT {$this->qtd} ROWS ONLY";
        
        $select = DB::select("
            SELECT 
			calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id, calc.evento_id,calc.id,
			CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as CONTA_CONTABIL
            ,CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto ) as CENTRO_CUSTO
            ,CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac) as LOTACAO
            ,CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic) as CARGO
            ,CONCAT( evento.cdn_event, ' - ', evento.des_event) as EVENTO
			--opcional unitario(qtd)
            
            ,format( [jan_val_orc], 'n2' ) as jan_val_orc
            ,format( [jan_val_min], 'n2') as jan_val_min
            ,cast([jan_qtd] as integer) as jan_qtd
            ,cast([jan_qtd_min] as integer) as jan_qtd_min

			/*,sum(isnull([jan_qtd],0)) as qtd_jan
            ,sum(isnull([jan_qtd_min],0)) as qtd_inicial_jan
			,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) as qtd_total*/

            ,format( [fev_val_orc], 'n2' ) as fev_val_orc
            ,format( [fev_val_min], 'n2' ) as fev_val_min
            ,cast([fev_qtd] as integer) as fev_qtd
            ,cast([fev_qtd_min] as integer) as fev_qtd_min

            ,format( [mar_val_orc], 'n2' ) as mar_val_orc
            ,format( [mar_val_min], 'n2' ) as mar_val_min
            ,cast([mar_qtd] as integer) as mar_qtd
            ,cast([mar_qtd_min] as integer) as mar_qtd_min

            ,format( [abr_val_orc], 'n2' ) as abr_val_orc
            ,format( [abr_val_min], 'n2' ) as abr_val_min
            ,cast([abr_qtd] as integer) as abr_qtd
            ,cast([abr_qtd_min] as integer) as abr_qtd_min

            ,format( [mai_val_orc], 'n2' ) as mai_val_orc
            ,format( [mai_val_min], 'n2' ) as mai_val_min
            ,cast([mai_qtd] as integer) as mai_qtd
            ,cast([mai_qtd_min] as integer) as mai_qtd_min

            ,format( [jun_val_orc], 'n2' ) as jun_val_orc
            ,format( [jun_val_min], 'n2' ) as jun_val_min
            ,cast([jun_qtd] as integer) as jun_qtd
            ,cast([jun_qtd_min] as integer) as jun_qtd_min

            ,format( [jul_val_orc], 'n2' ) as jul_val_orc
            ,format( [jul_val_min], 'n2' ) as jul_val_min
            ,cast([jul_qtd] as integer) as jul_qtd
            ,cast([jul_qtd_min] as integer) as jul_qtd_min

            ,format( [ago_val_orc], 'n2' ) as ago_val_orc
            ,format( [ago_val_min], 'n2' ) as ago_val_min
            ,cast([ago_qtd] as integer) as ago_qtd
            ,cast([ago_qtd_min] as integer) as ago_qtd_min

            ,format( [set_val_orc], 'n2' ) as set_val_orc
            ,format( [set_val_min], 'n2' ) as set_val_min
            ,cast([set_qtd] as integer) as set_qtd
            ,cast([set_qtd_min] as integer) as set_qtd_min

            ,format( [out_val_orc], 'n2' ) as out_val_orc
            ,format( [out_val_min], 'n2' ) as out_val_min
            ,cast([out_qtd] as integer) as out_qtd
            ,cast([out_qtd_min] as integer) as out_qtd_min

            ,format( [nov_val_orc], 'n2' ) as nov_val_orc
            ,format( [nov_val_min], 'n2' ) as nov_val_min
            ,cast([nov_qtd] as integer) as nov_qtd
            ,cast([nov_qtd_min] as integer) as nov_qtd_min

            ,format( [dez_val_orc], 'n2' ) as dez_val_orc
            ,format( [dez_val_min], 'n2' ) as dez_val_min
            ,cast([dez_qtd] as integer) as dez_qtd
            ,cast([dez_qtd_min] as integer) as dez_qtd_min

            ,format( [jan_val_total], 'n2' ) as jan_val_total
            ,format( [fev_val_total], 'n2' ) as fev_val_total
            ,format( [mar_val_total], 'n2' ) as mar_val_total
            ,format( [abr_val_total], 'n2' ) as abr_val_total
            ,format( [mai_val_total], 'n2' ) as mai_val_total
            ,format( [jun_val_total], 'n2' ) as jun_val_total
            ,format( [jul_val_total], 'n2' ) as jul_val_total
            ,format( [ago_val_total], 'n2' ) as ago_val_total
            ,format( [set_val_total], 'n2' ) as set_val_total
            ,format( [out_val_total], 'n2' ) as out_val_total
            ,format( [nov_val_total], 'n2' ) as nov_val_total
            ,format( [dez_val_total], 'n2' ) as dez_val_total
			
            
            FROM [tbl_orc_resultados_calc] as calc
        
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
        
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
        
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
        
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
        
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $where_lotacao ".$clausula.")
            ".$where_tipo_table.$paginacao
        );
        
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
        }
        return $dados;
    }
    public function relatorioO1Totais($orc_id, $ind, $pag, $qtd, $clausula, $periodo = null, $tipo_table = 'F'){
        set_time_limit(700);

                
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
		if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        }
        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $where_tipo_table = $periodo != null ? " and calc.tipo_table = '$tipo_table' and calc.periodo = '{$periodo}' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_tipo_table = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }

        $select = DB::select("
        SELECT             
            format( SUM([jan_val_orc]), 'C', 'pt-br' ) as jan_val_orc
            ,format( SUM([jan_val_min]), 'C', 'pt-br') as jan_val_min
            ,format(cast(SUM([jan_qtd]) as integer), 'N0', 'pt-pr') as jan_qtd
            ,format(cast(SUM([jan_qtd_min]) as integer), 'N0', 'pt-pr') as jan_qtd_min

            ,format( SUM([fev_val_orc]), 'C', 'pt-br' ) as fev_val_orc
            ,format( SUM([fev_val_min]), 'C', 'pt-br' ) as fev_val_min
            ,format(cast(SUM([fev_qtd]) as integer), 'N0', 'pt-pr') as fev_qtd
            ,format(cast(SUM([fev_qtd_min]) as integer), 'N0', 'pt-pr') as fev_qtd_min

            ,format( SUM([mar_val_orc]), 'C', 'pt-br' ) as mar_val_orc
            ,format( SUM([mar_val_min]), 'C', 'pt-br' ) as mar_val_min
            ,format(cast(SUM([mar_qtd]) as integer), 'N0', 'pt-pr') as mar_qtd
            ,format(cast(SUM([mar_qtd_min]) as integer), 'N0', 'pt-pr') as mar_qtd_min

            ,format( SUM([abr_val_orc]), 'C', 'pt-br' ) as abr_val_orc
            ,format( SUM([abr_val_min]), 'C', 'pt-br' ) as abr_val_min
            ,format(cast(SUM([abr_qtd]) as integer), 'N0', 'pt-pr') as abr_qtd
            ,format(cast(SUM([abr_qtd_min]) as integer), 'N0', 'pt-pr') as abr_qtd_min

            ,format( SUM([mai_val_orc]), 'C', 'pt-br' ) as mai_val_orc
            ,format( SUM([mai_val_min]), 'C', 'pt-br' ) as mai_val_min
            ,format(cast(SUM([mai_qtd]) as integer), 'N0', 'pt-pr') as mai_qtd
            ,format(cast(SUM([mai_qtd_min]) as integer), 'N0', 'pt-pr') as mai_qtd_min

            ,format( SUM([jun_val_orc]), 'C', 'pt-br' ) as jun_val_orc
            ,format( SUM([jun_val_min]), 'C', 'pt-br' ) as jun_val_min
            ,format(cast(SUM([jun_qtd]) as integer), 'N0', 'pt-pr') as jun_qtd
            ,format(cast(SUM([jun_qtd_min]) as integer), 'N0', 'pt-pr') as jun_qtd_min

            ,format( SUM([jul_val_orc]), 'C', 'pt-br' ) as jul_val_orc
            ,format( SUM([jul_val_min]), 'C', 'pt-br' ) as jul_val_min
            ,format(cast(SUM([jul_qtd]) as integer), 'N0', 'pt-pr') as jul_qtd
            ,format(cast(SUM([jul_qtd_min]) as integer), 'N0', 'pt-pr') as jul_qtd_min

            ,format( SUM([ago_val_orc]), 'C', 'pt-br' ) as ago_val_orc
            ,format( SUM([ago_val_min]), 'C', 'pt-br' ) as ago_val_min
            ,format(cast(SUM([ago_qtd]) as integer), 'N0', 'pt-pr') as ago_qtd
            ,format(cast(SUM([ago_qtd_min]) as integer), 'N0', 'pt-pr') as ago_qtd_min

            ,format( SUM([set_val_orc]), 'C', 'pt-br' ) as set_val_orc
            ,format( SUM([set_val_min]), 'C', 'pt-br' ) as set_val_min
            ,format(cast(SUM([set_qtd]) as integer), 'N0', 'pt-pr') as set_qtd
            ,format(cast(SUM([set_qtd_min]) as integer), 'N0', 'pt-pr') as set_qtd_min

            ,format( SUM([out_val_orc]), 'C', 'pt-br' ) as out_val_orc
            ,format( SUM([out_val_min]), 'C', 'pt-br' ) as out_val_min
            ,format(cast(SUM([out_qtd]) as integer), 'N0', 'pt-pr') as out_qtd
            ,format(cast(SUM([out_qtd_min]) as integer), 'N0', 'pt-pr') as out_qtd_min

            ,format( SUM([nov_val_orc]), 'C', 'pt-br' ) as nov_val_orc
            ,format( SUM([nov_val_min]), 'C', 'pt-br' ) as nov_val_min
            ,format(cast(SUM([nov_qtd]) as integer), 'N0', 'pt-pr') as nov_qtd
            ,format(cast(SUM([nov_qtd_min]) as integer), 'N0', 'pt-pr') as nov_qtd_min

            ,format( SUM([dez_val_orc]), 'C', 'pt-br' ) as dez_val_orc
            ,format( SUM([dez_val_min]), 'C', 'pt-br' ) as dez_val_min
            ,format(cast(SUM([dez_qtd]) as integer), 'N0', 'pt-pr') as dez_qtd
            ,format(cast(SUM([dez_qtd_min]) as integer), 'N0', 'pt-pr') as dez_qtd_min

            ,format( SUM([jan_val_total]), 'C', 'pt-br' ) as jan_val_total
            ,format( SUM([fev_val_total]), 'C', 'pt-br' ) as fev_val_total
            ,format( SUM([mar_val_total]), 'C', 'pt-br' ) as mar_val_total
            ,format( SUM([abr_val_total]), 'C', 'pt-br' ) as abr_val_total
            ,format( SUM([mai_val_total]), 'C', 'pt-br' ) as mai_val_total
            ,format( SUM([jun_val_total]), 'C', 'pt-br' ) as jun_val_total
            ,format( SUM([jul_val_total]), 'C', 'pt-br' ) as jul_val_total
            ,format( SUM([ago_val_total]), 'C', 'pt-br' ) as ago_val_total
            ,format( SUM([set_val_total]), 'C', 'pt-br' ) as set_val_total
            ,format( SUM([out_val_total]), 'C', 'pt-br' ) as out_val_total
            ,format( SUM([nov_val_total]), 'C', 'pt-br' ) as nov_val_total
            ,format( SUM([dez_val_total]), 'C', 'pt-br' ) as dez_val_total
            FROM [tbl_orc_resultados_calc] as calc
        
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
        
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
        
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
        
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
        
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $where_lotacao ".$clausula.")
            ".$where_tipo_table
        );
        
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
            return $dados[$i];
        }
        return $dados;
    }
    public function relatorioResumidoCalcQtd($orc_id, $ind, $pag, $qtd, $clausula, $periodo = null, $tipo_table = 'F'){
        set_time_limit(500);
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        //dd($orc_id, $ind, $pag, $qtd, $clausula);
        if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        }

        if($qtd != 0){
            $off_set = $qtd * ($ind);// onde vai começar
            //$quantidade = (qtd * ($ind+1)) + 1;
        }
        $paginacao = $pag == false ? "" : " order by calc.id asc OFFSET {$off_set} ROWS FETCH NEXT {$qtd} ROWS ONLY";

        

        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $where_tipo_table = $periodo != null ? " and calc.tipo_table = '$tipo_table' and calc.periodo = '{$periodo}' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_tipo_table = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }
        //dd($where_tipo_table);
        $select = DB::select("
            SELECT
            calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,
            CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as CONTA_CONTABIL
            ,CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto ) as CENTRO_CUSTO
            ,CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac) as LOTACAO
            ,CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic) as CARGO
            ,CONCAT( evento.cdn_event, ' - ', evento.des_event) as EVENTO 
            ,calc.orc_cargo_id, calc.evento_id

            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_orc_total
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_min_total
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jan


            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_orc_total
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_min_total
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_orc_total
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_min_total
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_orc_total
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_min_total
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_orc_total
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_min_total
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_orc_total
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_min_total
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_orc_total
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_min_total
            ,sum(isnull([jul_qtd],0))OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_orc_total
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_min_total
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_orc_total
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_min_total
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_orc_total
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_min_total
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_orc_total
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_min_total
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_orc_total
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_min_total
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_total
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_total
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_total
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_total

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_total
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_total
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_total
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_total

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_total
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_total
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_total
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_total

            /*mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm*/
            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_orc
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_min
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jan
            
            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_orc
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_min
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_orc
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_min
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_orc
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_min
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_orc
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_min
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_orc
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_min
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_orc
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_min
            ,sum(isnull([jul_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_orc
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_min
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_orc
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_min
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_orc
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_min
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_orc
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_min
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_orc
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_min
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_total_
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_total_
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_total_
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_total_

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_total_
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_total_
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_total_
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_total_

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_total_
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_total_
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_total_
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_total_
            
            FROM [tbl_orc_resultados_calc] as calc
    
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $where_lotacao ".$clausula.")
            ".$where_tipo_table.$paginacao
        );
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
        }
        
        return $dados;
    }

    public function listarExportarQtd($orc_id, $periodo = null, $nome, $tipo_table = 'F'){
        
        set_time_limit($this->getTimeOut());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        
        if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        }

        $dados_orc = DB::select("SELECT * FROM tbl_orcamento where id = {$orc_id}");
        $data_select = date('d/m/Y H:i');

        // $tipo_table = $periodo == null ? 'O' : 'F';
        $where_periodo = $periodo != null ? " and calc.periodo = '{$periodo}' and calc.tipo_table = '$tipo_table' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_periodo = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }
        $select = DB::select("SELECT distinct
            --calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,
            CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as CONTA_CONTABIL
            ,CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto ) as CENTRO_CUSTO
            ,CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac) as LOTACAO
            ,CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic) as CARGO
            ,CONCAT( evento.cdn_event, ' - ', evento.des_event) as EVENTO 
            --,calc.orc_cargo_id, calc.evento_id

            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_orc_total
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_min_total
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jan


            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_orc_total
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_min_total
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_orc_total
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_min_total
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_orc_total
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_min_total
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_orc_total
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_min_total
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_orc_total
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_min_total
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_orc_total
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_min_total
            ,sum(isnull([jul_qtd],0))OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_orc_total
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_min_total
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_orc_total
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_min_total
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_orc_total
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_min_total
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_orc_total
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_min_total
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_orc_total
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_min_total
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_total
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_total
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_total
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_total

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_total
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_total
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_total
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_total

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_total
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_total
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_total
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_total

            /*mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm*/
            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_orc
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_min
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jan
            
            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_orc
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_min
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_orc
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_min
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_orc
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_min
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_orc
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_min
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_orc
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_min
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_orc
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_min
            ,sum(isnull([jul_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_orc
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_min
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_orc
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_min
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_orc
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_min
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_orc
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_min
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_orc
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_min
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_total_
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_total_
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_total_
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_total_

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_total_
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_total_
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_total_
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_total_

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_total_
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_total_
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_total_
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_total_,

            cast({$dados_orc[0]->id} as varchar)+' - '+(CASE 
            WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
            WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
            ELSE 'Orçado' END)+' '+IIF('{$tipo_table}' = 'F', SUBSTRING('{$periodo}', 6, 2)+'/'+cast({$dados_orc[0]->ano} as varchar), cast({$dados_orc[0]->ano} as varchar))+'. Gerado por {$nome} em {$data_select}' as informativo
            
            FROM [tbl_orc_resultados_calc] as calc
    
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where (calc.orcamento_id = {$orc_id} $where_lotacao)
            ".$where_periodo
        );

        return $select;
    }

    public function listarExportar($orc_id, $periodo = null, $nome, $tipo_table = 'F'){
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
		if(!$lotacoes){
            $lotacoes_string = '0';
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
        }

        
        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        $filtrar_lotacoes = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
            $filtrar_lotacoes =  "and orclot.lotacao_id in ($lotacoes_string)";
        }

        $dados_orc = DB::select("SELECT * FROM tbl_orcamento where id = {$orc_id}");
        $data_select = date('d/m/Y H:i');

        $tipo_table = $periodo == null ? 'O' : $tipo_table;

        $where_periodo = $periodo != null ? " and calc.periodo = '{$periodo}' and calc.tipo_table = '$tipo_table' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_periodo = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }

        $select = DB::select("SELECT 
            --calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id, calc.evento_id,calc.id,
            [dbo].[FN_FORMATAR_TEXTO_CARACTERES_ESPECIAIS](CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl)) as CONTA_CONTABIL
            ,[dbo].[FN_FORMATAR_TEXTO_CARACTERES_ESPECIAIS](CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto )) as CENTRO_CUSTO
            ,[dbo].[FN_FORMATAR_TEXTO_CARACTERES_ESPECIAIS](CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac)) as LOTACAO
            ,[dbo].[FN_FORMATAR_TEXTO_CARACTERES_ESPECIAIS](CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic)) as CARGO
            ,[dbo].[FN_FORMATAR_TEXTO_CARACTERES_ESPECIAIS](CONCAT( evento.cdn_event, ' - ', evento.des_event)) as EVENTO
			--opcional unitario(qtd)
            
            ,format( [jan_val_orc], 'G', 'pt-br' ) as 'jan valor inicial'
            ,format( [jan_val_min], 'G', 'pt-br' ) as 'jan valor inicial un'
            ,cast([jan_qtd] as integer) as 'jan qtd'
            ,cast([jan_qtd_min] as integer) as 'jan qtd inicial'

            ,format( [fev_val_orc], 'G', 'pt-br' ) as 'fev valor inicial'
            ,format( [fev_val_min], 'G', 'pt-br' ) as 'fev valor inicial un'
            ,cast([fev_qtd] as integer) as 'fev qtd'
            ,cast([fev_qtd_min] as integer) as 'fev qtd inicial'

            ,format( [mar_val_orc], 'G', 'pt-br' ) as 'mar valor inicial'
            ,format( [mar_val_min], 'G', 'pt-br' ) as 'mar valor inicial un'
            ,cast([mar_qtd] as integer) as 'mar qtd'
            ,cast([mar_qtd_min] as integer) as 'mar qtd inicial'

            ,format( [abr_val_orc], 'G', 'pt-br' ) as 'abr valor inicial'
            ,format( [abr_val_min], 'G', 'pt-br' ) as 'abr valor inicial un'
            ,cast([abr_qtd] as integer) as 'abr qtd'
            ,cast([abr_qtd_min] as integer) as 'abr qtd inicial'

            ,format( [mai_val_orc], 'G', 'pt-br' ) as 'mai valor inicial'
            ,format( [mai_val_min], 'G', 'pt-br' ) as 'mai valor inicial un'
            ,cast([mai_qtd] as integer) as 'mai qtd'
            ,cast([mai_qtd_min] as integer) as 'mai qtd inicial'

            ,format( [jun_val_orc], 'G', 'pt-br' ) as 'jun valor inicial'
            ,format( [jun_val_min], 'G', 'pt-br' ) as 'jun valor inicial un'
            ,cast([jun_qtd] as integer) as 'jun qtd'
            ,cast([jun_qtd_min] as integer) as 'jun qtd inicial'

            ,format( [jul_val_orc], 'G', 'pt-br' ) as 'jul valor inicial'
            ,format( [jul_val_min], 'G', 'pt-br' ) as 'jul valor inicial un'
            ,cast([jul_qtd] as integer) as 'jul qtd'
            ,cast([jul_qtd_min] as integer) as 'jul qtd inicial'

            ,format( [ago_val_orc], 'G', 'pt-br' ) as 'ago valor inicial'
            ,format( [ago_val_min], 'G', 'pt-br' ) as 'ago valor inicial un'
            ,cast([ago_qtd] as integer) as 'ago qtd'
            ,cast([ago_qtd_min] as integer) as 'ago qtd inicial'


            ,format( [set_val_orc], 'G', 'pt-br' ) as 'set valor inicial'
            ,format( [set_val_min], 'G', 'pt-br' ) as 'set valor inicial un'
            ,cast([set_qtd] as integer) as 'set qtd'
            ,cast([set_qtd_min] as integer) as 'set qtd inicial'

            ,format( [out_val_orc], 'G', 'pt-br' ) as 'out valor inicial'
            ,format( [out_val_min], 'G', 'pt-br' ) as 'out valor inicial un'
            ,cast([out_qtd] as integer) as 'out qtd'
            ,cast([out_qtd_min] as integer) as 'out qtd inicial'

            ,format( [nov_val_orc], 'G', 'pt-br' ) as 'nov valor inicial'
            ,format( [nov_val_min], 'G', 'pt-br' ) as 'nov valor inicial un'
            ,cast([nov_qtd] as integer) as 'nov qtd'
            ,cast([nov_qtd_min] as integer) as 'nov qtd inicial'

            ,format( [dez_val_orc], 'G', 'pt-br' ) as 'dez valor inicial'
            ,format( [dez_val_min], 'G', 'pt-br' ) as 'dez valor inicial un'
            ,cast([dez_qtd] as integer) as 'dez qtd'
            ,cast([dez_qtd_min] as integer) as 'dez qtd inicial'

            ,format( [jan_val_total], 'G', 'pt-br' ) as 'jan valor total'
            ,format( [fev_val_total], 'G', 'pt-br' ) as 'fev valor total'
            ,format( [mar_val_total], 'G', 'pt-br' ) as 'mar valor total'
            ,format( [abr_val_total], 'G', 'pt-br' ) as 'abr valor total'
            ,format( [mai_val_total], 'G', 'pt-br' ) as 'mai valor total'
            ,format( [jun_val_total], 'G', 'pt-br' ) as 'jun valor total'
            ,format( [jul_val_total], 'G', 'pt-br' ) as 'jul valor total'
            ,format( [ago_val_total], 'G', 'pt-br' ) as 'ago valor total'
            ,format( [set_val_total], 'G', 'pt-br' ) as 'set valor total'
            ,format( [out_val_total], 'G', 'pt-br' ) as 'out valor total'
            ,format( [nov_val_total], 'G', 'pt-br' ) as 'nov valor total'
            ,format( [dez_val_total], 'G', 'pt-br' ) as 'dez valor total'

            ,cast({$dados_orc[0]->id} as varchar)+' - '+(CASE 
            WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
            WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
            ELSE 'Orçado' END)+' '+IIF('{$tipo_table}' = 'F', SUBSTRING('{$periodo}', 6, 2)+'/'+cast({$dados_orc[0]->ano} as varchar), cast({$dados_orc[0]->ano} as varchar))+'. Gerado por {$nome} em {$data_select}' as informativo
			
            
            FROM [tbl_orc_resultados_calc] as calc
        
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
        
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
        
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
        
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
        
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $filtrar_lotacoes 
            )".$where_periodo);
        
        return $select;
    }


    public function gerarWaterfall($orcamento_a, $orcamento_b, $tipo_orcamento_a, $tipo_orcamento_b, $divisor = 1, $valor_min_exibir = 10){
        // $divisor = 1000000;
        // $valor_min_exibir = 10;
        set_time_limit($this->getTimeOut());
        $dados_orc_a = $this->getValoresByNatureza($orcamento_a, $tipo_orcamento_a);
        $dados_orc_b = $this->getValoresByNatureza($orcamento_b, $tipo_orcamento_b);

        $naturezas_a = array_column($dados_orc_a, 'natureza_hash_id');
        $naturezas_b = array_column($dados_orc_b, 'natureza_hash_id');
        $all_naturezas = array_unique(array_merge($naturezas_a, $naturezas_b));
        $naturezas_distinct = [];

        $data = [];

        foreach ($dados_orc_a as $dado) {
            if($dado['natureza_hash_id'] == 'TOTAL'){
                $data['TOTAL_ORCAMENTO_1'] = $dado['valor'];
                continue;
            }
            $data[$dado['natureza_hash_id']] = $dado['valor'];
        }

        foreach ($dados_orc_b as $dado) {
            if($dado['natureza_hash_id'] == 'TOTAL'){
                $data['TOTAL_ORCAMENTO_2'] = $dado['valor'];
                continue;
            }
            if(!array_key_exists($dado['natureza_hash_id'], $data)){
                $data[$dado['natureza_hash_id']] = - $dado['valor'];
                continue;
            }            
            
            $data[$dado['natureza_hash_id']] =  $data[$dado['natureza_hash_id']] - $dado['valor'];
        }
        // dd($data);

        $result['TOTAL_ORCAMENTO_1'] = $data['TOTAL_ORCAMENTO_1']/$divisor;
        $outras_naturezas = 0;

        unset($data['TOTAL_ORCAMENTO_1']);
        $anterior = $result['TOTAL_ORCAMENTO_1'];

        // arsort($data); //decrescente
        // asort($data,SORT_NUMERIC); ///crescente
        asort($data); ///crescente
        

        foreach ($data as $key => $value) {
            if($key == 'TOTAL_ORCAMENTO_2'){
                continue;
            }
            if((floatVal($anterior-($value/$divisor)) - floatVal($anterior)) <= $valor_min_exibir && (floatVal($anterior-($value/$divisor)) - floatVal($anterior)) >= -$valor_min_exibir){
                $outras_naturezas = $outras_naturezas + ($value/$divisor);
                continue;
            }
            $result[$key] = [floatVal($anterior), floatVal($anterior-$value/$divisor)];
            $anterior = $anterior-$value/$divisor;
        }

        $result['OUTRAS_NATUREZAS'] = [floatVal($anterior), floatVal($anterior-$outras_naturezas)];

        $result['TOTAL_ORCAMENTO_2'] = $data['TOTAL_ORCAMENTO_2']/$divisor;

        return $result;
    }

    public function getWherePeriodo($tipo_table, $orcamento_id){
        if($tipo_table != 'F'){
            return " AND periodo is null ";
        }
        else{
            return " AND periodo = (select max(periodo) from tbl_orc_lotacao where orcamento_id = $orcamento_id) ";
        }
    }

    public function getValoresByNatureza($orcamento_id, $tipo_table){
        set_time_limit($this->getTimeOut());
        $dados = DB::select("
            select 
                natureza_hash_id, SUM(ISNULL(jan_val_total, 0) + ISNULL(fev_val_total, 0) + ISNULL(mar_val_total, 0) + ISNULL(abr_val_total, 0) + ISNULL(mai_val_total, 0) + ISNULL(jun_val_total, 0) + ISNULL(jul_val_total, 0) + ISNULL(ago_val_total, 0) + ISNULL(set_val_total, 0) + ISNULL(out_val_total, 0) + ISNULL(nov_val_total, 0) + ISNULL(dez_val_total, 0)) valor
            from tbl_orc_resultados_calc where tipo_table = '$tipo_table' and orcamento_id = $orcamento_id ".$this->getWherePeriodo($tipo_table, $orcamento_id)."
            group by natureza_hash_id
            
            union 
            
            select 
                'TOTAL' natureza_hash_id, SUM(ISNULL(jan_val_total, 0) + ISNULL(fev_val_total, 0) + ISNULL(mar_val_total, 0) + ISNULL(abr_val_total, 0) + ISNULL(mai_val_total, 0) + ISNULL(jun_val_total, 0) + ISNULL(jul_val_total, 0) + ISNULL(ago_val_total, 0) + ISNULL(set_val_total, 0) + ISNULL(out_val_total, 0) + ISNULL(nov_val_total, 0) + ISNULL(dez_val_total, 0)) valor
            from tbl_orc_resultados_calc where tipo_table = '$tipo_table' and orcamento_id = $orcamento_id ".$this->getWherePeriodo($tipo_table, $orcamento_id)."
        ");

        return json_decode(json_encode($dados),true);
    }

    public function listarCalcQtdPais($orc_id, $ind, $pag, $qtd, $clausula, $periodo = null, $tipo_table = 'F'){
        
        set_time_limit(500);
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        //dd($orc_id, $ind, $pag, $qtd, $clausula);
        if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        }

        if($qtd != 0){
            $off_set = $qtd * ($ind);// onde vai começar
            //$quantidade = (qtd * ($ind+1)) + 1;
        }
        $paginacao = $pag == false ? "" : " order by calc.id asc OFFSET {$off_set} ROWS FETCH NEXT {$qtd} ROWS ONLY";

        

        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $where_tipo_table = $periodo != null ? " and calc.tipo_table = '$tipo_table' and calc.periodo = '{$periodo}' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_tipo_table = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }
        
        $select = DB::select("SELECT
            calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,
            CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as CONTA_CONTABIL
            ,CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto ) as CENTRO_CUSTO
            ,CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac) as LOTACAO
            --,CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic) as CARGO
            --,CONCAT( evento.cdn_event, ' - ', evento.des_event) as EVENTO 
            ,null orc_cargo_id, null evento_id

            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_orc_total
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_min_total
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jan


            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_orc_total
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_min_total
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_orc_total
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_min_total
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_orc_total
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_min_total
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_orc_total
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_min_total
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_orc_total
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_min_total
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_orc_total
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_min_total
            ,sum(isnull([jul_qtd],0))OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_orc_total
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_min_total
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_orc_total
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_min_total
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_orc_total
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_min_total
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_orc_total
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_min_total
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_orc_total
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_min_total
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_total
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_total
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_total
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_total

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_total
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_total
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_total
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_total

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_total
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_total
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_total
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_total

            /*mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm*/
            /*,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_orc
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_min
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jan
            
            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_orc
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_min
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_orc
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_min
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_orc
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_min
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_orc
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_min
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_orc
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_min
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_orc
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_min
            ,sum(isnull([jul_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_orc
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_min
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_orc
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_min
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_orc
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_min
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_orc
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_min
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_orc
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_min
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_total_
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_total_
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_total_
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_total_

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_total_
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_total_
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_total_
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_total_

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_total_
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_total_
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_total_
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_total_*/
            
            FROM [tbl_orc_resultados_calc] as calc
    
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $where_lotacao ".$clausula.")
            ".$where_tipo_table.$paginacao
        );
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
        }
        
        return $dados;
    }

    public function listarCalcQtdFilhos($orc_id, $data, $periodo = null, $tipo_table = 'F'){
        set_time_limit(500);
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo == null ? 'O' : $tipo_table;
        
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        //dd($orc_id, $ind, $pag, $qtd, $clausula);
        if(!$lotacoes){
            $lotacoes_string = '0';
            $where_lotacao = "";
        }
        else{
            $lotacoes_string = implode(",",$lotacoes);
            $where_lotacao = " and orclot.lotacao_id in ($lotacoes_string)";
        } 

        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orclot.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $where_tipo_table = $periodo != null ? " and calc.tipo_table = '$tipo_table' and calc.periodo = '{$periodo}' " : " and calc.tipo_table = 'O' ";
        if($tipo_table == 'R'){
            $where_tipo_table = " and calc.tipo_table = 'R' and calc.periodo is null ";
        }
        $where_pais = " AND calc.ccontabil_id = {$data['ccontabil_id']} and calc.orc_lotacao_id = {$data['orc_lotacao_id']} and calc.ccusto_id = {$data['ccusto_id']} ";
        //dd($where_tipo_table);
        $select = DB::select("SELECT
            calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,
            CONCAT( ctactb.cod_cta_ctbl, ' - ', ctactb.desc_cta_ctbl) as CONTA_CONTABIL
            ,CONCAT( cc.cod_ccusto, ' - ', cc.des_ccusto ) as CENTRO_CUSTO
            ,CONCAT( lot.unid_lotac, ' - ', lot.des_unid_lotac) as LOTACAO
            ,CONCAT( carg.cod_cargo_basic, ' - ', carg.des_cargo_basic) as CARGO
            ,CONCAT( evento.cdn_event, ' - ', evento.des_event) as EVENTO 
            ,calc.orc_cargo_id, calc.evento_id

            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_orc_total
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_min_total
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jan


            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_orc_total
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_min_total
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_orc_total
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_min_total
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_orc_total
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_min_total
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_orc_total
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_min_total
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_orc_total
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_min_total
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_orc_total
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_min_total
            ,sum(isnull([jul_qtd],0))OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_orc_total
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_min_total
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_orc_total
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_min_total
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_orc_total
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_min_total
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_orc_total
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_min_total
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_orc_total
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_min_total
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) total_qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jan_val_total
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) fev_val_total
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mar_val_total
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) abr_val_total

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) mai_val_total
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jun_val_total
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) jul_val_total
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) ago_val_total

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) set_val_total
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) out_val_total
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) nov_val_total
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id) dez_val_total

            /*mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm*/
            ,sum(isnull([jan_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_orc
            ,sum(isnull([jan_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_min
            ,sum(isnull([jan_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jan
            ,sum(isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jan
            ,sum(isnull([jan_qtd],0) + isnull([jan_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jan
            
            ,sum(isnull([fev_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_orc
            ,sum(isnull([fev_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_min
            ,sum(isnull([fev_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_fev
            ,sum(isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_fev
            ,sum(isnull([fev_qtd],0) + isnull([fev_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_fev

            ,sum(isnull([mar_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_orc
            ,sum(isnull([mar_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_min
            ,sum(isnull([mar_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mar
            ,sum(isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mar
            ,sum(isnull([mar_qtd],0) + isnull([mar_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mar

            ,sum(isnull([abr_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_orc
            ,sum(isnull([abr_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_min
            ,sum(isnull([abr_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_abr
            ,sum(isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_abr
            ,sum(isnull([abr_qtd],0) + isnull([abr_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_abr

            ,sum(isnull([mai_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_orc
            ,sum(isnull([mai_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_min
            ,sum(isnull([mai_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_mai
            ,sum(isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_mai
            ,sum(isnull([mai_qtd],0) + isnull([mai_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_mai

            ,sum(isnull([jun_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_orc
            ,sum(isnull([jun_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_min
            ,sum(isnull([jun_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jun
            ,sum(isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jun
            ,sum(isnull([jun_qtd],0) + isnull([jun_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jun

            ,sum(isnull([jul_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_orc
            ,sum(isnull([jul_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_min
            ,sum(isnull([jul_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_jul
            ,sum(isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_jul
            ,sum(isnull([jul_qtd],0) + isnull([jul_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_jul

            ,sum(isnull([ago_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_orc
            ,sum(isnull([ago_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_min
            ,sum(isnull([ago_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_ago
            ,sum(isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_ago
            ,sum(isnull([ago_qtd],0) + isnull([ago_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_ago

            ,sum(isnull([set_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_orc
            ,sum(isnull([set_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_min
            ,sum(isnull([set_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_set
            ,sum(isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_set
            ,sum(isnull([set_qtd],0) + isnull([set_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_set

            ,sum(isnull([out_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_orc
            ,sum(isnull([out_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_min
            ,sum(isnull([out_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_out
            ,sum(isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_out
            ,sum(isnull([out_qtd],0) + isnull([out_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_out

            ,sum(isnull([nov_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_orc
            ,sum(isnull([nov_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_min
            ,sum(isnull([nov_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_nov
            ,sum(isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_nov
            ,sum(isnull([nov_qtd],0) + isnull([nov_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_nov

            ,sum(isnull([dez_val_orc],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_orc
            ,sum(isnull([dez_val_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_min
            ,sum(isnull([dez_qtd],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_dez
            ,sum(isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_inicial_dez
            ,sum(isnull([dez_qtd],0) + isnull([dez_qtd_min],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) qtd_total_dez


            ,sum(isnull([jan_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jan_val_total_
            ,sum(isnull([fev_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) fev_val_total_
            ,sum(isnull([mar_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mar_val_total_
            ,sum(isnull([abr_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) abr_val_total_

            ,sum(isnull([mai_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) mai_val_total_
            ,sum(isnull([jun_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jun_val_total_
            ,sum(isnull([jul_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) jul_val_total_
            ,sum(isnull([ago_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) ago_val_total_

            ,sum(isnull([set_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) set_val_total_
            ,sum(isnull([out_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) out_val_total_
            ,sum(isnull([nov_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) nov_val_total_
            ,sum(isnull([dez_val_total],0)) OVER(PARTITION BY calc.ccontabil_id, calc.orc_lotacao_id, calc.ccusto_id,calc.orc_cargo_id, calc.evento_id) dez_val_total_
            
            FROM [tbl_orc_resultados_calc] as calc
    
            left join [tbl_cta_contabil] as ctactb on calc.ccontabil_id = ctactb.id
            left join [tbl_ccusto] as cc on calc.ccusto_id = cc.id
            left join [tbl_eventos] as evento on calc.evento_id = evento.id
            left join [tbl_orc_lotacao] as orclot on calc.orc_lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id}
            left join [tbl_lotacao] as lot on orclot.lotacao_id = lot.id
            left join [tbl_orc_cargo] as orccargo on calc.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            left join [tbl_cargo] as carg on orccargo.cargo_id = carg.id

            where ( $mostrar_calculo_nao_liberado calc.orcamento_id = {$orc_id} $where_lotacao {$where_pais})
            ".$where_tipo_table
        );
        $dados = [];
        for($i = 0; $i < count($select); $i++){
            $dados[$i] = (array)$select[$i];
        }
        
        return $dados;
    }
}
