<?php

namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto as LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcParametros;
use App\Modules\Natureza51\Entities\CadastroParametros;
use \App\Core\Traits\ErrorTrait;
use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\BeneficioLotacaoCargo;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CargosArea;
use App\Modules\Natureza51\Entities\NaturezaEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use App\Modules\Natureza51\Http\Controllers\BeneficioController;
use App\Modules\Natureza51\Http\Controllers\BeneficioFuncionarioController;
use App\Modules\Natureza51\Repositories\RepoBeneficio;
use App\Modules\Natureza51\Entities\OrcParamNatureza;
use App\Modules\Natureza51\Http\Controllers\BeneficioLotacaoCargoController;
use DateTime;
use Exception;
use Illuminate\Support\Facades\DB;

class RepoOrcScriptCalculos extends RepoOrcamento
{


    public function createCalcCargoArea($orc_id){
        $orc_cargo_area_sal = new OrcCargosAreaSal();
        $funcionario = new Funcionario();
        $orc_cargo = new OrcCargo();
        $cargo = new Cargo();
        $orc_lotacao = new OrcLotacao();
        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();
        $centro_custo = new CentroCusto();
        $orc_eventos = new OrcEventos();
        $eventos = new Eventos();
        $empresa = new Empresa();
        $conta_contabil_vs_eventos = new ContaContabilVSEventos();
        $conta_contabil = new ContaContabil();
        $calc_orcamento = new CalcOrcamento();
        $orc_parametros = new OrcParametros();

        $beneficio = new Beneficio();
        $orc_beneficio = new OrcBeneficio();
        $orc_beneficio_cargo_area = new OrcLotCargoBeneficio();
        $orc_beneficio_funcionario_area = new OrcLotFuncionatioBeneficio();

        $cargo_lotacao = new CargosArea();

        $entities = [
            'orcCargosAreaSal' => ['instance'=>$orc_cargo_area_sal],
            'funcionario' => ['instance'=>$funcionario],
            'orcCargo' => ['instance'=>$orc_cargo],
            'cargo' => ['instance' => $cargo],
            'orcLotacao' => ['instance' => $orc_lotacao],
            'lotacaoCCusto' => ['instance' => $lotacao_c_custo],
            'lotacao' => ['instance' => $lotacao],
            'centroCusto' => ['instance' => $centro_custo],
            'orcEventos' => ['instance' => $orc_eventos],
            'eventos' => ['instance' => $eventos],
            'empresa' => ['instance' => $empresa],
            'contaContabilVSEventos' => ['instance' => $conta_contabil_vs_eventos],
            'contaContabil' => ['instance' => $conta_contabil],
            'calcOrcamento' => ['instance' => $calc_orcamento],
            'orcParametros' => ['instance' => $orc_parametros],

            'beneficio' => ['instance' => $beneficio],
            'orc_beneficio' => ['instance' => $orc_beneficio],
            'orc_beneficio_cargo_area' => ['instance' => $orc_beneficio_cargo_area],
            'orc_beneficio_funcionario_area' => ['instance' => $orc_beneficio_funcionario_area],
            'CargoLotacao' => ['instance' => $cargo_lotacao]
        ];

        $result = $this->scriptMergeOrcLotacao($orc_id, 1);

        if($result["status"]!="success"){
            return $result;
        }
        
        $calc_orc_cargo = $this->insertUpcalcOrcCargo($entities, $orc_id);

        if($calc_orc_cargo["status"]=="success"){
            $result = $this->insertCalcOrcamentoCargo($entities, $orc_id);
        }
        $calc_orc_cargo_sal = $this->insertUpcalcOrcCargoAreaSal($entities, $orc_id);

        if($calc_orc_cargo_sal["status"]=="success"){
            $this->update_sal_med_orc_cargos_area_sal($orc_id);
            $this->update_insal_peric_orc_cargos_area_sal($orc_id);

            $result = $this->insertCalcOrcamentoCargoAreaSal($entities, $orc_id);
        }
        $return = $this->populaOrcEventos($entities, $orc_id);

        $return = $this->populaBeneficio($orc_id, $result);

        //Felipe MRN pediu para não popular automatico. 08/07/2020
        // $result_orc_turma = $this->insertOrcTurma($orc_id);

        //Felipe MRN pediu para não popular automatico. 07/07/2020
        // $result_orc_turma_evento = $this->scriptinsertOrcTurmaEvento($orc_id);

        $result = $this->insertOrcParametros($orc_id);

        if(!$this->InsereNaturezaEvento($orc_id)){
            $result = false;
        }
        if(!$this->insertToOrcParamNatureza($orc_id)){
            $result = false;
        }
        // esse script deve ser rodado apos o orçamento ser liberado.
        // $result = $this->scriptInsertOrcHeadCount($orc_id);

        $result = $this->scriptInsertHoraExtra($orc_id, 1);

        // $beneficio_ids = $this->getModelEntity()::select("beneficio_id")
        //                 ->where('orcamento_id',$orc_id)
        //                 ->get()
        //                 ->toArray();
        $orc_beneficio = new OrcBeneficio();
        $beneficio_ids = $orc_beneficio::select("beneficio_id")
                        ->where('orcamento_id',$orc_id)
                        ->get()
                        ->toArray();
                        
        if(!empty($beneficio_ids)){
            foreach($beneficio_ids as $beneficio_id){
                $resp = $this->sp_hnd_beneficio_mov_contabil($orc_id, $beneficio_id['beneficio_id']);
                
                 if($resp["status"]=="error"){
                    $result['msg']="Ocorreu uma falha ao repopular tela Benefício cargo ind!";
                    $result['submsg']='Falha ao inserir o registro. Erro:270820201027';
                    $result['status']='error';                   
                }
            }  
        }

        return $result;
    }

    public function populaOrcEventos($entities, $orc_id, $periodo = null, $tipo_table = 'O') {
        // $calc_eventos = $this->insertUpcalcOrcEventos($entities, $orc_id);
        
        if($tipo_table == 'F'){
            $calc_eventos = $this->insertOrcEventosSPForecast($orc_id, $periodo, $tipo_table);
            if($calc_eventos["status"]=="success"){
                $result = $this->insertCalcOrcamentoEventos($orc_id, $periodo, $tipo_table);
                return $result;
            }
            return $calc_eventos;
        }
        else{
            $calc_eventos = $this->insertOrcEventosSP($orc_id);
            if($calc_eventos["status"]=="success"){
                $result = $this->insertCalcOrcamentoEventos($orc_id);
                return $result;
            }
            return $calc_eventos;
        }
        
    }

    public function insertOrcEventosSPForecast($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir Orçamento! Erro: 060120211405';
        DB::beginTransaction();
        $usuario_id = $this->fillCriadoPor();
        try {

            $sql="EXEC insere_orc_evento_forecast :orc_id, :tipo_table, :periodo, :usuario_id";
            
            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_STR );
            
            if(!$stmt->execute()){

                $retorno["status"] = "error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 060120211405 | insere_orc_evento_forecast';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($orc_id);
            
            $retorno["status"] = "error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg'] = 'Falha ao fazer inserir registro. Erro: 060120211422 - ' . 'insere_orc_evento_forecast';
        }

        saida:

        ($retorno['status'] == 'error') ? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcEventosSP($orc_id){
        $value  = 'Falha ao inserir Orçamento! Erro: 231120200840';
        DB::beginTransaction();
        $usuario_id = $this->fillCriadoPor();
        try {

            $sql="EXEC insere_orc_evento :orc_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            
            if(!$stmt->execute()){

                $retorno["status"] = "error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 231120200842 | insere_orc_evento';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($orc_id);

            $retorno["status"] = "error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg'] = 'Falha ao fazer inserir registro. Erro: 231120200841 - ' . 'insere_orc_evento';
        }

        saida:

        ($retorno['status'] == 'error') ? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function populaBeneficio($orc_id, $result){

        if(!$this->insertCalcBeneficioProcedure($orc_id)){
            $result = false;
        }
        if(!$this->insert_orc_beneficio_funcionario($orc_id)){
            $result = false;
        }

        if(!$this->insertOrcBeneficioCargoSP($orc_id)){
            $result = false;
        }

        // if(!$this->insertOrcBeneficioCargoSPCalculo($orc_id)){
        //     $result = false;
        // }

        // if(!$this->insertOrcBeneficioCargoSPIndice($orc_id)){
        //     $result = false;
        // }

        return $result;
    }

    public function insertUpcalcOrcCargoAreaSal($entities, $orc_id, $periodo = null, $tipo_table = 'O'){
        
        $tb_alias_a = $this->getTableAlias('a',$entities['funcionario']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b',$entities['orcCargo']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['orcLotacao']['instance'])['table'];
        $tb_alias_d = $this->getTableAlias('d',$entities['CargoLotacao']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['funcionario']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['orcCargo']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['orcLotacao']['instance'])['alias'];
        $alias_table_d = $this->getTableAlias('d',$entities['CargoLotacao']['instance'])['alias'];

        $condicao = $tipo_table == 'F' ? " and {$alias_table_b}.periodo = '{$periodo}' and {$alias_table_b}.tipo_table = '{$tipo_table}' and {$alias_table_c}.periodo = '{$periodo}' and {$alias_table_c}.tipo_table = '{$tipo_table}'" : " and {$alias_table_b}.tipo_table = '{$tipo_table}' and {$alias_table_c}.tipo_table = '{$tipo_table}' ";
        // $condicao2 = $tipo_table == 'F' ? " and oca.tipo_table = '{$tipo_table}' and oca.periodo = '{$periodo}' " : " and oca.tipo_table = '{$tipo_table}' and oca.periodo is null";
        $colunas = "";
        
        if(strlen($periodo) == 0){
            $colunas = "
                {$orc_id} orcamento_id,
                {$alias_table_b}.id cargo_id,
                {$alias_table_c}.id lotacao_id,
                null parametros_formula,
                --avg({$alias_table_a}.salario) sal_base,
                CASE (select count(*) from tbl_funcionario where lotacao_id = {$alias_table_c}.lotacao_id and cargo_id = {$alias_table_b}.cargo_id and dat_demis_func is null)
                    when 0 then
                        (select salario from tbl_cargo where id = {$alias_table_b}.cargo_id)
                    else
                        (select avg(func.salario) from tbl_funcionario as func
                            inner join tbl_orc_cargo as oca on oca.cargo_id = func.cargo_id and oca.orcamento_id = $orc_id
                            inner join tbl_orc_lotacao as ola on ola.lotacao_id = func.lotacao_id and ola.orcamento_id = $orc_id
                            where oca.id = {$alias_table_b}.id and ola.id = {$alias_table_c}.id
                            and func.dat_demis_func is null
                        ) end as sal_base,
                max({$alias_table_b}.sal_max) sal_maior,
                --avg({$alias_table_a}.salario) sal_med,
                CASE (select count(*) from tbl_funcionario where lotacao_id = {$alias_table_c}.lotacao_id and cargo_id = {$alias_table_b}.cargo_id and dat_demis_func is null)
                    when 0 then
                        (select salario from tbl_cargo where id = {$alias_table_b}.cargo_id)
                    else
                        (select avg(func.salario) from tbl_funcionario as func
                            inner join tbl_orc_cargo as oca on oca.cargo_id = func.cargo_id and oca.orcamento_id = $orc_id
                            inner join tbl_orc_lotacao as ola on ola.lotacao_id = func.lotacao_id and ola.orcamento_id = $orc_id
                            where oca.id = {$alias_table_b}.id and ola.id = {$alias_table_c}.id
                            and func.dat_demis_func is null
                ) end as sal_med,

                min({$alias_table_b}.sal_min) sal_menor,
                {$alias_table_a}.empresa_id,
                {$alias_table_a}.ccusto_id,
                '{$tipo_table}' as tipo_table,
                null as periodo,
                ISNULL({$alias_table_d}.periculosidade, 0) as periculosidade,
                ISNULL({$alias_table_d}.insalubridade, 0) as insalubridade
            ";
        }
        else{
            $colunas = "
                {$orc_id} orcamento_id,
                {$alias_table_b}.id cargo_id,
                {$alias_table_c}.id lotacao_id,
                null parametros_formula,
                --avg({$alias_table_a}.salario) sal_base,
                CASE (select count(*) from tbl_funcionario where lotacao_id = {$alias_table_c}.lotacao_id and cargo_id = {$alias_table_b}.cargo_id and dat_demis_func is null)
                    when 0 then
                        (select salario_min from tbl_cargo where id = {$alias_table_b}.cargo_id)
                    else
                        (select avg(func.salario) from tbl_funcionario as func
                            inner join tbl_orc_cargo as oca on oca.cargo_id = func.cargo_id and oca.orcamento_id = $orc_id
                            inner join tbl_orc_lotacao as ola on ola.lotacao_id = func.lotacao_id and ola.orcamento_id = $orc_id
                            where oca.id = {$alias_table_b}.id and ola.id = {$alias_table_c}.id
                            and func.dat_demis_func is null
                        ) end as sal_base,
                max({$alias_table_b}.sal_max) sal_maior,
                --avg({$alias_table_a}.salario) sal_med,
                CASE (select count(*) from tbl_funcionario where lotacao_id = {$alias_table_c}.lotacao_id and cargo_id = {$alias_table_b}.cargo_id and dat_demis_func is null)
                    when 0 then
                        (select salario_min from tbl_cargo where id = {$alias_table_b}.cargo_id)
                    else
                        (select avg(func.salario) from tbl_funcionario as func
                            inner join tbl_orc_cargo as oca on oca.cargo_id = func.cargo_id and oca.orcamento_id = $orc_id
                            inner join tbl_orc_lotacao as ola on ola.lotacao_id = func.lotacao_id and ola.orcamento_id = $orc_id
                            where oca.id = {$alias_table_b}.id and ola.id = {$alias_table_c}.id
                            and func.dat_demis_func is null
                ) end as sal_med,

                min({$alias_table_b}.sal_min) sal_menor,
                {$alias_table_a}.empresa_id,
                {$alias_table_a}.ccusto_id,
                '{$tipo_table}' as tipo_table,
                '{$periodo}' as periodo,
                ISNULL({$alias_table_d}.periculosidade, 0) as periculosidade,
                ISNULL({$alias_table_d}.insalubridade, 0) as insalubridade
            ";
        }
        
        $tipo_join = " INNER JOIN ";
        $tipo_join2 = " LEFT JOIN ";

        $on_a = " ON {$alias_table_a}.cargo_id = {$alias_table_b}.cargo_id AND {$alias_table_b}.orcamento_id = $orc_id ";

        $on_b = " ON {$alias_table_a}.lotacao_id = {$alias_table_c}.lotacao_id
        AND {$alias_table_a}.ccusto_id = {$alias_table_c}.cc_custo_id AND {$alias_table_c}.orcamento_id = $orc_id ";

        $on_c = " ON {$alias_table_d}.lotacao_id = {$alias_table_a}.lotacao_id
        AND {$alias_table_d}.ccusto_id = {$alias_table_a}.ccusto_id AND {$alias_table_a}.cargo_id = {$alias_table_d}.cargo_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a . $tipo_join . $tb_alias_c . $on_b . $tipo_join2 . $tb_alias_d . $on_c;

        $where = " where {$alias_table_a}.dat_demis_func is null ".$condicao;

        $group_by = " GROUP BY
                        {$alias_table_b}.id,
                        {$alias_table_c}.id,
                        {$alias_table_a}.empresa_id,
                        {$alias_table_a}.ccusto_id,
                        {$alias_table_b}.cargo_id,
                        {$alias_table_c}.lotacao_id,
                        {$alias_table_d}.periculosidade,
                        {$alias_table_d}.insalubridade
                    ";

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where,
            'group_by' => $group_by
        ];

        $select = $this->scriptSelectInsert($param_select_insert);

        
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcCargosAreaSal']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'cargo_id'
            ,'lotacao_id'
            ,'ccusto_id'
            ,'periodo'
            ,'tipo_table'
        ];

        $array_campos_update = [
            'sal_base'
            ,'sal_maior'
            ,'sal_med'
            ,'sal_menor'
            ,'updated_at'
            ,'insalubridade'
            ,'periculosidade'
            ,'updated_by'
        ];

        $array_colunas_insert = [
            'orcamento_id'
			,'cargo_id'
			,'lotacao_id'
			,'parametros_formula'
			,'sal_base'
			,'sal_maior'
			,'sal_med'
			,'sal_menor'
			,'empresa_id'
			,'ccusto_id'
			,'created_at'
            ,'created_by'
            ,'periodo'
            ,'tipo_table'
            ,'insalubridade'
            ,'periculosidade'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];

        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge, true, $tipo_table);
        if($result['status'] == 'error'){
            return $result;
        }

        // $result = $this->updateCargoAreaSalMeses($orc_id);


        return $result;
    }

    public function updateCargoAreaSalMeses($orc_id){

        $query_exec = `UPDATE
                    tbl_orc_cargos_area_sal
                SET
                    tbl_orc_cargos_area_sal.sal_menor = b.sal_min,
                    tbl_orc_cargos_area_sal.sal_maior = b.sal_max
                FROM 
                    tbl_orc_cargos_area_sal a
                    INNER JOIN tbl_orc_cargo b
                        ON b.id = a.cargo_id 
                    WHERE a.orcamento_id = $orc_id

                UPDATE
                    tbl_calc_orcamento
                SET
                    tbl_calc_orcamento.jan_orcado = b.sal_med,
                    tbl_calc_orcamento.fev_orcado = b.sal_med,
                    tbl_calc_orcamento.mar_orcado = b.sal_med,
                    tbl_calc_orcamento.abr_orcado = b.sal_med,
                    tbl_calc_orcamento.mai_orcado = b.sal_med,
                    tbl_calc_orcamento.jun_orcado = b.sal_med,
                    tbl_calc_orcamento.jul_orcado = b.sal_med,
                    tbl_calc_orcamento.ago_orcado = b.sal_med,
                    tbl_calc_orcamento.set_orcado = b.sal_med,
                    tbl_calc_orcamento.out_orcado = b.sal_med,
                    tbl_calc_orcamento.nov_orcado = b.sal_med,
                    tbl_calc_orcamento.dez_orcado = b.sal_med
                FROM 
                    tbl_calc_orcamento a
                    INNER JOIN tbl_orc_cargos_area_sal b
                        ON b.id = a.origem_id and a.tbl_origem = 'tbl_orc_cargos_area_sal'
                    WHERE b.orcamento_id = $orc_id`;

        DB::beginTransaction();

        try {

            $pdo = DB::connection()->getPdo();

            $query = $pdo->prepare($query_exec);

            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){

                $retorno["status"]="error";
                $retorno['msg'] = implode(",", $query->errorInfo());
                $retorno['submsg']='Falha ao atualizar registro. Erro: 180820200815';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]="{$count} Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 180820200816';
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 180820200817 - ' .implode(",", $query->errorInfo());
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;
    }

    public function insertUpcalcOrcEventos($entities, $orc_id){

        $tb_alias_a = $this->getTableAlias('a',$entities['eventos']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b',$entities['empresa']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['contaContabilVSEventos']['instance'])['table'];
        $tb_alias_d = $this->getTableAlias('d',$entities['contaContabil']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['eventos']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['empresa']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['contaContabilVSEventos']['instance'])['alias'];
        $alias_table_d = $this->getTableAlias('d',$entities['contaContabil']['instance'])['alias'];

        $colunas = "
                    {$alias_table_a}.empresa_id,
                    {$orc_id} orcamento_id,
                    {$alias_table_a}.id  evento_id,
                    {$alias_table_a}.cdn_event,
                    {$alias_table_a}.des_event,
                    {$alias_table_a}.inc_liquido,
                    {$alias_table_a}.impr_envel,
                    {$alias_table_a}.multiplica,
                    {$alias_table_a}.formula,
                    {$alias_table_a}.ativo,
                    {$alias_table_a}.origem,
                    {$alias_table_a}.tipo_evento_id


        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_a}.empresa_id = {$alias_table_b}.id ";

        $on_b = " ON {$alias_table_c}.empresa_id = {$alias_table_b}.id AND {$alias_table_c}.eventos_id = {$alias_table_a}.id ";

        $on_c = " ON {$alias_table_d}.empresa_id = {$alias_table_b}.id AND {$alias_table_d}.id = {$alias_table_c}.cta_contabil_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a .
                $tipo_join . $tb_alias_c . $on_b .
                $tipo_join . $tb_alias_d . $on_c;

        $where = " where {$alias_table_a}.ativo = 1 ";

        $group_by = " GROUP BY
                        {$alias_table_a}.empresa_id,
                        {$alias_table_a}.id,
                        {$alias_table_a}.cdn_event,
                        {$alias_table_a}.des_event,
                        {$alias_table_a}.inc_liquido,
                        {$alias_table_a}.impr_envel,
                        {$alias_table_a}.multiplica,
                        {$alias_table_a}.formula,
                        {$alias_table_a}.ativo,
                        {$alias_table_a}.origem,
                        {$alias_table_a}.tipo_evento_id

                    ";

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where,
            'group_by' => $group_by
        ];
        $select = $this->scriptSelectInsert($param_select_insert);
        // dd("adasdfasdf--->>>",$select);
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcEventos']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'evento_id'
        ];

        $array_campos_update = [
            'evento_id'
            ,'cdn_event'
            ,'des_event'
            ,'inc_liquido'
            ,'impr_envel'
            ,'multiplica'
            ,'formula'
            ,'ativo'
            ,'origem'
            ,'tipo_evento_id'
            ,'updated_at'
        ];

        $array_colunas_insert = [
            'empresa_id'
            ,'orcamento_id'
            ,'evento_id'
            ,'cdn_event'
            ,'des_event'
            ,'inc_liquido'
            ,'impr_envel'
            ,'multiplica'
            ,'formula'
            ,'ativo'
            ,'origem'
            ,'tipo_evento_id'
			,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
    //    dd($this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id));
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result);
        return $result;
    }

    public function insertUpcalcOrcCargo($entities, $orc_id, $periodo = null, $tipo_table = 'O'){

        $tb_alias_a = $this->getTableAlias('a',$entities['cargo']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['cargo']['instance'])['alias'];

        $colunas = "";
        if($tipo_table == 'O'){
            $colunas = "
            {$orc_id} orcamento_id,
            {$alias_table_a}.id cargo_id,
            salario sal_base,
            salario_max sal_max,
            salario_min sal_min,
            data_salario data_calc,
            null grupo_salarial,
            null periodo,
            '{$tipo_table}' tipo_table
            ";
        }
        else{
            $colunas = "
            {$orc_id} orcamento_id,
            {$alias_table_a}.id cargo_id,
            salario sal_base,
            salario_max sal_max,
            salario_min sal_min,
            data_salario data_calc,
            null grupo_salarial,
            '{$periodo}' periodo,
            '{$tipo_table}' tipo_table
            ";
        }
        

        $from = $tb_alias_a;

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => " where {$alias_table_a}.ativo = 1"
        ];

        $select = $this->scriptSelectInsert($param_select_insert);
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcCargo']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'cargo_id'
            ,'periodo'
            ,'tipo_table'
        ];

        $array_campos_update = [
            'sal_base'
            ,'sal_max'
            ,'sal_min'
            ,'data_calc'
            ,'updated_at'
            ,'updated_by'
        ];

        $array_colunas_insert = [
            'cargo_id',
            'orcamento_id',
            'sal_base',
            'sal_max',
            'sal_min',
            'data_calc',
            'grupo_salarial',
			'created_at',
            'tipo_table',
            'periodo',
            'created_by'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];

        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge, true, $tipo_table);
        // dd("insert_orc------>>>>", $result);
        return $result;
    }

    public function insertUpcalcOrcLotacao($entities, $orc_id){

        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();
        $centro_custo = new CentroCusto();

        $tb_alias_a = $this->getTableAlias('a',$entities['lotacaoCCusto']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b',$entities['lotacao']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['centroCusto']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['lotacaoCCusto']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['lotacao']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['centroCusto']['instance'])['alias'];

        $colunas = "
                    {$orc_id} orcamento_id,
                    {$alias_table_b}.id lotacao_id,
                    1 responder_orc,
                    {$alias_table_c}.id cc_custo_id
        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_a}.lotacao_id = {$alias_table_b}.id AND
                        {$alias_table_a}.empresa_id = {$alias_table_b}.empresa_id ";

        $on_b = " ON {$alias_table_a}.ccusto_id = {$alias_table_c}.id AND
                        {$alias_table_c}.ativo = 1 AND {$alias_table_a}.empresa_id = {$alias_table_c}.empresa_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a
                .$tipo_join . $tb_alias_c . $on_b;

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from
        ];

        $select = $this->scriptSelectInsert($param_select_insert);

        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcLotacao']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'lotacao_id'
            ,'cc_custo_id'
        ];

        $array_campos_update = [
            'responder_orc'
            ,'cc_custo_id'
        ];

        $array_colunas_insert = [
            'orcamento_id'
            ,'lotacao_id'
            ,'responder_orc'
            ,'cc_custo_id'
			,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];

        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result);
        return $result;
    }

    public function scriptInsert($table_entitie, $select, $colunas, $orc_id){
        // sequencia das colunas devem seguir a sequencia da select.
        $table = $table_entitie->getTable();

        $insert = DB::raw("
                INSERT INTO $table (
                    $colunas
                    , created_at
                    , updated_at
                    )
            " . $select);

        DB::beginTransaction();

        try {

            $result = DB::connection()->insert(
                $insert , [$orc_id]
            );

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 30012021510';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir registro. Erro: 30012021515.'.$e);
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function scriptSelectInsert($param_select_insert){
        // sequencia das colunas devem seguir a sequencia do insert.
        $colunas = '';
        $from = '';
        $where = '';
        $group_by = '';
        $order_by = '';

        if(isset($param_select_insert['colunas']) && !is_null($param_select_insert['colunas'])){
            $colunas = $param_select_insert['colunas'];
        }
        if(isset($param_select_insert['from']) && !is_null($param_select_insert['from'])){
            $from = $param_select_insert['from'];
        }
        if(isset($param_select_insert['where']) && !is_null($param_select_insert['where'])){
            $where = $param_select_insert['where'];
        }
        if(isset($param_select_insert['group_by']) && !is_null($param_select_insert['group_by'])){
            $group_by = $param_select_insert['group_by'];
        }
        if(isset($param_select_insert['order_by']) && !is_null($param_select_insert['order_by'])){
            $order_by = $param_select_insert['order_by'];
        }

        $select = "select
                        {$colunas}
                        , getDate() created_at
                        , NULL updated_at
                    FROM
                    {$from}
                    {$where}
                    {$group_by}
                    {$order_by}
            ";
        
        return $select;
    }

    public function scriptMergeInsertUpdate($table_entitie, $select, $array_merge, $tem_periodo = false, $tipo_table = 'O'){
        $table = $table_entitie->getTable();

        $array_on_colunas_chave_ex_primaria = '';
        $array_campos_update = '';
        $array_colunas_insert = '';
        $array_value_insert = '';

        for($i = 0; $i < count($array_merge['array_on_colunas_chave_ex_primaria']); $i++){
            if($array_merge['array_on_colunas_chave_ex_primaria'][$i] == 'periodo' && $tem_periodo === true && $tipo_table == 'O'){
                $and = $i > 0 ? " AND ": "";
                $array_on_colunas_chave_ex_primaria .= $and."target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} is null";
                continue;
            }

            ($i==0) ? $array_on_colunas_chave_ex_primaria .= " target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} " :
                      $array_on_colunas_chave_ex_primaria .= " AND target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                 source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} ";
        }

        for($i = 0; $i < count($array_merge['array_campos_update']); $i++){
            $up = '';
            // ($array_merge['array_campos_update'][$i]=='updated_at') ? $up = "getDate()" : $up = "source.{$array_merge['array_campos_update'][$i]}";
            if ($array_merge['array_campos_update'][$i] == 'updated_at') {
                $up = "getDate()";
            } else if ($array_merge['array_campos_update'][$i] == 'updated_by') {
                $up = "{$this->fillCriadoPor()}";
            } else {
                $up = "source.{$array_merge['array_campos_update'][$i]}";
            }
            
            ($i==0) ? $array_campos_update .= " target.{$array_merge['array_campos_update'][$i]}=
                                                source.{$array_merge['array_campos_update'][$i]} " :
                      $array_campos_update .= " , target.{$array_merge['array_campos_update'][$i]}=
                                                    {$up} ";
        }

        for($i = 0; $i < count($array_merge['array_colunas_insert']); $i++){
            ($i==0) ? $array_colunas_insert .= " {$array_merge['array_colunas_insert'][$i]} " :
                      $array_colunas_insert .= ", {$array_merge['array_colunas_insert'][$i]} ";

            // ($i==0) ? $array_value_insert .= " source.{$array_merge['array_colunas_insert'][$i]} " :
            //           $array_value_insert .= ", source.{$array_merge['array_colunas_insert'][$i]} ";

            if($i == 0){
                $array_value_insert .= " source.{$array_merge['array_colunas_insert'][$i]} ";
            }
            else{
                if($array_merge['array_colunas_insert'][$i] == "created_by"){
                    $array_value_insert .= ", {$this->fillCriadoPor()} ";
                }
                else if($array_merge['array_colunas_insert'][$i] == "created_at"){
                    $array_value_insert .= ", GETDATE() ";
                }
                else{
                    $array_value_insert .= ", source.{$array_merge['array_colunas_insert'][$i]} ";
                }
                
            }
        }

        $merge = "
        MERGE {$table} as target
                USING
                (
                    {$select}
                ) AS source
                ON
                    {$array_on_colunas_chave_ex_primaria}
                WHEN MATCHED
                    THEN UPDATE SET
                        {$array_campos_update}
                WHEN NOT MATCHED BY target
                    THEN
                        INSERT (
                            {$array_colunas_insert}
                            )values(
                            {$array_value_insert}
                            )
            ;
        ";
        
        
        DB::beginTransaction();
        // if($table == 'tbl_orc_eventos'){
        //     dd('parou onde a gente quer', $merge);
        // }
        try {

            $pdo = DB::connection()->getPdo();

            $query = $pdo->prepare($merge);
            if ($query->execute()) {
                $count = $query->rowCount();
            }

            if(!$query){

                $retorno["status"]="error";
                $retorno['msg'] = implode(",", $query->errorInfo());
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310120201126';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]="{$count} Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 310120201122';
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 310120201123 - ' .implode(",", $query->errorInfo());
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();

        return $retorno;

    }

    public function insertCalcOrcamentoCargo($entitie, $orc_id, $periodo = null, $tipo_table = 'O'){

        $tb_alias_a = $this->getTableAlias('a', $entitie['orcCargo']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a', $entitie['orcCargo']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['alias'];

        $condicao = $tipo_table != 'F' ? " and {$alias_table_a}.periodo is null and {$alias_table_a}.tipo_table = '{$tipo_table}'" : " and {$alias_table_a}.periodo = '{$periodo}' and {$alias_table_a}.tipo_table = '{$tipo_table}'";

        $colunas = "
                    {$alias_table_a}.id origem_id
                    ,'tbl_orc_cargo' [tbl_origem]
                    ,{$alias_table_a}.sal_base [jan_orcado]
                    ,{$alias_table_a}.sal_base [fev_orcado]
                    ,{$alias_table_a}.sal_base [mar_orcado]
                    ,{$alias_table_a}.sal_base [abr_orcado]
                    ,{$alias_table_a}.sal_base [mai_orcado]
                    ,{$alias_table_a}.sal_base [jun_orcado]
                    ,{$alias_table_a}.sal_base [jul_orcado]
                    ,{$alias_table_a}.sal_base [ago_orcado]
                    ,{$alias_table_a}.sal_base [set_orcado]
                    ,{$alias_table_a}.sal_base [out_orcado]
                    ,{$alias_table_a}.sal_base [nov_orcado]
                    ,{$alias_table_a}.sal_base [dez_orcado]
                    ,NULL [user_id]
                    ,{$alias_table_a}.[empresa_id]

        ";

        $tipo_join = " LEFT JOIN ";

        $on_a = " ON {$alias_table_a}.id = {$alias_table_b}.origem_id AND 'tbl_orc_cargo' = {$alias_table_b}.tbl_origem ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a ;

        // $where = " where {$alias_table_a}.orcamento_id = $orc_id AND {$alias_table_b}.id is null";
        $where = " where {$alias_table_a}.orcamento_id = $orc_id ";

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);

        $table_entitie = $entitie['calcOrcamento']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'origem_id'
            ,'tbl_origem'
        ];

        $array_campos_update = [
            'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'updated_at'
            ,'updated_by'
        ];

        $array_colunas_insert = [
            'origem_id'
            ,'tbl_origem'
            ,'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'user_id'
            ,'empresa_id'
            ,'created_at'
            ,'created_by'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];

        

        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result);

        return $result;
    }

    public function insertCalcOrcamentoCargoAreaSal($entitie, $orc_id, $periodo = null, $tipo_table = 'O'){

        $tb_alias_a = $this->getTableAlias('a', $entitie['orcCargosAreaSal']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a', $entitie['orcCargosAreaSal']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['alias'];

        $condicao = $tipo_table != 'F' ? " and {$alias_table_a}.periodo is null and {$alias_table_a}.tipo_table = '{$tipo_table}'" : " and {$alias_table_a}.periodo = '{$periodo}' and {$alias_table_a}.tipo_table = '{$tipo_table}'";

        $colunas = "
                    {$alias_table_a}.id origem_id
                    ,'tbl_orc_cargos_area_sal' [tbl_origem]
                    ,{$alias_table_a}.sal_med [jan_orcado]
                    ,{$alias_table_a}.sal_med [fev_orcado]
                    ,{$alias_table_a}.sal_med [mar_orcado]
                    ,{$alias_table_a}.sal_med [abr_orcado]
                    ,{$alias_table_a}.sal_med [mai_orcado]
                    ,{$alias_table_a}.sal_med [jun_orcado]
                    ,{$alias_table_a}.sal_med [jul_orcado]
                    ,{$alias_table_a}.sal_med [ago_orcado]
                    ,{$alias_table_a}.sal_med [set_orcado]
                    ,{$alias_table_a}.sal_med [out_orcado]
                    ,{$alias_table_a}.sal_med [nov_orcado]
                    ,{$alias_table_a}.sal_med [dez_orcado]
                    ,NULL [user_id]
                    ,{$alias_table_a}.[empresa_id]

        ";

        $tipo_join = " LEFT JOIN ";

        $on_a = " ON {$alias_table_a}.id = {$alias_table_b}.origem_id AND 'tbl_orc_cargos_area_sal' = {$alias_table_b}.tbl_origem ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a ;

        $where = " where {$alias_table_a}.orcamento_id = $orc_id ".$condicao;
        // AND {$alias_table_b}.id is null
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where
        ];

        $select = $this->scriptSelectInsert($param_select_insert);

        $table_entitie = $entitie['calcOrcamento']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'origem_id'
            ,'tbl_origem'
        ];

        $array_campos_update = [
            'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'updated_at'
            ,'updated_by'
        ];

        $array_colunas_insert = [
            'origem_id'
            ,'tbl_origem'
            ,'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'user_id'
            ,'empresa_id'
            ,'created_at'
            ,'created_by'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result);

        return $result;
    }

    public function scriptMergeOrcLotacao($orc_id, $responder_orc){
        $value  = 'Falha ao inserir Orçamento! Erro: 210220201518';
        $tipo_table = 'O';
        $periodo = null;
        DB::beginTransaction();

        try {
            $user_id = $this->fillCriadoPor();
            $sql="EXEC insert_merge_lotacao :orc_id, :responder_orc, :tipo_table, :periodo, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':responder_orc', $responder_orc, \PDO::PARAM_INT );

            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $user_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){

                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 210220201520 | insert_merge_lotacao';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($orc_id);

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 210220201515 - ' . 'insert_merge_lotacao';
        }

        saida:

        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function scriptMergeOrcLotacaoForecast($orc_id, $responder_orc, $periodo, $tipo_table){
        $value  = 'Falha ao atualizar Lotações! Erro: 260120211529';
        DB::beginTransaction();
        $usuario_id = $this->fillCriadoPor();

        try {

            $sql="EXEC insert_merge_lotacao :orc_id, :responder_orc, :tipo_table, :periodo, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':responder_orc', $responder_orc, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){

                $retorno["status"] = "error";
                $retorno['msg'] = $value;
                $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 260120211530 | insert_merge_lotacao';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($orc_id);

            $retorno["status"] = "error";
            $retorno['msg'] = $value;
            $retorno['submsg'] = 'Falha ao fazer inserir registro. Erro: 260120211531 - ' . 'insert_merge_lotacao';
        }

        saida:

        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function scriptInsertOrcHeadCount($orc_id){
        $value  = 'Falha ao inserir registros na tela Headcount! Erro: 22022021330';
        $user = $this->getUserFromCurrentGuard();
        $empresa_id = $user->id_empresa;
        $user_id = $user->id;

        set_time_limit(1200);

        DB::beginTransaction();

        try {
            $sql="EXEC popula_orc_headcount :orc_id, :p_empresa_id, :p_user_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_empresa_id', $empresa_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_user_id', $user_id, \PDO::PARAM_INT );

            if(!$result = $stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 22022021330 | popula_orc_headcount - '.$result;
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $e;
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060120211437 - ' . 'popula_orc_headcount - '.$e;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function scriptInsertOrcFuncionario($orc_id){
        $value  = 'Falha ao inserir registros na tabela orc_funcionarios! Erro: 271120201054';
        $user = $this->getUserFromCurrentGuard();
        $empresa_id = $user->id_empresa;
        $user_id = $user->id;

        DB::beginTransaction();

        try {
            // $sql="EXEC insert_orc_funcionario :orc_id, :user_id";
            $sql="EXEC sp_atualiza_orc_funcionario :id_orc, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $user_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':user_id', $user_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 271120201054 | sp_atualiza_orc_funcionario';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $e->getMessage();
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060120211436 - ' . 'sp_atualiza_orc_funcionario';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function scriptInsertHoraExtra($orc_id, $user){
        $value  = 'Falha ao inserir registros na tela Headcount Hora Extra! Erro: 280220201100';
        $user = $this->fillCriadoPor();
        DB::beginTransaction();

        try {

            $sql="EXEC insert_hora_extra :orc_id, :user";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user', $user, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 280220201100 | insert_hora_extra';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 280220201057 - ' . 'insert_hora_extra';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertCalcOrcamentoEventos($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros na tela Controle Eventos! Erro: 060320201620';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        if($tipo_table == 'F'){
            try {
                
                $sql="EXEC insert_calc_orcamento_x_orc_eventos_forecast :orc_id, :tipo_table, :periodo, :usuario_id";
    
                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
    
                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 060120211408 | insert_calc_orcamento_x_orc_eventos_forecast';
                    goto saida;
                }
    
                $retorno["status"]="success";
                $retorno["msg"]=" Registros atualizado com sucesso!";
    
            } catch (\Exception $e) {
                DB::rollBack();
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060120211408ct - ' . 'insert_calc_orcamento_x_orc_eventos_forecast';
            }
        }
        else{
            try {

                $sql="EXEC insert_calc_orcamento_x_orc_eventos :orc_id, :usuario_id";
    
                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
    
                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 060320201620 | insert_calc_orcamento_x_orc_eventos';
                    goto saida;
                }
    
                $retorno["status"]="success";
                $retorno["msg"]=" Registros atualizado com sucesso!";
    
            } catch (\Exception $e) {
                DB::rollBack();
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060320201620 - ' . 'insert_calc_orcamento_x_orc_eventos';
            }
        }
        
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcTurma($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros na tela Turma/turno! Erro: 160320201404';
        $usuario_id = $this->fillModificadoPor();

        DB::beginTransaction();

        try {

            $params = ", :tipo_table, :periodo, :usuario_id"; // $tipo_table == 'O' ? ", :usuario_id" : 
            $sql = "EXEC popula_orc_turma :orc_id".$params;

            $stmt = DB::getPdo()->prepare($sql);
            
            if($tipo_table == 'F'){
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            }
            else{
                $periodo = null;
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_NULL );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            }
            

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 160320201404 | popula_orc_turma_'.$tipo_table;
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060320201620 - ' . 'insert_calc_orcamento_x_orc_eventos - '.$tipo_table;
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcParametros($orc_id){
        $parametrosOrc = CadastroParametros::where('tipo_parametro', 1)->get();
        $hasErro = false;
        $retorno = null;
        DB::transaction(function()use($parametrosOrc, $orc_id, &$hasErro, &$retorno) {
            foreach ($parametrosOrc as $param) {
                $result = OrcParametros::insert([
                    'parametro_id'=>$param->id,
                    'orcamento_id'=>$orc_id,
                    'valor_parametro'=>$param->valor_default,
                    'created_at'=>$this->fillCriadoEm(),
                    'created_by'=>$this->fillCriadoPor()
                ]);
                if(!$result){
                    $hasErro = true;
                    $retorno["status"]="error";
                    $retorno['msg'] = OrcParametros::getErrosFlatted();
                    $retorno['submsg']='Falha ao fazer inserir registro. Erro: 270320201020';
                    abort(500,'Falha ao inserir registro. Erro: 270320201027.');

                }
            }
        });

        if($hasErro){
            return $retorno;
        }
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        return $retorno;

    }

    public function getTableAlias($alias, $entitie){
        $alias_table = $entitie->getTable().'_'.$alias;
        $tb_alias = $entitie->getTable();
        $tb_alias = $tb_alias . " AS {$alias_table}";

        $result = [
            'alias' => $alias_table,
            'table' => $tb_alias
        ];
        return $result;
    }

    public function colEntitie($entitie, $campos_remover){
        $result = implode(',', array_diff($entitie->getNomeColunas(), $campos_remover));

        return $result;
    }

    public function colEntitieSelectDiff($entitie, $campos_remover){
        $result = array_diff($entitie->getNomeColunas(), $campos_remover);

        return $result;
    }

    public function deleteOrcamento($orc_id){
        $Orcamento = new Orcamento();

        DB::beginTransaction();

        try{
            // FOI COMENTADO PORQUE TEM LUGARES QUE CHAMAM ESSE MÉTODO, MAS ACHO QUE NÃO DEVERIA CHAMAR - MATHEUS 02/02/2021 10:16
            // if(!$Orcamento->deleteParent($data['id'])){
            //     $this->setError('Falha ao deletar o Orçamento. Erro: 030320201105 ' .$this->getErrosFlatted());
            //     DB::rollBack();
            //     return false;
            // }

            DB::commit();

            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao deletar o Orçamento. Erro: 080120201624.'.$ex);
        }

        return array('msg'=>"Orçamento deletado!",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function insertBeneficioBefore($entities, $orc_id){

        $tb_alias_a = $this->getTableAlias('a',$entities['eventos']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b',$entities['orc_beneficio']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['empresa']['instance'])['table'];
        $tb_alias_d = $this->getTableAlias('d',$entities['beneficio']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['eventos']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['orc_beneficio']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['empresa']['instance'])['alias'];
        $alias_table_d = $this->getTableAlias('d',$entities['beneficio']['instance'])['alias'];

        $colunas = "
                    {$alias_table_b}.empresa_id,
                    {$orc_id} orcamento_id,

                    {$alias_table_b} evento_id,
                    {$alias_table_b} beneficio_id,
                    {$alias_table_b} tipo_calc,
                    {$alias_table_b} vlr_movto,
                    {$alias_table_b} formula

        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_b}.empresa_id = {$alias_table_c}.id ";

        $on_b = " ON {$alias_table_b}.evento_id = {$alias_table_a}.id ";

        $on_c = " ON {$alias_table_b}.beneficio_id = {$alias_table_d}.id ";

        $from = $tb_alias_d . $tipo_join . //$tb_alias_c . $on_a .
                $tipo_join . $tb_alias_a . $on_b .
                $tipo_join . $tb_alias_d . $on_c;

        // $where = " where {$alias_table_a}.ativo = 1 ";

        // $group_by = " GROUP BY
        //                 {$alias_table_a}.empresa_id,
        //                 {$alias_table_a}.id,
        //                 {$alias_table_a}.cdn_event,
        //                 {$alias_table_a}.des_event,
        //                 {$alias_table_a}.inc_liquido,
        //                 {$alias_table_a}.impr_envel,
        //                 {$alias_table_a}.multiplica,
        //                 {$alias_table_a}.formula,
        //                 {$alias_table_a}.ativo,
        //                 {$alias_table_a}.origem,
        //                 {$alias_table_a}.tipo_evento_id

        //             ";

        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            //'where' => $where,
            //'group_by' => $group_by
        ];

        $select = $this->scriptSelectInsert($param_select_insert);
        //dd("adasdfasdf--->>>",$select);
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcEventos']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'beneficio_id'
        ];

        $array_campos_update = [
            'evento_id',
            'orcamento_id',
            'beneficio_id',
            'tipo_calc',
            'vlr_movto',
            'formula'
            //ver se precisa colocar updated_at
        ];

        $array_colunas_insert = [
            'empresa_id',
            'evento_id',
            'orcamento_id',
            'beneficio_id',
            'tipo_calc',
            'vlr_movto',
            'formula'
            //ver se precisa colocar o campo created_at
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];

        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result);
        return $result;
    }
    public function insertCalcBeneficio($orc_id){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 050520201656';

        DB::beginTransaction();

        try {

            $sql="EXEC insert_beneficio_x_orc_beneficio :orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 050520201654 | insert_beneficio_x_orc_beneficio';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 050520201657 - ' . 'insert_beneficio_x_orc_beneficio';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertCalcBeneficioProcedure($orc_id){
        $beneficio = new Beneficio();

        $select = $beneficio->where('ativo', 1)->get();

        if(count($select)>0){
            for($i = 0; $i < count($select); $i++){
                if(( $orc_id == null ) || ($select[$i]['id'] == null) || ($select[$i]['evento_id'] == null) ){
                    $retorno["status"]="error";
                    $retorno['msg'] = 'Dados inválidos';
                    $retorno['submsg']='Falha ao inserir beneficios. Erro: 070520201146';
                    goto saida;
                }
                $insert = $this->insertOrcBeneficioGo($select[$i], $orc_id);
                if(!$insert){
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir beneficios. Erro: 060520201421';
                    goto saida;
                }
            }
        }
        else{
            $retorno["status"]="error";
            $retorno['msg'] = 'Sem registros para inserir';
            $retorno['submsg']='Falha ao inserir beneficios. Erro: 070520200905';
            goto saida;
        }
        $retorno["status"]="success";
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }
    public function insertOrcBeneficioGo($dados, $orc_id){

        $calc_orcamento = new CalcOrcamento();
        $tbl_orc_beneficio = new OrcBeneficio();
        $tbl_calc_indice = new CalcIndice();

        $select = $tbl_orc_beneficio->select()
        ->where([
            [$tbl_orc_beneficio->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_orc_beneficio->getColunaAlias('beneficio_id'),'=',$dados['id']],
            [$tbl_orc_beneficio->getColunaAlias('evento_id'),'=',$dados['evento_id']]
        ])
        ->get()->toArray();

        if(count($select)>0){
            $this->setError('registro já existente.');
            return false;
        }
            DB::beginTransaction();

            try{
                //orcamento_id( $orc_id ), empresa_id( 1 ), beneficio_id( id ), evento_id, tipo_calc, vlr_movto, formula
                $dados_beneficio = array(
                    "orcamento_id" => $orc_id,
                    "empresa_id" => $dados['empresa_id'], //vem pelo bearerToken
                    "beneficio_id" => $dados['id'],
                    "evento_id" => $dados['evento_id'],
                    "tipo_calc" => $dados['tipo_calc'],
                    "vlr_movto" => ($dados['tipo_calc'] == 2) ? $dados['multiplica'] : $dados['vlr_movto'],
                    "vlr_maximo" => ($dados['tipo_calc'] == 2) ? $dados['vlr_maximo'] : 0,
                    "cta_ctb_id" => $dados['cta_ct_id'],
                    'salario_corte' => $dados['salario_corte'],
                    'tipo_acesso' => $dados['tipo_acesso'],
                    "formula" => $dados['formula'],
                    "exclusivo_admissao" => $dados['exclusivo_admissao'],
                    'tipo_table' =>'O',
                    'created_at' => $this->fillCriadoEm(),
                    'created_by' => $this->fillCriadoPor()
                );


                $inserir_beneficio = $tbl_orc_beneficio->create($dados_beneficio);

                if(!$inserir_beneficio){
                    $this->setError('Falha ao cadastrar beneficio. erro: 060520201418');
                    return false;
                }
                $indice = 1;
                $dados_calc_orcamento = array(
                    "origem_id" => $inserir_beneficio->id,
                    "tbl_origem" => "tbl_orc_beneficio",

                    "jan_indice" => $indice,
                    "fev_indice" => $indice,
                    "marc_indice" => $indice,
                    "abril_indice" => $indice,
                    "maio_indice" => $indice,
                    "jun_indice" => $indice,
                    "jul_indice" => $indice,
                    "agost_indice" => $indice,
                    "set_indice" => $indice,
                    "out_indice" => $indice,
                    "nov_indice" => $indice,
                    "dez_indice" => $indice,
                    "created_at" => $this->fillCriadoEm(),
                    "created_by" => $this->fillCriadoPor()
                );
                $inserir_indice = $tbl_calc_indice->create($dados_calc_orcamento);
                if(!$inserir_indice){
                    $this->setError('Falha ao cadastrar indice. erro: 220620201544');
                    return false;
                }
                $campo_valor = ($dados['tipo_calc'] == 2) ? 'multiplica' : 'vlr_movto';

                $dados_calc_orcamento = array(
                    "origem_id" => $inserir_beneficio->id,
                    "tbl_origem" => "tbl_orc_beneficio",

                    "jan_orcado" => $dados[$campo_valor],
                    "fev_orcado" => $dados[$campo_valor],
                    "mar_orcado" => $dados[$campo_valor],
                    "abr_orcado" => $dados[$campo_valor],

                    "mai_orcado" => $dados[$campo_valor],
                    "jun_orcado" => $dados[$campo_valor],
                    "jul_orcado" => $dados[$campo_valor],
                    "ago_orcado" => $dados[$campo_valor],

                    "set_orcado" => $dados[$campo_valor],
                    "out_orcado" => $dados[$campo_valor],
                    "nov_orcado" => $dados[$campo_valor],
                    "dez_orcado" => $dados[$campo_valor],

                    "created_at" => $this->fillCriadoEm(),
                    "created_by" => $this->fillCriadoPor()
                );


                $inserir_calc = $calc_orcamento->create($dados_calc_orcamento);

                if(!$inserir_calc){
                    DB::rollBack();
                    $this->setError('Falha ao cadastrar calculo. erro: 060520201418');
                    return false;
                }

                DB::commit();

            }
            catch(Exception $e){
                DB::rollBack();
                abort(500,'Falha ao cadastrar beneficios no orçamento via procedure php. Erro: 060520201358.'.$e);
            }

            return true;

    }

    public function insertCalcBeneficioFuncionarioProcedure($orc_id){
        $beneficio_funcionario = new BeneficioFuncionarioController();

        $select = $beneficio_funcionario->listarToCadAutomaticoc($orc_id);


        if(count($select)>0){
            for($i = 0; $i < count($select); $i++){
                if(( $orc_id == null ) || ($select[$i]['funcionario_id'] == null) || ($select[$i]['ccusto_id'] == null) || ($select[$i]['orc_beneficio_id'] == null) || ($select[$i]['orc_lotacao_id'] == null)){
                    $retorno["status"]="error";
                    $retorno['msg'] = 'Dados inválidos';
                    $retorno['submsg']='Falha ao inserir beneficios por funcionário. Erro: 070520201158';
                    goto saida;
                }
                $insert = $this->insertOrcBeneficioFuncionarioGo($select[$i], $orc_id);
                if(!$insert){

                    $retorno["status"]="error";
                    $retorno['msg'] = 'Falha ao inserir registro'.($i+1);
                    $retorno['submsg']='Falha ao inserir beneficios. Erro: 070520200855';
                    goto saida;
                }
            }
        }
        else{

            $retorno["status"]="error";
            $retorno['msg'] = 'Sem registros para inserir.';
            $retorno['submsg']='Sem registros para inserir. Erro: 070520200903';
        }
        $retorno["status"]="success";
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioFuncionarioGo($dados, $orc_id){
        $calc_orcamento = new CalcOrcamento();
        $tbl_orc_beneficio_funcionario = new OrcLotFuncionatioBeneficio();

        $select = $tbl_orc_beneficio_funcionario->select()
        ->where([
            [$tbl_orc_beneficio_funcionario->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_orc_beneficio_funcionario->getColunaAlias('funcionario_id'),'=',$dados['funcionario_id']],
            [$tbl_orc_beneficio_funcionario->getColunaAlias('ccusto_id'),'=',$dados['ccusto_id']],
            [$tbl_orc_beneficio_funcionario->getColunaAlias('orc_beneficio_id'),'=',$dados['orc_beneficio_id']],
            [$tbl_orc_beneficio_funcionario->getColunaAlias('orc_lotacao_id'),'=',$dados['orc_lotacao_id']],
        ])
        ->get()->toArray();

        if(count($select)>0){
            $this->setError('registro já existente.');
            return false;
        }
            DB::beginTransaction();

            try{
                if($dados['ativo'] == '1'){
                    if($dados['tipo_calc'] == 2){
                        $dados_beneficio_funcionario = array(
                            "orcamento_id" => $orc_id,
                            "funcionario_id" => $dados['funcionario_id'],
                            "orc_lotacao_id" => $dados['orc_lotacao_id'],
                            "ccusto_id" => $dados['ccusto_id'],
                            "orc_beneficio_id" => $dados['orc_beneficio_id'],
                            "empresa_id" => $dados['empresa_id'],
                            "tipo_calc" => $dados['tipo_calc'],
                            "vlr_movto" => $dados['multiplica'],
                            "vlr_maximo" => $dados['vlr_maximo'],
                            "cta_ctb_id" => $dados['cta_ct_id'],
                            "formula" => $dados['formula']
                        );
                    }else{
                        $dados_beneficio_funcionario = array(
                            "orcamento_id" => $orc_id,
                            "funcionario_id" => $dados['funcionario_id'],
                            "orc_lotacao_id" => $dados['orc_lotacao_id'],
                            "ccusto_id" => $dados['ccusto_id'],
                            "orc_beneficio_id" => $dados['orc_beneficio_id'],
                            "empresa_id" => $dados['empresa_id'],
                            "tipo_calc" => $dados['tipo_calc'],
                            "vlr_movto" => $dados['vlr_movto'],
                            //"vlr_maximo" => '',
                            "cta_ctb_id" => $dados['cta_ct_id'],
                            "formula" => $dados['formula']
                        );
                    }


                    $inserir_beneficio_funcionario = $tbl_orc_beneficio_funcionario->create($dados_beneficio_funcionario);

                    if(!$inserir_beneficio_funcionario){
                        $this->setError('Falha ao cadastrar beneficio. erro: 070520200900');
                        return false;
                    }
                    if($dados['tipo_calc'] == 2){
                        $dados_calc_orcamento = array(
                            "origem_id" => $inserir_beneficio_funcionario->id,
                            "tbl_origem" => "tbl_orc_beneficio_funcionario",

                            "jan_orcado" => $dados['multiplica'],
                            "fev_orcado" => $dados['multiplica'],
                            "mar_orcado" => $dados['multiplica'],
                            "abr_orcado" => $dados['multiplica'],

                            "mai_orcado" => $dados['multiplica'],
                            "jun_orcado" => $dados['multiplica'],
                            "jul_orcado" => $dados['multiplica'],
                            "ago_orcado" => $dados['multiplica'],

                            "set_orcado" => $dados['multiplica'],
                            "out_orcado" => $dados['multiplica'],
                            "nov_orcado" => $dados['multiplica'],
                            "dez_orcado" => $dados['multiplica'],
                        );
                    }else{
                        $dados_calc_orcamento = array(
                            "origem_id" => $inserir_beneficio_funcionario->id,
                            "tbl_origem" => "tbl_orc_beneficio_funcionario",

                            "jan_orcado" => $dados['vlr_movto'],
                            "fev_orcado" => $dados['vlr_movto'],
                            "mar_orcado" => $dados['vlr_movto'],
                            "abr_orcado" => $dados['vlr_movto'],

                            "mai_orcado" => $dados['vlr_movto'],
                            "jun_orcado" => $dados['vlr_movto'],
                            "jul_orcado" => $dados['vlr_movto'],
                            "ago_orcado" => $dados['vlr_movto'],

                            "set_orcado" => $dados['vlr_movto'],
                            "out_orcado" => $dados['vlr_movto'],
                            "nov_orcado" => $dados['vlr_movto'],
                            "dez_orcado" => $dados['vlr_movto'],
                        );
                    }


                    $inserir_calc = $calc_orcamento->create($dados_calc_orcamento);
                    if(!$inserir_calc){
                        DB::rollBack();
                        $this->setError('Falha ao cadastrar calculo. erro: 070520200900');
                        return false;
                    }

                    DB::commit();
                }
                else return false;
            }
            catch(Exception $e){
                DB::rollBack();
                abort(500,'Falha ao cadastrar beneficios por funcionario no orçamento via procedure php. Erro: 070520200949.'.$e);
            }

        return true;
    }

    public function insertCalcBeneficioCargoProcedure($orc_id){
        $beneficio_cargo = new BeneficioLotacaoCargoController();
        $cont = 0;
        $select = $beneficio_cargo->listarToCadAutc($orc_id);
        //dd($select);
        if(count($select)>0){
            for($i = 0; $i < count($select); $i++){
                $insert = $this->insertOrcBeneficioCargoGo($select[$i], $orc_id);
                if(!$insert){
                    $cont++;
                }
            }
            // if($cont > 0){
            //     $retorno["status"] = "error";
            //     goto saida;
            // }
        }
        // else{
        //     $retorno["status"] = 'error';
        //     goto saida;
        // }

        // $retorno["status"] = "success";
        return true;

        // saida:
        // ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // return $retorno;
    }

    public function insertOrcBeneficioCargoGo($dados, $orc_id){//parei aqui

        $calc_orcamento = new CalcOrcamento();
        $tbl_orc_beneficio_cargo = new OrcLotCargoBeneficio();
        $calc_indice = new CalcIndice();

        /*$select = $tbl_orc_beneficio_cargo->select()
        ->where([
            [$tbl_orc_beneficio_cargo->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_orc_beneficio_cargo->getColunaAlias('orc_cargo_id'),'=',$dados['orc_cargo_id']],
            [$tbl_orc_beneficio_cargo->getColunaAlias('ccusto_id'),'=',$dados['ccusto_id']],
            [$tbl_orc_beneficio_cargo->getColunaAlias('orc_beneficio_id'),'=',$dados['orc_beneficio_id']],
            [$tbl_orc_beneficio_cargo->getColunaAlias('orc_lotacao_id'),'=',$dados['orc_lotacao_id']],
        ])
        ->get()->toArray();

        if(count($select)>0){
            $this->setError('registro já existente.');
            return false;
        }*/

        DB::beginTransaction();

            try{

                if($dados['ativo'] == '1'){
                    if($dados['tipo_calc'] == 2){
                        $dados_beneficio_cargo = array(
                            "orcamento_id" => $orc_id,
                            "orc_lotacao_id" => $dados['orc_lotacao_id'],
                            "orc_cargo_id" => $dados['orc_cargo_id'],
                            "orc_beneficio_id" => $dados['orc_beneficio_id'],
                            "ccusto_id" => $dados['ccusto_id'],
                            "tipo_calc" => $dados['tipo_calc'],
                            "vlr_movto" => $dados['multiplica'],
                            //"formula" => $dados['formula'],
                            "vlr_maximo" => $dados['vlr_maximo'],
                            "cta_ctb_id" => $dados['cta_ct_id'],
                            "empresa_id" => $dados['empresa_id']
                        );
                    }
                    else{
                        $dados_beneficio_cargo = array(
                            "orcamento_id" => $orc_id,
                            "orc_lotacao_id" => $dados['orc_lotacao_id'],
                            "orc_cargo_id" => $dados['orc_cargo_id'],
                            "orc_beneficio_id" => $dados['orc_beneficio_id'],
                            "ccusto_id" => $dados['ccusto_id'],
                            "tipo_calc" => $dados['tipo_calc'],
                            "vlr_movto" => $dados['vlr_movto'],
                            //"formula" => $dados['formula'],
                            "cta_ctb_id" => $dados['cta_ct_id'],
                            "empresa_id" => $dados['empresa_id']
                        );
                    }
                    $inserir_beneficio_cargo = $tbl_orc_beneficio_cargo->create($dados_beneficio_cargo);

                    if(!$inserir_beneficio_cargo){
                        $this->setError('Falha ao cadastrar benefício por cargo. erro: 070520200947');
                        return false;
                    }
                    $indice = 1;
                    $dados_indice = array(
                        "origem_id" => $inserir_beneficio_cargo->id,
                        "tbl_origem" => $tbl_orc_beneficio_cargo->getTable(),
                        "jan_indice" => $indice,
                        "fev_indice" => $indice,
                        "marc_indice" => $indice,
                        "abril_indice" => $indice,
                        "maio_indice" => $indice,
                        "jun_indice" => $indice,
                        "jul_indice" => $indice,
                        "agost_indice" => $indice,
                        "set_indice" => $indice,
                        "out_indice" => $indice,
                        "nov_indice" => $indice,
                        "dez_indice" => $indice,
                    );
                    $calc_indice->create($dados_indice);

                    if($dados['tipo_calc'] == 2){
                        $dados_calc_orcamento = array(
                            "origem_id" => $inserir_beneficio_cargo->id,
                            "tbl_origem" => "tbl_orc_benef_lot_carg",

                            "jan_orcado" => $dados['multiplica'],
                            "fev_orcado" => $dados['multiplica'],
                            "mar_orcado" => $dados['multiplica'],
                            "abr_orcado" => $dados['multiplica'],
                            "mai_orcado" => $dados['multiplica'],
                            "jun_orcado" => $dados['multiplica'],
                            "jul_orcado" => $dados['multiplica'],
                            "ago_orcado" => $dados['multiplica'],
                            "set_orcado" => $dados['multiplica'],
                            "out_orcado" => $dados['multiplica'],
                            "nov_orcado" => $dados['multiplica'],
                            "dez_orcado" => $dados['multiplica'],
                        );
                    }
                    else{
                        $dados_calc_orcamento = array(
                            "origem_id" => $inserir_beneficio_cargo->id,
                            "tbl_origem" => "tbl_orc_benef_lot_carg",
                            "jan_orcado" => $dados['vlr_movto'],
                            "fev_orcado" => $dados['vlr_movto'],
                            "mar_orcado" => $dados['vlr_movto'],
                            "abr_orcado" => $dados['vlr_movto'],
                            "mai_orcado" => $dados['vlr_movto'],
                            "jun_orcado" => $dados['vlr_movto'],
                            "jul_orcado" => $dados['vlr_movto'],
                            "ago_orcado" => $dados['vlr_movto'],
                            "set_orcado" => $dados['vlr_movto'],
                            "out_orcado" => $dados['vlr_movto'],
                            "nov_orcado" => $dados['vlr_movto'],
                            "dez_orcado" => $dados['vlr_movto'],
                        );
                    }

                    $inserir_calc = $calc_orcamento->create($dados_calc_orcamento);
                    if(!$inserir_calc){
                        DB::rollBack();
                        $this->setError('Falha ao cadastrar calculo. erro: 070520200948');
                        return false;
                    }
                    DB::commit();
                }
                else{
                    return false;
                }
            }
            catch(Exception $e){
                DB::rollBack();
                abort(500,'Falha ao cadastrar beneficios por cargo no orçamento via procedure php. Erro: 070520200949.'.$e);
            }
        return true;
    }

    public function insertOrcBeneficioCargoSP($orc_id){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200937';
        $usuario_id = $this->fillCriadoPor();
        DB::beginTransaction();

        try {

            /*$sql="EXEC insert_orc_beneficio_lotacao_cargo :id_orc";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao inserir registro. Erro: 180620200938 | insert_orc_beneficio_lotacao_cargo';
                goto saida;
            }*/

            $result = DB::statement(DB::raw("
                SET NOCOUNT ON;
                EXEC [dbo].insert_orc_beneficio_lotacao_cargo
                @id_orc = $orc_id, @usuario_id = $usuario_id
            "));
            if($result){
                $retorno["status"] = "success";
                $retorno["msg"] = " Registros inserido com sucesso!";
                DB::commit();
            }
            
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200939 - ' . 'insert_orc_beneficio_lotacao_cargo';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioCargoSPCalculo($orc_id){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200942';

        // DB::beginTransaction();

        try {

            $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc :id_orc";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg'] = 'Falha ao inserir registro. Erro: 180620200943 | insert_orc_beneficio_lotacao_cargo_calc';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros inserido com sucesso!";

        } catch (\Exception $e) {
            // DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200944 - ' . 'insert_orc_beneficio_lotacao_cargo_calc';
        }
        saida:
        // ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioCargoSPIndice($orc_id){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200951';

        // DB::beginTransaction();

        try {

            $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc_ind :id_orc";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg'] = 'Falha ao inserir registro. Erro: 180620200943 | insert_orc_beneficio_lotacao_cargo_calc_ind';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros inserido com sucesso!";
            // DB::commit();

        } catch (\Exception $e) {
            // DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200944 - ' . 'insert_orc_beneficio_lotacao_cargo_calc_ind';
        }
        saida:
        // ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function update_insal_peric_orc_cargos_area_sal($orc_id){
        $value  = 'Falha ao inserir registros na tela Salário! Erro: 080620201528';

        DB::beginTransaction();
        $usuario_id = $this->fillCriadoPor();

        try {

            $sql="EXEC update_insal_peric_orc_cargos_area_sal :orc_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 080620201528 | update_insal_peric_orc_cargos_area_sal';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 080620201528 - ' . 'update_insal_peric_orc_cargos_area_sal';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function insert_orc_beneficio_funcionario($orc_id){
        $value  = 'Falha ao inserir registros na tela Benefício Funcionário! Erro: 080620202051';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC insert_orc_beneficio_funcionario :orc_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 080620202051 | insert_orc_beneficio_funcionario';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 080620202051 - ' . 'insert_orc_beneficio_funcionario';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function update_sal_med_orc_cargos_area_sal($orc_id){
        $value  = 'Falha ao inserir registros na tela Salário! Erro: 080620201603';

        DB::beginTransaction();

        try {
            $usuario_id = $this->fillCriadoPor();
            $sql="EXEC update_sal_med_orc_cargos_area_sal :orc_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 080620201603 | update_sal_med_orc_cargos_area_sal';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 080620201603 - ' . 'update_sal_med_orc_cargos_area_sal';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function insertToOrcParamNatureza($orc_id){
        $natureza_evento = new RepoNaturezaEvento();
        $dados = $natureza_evento->listarToCadAutomatico();
        $cont = 0;
        //dd($dados); 
        for($i = 0; $i < count($dados); $i++){
            if($this->goToInsertOrcParamNatureza($dados[$i],$orc_id)){
                $cont++;//conta os sucessos
            }
        }
        if($cont == count($dados)){
            return true;
        }
        return false;
    }
    public function goToInsertOrcParamNatureza($dados, $orc_id){

        $tbl_param_natureza = new OrcParamNatureza();
        $identificador = 0;

        $is_beneficio = $this->checkIsBeneficio($dados['eventos_id']);

        $form_data = array(
            "hash_id" => tirarAcentos(str_replace(' ','_',$dados['desc_cta_ctbl'])),
            "empresa_id" => $dados['empresa_id'],
            "orcamento_id" => $orc_id,
            'cta_contabil_id' => $dados['cta_contabil_id'],
            'cod_cta_ctbl' => $dados['cod_cta_ctbl'],
            'ordem_execucao' => $dados['sequencia_execucao'],
            'evento_principal_id' => $dados['eventos_id'],
            'handle_sql' => ($is_beneficio) ? 'sp_hnd_outros_beneficios' : 'sp_hnd_'.mb_strtolower(tirarAcentos(str_replace('__','_',str_replace('/','',str_replace(' ','_',str_replace('º','',$dados['desc_cta_ctbl'])))))),
            // 'handle_arguments' => strtolower(str_replace(' ','_',$dados['des_event']))
            // 'handle_sql' => tirarAcentos(str_replace(' ','_',$dados['desc_cta_ctbl'])),
            'handle_arguments' => str_replace(' ','_',$dados['des_event']),
            'base_recisao' => $dados['base_recisao'],
            'created_at' => $this->fillCriadoEm(),
            'created_by' => $this->fillCriadoPor()
        );

        // $select = $tbl_param_natureza->select()
        // ->where([
        //     [$tbl_param_natureza->getColunaAlias('orcamento_id'),$orc_id],
        // ])
        // ->get()->toArray();

        // $maior_sequencia = 0;
        // if(count($select) > 0){
        //     for($i = 0; $i < count($select); $i++){
        //         if($form_data['cta_contabil_id'] == $select[$i]['cta_contabil_id']){
        //             $maior_sequencia = $select[$i]['ordem_execucao'];
        //             $identificador = 1;
        //             break;
        //         }
        //         else{
        //             if($select[$i]['ordem_execucao'] > $maior_sequencia){
        //                 $identificador = 2;
        //                 $maior_sequencia = $select[$i]['ordem_execucao'];
        //             }
        //         }
        //     }
        // }
        // $valor = intval($maior_sequencia,10);
        // if($identificador == 1){
        //     $form_data['ordem_execucao'] = $valor;
        // }else if($identificador == 2){
        //     $form_data['ordem_execucao'] = $valor + 1;
        // }
        // else{
        //     $form_data['ordem_execucao'] = 0;
        // }
        //dd($form_data);
        $insert = $tbl_param_natureza->create($form_data);
        if(!$insert){
            return false;
        }
        return true;

    }

    public function scriptinsertOrcTurmaEvento($orc_id){
        $value  = 'Falha ao inserir registros na tela Turma Evento! Erro: 290620201617';

        DB::beginTransaction();

        try {

            $sql="EXEC insert_orc_turma_evento :orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 290620201617 | insert_orc_turma_evento';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 290620201617 - ' . 'insert_orc_turma_evento';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function checkIsBeneficio($evento_id){
        $repo_beneficio = new Beneficio();
        $qtd = $repo_beneficio->where('evento_id', $evento_id)->get();

        return count($qtd) != 0;
    }
    public function InsereNaturezaEvento($orc_id){
        $natureza_evento = new RepoNaturezaEvento();
        $dados = $natureza_evento->listarToCadAutomatico();
        $cont = 0;

        if(count($dados) > 0){
            for($i = 0; $i < count($dados); $i++){
                if($this->insereNaturezaEventoEnd($dados[$i],$orc_id)){
                    $cont++;
                }
            }
            if($cont == count($dados)){
                return true;
            }
            $this->setError("Falha ao inserir registro.<br>Erro: 1140720200940");
            return false;
        }
    }
    public function insereNaturezaEventoEnd($dados, $orc_id){
        $natureza_evento = new RepoOrcNaturezaEvento();

        $form_data = array(
            'orc_id'=>$orc_id,
            'natureza_has_id'=>tirarAcentos(str_replace(' ','_',$dados['desc_cta_ctbl'])),
            'evento_id'=>$dados['eventos_id'],
            'cdn_event'=>$dados['cdn_event'],
            'multiplica'=>$dados['multiplica'],
            'dt_base_admissao_ini'=>$dados['dt_base_admissao_ini'],
            'dt_base_admissao_fim'=>$dados['dt_base_admissao_fim'],
            'empresa_id'=>$dados['empresa_id'],
            'tipo_table'=>'O',
            'cod_natureza'=>$dados['cod_cta_ctbl'],
            'natureza_id'=>$dados['cta_contabil_id'],
            'created_at'=>$this->fillCriadoEm(),
            'created_by'=>$this->fillCriadoPor()
        );
        $inserir = $natureza_evento->create($form_data);
        if(!$inserir){
            $this->setError("Falha ao inserir registro.<br>Erro: 1140720200940");
            return false;
        }
        else{
            return true;
        }
    }
    public function reiniciarOrcScript($orc_id){
      $value  = 'Falha ao reiniciar o orçamento!';

      DB::beginTransaction();

      try {

          $sql = "EXEC reiniciar_orcamento :id_orc";

          $stmt = DB::getPdo()->prepare($sql);
          $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

          if(!$stmt->execute()){
              $retorno["status"] = "error";
              $retorno['msg'] = $value.' Erro: 240720201407';
              $retorno['submsg'] = 'Falha ao Reiniciar o Orçamento. Erro: 240720201408 | reiniciar_orcamento';
              goto saida;
          }
          $retorno["submsg"] = "Sucesso";
          $retorno["status"] = "success";
          $retorno["msg"] = "Orçamento Reiniciado com sucesso!";

      } catch (\Exception $e) {
          DB::rollBack();
          $retorno["status"] = "error";
          $retorno['msg'] = $value.' Erro: 240720201422';
          $retorno['submsg'] = 'Erro';
      }
      saida:
      ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
      return $retorno;
    }
    public function reabrirOrcamento($orc_id){
        try{
            $update = DB::table('tbl_orc_lot_carg_headcount')
            ->where([
                ['orc_id','=',$orc_id],
                ['tipo_table', '=', 'O']
            ])->update(['orcado_anterior' => 0, 'forecast_total' => 0]);
        } catch (\Exception $e) {
            $this->setError("Falha ao atualizar totais do headcount. Erro 100320210740.");
            return false;
        }        
        return true;
    }

    public function sp_hnd_beneficio_mov_contabil($orc_id, $beneficio){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 310820200901';
        $usuario_id = $this->fillCriadoPor();
        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_beneficio_mov_contabil :p_orcamento_id, :p_beneficio_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_beneficio_id', $beneficio, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310820200901 | sp_hnd_beneficio_mov_contabil';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 310820200901 - ' . 'sp_hnd_beneficio_mov_contabil';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function sp_hnd_atualiza_headcount_ppr($orc_id){
        $value  = 'Falha ao inserir registros na tela PPR! Erro: 090920200856';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_ppr :p_orcamento_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 090920200856 | sp_hnd_atualiza_headcount_ppr';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            dd("rolback", $e);
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 090920200856 - ' . 'sp_hnd_atualiza_headcount_ppr';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function sp_hnd_atualiza_headcount_ppr_forecast($orc_id, $periodo, $tipo_table){
        $value  = 'Falha ao inserir registros na tela PPR! Erro: 260120211553';
        $usuario_id = $this->fillCriadoPor();
        
        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_ppr_forecast :p_orcamento_id, :periodo, :tipo_table, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 260120211555 | sp_hnd_atualiza_headcount_ppr_forecast';
                goto saida;
            }

            $retorno["status"] = "success";
            $retorno["msg"] = "Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            dd("rollback", $e->getMessage());
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $e->getMessage();
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 260120211555ct - ' . 'sp_hnd_atualiza_headcount_ppr_forecast';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function sp_hnd_atualiza_headcount_bonus($orc_id){
        $value  = 'Falha ao inserir registros na tela Bonus! Erro: 090920200855';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_bonus :p_orcamento_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 090920200855 | sp_hnd_atualiza_headcount_bonus';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            dd("rolback", $e);
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 090920200855 - ' . 'sp_hnd_atualiza_headcount_bonus';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    public function sp_hnd_atualiza_headcount_bonus_forecast($orc_id, $periodo, $tipo_table){
        $value  = 'Falha ao inserir registros na tela Bonus! Erro: 260120211602';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_atualiza_headcount_bonus_forecast :p_orcamento_id, :periodo, :tipo_table, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 260120211602b | sp_hnd_atualiza_headcount_bonus_forecast';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            dd("rolback", $e);
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 260120211604 - ' . 'sp_hnd_atualiza_headcount_bonus_forecast';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }
}
